/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.inventory;

import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.inventory.CreateResourceResponse;
import org.rhq.core.clientapi.server.inventory.ResourceFactoryServerService;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceFactoryManager;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.util.exception.ThrowableUtil;

public class CreateResourceRunner
implements Callable,
Runnable {
    private final Log log = LogFactory.getLog(CreateResourceRunner.class);
    private ResourceFactoryManager resourceFactoryManager;
    private int parentResourceId;
    private boolean runRuntimeScan;
    private int requestId;
    private CreateChildResourceFacet facet;
    private CreateResourceReport report;

    public CreateResourceRunner(ResourceFactoryManager resourceFactoryManager, int parentResourceId, CreateChildResourceFacet facet, int requestId, CreateResourceReport report, boolean runRuntimeScan) {
        this.resourceFactoryManager = resourceFactoryManager;
        this.parentResourceId = parentResourceId;
        this.facet = facet;
        this.requestId = requestId;
        this.report = report;
        this.runRuntimeScan = runRuntimeScan;
    }

    public void run() {
        try {
            this.call();
        }
        catch (Exception e) {
            this.log.error((Object)"Error while chaining run to call", (Throwable)e);
        }
    }

    public Object call() throws Exception {
        CreateResourceStatus status;
        String errorMessage;
        this.log.info((Object)("Creating resource through report: " + this.report));
        String resourceName = null;
        String resourceKey = null;
        Configuration configuration = null;
        try {
            Throwable throwable;
            this.report = this.facet.createResource(this.report);
            resourceName = this.report.getResourceName();
            resourceKey = this.report.getResourceKey();
            errorMessage = this.report.getErrorMessage();
            status = this.report.getStatus();
            configuration = this.report.getResourceConfiguration();
            CreateResourceStatus reportedStatus = this.report.getStatus();
            if (reportedStatus == null || reportedStatus == CreateResourceStatus.IN_PROGRESS) {
                this.log.warn((Object)("Plugin did not indicate the result of the request: " + this.requestId));
                errorMessage = "Plugin did not indicate the result of the resource creation attempt.";
                status = CreateResourceStatus.FAILURE;
            }
            if (CreateResourceRunner.isSuccessStatus(reportedStatus) && resourceKey == null) {
                this.log.warn((Object)("Plugin did not indicate the resource key for this request: " + this.requestId));
                errorMessage = "Plugin did not indicate a resource key for this request.";
                status = CreateResourceStatus.FAILURE;
            }
            if (CreateResourceRunner.isSuccessStatus(reportedStatus) && resourceName == null) {
                this.log.warn((Object)("Plugin did not indicate a resource name for the request: " + this.requestId));
                errorMessage = "Plugin did not indicate a resource name for this request.";
                status = CreateResourceStatus.FAILURE;
            }
            if ((throwable = this.report.getException()) != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Throwable was found in creation report for request [" + this.requestId + "]."), throwable);
                } else {
                    this.log.warn((Object)("Throwable was found in creation report for request [" + this.requestId + "]: " + throwable + " - Enable DEBUG logging to see the stack trace."));
                }
                status = CreateResourceStatus.FAILURE;
                String messages = ThrowableUtil.getAllMessages((Throwable)throwable);
                errorMessage = errorMessage != null ? errorMessage + " - Cause: " + messages : messages;
            }
        }
        catch (Throwable t) {
            errorMessage = ThrowableUtil.getStackAsString((Throwable)t);
            status = CreateResourceStatus.FAILURE;
        }
        CreateResourceResponse response = new CreateResourceResponse(this.requestId, resourceName, resourceKey, status, errorMessage, configuration);
        this.log.info((Object)("Sending create response to server: " + response));
        ResourceFactoryServerService serverService = this.resourceFactoryManager.getServerService();
        if (serverService != null) {
            try {
                serverService.completeCreateResource(response);
            }
            catch (Throwable throwable) {
                this.log.error((Object)("Error received while attempting to complete report for request: " + this.requestId), throwable);
            }
        }
        if (this.runRuntimeScan && CreateResourceRunner.isSuccessStatus(status)) {
            this.log.info((Object)"Scanning for newly created Resource...");
            try {
                InventoryManager inventoryManager = PluginContainer.getInstance().getInventoryManager();
                inventoryManager.performServiceScan(this.parentResourceId);
            }
            catch (Throwable t) {
                this.log.error((Object)"Error received while attempting runtime scan for newly created Resource...");
            }
        }
        return response;
    }

    private static boolean isSuccessStatus(CreateResourceStatus status) {
        return status == CreateResourceStatus.SUCCESS || status == CreateResourceStatus.INVALID_CONFIGURATION || status == CreateResourceStatus.INVALID_ARTIFACT;
    }
}

