#!/bin/sh
# Copyright(c) 2009 Red Hat Middleware, LLC,
# and individual contributors as indicated by the @authors tag.
# See the copyright.txt in the distribution for a
# full listing of individual contributors.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# @author Mladen Turk
#

. $XB_BUILD_DIR/xb.functions.sh
o_httpdw="$XB_BUILD_ROOT/tmp"

rwip()
{
    $XB_GSED -e "s;@confdir@;$o_prefix/etc/httpd/conf;g" \
        -e "s;@logdir@;/var/log/httpd;g" \
        -e "s;@tomcatdir@;$o_prefix/var/lib/tomcat5;g" \
        -e "s;@java_home@;/opt/java;g" \
        "$1" | $XB_GREP -v "^AddModule" > "$2"
    chmod 644 "$2"
}

if [ -f sources ]; then
    srcd=`cat sources | head -n 1`
    if [ ".$srcd" = . ]; then
        exit 22
    fi
    bldd=`pwd`
    if [ -f makefiles.opts ]; then
        . $bldd/makefiles.opts
        opts="$GLOBAL_CFLAGS"
        for o in $XB_OVERRIDES
        do
            eval v="\$${o}_CFLAGS"
            if [ -n "$v" ]; then xbvaradds opts "$v" ; fi
            eval v="\$${o}_LIBDIR"
            if [ -n "$v" ]; then libd="$v"        ; fi
            eval v="\$${o}_ARCH"
            if [ -n "$v" ]; then arch="$v"        ; fi
        done
    fi

    RPM_OPT_FLAGS="$opts"
    xbexportvs RPM_OPT_FLAGS

    if [ -d "$srcd/native" ]; then
        $XB_VERBOSE "Making mod_cluster..."
        $XB_VERBOSE "  prefix      : \`$o_prefix'"
        $XB_VERBOSE "  modules dir : \`$o_prefix/$libd/httpd/modules'"
        $XB_VERBOSE "  httpd dir   : \`$o_httpdw'"
        $XB_VERBOSE "  rpm options : $RPM_OPT_FLAGS"
        $XB_VERBOSE "  arch        : $arch-bit"
        $XB_VERBOSE ""
        if [ -f skip.makefiles ]; then
            $XB_VERBOSE "Skipping make stage"
            exit 0
        fi
        install -m 755 -d "$XB_BUILD_ROOT$o_prefix/$libd/httpd/modules/"

        # Advertise module
        cd "$bldd/$srcd/native/advertise"
        if $xb_build_clean; then
            make EXTRA_CFLAGS="$RPM_OPT_FLAGS" clean
        fi
        make EXTRA_CFLAGS="$RPM_OPT_FLAGS"
        make install
        mb="$o_httpdw$o_prefix/$libd/httpd/modules/mod_advertise$XB_DLL_EXT"
        if [ ! -f "$mb" ]; then
            mb="$o_httpdw$o_prefix/$libd/httpd/modules/mod_advertise.so"
        fi
        if [ -f "$mb" ]; then
            xbstripbin "$mb"
            install -m 755 "$mb" "$XB_BUILD_ROOT$o_prefix/$libd/httpd/modules/"
        else
            echo "ERROR: module not found : \`$mb'"
            exit 2
        fi

        # Manager module
        cd "$bldd/$srcd/native/mod_manager"
        if $xb_build_clean; then
            make EXTRA_CFLAGS="$RPM_OPT_FLAGS" clean
        fi
        make EXTRA_CFLAGS="$RPM_OPT_FLAGS"
        make install
        mb="$o_httpdw$o_prefix/$libd/httpd/modules/mod_manager$XB_DLL_EXT"
        if [ ! -f "$mb" ]; then
            mb="$o_httpdw$o_prefix/$libd/httpd/modules/mod_manager.so"
        fi
        if [ -f "$mb" ]; then
            xbstripbin "$mb"
            install -m 755 "$mb" "$XB_BUILD_ROOT$o_prefix/$libd/httpd/modules/"
        else
            echo "ERROR: module not found : \`$mb'"
            exit 2
        fi

        # Proxy cluster module
        cd "$bldd/$srcd/native/mod_proxy_cluster"
        if $xb_build_clean; then
            make EXTRA_CFLAGS="$RPM_OPT_FLAGS" clean
        fi
        make EXTRA_CFLAGS="$RPM_OPT_FLAGS"
        make install
        mb="$o_httpdw$o_prefix/$libd/httpd/modules/mod_proxy_cluster$XB_DLL_EXT"
        if [ ! -f "$mb" ]; then
            mb="$o_httpdw$o_prefix/$libd/httpd/modules/mod_proxy_cluster.so"
        fi
        if [ -f "$mb" ]; then
            xbstripbin "$mb"
            install -m 755 "$mb" "$XB_BUILD_ROOT$o_prefix/$libd/httpd/modules/"
        else
            echo "ERROR: module not found : \`$mb'"
            exit 2
        fi

        # Slotmem module
        cd "$bldd/$srcd/native/mod_slotmem"
        if $xb_build_clean; then
            make EXTRA_CFLAGS="$RPM_OPT_FLAGS" clean
        fi
        make EXTRA_CFLAGS="$RPM_OPT_FLAGS"
        make install
        mb="$o_httpdw$o_prefix/$libd/httpd/modules/mod_slotmem$XB_DLL_EXT"
        if [ ! -f "$mb" ]; then
            mb="$o_httpdw$o_prefix/$libd/httpd/modules/mod_slotmem.so"
        fi
        if [ -f "$mb" ]; then
            xbstripbin "$mb"
            install -m 755 "$mb" "$XB_BUILD_ROOT$o_prefix/$libd/httpd/modules/"
        else
            echo "ERROR: module not found : \`$mb'"
            exit 2
        fi
        #
        # netstat -in -f inet | grep '.*\.0\ .*' | grep -v '127.0.0' | grep -v ':' | awk '{print $4}'
    else
        exit 20
    fi
else
    exit 2
fi

exit 0
