#!/bin/sh
# Copyright(c) 2010 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# @author Mladen Turk
#

# Arguments
# $1 : chroot base

xb_chr_shell="bash sh false true test echo env expr printf yes ["
xb_chr_mtext="awk gettext grep head sed sort tail tr touch"
xb_chr_mfile="basename chgrp chmod chown cat cp dirname find ln ls mkdir mv \
pwd readlink rm rmdir stat umask touch which"
xb_chr_utils="date diff groupadd gzip id install ldd nohup \
otool patch su strace uname useradd uuidgen tar"
xb_chr_unet="curl hostid hostname openldap wget"
xb_chr_ietc="group passwd hosts resolv.conf netconfig"

xb_chr_rpms="glibc openldap shadow-utils"
xb_chr_pkgs="SUNWlibms SUNWcsl SUNWzlib SUNWlibC SUNWcslr"


xb_chroot=""
xb_saved_ifs="$IFS"
XB_LF="
"
xb_linesIFS()
{
    xb_saved_ifs="$IFS"
    IFS="$XB_LF"
}

xb_resetIFS()
{
    IFS="$xb_saved_ifs"
}


do_filesucopy()
{
    dd="`dirname \"$2\"`"
    install -m 755 -d "$1$dd"
    sudo cp "$2" "$1$dd" 2>/dev/null || true
}

do_chrootcopy()
{
    dd="`dirname \"$2\"`"
    install -m 755 -d "$1$dd"
    sudo cp "$2" "$1$dd" 2>/dev/null || true

    if [ ! -x "$2" ]; then
        return
    fi
    ifs="$IFS"
    IFS="$XB_LF"
    deps=`ldd "$2" 2>/dev/null | awk '{ if (NF > 2) print $3; else print $1; }'`
    for d in $deps
    do
        IFS="$ifs"
        if [ -f "$d" -a ! -f "$1$d" ]; then
            dd="`dirname \"$d\"`"
            if [ ! -d "$1$dd" ]; then
                install -m 755 -d "$1$dd"
            fi
            sudo cp "$d" "$1$dd/"
        fi
    done
}

xb_chrootcopy()
{
    if [ -f "$1" ]; then
        do_chrootcopy "$xb_chroot" "$1"
    else
        PATH="/sbin:/usr/sbin:/usr/xpg4/bin:$PATH"
        pb="`which $1 2>/dev/null || type $1 2>&1`"
        if [ -x "$pb" ]; then
            if [ -x "$pb" ]; then
                do_chrootcopy "$xb_chroot" "$pb"
            fi
        fi
    fi
}

xb_chroot_install_tools()
{
    for i in $xb_chr_shell $xb_chr_mtext $xb_chr_mfile $xb_chr_utils $xb_chr_unet
    do
        xb_chrootcopy $i
    done
}

xb_chroot_install_rpm()
{
    ifs="$IFS"
    IFS="$XB_LF"
    for i in `rpm -lq "$1"`
    do
        IFS="$ifs"
        if [ -f "$i" ]; then
            m="`echo $i | grep -e '/man/' -e '/doc/' -e '/locale/'`"
            if [ -z "$m" ]; then
                do_chrootcopy "$xb_chroot" "$i"
            fi
        fi
    done
}

xb_chroot_install_pkg()
{
    ifs="$IFS"
    IFS="$XB_LF"
    for i in `/usr/sbin/pkgchk -l "$1" | grep 'Pathname:' | awk '{ print $2; }'`
    do
        IFS="$ifs"
        if [ -f "$i" ]; then
            m="`echo $i | grep -e '/man/' -e '/doc/' -e '/locale/'`"
            if [ -z "$m" ]; then
                do_filesucopy "$xb_chroot" "$i"
            fi
        fi
    done
}

xb_chroot_create_dev()
{
  major=`ls -lL /dev/$1 | awk '{ print $5 }' | sed 's/,//'`
  minor=`ls -lL /dev/$1 | awk '{ print $6 }'`

  sudo mknod $xb_chroot/dev/$1 c $major $minor
}

xb_chroot_install_sys()
{
    install -m 777 -d "$xb_chroot/tmp"
    install -m 755 -d "$xb_chroot/var/run"
    install -m 755 -d "$xb_chroot/etc"
    install -m 755 -d "$xb_chroot/dev"
    install -m 755 -d "$xb_chroot/proc"
    for i in $xb_chr_ietc
    do
        sudo cp /etc/$i "$xb_chroot/etc/" >/dev/null 2>&1 || true
    done
    if [ -f /etc/inet/ipnodes ]; then
        install -m 755 -d "$xb_chroot/etc/inet"
        sudo cp /etc/inet/ipnodes "$xb_chroot/etc/inet/" >/dev/null 2>&1 || true
    fi
    case "`uname -s`" in
        Linux   )
            for i in $xb_chr_rpms
            do
                xb_chroot_install_rpm "$i"
            done
            sudo mount -t proc proc "$xb_chroot/proc"
            # Create needed devices
            for i in null random urandom
            do
                xb_chroot_create_dev $i
            done
        ;;
        SunOS   )
            for i in $xb_chr_pkgs
            do
                xb_chroot_install_pkg "$i"
            done
            sudo /usr/sbin/mount -F proc proc "$xb_chroot/proc"
            # Create needed devices
            for i in ip kmem null random rawip tcp tcp6 ticlts ticots ticotsord udp udp6 zero urandom
            do
                xb_chroot_create_dev $i
            done
            for i in lib usr/lib
            do
            (
                cd "$xb_chroot/$i"
                if [ ! -d 64 ]; then
                    for d in amd64 sparcv9
                    do
                        if [ -d $d ]; then
                            ln -sf $d 64
                        fi
                    done
                fi
            )
            done
            if [ ! -d "$xb_chroot/bin" ]; then
            (
                cd "$xb_chroot"
                ln -sf usr/bin bin
            )
            fi
            xb_chrootcopy "/usr/bin/sh"
        ;;
    esac
}

xbcopypdir()
{
    install -m 755 -d "$2"
    if [ -d "$1" ]; then
    (
        cd "$1"
        tar cf - . |\
        (   cd "$2"
            tar xf -
        )
    )
    fi
}

xb_chroot_make()
{

    cj=false
    jp=""
    for o
    do
        case "$o" in
        -*=*) a=`echo "$o" | sed 's/^[-_a-zA-Z0-9]*=//'` ;;
           *) a='' ;;
        esac
        case "$o" in
            --chroot=*      ) xb_chroot="$a";       shift ;;
            --with-java=*   ) jp="$a"; cj=true;     shift ;;
            *  ) break ;;
        esac
    done
    if [ ".$xb_chroot" = . ]; then
        xb_chroot="$1";
        shift
    fi
    xb_chroot_install_sys
    xb_chroot_install_tools
    if $cj ; then
        xbcopypdir $jp $xb_chroot/$jp
    fi
}

xb_chroot_make $@
exit 0
