/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.helpers;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.jboss.classloading.spi.version.Version;
import org.jboss.classloading.spi.version.VersionComparatorRegistry;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.metatype.api.annotations.CompositeKey;
import org.jboss.metatype.api.annotations.CompositeValue;

public class NameAndVersionSupport
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6943685422194480909L;
    private String name = "<unknown>";
    private Object version = Version.DEFAULT_VERSION;

    public NameAndVersionSupport() {
    }

    public NameAndVersionSupport(String name) {
        this(name, null);
    }

    public NameAndVersionSupport(String name, Object version) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (version == null) {
            version = Version.DEFAULT_VERSION;
        }
        this.name = name;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    @CompositeKey
    @ManagementProperty
    @XmlAttribute
    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.name = name;
    }

    public Object getVersion() {
        return this.version;
    }

    @CompositeValue(ignore=true)
    @XmlTransient
    public void setVersion(Object version) {
        if (version == null) {
            version = Version.DEFAULT_VERSION;
        }
        this.version = version;
    }

    public Version getTheVersion() {
        Object version = this.getVersion();
        if (version instanceof Version) {
            return (Version)version;
        }
        if (version instanceof String) {
            return Version.parseVersion((String)version);
        }
        throw new IllegalStateException(version + " is not an instanceof version");
    }

    @CompositeKey
    @CompositeValue(name="version")
    @ManagementProperty(name="version")
    @XmlAttribute(name="version")
    public void setTheVersion(Version version) {
        this.setVersion(version);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof NameAndVersionSupport)) {
            return false;
        }
        NameAndVersionSupport other = (NameAndVersionSupport)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        return VersionComparatorRegistry.getInstance().same(this.getVersion(), other.getVersion());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getName() + ":" + this.getVersion();
    }

    public NameAndVersionSupport clone() {
        try {
            NameAndVersionSupport clone = (NameAndVersionSupport)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Unexpected", e);
        }
    }
}

