/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.pluginapi.event.EventContext;
import org.rhq.core.pluginapi.inventory.ResourceContext;

public class SyslogProcessor {
    private final Log log = LogFactory.getLog(SyslogProcessor.class);
    private final EventContext eventContext;
    private final EventSeverity minimumEventSeverity;
    private final Pattern includesPattern;
    private final Pattern parserRegex;
    private final SimpleDateFormat dateTimeFormatter;
    private final String sourceLocation;
    protected static final String EVENT_LOG_TYPE = "Event Log";
    private static SimpleDateFormat RFC3339_FORMAT_ZULU;
    private static SimpleDateFormat RFC3339_FORMAT;

    public SyslogProcessor(ResourceContext resourceContext, PropertyMap logProperties, String sourceLocation) {
        this.sourceLocation = sourceLocation;
        this.eventContext = resourceContext.getEventContext();
        String minSev = logProperties.getSimpleValue("logTrackingMinimumSeverity", "");
        this.minimumEventSeverity = minSev.toLowerCase().startsWith("info") ? EventSeverity.INFO : (minSev.toLowerCase().startsWith("warn") ? EventSeverity.WARN : (minSev.toLowerCase().startsWith("err") ? EventSeverity.ERROR : null));
        String regexString = logProperties.getSimpleValue("logTrackingIncludesPattern", null);
        Pattern regexPattern = null;
        if (regexString != null && !regexString.equals("")) {
            try {
                regexPattern = Pattern.compile(regexString);
            }
            catch (Exception e) {
                this.log.error((Object)("Invalid includes regex [" + regexString + "]. All events will be accepted. " + e));
            }
        }
        this.includesPattern = regexPattern;
        regexString = logProperties.getSimpleValue("logTrackingParserRegex", null);
        regexPattern = null;
        if (regexString != null && !regexString.equals("")) {
            try {
                regexPattern = Pattern.compile(regexString);
            }
            catch (Exception e) {
                this.log.error((Object)("Invalid parser regex [" + regexString + "]. Will parse with a best guess. " + e));
            }
        }
        this.parserRegex = regexPattern;
        regexString = logProperties.getSimpleValue("logTrackingDateTimeFormat", null);
        SimpleDateFormat formatter = null;
        if (regexString != null && !regexString.equals("")) {
            try {
                formatter = new SimpleDateFormat(regexString);
            }
            catch (Exception e) {
                this.log.error((Object)("Invalid datetime format [" + regexString + "]. Will use current times. " + e));
            }
        }
        this.dateTimeFormatter = formatter;
    }

    protected String getSourceLocation() {
        return this.sourceLocation;
    }

    protected EventContext getEventContext() {
        return this.eventContext;
    }

    protected EventSeverity getMinimumEventSeverity() {
        return this.minimumEventSeverity;
    }

    protected Pattern getIncludesPattern() {
        return this.includesPattern;
    }

    protected Pattern getParserRegex() {
        return this.parserRegex;
    }

    protected Event convertLine(String syslogMessage) {
        Event event = null;
        try {
            event = this.parserRegex != null ? this.convertLineParserRegEx(syslogMessage) : this.convertLineDefaultFormat(syslogMessage);
            if (event == null) {
                event = this.convertAnyLine(syslogMessage);
            }
            if (event != null) {
                if (this.minimumEventSeverity != null && !event.getSeverity().isAtLeastAsSevereAs(this.minimumEventSeverity)) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("event is not at minimum severity: " + event));
                    }
                    event = null;
                } else if (this.includesPattern != null && !this.includesPattern.matcher(event.getDetail()).matches()) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("event does not match includes pattern [" + this.includesPattern + "]: " + event));
                    }
                    event = null;
                }
            }
        }
        catch (Exception e) {
            event = null;
            this.log.warn((Object)("Failed to convert syslog message [" + syslogMessage + "] to event: " + e));
        }
        return event;
    }

    protected Event convertLineParserRegEx(String syslogMessage) {
        Event event;
        block5: {
            try {
                Matcher matcher = this.parserRegex.matcher(syslogMessage);
                if (matcher.find() && matcher.groupCount() == 3) {
                    String dateTimeString = matcher.group(1);
                    String severityString = matcher.group(2);
                    String detailsString = matcher.group(3);
                    long timestamp = this.getTimestamp(dateTimeString);
                    EventSeverity severity = this.getSeverity(severityString);
                    event = new Event(EVENT_LOG_TYPE, this.sourceLocation, timestamp, severity, detailsString);
                } else {
                    event = null;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Message [" + syslogMessage + "] did not match parser regex: " + this.parserRegex.pattern()));
                    }
                }
            }
            catch (Exception e) {
                event = null;
                if (!this.log.isTraceEnabled()) break block5;
                this.log.trace((Object)("Failed to parse [" + syslogMessage + "] with [" + this.parserRegex.pattern() + "]"), (Throwable)e);
            }
        }
        return event;
    }

    protected Event convertLineDefaultFormat(String syslogMessage) {
        Event event;
        block3: {
            try {
                String[] messageParts = syslogMessage.split("\\,", 3);
                if (messageParts == null || messageParts.length < 3) {
                    return null;
                }
                String dateTimeString = messageParts[0];
                String severityString = messageParts[1];
                String detailsString = messageParts[2];
                long timestamp = this.getTimestamp(dateTimeString);
                EventSeverity severity = this.getSeverity(severityString);
                event = new Event(EVENT_LOG_TYPE, this.sourceLocation, timestamp, severity, detailsString);
            }
            catch (Exception e) {
                event = null;
                if (!this.log.isTraceEnabled()) break block3;
                this.log.trace((Object)("defaultFormat: Failed to convert syslog message [" + syslogMessage + "] to event: " + e));
            }
        }
        return event;
    }

    protected Event convertAnyLine(String syslogMessage) {
        Event event;
        block2: {
            try {
                long timestamp = System.currentTimeMillis();
                EventSeverity severity = EventSeverity.INFO;
                event = new Event(EVENT_LOG_TYPE, this.sourceLocation, timestamp, severity, syslogMessage);
            }
            catch (Exception e) {
                event = null;
                if (!this.log.isTraceEnabled()) break block2;
                this.log.trace((Object)("anyLine: Failed to convert syslog message [" + syslogMessage + "] to event: " + e));
            }
        }
        return event;
    }

    protected long getTimestamp(String dateTimeString) {
        if (dateTimeString == null || dateTimeString.length() == 0) {
            return System.currentTimeMillis();
        }
        if (this.dateTimeFormatter == null) {
            if (dateTimeString.length() < 19 || dateTimeString.charAt(10) != 'T') {
                return System.currentTimeMillis();
            }
            try {
                return this.parseRFC3339Date(dateTimeString).getTime();
            }
            catch (Exception e) {
                return System.currentTimeMillis();
            }
        }
        try {
            Date date = this.dateTimeFormatter.parse(dateTimeString);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            if (cal.get(1) < 2000) {
                cal.set(1, Calendar.getInstance().get(1));
            }
            return cal.getTimeInMillis();
        }
        catch (Exception e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Failed to parse date/time [" + dateTimeString + "] with format [" + this.dateTimeFormatter.toPattern() + "]. " + e));
            }
            return System.currentTimeMillis();
        }
    }

    protected EventSeverity getSeverity(String severityString) {
        EventSeverity severity = EventSeverity.INFO;
        if (severityString != null) {
            if ((severityString = severityString.toUpperCase()).startsWith("EMERG") || severityString.startsWith("CRIT")) {
                severity = EventSeverity.FATAL;
            } else if (severityString.startsWith("ERR")) {
                severity = EventSeverity.ERROR;
            } else if (severityString.startsWith("WARN")) {
                severity = EventSeverity.WARN;
            } else if (severityString.startsWith("NOTICE") || severityString.startsWith("INFO")) {
                severity = EventSeverity.INFO;
            } else if (severityString.startsWith("DEBUG")) {
                severity = EventSeverity.DEBUG;
            }
        }
        return severity;
    }

    protected Date parseRFC3339Date(String rfc3339String) throws Exception {
        if ((rfc3339String = rfc3339String.replaceFirst("\\.\\d*", "")).endsWith("Z")) {
            Date date = RFC3339_FORMAT_ZULU.parse(rfc3339String);
            return date;
        }
        if (rfc3339String.matches(".*[\\+\\-]\\d\\d:\\d\\d.*")) {
            int length = rfc3339String.length();
            rfc3339String = rfc3339String.substring(0, length - 3) + rfc3339String.substring(length - 2);
        }
        Date date = RFC3339_FORMAT.parse(rfc3339String);
        return date;
    }

    static {
        try {
            RFC3339_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            RFC3339_FORMAT_ZULU = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            RFC3339_FORMAT_ZULU.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        catch (Throwable t) {
            LogFactory.getLog(SyslogProcessor.class).warn((Object)"Cannot setup rfc3999 formats", t);
        }
    }
}

