/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.latch;

import com.sleepycat.je.latch.LatchException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

class LatchTable {
    private String tableName;
    private Map latchesByThread;

    LatchTable(String tableName) {
        this.tableName = tableName;
        this.latchesByThread = Collections.synchronizedMap(new WeakHashMap());
    }

    boolean noteLatch(Object latch) throws LatchException {
        Thread cur = Thread.currentThread();
        HashSet<Object> threadLatches = (HashSet<Object>)this.latchesByThread.get(cur);
        if (threadLatches == null) {
            threadLatches = new HashSet<Object>();
            this.latchesByThread.put(cur, threadLatches);
        }
        threadLatches.add(latch);
        return true;
    }

    boolean unNoteLatch(Object latch, String name) {
        Thread cur = Thread.currentThread();
        Set threadLatches = (Set)this.latchesByThread.get(cur);
        if (threadLatches == null) {
            return false;
        }
        return threadLatches.remove(latch);
    }

    int countLatchesHeld() {
        Thread cur = Thread.currentThread();
        Set threadLatches = (Set)this.latchesByThread.get(cur);
        if (threadLatches != null) {
            return threadLatches.size();
        }
        return 0;
    }

    String latchesHeldToString() {
        Thread cur = Thread.currentThread();
        Set threadLatches = (Set)this.latchesByThread.get(cur);
        StringBuffer sb = new StringBuffer();
        if (threadLatches != null) {
            Iterator i = threadLatches.iterator();
            while (i.hasNext()) {
                sb.append(i.next()).append('\n');
            }
        }
        return sb.toString();
    }

    void clearNotes() {
        this.latchesByThread.clear();
    }

    String getNameString(String name) {
        StringBuffer sb = new StringBuffer(this.tableName);
        if (name != null) {
            sb.append("(").append(name).append(")");
        }
        return sb.toString();
    }

    String toString(String name, Object owner, List waiters, int startIndex) {
        StringBuffer sb = new StringBuffer();
        sb.append("<LATCH ");
        if (name != null) {
            sb.append("[name: ").append(name).append("] ");
        }
        sb.append("[owner: ").append(owner).append("]");
        if (waiters != null && waiters.size() > startIndex) {
            sb.append(" [waiters: ");
            for (int i = startIndex; i < waiters.size(); ++i) {
                sb.append(waiters.get(i)).append(" ");
            }
            sb.append("]");
        }
        sb.append(">");
        return sb.toString();
    }
}

