/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.web;

public class ServletMapping {
    String mapping;

    public ServletMapping(String mapping) {
        this.mapping = mapping;
    }

    public String mapViewIdToURL(String viewId) {
        int pos;
        if (this.mapping.endsWith("/*")) {
            return this.mapping.substring(0, this.mapping.length() - 2) + viewId;
        }
        if (this.mapping.startsWith("*.") && (pos = viewId.lastIndexOf(".")) != -1) {
            return viewId.substring(0, pos) + this.mapping.substring(1);
        }
        return null;
    }

    private String stripExtension(String text) {
        int pos = text.lastIndexOf(46);
        return pos == -1 ? null : text.substring(0, pos);
    }

    public boolean isMapped(String baseURL, String viewId) {
        if (this.mapping.startsWith("*.")) {
            String baseValue = this.stripExtension(baseURL);
            String viewValue = this.stripExtension(viewId);
            return baseValue != null && viewValue != null && baseValue.equals(viewValue);
        }
        if (this.mapping.endsWith("/*")) {
            String prefix = this.mapping.substring(0, this.mapping.length() - 2) + viewId;
            return baseURL.equals(prefix);
        }
        return false;
    }
}

