/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Message;

public class AckReceiverWindow {
    long next_to_remove = 0L;
    final Map<Long, Message> msgs = new HashMap<Long, Message>();
    static final Log log = LogFactory.getLog(AckReceiverWindow.class);
    final AtomicBoolean processing = new AtomicBoolean(false);

    public AckReceiverWindow(long initial_seqno) {
        this.next_to_remove = initial_seqno;
    }

    public AtomicBoolean getProcessing() {
        return this.processing;
    }

    public boolean add(long seqno, Message msg) {
        return this.add2(seqno, msg) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte add2(long seqno, Message msg) {
        if (msg == null) {
            throw new IllegalArgumentException("msg must be non-null");
        }
        Map<Long, Message> map = this.msgs;
        synchronized (map) {
            if (seqno < this.next_to_remove) {
                return -1;
            }
            if (!this.msgs.containsKey(seqno)) {
                this.msgs.put(seqno, msg);
                return 1;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message remove() {
        Message retval = null;
        Map<Long, Message> map = this.msgs;
        synchronized (map) {
            long seqno = this.next_to_remove;
            try {
                retval = this.msgs.remove(seqno);
            }
            finally {
                if (retval != null) {
                    this.next_to_remove = ++seqno;
                }
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message remove(AtomicBoolean processing) {
        Message retval = null;
        Map<Long, Message> map = this.msgs;
        synchronized (map) {
            long seqno = this.next_to_remove;
            try {
                retval = this.msgs.remove(seqno);
            }
            finally {
                if (retval != null) {
                    this.next_to_remove = ++seqno;
                } else {
                    processing.set(false);
                }
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> removeMany(AtomicBoolean processing) {
        ArrayList<Message> retval;
        Map<Long, Message> map = this.msgs;
        synchronized (map) {
            Message msg;
            retval = new ArrayList<Message>(this.msgs.size());
            while ((msg = this.msgs.remove(this.next_to_remove)) != null) {
                ++this.next_to_remove;
                retval.add(msg);
            }
            if (retval.isEmpty()) {
                processing.set(false);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message removeOOBMessage() {
        Message retval;
        Map<Long, Message> map = this.msgs;
        synchronized (map) {
            retval = this.msgs.get(this.next_to_remove);
            if (retval != null) {
                if (!retval.isFlagSet((byte)1)) {
                    return null;
                }
                retval = this.msgs.remove(this.next_to_remove);
                ++this.next_to_remove;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessagesToRemove() {
        Map<Long, Message> map = this.msgs;
        synchronized (map) {
            return this.msgs.containsKey(this.next_to_remove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map<Long, Message> map = this.msgs;
        synchronized (map) {
            this.msgs.clear();
        }
    }

    public int size() {
        return this.msgs.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.msgs.size()).append(" msgs (").append("next=").append(this.next_to_remove).append(")");
        TreeSet<Long> s = new TreeSet<Long>(this.msgs.keySet());
        if (!s.isEmpty()) {
            sb.append(" [").append(s.first()).append(" - ").append(s.last()).append("]");
            sb.append(": ").append(s);
        }
        return sb.toString();
    }

    public String printDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.msgs.size()).append(" msgs (").append("next=").append(this.next_to_remove).append(")").append(", msgs=").append(new TreeSet<Long>(this.msgs.keySet()));
        return sb.toString();
    }
}

