/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ant.AbstractArtifactWithRepositoryTask;
import org.apache.maven.artifact.ant.AttachedArtifact;
import org.apache.maven.artifact.ant.Profile;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.apache.maven.artifact.ant.shaded.introspection.ReflectionValueExtractor;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Build;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Scm;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;

public class Pom
extends AbstractArtifactWithRepositoryTask {
    private String refid;
    private String antId;
    private MavenProject mavenProject;
    private File file;
    private List profiles = new ArrayList();
    private final POMPropertyHelper helper = new POMPropertyHelper();

    public String getRefid() {
        return this.refid;
    }

    public void setRefid(String refid) {
        this.refid = refid;
    }

    public void setId(String id) {
        this.antId = id;
    }

    protected Pom getInstance() {
        Pom instance = this;
        if (this.refid != null && (instance = (Pom)((Object)this.getProject().getReference(this.refid))) == null) {
            throw new BuildException("Invalid reference: '" + this.refid + "'");
        }
        return instance;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.getInstance().mavenProject = mavenProject;
    }

    public File getFile() {
        return this.getInstance().file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public List getProfiles() {
        return this.profiles;
    }

    public void addProfile(Profile activeProfile) {
        this.profiles.add(activeProfile);
    }

    public Artifact getArtifact() {
        return this.getMavenProject().getArtifact();
    }

    public void attach(AttachedArtifact attached) {
        MavenProjectHelper helper = (MavenProjectHelper)this.lookup(MavenProjectHelper.ROLE);
        MavenProject project = this.getMavenProject();
        if (attached.getClassifier() != null) {
            helper.attachArtifact(project, attached.getType(), attached.getClassifier(), attached.getFile());
        } else {
            helper.attachArtifact(project, attached.getType(), attached.getFile());
        }
    }

    public List getAttachedArtifacts() {
        return this.getMavenProject().getAttachedArtifacts();
    }

    void initialise(MavenProjectBuilder builder, ArtifactRepository localRepository) {
        if (this.mavenProject != null) {
            this.log("POM is already initialized for: " + this.mavenProject.getId(), 4);
            return;
        }
        if (this.file != null) {
            this.addAntRepositoriesToProfileManager();
            try {
                this.mavenProject = builder.build(this.file, localRepository, this.getActivatedProfiles());
            }
            catch (ProjectBuildingException e) {
                throw new BuildException("Unable to initialize POM " + this.file.getName() + ": " + e.getMessage(), (Throwable)e);
            }
        } else if (this.refid != null) {
            this.getInstance().initialise(builder, localRepository);
        }
    }

    protected MavenProject getMavenProject() {
        return this.getInstance().mavenProject;
    }

    public String getArtifactId() {
        return this.getMavenProject().getArtifactId();
    }

    public Build getBuild() {
        return this.getMavenProject().getBuild();
    }

    public CiManagement getCiManagement() {
        return this.getMavenProject().getCiManagement();
    }

    public List getContributors() {
        return this.getMavenProject().getContributors();
    }

    public List getDependencies() {
        return this.getMavenProject().getDependencies();
    }

    public DependencyManagement getDependencyManagement() {
        return this.getMavenProject().getDependencyManagement();
    }

    public String getDescription() {
        return this.getMavenProject().getDescription();
    }

    public List getDevelopers() {
        return this.getMavenProject().getDevelopers();
    }

    public DistributionManagement getDistributionManagement() {
        return this.getMavenProject().getDistributionManagement();
    }

    public String getGroupId() {
        return this.getMavenProject().getGroupId();
    }

    public String getInceptionYear() {
        return this.getMavenProject().getInceptionYear();
    }

    public IssueManagement getIssueManagement() {
        return this.getMavenProject().getIssueManagement();
    }

    public List getLicenses() {
        return this.getMavenProject().getLicenses();
    }

    public List getMailingLists() {
        return this.getMavenProject().getMailingLists();
    }

    public String getModelVersion() {
        return this.getMavenProject().getModelVersion();
    }

    public List getModules() {
        return this.getMavenProject().getModules();
    }

    public String getName() {
        return this.getMavenProject().getName();
    }

    public Organization getOrganization() {
        return this.getMavenProject().getOrganization();
    }

    public String getPackaging() {
        return this.getMavenProject().getPackaging();
    }

    public List getPluginRepositories() {
        return this.getMavenProject().getPluginRepositories();
    }

    public Reporting getReporting() {
        return this.getMavenProject().getReporting();
    }

    public List getRepositories() {
        return this.getMavenProject().getRepositories();
    }

    public Scm getScm() {
        return this.getMavenProject().getScm();
    }

    public String getUrl() {
        return this.getMavenProject().getUrl();
    }

    public String getVersion() {
        return this.getMavenProject().getVersion();
    }

    public String getId() {
        return this.getMavenProject().getId();
    }

    protected void doExecute() {
        ArtifactRepository localRepo = this.createLocalArtifactRepository();
        MavenProjectBuilder projectBuilder = (MavenProjectBuilder)this.lookup(MavenProjectBuilder.ROLE);
        this.initialise(projectBuilder, localRepo);
        Project project = this.getProject();
        project.addReference(this.antId, (Object)this);
        PropertyHelper phelper = PropertyHelper.getPropertyHelper((Project)project);
        this.helper.setNext(phelper.getNext());
        this.helper.setProject(project);
        phelper.setNext((PropertyHelper)this.helper);
    }

    private void addAntRepositoriesToProfileManager() {
        List remoteRepositories = this.getRemoteRepositories();
        if (remoteRepositories == null || remoteRepositories.isEmpty()) {
            return;
        }
        org.apache.maven.model.Profile repositoriesProfile = new org.apache.maven.model.Profile();
        repositoriesProfile.setId("maven-ant-tasks-repo-profile");
        Iterator iter = remoteRepositories.iterator();
        while (iter.hasNext()) {
            RemoteRepository antRepo = (RemoteRepository)((Object)iter.next());
            Repository mavenRepo = new Repository();
            mavenRepo.setId(antRepo.getId());
            mavenRepo.setUrl(antRepo.getUrl());
            repositoriesProfile.addRepository(mavenRepo);
        }
        this.getProfileManager().addProfile(repositoriesProfile);
        this.getProfileManager().explicitlyActivate(repositoriesProfile.getId());
    }

    private ProfileManager getActivatedProfiles() {
        ProfileManager profileManager = this.getProfileManager();
        Iterator it = this.getProfiles().iterator();
        while (it.hasNext()) {
            Profile profile = (Profile)it.next();
            if (profile.getId() == null) {
                throw new BuildException("Attribute \"id\" is required for profile in pom type.");
            }
            if (profile.getActive() == null || Boolean.valueOf(profile.getActive()).booleanValue()) {
                profileManager.explicitlyActivate(profile.getId());
                continue;
            }
            profileManager.explicitlyDeactivate(profile.getId());
        }
        return profileManager;
    }

    private class POMPropertyHelper
    extends PropertyHelper {
        private static final String PROPERTIES_PREFIX = "project.properties.";

        private POMPropertyHelper() {
        }

        public Object getPropertyHook(String ns, String name, boolean user) {
            String prefix = Pom.this.antId + ".";
            if (!name.startsWith(prefix)) {
                return super.getPropertyHook(ns, name, user);
            }
            try {
                String expression = name.substring(prefix.length());
                return this.getPOMValue("project." + expression);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        private Object getPOMValue(String expression) {
            Object value = null;
            try {
                if (expression.startsWith(PROPERTIES_PREFIX)) {
                    expression = expression.substring(PROPERTIES_PREFIX.length());
                    value = Pom.this.getMavenProject().getProperties().get(expression);
                } else {
                    value = ReflectionValueExtractor.evaluate(expression, Pom.this.getMavenProject());
                }
            }
            catch (Exception e) {
                throw new BuildException("Error extracting expression from POM", (Throwable)e);
            }
            return value;
        }
    }
}

