/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.memory;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.plugins.context.AbstractVFSContext;
import org.jboss.virtual.plugins.context.memory.MemoryContextHandler;
import org.jboss.virtual.plugins.vfs.helpers.PathTokenizer;
import org.jboss.virtual.spi.VirtualFileHandler;

public class MemoryContext
extends AbstractVFSContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MemoryContextHandler root;
    private final VirtualFile rootFile;

    protected MemoryContext(URL url) throws URISyntaxException {
        super(url);
        this.root = new MemoryContextHandler(this, null, url, url.getFile());
        this.rootFile = this.root.getVirtualFile();
    }

    public String getName() {
        return this.root.getName();
    }

    public VirtualFileHandler getRoot() throws IOException {
        return this.root;
    }

    VirtualFile createDirectory(URL url) {
        return this.putFile(url, null);
    }

    VirtualFile putFile(URL url, byte[] contents) {
        try {
            List<String> tokens = PathTokenizer.getTokens(url.getPath());
            if (tokens == null || tokens.size() == 0) {
                return null;
            }
            boolean definitelyNew = false;
            String protocolAndHost = url.getProtocol() + "://" + url.getHost();
            StringBuffer path = new StringBuffer(protocolAndHost);
            MemoryContextHandler current = this.root;
            for (String token : tokens) {
                path.append("/");
                path.append(token);
                if (!definitelyNew) {
                    try {
                        MemoryContextHandler child = current.getDirectChild(token);
                        if (child != null) {
                            current = child;
                            continue;
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    definitelyNew = true;
                }
                URL localUrl = new URL(path.toString());
                if (current.getContents() != null) {
                    throw new IllegalStateException("Cannot add a child to " + current + ", it already has contents");
                }
                current = new MemoryContextHandler(this, current, localUrl, token);
            }
            current.setContents(contents);
            return current.getVirtualFile();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

