/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * Copyright (c) 2008, Red Hat Middleware LLC or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat Middleware LLC.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 *
 */
package org.hibernate.transaction;

import java.util.Properties;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;

import org.hibernate.HibernateException;
import org.hibernate.util.NamingHelper;

/**
 * A {@link TransactionManagerLookup} lookup strategy for JBoss AS.
 *
 * @author Gavin King
 */
public final class JBossTransactionManagerLookup extends JNDITransactionManagerLookup {
    public static final String AS4_TM_NAME = "java:/TransactionManager";
    public static final String AS7_TM_NAME = "java:jboss/TransactionManager";

    protected String getName() {
        return AS4_TM_NAME;
    }

    public String getUserTransactionName() {
        return "UserTransaction";
    }

    @Override
    public TransactionManager getTransactionManager(Properties props) throws HibernateException {
        try {
            return (TransactionManager) NamingHelper.getInitialContext( props ).lookup( getName() );
        }
        catch ( NamingException ne ) {
            try {
                return (TransactionManager) NamingHelper.getInitialContext( props ).lookup( AS7_TM_NAME );
            }
            catch ( NamingException ne2 ) {
                throw new HibernateException( "Could not locate TransactionManager", ne2 );
            }
        }
    }
}
