/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format.xml;

import java.util.HashMap;
import java.util.Map;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmProperty;

public class FeedCustomizations {
    private final EdmDataServices metadata;
    private Map<String, FeedCustomization> cache;

    public FeedCustomizations(EdmDataServices metadata) {
        this.metadata = metadata;
    }

    public FeedCustomization get(EdmEntityType eet) {
        String key;
        FeedCustomization value;
        if (eet == null) {
            return null;
        }
        if (this.cache == null) {
            this.cache = new HashMap<String, FeedCustomization>();
        }
        if ((value = this.cache.get(key = eet.getFullyQualifiedTypeName())) == null) {
            value = FeedCustomizations.computeFeedCustomization(this.metadata, eet);
            this.cache.put(key, value);
        }
        return value;
    }

    private static FeedCustomization computeFeedCustomization(EdmDataServices metadata, EdmEntityType eet) {
        PropertyCustomization syndicationTitle = null;
        PropertyCustomization syndicationSummary = null;
        for (EdmProperty ep : eet.getProperties()) {
            if ("SyndicationTitle".equals(ep.getFcTargetPath())) {
                syndicationTitle = new PropertyCustomization(ep.getName(), !"false".equals(ep.getFcKeepInContent()));
            }
            if (!"SyndicationSummary".equals(ep.getFcTargetPath())) continue;
            syndicationSummary = new PropertyCustomization(ep.getName(), !"false".equals(ep.getFcKeepInContent()));
        }
        return FeedCustomization.create(syndicationTitle, syndicationSummary);
    }

    public static class FeedCustomization {
        public static final FeedCustomization NONE = new FeedCustomization(null, null);
        public final PropertyCustomization syndicationTitle;
        public final PropertyCustomization syndicationSummary;

        private FeedCustomization(PropertyCustomization syndicationTitle, PropertyCustomization syndicationSummary) {
            this.syndicationTitle = syndicationTitle;
            this.syndicationSummary = syndicationSummary;
        }

        public static FeedCustomization create(PropertyCustomization syndicationTitle, PropertyCustomization syndicationSummary) {
            return syndicationTitle == null && syndicationSummary == null ? NONE : new FeedCustomization(syndicationTitle, syndicationSummary);
        }
    }

    public static class PropertyCustomization {
        public final String propertyName;
        public final boolean keepInContent;

        public PropertyCustomization(String propertyName, boolean keepInContent) {
            this.propertyName = propertyName;
            this.keepInContent = keepInContent;
        }
    }
}

