package org.jboss.hibernate.customresolvers;

import java.sql.*;

import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.jdbc.dialect.internal.AbstractDialectResolver;
import org.hibernate.service.jdbc.dialect.internal.StandardDialectResolver;
import org.hibernate.service.jdbc.dialect.spi.DialectResolver;
import org.jboss.logging.Logger;

/**
 * Created by stejohns on 24/12/13.
 */
public class MySQL5InnoDBDialectResolver extends AbstractDialectResolver
{
    private final static String INNODB = "InnoDB";

    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class,
                               MySQL5InnoDBDialectResolver.class.getName());

    private final DialectResolver standardDialectResolver = new StandardDialectResolver();

    @Override
    protected Dialect resolveDialectInternal(DatabaseMetaData databaseMetaData) throws SQLException
    {
        Dialect dialect = standardDialectResolver.resolveDialect(databaseMetaData);

        if (dialect instanceof MySQLDialect)
        {
            PreparedStatement p = null;
            ResultSet r = null;
            try
            {
                Connection connection = databaseMetaData.getConnection();

                // lookup storage_engine session variable value
                String query = "SHOW SESSION VARIABLES LIKE ?";
                p = connection.prepareStatement(query);
                p.setString(1, "storage_engine");

                // retrieve storage_engine session value
                r = p.executeQuery();
                r.first();
                String storageEngine = r.getString("Value");
                LOG.info("MySQL storage_engine=" + storageEngine);
                if (storageEngine.equals(INNODB))
                {
                    LOG.info("Dialect set to org.hibernate.dialect.MySQL5InnoDBDialect");
                    dialect = new org.hibernate.dialect.MySQL5InnoDBDialect();
                }
            }
            finally
            {
                // help free resource(s)
                try
                {
                    if (r != null)
                        r.close();
                }
                catch (SQLException e)
                {
                    // must not mask original sql exception
                    LOG.warn("Jdbc ResultSet did not close cleanly.");
                }

                try
                {
                    if (p != null)
                        p.close();
                }
                catch (SQLException e)
                {
                    // must not mask original sql exception
                    LOG.warn("jdbc PreparedStatement did not close cleanly.");
                }
            }
        }

        return dialect;
    }
}