package org.hibernate.plugins.guards;

/**
 * @author vdedik@redhat.com
 */
public class MySQL5InnoDBGuard extends AbstractGuard {

    @Override
    public String safeGuardCreateTable(String sql) {
        return decorateWithIfNot("create table", sql);
    }

    @Override
    public String safeGuardDropTable(String sql) {
        return decorateWithIf("drop table", sql);
    }

    @Override
    public String safeGuardAlterTable(String sql) {
        return decorateWithExecuteIf(sql);
    }
}
