package org.hibernate.plugins.guards;

/**
 * @author vdedik@redhat.com
 */
public class Oracle10gGuard extends AbstractGuard {

    @Override
    public String safeGuardCreateTable(String sql) {
        return decorateWithExecuteIfNot(sql);
    }

    @Override
    public String safeGuardDropTable(String sql) {
        return decorateWithExecuteIf(sql);
    }

    @Override
    public String safeGuardCreateSequence(String sql) {
        return decorateWithExecuteIfNot(sql);
    }

    @Override
    public String safeGuardDropSequence(String sql) {
        return decorateWithExecuteIf(sql);
    }

    @Override
    public String safeGuardAlterTable(String sql) {
        return decorateWithExecuteIf(sql);
    }

    @Override
    public String decorateWithCall(String sql) {
        return "begin " + sql + "; end;";
    }
}
