package org.hibernate.plugins.guards;

import org.hibernate.plugins.util.Util;

/**
 * @author vdedik@redhat.com
 */
public class SQLServer2008Guard extends AbstractGuard {

    @Override
    public String safeGuardCreateTable(String sql) {
        if (Util.statementContains(sql, "if object_id")) {
            return sql;
        }
        return sql.replaceAll("(?i)create\\s+table\\s+(\\w+)", "if object_id('$1', 'U') is null create table $1");
    }

    @Override
    public String safeGuardDropTable(String sql) {
        if (Util.statementContains(sql, "if object_id")) {
            return sql;
        }
        return sql.replaceAll("(?i)drop\\s+table\\s+(\\w+)", "if object_id('$1', 'U') is not null drop table $1");
    }

    @Override
    public String safeGuardAlterTable(String sql) {
        if (Util.statementContains(sql, "if object_id")) {
            return sql;
        }
        return sql.replaceAll("(?i)alter\\s+table\\s+(\\w+)", "if object_id('$1', 'U') is not null alter table $1");
    }
}
