package com.redhat.installer.panels;

import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ConsoleInstaller;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.util.AbstractUIHandler;
import com.izforge.izpack.util.Shell;
import com.redhat.installer.util.JBossJDBCConstants;
import com.redhat.installer.util.JDBCConnectionUtils;

public class JBossJDBCDriverSetupPanelFSWConsoleHelper extends JBossJDBCDriverSetupPanelConsoleHelper implements PanelConsole
{
	public void makeXMLData(IXMLElement panelRoot, AutomatedInstallData idata)
	{
		new JBossJDBCDriverSetupPanelFSWAutomationHelper().makeXMLData(idata, panelRoot);
	}

	public boolean runConsole(AutomatedInstallData idata, ConsoleInstaller parent)
	{
		this.idata = idata;
		hasDriver = false;
		hasRemote = false;
		String product = idata.getVariable("product.name");
		//copied directly from GUI class. who needs inheritance when you have copy paste? /s
		boolean isEap = product != null ? product.equals("eap") : false;
		if (isEap){
			driverOptions =	createArray(JBossJDBCConstants.ibmVendorName, JBossJDBCConstants.oracleVendorName, JBossJDBCConstants.mysqlVendorName, JBossJDBCConstants.postgresqlVendorName, JBossJDBCConstants.sybaseVendorName, JBossJDBCConstants.microsoftVendorName);
		} else {
			driverOptions = createArray(JBossJDBCConstants.ibmVendorName, JBossJDBCConstants.oracleVendorName, JBossJDBCConstants.mysqlVendorName, JBossJDBCConstants.postgresqlVendorName, JBossJDBCConstants.microsoftVendorName);
		}
		chooseDriver();
		while(!enterJarPaths()){} // repeat this until the function reports false, which means the paths are chosen correctly
		
		do {
		setDbUser();
		enterDbPassword();
		setDbUrl();
		summarizeDbData();
		} while (testConnection());
		
	
		
		int i = askEndOfConsolePanel(idata);
		if (i == 1)
		{
			return true;
		}
		else if (i == 2)
		{
			return false;
		}
		else
		{
			return runConsole(idata, parent);
		}
	}
	// refactor this crap to JDBCConnectionUtils
	private boolean testConnection() {
		int answer = PanelConsoleHelper.askYesNo(idata.langpack.getString("db.test.connection")+"?", false); 
		if (answer == AbstractUIHandler.ANSWER_YES){
			if (!hasDriver){ 
				System.out.println(String.format(idata.langpack.getString("JBossJDBCDriverSetupPanelFSW.path.nodriver"), JBossJDBCConstants.classnameMap.get(idata.getVariable("jdbc.driver.name"))));
				return false;
			}
			
			// the driver exists; try to create a driver instance
			Driver jdbcDriver = null;
			URL[] jarUrls = JDBCConnectionUtils.convertToUrlArray(getJarPaths());
			Class<?> driverClass = JDBCConnectionUtils.findDriverClass(JBossJDBCConstants.classnameMap.get(idata.getVariable("jdbc.driver.name")), jarUrls);
			
			try {
				jdbcDriver = (Driver) driverClass.newInstance();
			} catch (InstantiationException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			}
			
			Object conn = JDBCConnectionUtils.getDatabaseConnection(jdbcDriver, idata.getVariable("db.user"),idata.getVariable("db.password"),idata.getVariable("db.url"));

			if (conn != null){
				try {
                    if (conn.getClass().equals(String.class)) {
                        System.out.println((String) conn);
                        return true;
                    }
                    ((Connection) conn).close();
				} catch (SQLException e) {
					e.printStackTrace();
				}
				System.out.println(idata.langpack.getString("db.test.success"));
				return false;
			} else {
				System.out.println(idata.langpack.getString("db.test.failure"));
				return true;
			}

		}	else {	
			return false;
		}
	}

	private Object[] getJarPaths() {
		ArrayList<String> jars = new ArrayList<String>(1);
		int counter = 1;
		while (true){
			String jar = idata.getVariable("jdbc.driver.jar-"+counter+"-path");
			if (jar != null){
				jars.add(jar);
			} else {
				// done 
				return jars.toArray();
			}
			counter++;
		}
	}

	protected void setDbUrl(){
		String prevChoice = idata.getVariable("db.url");
		Shell console = new Shell();
		boolean unset = true;
		
		if (prevChoice == null){
			// display the appropriate default for the given driver:
			prevChoice = idata.getVariable("jdbc.driver.console.vendor");
		}
		
		while (unset){
			try {
				String dbUrlPrompt = idata.langpack.getString("db.url.text");
				System.out.println(dbUrlPrompt + "["+prevChoice + "]");
				String input = null;
				input = console.getInput();
				if (!input.trim().isEmpty()){
					idata.setVariable("db.url", input);
					unset = false;
				} else {
					idata.setVariable("db.url", prevChoice); // default
					unset = false;
				}
			} catch (Exception e) {e.printStackTrace();}
		}
	}
		
	protected void setDbUser(){
		String prevChoice = idata.getVariable("db.user");
		Shell console = new Shell();
		boolean unset = true;
		
		if (prevChoice  == null){
			prevChoice = "";
		} 
		
		while (unset){
			try{
				String dbUserPrompt = idata.langpack.getString("db.username.text");
				System.out.println(dbUserPrompt + "[ " + prevChoice + " ]");
				String input = null;
				input = console.getInput();
				if (!input.trim().isEmpty()){
					idata.setVariable("db.user",input);
					unset = false;
				} else {
					idata.setVariable("db.user",prevChoice); // default
					unset = false;
				}
			} catch (Exception e) {e.printStackTrace();}
		}
	}

	// thanks for the inheritance IzPack /s

	protected void enterDbPassword() {
		String passwordPrompt = idata.langpack.getString("db.password.text");// "JBossDatasourceConfigPanel.password");
		String passwordReprompt = idata.langpack.getString("db.password.re.text");
		String prevPwd = idata.getVariable("db.password");// "jdbc.datasource.password");
		String noMatch = idata.langpack.getString("username.no.match.password");
		String set = "";
		Shell console = new Shell();
		
		if (prevPwd != null){
            for (int j = 0; j < prevPwd.length(); j++){
                set += "*";
            }
        } else {
            prevPwd = "";
        }
		String pwd = null;
		String pwdCheck = null;
		while (true) {
	    System.out.println(passwordPrompt + " [" + set + "]");
			try {
				pwd = new String(console.getPassword());
				if (pwd.equals("")) { pwd = prevPwd; }
				if (pwd.equals("")) { System.out.println("Please enter a password."); continue; }
			} catch (Exception e) {
                e.printStackTrace();
            }
		
    		// Produce new masked password
            set = "";
            for (int j = 0; j < pwd.length(); j++){
                set += "*";
            }
				

			System.out.println(passwordReprompt + " [" + set + "]");
			pwdCheck = new String(console.getPassword());
			if (pwdCheck.equals("")) { pwdCheck = prevPwd; }
			if (pwd.equals(pwdCheck)) { break; } 
			else { System.out.println(noMatch); continue; }
		}
		idata.setVariable("db.password", pwd);
	}
	
	protected void summarizeDbData(){
		System.out.println(idata.langpack.getString("db.title"));
		System.out.println(idata.langpack.getString("db.username.text") +  " " + idata.getVariable("db.user"));
		System.out.println(idata.langpack.getString("db.url.text") +  " " + idata.getVariable("db.url"));
	}

	/** 
	 * Code duplication from GUI version of this class.
	 */
	private String[] createArray(String ... array) {
		return array;
	}
}
