package com.redhat.installer.validator;

import java.util.HashMap;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;

public class FieldNotEqualValidator implements DataValidator {
    String errorMsg = "";
    public Status validateData(AutomatedInstallData adata) {
        String msgKey = "FieldNotEqualValidator.errorMsg";
        errorMsg = adata.langpack.getString(msgKey);
        errorMsg = errorMsg.length() == 0 || msgKey.equals(errorMsg) ? "Username and password cannot match" : errorMsg;
        String parseNames = adata.getVariable("FieldNotEqualValidator.check");
        HashMap<String, String> allMap = new HashMap<String,String>();
        if (parseNames==null) {
            return Status.OK;
        } else {
            for (String val : parseNames.split(",")){
                allMap.put(val, adata.getVariable(val));
            }
            if (!allMap.isEmpty()) {
                for (String keyCur : allMap.keySet()) {
                    for (String keyAll : allMap.keySet()) {
                        if (keyAll.equals(keyCur)) {
                            continue;
                        } else if (allMap.get(keyCur).equals(allMap.get(keyAll))) {
                            return Status.ERROR;
                        }
                    }
                }
                return Status.OK;
            } else {
                return Status.OK;
            }
        }
    }

    public String getErrorMessageId() {
        return errorMsg;
    }

    public String getWarningMessageId() {
        return null;
    }

    public boolean getDefaultAnswer() {
        return false;
    }
}
