package com.redhat.installer.validator;

import java.io.File;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;

/**
 * This class validates the fields given by the user, to make sure vault generation and vault creation succeed
 * @author thauser
 *
 */

public class VaultValidator implements DataValidator
{

	private String error;
	
	@Override
	public Status validateData(AutomatedInstallData adata) {
		// all of the other variables are validated in panel
		String path = adata.getVariable("vault.keystoreloc");
		File file = new File(path);
		if (file.exists()){
			setError(adata.langpack.getString("vault.path.existing"));
			return Status.ERROR;
		}
		return Status.OK;
	}

	private void setError(String string) {
		this.error = string;
		
	}

	@Override
	public String getErrorMessageId() {
		// TODO Auto-generated method stub
		return error;
	}

	@Override
	public String getWarningMessageId() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean getDefaultAnswer() {
		// TODO Auto-generated method stub
		return false;
	}

}
