#!/bin/sh

get_abs_filename() {
  # $1 : relative filename
  echo "$(cd "$(dirname "$1")" && pwd)/$(basename "$1")"
}

INSTALL_DB=FALSE
ANT_ARGS=

while [[ $# -gt 0 ]]
do
   case $1 in
      --setup-db)
         INSTALL_DB=TRUE
         ;;
      *)
         ANT_ARGS=$ANT_ARGS $1
    esac
    shift
done

SCRIPT_HOME=$(get_abs_filename `dirname $0`)
EAP_HOME=$(get_abs_filename ${SCRIPT_HOME}/../../..)
ANT_HOME=$(get_abs_filename ${EAP_HOME}/lib)

java -Dant.home=${ANT_HOME} -Dpath=${EAP_HOME} -Dappserver.id=jboss-eap-64 -cp ${ANT_HOME}/ant-launcher-1.8.3.jar org.apache.tools.ant.launch.Launcher -q -f ${SCRIPT_HOME}/platforms/jboss-eap-64/all/build.xml $ANT_ARGS install

if [ "$INSTALL_DB" == "TRUE" ]
then
   H2_HOME=$(get_abs_filename ${EAP_HOME}/modules/system/layers/base/com/h2database/h2/main)
   H2_JAR=`ls ${H2_HOME}/h2-*.jar | head -1`
   DATA_DIR=$(get_abs_filename ${EAP_HOME}/standalone/data)

   echo "Setting up H2 database jdbc:h2:${DATA_DIR}/h2/rtgov"
   java -cp ${H2_JAR} org.h2.tools.RunScript -url jdbc:h2:${DATA_DIR}/h2/rtgov -script ${EAP_HOME}/sql/rtgov/overlord-rtgov.H2Dialect.sql
fi
