/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt.record.impl;

import com.sap.conn.idoc.IDocFieldNotFoundException;
import com.sap.conn.idoc.rt.record.ExtendedFieldMetaData;
import com.sap.conn.idoc.rt.record.RecordConstants;
import com.sap.conn.idoc.rt.record.RecordMetaData;
import com.sap.conn.idoc.rt.record.impl.AbstractMetaData;

public class DefaultRecordMetaData
extends AbstractMetaData
implements RecordMetaData {
    private static final long serialVersionUID = 1000L;
    protected int[][] offset = new int[][]{RecordConstants.EMPTY_INT_ARRAY, RecordConstants.EMPTY_INT_ARRAY};

    protected DefaultRecordMetaData(String name) {
        super(name);
    }

    protected DefaultRecordMetaData(String name, int capacity) {
        super(name);
        this.ensureCapacity(capacity);
    }

    DefaultRecordMetaData(RecordMetaData obj) {
        super(obj.getName());
        this.ensureCapacity(obj.getFieldCount());
        this.copy(obj);
        for (int i = 0; i < this.numFields; ++i) {
            if (this.tabMeta[i] == null || this.tabMeta[i] instanceof String) continue;
            this.tabMeta[i] = this.tabMeta[i] instanceof RecordMetaData ? new DefaultRecordMetaData((RecordMetaData)this.tabMeta[i]) : null;
        }
    }

    public void ensureCapacity(int capacity) {
        if (this.name.length >= capacity) {
            return;
        }
        super.ensureCapacity(capacity);
        int[][] oldOffset = this.offset;
        this.offset = new int[2][capacity];
        System.arraycopy(oldOffset[0], 0, this.offset[0], 0, this.numFields);
        System.arraycopy(oldOffset[1], 0, this.offset[1], 0, this.numFields);
    }

    protected void copy(RecordMetaData obj) {
        if (obj == null) {
            return;
        }
        super.copy(obj);
        this.setRecordLength(obj.getRecordLength(), obj.getUnicodeRecordLength());
        if (obj instanceof DefaultRecordMetaData) {
            DefaultRecordMetaData meta = (DefaultRecordMetaData)obj;
            System.arraycopy(meta.offset[0], 0, this.offset[0], 0, this.numFields);
            System.arraycopy(meta.offset[1], 0, this.offset[1], 0, this.numFields);
        } else {
            int n = obj.getFieldCount();
            for (int i = 0; i < n; ++i) {
                this.add(obj.getName(i), obj.getType(i), obj.getByteLength(i), obj.getUnicodeByteLength(i), obj.getByteOffset(i), obj.getUnicodeByteOffset(i), obj.getDecimals(i), obj.getDescription(i), obj.getRecordTypeName(i), obj.getExtendedFieldMetaData(i));
            }
        }
    }

    public void add(String name, int type, int byteLength, int byteOffset, int unicodeByteLength, int unicodeOffset) {
        this.add(name, type, byteLength, byteOffset, unicodeByteLength, unicodeOffset, 0, null, null, null);
    }

    public void add(String name, int type, int nucByteLength, int nucByteOffset, int ucByteLength, int ucByteOffset, int decimals, String description, Object recordMetaData, ExtendedFieldMetaData extended) {
        super.add(name, type, nucByteLength, ucByteLength, decimals, description, recordMetaData, extended);
        if (nucByteOffset < 0) {
            int n = nucByteOffset = this.numFields > 0 ? this.offset[0][this.numFields - 1] + this.length[0][this.numFields - 1] : 0;
        }
        if (ucByteOffset < 0) {
            ucByteOffset = this.numFields > 0 ? this.offset[1][this.numFields - 1] + this.length[1][this.numFields - 1] : 0;
        }
        this.offset[0][this.numFields - 1] = nucByteOffset;
        this.offset[1][this.numFields - 1] = ucByteOffset;
    }

    public int getUnicodeRecordLength() {
        return this.tabLength[1];
    }

    public int getRecordLength() {
        return this.tabLength[0];
    }

    public void setRecordLength(int tabNUCLength, int tabUCLength) {
        if (this.isLocked()) {
            throw new UnsupportedOperationException("The JCoMetaData object " + this.name + " is already locked. Changing it is no longer possible");
        }
        this.tabLength[0] = tabNUCLength;
        this.tabLength[1] = tabUCLength;
    }

    public int getUnicodeByteOffset(int index) {
        this.checkIndex(index);
        return this.offset[1][index];
    }

    public int getUnicodeByteOffset(String fieldName) throws IDocFieldNotFoundException {
        return this.offset[1][this.indexOf(fieldName)];
    }

    public int getByteOffset(int index) {
        super.checkIndex(index);
        return this.offset[0][index];
    }

    public int getByteOffset(String fieldName) throws IDocFieldNotFoundException {
        return this.offset[0][this.indexOf(fieldName)];
    }

    public int getOffset(int index) {
        return this.getByteOffset(index);
    }

    public int getOffset(String fieldName) throws IDocFieldNotFoundException {
        return this.getByteOffset(fieldName);
    }

    protected String toString(int level) {
        int k;
        int n = this.getFieldCount();
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            int l;
            for (k = 0; k < level * 10; ++k) {
                s.append(' ');
            }
            s.append(this.name[i]);
            for (k = l = this.name[i].length(); k < 32; ++k) {
                s.append(' ');
            }
            s.append(',');
            if (this.tabMeta[i] != null) {
                if (this.tabMeta[i] instanceof String) {
                    s.append((String)((Object)this.tabMeta[i]));
                    for (k = l = ((String)((Object)this.tabMeta[i])).length(); k < 32; ++k) {
                        s.append(' ');
                    }
                } else if (this.tabMeta[i] instanceof DefaultRecordMetaData) {
                    String name = ((DefaultRecordMetaData)this.tabMeta[i]).getName();
                    s.append(name);
                    for (k = l = name.length(); k < 32; ++k) {
                        s.append(' ');
                    }
                } else {
                    for (k = 0; k < 32; ++k) {
                        s.append(' ');
                    }
                }
            } else {
                for (k = 0; k < 32; ++k) {
                    s.append(' ');
                }
            }
            s.append(',');
            s.append(DefaultRecordMetaData.getJCOTypeChar(this.type[i]));
            s.append(',');
            s.append(this.blength[i]);
            s.append(',');
            s.append(this.boffset[i]);
            s.append(',');
            s.append(this.length[0][i]);
            s.append(',');
            s.append(this.offset[0][i]);
            s.append(',');
            s.append(this.length[1][i]);
            s.append(',');
            s.append(this.offset[1][i]);
            s.append(',');
            s.append(this.decimals[i]);
            if (this.description != null) {
                s.append(',');
                s.append(this.getDescription(i) != null ? this.getDescription(i) : " ");
            }
            if (this.tabMeta[i] != null && this.tabMeta[i] instanceof DefaultRecordMetaData) {
                s.append(RecordConstants.CRLF);
                s.append(((DefaultRecordMetaData)this.tabMeta[i]).toString(level + 1));
                continue;
            }
            if (this.tabMeta[i] != null && this.tabMeta[i] instanceof String) {
                s.append(',');
                s.append((String)((Object)this.tabMeta[i]));
                s.append(RecordConstants.CRLF);
                continue;
            }
            s.append(RecordConstants.CRLF);
        }
        for (k = 0; k < level * 10; ++k) {
            s.append(' ');
        }
        s.append("Record length: ").append(this.tabLength[0]).append(',').append(this.tabLength[1]).append(RecordConstants.CRLF);
        return s.toString();
    }
}

