/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt;

import com.sap.conn.idoc.IDocConversionException;
import com.sap.conn.idoc.IDocDatatype;
import com.sap.conn.idoc.IDocFieldNotFoundException;
import com.sap.conn.idoc.IDocRecord;
import com.sap.conn.idoc.IDocRecordMetaData;
import com.sap.conn.idoc.IDocSyntaxException;
import com.sap.conn.idoc.rt.DefaultIDocFieldMetaData;
import com.sap.conn.idoc.rt.DefaultIDocRecordMetaData;
import com.sap.conn.idoc.rt.record.impl.AbstractRecord;
import java.io.Serializable;

public class BasicIDocRecord
extends AbstractRecord
implements IDocRecord,
Serializable {
    private static final long serialVersionUID = 1000L;
    protected boolean m_checkFieldValuesOnSet = false;
    protected DefaultIDocRecordMetaData recordMetaData = null;

    public BasicIDocRecord(int type, IDocRecordMetaData recordMetaData) {
        super(type, (DefaultIDocRecordMetaData)recordMetaData);
        this.recordMetaData = (DefaultIDocRecordMetaData)recordMetaData;
    }

    public BasicIDocRecord(IDocRecordMetaData recordMetaData) {
        this(1, (DefaultIDocRecordMetaData)recordMetaData);
    }

    public void checkFieldMatchingDatatype(int index) throws IDocConversionException {
        int fieldCount = this.metaData.getFieldCount();
        if (index < 0) {
            throw new IndexOutOfBoundsException("index < 0 [" + index + "<0]");
        }
        if (index >= fieldCount) {
            throw new IndexOutOfBoundsException("index >= getNumFields() [" + index + ">=" + fieldCount + "]");
        }
        if (this.isInitialized(index) && !this.recordMetaData.isValueMatchingDatatype(index, this.getString(index))) {
            throw new IDocConversionException(this, this.getName(index), "Value of segment field \"" + this.getName(index) + "\" cannot be converted to datatype " + (Object)((Object)this.recordMetaData.getDatatype(index)) + ".");
        }
    }

    public void checkFieldValue(int index) throws IDocSyntaxException {
        this.checkFieldValue(index, true);
    }

    public void checkFieldValue(int index, boolean checkDatatype) throws IDocSyntaxException {
        int fieldCount = this.metaData.getFieldCount();
        if (index < 0) {
            throw new IndexOutOfBoundsException("index < 0 [" + index + "<0]");
        }
        if (index >= fieldCount) {
            throw new IndexOutOfBoundsException("index >= getNumFields() [" + index + ">=" + fieldCount + "]");
        }
        if (this.isInitialized(index) && !this.recordMetaData.isValidValue(index, this.getString(index), checkDatatype)) {
            throw new IDocSyntaxException(this, this.getName(index), "Invalid value for segment field \"" + this.getName(index) + "\".");
        }
    }

    public void checkFieldValues() throws IDocSyntaxException {
        this.checkFieldValues(true);
    }

    public void checkFieldValues(boolean checkDatatype) throws IDocSyntaxException {
        int numFields = this.metaData.getFieldCount();
        for (int i = 0; i < numFields; ++i) {
            if (!this.isInitialized(i) || this.recordMetaData.isValidValue(i, this.getString(i), checkDatatype)) continue;
            throw new IDocSyntaxException(this, this.getName(i), "Invalid value for segment field \"" + this.getName(i) + "\".");
        }
    }

    public void disableFieldValueChecking() {
        this.m_checkFieldValuesOnSet = false;
    }

    public void enableFieldValueChecking() {
        this.m_checkFieldValuesOnSet = true;
    }

    public DefaultIDocFieldMetaData getFieldMetaData(int index) {
        return (DefaultIDocFieldMetaData)this.metaData.getExtendedFieldMetaData(index);
    }

    public DefaultIDocFieldMetaData getFieldMetaData(String name) throws IDocFieldNotFoundException {
        return (DefaultIDocFieldMetaData)this.metaData.getExtendedFieldMetaData(name);
    }

    public int getLength() {
        return this.recordMetaData.getRecordLength();
    }

    public String getName(int index) {
        int num_fields = this.metaData.getFieldCount();
        if (index < 0) {
            throw new IndexOutOfBoundsException("index < 0 [" + index + "<0]");
        }
        if (index >= num_fields) {
            throw new IndexOutOfBoundsException("index >= getNumFields() [" + index + ">=" + num_fields + "]");
        }
        return this.metaData.getName(index);
    }

    public int getNumFields() {
        return this.metaData.getFieldCount();
    }

    public Object getValue(int index) throws IDocConversionException {
        IDocDatatype fieldDatatype;
        int num_fields = this.metaData.getFieldCount();
        if (index < 0) {
            throw new IndexOutOfBoundsException("index < 0 [" + index + "<0]");
        }
        if (index >= num_fields) {
            throw new IndexOutOfBoundsException("index >= getNumFields() [" + index + ">=" + num_fields + "]");
        }
        DefaultIDocFieldMetaData fieldMetaData = this.getFieldMetaData(index);
        if (fieldMetaData != null && (fieldDatatype = fieldMetaData.getDatatype()) != null) {
            if (fieldDatatype == IDocDatatype.STRING) {
                return this.getString(index);
            }
            if (fieldDatatype == IDocDatatype.NUMERIC) {
                return this.getString(index);
            }
            if (fieldDatatype == IDocDatatype.INTEGER) {
                return this.getBigInteger(index);
            }
            if (fieldDatatype == IDocDatatype.DECIMAL) {
                return this.getBigDecimal(index);
            }
            if (fieldDatatype == IDocDatatype.DATE) {
                return this.getDate(index);
            }
            if (fieldDatatype == IDocDatatype.TIME) {
                return this.getTime(index);
            }
            if (fieldDatatype == IDocDatatype.BINARY) {
                return this.getByteArray(index);
            }
        }
        return this.getString(index);
    }

    public IDocRecordMetaData getRecordMetaData() {
        return (IDocRecordMetaData)((Object)this.metaData);
    }

    public boolean isFieldValueCheckingEnabled() {
        return this.m_checkFieldValuesOnSet;
    }

    public void setValue(int index, byte[] value) throws IDocConversionException, IDocSyntaxException {
        super.setValue(index, value);
        this.checkFieldMatchingDatatype(index);
        if (this.m_checkFieldValuesOnSet) {
            this.checkFieldValue(index, false);
        }
    }

    public void setValue(int index, char value) throws IDocConversionException, IDocSyntaxException {
        super.setValue(index, value);
        this.checkFieldMatchingDatatype(index);
        if (this.m_checkFieldValuesOnSet) {
            this.checkFieldValue(index, false);
        }
    }

    public void setValue(int index, double value) throws IDocConversionException, IDocSyntaxException {
        super.setValue(index, value);
        this.checkFieldMatchingDatatype(index);
        if (this.m_checkFieldValuesOnSet) {
            this.checkFieldValue(index, false);
        }
    }

    public void setValue(int index, int value) throws IDocConversionException, IDocSyntaxException {
        super.setValue(index, value);
        this.checkFieldMatchingDatatype(index);
        if (this.m_checkFieldValuesOnSet) {
            this.checkFieldValue(index, false);
        }
    }

    public void setValue(int index, long value) throws IDocConversionException, IDocSyntaxException {
        super.setValue(index, value);
        this.checkFieldMatchingDatatype(index);
        if (this.m_checkFieldValuesOnSet) {
            this.checkFieldValue(index, false);
        }
    }

    public void setValue(int index, Object value) throws IDocConversionException, IDocSyntaxException {
        super.setValue(index, value);
        this.checkFieldMatchingDatatype(index);
        if (this.m_checkFieldValuesOnSet) {
            this.checkFieldValue(index, false);
        }
    }

    public void setValue(int index, short value) throws IDocConversionException, IDocSyntaxException {
        super.setValue(index, value);
        this.checkFieldMatchingDatatype(index);
        if (this.m_checkFieldValuesOnSet) {
            this.checkFieldValue(index, false);
        }
    }

    public void setValue(int index, String value) throws IDocConversionException, IDocSyntaxException {
        super.setValue(index, value);
        this.checkFieldMatchingDatatype(index);
        if (this.m_checkFieldValuesOnSet) {
            this.checkFieldValue(index, false);
        }
    }

    public void setValue(String name, byte[] value) throws IDocFieldNotFoundException, IDocConversionException, IDocSyntaxException {
        this.setValue(this.indexOf(name), value);
    }

    public void setValue(String name, char value) throws IDocFieldNotFoundException, IDocConversionException, IDocSyntaxException {
        this.setValue(this.indexOf(name), value);
    }

    public void setValue(String name, double value) throws IDocFieldNotFoundException, IDocConversionException, IDocSyntaxException {
        this.setValue(this.indexOf(name), value);
    }

    public void setValue(String name, int value) throws IDocFieldNotFoundException, IDocConversionException, IDocSyntaxException {
        this.setValue(this.indexOf(name), value);
    }

    public void setValue(String name, long value) throws IDocFieldNotFoundException, IDocConversionException, IDocSyntaxException {
        this.setValue(this.indexOf(name), value);
    }

    public void setValue(String name, Object value) throws IDocFieldNotFoundException, IDocConversionException, IDocSyntaxException {
        this.setValue(this.indexOf(name), value);
    }

    public void setValue(String name, short value) throws IDocFieldNotFoundException, IDocConversionException, IDocSyntaxException {
        this.setValue(this.indexOf(name), value);
    }

    public void setValue(String name, String value) throws IDocFieldNotFoundException, IDocConversionException, IDocSyntaxException {
        this.setValue(this.indexOf(name), value);
    }

    void setValueWithoutCheck(int index, String value) throws IDocConversionException, IDocSyntaxException {
        super.setValue(index, value);
    }

    public Object clone() {
        return super.clone();
    }
}

