/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt.record.impl;

import com.sap.conn.idoc.IDocConversionException;
import com.sap.conn.idoc.IDocFieldNotFoundException;
import com.sap.conn.idoc.IDocRecord;
import com.sap.conn.idoc.IDocRuntimeException;
import com.sap.conn.idoc.IDocSyntaxException;
import com.sap.conn.idoc.rt.record.MetaDataBase;
import com.sap.conn.idoc.rt.record.Record;
import com.sap.conn.idoc.rt.record.RecordConstants;
import com.sap.conn.idoc.rt.record.RecordMetaData;
import com.sap.conn.idoc.rt.record.impl.AbstractMetaData;
import com.sap.conn.idoc.rt.record.impl.DefaultRecordMetaData;
import com.sap.conn.idoc.rt.trace.Trace;
import com.sap.conn.idoc.rt.util.SyncDateFormat;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;

public abstract class AbstractRecord
implements Record,
Serializable,
Cloneable {
    static final long serialVersionUID = 1000L;
    protected static final byte PARAMETER = 1;
    protected static final byte STRUCTURE = 2;
    protected static final byte TABLE = 4;
    protected static final byte SEGMENT = 8;
    protected static final byte REQUEST = 16;
    protected static final byte RESPONSE = 32;
    protected byte recType = 1;
    public static final int UNINITIALIZED_PARAMETER = 1;
    protected AbstractMetaData metaData = null;
    protected char[] data = RecordConstants.EMPTY_CHAR_ARRAY;
    protected char[][] tableDataRows = null;
    protected Object[] odata = RecordConstants.EMPTY_OBJ_ARRAY;
    protected byte[] flags = RecordConstants.EMPTY_BYTE_ARRAY;
    protected byte[] opcode = RecordConstants.EMPTY_BYTE_ARRAY;
    protected int[] delta = null;
    protected int rowLength = 0;
    protected int numRows = 0;
    protected int row = 0;
    protected boolean modified = false;
    protected static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected static final SyncDateFormat daterfc = new SyncDateFormat("yyyyMMdd");
    protected static final SyncDateFormat dateiso = new SyncDateFormat("yyyy-MM-dd");
    protected static final SyncDateFormat timerfc = new SyncDateFormat("HHmmss");
    protected static final SyncDateFormat timeiso = new SyncDateFormat("HH:mm:ss");

    AbstractRecord(MetaDataBase metaData) {
        this(1, metaData);
    }

    protected AbstractRecord(int recType, MetaDataBase metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException("metaData equals null is passed into Record");
        }
        if (!metaData.isLocked()) {
            throw new IllegalArgumentException("The metaData is not locked. Only locked instances are allowed. Use the JCoMetaData.lock() API.");
        }
        if (metaData instanceof AbstractMetaData) {
            this.metaData = (AbstractMetaData)metaData;
        } else if (metaData instanceof RecordMetaData) {
            this.metaData = new DefaultRecordMetaData((RecordMetaData)metaData);
        } else {
            throw new IllegalArgumentException(new StringBuilder(150).append("The metaData is neither an instance of JCoRecordMetaData nor of JCoListMetaData. ").append(metaData.getClass().getName()).append(" is passed into Record").toString());
        }
        this.recType = (byte)recType;
        this.numRows = (this.recType & 4) != 0 ? 0 : 1;
        this.ensureBufferCapacity();
    }

    protected AbstractRecord(AbstractRecord value) {
        this(value.getBaseMetaData());
        this.copyContent(value);
    }

    public Object clone() {
        try {
            AbstractRecord obj = (AbstractRecord)super.clone();
            obj.copyContent(this);
            return obj;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractRecord)) {
            return false;
        }
        AbstractRecord rec = (AbstractRecord)obj;
        if (!this.metaData.equals(rec.metaData)) {
            return false;
        }
        if (this.numRows != rec.numRows) {
            return false;
        }
        if (this.recType != rec.recType) {
            return false;
        }
        if (this.metaData.numOdata != rec.metaData.numOdata) {
            return false;
        }
        if (this.metaData.tabLength[1] != rec.metaData.tabLength[1]) {
            return false;
        }
        if (this.metaData.tabLength[0] != rec.metaData.tabLength[0]) {
            return false;
        }
        if (this.rowLength > 0) {
            for (int rowId = 0; rowId < this.numRows; ++rowId) {
                char[] d2;
                char[] d1;
                if ((this.recType & 4) != 0) {
                    d1 = this.tableDataRows[rowId];
                    d2 = rec.tableDataRows[rowId];
                } else {
                    d1 = this.data;
                    d2 = rec.data;
                }
                for (int i = 0; i < this.rowLength; ++i) {
                    if (d1[i] == d2[i]) continue;
                    return false;
                }
            }
        }
        int size = this.numRows * this.metaData.numOdata;
        for (int i = 0; i < size; ++i) {
            if (this.odata[i] == null && rec.odata[i] == null) continue;
            if (this.odata[i] == null && rec.odata[i] != null || this.odata[i] != null && rec.odata[i] == null) {
                return false;
            }
            if (this.odata[i] instanceof AbstractRecord || this.odata[i] instanceof String) {
                if (this.odata[i].equals(rec.odata[i])) continue;
                return false;
            }
            if (this.odata[i] instanceof byte[]) {
                if (Arrays.equals((byte[])this.odata[i], (byte[])rec.odata[i])) continue;
                return false;
            }
            if (this.odata[i] == null) continue;
            Trace.fireTraceCritical(new StringBuilder(120).append("[IDocRT] AbstractRecord.equals() Unknown object type inside JCO.Record:").append(this.odata[i].getClass().getName()).toString());
        }
        return true;
    }

    public int hashCode() {
        int hashcode = this.getBaseMetaData().hashCode();
        if (this.rowLength > 0) {
            for (int rowId = 0; rowId < this.numRows; ++rowId) {
                char[] data = (this.recType & 4) != 0 ? this.tableDataRows[rowId] : this.data;
                for (int i = 0; i < this.rowLength; ++i) {
                    hashcode = 31 * hashcode + data[i];
                }
            }
        }
        int size = this.numRows * this.metaData.numOdata;
        for (int i = 0; i < size; ++i) {
            if (this.odata[i] == null) continue;
            hashcode = 31 * hashcode + this.odata[i].hashCode();
        }
        return hashcode;
    }

    protected int getObjectId() {
        return System.identityHashCode(this);
    }

    public void copyContent(AbstractRecord src) {
        int i;
        this.recType = src.recType;
        this.numRows = src.numRows;
        this.row = src.row;
        this.modified = src.modified;
        if (this.rowLength > 0) {
            if (src.tableDataRows != null) {
                this.tableDataRows = new char[src.tableDataRows.length][];
                for (i = 0; i < src.numRows; ++i) {
                    this.tableDataRows[i] = (char[])src.tableDataRows[i].clone();
                }
            } else if (src.data != null) {
                this.data = (char[])src.data.clone();
            }
        }
        if (src.delta != null) {
            this.delta = (int[])src.delta.clone();
        }
        if (src.opcode != null && src.opcode.length > 0) {
            this.opcode = (byte[])src.opcode.clone();
        }
        if (src.odata != null && src.odata.length > 0) {
            this.odata = new Object[src.odata.length];
            for (i = 0; i < this.odata.length; ++i) {
                Object o = src.odata[i];
                if (o != null) {
                    if (o instanceof AbstractRecord) {
                        o = ((AbstractRecord)o).clone();
                    } else if (o instanceof byte[]) {
                        o = ((byte[])o).clone();
                    }
                }
                this.odata[i] = o;
            }
        }
    }

    protected IDocConversionException createConversionException(int index, String to_type) {
        return new IDocConversionException((IDocRecord)((Object)this), this.metaData.name[index], new StringBuilder(200).append("Cannot convert field ").append(this.metaData.name[index]).append(" of type ").append(AbstractMetaData.getJCOTypeString(this.metaData.type[index])).append(" to type ").append(to_type).toString());
    }

    protected IDocConversionException createConversionException(int index, String from_type, String value) {
        if (value != null) {
            return new IDocConversionException((IDocRecord)((Object)this), this.metaData.name[index], new StringBuilder(200).append("Cannot convert value '").append(value).append("' from type ").append(from_type).append(" to type ").append(AbstractMetaData.getJCOTypeString(this.metaData.type[index])).append(" at field ").append(this.metaData.name[index]).toString());
        }
        return new IDocConversionException((IDocRecord)((Object)this), this.metaData.name[index], new StringBuilder(200).append("Cannot convert a value from type ").append(from_type).append(" to type ").append(AbstractMetaData.getJCOTypeString(this.metaData.type[index])).append(" at field ").append(this.metaData.name[index]).toString());
    }

    public int indexOf(String fieldName) throws IDocFieldNotFoundException {
        try {
            return this.metaData.indexOf(fieldName);
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocFieldNotFoundException((IDocRecord)((Object)this), fieldName, new StringBuilder(100).append("Field \"").append(fieldName).append("\" is not a member of IDocRecord \"").append(this.metaData.recName).append("\".").toString());
        }
    }

    protected void setModified(int row) {
        this.modified = true;
    }

    protected final boolean checkIfInitialized() {
        int i;
        boolean isInitialized = false;
        block4: for (i = 0; i < this.metaData.numFields; ++i) {
            switch (this.metaData.type[i]) {
                case 17: {
                    AbstractRecord rec = (AbstractRecord)this.odata[this.metaData.oindex[i]];
                    if (!rec.checkIfInitialized() && !rec.modified) continue block4;
                    int n = i;
                    this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
                    isInitialized = true;
                    continue block4;
                }
                case 99: {
                    int n = i;
                    this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
                    isInitialized = true;
                    continue block4;
                }
            }
        }
        for (i = 0; i < this.metaData.numFields && !isInitialized; ++i) {
            isInitialized = (this.flags[i] & 1) == 0;
        }
        return isInitialized;
    }

    protected String getDefaultValue(int index) {
        return null;
    }

    protected void initializeRow(int irow) {
        int row_save = this.row;
        this.row = irow;
        String defval = null;
        char[] data = null;
        if (this.rowLength > 0) {
            data = (this.recType & 4) != 0 ? this.tableDataRows[irow] : this.data;
        }
        for (int ifield = 0; ifield < this.metaData.numFields; ++ifield) {
            int ilength;
            int ioffset;
            int i;
            int iend;
            int istart;
            byte itype = this.metaData.type[ifield];
            defval = this.getDefaultValue(ifield);
            if (itype == 0 || itype == 17 || itype == 99 || itype == 29 || itype == 30) {
                istart = this.metaData.boffset[ifield];
                iend = istart + this.metaData.blength[ifield];
                for (i = istart; i < iend; ++i) {
                    data[i] = 32;
                }
                if (itype != 0 || defval == null) continue;
                ioffset = this.metaData.boffset[ifield];
                ilength = Math.min(this.metaData.blength[ifield], defval.length());
                defval.getChars(0, ilength, data, ioffset);
                continue;
            }
            if (itype != 1 && itype != 3 && itype != 6) continue;
            istart = this.metaData.boffset[ifield];
            iend = istart + this.metaData.blength[ifield];
            for (i = istart; i < iend; ++i) {
                data[i] = 48;
            }
            if (defval == null) continue;
            ioffset = this.metaData.boffset[ifield];
            ilength = Math.min(this.metaData.blength[ifield], defval.length());
            defval.getChars(0, ilength, data, ioffset);
        }
        this.row = row_save;
    }

    protected void ensureBufferCapacity() {
        Object[] old_odata = null;
        char[] old_data = null;
        boolean should_init = false;
        if (this.metaData.numFields > 0) {
            this.rowLength = this.metaData.boffset[this.metaData.numFields - 1] + this.metaData.blength[this.metaData.numFields - 1];
        }
        if (this.numRows == 0) {
            return;
        }
        if (this.odata == null || this.odata.length < this.metaData.numOdata) {
            if (this.odata != null && this.odata.length > 0) {
                old_odata = this.odata;
            }
            this.odata = new Object[this.metaData.numOdata];
            should_init = true;
        }
        if (this.data == null || this.data.length < this.rowLength) {
            if (this.data != null && this.data.length > 0) {
                old_data = this.data;
            }
            this.data = new char[this.rowLength];
            should_init = true;
        }
        if (should_init) {
            this.initializeRow(0);
            if (old_data != null && old_data.length > 0) {
                System.arraycopy(old_data, 0, this.data, 0, old_data.length);
            }
            if (old_odata != null && old_odata.length > 0) {
                System.arraycopy(old_odata, 0, this.odata, 0, old_odata.length);
            }
        }
        if (this.flags.length < this.metaData.numFields) {
            byte[] newFlags = new byte[this.metaData.numFields];
            if (this.flags.length > 0) {
                System.arraycopy(this.flags, 0, newFlags, 0, this.flags.length);
            }
            this.flags = newFlags;
        }
    }

    protected final void checkRowCapacity() {
        if ((this.recType & 4) != 0 && this.numRows == 0) {
            throw new IllegalStateException("Trying to access row values in a table which does not have any rows yet");
        }
    }

    protected char[] getRawBuffer() {
        return this.data;
    }

    protected int getRawBufferLength() {
        return this.rowLength;
    }

    public void clear() {
        this.initializeRow(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copyFrom(Record sourceRecord) {
        AbstractRecord source = (AbstractRecord)sourceRecord;
        if (source == null || source.metaData == null || source.metaData.numFields == 0 || source.numRows == 0) {
            return 0;
        }
        if (source.metaData.numFields == this.metaData.numFields) {
            boolean metadata_equals = true;
            if (source.metaData != this.metaData) {
                for (int i = 0; i < source.metaData.numFields; ++i) {
                    if (source.metaData.type[i] == this.metaData.type[i] && source.metaData.name[i].equals(this.metaData.name[i]) && source.metaData.boffset[i] == this.metaData.boffset[i] && source.metaData.blength[i] == this.metaData.blength[i]) continue;
                    metadata_equals = false;
                    break;
                }
            }
            if (metadata_equals) {
                this.ensureBufferCapacity();
                if (this.rowLength > 0) {
                    System.arraycopy(source.data, source.metaData.boffset[0], this.data, this.metaData.boffset[0], source.rowLength);
                }
                int dst_idx = 0;
                int src_idx = source.row * source.metaData.numOdata;
                int count = this.metaData.numOdata;
                int i = 0;
                while (i < count) {
                    if (source.odata[src_idx] != null) {
                        if (source.odata[src_idx] instanceof String) {
                            this.odata[dst_idx] = source.odata[src_idx];
                        } else if (source.odata[src_idx] instanceof AbstractRecord) {
                            this.odata[dst_idx] = ((AbstractRecord)source.odata[src_idx]).clone();
                        } else if (source.odata[src_idx] instanceof byte[]) {
                            this.odata[dst_idx] = ((byte[])source.odata[src_idx]).clone();
                        } else {
                            Trace.fireTraceCritical(new StringBuilder(120).append("[IDocRT] Record.copyFrom() unknown type ").append(source.odata[src_idx].getClass().getName()).append(" in ").append(this.metaData.recName).toString());
                        }
                    }
                    ++i;
                    ++dst_idx;
                    ++src_idx;
                }
                this.numRows = 1;
                for (i = 0; i < this.metaData.numFields; ++i) {
                    if ((source.flags[i] & 1) != 0) {
                        int n = i;
                        this.flags[n] = (byte)(this.flags[n] | 1);
                        continue;
                    }
                    int n = i;
                    this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
                }
                this.modified = true;
                return this.metaData.numFields;
            }
        }
        int n = 0;
        int[] index = new int[source.metaData.numFields];
        int irow_save = source.row;
        int jrow_save = this.row;
        int jnum_rows_save = this.numRows;
        boolean modified_save = this.modified;
        char[] data_save = null;
        char[] temp_src_data = null;
        char[] temp_dst_data = null;
        Object table_data_rows_save = null;
        Object[] odata_save = null;
        byte[] opcode_save = null;
        byte[] flags_save = null;
        try {
            int j;
            int i;
            n = 0;
            block16: for (i = 0; i < source.metaData.numFields; ++i) {
                index[i] = -1;
                for (j = 0; j < this.metaData.numFields; ++j) {
                    if (source.metaData.type[i] != this.metaData.type[j] || !source.metaData.name[i].equals(this.metaData.name[j])) continue;
                    index[i] = j;
                    ++n;
                    continue block16;
                }
            }
            if (n == 0) {
                int n2 = n;
                return n2;
            }
            if (this.flags != null) {
                flags_save = new byte[this.flags.length];
                System.arraycopy(this.flags, 0, flags_save, 0, this.flags.length);
            }
            if (this.data != null) {
                data_save = new char[this.data.length];
                System.arraycopy(this.data, 0, data_save, 0, this.data.length);
            }
            if (this.tableDataRows != null) {
                table_data_rows_save = new char[this.tableDataRows.length][];
                System.arraycopy(this.tableDataRows, 0, table_data_rows_save, 0, this.tableDataRows.length);
            }
            if (this.odata != null) {
                odata_save = new Object[this.odata.length];
                System.arraycopy(this.odata, 0, odata_save, 0, this.odata.length);
            }
            if (this.opcode != null) {
                opcode_save = new byte[this.opcode.length];
                System.arraycopy(this.opcode, 0, opcode_save, 0, this.opcode.length);
            }
            this.ensureBufferCapacity();
            for (i = 0; i < source.metaData.numFields; ++i) {
                j = index[i];
                if (j < 0) continue;
                this.row = (this.recType & 4) != 0 ? jnum_rows_save : 0;
                byte itype = source.metaData.type[i];
                int ioffset = source.metaData.boffset[i];
                int ilength = source.metaData.blength[i];
                int joffset = this.metaData.boffset[j];
                int jlength = this.metaData.blength[j];
                ilength = Math.min(ilength, jlength);
                if ((source.flags[i] & 1) != 0) {
                    int n3 = j;
                    this.flags[n3] = (byte)(this.flags[n3] | 1);
                } else {
                    int n4 = j;
                    this.flags[n4] = (byte)(this.flags[n4] & 0xFFFFFFFE);
                }
                source.row = 0;
                while (source.row < source.numRows) {
                    if (this.rowLength > 0) {
                        temp_src_data = (source.recType & 4) != 0 ? source.tableDataRows[source.row] : source.data;
                        temp_dst_data = (this.recType & 4) != 0 ? this.tableDataRows[this.row] : this.data;
                    }
                    switch (itype) {
                        case 0: {
                            int k;
                            System.arraycopy(temp_src_data, ioffset, temp_dst_data, joffset, ilength);
                            for (k = ilength; k < jlength; ++k) {
                                temp_dst_data[joffset + k] = 32;
                            }
                            break;
                        }
                        case 2: {
                            this.setValue(j, (Object)source.getBigDecimal(i));
                            break;
                        }
                        case 6: {
                            this.setValue(j, source.decodeNUM(i));
                            break;
                        }
                        case 4: {
                            int k;
                            System.arraycopy(temp_src_data, ioffset, temp_dst_data, joffset, ilength);
                            for (k = ilength; k < jlength; ++k) {
                                temp_dst_data[joffset + k] = '\u0000';
                            }
                            break;
                        }
                        case 29: 
                        case 30: {
                            this.setValue(j, source.getValue(i));
                            break;
                        }
                        default: {
                            System.arraycopy(temp_src_data, ioffset, temp_dst_data, joffset, ilength);
                        }
                    }
                    ++this.row;
                    ++source.row;
                }
            }
            this.modified = true;
        }
        catch (Throwable t) {
            this.row = jrow_save;
            this.numRows = jnum_rows_save;
            this.data = data_save;
            this.tableDataRows = table_data_rows_save;
            this.odata = odata_save;
            this.opcode = opcode_save;
            this.flags = flags_save;
            this.modified = modified_save;
            source.row = irow_save;
        }
        finally {
            source.row = irow_save;
            this.row = jrow_save;
        }
        return n;
    }

    public int getFieldCount() {
        return this.metaData.numFields;
    }

    public MetaDataBase getBaseMetaData() {
        return this.metaData;
    }

    public Object getValue(int index) throws IDocConversionException {
        this.checkRowCapacity();
        this.metaData.checkIndex(index);
        byte itype = this.metaData.type[index];
        switch (itype) {
            case 0: {
                return this.decodeCHAR(index);
            }
            case 6: {
                return this.decodeNUM(index);
            }
            case 1: {
                return this.decodeDATE(index);
            }
            case 3: {
                return this.decodeTIME(index);
            }
        }
        throw new IDocRuntimeException(this.createConversionException(index, "object"));
    }

    public String getString(int index) {
        this.checkRowCapacity();
        this.metaData.checkIndex(index);
        byte itype = this.metaData.type[index];
        switch (itype) {
            case 0: {
                return this.decodeCHAR(index);
            }
            case 6: {
                return this.decodeNUM(index);
            }
            case 1: {
                return this.decodeCHAR(index);
            }
            case 3: {
                return this.decodeCHAR(index);
            }
        }
        throw new IDocRuntimeException(this.createConversionException(index, "java.lang.String"));
    }

    public char getChar(int index) throws IDocConversionException {
        this.checkRowCapacity();
        this.metaData.checkIndex(index);
        boolean conversion_error = false;
        byte itype = this.metaData.type[index];
        if (itype == 0) {
            String value = this.decodeCHAR(index);
            if (value == null || value.length() == 0) {
                return ' ';
            }
            if (value.length() == 1) {
                return value.charAt(0);
            }
            conversion_error = true;
        } else {
            conversion_error = true;
        }
        if (conversion_error) {
            throw this.createConversionException(index, "char");
        }
        return ' ';
    }

    public byte getByte(int index) throws IDocConversionException {
        this.metaData.checkIndex(index);
        if (this.metaData.blength[index] <= 1) {
            byte itype = this.metaData.type[index];
            if (itype == 0 || itype == 29) {
                char c = this.getChar(index);
                byte b = (byte)c;
                if (b == c) {
                    return b;
                }
            } else {
                short value = this.getShort(index);
                byte casted_value = (byte)value;
                if (casted_value == value) {
                    return casted_value;
                }
            }
        }
        throw this.createConversionException(index, "byte");
    }

    public final byte getByte(String fieldName) throws IDocFieldNotFoundException, IDocConversionException {
        return this.getByte(this.indexOf(fieldName));
    }

    public float getFloat(int index) throws IDocConversionException {
        this.metaData.checkIndex(index);
        double value = this.getDouble(index);
        return (float)value;
    }

    public final float getFloat(String fieldName) throws IDocFieldNotFoundException, IDocConversionException {
        return this.getFloat(this.indexOf(fieldName));
    }

    public short getShort(int index) throws IDocConversionException {
        this.checkRowCapacity();
        this.metaData.checkIndex(index);
        boolean conversion_error = false;
        byte itype = this.metaData.type[index];
        if (itype == 6) {
            try {
                return Short.parseShort(this.decodeNUM(index));
            }
            catch (NumberFormatException ex) {
                conversion_error = true;
            }
        } else if (itype == 0) {
            try {
                return Short.parseShort(this.decodeNUMBER(index));
            }
            catch (NumberFormatException ex) {
                conversion_error = true;
            }
        } else {
            conversion_error = true;
        }
        if (conversion_error) {
            throw this.createConversionException(index, "short");
        }
        return 0;
    }

    public int getInt(int index) throws IDocConversionException {
        this.checkRowCapacity();
        this.metaData.checkIndex(index);
        boolean conversion_error = false;
        byte itype = this.metaData.type[index];
        if (itype == 6) {
            try {
                return Integer.parseInt(this.decodeNUM(index));
            }
            catch (NumberFormatException ex) {
                conversion_error = true;
            }
        } else if (itype == 0) {
            try {
                return Integer.parseInt(this.decodeNUMBER(index));
            }
            catch (NumberFormatException ex) {
                conversion_error = true;
            }
        } else {
            conversion_error = true;
        }
        if (conversion_error) {
            throw this.createConversionException(index, "int");
        }
        return 0;
    }

    public long getLong(int index) throws IDocConversionException {
        this.checkRowCapacity();
        this.metaData.checkIndex(index);
        boolean conversion_error = false;
        byte itype = this.metaData.type[index];
        if (itype == 6) {
            try {
                return Long.parseLong(this.decodeNUM(index));
            }
            catch (NumberFormatException ex) {
                conversion_error = true;
            }
        } else if (itype == 0) {
            try {
                return Long.parseLong(this.decodeNUMBER(index));
            }
            catch (NumberFormatException ex) {
                conversion_error = true;
            }
        } else {
            conversion_error = true;
        }
        if (conversion_error) {
            throw this.createConversionException(index, "long");
        }
        return 0L;
    }

    public BigInteger getBigInteger(int index) throws IDocConversionException {
        this.checkRowCapacity();
        this.metaData.checkIndex(index);
        boolean conversion_error = false;
        byte itype = this.metaData.type[index];
        if (itype == 6) {
            try {
                return new BigInteger(this.decodeNUM(index));
            }
            catch (NumberFormatException ex) {
                conversion_error = true;
            }
        } else if (itype == 0) {
            try {
                return new BigInteger(this.decodeNUMBER(index));
            }
            catch (NumberFormatException ex) {
                conversion_error = true;
            }
        } else {
            conversion_error = true;
        }
        if (conversion_error) {
            throw this.createConversionException(index, "java.math.BigInteger");
        }
        return null;
    }

    public double getDouble(int index) throws IDocConversionException {
        this.checkRowCapacity();
        this.metaData.checkIndex(index);
        boolean conversion_error = false;
        byte itype = this.metaData.type[index];
        if (itype == 6) {
            try {
                return Double.valueOf(this.decodeNUM(index));
            }
            catch (NumberFormatException ex) {
                conversion_error = true;
            }
        } else if (itype == 0) {
            try {
                return Double.valueOf(this.decodeNUMBER(index));
            }
            catch (NumberFormatException ex) {
                conversion_error = true;
            }
        } else {
            conversion_error = true;
        }
        if (conversion_error) {
            throw this.createConversionException(index, "double");
        }
        return 0.0;
    }

    public BigDecimal getBigDecimal(int index) throws IDocConversionException {
        this.checkRowCapacity();
        this.metaData.checkIndex(index);
        boolean conversion_error = false;
        byte itype = this.metaData.type[index];
        if (itype == 6) {
            try {
                return new BigDecimal(this.decodeNUM(index));
            }
            catch (NumberFormatException ex) {
                conversion_error = true;
            }
        } else if (itype == 0) {
            try {
                return new BigDecimal(this.decodeNUMBER(index));
            }
            catch (NumberFormatException ex) {
                conversion_error = true;
            }
        } else {
            conversion_error = true;
        }
        if (conversion_error) {
            throw this.createConversionException(index, "java.math.BigDecimal");
        }
        return null;
    }

    public Date getDate(int index) throws IDocConversionException {
        this.checkRowCapacity();
        this.metaData.checkIndex(index);
        byte itype = this.metaData.type[index];
        if (itype == 1 || itype == 0 || itype == 29) {
            return this.decodeDATE(index);
        }
        if (itype == 3) {
            return this.decodeTIME(index);
        }
        throw this.createConversionException(index, "java.util.Date");
    }

    public Date getTime(int index) throws IDocConversionException {
        this.checkRowCapacity();
        this.metaData.checkIndex(index);
        byte itype = this.metaData.type[index];
        if (itype == 3 || itype == 0 || itype == 29) {
            return this.decodeTIME(index);
        }
        if (itype == 1) {
            return this.decodeDATE(index);
        }
        throw this.createConversionException(index, "java.util.Date");
    }

    public byte[] getByteArray(int index) throws IDocConversionException {
        this.checkRowCapacity();
        this.metaData.checkIndex(index);
        byte itype = this.metaData.type[index];
        if (itype == 0) {
            try {
                return this.decodeCHAR(index).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                Trace.fireTraceCritical("missing standard java char converter", ex);
                throw new IDocRuntimeException("missing standard java char converter", ex);
            }
        }
        throw this.createConversionException(index, "byte[]");
    }

    public char[] getCharArray(int index) throws IDocConversionException {
        this.checkRowCapacity();
        this.metaData.checkIndex(index);
        byte itype = this.metaData.type[index];
        switch (itype) {
            case 0: 
            case 6: {
                return this.decodeCHARARRAY(index);
            }
        }
        throw this.createConversionException(index, "char[]");
    }

    public InputStream getBinaryStream(int index) throws IDocConversionException {
        this.checkRowCapacity();
        this.metaData.checkIndex(index);
        byte itype = this.metaData.type[index];
        if (itype == 0) {
            try {
                return new ByteArrayInputStream(this.decodeCHAR(index).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                throw this.createConversionException(index, "java.io.InputStream");
            }
        }
        throw this.createConversionException(index, "java.io.InputStream");
    }

    public Reader getCharacterStream(int index) throws IDocConversionException {
        this.checkRowCapacity();
        this.metaData.checkIndex(index);
        byte itype = this.metaData.type[index];
        if (itype == 0) {
            return new StringReader(this.decodeCHAR(index));
        }
        throw this.createConversionException(index, "java.io.Reader");
    }

    public void setValue(int index, String value) throws IDocConversionException, IDocSyntaxException {
        this.checkRowCapacity();
        this.metaData.checkIndex(index);
        if (value == null || value.length() == 0) {
            this.setDefault(index);
            return;
        }
        boolean conversion_error = false;
        byte itype = this.metaData.type[index];
        if (itype == 0) {
            this.encodeCHAR(value, index);
        } else if (itype == 6) {
            try {
                this.encodeNUM(value, index);
            }
            catch (NumberFormatException ex) {
                conversion_error = true;
            }
        } else if (itype == 1) {
            try {
                this.encodeDATE(value, index);
            }
            catch (Exception ex) {
                conversion_error = true;
            }
        } else if (itype == 3) {
            try {
                this.encodeTIME(value, index);
            }
            catch (Exception ex) {
                conversion_error = true;
            }
        } else {
            conversion_error = true;
        }
        if (conversion_error) {
            throw this.createConversionException(index, "java.lang.String", value);
        }
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    public final String getClassNameOfValue(String fieldName) throws IDocFieldNotFoundException {
        return this.metaData.getClassNameOfField(this.indexOf(fieldName));
    }

    public final Object getValue(String fieldName) throws IDocFieldNotFoundException, IDocConversionException {
        return this.getValue(this.indexOf(fieldName));
    }

    public final String getString(String fieldName) throws IDocFieldNotFoundException {
        return this.getString(this.indexOf(fieldName));
    }

    public final char getChar(String fieldName) throws IDocFieldNotFoundException, IDocConversionException {
        return this.getChar(this.indexOf(fieldName));
    }

    public final short getShort(String fieldName) throws IDocFieldNotFoundException, IDocConversionException {
        return this.getShort(this.indexOf(fieldName));
    }

    public final int getInt(String fieldName) throws IDocFieldNotFoundException, IDocConversionException {
        return this.getInt(this.indexOf(fieldName));
    }

    public final long getLong(String fieldName) throws IDocFieldNotFoundException, IDocConversionException {
        return this.getLong(this.indexOf(fieldName));
    }

    public final BigInteger getBigInteger(String fieldName) throws IDocFieldNotFoundException, IDocConversionException {
        return this.getBigInteger(this.indexOf(fieldName));
    }

    public final double getDouble(String fieldName) throws IDocFieldNotFoundException, IDocConversionException {
        return this.getDouble(this.indexOf(fieldName));
    }

    public final BigDecimal getBigDecimal(String fieldName) throws IDocFieldNotFoundException, IDocConversionException {
        return this.getBigDecimal(this.indexOf(fieldName));
    }

    public final Date getDate(String fieldName) throws IDocFieldNotFoundException, IDocConversionException {
        return this.getDate(this.indexOf(fieldName));
    }

    public final Date getTime(String fieldName) throws IDocFieldNotFoundException, IDocConversionException {
        return this.getTime(this.indexOf(fieldName));
    }

    public final byte[] getByteArray(String fieldName) throws IDocFieldNotFoundException, IDocConversionException {
        return this.getByteArray(this.indexOf(fieldName));
    }

    public final char[] getCharArray(String fieldName) throws IDocFieldNotFoundException, IDocConversionException {
        return this.getCharArray(this.indexOf(fieldName));
    }

    public final InputStream getBinaryStream(String fieldName) throws IDocFieldNotFoundException, IDocConversionException {
        return this.getBinaryStream(this.indexOf(fieldName));
    }

    public final Reader getCharacterStream(String fieldName) throws IDocFieldNotFoundException, IDocConversionException {
        return this.getCharacterStream(this.indexOf(fieldName));
    }

    protected void setDefault(int index) {
        byte itype = this.metaData.type[index];
        if (itype == 0) {
            this.encodeCHAR("", index);
        } else if (itype == 1) {
            this.encodeCHAR("00000000", index);
        } else if (itype == 3) {
            this.encodeCHAR("000000", index);
        } else if (itype == 6) {
            try {
                this.encodeNUM(0L, index);
            }
            catch (IDocConversionException iDocConversionException) {}
        } else {
            return;
        }
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    public void setValue(int index, char value) throws IDocConversionException, IDocSyntaxException {
        this.setValue(index, new char[]{value}, 0, 1);
    }

    public void setValue(int index, char[] value) throws IDocConversionException, IDocSyntaxException {
        this.setValue(index, value, 0, value.length);
    }

    public void setValue(int index, char[] value, int from, int length) throws IDocConversionException, IDocSyntaxException {
        this.metaData.checkIndex(index);
        this.checkRowCapacity();
        if (value == null || length == 0) {
            this.setDefault(index);
            return;
        }
        if (length < 0) {
            throw new IllegalArgumentException("Illegal length [" + length + "] was passed. Current field " + this.metaData.name[index]);
        }
        if (value.length < from + length) {
            throw new IllegalArgumentException("Array length [" + value.length + "] less than length was passed [" + (from + length) + "]. Current field " + this.metaData.name[index]);
        }
        boolean conversion_error = false;
        byte itype = this.metaData.type[index];
        if (itype == 0) {
            this.encodeCHARS(value, from, length, index);
        } else {
            conversion_error = true;
        }
        if (conversion_error) {
            throw this.createConversionException(index, "char[]", new String(value, from, length));
        }
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    public void setValue(int index, short value) throws IDocConversionException, IDocSyntaxException {
        this.metaData.checkIndex(index);
        this.checkRowCapacity();
        byte itype = this.metaData.type[index];
        if (itype == 6) {
            this.encodeNUM(value, index);
        } else if (itype == 0) {
            this.encodeCHAR(Short.toString(value), index);
        } else {
            throw this.createConversionException(index, "short", null);
        }
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    public void setValue(int index, int value) throws IDocConversionException, IDocSyntaxException {
        this.metaData.checkIndex(index);
        this.checkRowCapacity();
        byte itype = this.metaData.type[index];
        if (itype == 6) {
            try {
                this.encodeNUM(value, index);
            }
            catch (Exception ex) {
                throw new IDocConversionException((IDocRecord)((Object)this), this.metaData.name[index], ex.getMessage(), (Throwable)ex);
            }
        } else if (itype == 0) {
            this.encodeCHAR(Integer.toString(value), index);
        } else {
            throw this.createConversionException(index, "int", null);
        }
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    public void setValue(int index, long value) throws IDocConversionException, IDocSyntaxException {
        this.metaData.checkIndex(index);
        this.checkRowCapacity();
        byte itype = this.metaData.type[index];
        if (itype == 6) {
            this.encodeNUM(value, index);
        } else if (itype == 0) {
            this.encodeCHAR(Long.toString(value), index);
        } else {
            throw this.createConversionException(index, "long", null);
        }
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    public void setValue(int index, double value) throws IDocConversionException, IDocSyntaxException {
        this.metaData.checkIndex(index);
        this.checkRowCapacity();
        byte itype = this.metaData.type[index];
        if (itype != 0) {
            throw this.createConversionException(index, "double", null);
        }
        this.encodeCHAR(Double.toString(value), index);
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    public void setValue(int index, byte[] value) throws IDocConversionException, IDocSyntaxException {
        char[] c;
        this.metaData.checkIndex(index);
        this.checkRowCapacity();
        if (value == null || value.length == 0) {
            this.setDefault(index);
            return;
        }
        byte itype = this.metaData.type[index];
        if (itype == 0) {
            c = new char[value.length * 2];
            int k = 0;
            for (int i = 0; i < value.length; ++i) {
                c[k++] = HEX[value[i] >> 4 & 0xF];
                c[k++] = HEX[value[i] & 0xF];
            }
        } else {
            throw this.createConversionException(index, "byte[]", null);
        }
        this.encodeCHARS(c, 0, c.length, index);
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    public void setValue(int index, Object value) throws IDocConversionException, IDocSyntaxException {
        this.metaData.checkIndex(index);
        this.checkRowCapacity();
        if (value == null) {
            this.setDefault(index);
            return;
        }
        byte itype = this.metaData.type[index];
        if (value instanceof String) {
            this.setValue(index, (String)value);
        } else if (value instanceof char[]) {
            this.setValue(index, (char[])value);
        } else if (value instanceof Integer) {
            this.setValue(index, (int)((Integer)value));
        } else if (value instanceof Long) {
            this.setValue(index, (long)((Long)value));
        } else if (value instanceof Short) {
            this.setValue(index, ((Short)value).intValue());
        } else if (value instanceof Double) {
            this.setValue(index, (double)((Double)value));
        } else if (value instanceof Float) {
            this.setValue(index, ((Float)value).doubleValue());
        } else if (value instanceof BigInteger && itype == 6) {
            this.encodeNUM(value.toString(), index);
        } else if (value instanceof BigDecimal && itype == 7) {
            BigDecimal bd = (BigDecimal)value;
            bd = bd.setScale((int)this.metaData.decimals[index], 6);
            this.setValue(index, bd.doubleValue());
        } else if (itype == 1 && value instanceof Date) {
            this.setValue(index, dateiso.format((Date)value));
        } else if (itype == 3 && value instanceof Date) {
            this.setValue(index, timeiso.format((Date)value));
        } else if (value instanceof byte[] && itype == 4) {
            this.setValue(index, (byte[])value);
        } else if (value instanceof byte[] && itype == 30) {
            this.setValue(index, (byte[])value);
        } else {
            throw this.createConversionException(index, "java.lang.Object", null);
        }
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    public void setValue(String name, String value) throws IDocFieldNotFoundException, IDocConversionException, IDocSyntaxException {
        this.setValue(this.indexOf(name), value);
    }

    public void setValue(String name, char[] value) throws IDocFieldNotFoundException, IDocConversionException, IDocSyntaxException {
        this.setValue(this.indexOf(name), value, 0, value.length);
    }

    public void setValue(String name, char[] value, int from, int length) throws IDocFieldNotFoundException, IDocConversionException, IDocSyntaxException {
        this.setValue(this.indexOf(name), value, from, length);
    }

    public void setValue(String name, char value) throws IDocFieldNotFoundException, IDocConversionException, IDocSyntaxException {
        this.setValue(this.indexOf(name), value);
    }

    public void setValue(String name, short value) throws IDocFieldNotFoundException, IDocConversionException, IDocSyntaxException {
        this.setValue(this.indexOf(name), value);
    }

    public void setValue(String name, int value) throws IDocFieldNotFoundException, IDocConversionException, IDocSyntaxException {
        this.setValue(this.indexOf(name), value);
    }

    public void setValue(String name, long value) throws IDocFieldNotFoundException, IDocConversionException, IDocSyntaxException {
        this.setValue(this.indexOf(name), value);
    }

    public void setValue(String name, double value) throws IDocFieldNotFoundException, IDocConversionException, IDocSyntaxException {
        this.setValue(this.indexOf(name), value);
    }

    public void setValue(int index, float value) throws IDocConversionException, IDocSyntaxException {
        this.setValue(index, (double)value);
    }

    public void setValue(String name, float value) throws IDocFieldNotFoundException, IDocConversionException, IDocSyntaxException {
        this.setValue(this.indexOf(name), value);
    }

    public void setValue(int index, byte value) throws IDocConversionException, IDocSyntaxException {
        this.metaData.checkIndex(index);
        this.checkRowCapacity();
        if (this.metaData.blength[index] > 1) {
            throw new IDocConversionException((IDocRecord)((Object)this), this.metaData.name[index], "This is not a proper method to set the field " + this.metaData.name[index] + ", since this field is longer than 1 byte. Use a different method.");
        }
        byte itype = this.metaData.type[index];
        if (itype == 0) {
            char[] c = new char[]{(char)value};
            this.encodeCHAR(new String(c), index);
        } else if (itype == 6) {
            this.encodeNUM(value, index);
        } else {
            throw this.createConversionException(index, "byte", null);
        }
        int n = index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        this.setModified(this.row);
    }

    public void setValue(String name, byte value) throws IDocFieldNotFoundException, IDocConversionException, IDocSyntaxException {
        this.setValue(this.indexOf(name), value);
    }

    public void setValue(String name, byte[] value) throws IDocFieldNotFoundException, IDocConversionException, IDocSyntaxException {
        this.setValue(this.indexOf(name), value);
    }

    public void setValue(String name, Object value) throws IDocFieldNotFoundException, IDocConversionException, IDocSyntaxException {
        this.setValue(this.indexOf(name), value);
    }

    public boolean isInitialized(int index) {
        this.metaData.checkIndex(index);
        return (this.flags[index] & 1) == 0;
    }

    public boolean isInitialized(String field_name) throws IDocFieldNotFoundException {
        return (this.flags[this.indexOf(field_name)] & 1) == 0;
    }

    private final void encodeCHAR(String value, int index) {
        if (value == null) {
            value = "";
        }
        char[] temp_data = (this.recType & 4) != 0 ? this.tableDataRows[this.row] : this.data;
        int ioffset = this.metaData.boffset[index];
        int ilength = this.metaData.blength[index];
        int iend = ioffset + ilength;
        ilength = Math.min(value.length(), ilength);
        this.ensureBufferCapacity();
        value.getChars(0, ilength, temp_data, ioffset);
        ioffset += ilength;
        while (ioffset < iend) {
            temp_data[ioffset++] = 32;
        }
    }

    private final void encodeCHARS(char[] value, int from, int length, int index) {
        char[] temp_data = (this.recType & 4) != 0 ? this.tableDataRows[this.row] : this.data;
        int ioffset = this.metaData.boffset[index];
        int ilength = this.metaData.blength[index];
        int iend = ioffset + ilength;
        ilength = Math.min(length, ilength);
        this.ensureBufferCapacity();
        System.arraycopy(value, from, temp_data, ioffset, ilength);
        ioffset += ilength;
        while (ioffset < iend) {
            temp_data[ioffset++] = 32;
        }
    }

    private final void encodeNUM(long value, int index) throws IDocConversionException {
        int i;
        char[] temp_data = (this.recType & 4) != 0 ? this.tableDataRows[this.row] : this.data;
        int ioffset = this.metaData.boffset[index];
        int ilength = this.metaData.blength[index];
        int length = 0;
        this.ensureBufferCapacity();
        if (value < 0L) {
            throw new IDocConversionException((IDocRecord)((Object)this), this.metaData.name[index], "Value '" + value + "' cannot be converted to " + AbstractMetaData.getJCOTypeString(this.metaData.type[index]) + " type at field " + this.metaData.name[index]);
        }
        for (long tmp_value = value; tmp_value > 0L; tmp_value /= 10L) {
            ++length;
        }
        if (length > ilength) {
            throw new IDocConversionException((IDocRecord)((Object)this), this.metaData.name[index], "Integer '" + value + "' has too many digits at field " + this.metaData.name[index]);
        }
        for (i = 0; i < ilength - length; ++i) {
            temp_data[ioffset++] = 48;
        }
        i = ilength - 1;
        ioffset += length;
        while (i >= ilength - length) {
            temp_data[--ioffset] = (char)(48L + value % 10L);
            --i;
            value /= 10L;
        }
    }

    private final void encodeNUM(String value, int index) throws IDocConversionException {
        int i;
        char[] temp_data = (this.recType & 4) != 0 ? this.tableDataRows[this.row] : this.data;
        int ioffset = this.metaData.boffset[index];
        int ilength = this.metaData.blength[index];
        int length = 0;
        int start = 0;
        this.ensureBufferCapacity();
        for (i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (length == 0 && c == '0') {
                ++start;
                continue;
            }
            if (c >= '0' && c <= '9') {
                ++length;
                continue;
            }
            throw new IDocConversionException((IDocRecord)((Object)this), this.metaData.name[index], "Value '" + value + "' cannot be converted to " + AbstractMetaData.getJCOTypeString(this.metaData.type[index]) + " type at field " + this.metaData.name[index]);
        }
        if (length > ilength) {
            throw new IDocConversionException((IDocRecord)((Object)this), this.metaData.name[index], "Integer '" + value + "' has too many digits at field " + this.metaData.name[index]);
        }
        for (i = 0; i < ilength - length; ++i) {
            temp_data[ioffset++] = 48;
        }
        for (i = 0; i < length; ++i) {
            temp_data[ioffset++] = value.charAt(start + i);
        }
    }

    private final void encodeTIME(String value, int index) throws ParseException {
        String time = value;
        if (value.equals("240000") || value.equals("24:00:00") || value.equals("  :  :  ")) {
            time = "240000";
        } else {
            try {
                time = timerfc.format(timeiso.parse(value));
            }
            catch (ParseException ex) {
                time = timerfc.format(timerfc.parse(value));
            }
        }
        this.encodeCHAR(time, index);
    }

    private final void encodeDATE(String value, int index) throws ParseException {
        String date = value;
        if (value.length() == 0 || value.equals("0000-00-00") || value.equals("00000000") || value.equals("    -  -  ")) {
            date = "00000000";
        } else if (value.equals("9999-99-99") || value.equals("99999999")) {
            date = "99999999";
        } else {
            try {
                date = daterfc.format(dateiso.parse(value));
            }
            catch (ParseException ex) {
                date = daterfc.format(daterfc.parse(value));
            }
        }
        this.encodeCHAR(date, index);
    }

    private final String decodeCHAR(int index) {
        int iend;
        char[] temp_data;
        int ioffset = this.metaData.boffset[index];
        char[] cArray = temp_data = (this.recType & 4) != 0 ? this.tableDataRows[this.row] : this.data;
        for (iend = ioffset + this.metaData.blength[index] - 1; iend >= ioffset && temp_data[iend] == ' '; --iend) {
        }
        return new String(temp_data, ioffset, iend - ioffset + 1);
    }

    private final char[] decodeCHARARRAY(int index) {
        int ioffset = this.metaData.boffset[index];
        int ilength = this.metaData.blength[index];
        char[] temp_data = (this.recType & 4) != 0 ? this.tableDataRows[this.row] : this.data;
        char[] result = new char[ilength];
        System.arraycopy(temp_data, ioffset, result, 0, ilength);
        return result;
    }

    private final Date decodeDATE(int index) throws IDocConversionException {
        String str = this.decodeCHAR(index);
        if (str.length() == 0 || str.equals("00000000") || str.equals("0000-00-00")) {
            return null;
        }
        if (str.equals("99999999") || str.equals("9999-99-99")) {
            str = "99991231";
        }
        try {
            return daterfc.parse(str);
        }
        catch (Exception ex) {
            try {
                return dateiso.parse(str);
            }
            catch (Exception ex2) {
                throw new IDocConversionException((IDocRecord)((Object)this), this.metaData.name[index], ex2.getMessage() + " in record " + this.metaData.recName + " at field " + this.metaData.name[index], (Throwable)ex2);
            }
        }
    }

    private final Date decodeTIME(int index) throws IDocConversionException {
        String str = this.decodeCHAR(index);
        if (str.length() == 0) {
            return null;
        }
        if (str.equals("240000") || str.equals("24:00:00")) {
            str = "000000";
        }
        try {
            return timerfc.parse(str);
        }
        catch (Exception ex) {
            try {
                return timeiso.parse(str);
            }
            catch (Exception ex2) {
                throw new IDocConversionException((IDocRecord)((Object)this), this.metaData.name[index], ex2.getMessage() + " in record " + this.metaData.recName + " at field " + this.metaData.name[index], (Throwable)ex2);
            }
        }
    }

    private final String decodeNUM(int index) {
        return this.decodeCHAR(index);
    }

    private final String decodeNUMBER(int index) {
        char[] temp_data;
        int ioffset;
        int iend = ioffset + this.metaData.blength[index] - 1;
        char[] cArray = temp_data = (this.recType & 4) != 0 ? this.tableDataRows[this.row] : this.data;
        for (ioffset = this.metaData.boffset[index]; ioffset <= iend && temp_data[ioffset] == ' '; ++ioffset) {
        }
        while (iend >= ioffset && temp_data[iend] == ' ') {
            --iend;
        }
        if (ioffset > iend) {
            return "0";
        }
        if (temp_data[iend] == '-') {
            StringBuilder value = new StringBuilder(iend - ioffset + 1);
            value.append('-');
            value.append(temp_data, ioffset, iend - ioffset);
            return value.toString();
        }
        if (temp_data[iend] == '+' && temp_data[ioffset] != '-' && temp_data[ioffset] != '+') {
            --iend;
        }
        return new String(temp_data, ioffset, iend - ioffset + 1);
    }

    public String toString() {
        int i;
        int length;
        int index;
        StringBuilder buf = new StringBuilder(200);
        int ilength = 0;
        int row_save = this.row;
        buf.append('|');
        for (index = 0; index < this.metaData.numFields; ++index) {
            switch (this.metaData.type[index]) {
                case 17: 
                case 29: 
                case 30: 
                case 99: {
                    length = this.metaData.name[index].length();
                    for (i = 0; i < length; ++i) {
                        buf.append('-');
                    }
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    for (i = 0; i < this.metaData.blength[index]; ++i) {
                        buf.append("----");
                    }
                    break;
                }
                default: {
                    for (i = 0; i < this.metaData.blength[index]; ++i) {
                        buf.append('-');
                    }
                }
            }
            buf.append('|');
        }
        String lineString = buf.toString();
        buf.append(RecordConstants.CRLF);
        if ((this.recType & 4) != 0) {
            buf.append("| TABLE");
        } else if ((this.recType & 2) != 0) {
            buf.append("| STRUCTURE");
        } else if ((this.recType & 0x10) != 0) {
            buf.append("| REQUEST");
        } else if ((this.recType & 0x20) != 0) {
            buf.append("| RESPONSE");
        } else if ((this.recType & 1) != 0) {
            buf.append("| PARAMETERS");
        }
        buf.append(" '");
        buf.append(this.metaData.recName);
        buf.append("'");
        buf.append(RecordConstants.CRLF);
        buf.append(lineString);
        buf.append(RecordConstants.CRLF);
        for (index = 0; index < this.metaData.numFields; ++index) {
            String iname = this.metaData.name[index];
            switch (this.metaData.type[index]) {
                case 17: 
                case 29: 
                case 30: 
                case 99: {
                    ilength = iname.length();
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    ilength = this.metaData.blength[index] * 4;
                    break;
                }
                default: {
                    ilength = this.metaData.blength[index];
                }
            }
            if (iname.length() > ilength) {
                iname = iname.substring(0, ilength);
            }
            buf.append("|");
            buf.append(iname);
            length = ilength;
            for (i = iname.length(); i < length; ++i) {
                buf.append(' ');
            }
        }
        buf.append("|" + RecordConstants.CRLF);
        buf.append(lineString);
        buf.append(RecordConstants.CRLF);
        buf.append('|');
        for (index = 0; index < this.metaData.numFields; ++index) {
            switch (this.metaData.type[index]) {
                case 17: 
                case 29: 
                case 30: 
                case 99: {
                    length = this.metaData.name[index].length();
                    for (i = 0; i < length; ++i) {
                        buf.append(' ');
                    }
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    length = this.metaData.boffset[index] + this.metaData.blength[index];
                    for (i = this.metaData.boffset[index]; i < length; ++i) {
                        buf.append("   ");
                        buf.append(i % 10);
                    }
                    break;
                }
                default: {
                    length = this.metaData.boffset[index] + this.metaData.blength[index];
                    for (i = this.metaData.boffset[index]; i < length; ++i) {
                        buf.append(i % 10);
                    }
                }
            }
            buf.append('|');
        }
        buf.append(RecordConstants.CRLF);
        buf.append(lineString);
        buf.append(RecordConstants.CRLF);
        if (this.numRows > 0) {
            char[] data = null;
            this.row = 0;
            while (this.row < this.numRows) {
                data = (this.recType & 4) != 0 ? this.tableDataRows[this.row] : this.data;
                buf.append('|');
                for (int index2 = 0; index2 < this.metaData.numFields; ++index2) {
                    switch (this.metaData.type[index2]) {
                        case 17: 
                        case 99: {
                            buf.append(this.metaData.name[index2]);
                            break;
                        }
                        case 29: 
                        case 30: {
                            String temp = this.getString(index2);
                            ilength = this.metaData.name[index2].length();
                            if (temp == null) {
                                temp = "null";
                            }
                            if (temp.length() > ilength) {
                                temp = temp.substring(0, ilength);
                            }
                            buf.append(temp);
                            for (int i2 = temp.length(); i2 < ilength; ++i2) {
                                buf.append(' ');
                            }
                            break;
                        }
                        default: {
                            buf.append(data, this.metaData.boffset[index2], this.metaData.blength[index2]);
                        }
                    }
                    buf.append('|');
                }
                if (this.row < this.numRows - 1) {
                    buf.append(RecordConstants.CRLF);
                }
                ++this.row;
            }
        }
        buf.append(RecordConstants.CRLF);
        buf.append(lineString);
        buf.append(RecordConstants.CRLF);
        this.row = row_save;
        return buf.toString();
    }
}

