/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.interfaces.IMessageBuilder;
import com.sap.tc.logging.interfaces.IMessageDelimiterBuilder;
import java.util.Arrays;

public class MessageDelimiterBuilder
implements IMessageDelimiterBuilder {
    private static final int DYNAMIC_COUNTER_MAX_SIZE = 5;
    private int[] delimiters;
    private int[] delimiterEmpty;
    private int[][] delimiterDynamicCounters;
    private int delimiterSize;
    private int delimiterDynamicCounterSize;
    private int delimiterMinSize;
    private int delimiterLatestPos;
    private byte delimiter;
    private boolean delimiterEnabled;
    private boolean isDelSorted;
    private boolean isLatestCharMask;
    private boolean isLatestCharDelimiter;
    private IMessageBuilder parent;

    public MessageDelimiterBuilder() {
    }

    protected MessageDelimiterBuilder(byte delimiter, int delimiterMinSize) {
        this.delimiter = delimiter;
        this.delimiterMinSize = delimiterMinSize;
        if (delimiterMinSize > 0) {
            this.delimiterEnabled = true;
            this.delimiters = new int[150];
            this.delimiterEmpty = new int[150];
            this.delimiterDynamicCounters = new int[5][2];
        }
    }

    public void setParent(IMessageBuilder parent) {
        this.parent = parent;
    }

    public void addDynamicCounter(int pos, boolean isFixed) {
        if (this.delimiterDynamicCounterSize == 5) {
            throw new IllegalArgumentException("The maximum number (5) of dynamic counters has been is reached!");
        }
        if (isFixed) {
            this.delimiterDynamicCounters[this.delimiterDynamicCounterSize][0] = pos;
            this.delimiterDynamicCounters[this.delimiterDynamicCounterSize][1] = 0;
        } else {
            this.delimiterDynamicCounters[this.delimiterDynamicCounterSize][0] = pos;
            this.delimiterDynamicCounters[this.delimiterDynamicCounterSize][1] = 1;
        }
        ++this.delimiterDynamicCounterSize;
    }

    public void setDelimiter(byte value) {
        this.delimiter = value;
    }

    public byte getDelimiter() {
        return this.delimiter;
    }

    public void saveNextPosition(byte value, int pos) {
        if (this.delimiterEnabled) {
            if (value == 92) {
                this.isLatestCharMask = !this.isLatestCharMask;
            } else if (value == this.delimiter) {
                this.delimiterLatestPos = this.getMessageSize() + pos;
                if (!this.isLatestCharMask) {
                    this.delimiters[this.delimiterSize++] = this.delimiterLatestPos;
                }
                this.isLatestCharMask = false;
            } else {
                this.isLatestCharMask = false;
            }
        }
    }

    public void savePreviousPosition(byte value, int pos) {
        if (this.delimiterEnabled) {
            this.isDelSorted = false;
            if (value == this.delimiter) {
                this.delimiters[this.delimiterSize++] = (this.getMessageSize() + (pos - 1)) * -1;
                this.isLatestCharDelimiter = true;
                this.isLatestCharMask = false;
            } else if (value == 92) {
                if (this.isLatestCharMask) {
                    if (this.isLatestCharDelimiter) {
                        ++this.delimiterSize;
                        this.isLatestCharDelimiter = false;
                    }
                } else if (this.isLatestCharDelimiter) {
                    --this.delimiterSize;
                }
                this.isLatestCharMask = true;
            } else {
                this.isLatestCharMask = false;
                this.isLatestCharDelimiter = false;
            }
        }
    }

    public void demask() {
        this.isLatestCharMask = false;
    }

    public int getDelimiterPos(int index) {
        if (index < 0 || index >= this.delimiterSize) {
            return 0;
        }
        if (this.delimiterSize >= this.delimiterMinSize) {
            this.sortingDelimiters();
        }
        return this.delimiters[index];
    }

    public boolean isComplete() {
        if (!this.isDelimited()) {
            return true;
        }
        int dynamicPos = 0;
        int dynamicPosIndex = 0;
        int dynamicSize = 0;
        int dynamicSumSize = 0;
        for (int i = 0; i < this.delimiterDynamicCounterSize; ++i) {
            dynamicPos = dynamicSize + this.delimiterDynamicCounters[i][0];
            int n = dynamicPosIndex = (dynamicSize = this.getFieldInt(dynamicPos)) > 0 ? this.delimiterDynamicCounters[i][1] : 0;
            if ((dynamicSumSize += dynamicSize) <= 0 || this.delimiterSize - (dynamicSumSize + dynamicPosIndex) >= this.delimiterMinSize) continue;
            return false;
        }
        return this.delimiterSize >= this.delimiterMinSize;
    }

    public boolean isDelimited() {
        return this.delimiterMinSize > 0;
    }

    public int size() {
        return this.delimiterSize;
    }

    public void reset() {
        if (this.delimiterEnabled) {
            System.arraycopy(this.delimiterEmpty, 0, this.delimiters, 0, this.delimiterEmpty.length);
        }
        this.delimiterSize = 0;
        this.isDelSorted = true;
    }

    private int getMessageSize() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.size();
    }

    private int getFieldInt(int pos) {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getFieldInt(pos);
    }

    private void sortingDelimiters() {
        if (this.isDelSorted) {
            return;
        }
        for (int i = 0; i < this.delimiterSize; ++i) {
            if (this.delimiters[i] >= 0) continue;
            this.delimiters[i] = this.getMessageSize() - this.delimiters[i] * -1;
        }
        Arrays.sort(this.delimiters);
        System.arraycopy(this.delimiters, this.delimiters.length - this.delimiterSize, this.delimiters, 0, this.delimiterSize);
        this.isDelSorted = true;
    }
}

