/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.ext.PasswordChangeHandler;
import com.sap.conn.jco.rt.ClientConnection;
import com.sap.conn.jco.rt.ClientFactory;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.MonitoredConnectionData;
import com.sap.conn.jco.rt.PoolingFactory;
import com.sap.conn.jco.rt.RfcDestination;
import com.sap.conn.jco.rt.RuntimeEnvironment;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.rfc.engine.PasswordState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

abstract class ConnectionManager {
    private static HashMap<String, ClientFactory> mFactories = new HashMap();
    private static HashMap<String, AtomicInteger> mCreationSemaphores = new HashMap();
    private static final HashSet<String> friendlyClasses = ConnectionManager.getFriendlyClasses();
    private static ConnectionManager singleton;

    private static HashSet<String> getFriendlyClasses() {
        HashSet<String> friends = new HashSet<String>();
        friends.add("com.sap.conn.jco.rt.JCoJ2EERuntime");
        friends.add("com.sap.conn.jco.rt.DefaultJCoRuntime");
        friends.add("com.sap.conn.jco.rt.JCoVMCRuntime");
        friends.add("com.sap.conn.jco.rt.VMCConnectionManager");
        friends.add("com.sap.conn.jco.rt.DefaultConnectionManager");
        return friends;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionManager() {
        if (!JCoRuntime.checkAccess(friendlyClasses, "com.sap.conn.jco.rt.ConnectionManager")) {
            throw new UnsupportedOperationException("It is not allowed to extend the ConnectionManager class");
        }
        Class<ConnectionManager> clazz = ConnectionManager.class;
        synchronized (ConnectionManager.class) {
            if (singleton == null) {
                singleton = this;
                try {
                    Runtime.getRuntime().addShutdownHook(new Thread(JCoRuntime.jcoThreadGroup, new PoolFinalizer(), "JCoPoolFinalizerThread"));
                }
                catch (Throwable t) {
                    Trace.fireTraceCritical("[JCoAPI] Exception while adding ConnectionManager shutdown hook:", t);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static ConnectionManager getConnectionManager() {
        if (singleton == null) {
            JCoRuntimeFactory.getRuntime();
        }
        return singleton;
    }

    protected final void clearAllFactories() {
        if (Trace.isOn(8)) {
            Trace.fireTrace(8, "[JCoAPI] Clearing all connection pools");
        }
        for (ClientFactory factory : mFactories.values()) {
            factory.clear();
        }
    }

    protected final ClientConnection getClient(JCoDestination destination) throws JCoException {
        return this.getClient((InternalDestination)destination, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final ClientConnection getClient(InternalDestination destination, boolean forRepository, boolean forChangePassword) throws JCoException {
        try {
            PasswordChangeHandler changeHandler;
            ClientFactory factory = this.getFactory(destination, forRepository, true);
            ClientConnection client = factory.getClient();
            PasswordState passwordState = client.rfcHandle.getPasswordState();
            if (passwordState == null) return client;
            if (passwordState != PasswordState.INITIAL && passwordState != PasswordState.EXPIRED) {
                if (passwordState != PasswordState.RULES_ENFORCED) return client;
            }
            if ((changeHandler = RuntimeEnvironment.getPasswordChangeHandler()) != null && !forRepository) {
                destination.setInPasswordChangeHandler(true);
                try {
                    if (this.doPasswortChangeWithHandler(changeHandler, destination, client)) {
                        ClientConnection clientConnection = client;
                        return clientConnection;
                    }
                }
                finally {
                    destination.setInPasswordChangeHandler(false);
                }
            }
            if (!"1".equals(client.properties.getProperty("jco.client.deny_initial_password"))) return client;
            if (forChangePassword) return client;
            StringBuilder message = new StringBuilder(134);
            switch (passwordState) {
                case INITIAL: {
                    message.append("The current password is initial.");
                    break;
                }
                case EXPIRED: {
                    message.append("The current password has expired.");
                    break;
                }
                case RULES_ENFORCED: {
                    message.append("The password rules have changed.");
                    break;
                }
            }
            message.append(" Please change your password in the AS ABAP system as well as in the local destination configuration.");
            throw new JCoException(138, message.toString());
        }
        catch (ClassCastException cce) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", new StringBuilder(130).append("Unsupported class ").append(destination.getClass().getName()).append(" encountered. Use the DestinationManager to obtain destination instances").toString(), cce);
        }
    }

    private boolean doPasswortChangeWithHandler(PasswordChangeHandler changeHandler, InternalDestination destination, ClientConnection client) {
        boolean successfulChange = false;
        Exception previous = null;
        for (int i = 0; i < 7; ++i) {
            if (i > 0 && !client.isValid()) {
                throw new JCoRuntimeException(136, "Connection was closed when trying to change password", previous);
            }
            String[] passwords = changeHandler.promptPassword(destination, previous);
            if (passwords == null || passwords.length < 2) break;
            try {
                client.changeBackendPassword(destination.getUser(), passwords[0], passwords[1]);
                successfulChange = true;
                break;
            }
            catch (Exception e) {
                previous = e;
                continue;
            }
        }
        return successfulChange;
    }

    protected final void releaseClient(ClientConnection client) throws JCoException {
        if (client == null) {
            Trace.fireTraceCritical("[JCoAPI] ClientConnection is null in releaseClient()", true);
            return;
        }
        client.sessionId = null;
        ClientFactory pool = client.pool;
        if (pool == null) {
            if (client.isAlive()) {
                client.disconnect(false);
            }
            return;
        }
        pool.releaseClient(client);
    }

    protected final void releaseWithCancel(ClientConnection client) throws JCoException {
        if (client == null) {
            Trace.fireTraceCritical("[JCoAPI] ClientConnection is null in releaseWithCancel()", true);
            return;
        }
        client.sessionId = null;
        ClientFactory pool = client.pool;
        if (pool != null) {
            pool.detachFromPool(client);
        }
        client.cancel();
    }

    protected final void clearClient(ClientConnection client) throws JCoException {
        if (client == null) {
            Trace.fireTraceCritical("[JCoAPI] ClientConnection is null in clearClient()", true);
            return;
        }
        ClientFactory pool = client.pool;
        if (pool != null) {
            pool.detachFromPool(client);
        }
        client.free();
    }

    protected final void restoreClient(ClientConnection client, String destinationId, boolean allocate) throws JCoException {
        if (client == null) {
            Trace.fireTraceCritical("[JCoAPI] ClientConnection is null in restoreClient()", true);
            return;
        }
        ClientFactory factory = mFactories.get(destinationId);
        if (factory != null) {
            factory.attachToPool(client, allocate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientFactory getFactory(InternalDestination destination, boolean forRepository, boolean create) throws JCoException {
        String key = forRepository ? destination.getRepositoryKey() : destination.getDestinationID();
        ClientFactory factory = mFactories.get(key);
        if (factory == null && create) {
            AtomicInteger semaphore = null;
            Serializable serializable = mCreationSemaphores;
            synchronized (serializable) {
                factory = mFactories.get(key);
                if (factory == null) {
                    semaphore = mCreationSemaphores.get(key);
                    if (semaphore == null) {
                        semaphore = new AtomicInteger(1);
                        mCreationSemaphores.put(key, semaphore);
                    } else {
                        semaphore.incrementAndGet();
                    }
                }
            }
            if (semaphore != null) {
                serializable = semaphore;
                synchronized (serializable) {
                    block24: {
                        HashMap<String, Object> hashMap;
                        try {
                            factory = mFactories.get(key);
                            if (factory != null) break block24;
                            factory = this.createFactory(destination, forRepository);
                            hashMap = mFactories;
                            synchronized (hashMap) {
                                mFactories.put(key, factory);
                            }
                        }
                        finally {
                            hashMap = mCreationSemaphores;
                            synchronized (hashMap) {
                                if (semaphore.decrementAndGet() == 0) {
                                    mCreationSemaphores.remove(key);
                                }
                            }
                        }
                    }
                }
            }
        }
        return factory;
    }

    protected ClientFactory createFactory(InternalDestination destination, boolean forRepository) throws JCoException {
        PoolingFactory factory = new PoolingFactory(destination, forRepository);
        ((ClientFactory)factory).init(destination);
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFactories(InternalDestination destination) {
        ClientFactory removed = null;
        ClientFactory removedRepositoryFactory = null;
        HashMap<String, ClientFactory> hashMap = mFactories;
        synchronized (hashMap) {
            removed = mFactories.remove(destination.getDestinationID());
            removedRepositoryFactory = mFactories.remove(destination.getRepositoryKey());
        }
        if (removed != null) {
            removed.clear();
            removed.removeDestinationMonitor();
        }
        if (removedRepositoryFactory != null) {
            removedRepositoryFactory.clear();
            removedRepositoryFactory.removeDestinationMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeFactory(ClientFactory factory) {
        if (factory.getCurrentPoolSize() > 0) {
            return false;
        }
        ClientFactory removed = null;
        HashMap<String, ClientFactory> hashMap = mFactories;
        synchronized (hashMap) {
            if (factory.getCurrentPoolSize() > 0) {
                return false;
            }
            removed = mFactories.remove(factory.getDestinationID());
        }
        if (removed != null) {
            removed.removeDestinationMonitor();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateFactory(RfcDestination oldDestination, RfcDestination newDestination) {
        ClientFactory oldFactory = mFactories.get(oldDestination.getDestinationID());
        if (oldFactory == null) {
            throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "error in ConnectionManager.updateFactory(): no factory found for the given destination");
        }
        if (oldDestination.equals(newDestination)) {
            HashMap<String, ClientFactory> hashMap = mFactories;
            synchronized (hashMap) {
                mFactories.remove(oldDestination.getDestinationID());
                mFactories.put(newDestination.getDestinationID(), oldFactory);
            }
            oldFactory.updateDestination(newDestination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void internalExecute(JCoFunction function, JCoDestination destination, boolean repositoryCall) throws JCoException {
        ClientConnection client = null;
        if (destination == null) {
            throw new JCoException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Destination is null and not allowed, hence the call cannot be executed.");
        }
        try {
            client = ConnectionManager.getConnectionManager().getClient((InternalDestination)destination, repositoryCall, false);
            client.execute(function, destination.getRepository());
        }
        finally {
            if (client != null) {
                ConnectionManager.getConnectionManager().releaseClient(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getMonitoredData(List<MonitoredConnectionData> monitoredData) {
        ArrayList<ClientFactory> factories = new ArrayList<ClientFactory>();
        HashMap<String, ClientFactory> hashMap = mFactories;
        synchronized (hashMap) {
            factories.addAll(mFactories.values());
        }
        Iterator it = factories.iterator();
        while (it.hasNext()) {
            ((ClientFactory)it.next()).getMonitoredData(monitoredData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ClientFactory> getCopyOfAllFactories() {
        ArrayList<ClientFactory> factories = new ArrayList<ClientFactory>();
        HashMap<String, ClientFactory> hashMap = mFactories;
        synchronized (hashMap) {
            factories.addAll(mFactories.values());
        }
        return factories;
    }

    ClientFactory getFactoryByDestinationID(String destinationID) {
        if (destinationID != null) {
            return mFactories.get(destinationID);
        }
        return null;
    }

    private class PoolFinalizer
    implements Runnable {
        private PoolFinalizer() {
        }

        @Override
        public void run() {
            ConnectionManager.this.clearAllFactories();
        }
    }
}

