/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt.trace;

import com.sap.conn.idoc.IDocTraceListener;
import com.sap.conn.idoc.rt.trace.TraceWriter;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Trace {
    public static final int NONE = 0;
    public static final int ERROR = 2;
    public static final int WARNING = 4;
    public static final int INFO = 8;
    public static final int INFO2 = 16;
    public static final int INFO3 = 32;
    public static final int PATH = 64;
    public static final int PATH2 = 128;
    public static final int PATH3 = 256;
    static final int DUMMY1 = 512;
    static final int DUMMY2 = 1024;
    public static final int ENFORCE = 0;
    protected static final String CRLF = System.getProperty("line.separator");
    protected static DateFormat timeStamp = new SimpleDateFormat("HH':'mm':'ss':'SSS");
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected static TraceWriter[] writerList = new TraceWriter[0];
    protected static IDocTraceListener[] listenerList = new IDocTraceListener[0];
    private static int envTraceLevel = 0;
    private static int writerCount = 0;
    private static int listenerCount = 0;
    protected static int idocLogLevel = 0;
    protected static int internalLogLevel = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addTraceWriter(TraceWriter writer) {
        if (writer == null) {
            return;
        }
        if (Trace.indexOf(writer) > -1) {
            return;
        }
        TraceWriter[] traceWriterArray = writerList;
        synchronized (writerList) {
            if (writerCount == writerList.length) {
                TraceWriter[] newList = new TraceWriter[writerList.length + 1];
                System.arraycopy(writerList, 0, newList, 0, writerList.length);
                writerList = newList;
            }
            Trace.writerList[Trace.writerCount++] = writer;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTracelistener(IDocTraceListener listener) {
        if (listener == null) {
            return;
        }
        IDocTraceListener[] iDocTraceListenerArray = listenerList;
        synchronized (listenerList) {
            if (Trace.indexOf(listener) > -1) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (listenerCount == listenerList.length) {
                IDocTraceListener[] newList = new IDocTraceListener[listenerList.length + 3];
                System.arraycopy(listenerList, 0, newList, 0, listenerList.length);
                listenerList = newList;
            }
            Trace.listenerList[Trace.listenerCount++] = listener;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeTraceWriter(TraceWriter writer) {
        if (writer == null) {
            return;
        }
        TraceWriter[] traceWriterArray = writerList;
        synchronized (writerList) {
            int idx = Trace.indexOf(writer);
            if (idx == -1) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (idx < writerCount - 1) {
                System.arraycopy(writerList, idx + 1, writerList, idx, writerCount - 1);
            }
            --writerCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTraceListener(IDocTraceListener listener) {
        if (listener == null) {
            return;
        }
        IDocTraceListener[] iDocTraceListenerArray = listenerList;
        synchronized (listenerList) {
            int idx = Trace.indexOf(listener);
            if (idx == -1) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (idx < listenerCount - 1) {
                System.arraycopy(listenerList, idx + 1, listenerList, idx, listenerCount - idx - 1);
            }
            --listenerCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int indexOf(IDocTraceListener listener) {
        IDocTraceListener[] iDocTraceListenerArray = listenerList;
        synchronized (listenerList) {
            for (int i = 0; i < listenerCount; ++i) {
                if (listener != listenerList[i]) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int indexOf(TraceWriter writer) {
        TraceWriter[] traceWriterArray = writerList;
        synchronized (writerList) {
            for (int i = 0; i < writerCount; ++i) {
                if (writer != writerList[i]) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return -1;
        }
    }

    public static int getTraceWriterCount() {
        return writerCount;
    }

    public static int getTraceListenerCount() {
        return listenerCount;
    }

    protected static int toExternalTraceLevel(int internalLevel) {
        if ((internalLevel & 2) != 0) {
            return 1;
        }
        if ((internalLevel & 4) != 0) {
            return 2;
        }
        if ((internalLevel & 8) != 0) {
            return 3;
        }
        if ((internalLevel & 0x40) != 0) {
            return 4;
        }
        if ((internalLevel & 0x80) != 0) {
            return 5;
        }
        if ((internalLevel & 0x10) != 0) {
            return 6;
        }
        if ((internalLevel & 0x100) != 0) {
            return 7;
        }
        if ((internalLevel & 0x20) != 0) {
            return 8;
        }
        if ((internalLevel & 0x200) != 0) {
            return 9;
        }
        if ((internalLevel & 0x400) != 0) {
            return 10;
        }
        return 0;
    }

    protected static int toInternalTraceLevel(int externalLevel) {
        int logLevel = 0;
        if (externalLevel > 10) {
            externalLevel = 10;
        }
        switch (externalLevel) {
            case 10: {
                logLevel = 2046;
                break;
            }
            case 9: {
                logLevel = 1022;
                break;
            }
            case 8: {
                logLevel = 510;
                break;
            }
            case 7: {
                logLevel = 478;
                break;
            }
            case 6: {
                logLevel = 222;
                break;
            }
            case 5: {
                logLevel = 206;
                break;
            }
            case 4: {
                logLevel = 78;
                break;
            }
            case 3: {
                logLevel = 14;
                break;
            }
            case 2: {
                logLevel = 6;
                break;
            }
            case 1: {
                logLevel = 2;
                break;
            }
            default: {
                logLevel = 0;
            }
        }
        return logLevel;
    }

    protected Trace() {
    }

    public abstract void trace(int var1, String var2);

    public static String dumpContent(char[] chars) {
        return Trace.dumpContent(chars, true, chars.length);
    }

    public static String dumpContent(char[] chars, boolean withHex, int lengthToDump) {
        if (chars == null) {
            chars = new char[]{};
        }
        if (lengthToDump < 0 || lengthToDump > chars.length) {
            lengthToDump = chars.length;
        }
        StringBuilder sb = new StringBuilder((lengthToDump + 19) / 20 * (33 + (withHex ? 84 : 0)));
        int[] offsets = new int[8];
        char[] hexs = new char[80];
        for (int i = 0; i < lengthToDump; i += 20) {
            int k;
            sb.append("|");
            for (k = 0; k < 8; ++k) {
                offsets[k] = i / (int)Math.pow(10.0, k) % 10;
            }
            for (k = 7; k >= 0; --k) {
                sb.append(offsets[k]);
            }
            sb.append("|");
            if (withHex) {
                for (k = 0; k < 20; ++k) {
                    if (i + k < chars.length) {
                        hexs[k * 4 + 0] = HEX[chars[i + k] >> 12 & 0xF];
                        hexs[k * 4 + 1] = HEX[chars[i + k] >> 8 & 0xF];
                        hexs[k * 4 + 2] = HEX[chars[i + k] >> 4 & 0xF];
                        hexs[k * 4 + 3] = HEX[chars[i + k] & 0xF];
                        continue;
                    }
                    hexs[k * 4 + 3] = 32;
                    hexs[k * 4 + 2] = 32;
                    hexs[k * 4 + 1] = 32;
                    hexs[k * 4] = 32;
                }
                for (k = 0; k < hexs.length; ++k) {
                    if (k != 0 && 0 == k % 20) {
                        sb.append(' ');
                    }
                    sb.append(hexs[k]);
                }
                sb.append('|');
            }
            for (k = 0; k < 20; ++k) {
                char curChar = i + k < chars.length ? chars[i + k] : (char)' ';
                sb.append(!Character.isISOControl(curChar) && Character.isDefined(curChar) && (curChar < '\ud800' || curChar >= '\ue000') ? curChar : (char)'.');
            }
            sb.append('|');
            sb.append(CRLF);
        }
        return sb.toString();
    }

    public static String dumpContent(byte[] bytes) {
        return Trace.dumpContent(bytes, bytes.length);
    }

    public static String dumpContent(byte[] bytes, int lengthToDump) {
        if (bytes == null) {
            bytes = new byte[]{};
        }
        if (lengthToDump < 0 || lengthToDump > bytes.length) {
            lengthToDump = bytes.length;
        }
        StringBuilder sb = new StringBuilder((lengthToDump + 39) / 40 * 96);
        int[] offsets = new int[8];
        char[] hexs = new char[80];
        for (int i = 0; i < lengthToDump; i += 40) {
            int k;
            sb.append("|");
            for (k = 0; k < 8; ++k) {
                offsets[k] = i / (int)Math.pow(10.0, k) % 10;
            }
            for (k = 7; k >= 0; --k) {
                sb.append(offsets[k]);
            }
            sb.append("|");
            for (k = 0; k < 40; ++k) {
                if (i + k < bytes.length) {
                    hexs[k * 2 + 0] = HEX[bytes[i + k] >> 4 & 0xF];
                    hexs[k * 2 + 1] = HEX[bytes[i + k] & 0xF];
                    continue;
                }
                hexs[k * 2 + 1] = 32;
                hexs[k * 2] = 32;
            }
            for (k = 0; k < hexs.length; ++k) {
                if (k != 0 && 0 == k % 20) {
                    sb.append(' ');
                }
                sb.append(hexs[k]);
            }
            sb.append('|');
            sb.append(CRLF);
        }
        return sb.toString();
    }

    protected static int setTraceLevel(int level) {
        if (level > 10) {
            level = 10;
        }
        if (level < envTraceLevel) {
            level = envTraceLevel;
        }
        int logLevel = Trace.toInternalTraceLevel(level);
        Trace.setLogLevel(logLevel);
        return level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLogLevel(int level) {
        idocLogLevel = level;
        TraceWriter[] traceWriterArray = writerList;
        synchronized (writerList) {
            int writersLogLevel = 0;
            for (int i = 0; i < writerCount; ++i) {
                writersLogLevel |= writerList[i].getTraceLevel();
            }
            internalLogLevel = writersLogLevel | idocLogLevel;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean isOn(int level) {
        return (level & internalLogLevel) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean isOn(int level, boolean check) {
        if (check) {
            TraceWriter[] traceWriterArray = writerList;
            // MONITORENTER : writerList
            int writersLogLevel = 0;
            for (int i = 0; i < writerCount; writersLogLevel |= writerList[i].getTraceLevel(), ++i) {
            }
            internalLogLevel = writersLogLevel | idocLogLevel;
            // MONITOREXIT : traceWriterArray
        }
        if ((level & internalLogLevel) == 0) return false;
        return true;
    }

    public static void fireTrace(int level, String text, Throwable causedBy) {
        if (Trace.isOn(level)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.write(text);
            if (causedBy != null) {
                pw.write(" stack trace");
                pw.write(CRLF);
                causedBy.printStackTrace(pw);
            }
            pw.flush();
            Trace.fireTrace(level, sw.getBuffer().toString());
        }
    }

    public static void fireTrace(int level, Throwable causedBy) {
        Trace.fireTrace(level, "exception occurred:", causedBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fireTraceCritical(String msg) {
        try {
            if (!Trace.isOn(2, true)) return;
            TraceWriter[] traceWriterArray = writerList;
            synchronized (writerList) {
                for (int i = 0; i < writerCount; ++i) {
                    try {
                        writerList[i].trace(2, msg);
                        continue;
                    }
                    catch (Throwable th) {
                        // empty catch block
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                int standaloneTraceLevel = Trace.toExternalTraceLevel(2);
                IDocTraceListener[] iDocTraceListenerArray = listenerList;
                synchronized (listenerList) {
                    for (int i = 0; i < listenerCount; ++i) {
                        try {
                            listenerList[i].trace(standaloneTraceLevel, msg);
                            continue;
                        }
                        catch (Throwable th) {
                            // empty catch block
                        }
                    }
                    // ** MonitorExit[var2_5] (shouldn't be in output)
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void fireTraceCritical(String msg, boolean where) {
        try {
            if (where) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                new Throwable().fillInStackTrace().printStackTrace(pw);
                pw.close();
                StringBuilder sb = new StringBuilder((msg != null ? msg.length() : 4) + 10 + sw.getBuffer().length());
                sb.append(msg).append(' ').append(CRLF).append("Stack trace of the call").append(CRLF).append(sw.getBuffer().delete(0, "java.lang.Throwable".length()).toString());
                msg = sb.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Trace.fireTraceCritical(msg);
    }

    public static void fireTraceCritical(String msg, Throwable th) {
        try {
            if (th != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                th.printStackTrace(pw);
                pw.close();
                StringBuilder sb = new StringBuilder((msg != null ? msg.length() : 4) + 1 + sw.getBuffer().length());
                sb.append(msg).append(' ').append(sw.getBuffer().toString());
                msg = sb.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Trace.fireTraceCritical(msg);
    }

    protected static String levelToString(int level) {
        StringBuilder sb = new StringBuilder(level * 6);
        if ((level & 2) != 0) {
            sb.append(" ERROR");
        }
        if ((level & 4) != 0) {
            sb.append(" WARNING");
        }
        if ((level & 0x40) != 0) {
            sb.append(" PATH");
        }
        if ((level & 0x80) != 0) {
            sb.append(" PATH2");
        }
        if ((level & 0x100) != 0) {
            sb.append(" PATH3");
        }
        if ((level & 8) != 0) {
            sb.append(" INFO");
        }
        if ((level & 0x10) != 0) {
            sb.append(" INFO2");
        }
        if ((level & 0x20) != 0) {
            sb.append(" INFO3");
        }
        return sb.toString();
    }

    public static void fireTrace(int level, String msg) {
        try {
            Trace.fireTrace(level, msg, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fireTrace(int level, String msg, boolean where) {
        if (where) {
            try {
                Throwable t = new Throwable();
                t.fillInStackTrace();
                StackTraceElement[] stackTrace = t.getStackTrace();
                StringBuilder sb = new StringBuilder(stackTrace.length * 100 + (msg != null ? msg.length() : 4));
                sb.append(msg).append(CRLF);
                for (int i = 1; i < stackTrace.length; ++i) {
                    sb.append("\tinvoked at ").append(stackTrace[i]).append(CRLF);
                }
                msg = sb.toString();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if ((level & internalLogLevel) == 0 && level != 0) return;
        TraceWriter[] e = writerList;
        synchronized (writerList) {
            for (int i = 0; i < writerCount; ++i) {
                try {
                    writerList[i].trace(level, msg);
                    continue;
                }
                catch (Throwable e2) {
                    // empty catch block
                }
            }
            // ** MonitorExit[e] (shouldn't be in output)
            int standaloneTraceLevel = Trace.toExternalTraceLevel(level);
            IDocTraceListener[] iDocTraceListenerArray = listenerList;
            synchronized (listenerList) {
                for (int i = 0; i < listenerCount; ++i) {
                    try {
                        listenerList[i].trace(standaloneTraceLevel, msg);
                        continue;
                    }
                    catch (Throwable e3) {
                        // empty catch block
                    }
                }
                // ** MonitorExit[var4_8] (shouldn't be in output)
                return;
            }
        }
    }

    protected abstract String getOwnFilePath();

    protected abstract Properties getProperties();

    protected abstract String getVersion();

    protected static String getFilePathToClass(Class<?> cls) {
        String filepath = null;
        try {
            String ptc;
            String rsc = cls.getName().replace('.', '/') + ".class";
            URL url = cls.getClassLoader().getResource(rsc);
            String string = ptc = url != null ? url.getProtocol() : null;
            if ("jar".equals(ptc) || "file".equals(ptc)) {
                filepath = URLDecoder.decode(url.getFile(), "UTF-8");
                if ((filepath = filepath.substring(0, filepath.length() - rsc.length() - ("jar".equals(ptc) ? 2 : 1))).startsWith("jar:")) {
                    filepath = filepath.substring(4);
                }
                if (filepath.startsWith("file:")) {
                    filepath = filepath.substring(5);
                }
                filepath = new File(filepath).getCanonicalPath();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return filepath;
    }

    protected void writeInfo(IDocTraceListener tl) {
        if (tl == null) {
            return;
        }
        tl.trace(2, "************************  " + new Date() + "  ************************");
        tl.trace(8, "SAP Java IDoc Class Library runtime information");
        tl.trace(8, "");
        String os_version = System.getProperty("os.name") + " " + System.getProperty("os.version") + " for " + System.getProperty("os.arch");
        String java_version = System.getProperty("java.version") + " " + System.getProperty("java.vendor");
        String default_charset = Charset.defaultCharset().name();
        tl.trace(8, "Java Runtime:");
        tl.trace(8, "\tOperating System    : " + os_version);
        tl.trace(8, "\tJava VM             : " + java_version);
        tl.trace(8, "\tDefault charset     : " + default_charset);
        tl.trace(8, "");
        String idoc_version = "7.30.11 (2013-08-15)";
        String idoc_path = null;
        try {
            idoc_version = this.getVersion();
            idoc_path = this.getOwnFilePath();
        }
        catch (Throwable t) {
            // empty catch block
        }
        String jco_version = null;
        String jco_path = null;
        try {
            Class<?> jcoClass = Class.forName("com.sap.conn.jco.JCo");
            jco_path = Trace.getFilePathToClass(jcoClass);
            Method getVersionM = jcoClass.getMethod("getVersion", null);
            jco_version = (String)getVersionM.invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            // empty catch block
        }
        tl.trace(8, "Versions:");
        tl.trace(2, "\tIDoc API             : " + (idoc_version == null || idoc_version.length() == 0 ? "unknown" : idoc_version));
        tl.trace(8, "\tJCo API              : " + (jco_version == null || jco_version.length() == 0 ? "unknown" : jco_version));
        tl.trace(8, "");
        tl.trace(8, "Library Paths:");
        tl.trace(8, "\tPath to IDoc archive : " + (idoc_path == null || idoc_path.length() == 0 ? "not found" : idoc_path));
        tl.trace(8, "\tPath to JCo archive  : " + (jco_path == null || jco_path.length() == 0 ? "not found" : jco_path));
        tl.trace(8, "");
        Properties rtProps = this.getProperties();
        if (rtProps != null && rtProps.size() > 0) {
            StringBuilder sb = new StringBuilder(80);
            tl.trace(8, "Configuration:");
            for (Object key : rtProps.keySet()) {
                sb.append('\t').append(key).append(" = ").append(rtProps.getProperty((String)key));
                tl.trace(8, sb.toString());
                sb.setLength(0);
            }
            tl.trace(8, "");
        }
        tl.trace(8, "********************************************************************************");
    }

    static {
        try {
            envTraceLevel = Integer.parseInt(System.getProperty("idoc.trace_level", "0"));
        }
        catch (Exception e) {
            envTraceLevel = 0;
        }
    }
}

