/*
 * Copyright 2013 Red Hat Inc. and/or its affiliates and other contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,  
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.switchyard.component.camel.common.transacted;

import java.util.Map;

import org.apache.camel.component.direct.DirectConsumer;
import org.apache.camel.component.direct.DirectEndpoint;
import org.springframework.transaction.PlatformTransactionManager;

public class TransactedDirectEndpoint extends DirectEndpoint {

    private PlatformTransactionManager manager;

    public TransactedDirectEndpoint(String uri, TransactedDirectComponent component, Map<String, DirectConsumer> consumers) {
        super(uri, component, consumers);
    }

    public void setTransactionManager(PlatformTransactionManager manager) {
        this.manager = manager;
    }

    public PlatformTransactionManager getTransactionManager() {
        return manager;
    }

}
