/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoClassMetaData;
import com.sap.conn.jco.JCoCustomRepository;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.rt.AbapRepository;
import com.sap.conn.jco.rt.ClientConnection;
import com.sap.conn.jco.rt.ConnectionManager;
import com.sap.conn.jco.rt.Context;
import com.sap.conn.jco.rt.DefaultClassMetaData;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.DynamicRecordMetaData;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.Trace;

public class CustomRepository
extends AbapRepository
implements JCoCustomRepository {
    private boolean useNonUnicodeLayoutOnly = false;
    private boolean useRepositoryConnections = true;
    private Context ctx;

    protected CustomRepository(String name) {
        super(name);
    }

    public void setContainsUnicodeInfo(boolean isUnicode) {
        this.containsUnicodeInfo = isUnicode;
    }

    @Override
    public void addFunctionTemplateToCache(JCoFunctionTemplate meta) {
        this.addFunctionTemplate(meta);
    }

    @Override
    public void addRecordMetaDataToCache(JCoRecordMetaData meta) {
        this.addRecordMetaData(meta);
    }

    @Override
    public void addClassMetaDataToCache(JCoClassMetaData meta) {
        this.addClassMetaData(meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDestination(JCoDestination abapDestination) throws JCoException, JCoRuntimeException {
        this.lastAccessTimestamp = System.currentTimeMillis();
        InternalDestination oldDestination = (InternalDestination)this.destinationList.getCurrentDestination();
        if (abapDestination == null) {
            if (oldDestination != null) {
                this.destinationList.removeDestination(oldDestination);
            }
            this.partnerRelease = null;
            this.repository_version = 0;
            this.containsUnicodeInfo = false;
            this.ddicHelper = null;
            return;
        }
        if (!(abapDestination instanceof InternalDestination)) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only destination instances that have been created by the JCo runtime are allowed. Passed destination " + abapDestination.getDestinationName() + " is an instance of class " + abapDestination.getClass().getName());
        }
        InternalDestination newDestination = (InternalDestination)abapDestination;
        if (newDestination == oldDestination) {
            return;
        }
        String oldID = null;
        if (oldDestination != null) {
            oldID = oldDestination.getOriginDestinationID(this.useRepositoryConnections);
        }
        if (oldID == null || !oldID.equals(newDestination.getOriginDestinationID(this.useRepositoryConnections))) {
            int version;
            ClientConnection client = null;
            try {
                client = ConnectionManager.getConnectionManager().getClient(newDestination, this.useRepositoryConnections, false);
                version = client.getAttributes().getPartnerReleaseNumber();
            }
            finally {
                if (client != null) {
                    ConnectionManager.getConnectionManager().releaseClient(client);
                }
            }
            if (version == 0) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only destinations to an SAP AS ABAP system are allowed. Passed destination " + abapDestination.getDestinationName() + " is invalid because the system reports its release to be of version 0");
            }
            this.destinationList.addDestination(newDestination);
            if (oldDestination != null) {
                this.destinationList.removeDestination(oldDestination);
            }
            this.partnerRelease = client.getAttributes().getPartnerRelease();
            this.repository_version = version;
            this.containsUnicodeInfo = this.useNonUnicodeLayoutOnly ? false : this.repository_version > 463;
            this.ddicHelper = this.initDDICHelper();
        } else {
            this.destinationList.addDestination(newDestination);
            if (oldDestination != null) {
                this.destinationList.removeDestination(oldDestination);
            }
        }
    }

    @Override
    public void setQueryMode(JCoCustomRepository.QueryMode queryMode) {
        this.lastAccessTimestamp = System.currentTimeMillis();
        switch (queryMode) {
            case ALL_AVAILABLE_LAYOUTS: {
                this.useNonUnicodeLayoutOnly = false;
                this.containsUnicodeInfo = this.repository_version > 463;
                break;
            }
            case NON_UNICODE_LAYOUT_ONLY: {
                this.useNonUnicodeLayoutOnly = true;
                this.containsUnicodeInfo = false;
                break;
            }
            case DISABLE_REPOSITORY_POOL: {
                this.useRepositoryConnections = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ClientConnection getClient(InternalDestination destination, boolean useRepositoryPool) throws JCoException {
        if (this.useRepositoryConnections) {
            return super.getClient(destination, useRepositoryPool);
        }
        Object object = this.semaphore;
        synchronized (object) {
            if (this.ctx != null) {
                throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "This instance of the custom repository is currently used. Because the DISABLE_REPOSITORY_POOL mode is set only one query may be executed.");
            }
            this.ctx = JCoRuntimeFactory.getRuntime().getRuntimeContext(null);
            if (Trace.isOn(64)) {
                StringBuilder buf = new StringBuilder("[JCoAPI] destination ").append(this.name).append(" destinationID=").append(destination.getDestinationID()).append(" executes repository call sessionID=").append(this.ctx.sessionID).append(", threadID=0x").append(Long.toHexString(Thread.currentThread().getId()));
                Trace.fireTrace(64, buf.toString());
            }
            return this.ctx.getConnection(destination, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void releaseClient(ClientConnection client, InternalDestination destination) throws JCoException {
        if (this.useRepositoryConnections) {
            super.releaseClient(client, destination);
        } else {
            try {
                this.ctx.releaseConnection(destination, client);
            }
            finally {
                this.ctx = null;
            }
        }
    }

    @Override
    DefaultClassMetaData queryClassMetaData(String className, InternalDestination destination, boolean useRepositoryPool) throws JCoException {
        if (destination == null) {
            return null;
        }
        return super.queryClassMetaData(className, destination, useRepositoryPool);
    }

    @Override
    JCoFunctionTemplate queryFunctionTemplate(String functionName, InternalDestination destination, boolean useRepositoryPool) throws JCoException {
        if (destination == null) {
            return null;
        }
        return super.queryFunctionTemplate(functionName, destination, useRepositoryPool);
    }

    @Override
    DefaultRecordMetaData queryRecordMetaData(String recordName, InternalDestination destination, boolean useRepositoryPool) throws JCoException {
        if (destination == null) {
            return null;
        }
        return super.queryRecordMetaData(recordName, destination, useRepositoryPool);
    }

    @Override
    public void resolveDynamicRecordMetaData(DynamicRecordMetaData meta) throws JCoException {
        this.lastAccessTimestamp = System.currentTimeMillis();
        InternalDestination destination = (InternalDestination)this.destinationList.getCurrentDestination();
        if (destination != null) {
            this.ddicHelper.resolveDynamicRecordMetaData(meta, destination, this.useRepositoryConnections);
        }
    }
}

