/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt;

import com.sap.conn.idoc.IDocTraceListener;
import com.sap.conn.idoc.rt.DefaultIDocRuntime;
import com.sap.conn.idoc.rt.trace.Trace;
import com.sap.conn.idoc.rt.util.SyncDateFormat;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import java.util.Properties;

public final class DefaultTrace
extends Trace
implements IDocTraceListener {
    public final String STDOUT = "stdout";
    public final String STDERR = "stderr";
    private static final int MAX_TRACE_FILE_LENGTH = 0x1400000;
    private static final SyncDateFormat fTime = new SyncDateFormat("HH':'mm':'ss':'SSS");
    private static final SyncDateFormat fileNameTimestampFormat = new SyncDateFormat("'IDoc'yyyyMMdd'_'HHmmssSSS");
    private static int idocTraceLevel = 0;
    private static String idocTracePath = null;
    private static IDocTraceListener singleton = null;
    private String baseTraceFileName = "";
    private File traceFile = null;
    private Writer traceWriter = null;
    private Writer stdTraceWriter = null;
    private int files_count = 0;
    private static Object monitor = new Object();

    public void setTrace(int level, String path) {
        if (level < idocTraceLevel) {
            level = idocTraceLevel;
        }
        Trace.setTraceLevel(level);
        if (path == null || !path.equals(idocTracePath)) {
            if (!this.isStandardOutputOn()) {
                this.closeTraceWriter();
            }
            idocTracePath = path;
        }
    }

    public static int getStandaloneTraceLevel(int internalLevel) {
        return Trace.toExternalTraceLevel(internalLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDocTraceListener getListener() {
        Object object = monitor;
        synchronized (object) {
            if (singleton == null) {
                singleton = new DefaultTrace();
            }
            return singleton;
        }
    }

    public boolean isStandardOutputOn() {
        return idocTracePath == null || idocTracePath.equals("stdout") || idocTracePath.equals("stderr");
    }

    private Writer createNewFile(File file) {
        BufferedWriter writer = null;
        try {
            try {
                FileOutputStream fos = new FileOutputStream(file);
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
                new DataOutputStream(fos).write(new byte[]{-17, -69, -65}, 0, 3);
                fos.flush();
            }
            catch (UnsupportedEncodingException e) {
                writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            }
            return writer;
        }
        catch (IOException ex) {
            throw new RuntimeException("IDocLibrary-TraceWriter: cannot open trace file [" + file.getAbsolutePath() + "]", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTraceWriter() {
        try {
            Object object = monitor;
            synchronized (object) {
                if (this.traceWriter != null) {
                    this.traceWriter.close();
                    this.traceWriter = null;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Writer getWriter() {
        if (this.traceWriter != null) {
            try {
                if (this.traceFile != null && this.traceFile.length() > 0x1400000L) {
                    this.traceWriter.close();
                    String traceFileName = this.baseTraceFileName + '.' + ++this.files_count + ".trc";
                    this.traceFile = new File(traceFileName.toString());
                    this.traceWriter = this.createNewFile(this.traceFile);
                    this.writeInfo(this);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("TraceWriter exception: " + ex.toString(), ex);
            }
            return this.traceWriter;
        }
        if (idocTracePath == null && this.stdTraceWriter != null) {
            return this.stdTraceWriter;
        }
        String path = "stdout";
        if (idocTracePath != null) {
            path = idocTracePath;
        }
        if (path.equalsIgnoreCase("stdout")) {
            this.stdTraceWriter = new BufferedWriter(new OutputStreamWriter(System.out));
        } else if (path.equalsIgnoreCase("stderr")) {
            this.stdTraceWriter = new BufferedWriter(new OutputStreamWriter(System.err));
        } else {
            if (!new File(path).isDirectory()) {
                path = ".";
            }
            StringBuilder traceFileName = new StringBuilder(path);
            traceFileName.append(File.separator);
            traceFileName.append(fileNameTimestampFormat.format(new Date()));
            this.baseTraceFileName = traceFileName.toString();
            traceFileName.append(".trc");
            this.traceFile = new File(traceFileName.toString());
            this.traceWriter = this.createNewFile(this.traceFile);
            this.writeInfo(this);
            return this.traceWriter;
        }
        return this.stdTraceWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(int messageLevel, String message) {
        Writer traceWriter = null;
        try {
            Object object = monitor;
            synchronized (object) {
                traceWriter = this.getWriter();
                traceWriter.write(Thread.currentThread().getName());
                traceWriter.write(" [");
                traceWriter.write(fTime.format(new Date()));
                traceWriter.write("]");
                traceWriter.write(": ");
                traceWriter.write(message);
                traceWriter.write(CRLF);
                traceWriter.flush();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    protected String getOwnFilePath() {
        return DefaultTrace.getFilePathToClass(DefaultIDocRuntime.get().getClass());
    }

    protected Properties getProperties() {
        return DefaultIDocRuntime.properties;
    }

    protected String getVersion() {
        return DefaultIDocRuntime.get().getVersion();
    }

    static void setIDocTraceLevel(int level) {
        Trace.setTraceLevel(level);
    }
}

