/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.jco.rt;

import com.sap.conn.idoc.IDocRuntimeException;
import com.sap.conn.idoc.IDocSegmentMetaData;
import com.sap.conn.idoc.jco.rt.JCoIDocRepositoryManager;
import com.sap.conn.idoc.jco.rt.JCoIDocRuntime;
import com.sap.conn.idoc.jco.rt.JCoStaticRepositories;
import com.sap.conn.idoc.jco.rt.JCoStaticRepository;
import com.sap.conn.idoc.monitor.IDocRepositoryMonitor;
import com.sap.conn.idoc.rt.BasicIDocRepository;
import com.sap.conn.idoc.rt.DefaultIDocFieldMetaData;
import com.sap.conn.idoc.rt.DefaultIDocRecordMetaData;
import com.sap.conn.idoc.rt.DefaultIDocSegmentMetaData;
import com.sap.conn.idoc.rt.trace.Trace;
import com.sap.conn.idoc.rt.util.Int;
import com.sap.conn.idoc.rt.util.Utils;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.rt.ClientConnection;
import com.sap.conn.jco.rt.DefaultConnectionManager;
import com.sap.conn.jco.rt.DestinationList;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.RfcDestination;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SAPRepository
extends BasicIDocRepository {
    static final long serialVersionUID = 3007L;
    private static SAPRepository connectionRepository = new SAPRepository();
    protected long m_lastRemoteQueryTimestamp = 0L;
    protected transient DestinationList<JCoDestination> destinationList;
    protected String m_partnerRelease = null;
    protected transient Hashtable<String, Object> m_querySemaphores = new Hashtable(11);
    protected transient Object m_iDocCompoundTypeQuerySemaphore = new Object();
    protected int m_iDocCompoundTypeKeysInSegmentMetaDataCache = 0;
    protected boolean m_iDocCompoundTypesQueried = false;
    protected Hashtable<String, String[]> m_iDocOutboundMessageReleaseCache = null;
    private transient ConnectionProvider connectionProvider = new ConnectionProvider();

    private SAPRepository() {
        super("$$internal$$");
    }

    protected SAPRepository(String repositoryName, JCoDestination destination) throws JCoException {
        super(repositoryName);
        this.destinationList = new DestinationList((Object)destination);
        this.m_partnerRelease = this.connectionProvider.getPartnerRelease();
    }

    static String getSystemID(JCoDestination jcoDestination) throws JCoException {
        return connectionRepository.getSystemIDInstance(jcoDestination);
    }

    private String getSystemIDInstance(JCoDestination jcoDestination) throws JCoException {
        return this.connectionProvider.getSystemID(jcoDestination);
    }

    protected static void addFieldMetaDataValueRanges(Hashtable<String, DefaultIDocRecordMetaData> recordMetaDataHashtable, Hashtable<String, Integer> fieldMetaDataIndexHashtable, JCoTable metaFValuesTable) {
        if (metaFValuesTable.getNumRows() == 0) {
            return;
        }
        DefaultIDocRecordMetaData recordMetaData = null;
        DefaultIDocFieldMetaData fieldMetaData = null;
        Integer integer = null;
        int fieldIndex = -1;
        String type = null;
        String nextType = null;
        String fieldName = null;
        String nextFieldName = null;
        boolean nextRow = true;
        metaFValuesTable.firstRow();
        type = metaFValuesTable.getString(0);
        fieldName = metaFValuesTable.getString(1);
        do {
            recordMetaData = recordMetaDataHashtable.get(type);
            do {
                fieldMetaData = null;
                if (recordMetaData != null && (integer = fieldMetaDataIndexHashtable.get(DefaultIDocFieldMetaData.createKey(type, fieldName))) != null && (fieldIndex = integer.intValue()) >= 0 && fieldIndex < recordMetaData.getNumFields()) {
                    fieldMetaData = recordMetaData.getFieldMetaData(fieldIndex);
                }
                do {
                    if (fieldMetaData != null) {
                        fieldMetaData.addValueRange(metaFValuesTable.getString(2), metaFValuesTable.getString(3), metaFValuesTable.getString(4));
                    }
                    if (!(nextRow = metaFValuesTable.nextRow())) continue;
                    nextType = metaFValuesTable.getString(0);
                    nextFieldName = metaFValuesTable.getString(1);
                } while (nextRow && fieldName.equals(nextFieldName) && type.equals(nextType));
                fieldName = nextFieldName;
            } while (nextRow && type.equals(nextType));
            type = nextType;
        } while (nextRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addIDocOutboundMessageReleaseToCache(String key, String[] iDocOutboundMessageRelease) {
        if (key == null || key.length() == 0 || iDocOutboundMessageRelease == null || iDocOutboundMessageRelease.length != 2 || iDocOutboundMessageRelease[0] == null) {
            return;
        }
        if (this.m_iDocOutboundMessageReleaseCache == null) {
            SAPRepository sAPRepository = this;
            synchronized (sAPRepository) {
                if (this.m_iDocOutboundMessageReleaseCache == null) {
                    this.m_iDocOutboundMessageReleaseCache = new Hashtable(47);
                }
            }
        }
        this.m_iDocOutboundMessageReleaseCache.put(key, iDocOutboundMessageRelease);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        super.clear();
        if (this.m_iDocCompoundTypesCache != null) {
            SAPRepository sAPRepository = this;
            synchronized (sAPRepository) {
                this.m_iDocCompoundTypesCache = new Hashtable(47);
                this.m_iDocCompoundTypeKeysInSegmentMetaDataCache = 0;
                this.m_iDocCompoundTypesQueried = false;
            }
        } else {
            this.m_iDocCompoundTypesQueried = false;
        }
        if (this.m_iDocOutboundMessageReleaseCache != null) {
            this.m_iDocOutboundMessageReleaseCache = new Hashtable(47);
        }
    }

    protected static String createIDocMessagePartnerProfileKey(String client, String partnerNumber, String partnerType, String partnerFunction, String messageType, String messageCode, String messageFunction, String testFlag) {
        StringBuilder key = new StringBuilder(61);
        if (client != null) {
            key.append(client);
        }
        key.append('|');
        if (partnerNumber != null) {
            key.append(partnerNumber);
        }
        key.append('|');
        if (partnerType != null) {
            key.append(partnerType);
        }
        key.append('|');
        if (partnerFunction != null) {
            key.append(partnerFunction);
        }
        key.append('|');
        if (messageType != null) {
            key.append(messageType);
        }
        key.append('|');
        if (messageCode != null) {
            key.append(messageCode);
        }
        key.append('|');
        if (messageFunction != null) {
            key.append(messageFunction);
        }
        key.append('|');
        if (testFlag != null) {
            key.append(testFlag);
        }
        return key.toString();
    }

    protected static Hashtable<String, String> createIDocCompoundTypesHashtable(JCoTable tabEDIDOFields, JCoTable tabEDIDOData) {
        if (tabEDIDOFields == null || tabEDIDOData == null) {
            return null;
        }
        int numRowsData = tabEDIDOData.getNumRows();
        if (numRowsData == 0 || tabEDIDOFields.getNumRows() == 0) {
            return null;
        }
        int iDocCompoundTypeOffset = -1;
        int iDocCompoundTypeEnd = 0;
        int iDocTypeOffset = -1;
        int iDocTypeEnd = 0;
        int iDocTypeExtensionOffset = -1;
        int iDocTypeExtensionEnd = 0;
        boolean complete = false;
        String fieldName = null;
        tabEDIDOFields.firstRow();
        do {
            if ("DOCTYP".equals(fieldName = tabEDIDOFields.getString(0))) {
                iDocCompoundTypeOffset = tabEDIDOFields.getInt(1);
                iDocCompoundTypeEnd = iDocCompoundTypeOffset + tabEDIDOFields.getInt(2);
                if (iDocTypeOffset < 0 || iDocTypeExtensionOffset < 0) continue;
                complete = true;
                continue;
            }
            if ("IDOCTYP".equals(fieldName)) {
                iDocTypeOffset = tabEDIDOFields.getInt(1);
                iDocTypeEnd = iDocTypeOffset + tabEDIDOFields.getInt(2);
                if (iDocCompoundTypeOffset < 0 || iDocTypeExtensionOffset < 0) continue;
                complete = true;
                continue;
            }
            if (!"CIMTYP".equals(fieldName)) continue;
            iDocTypeExtensionOffset = tabEDIDOFields.getInt(1);
            iDocTypeExtensionEnd = iDocTypeExtensionOffset + tabEDIDOFields.getInt(2);
            if (iDocCompoundTypeOffset < 0 || iDocTypeOffset < 0) continue;
            complete = true;
        } while (tabEDIDOFields.nextRow() && !complete);
        if (!complete) {
            return null;
        }
        Hashtable<String, String> iDocCompoundTypesHashtable = new Hashtable<String, String>(numRowsData);
        String dataRow = null;
        String iDocType = null;
        String iDocTypeExtension = null;
        String iDocCompoundType = null;
        String key = null;
        tabEDIDOData.firstRow();
        do {
            dataRow = tabEDIDOData.getString(0);
            iDocCompoundType = dataRow.substring(iDocCompoundTypeOffset, iDocCompoundTypeEnd).trim();
            iDocType = dataRow.substring(iDocTypeOffset, iDocTypeEnd).trim();
            iDocTypeExtension = dataRow.substring(iDocTypeExtensionOffset, iDocTypeExtensionEnd).trim();
            key = SAPRepository.createIDocCompoundTypeKey(iDocType, iDocTypeExtension);
            iDocCompoundTypesHashtable.put(key, iDocCompoundType);
        } while (tabEDIDOData.nextRow());
        return iDocCompoundTypesHashtable;
    }

    protected IDocSegmentMetaData createRootSegmentMetaData31(String iDocType, String iDocTypeExtension, String systemRelease, JCoTable metaSegmentsTable) throws AbapException {
        boolean nextRow;
        DefaultIDocSegmentMetaData rootSegmentMetaData = null;
        DefaultIDocSegmentMetaData segmentMetaData = null;
        DefaultIDocSegmentMetaData parentSegmentMetaData = null;
        DefaultIDocRecordMetaData recordMetaData = null;
        Int segmentMetaDataLength = new Int();
        Hashtable<Integer, DefaultIDocSegmentMetaData> segmentMetaDataHashtable = new Hashtable<Integer, DefaultIDocSegmentMetaData>(51);
        Integer segmentMetaDataNumber = null;
        Integer parentSegmentMetaDataNumber = null;
        String segmentMetaDataType = null;
        String segmentMetaDataDefinition = null;
        String segmentMetaDataDescription = null;
        boolean segmentMetaDataIsMandatory = false;
        long segmentMetaDataMinOccurrence = 0L;
        long segmentMetaDataMaxOccurrence = 0L;
        boolean bl = nextRow = metaSegmentsTable.getNumRows() > 0;
        if (nextRow) {
            metaSegmentsTable.firstRow();
            String rootSegmentIDocCompoundTypeKey = null;
            String iDocCompoundType = metaSegmentsTable.getString(11);
            if (iDocCompoundType != null && iDocCompoundType.length() > 0) {
                String realIDocType = metaSegmentsTable.getString(0);
                String realIDocTypeExtension = metaSegmentsTable.getString(1);
                if (realIDocType != null && realIDocType.length() > 0 && !realIDocType.equals(iDocType) || realIDocTypeExtension != null && realIDocTypeExtension.length() > 0 && !realIDocTypeExtension.equals(iDocTypeExtension)) {
                    rootSegmentIDocCompoundTypeKey = DefaultIDocSegmentMetaData.createKey(iDocType, iDocTypeExtension, systemRelease, null, "ROOT");
                    iDocType = realIDocType;
                    iDocTypeExtension = realIDocTypeExtension;
                }
                this.addIDocCompoundTypeToCache(iDocType, iDocTypeExtension, iDocCompoundType);
            }
            rootSegmentMetaData = JCoIDocRuntime.get().createIDocRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, null, "ROOT", metaSegmentsTable.getInt(10) - 1, "General root segment");
            segmentMetaDataHashtable.put(new Integer(0), rootSegmentMetaData);
            if (rootSegmentIDocCompoundTypeKey != null && this.m_segmentMetaDataCache.put(rootSegmentIDocCompoundTypeKey, rootSegmentMetaData) == null) {
                ++this.m_iDocCompoundTypeKeysInSegmentMetaDataCache;
                this.m_latestCachedIDocTypes = null;
            }
        } else {
            rootSegmentMetaData = JCoIDocRuntime.get().createIDocRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, null, "ROOT", 0, "General root segment");
        }
        while (nextRow) {
            segmentMetaDataNumber = new Integer(metaSegmentsTable.getInt(2));
            parentSegmentMetaDataNumber = new Integer(metaSegmentsTable.getInt(5));
            segmentMetaDataType = metaSegmentsTable.getString(3);
            segmentMetaDataDefinition = this.querySegmentDefinition31(segmentMetaDataType, systemRelease, segmentMetaDataLength);
            segmentMetaDataIsMandatory = metaSegmentsTable.getChar(7) == 'X';
            segmentMetaDataMinOccurrence = metaSegmentsTable.getLong(8);
            segmentMetaDataMaxOccurrence = metaSegmentsTable.getLong(9);
            segmentMetaDataDescription = this.querySegmentDescription31(segmentMetaDataType);
            recordMetaData = this.queryRecordMetaData31(segmentMetaDataType, segmentMetaDataLength.value());
            segmentMetaData = JCoIDocRuntime.get().createIDocSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, null, segmentMetaDataType, segmentMetaDataDefinition, metaSegmentsTable.getInt(10), segmentMetaDataDescription, segmentMetaDataIsMandatory, segmentMetaDataMinOccurrence, segmentMetaDataMaxOccurrence, false, recordMetaData);
            parentSegmentMetaData = (DefaultIDocSegmentMetaData)segmentMetaDataHashtable.get(parentSegmentMetaDataNumber);
            segmentMetaDataHashtable.put(segmentMetaDataNumber, segmentMetaData);
            parentSegmentMetaData.addChild(segmentMetaData);
            nextRow = metaSegmentsTable.nextRow();
        }
        rootSegmentMetaData.lock();
        return rootSegmentMetaData;
    }

    protected static IDocSegmentMetaData createRootSegmentMetaData40(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, JCoTable metaSegmentsTable, Hashtable<String, DefaultIDocRecordMetaData> recordMetaDataHashtable) {
        boolean nextRow;
        DefaultIDocSegmentMetaData rootSegmentMetaData = null;
        DefaultIDocSegmentMetaData segmentMetaData = null;
        DefaultIDocSegmentMetaData parentSegmentMetaData = null;
        DefaultIDocRecordMetaData recordMetaData = null;
        Hashtable<Integer, DefaultIDocSegmentMetaData> segmentMetaDataHashtable = new Hashtable<Integer, DefaultIDocSegmentMetaData>(51);
        Integer segmentMetaDataNumber = null;
        Integer parentSegmentMetaDataNumber = null;
        String segmentMetaDataType = null;
        boolean segmentMetaDataIsParent = false;
        boolean bl = nextRow = metaSegmentsTable.getNumRows() > 0;
        if (nextRow) {
            metaSegmentsTable.firstRow();
            rootSegmentMetaData = JCoIDocRuntime.get().createIDocRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, "ROOT", metaSegmentsTable.getInt(11) - 1, "General root segment");
            segmentMetaDataHashtable.put(new Integer(0), rootSegmentMetaData);
        } else {
            rootSegmentMetaData = JCoIDocRuntime.get().createIDocRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, "ROOT", 0, "General root segment");
        }
        while (nextRow) {
            segmentMetaDataNumber = new Integer(metaSegmentsTable.getInt(0));
            segmentMetaDataType = metaSegmentsTable.getString(1);
            parentSegmentMetaDataNumber = new Integer(metaSegmentsTable.getInt(6));
            segmentMetaDataIsParent = metaSegmentsTable.getChar(7) == 'X';
            recordMetaData = recordMetaDataHashtable.get(segmentMetaDataType);
            segmentMetaData = segmentMetaDataIsParent ? JCoIDocRuntime.get().createIDocSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, segmentMetaDataType, metaSegmentsTable.getString(2), metaSegmentsTable.getInt(11), metaSegmentsTable.getString(12), metaSegmentsTable.getChar(13) == 'X', metaSegmentsTable.getLong(14), metaSegmentsTable.getLong(15), metaSegmentsTable.getChar(3) == 'X', recordMetaData) : JCoIDocRuntime.get().createIDocSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, segmentMetaDataType, metaSegmentsTable.getString(2), metaSegmentsTable.getInt(11), metaSegmentsTable.getString(12), metaSegmentsTable.getChar(8) == 'X', metaSegmentsTable.getLong(9), metaSegmentsTable.getLong(10), metaSegmentsTable.getChar(3) == 'X', recordMetaData);
            parentSegmentMetaData = (DefaultIDocSegmentMetaData)segmentMetaDataHashtable.get(parentSegmentMetaDataNumber);
            segmentMetaDataHashtable.put(segmentMetaDataNumber, segmentMetaData);
            parentSegmentMetaData.addChild(segmentMetaData);
            nextRow = metaSegmentsTable.nextRow();
        }
        rootSegmentMetaData.lock();
        return rootSegmentMetaData;
    }

    protected static Hashtable<String, DefaultIDocRecordMetaData> createRecordMetaDataHashtable40(JCoTable metaFieldsTable, JCoTable metaFValuesTable) {
        if (metaFieldsTable.getNumRows() == 0) {
            return new Hashtable<String, DefaultIDocRecordMetaData>(0);
        }
        Hashtable<String, DefaultIDocRecordMetaData> recordMetaDataHashtable = new Hashtable<String, DefaultIDocRecordMetaData>(51);
        Hashtable<String, Integer> fieldMetaDataIndexHashtable = new Hashtable<String, Integer>(1000);
        DefaultIDocRecordMetaData recordMetaData = null;
        DefaultIDocFieldMetaData fieldMetaData = null;
        String nextType = null;
        int startOffset = 0;
        int fieldIndex = 0;
        boolean nextRow = true;
        String type = null;
        String fieldName = null;
        int internalLength = 0;
        int outputLength = 0;
        int offset = 0;
        String dataTypeName = null;
        String dataElementName = null;
        String domainName = null;
        String description = null;
        String checkTableName = null;
        boolean isISOCode = false;
        metaFieldsTable.firstRow();
        type = metaFieldsTable.getString(0);
        startOffset = metaFieldsTable.getInt(5);
        do {
            recordMetaData = JCoIDocRuntime.get().createIDocRecordMetaData(type);
            fieldIndex = 0;
            do {
                fieldName = metaFieldsTable.getString(1);
                internalLength = metaFieldsTable.getInt(2);
                outputLength = metaFieldsTable.getInt(3);
                offset = metaFieldsTable.getInt(5) - startOffset;
                dataTypeName = metaFieldsTable.getString(9);
                dataElementName = metaFieldsTable.getString(7);
                domainName = metaFieldsTable.getString(8);
                description = metaFieldsTable.getString(10);
                checkTableName = metaFieldsTable.getString(12);
                isISOCode = metaFieldsTable.getChar(11) == 'X';
                fieldMetaData = JCoIDocRuntime.get().createIDocFieldMetaData(fieldName, internalLength, outputLength, dataTypeName, dataElementName, domainName, description, checkTableName, isISOCode);
                recordMetaData.add(fieldName, 0, outputLength, offset, outputLength, offset, 0, description, null, fieldMetaData);
                fieldMetaDataIndexHashtable.put(DefaultIDocFieldMetaData.createKey(type, fieldName), new Integer(fieldIndex));
                nextRow = metaFieldsTable.nextRow();
                if (!nextRow) continue;
                nextType = metaFieldsTable.getString(0);
                ++fieldIndex;
            } while (nextRow && type.equals(nextType));
            recordMetaData.setRecordLength(offset + outputLength, offset + outputLength);
            recordMetaData.lock();
            recordMetaDataHashtable.put(type, recordMetaData);
            type = nextType;
        } while (nextRow);
        SAPRepository.addFieldMetaDataValueRanges(recordMetaDataHashtable, fieldMetaDataIndexHashtable, metaFValuesTable);
        return recordMetaDataHashtable;
    }

    protected static DefaultIDocRecordMetaData createRecordMetaData31(String recordName, int maxRecordLength, JCoTable metaFieldInfoTable1, JCoTable metaFieldInfoTable3) {
        DefaultIDocRecordMetaData recordMetaData = JCoIDocRuntime.get().createIDocRecordMetaData(recordName);
        DefaultIDocFieldMetaData fieldMetaData = null;
        String fieldName = null;
        int internalLength = 0;
        int outputLength = 0;
        int offset = 0;
        String dataTypeName = null;
        String dataElementName = null;
        String domainName = null;
        String description = null;
        metaFieldInfoTable1.firstRow();
        if (metaFieldInfoTable3 != null) {
            metaFieldInfoTable3.firstRow();
        }
        do {
            fieldName = metaFieldInfoTable1.getString(1);
            internalLength = metaFieldInfoTable1.getInt(9);
            outputLength = metaFieldInfoTable1.getInt(8);
            offset = metaFieldInfoTable1.getInt(4);
            if (metaFieldInfoTable3 != null && fieldName.equals(metaFieldInfoTable3.getString(1))) {
                dataTypeName = metaFieldInfoTable3.getString(12);
                dataElementName = metaFieldInfoTable3.getString(6);
                domainName = metaFieldInfoTable3.getString(5);
                description = metaFieldInfoTable3.getString(27);
            } else {
                dataTypeName = metaFieldInfoTable1.getString(12);
                dataElementName = metaFieldInfoTable1.getString(6);
                domainName = metaFieldInfoTable1.getString(5);
                description = metaFieldInfoTable1.getString(27);
            }
            fieldMetaData = JCoIDocRuntime.get().createIDocFieldMetaData(fieldName, internalLength, outputLength, dataTypeName, dataElementName, domainName, description, null, false);
            recordMetaData.add(fieldName, 0, outputLength, offset, outputLength, offset, 0, description, null, fieldMetaData);
            if (metaFieldInfoTable3 == null) continue;
            metaFieldInfoTable3.nextRow();
        } while (metaFieldInfoTable1.nextRow() && offset + outputLength < maxRecordLength);
        recordMetaData.setRecordLength(offset + outputLength, offset + outputLength);
        recordMetaData.lock();
        return recordMetaData;
    }

    protected String[] getCachedIDocOutboundMessageRelease(String key) {
        this.m_lastAccessTimestamp = System.currentTimeMillis();
        if (this.m_iDocOutboundMessageReleaseCache == null) {
            return null;
        }
        return this.m_iDocOutboundMessageReleaseCache.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getIDocCompoundType(String iDocType, String iDocTypeExtension) {
        String iDocCompoundType = this.getCachedIDocCompoundType(iDocType, iDocTypeExtension);
        if (iDocCompoundType == null) {
            if (!this.m_iDocCompoundTypesQueried) {
                Object object = this.m_iDocCompoundTypeQuerySemaphore;
                synchronized (object) {
                    iDocCompoundType = this.getCachedIDocCompoundType(iDocType, iDocTypeExtension);
                    if (iDocCompoundType != null) {
                        return iDocCompoundType;
                    }
                    if (!this.m_iDocCompoundTypesQueried) {
                        Hashtable<String, String> iDocCompoundTypesHashtable = this.queryIDocCompoundTypes();
                        this.m_iDocCompoundTypesQueried = true;
                        if (iDocCompoundTypesHashtable != null) {
                            this.addIDocCompoundTypesToCache(iDocCompoundTypesHashtable);
                            iDocCompoundType = this.getCachedIDocCompoundType(iDocType, iDocTypeExtension);
                            if (iDocCompoundType != null) {
                                return iDocCompoundType;
                            }
                        }
                    }
                }
            }
            if (iDocType != null && (iDocTypeExtension == null || iDocTypeExtension.length() == 0)) {
                iDocCompoundType = iDocType;
            }
        }
        return iDocCompoundType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getIDocOutboundMessageRelease(String client, String recipientPartnerNumber, String recipientPartnerType, String recipientPartnerFunction, String messageType, String messageCode, String messageFunction, String testFlag) {
        String key = SAPRepository.createIDocMessagePartnerProfileKey(client, recipientPartnerNumber, recipientPartnerType, recipientPartnerFunction, messageType, messageCode, messageFunction, testFlag);
        String[] iDocOutboundMessageRelease = this.getCachedIDocOutboundMessageRelease(key);
        if (iDocOutboundMessageRelease == null) {
            Object querySemaphore = null;
            Object object = this.m_querySemaphores;
            synchronized (object) {
                querySemaphore = this.m_querySemaphores.get(key);
                if (querySemaphore == null) {
                    querySemaphore = new Object();
                    this.m_querySemaphores.put(key, querySemaphore);
                }
            }
            object = querySemaphore;
            synchronized (object) {
                iDocOutboundMessageRelease = this.getCachedIDocOutboundMessageRelease(key);
                if (Trace.isOn(64)) {
                    Trace.fireTrace(64, new StringBuilder(120).append("[IDocAPI] IDocRepository.queryIDocOutboundMessageRelease(\"").append(key).append("\") for repository ").append(this.m_name).append(" version ").append(this.m_partnerRelease).append(" using destination ").append(this.destinationList.getCurrentDestination() != null ? ((JCoDestination)this.destinationList.getCurrentDestination()).getDestinationName() : "null").toString());
                }
                if (iDocOutboundMessageRelease == null) {
                    try {
                        iDocOutboundMessageRelease = this.queryIDocOutboundMessageRelease(client, recipientPartnerNumber, recipientPartnerType, recipientPartnerFunction, messageType, messageCode, messageFunction, testFlag);
                        if (iDocOutboundMessageRelease != null) {
                            this.addIDocOutboundMessageReleaseToCache(key, iDocOutboundMessageRelease);
                        }
                    }
                    finally {
                        this.m_querySemaphores.remove(key);
                    }
                }
            }
        }
        return iDocOutboundMessageRelease;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDocSegmentMetaData getRootSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
        IDocSegmentMetaData rootSegmentMetaData = this.getCachedRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
        if (rootSegmentMetaData == null) {
            Object querySemaphore = null;
            String key = DefaultIDocSegmentMetaData.createKey(iDocType, iDocTypeExtension, systemRelease, applicationRelease, "ROOT");
            Object object = this.m_querySemaphores;
            synchronized (object) {
                querySemaphore = this.m_querySemaphores.get(key);
                if (querySemaphore == null) {
                    querySemaphore = new Object();
                    this.m_querySemaphores.put(key, querySemaphore);
                }
            }
            object = querySemaphore;
            synchronized (object) {
                rootSegmentMetaData = this.getCachedSegmentMetaData(key);
                if (rootSegmentMetaData == null) {
                    try {
                        rootSegmentMetaData = this.queryRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
                        if (rootSegmentMetaData != null) {
                            this.addSegmentMetaDataToCache(rootSegmentMetaData);
                        }
                    }
                    finally {
                        this.m_querySemaphores.remove(key);
                    }
                }
            }
        }
        return rootSegmentMetaData;
    }

    @Override
    public IDocSegmentMetaData getSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, String definition) {
        IDocSegmentMetaData rootSegmentMetaData;
        if ("ROOT".equals(definition)) {
            return this.getRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
        }
        String key = DefaultIDocSegmentMetaData.createKey(iDocType, iDocTypeExtension, systemRelease, applicationRelease, definition);
        IDocSegmentMetaData segmentMetaData = this.getCachedSegmentMetaData(key);
        if (segmentMetaData == null && (rootSegmentMetaData = this.getRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease)) != null) {
            this.addSegmentMetaDataTreeToCache(rootSegmentMetaData);
            segmentMetaData = this.getCachedSegmentMetaData(key);
        }
        return segmentMetaData;
    }

    public Hashtable<String, String> queryIDocCompoundTypes() {
        try {
            JCoStaticRepository jcoRepository = JCoStaticRepositories.getJCoStaticRepository(this.m_partnerRelease);
            JCoFunction metaFunction = jcoRepository.getFunction("RFC_READ_TABLE");
            JCoParameterList impParamList = metaFunction.getImportParameterList();
            JCoParameterList tabParamList = metaFunction.getTableParameterList();
            impParamList.setValue("QUERY_TABLE", "EDIDO");
            tabParamList.setActive("OPTIONS", false);
            this.connectionProvider.execute(metaFunction);
            JCoTable tabEDIDOFields = tabParamList.getTable("FIELDS");
            JCoTable tabEDIDOData = tabParamList.getTable("DATA");
            return SAPRepository.createIDocCompoundTypesHashtable(tabEDIDOFields, tabEDIDOData);
        }
        catch (AbapException ex) {
            return new Hashtable<String, String>(0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String[] queryIDocOutboundMessageRelease(String client, String recipientPartnerNumber, String recipientPartnerType, String recipientPartnerFunction, String messageType, String messageCode, String messageFunction, String testFlag) {
        String[] iDocOutboundMessageRelease = null;
        try {
            JCoStaticRepository jcoRepository = JCoStaticRepositories.getJCoStaticRepository(this.m_partnerRelease);
            JCoFunction metaFunction = jcoRepository.getFunction("EDI_AGREE_OUT_MESSTYPE_READ");
            JCoStructure importStruct = metaFunction.getImportParameterList().getStructure("REC_EDK13");
            JCoStructure exportStruct = metaFunction.getExportParameterList().getStructure("REC_EDD13");
            importStruct.setValue(0, client);
            importStruct.setValue(1, recipientPartnerNumber);
            importStruct.setValue(2, recipientPartnerType);
            importStruct.setValue(3, recipientPartnerFunction);
            importStruct.setValue(4, messageType);
            importStruct.setValue(5, messageCode);
            importStruct.setValue(6, messageFunction);
            importStruct.setValue(7, testFlag);
            this.connectionProvider.execute(metaFunction);
            iDocOutboundMessageRelease = new String[2];
            iDocOutboundMessageRelease[0] = exportStruct.getString(17);
            if (exportStruct.getFieldCount() > 19) {
                iDocOutboundMessageRelease[1] = exportStruct.getString(19);
            }
        }
        catch (AbapException ex) {
            if (Trace.isOn(8)) {
                String key = SAPRepository.createIDocMessagePartnerProfileKey(client, recipientPartnerNumber, recipientPartnerType, recipientPartnerFunction, messageType, messageCode, messageFunction, testFlag);
                Trace.fireTrace(8, new StringBuilder(120).append("[IDocAPI] queryIDocOutboundMessageRelease(\"").append(key).append("\") failed with ABAP exception: ").append(ex.getKey()).toString());
            }
        }
        catch (Exception ex) {
            String key = SAPRepository.createIDocMessagePartnerProfileKey(client, recipientPartnerNumber, recipientPartnerType, recipientPartnerFunction, messageType, messageCode, messageFunction, testFlag);
            if (Trace.isOn(4)) {
                Trace.fireTrace(4, new StringBuilder(120).append("[IDocAPI] queryIDocOutboundMessageRelease(\"").append(key).append("\") failed with exception: ").append(ex.toString()).toString());
            }
            String error = "Unable to get outbound message release for " + key;
            throw new IDocRuntimeException(error, ex);
        }
        return iDocOutboundMessageRelease;
    }

    public IDocSegmentMetaData queryRootSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
        if (iDocType == null || iDocType.length() == 0) {
            return null;
        }
        this.m_lastRemoteQueryTimestamp = System.currentTimeMillis();
        try {
            if (Trace.isOn(64)) {
                Trace.fireTrace(64, new StringBuilder(250).append("[IDocAPI] IDocRepository.queryRootSegmentMetaData(").append(iDocType).append(", ").append(iDocTypeExtension).append(", ").append(systemRelease).append(", ").append(applicationRelease).append(") for repository ").append(this.m_name).append(" version '").append(this.m_partnerRelease).append("' using destination ").append(this.destinationList.getCurrentDestination() != null ? ((JCoDestination)this.destinationList.getCurrentDestination()).getDestinationName() : "null").toString());
            }
            if (this.m_partnerRelease == null || this.m_partnerRelease.length() == 0 || this.m_partnerRelease.compareTo("4") >= 0) {
                return this.queryRootSegmentMetaData40(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
            }
            return this.queryRootSegmentMetaData31(iDocType, iDocTypeExtension, systemRelease);
        }
        catch (IDocRuntimeException iex) {
            throw iex;
        }
        catch (Exception ex) {
            if (Trace.isOn(4)) {
                Trace.fireTrace(4, new StringBuilder(300).append("[IDocAPI] IDocRepository.queryRootSegmentMetaData(").append(iDocType).append(", ").append(iDocTypeExtension).append(", ").append(systemRelease).append(", ").append(applicationRelease).append(") failed with exception: ").append(ex.toString()).toString());
            }
            String error = "Unable to get meta data for IDoc type " + iDocType;
            if (iDocTypeExtension != null && iDocTypeExtension.length() > 0) {
                error = error + " with extension " + iDocTypeExtension;
            }
            throw new IDocRuntimeException(error, ex);
        }
    }

    protected final IDocSegmentMetaData queryRootSegmentMetaData31(String iDocType, String iDocTypeExtension, String systemRelease) {
        if (iDocType == null || iDocType.length() == 0) {
            return null;
        }
        try {
            JCoStaticRepository jcoRepository = JCoStaticRepositories.getJCoStaticRepository("31I");
            JCoFunction metaFunction = null;
            JCoParameterList impParamList = null;
            JCoParameterList tabParamList = null;
            JCoTable metaSegmentsTable = null;
            if (iDocTypeExtension == null || iDocTypeExtension.length() == 0) {
                metaFunction = jcoRepository.getFunctionTemplate("EDI_IDOC_SYNTAX_GET").getFunction();
                impParamList = metaFunction.getImportParameterList();
                tabParamList = metaFunction.getTableParameterList();
                impParamList.setValue("DOCTYP", iDocType);
                this.connectionProvider.execute(metaFunction);
                metaSegmentsTable = tabParamList.getTable("SYNTAX_TABLE");
            } else {
                metaFunction = jcoRepository.getFunctionTemplate("EDI_IDOC_MERGE_WITH_EXTENSION").getFunction();
                impParamList = metaFunction.getImportParameterList();
                tabParamList = metaFunction.getTableParameterList();
                impParamList.setValue("IDOCTYP", iDocType);
                impParamList.setValue("CIMTYP", iDocTypeExtension);
                tabParamList.setActive("INT_IDOCSYN", false);
                tabParamList.setActive("INT_CIMSYN", false);
                this.connectionProvider.execute(metaFunction);
                metaSegmentsTable = tabParamList.getTable("INT_EDISYN");
            }
            return this.createRootSegmentMetaData31(iDocType, iDocTypeExtension, systemRelease, metaSegmentsTable);
        }
        catch (AbapException ae) {
            StringBuilder buf;
            if (Trace.isOn(8, true)) {
                buf = new StringBuilder(200);
                buf.append("[IDocAPI] queryRootSegmentMetaData31 (").append(iDocType);
                buf.append('|').append(iDocTypeExtension).append('|').append(systemRelease);
                buf.append(") threw an AbapException in repository ").append(this.m_name).append(". Exception: ").append(ae.getKey());
                Trace.fireTrace(8, buf.toString(), ae);
            }
            if ("SYNTAX_NOT_FOUND".equals(ae.getKey())) {
                return null;
            }
            buf = new StringBuilder(200).append("Unable to get meta data for IDoc type ").append(iDocType);
            if (iDocTypeExtension != null && iDocTypeExtension.length() > 0) {
                buf.append(" with extension ").append(iDocTypeExtension);
            }
            buf.append(": ");
            buf.append(ae.getMessage());
            throw new IDocRuntimeException(buf.toString(), ae);
        }
        catch (Exception ex) {
            if (Trace.isOn(4, true)) {
                Trace.fireTrace(4, "[IDocAPI] Exception during queryRootSegmentMetaData31 on repository " + this.getName(), ex);
            }
            StringBuilder buf = new StringBuilder(200).append("Unable to get meta data for IDoc type ").append(iDocType);
            if (iDocTypeExtension != null && iDocTypeExtension.length() > 0) {
                buf.append(" with extension ").append(iDocTypeExtension);
            }
            buf.append(": ");
            buf.append(ex.getMessage());
            throw new IDocRuntimeException(buf.toString(), ex);
        }
    }

    protected final IDocSegmentMetaData queryRootSegmentMetaData40(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
        if (iDocType == null || iDocType.length() == 0) {
            return null;
        }
        try {
            JCoStaticRepository jcoRepository = JCoStaticRepositories.getJCoStaticRepository("40");
            JCoFunction metaFunction = jcoRepository.getFunctionTemplate("IDOCTYPE_READ_COMPLETE").getFunction();
            JCoParameterList impParamList = metaFunction.getImportParameterList();
            JCoParameterList tabParamList = metaFunction.getTableParameterList();
            impParamList.setValue("PI_IDOCTYP", iDocType);
            impParamList.setValue("PI_CIMTYP", iDocTypeExtension);
            impParamList.setValue("PI_RELEASE", Utils.removeAllDotsFromString(systemRelease));
            impParamList.setValue("PI_APPLREL", Utils.removeAllDotsFromString(applicationRelease));
            tabParamList.setActive("PT_MESSAGES", false);
            this.connectionProvider.execute(metaFunction);
            JCoTable metaSegmentsTable = tabParamList.getTable("PT_SEGMENTS");
            JCoTable metaFieldsTable = tabParamList.getTable("PT_FIELDS");
            JCoTable metaFValuesTable = tabParamList.getTable("PT_FVALUES");
            Hashtable<String, DefaultIDocRecordMetaData> recordMetaDataHashtable = SAPRepository.createRecordMetaDataHashtable40(metaFieldsTable, metaFValuesTable);
            return SAPRepository.createRootSegmentMetaData40(iDocType, iDocTypeExtension, systemRelease, applicationRelease, metaSegmentsTable, recordMetaDataHashtable);
        }
        catch (AbapException ae) {
            StringBuilder buf;
            if (Trace.isOn(8, true)) {
                String messageNumber;
                buf = new StringBuilder(200);
                buf.append("[IDocAPI] queryRootSegmentMetaData40 (").append(iDocType);
                buf.append('|').append(iDocTypeExtension).append('|').append(systemRelease).append('|').append(applicationRelease);
                buf.append(") threw an AbapException in repository ").append(this.m_name).append(". Exception: ").append(ae.getKey());
                Trace.fireTrace(8, buf.toString());
                if ("OBJECT_UNKNOWN".equals(ae.getKey()) && "EA".equals(ae.getMessageClass()) && ("444".equals(messageNumber = ae.getMessageNumber()) || "445".equals(messageNumber))) {
                    buf.setLength(0);
                    buf.append("You have no authorization for ");
                    buf.append("444".equals(messageNumber) ? "basic types" : "extensions");
                    buf.append(" (activity ").append(ae.getMessageParameter(0)).append("). IDoc type");
                    buf.append("444".equals(messageNumber) ? ": " : " extension: ").append(ae.getMessageParameter(1));
                    Trace.fireTrace(8, buf.toString());
                }
            }
            if ("OBJECT_UNKNOWN".equals(ae.getKey()) && "EA".equals(ae.getMessageClass())) {
                String messageNumber = ae.getMessageNumber();
                if ("444".equals(messageNumber) || "445".equals(messageNumber)) {
                    StringBuilder buf2 = new StringBuilder(250).append("Unable to get meta data for IDoc type ").append(iDocType);
                    if (iDocTypeExtension != null && iDocTypeExtension.length() > 0) {
                        buf2.append(" with extension ").append(iDocTypeExtension);
                    }
                    buf2.append(": You have no authorization for ");
                    buf2.append("444".equals(messageNumber) ? "basic types" : "extensions");
                    buf2.append(" (activity ").append(ae.getMessageParameter(0)).append("). IDoc type");
                    buf2.append("444".equals(messageNumber) ? ": " : " extension: ").append(ae.getMessageParameter(1));
                    throw new IDocRuntimeException(buf2.toString(), ae);
                }
                return null;
            }
            buf = new StringBuilder(200).append("Unable to get meta data for IDoc type ").append(iDocType);
            if (iDocTypeExtension != null && iDocTypeExtension.length() > 0) {
                buf.append(" with extension ").append(iDocTypeExtension);
            }
            buf.append(": ");
            buf.append(ae.getMessage());
            throw new IDocRuntimeException(buf.toString(), ae);
        }
        catch (Exception ex) {
            if (Trace.isOn(4, true)) {
                Trace.fireTrace(4, "[IDocAPI] Exception during queryRootSegmentMetaData40 on repository " + this.getName(), ex);
            }
            StringBuilder buf = new StringBuilder(200).append("Unable to get meta data for IDoc type ").append(iDocType);
            if (iDocTypeExtension != null && iDocTypeExtension.length() > 0) {
                buf.append(" with extension ").append(iDocTypeExtension);
            }
            buf.append(": ");
            buf.append(ex.getMessage());
            throw new IDocRuntimeException(buf.toString(), ex);
        }
    }

    protected final String querySegmentDefinition31(String segmentType, String systemRelease, Int segmentLength) throws AbapException {
        if (segmentType == null || segmentType.length() == 0) {
            if (segmentLength != null) {
                segmentLength.set(0);
            }
            return null;
        }
        try {
            JCoStaticRepository jcoRepository = JCoStaticRepositories.getJCoStaticRepository("31");
            JCoFunction metaFunction = jcoRepository.getFunctionTemplate("EDI_SEGTYP_GET").getFunction();
            JCoParameterList impParamList = metaFunction.getImportParameterList();
            JCoParameterList expParamList = metaFunction.getExportParameterList();
            impParamList.setValue("SEGTYP", segmentType);
            impParamList.setValue("RELEASED", Utils.removeAllDotsFromString(systemRelease));
            this.connectionProvider.execute(metaFunction);
            if (segmentLength != null) {
                segmentLength.set(expParamList.getInt("SEGLEN"));
            }
            return expParamList.getString("SEGNAM");
        }
        catch (AbapException ae) {
            throw ae;
        }
        catch (Exception ex) {
            if (Trace.isOn(4, true)) {
                Trace.fireTrace(4, "[IDocAPI] Exception during querySegmentDefinition31 on repository " + this.getName(), ex);
            }
            if (segmentLength != null) {
                segmentLength.set(0);
            }
            String error = "Unable to get segment definition for " + segmentType + ": " + ex.getMessage();
            throw new IDocRuntimeException(error, ex);
        }
    }

    protected final String querySegmentDescription31(String segmentType) throws AbapException {
        if (segmentType == null || segmentType.length() == 0) {
            return null;
        }
        try {
            JCoStaticRepository jcoRepository = JCoStaticRepositories.getJCoStaticRepository("31");
            JCoFunction metaFunction = jcoRepository.getFunctionTemplate("EDI_SEGMENT_DESCRIPTION_GET").getFunction();
            JCoParameterList impParamList = metaFunction.getImportParameterList();
            JCoParameterList expParamList = metaFunction.getExportParameterList();
            impParamList.setValue("SEGTYP", segmentType);
            this.connectionProvider.execute(metaFunction);
            return expParamList.getString("DESCRP");
        }
        catch (AbapException ae) {
            throw ae;
        }
        catch (Exception ex) {
            if (Trace.isOn(4, true)) {
                Trace.fireTrace(4, "[IDocAPI] Exception during querySegmentDescription31 on repository " + this.getName(), ex);
            }
            String error = "Unable to get segment description for " + segmentType + ": " + ex.getMessage();
            throw new IDocRuntimeException(error, ex);
        }
    }

    protected final DefaultIDocRecordMetaData queryRecordMetaData31(String recordName, int maxRecordLength) throws AbapException {
        if (recordName == null || recordName.length() == 0) {
            return null;
        }
        try {
            JCoStaticRepository jcoRepository = JCoStaticRepositories.getJCoStaticRepository("31");
            JCoFunctionTemplate metaFunctionTemplate = jcoRepository.getFunctionTemplate("DDIF_FIELDINFO_GET");
            JCoFunction metaFunction = metaFunctionTemplate.getFunction();
            JCoParameterList impParamList = metaFunction.getImportParameterList();
            JCoParameterList tabParamList = metaFunction.getTableParameterList();
            impParamList.setValue("TABNAME", recordName);
            this.connectionProvider.execute(metaFunction);
            JCoTable metaFieldInfoTable1 = tabParamList.getTable("DFIES_TAB");
            JCoTable metaFieldInfoTable3 = null;
            if (metaFieldInfoTable1.getNumRows() == 0) {
                return null;
            }
            try {
                StringBuilder recordName3 = new StringBuilder(recordName);
                if (recordName3.length() > 1 && recordName3.charAt(1) == '1') {
                    recordName3.setCharAt(1, '3');
                    metaFunction = metaFunctionTemplate.getFunction();
                    impParamList = metaFunction.getImportParameterList();
                    tabParamList = metaFunction.getTableParameterList();
                    impParamList.setValue("TABNAME", recordName3.toString());
                    this.connectionProvider.execute(metaFunction);
                    metaFieldInfoTable3 = tabParamList.getTable("DFIES_TAB");
                    if (metaFieldInfoTable3.getNumRows() != metaFieldInfoTable1.getNumRows()) {
                        metaFieldInfoTable3 = null;
                    }
                }
            }
            catch (AbapException ae) {
                throw ae;
            }
            catch (Exception ex) {
                if (Trace.isOn(4, true)) {
                    Trace.fireTrace(4, "[IDocAPI] Exception during queryRecordMetaData31 on repository " + this.getName(), ex);
                }
                String error = "Unable to get meta data for record " + recordName + ": " + ex.getMessage();
                throw new IDocRuntimeException(error, ex);
            }
            return SAPRepository.createRecordMetaData31(recordName, maxRecordLength, metaFieldInfoTable1, metaFieldInfoTable3);
        }
        catch (AbapException ae) {
            throw ae;
        }
        catch (IDocRuntimeException ire) {
            throw ire;
        }
        catch (Exception ex) {
            if (Trace.isOn(4, true)) {
                Trace.fireTrace(4, "[IDocAPI] Exception during queryRecordMetaData31 on repository " + this.getName(), ex);
            }
            return null;
        }
    }

    @Override
    public IDocSegmentMetaData removeRootSegmentMetaDataFromCache(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
        IDocSegmentMetaData rootSegmentMetaData = super.removeRootSegmentMetaDataFromCache(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
        this.removeSecondRootSegmentMetaDataFromCache(iDocType, iDocTypeExtension, systemRelease, applicationRelease, rootSegmentMetaData);
        return rootSegmentMetaData;
    }

    @Override
    public IDocSegmentMetaData removeRootSegmentMetaDataTreeFromCache(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
        IDocSegmentMetaData rootSegmentMetaData = super.removeRootSegmentMetaDataTreeFromCache(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
        this.removeSecondRootSegmentMetaDataFromCache(iDocType, iDocTypeExtension, systemRelease, applicationRelease, rootSegmentMetaData);
        return rootSegmentMetaData;
    }

    private void removeSecondRootSegmentMetaDataFromCache(IDocSegmentMetaData rootSegmentMetaData) {
        String key;
        String iDocCompoundType;
        if (this.m_iDocCompoundTypeKeysInSegmentMetaDataCache > 0 && rootSegmentMetaData != null && (iDocCompoundType = this.getCachedIDocCompoundType(rootSegmentMetaData.getIDocType(), rootSegmentMetaData.getIDocTypeExtension())) != null && this.m_segmentMetaDataCache.remove(key = DefaultIDocSegmentMetaData.createKey(iDocCompoundType, null, rootSegmentMetaData.getSystemRelease(), rootSegmentMetaData.getApplicationRelease(), "ROOT")) != null) {
            --this.m_iDocCompoundTypeKeysInSegmentMetaDataCache;
            this.m_latestCachedIDocTypes = null;
        }
    }

    private void removeSecondRootSegmentMetaDataFromCache(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, IDocSegmentMetaData rootSegmentMetaData) {
        if (this.m_iDocCompoundTypeKeysInSegmentMetaDataCache > 0 && rootSegmentMetaData != null) {
            String key = DefaultIDocSegmentMetaData.createKey(iDocType, iDocTypeExtension, systemRelease, applicationRelease, "ROOT");
            if (key.equals(rootSegmentMetaData.getKey())) {
                String iDocCompoundType = this.getCachedIDocCompoundType(iDocType, iDocTypeExtension);
                if (iDocCompoundType != null && this.m_segmentMetaDataCache.remove(key = DefaultIDocSegmentMetaData.createKey(iDocCompoundType, null, systemRelease, applicationRelease, "ROOT")) != null) {
                    --this.m_iDocCompoundTypeKeysInSegmentMetaDataCache;
                    this.m_latestCachedIDocTypes = null;
                }
            } else if (this.m_segmentMetaDataCache.remove(key) != null) {
                --this.m_iDocCompoundTypeKeysInSegmentMetaDataCache;
                this.m_latestCachedIDocTypes = null;
            }
        }
    }

    @Override
    public boolean removeSegmentMetaDataFromCache(IDocSegmentMetaData segmentMetaData) {
        boolean removed = super.removeSegmentMetaDataFromCache(segmentMetaData);
        if (removed && "ROOT".equals(segmentMetaData.getDefinition())) {
            this.removeSecondRootSegmentMetaDataFromCache(segmentMetaData);
        }
        return removed;
    }

    @Override
    public boolean removeSegmentMetaDataTreeFromCache(IDocSegmentMetaData segmentMetaData) {
        boolean removed = super.removeSegmentMetaDataTreeFromCache(segmentMetaData);
        if (removed && "ROOT".equals(segmentMetaData.getDefinition())) {
            this.removeSecondRootSegmentMetaDataFromCache(segmentMetaData);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDocRepositoryMonitor getMonitor() {
        if (this.m_monitor == null) {
            SAPRepository sAPRepository = this;
            synchronized (sAPRepository) {
                if (this.m_monitor == null) {
                    this.m_monitor = new SAPRepositoryMonitor();
                }
            }
        }
        return this.m_monitor;
    }

    class SAPRepositoryMonitor
    extends BasicIDocRepository.BasicIDocRepositoryMonitor {
        SAPRepositoryMonitor() {
            super(SAPRepository.this);
        }

        public long getLastRemoteQueryTimestamp() {
            return SAPRepository.this.m_lastRemoteQueryTimestamp;
        }
    }

    private class ConnectionProvider
    extends DefaultConnectionManager {
        private ConnectionProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getSystemID(JCoDestination jcoDestination) throws JCoException {
            ClientConnection client = null;
            try {
                client = this.getClient((InternalDestination)((RfcDestination)jcoDestination), true, false);
                String string = client.getAttributes().getSystemID();
                return string;
            }
            finally {
                if (client != null) {
                    this.releaseClient(client);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getPartnerRelease() throws JCoException {
            JCoDestination currentDestination = (JCoDestination)SAPRepository.this.destinationList.getCurrentDestination();
            ClientConnection client = null;
            try {
                client = this.getClient((InternalDestination)((RfcDestination)currentDestination), true, false);
                String string = client.getAttributes().getPartnerRelease();
                return string;
            }
            finally {
                if (client != null) {
                    this.releaseClient(client);
                }
            }
        }

        private final void execute(JCoFunction function) throws JCoException {
            SAPRepository.this.m_lastRemoteQueryTimestamp = System.currentTimeMillis();
            Throwable originException = null;
            JCoDestination currentDestination = (JCoDestination)SAPRepository.this.destinationList.getCurrentDestination();
            try {
                this.internalExecute(function, currentDestination, true);
            }
            catch (AbapException ae) {
                if ("IDOCTYPE_READ_COMPLETE".equals(function.getName()) && "OBJECT_UNKNOWN".equals(ae.getKey()) && "EA".equals(ae.getMessageClass()) && ("444".equals(ae.getMessageNumber()) || "445".equals(ae.getMessageNumber()))) {
                    if (SAPRepository.this.destinationList.size() > 1) {
                        originException = ae;
                        function.getExportParameterList().clear();
                        function.getTableParameterList().clear();
                    }
                    throw ae;
                }
                throw ae;
            }
            catch (JCoException ex) {
                switch (ex.getGroup()) {
                    case 180: {
                        JCoIDocRepositoryManager.releaseRepository(currentDestination, SAPRepository.this);
                        if (SAPRepository.this.destinationList.size() > 0) {
                            originException = ex;
                            break;
                        }
                        throw ex;
                    }
                    case 102: 
                    case 103: 
                    case 104: 
                    case 106: {
                        if (SAPRepository.this.destinationList.size() > 1) {
                            originException = ex;
                            break;
                        }
                        throw ex;
                    }
                    default: {
                        throw ex;
                    }
                }
            }
            if (originException != null) {
                ArrayList<Throwable> excList = new ArrayList<Throwable>();
                excList.add(originException);
                boolean throwException = true;
                block14: for (JCoDestination destination : SAPRepository.this.destinationList) {
                    if (destination == currentDestination) continue;
                    try {
                        this.internalExecute(function, destination, true);
                    }
                    catch (AbapException ae2) {
                        if ("IDOCTYPE_READ_COMPLETE".equals(function.getName()) && "OBJECT_UNKNOWN".equals(ae2.getKey()) && "EA".equals(ae2.getMessageClass()) && ("444".equals(ae2.getMessageNumber()) || "445".equals(ae2.getMessageNumber()))) {
                            excList.add(ae2);
                            function.getExportParameterList().clear();
                            function.getTableParameterList().clear();
                            continue;
                        }
                        throw ae2;
                    }
                    catch (JCoException ex2) {
                        switch (ex2.getGroup()) {
                            case 180: {
                                JCoIDocRepositoryManager.releaseRepository(destination, SAPRepository.this);
                                excList.add(ex2);
                                continue block14;
                            }
                            case 102: 
                            case 103: 
                            case 104: 
                            case 106: {
                                excList.add(ex2);
                                continue block14;
                            }
                        }
                        throw ex2;
                    }
                    throwException = false;
                    SAPRepository.this.destinationList.replaceCurrentDestination((Object)currentDestination, (Object)destination);
                }
                if (throwException) {
                    StringBuilder buf = new StringBuilder("Unable to query IDoc meta data, caused by:");
                    Iterator it = excList.iterator();
                    while (it.hasNext()) {
                        buf.append("\n  ").append(((JCoException)((Object)it.next())).toString());
                    }
                    throw new JCoException(originException.getGroup(), originException.getKey(), buf.toString());
                }
            }
        }
    }
}

