/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt.record.impl;

import com.sap.conn.idoc.IDocFieldNotFoundException;
import com.sap.conn.idoc.rt.record.ExtendedFieldMetaData;
import com.sap.conn.idoc.rt.record.MetaDataBase;
import com.sap.conn.idoc.rt.record.RecordConstants;
import com.sap.conn.idoc.rt.record.RecordMetaData;
import java.io.Serializable;
import java.util.HashMap;

public abstract class AbstractMetaData
implements MetaDataBase,
Serializable,
Cloneable {
    static final long serialVersionUID = 1000L;
    protected String[] name = RecordConstants.EMPTY_STR_ARRAY;
    protected Serializable[] tabMeta = RecordConstants.EMPTY_SER_ARRAY;
    protected int[][] length = new int[][]{RecordConstants.EMPTY_INT_ARRAY, RecordConstants.EMPTY_INT_ARRAY};
    protected int[] boffset = RecordConstants.EMPTY_INT_ARRAY;
    protected int[] blength = RecordConstants.EMPTY_INT_ARRAY;
    protected byte[] type = RecordConstants.EMPTY_BYTE_ARRAY;
    protected byte[] decimals = RecordConstants.EMPTY_BYTE_ARRAY;
    protected byte[] oindex = RecordConstants.EMPTY_BYTE_ARRAY;
    protected String[] description = RecordConstants.EMPTY_STR_ARRAY;
    protected ExtendedFieldMetaData[] extendedFieldMetaData = null;
    protected int numFields = 0;
    protected int numOdata = 0;
    protected int[] tabLength = new int[]{0, 0};
    protected String recName = null;
    protected String typeName = null;
    protected HashMap<String, Integer> hashOfIndices = null;
    protected long lastActiveTimestamp = 0L;
    private boolean isLocked = false;
    private int hashcode = 0;

    protected AbstractMetaData(String name) {
        this.recName = name;
    }

    protected void copy(MetaDataBase obj) {
        if (this.isLocked) {
            throw new UnsupportedOperationException("The JCoMetaData object " + this.name + " is already locked. Changing it is no longer possible");
        }
        if (obj == null) {
            return;
        }
        this.hashcode = 0;
        this.ensureCapacity(obj.getFieldCount());
        this.recName = obj.getName();
        if (obj instanceof AbstractMetaData) {
            AbstractMetaData meta = (AbstractMetaData)obj;
            this.numFields = meta.numFields;
            this.numOdata = meta.numOdata;
            this.typeName = meta.typeName;
            System.arraycopy(meta.name, 0, this.name, 0, this.numFields);
            System.arraycopy(meta.tabMeta, 0, this.tabMeta, 0, this.numFields);
            System.arraycopy(meta.boffset, 0, this.boffset, 0, this.numFields);
            System.arraycopy(meta.length[0], 0, this.length[0], 0, this.numFields);
            System.arraycopy(meta.length[1], 0, this.length[1], 0, this.numFields);
            System.arraycopy(meta.blength, 0, this.blength, 0, this.numFields);
            System.arraycopy(meta.type, 0, this.type, 0, this.numFields);
            System.arraycopy(meta.decimals, 0, this.decimals, 0, this.numFields);
            System.arraycopy(meta.oindex, 0, this.oindex, 0, this.numFields);
            if (meta.description != null) {
                this.description = (String[])meta.description.clone();
            }
            if (meta.extendedFieldMetaData != null) {
                this.extendedFieldMetaData = (ExtendedFieldMetaData[])meta.extendedFieldMetaData.clone();
            }
        }
    }

    protected void add(String name, int type, int nucByteLength, int ucByteLength, int decimals, String description, Object tabMetaData, ExtendedFieldMetaData extended) {
        if (this.isLocked) {
            throw new IllegalStateException("The MetaDataBase object " + name + " is already locked. Changing it is no longer possible");
        }
        this.hashcode = 0;
        this.ensureCapacity(this.numFields + 1);
        if (ucByteLength < 0 || nucByteLength < 0) {
            throw new IllegalArgumentException("the field lengths have to be positive [ nucByteLength=" + nucByteLength + ", ucByteLength=" + ucByteLength + "]");
        }
        this.oindex[this.numFields] = -1;
        this.length[0][this.numFields] = nucByteLength;
        this.length[1][this.numFields] = ucByteLength;
        switch (type) {
            case 0: 
            case 5: 
            case 6: {
                this.blength[this.numFields] = nucByteLength;
                break;
            }
            case 1: {
                this.blength[this.numFields] = 8;
                break;
            }
            case 2: 
            case 4: {
                this.blength[this.numFields] = nucByteLength / 2 + nucByteLength % 2;
                break;
            }
            case 3: {
                this.blength[this.numFields] = 6;
                break;
            }
            case 7: {
                this.length[0][this.numFields] = 8;
                this.length[1][this.numFields] = 8;
                this.blength[this.numFields] = 4;
                break;
            }
            case 8: {
                this.length[0][this.numFields] = 4;
                this.length[1][this.numFields] = 4;
                this.blength[this.numFields] = 2;
                break;
            }
            case 9: {
                this.length[0][this.numFields] = 2;
                this.length[1][this.numFields] = 2;
                this.blength[this.numFields] = 1;
                break;
            }
            case 10: {
                this.length[0][this.numFields] = 1;
                this.length[1][this.numFields] = 1;
                this.blength[this.numFields] = 1;
                break;
            }
            case 29: 
            case 30: {
                this.length[0][this.numFields] = 8;
                this.length[1][this.numFields] = 8;
                this.blength[this.numFields] = 0;
                this.oindex[this.numFields] = (byte)this.numOdata++;
                break;
            }
            case 17: 
            case 99: {
                this.blength[this.numFields] = 0;
                this.oindex[this.numFields] = (byte)this.numOdata++;
                break;
            }
            case 98: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + type);
            }
        }
        this.name[this.numFields] = name;
        if (tabMetaData != null && !(tabMetaData instanceof String) && !(tabMetaData instanceof RecordMetaData)) {
            throw new IllegalArgumentException(new StringBuilder(250).append("The type of meta data for field ").append(name).append(" (type ").append(tabMetaData.getClass().getName()).append(") not allowed. Allowed types are String or JCoRecordMetaData").toString());
        }
        this.tabMeta[this.numFields] = (Serializable)tabMetaData;
        this.type[this.numFields] = (byte)type;
        this.decimals[this.numFields] = (byte)(type == 2 || type == 7 ? decimals : 0);
        if (description != null) {
            if (this.description.length == 0) {
                this.description = new String[this.name.length];
            }
            this.description[this.numFields] = description;
        }
        if (extended != null) {
            if (this.extendedFieldMetaData == null) {
                this.extendedFieldMetaData = new ExtendedFieldMetaData[this.name.length];
            }
            this.extendedFieldMetaData[this.numFields] = extended;
        }
        ++this.numFields;
        if (this.numFields > 1) {
            this.boffset[this.numFields - 1] = this.boffset[this.numFields - 2] + this.blength[this.numFields - 2];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void rebuildIndices() {
        if (this.hashOfIndices != null && this.hashOfIndices.size() >= this.name.length) return;
        String[] stringArray = this.name;
        synchronized (this.name) {
            if (this.hashOfIndices != null && this.hashOfIndices.size() >= this.name.length) return;
            int hashMapSize = this.name.length < 4 ? 5 : (this.name.length < 8 ? 11 : (this.name.length < 21 ? 29 : (this.name.length < 35 ? 47 : 89)));
            this.hashOfIndices = new HashMap(hashMapSize);
            for (int i = 0; i < this.name.length; ++i) {
                this.hashOfIndices.put(this.name[i], new Integer(i));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void checkIndex(int index) {
        if (index < 0 || index > this.numFields) {
            throw new IndexOutOfBoundsException(new StringBuilder(150).append("Index [").append(index).append("] ouf of bounds.").append("The metadata '").append(this.recName).append("' contains ").append(this.numFields).append(" fields").toString());
        }
    }

    protected void ensureCapacity(int capacity) {
        if (this.isLocked) {
            throw new UnsupportedOperationException("The JCoMetaData object " + this.name + " is already locked. Changing it is no longer possible");
        }
        if (this.name.length >= capacity) {
            return;
        }
        String[] old_name = this.name;
        this.name = new String[capacity];
        System.arraycopy(old_name, 0, this.name, 0, this.numFields);
        Serializable[] oldTabMeta = this.tabMeta;
        this.tabMeta = new Serializable[capacity];
        System.arraycopy(oldTabMeta, 0, this.tabMeta, 0, this.numFields);
        int[] oldBoffset = this.boffset;
        this.boffset = new int[capacity];
        System.arraycopy(oldBoffset, 0, this.boffset, 0, this.numFields);
        int[][] oldLength = this.length;
        this.length = new int[2][capacity];
        System.arraycopy(oldLength[0], 0, this.length[0], 0, this.numFields);
        System.arraycopy(oldLength[1], 0, this.length[1], 0, this.numFields);
        int[] oldBlength = this.blength;
        this.blength = new int[capacity];
        System.arraycopy(oldBlength, 0, this.blength, 0, this.numFields);
        byte[] oldType = this.type;
        this.type = new byte[capacity];
        System.arraycopy(oldType, 0, this.type, 0, this.numFields);
        byte[] oldDecimals = this.decimals;
        this.decimals = new byte[capacity];
        System.arraycopy(oldDecimals, 0, this.decimals, 0, this.numFields);
        byte[] oldOindex = this.oindex;
        this.oindex = new byte[capacity];
        System.arraycopy(oldOindex, 0, this.oindex, 0, this.numFields);
        if (this.description.length > 0) {
            String[] old_description = this.description;
            this.description = new String[capacity];
            System.arraycopy(old_description, 0, this.description, 0, this.numFields);
        }
        if (this.extendedFieldMetaData != null) {
            ExtendedFieldMetaData[] oldExtendedFieldMetaData = this.extendedFieldMetaData;
            this.extendedFieldMetaData = new ExtendedFieldMetaData[capacity];
            System.arraycopy(oldExtendedFieldMetaData, 0, this.extendedFieldMetaData, 0, this.numFields);
        }
    }

    public final int getJavaBufferLength(int index) {
        this.checkIndex(index);
        return this.blength[index];
    }

    public final int getJavaBufferOffset(int index) {
        this.checkIndex(index);
        return this.boffset[index];
    }

    public final int indexOf(String fieldName) throws IDocFieldNotFoundException {
        Integer idx = this.hashOfIndices.get(fieldName);
        if (idx != null) {
            return idx;
        }
        throw new IDocFieldNotFoundException(null, fieldName, new StringBuilder(100).append("Field \"").append(fieldName).append("\" is not a member of IDocRecordMetaData \"").append(this.recName).append("\".").toString());
    }

    public final boolean hasField(String fieldName) {
        if (this.name == null) {
            return false;
        }
        return this.hashOfIndices.get(fieldName) != null;
    }

    public final String getName() {
        return this.recName;
    }

    public String getRecordTypeName() {
        return this.typeName;
    }

    public final int getFieldCount() {
        return this.numFields;
    }

    public String getName(int index) {
        this.checkIndex(index);
        return this.name[index];
    }

    public String getRecordTypeName(int index) {
        this.checkIndex(index);
        if (this.tabMeta[index] instanceof String) {
            return (String)((Object)this.tabMeta[index]);
        }
        if (this.tabMeta[index] instanceof MetaDataBase) {
            return ((MetaDataBase)this.tabMeta[index]).getName();
        }
        return null;
    }

    public String getRecordTypeName(String fieldName) throws IDocFieldNotFoundException {
        return this.getRecordTypeName(this.indexOf(fieldName));
    }

    public ExtendedFieldMetaData getExtendedFieldMetaData(int index) {
        this.checkIndex(index);
        return this.extendedFieldMetaData == null ? null : this.extendedFieldMetaData[index];
    }

    public ExtendedFieldMetaData getExtendedFieldMetaData(String fieldName) throws IDocFieldNotFoundException {
        return this.extendedFieldMetaData[this.indexOf(fieldName)];
    }

    public int getUnicodeByteLength(int index) {
        this.checkIndex(index);
        return this.length[1][index];
    }

    public int getUnicodeByteLength(String fieldName) throws IDocFieldNotFoundException {
        return this.length[1][this.indexOf(fieldName)];
    }

    public int getByteLength(int index) {
        this.checkIndex(index);
        return this.length[0][index];
    }

    public int getByteLength(String fieldName) throws IDocFieldNotFoundException {
        return this.length[0][this.indexOf(fieldName)];
    }

    public int getLength(int index) {
        this.checkIndex(index);
        switch (this.type[index]) {
            case 5: 
            case 17: 
            case 29: 
            case 30: 
            case 99: {
                return 0;
            }
        }
        return this.getByteLength(index);
    }

    public int getLength(String fieldName) throws IDocFieldNotFoundException {
        return this.getLength(this.indexOf(fieldName));
    }

    protected void setDataBufferLength(int index, int dataBufferLength) {
        this.blength[index] = dataBufferLength;
    }

    protected void setDataBufferOffset(int index, int dataBufferOffset) {
        this.boffset[index] = dataBufferOffset;
    }

    protected void setName(String name) {
        this.recName = name;
    }

    public int getType(int index) {
        this.checkIndex(index);
        return this.type[index];
    }

    public int getType(String fieldName) throws IDocFieldNotFoundException {
        return this.type[this.indexOf(fieldName)];
    }

    public String getTypeAsString(int index) {
        return AbstractMetaData.getJCOTypeString(this.getType(index));
    }

    public String getTypeAsString(String fieldName) throws IDocFieldNotFoundException {
        return AbstractMetaData.getJCOTypeString(this.getType(fieldName));
    }

    public int getDecimals(int index) {
        this.checkIndex(index);
        return this.decimals[index];
    }

    public int getDecimals(String fieldName) throws IDocFieldNotFoundException {
        return this.decimals[this.indexOf(fieldName)];
    }

    public String getDescription(int index) {
        this.checkIndex(index);
        return this.description.length == 0 ? null : this.description[index];
    }

    public String getDescription(String field_name) throws IDocFieldNotFoundException {
        return this.getDescription(this.indexOf(field_name));
    }

    public boolean isStructure(int index) {
        this.checkIndex(index);
        return this.type[index] == 17;
    }

    public boolean isStructure(String field_name) throws IDocFieldNotFoundException {
        return this.type[this.indexOf(field_name)] == 17;
    }

    public boolean isTable(int index) {
        this.checkIndex(index);
        return this.type[index] == 99;
    }

    public boolean isTable(String field_name) throws IDocFieldNotFoundException {
        return this.type[this.indexOf(field_name)] == 99;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MetaDataBase)) {
            return false;
        }
        MetaDataBase m = (MetaDataBase)obj;
        if (this.numFields != m.getFieldCount()) {
            return false;
        }
        for (int i = 0; i < this.numFields; ++i) {
            if (this.type[i] != m.getType(i)) {
                return false;
            }
            if (this.length[1][i] != m.getUnicodeByteLength(i)) {
                return false;
            }
            if (this.length[0][i] != m.getByteLength(i)) {
                return false;
            }
            if (!this.name[i].equals(m.getName(i))) {
                return false;
            }
            if (this.decimals[i] != m.getDecimals(i)) {
                return false;
            }
            if (this.type[i] != 17 && this.type[i] != 99) continue;
            String o1 = this.getRecordTypeName(i);
            String o2 = m.getRecordTypeName(i);
            if (!(o1 == null || o2 == null ? o1 != o2 : !o1.equals(o2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            for (int i = 0; i < this.numFields; ++i) {
                this.hashcode = 31 * this.hashcode + this.type[i];
                if (this.length[0][i] > 0) {
                    this.hashcode = 31 * this.hashcode + this.length[0][i];
                }
                if (this.length[1][i] > 0) {
                    this.hashcode = 31 * this.hashcode + this.length[1][i];
                }
                this.hashcode = 31 * this.hashcode + this.name[i].hashCode();
                this.hashcode = 31 * this.hashcode + this.decimals[i];
                if (this.type[i] != 17 && this.type[i] != 99) continue;
                String name = this.getRecordTypeName(i);
                this.hashcode = 31 * this.hashcode + (name == null ? 0 : name.hashCode());
            }
        }
        return this.hashcode;
    }

    protected static byte getJCOType(char type) {
        switch (type) {
            case 'C': {
                return 0;
            }
            case 'I': {
                return 8;
            }
            case 'N': {
                return 6;
            }
            case 'P': {
                return 2;
            }
            case 'D': {
                return 1;
            }
            case 'T': {
                return 3;
            }
            case 'F': {
                return 7;
            }
            case 'X': {
                return 4;
            }
            case 'g': {
                return 29;
            }
            case 'y': {
                return 30;
            }
            case 's': {
                return 9;
            }
            case 'b': {
                return 10;
            }
            case 'u': {
                return 17;
            }
            case 'v': {
                return 17;
            }
            case 'h': {
                return 99;
            }
            case 'E': {
                return 98;
            }
        }
        return -1;
    }

    protected static char getJCOTypeChar(int type) {
        switch (type) {
            case 0: {
                return 'C';
            }
            case 8: {
                return 'I';
            }
            case 6: {
                return 'N';
            }
            case 2: {
                return 'P';
            }
            case 1: {
                return 'D';
            }
            case 3: {
                return 'T';
            }
            case 7: {
                return 'F';
            }
            case 4: {
                return 'X';
            }
            case 29: {
                return 'g';
            }
            case 30: {
                return 'y';
            }
            case 9: {
                return 's';
            }
            case 10: {
                return 'b';
            }
            case 17: {
                return 'u';
            }
            case 99: {
                return 'h';
            }
            case 98: {
                return 'E';
            }
        }
        return 'C';
    }

    protected static String getJCOTypeString(int type) {
        switch (type) {
            case 0: {
                return "CHAR";
            }
            case 8: {
                return "INT";
            }
            case 6: {
                return "NUM";
            }
            case 2: {
                return "BCD";
            }
            case 1: {
                return "DATE";
            }
            case 3: {
                return "TIME";
            }
            case 7: {
                return "FLOAT";
            }
            case 4: {
                return "BYTE";
            }
            case 29: {
                return "STRING";
            }
            case 30: {
                return "XSTRING";
            }
            case 9: {
                return "INT2";
            }
            case 10: {
                return "INT1";
            }
            case 17: {
                return "STRUCTURE";
            }
            case 99: {
                return "TABLE";
            }
            case 98: {
                return "EXCEPTION";
            }
        }
        return "CHAR";
    }

    public final String getClassNameOfField(String fieldName) throws IDocFieldNotFoundException {
        return this.getClassNameOfField(this.indexOf(fieldName));
    }

    public final String getClassNameOfField(int index) {
        byte t = this.type[index];
        switch (t) {
            case 0: 
            case 2: 
            case 6: 
            case 29: {
                return "java.lang.String";
            }
            case 8: 
            case 9: 
            case 10: {
                return "java.lang.Integer";
            }
            case 7: {
                return "java.lang.Double";
            }
            case 4: 
            case 30: {
                return "byte[]";
            }
            case 1: 
            case 3: {
                return "java.util.Date";
            }
            case 17: {
                return "com.sap.conn.jco.JCoStructure";
            }
            case 99: {
                return "com.sap.conn.jco.JCoTable";
            }
        }
        return "java.lang.Object";
    }

    public String toString() {
        return this.toString(0);
    }

    protected abstract String toString(int var1);

    public final boolean isLocked() {
        return this.isLocked;
    }

    public final void lock() {
        if (this.isLocked()) {
            return;
        }
        this.hashCode();
        this.rebuildIndices();
        if (this.tabMeta != null) {
            for (int i = 0; i < this.tabMeta.length; ++i) {
                if (!(this.tabMeta[i] instanceof MetaDataBase)) continue;
                ((MetaDataBase)this.tabMeta[i]).lock();
            }
        }
        this.isLocked = true;
    }
}

