/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt;

import com.sap.conn.idoc.IDocConversionException;
import com.sap.conn.idoc.IDocDocument;
import com.sap.conn.idoc.IDocFieldNotFoundException;
import com.sap.conn.idoc.IDocMetaDataUnavailableException;
import com.sap.conn.idoc.IDocRepository;
import com.sap.conn.idoc.IDocRuntimeException;
import com.sap.conn.idoc.IDocSegment;
import com.sap.conn.idoc.IDocSegmentMetaData;
import com.sap.conn.idoc.IDocSyntaxException;
import com.sap.conn.idoc.rt.BasicIDocRecord;
import com.sap.conn.idoc.rt.DefaultIDocRuntime;
import com.sap.conn.idoc.rt.DefaultIDocSegment;
import com.sap.conn.idoc.rt.StaticControlStructures;
import com.sap.conn.idoc.rt.util.Utils;
import java.util.Date;

public class DefaultIDocDocument
extends BasicIDocRecord
implements IDocDocument {
    private static final long serialVersionUID = 1000L;
    protected int m_controlStructVersion = 0;
    protected IDocSegment m_rootSegment = null;
    protected String m_iDocCompoundType = null;

    protected DefaultIDocDocument(IDocRepository repository, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) throws IDocMetaDataUnavailableException {
        this(systemRelease != null && systemRelease.length() > 0 ? (Utils.removeAllDotsFromString(systemRelease).compareTo("4") >= 0 ? "EDI_DC40" : "EDI_DC") : "EDI_DC40", repository, iDocType, iDocTypeExtension, systemRelease, applicationRelease);
    }

    protected DefaultIDocDocument(String controlStructName) {
        super(StaticControlStructures.getControlStructureMetaData(controlStructName));
        if ("EDI_DC40".equals(controlStructName)) {
            this.m_controlStructVersion = 40;
        } else if ("EDI_DC".equals(controlStructName)) {
            this.m_controlStructVersion = 31;
        }
    }

    protected DefaultIDocDocument(String controlStructName, IDocRepository repository, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) throws IDocMetaDataUnavailableException {
        super(StaticControlStructures.getControlStructureMetaData(controlStructName));
        try {
            if ("EDI_DC40".equals(controlStructName)) {
                this.m_controlStructVersion = 40;
                this.setTableStructureName("EDI_DC40");
            } else if ("EDI_DC".equals(controlStructName)) {
                this.m_controlStructVersion = 31;
                this.setTableStructureName("EDI_DC");
            }
            IDocSegmentMetaData rootSegmentMetaData = repository.getRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
            if (rootSegmentMetaData == null) {
                throw new IDocMetaDataUnavailableException("The meta data for the IDoc type \"" + iDocType + "\" " + (iDocTypeExtension != null && iDocTypeExtension.length() > 0 ? "with extension \"" + iDocTypeExtension + "\" " : "") + (systemRelease != null && systemRelease.length() > 0 ? "for system release \"" + systemRelease + "\" " : "") + (applicationRelease != null && applicationRelease.length() > 0 ? "and application release \"" + applicationRelease + "\" " : "") + "is unavailable.");
            }
            this.m_rootSegment = this.createDefaultIDocSegment(this, rootSegmentMetaData, false);
            iDocType = rootSegmentMetaData.getIDocType();
            iDocTypeExtension = rootSegmentMetaData.getIDocTypeExtension();
            this.setIDocType(iDocType);
            this.setIDocTypeExtension(iDocTypeExtension);
            if (this.m_controlStructVersion == 31 || systemRelease != null && systemRelease.length() > 0 && systemRelease.compareTo("4") < 0) {
                this.setIDocCompoundType(repository.getIDocCompoundType(iDocType, iDocTypeExtension));
            }
            Date timestamp = new Date();
            this.setCreationDate(timestamp);
            this.setCreationTime(timestamp);
        }
        catch (IDocConversionException exc) {
        }
        catch (IDocSyntaxException exc) {
            // empty catch block
        }
    }

    public void checkMandatoryFields() throws IDocSyntaxException {
        String value = this.getMessageType();
        if (value == null || value.length() == 0) {
            throw new IDocSyntaxException(this, "MESTYP", "Missing mandatory field: MessageType (MESTYP)");
        }
        value = this.getIDocType();
        if (value == null || value.length() == 0) {
            throw new IDocSyntaxException(this, "IDOCTYP", "Missing mandatory field: IDocType (IDOCTYP)");
        }
        value = this.getRecipientPartnerType();
        if (value == null || value.length() == 0) {
            throw new IDocSyntaxException(this, "RCVPRT", "Missing mandatory field: RecipientPartnerType (RCVPRT)");
        }
        value = this.getRecipientPartnerNumber();
        if (value == null || value.length() == 0) {
            throw new IDocSyntaxException(this, "RCVPRN", "Missing mandatory field: RecipientPartnerNumber (RCVPRN)");
        }
        value = this.getSenderPort();
        if (value == null || value.length() == 0) {
            throw new IDocSyntaxException(this, "SNDPOR", "Missing mandatory field: SenderPort (SNDPOR)");
        }
        value = this.getSenderPartnerType();
        if (value == null || value.length() == 0) {
            throw new IDocSyntaxException(this, "SNDPRT", "Missing mandatory field: SenderPartnerType (SNDPRT)");
        }
        value = this.getSenderPartnerNumber();
        if (value == null || value.length() == 0) {
            throw new IDocSyntaxException(this, "SNDPRN", "Missing mandatory field: SenderPartnerNumber (SNDPRN)");
        }
    }

    public void checkSyntax() throws IDocMetaDataUnavailableException, IDocSyntaxException {
        this.checkSyntax(527);
    }

    public void checkSyntax(int options) throws IDocMetaDataUnavailableException, IDocSyntaxException {
        if ((options & 1) != 0) {
            this.checkMandatoryFields();
        }
        this.m_rootSegment.checkSyntax(options &= 0xFFFEFFFF);
    }

    protected DefaultIDocSegment createDefaultIDocSegment(IDocDocument document, IDocSegmentMetaData segmentMetaData, boolean checkFieldValuesOnSet) {
        return new DefaultIDocSegment(document, segmentMetaData, checkFieldValuesOnSet);
    }

    public void disableFieldValueChecking() {
        this.disableFieldValueChecking(true);
    }

    public void disableFieldValueChecking(boolean applyToSegments) {
        this.m_checkFieldValuesOnSet = false;
        if (applyToSegments) {
            this.m_rootSegment.disableFieldValueChecking(true);
        }
    }

    public void enableFieldValueChecking() {
        this.enableFieldValueChecking(true);
    }

    public void enableFieldValueChecking(boolean applyToSegments) {
        this.m_checkFieldValuesOnSet = true;
        if (applyToSegments) {
            this.m_rootSegment.enableFieldValueChecking(true);
        }
    }

    public int getNumSegments() {
        return this.m_rootSegment.getNumDescendants() + 1;
    }

    public int getNumSegments(String segmentType) {
        if (this.m_rootSegment.getType().equals(segmentType)) {
            return 1;
        }
        return this.m_rootSegment.getNumDescendants(segmentType);
    }

    public IDocSegment getRootSegment() {
        return this.m_rootSegment;
    }

    public String getArchiveKey() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(34);
            }
            case 31: {
                return this.getString(27);
            }
        }
        try {
            return this.getString("ARCKEY");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getClient() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(1);
            }
            case 31: {
                return this.getString(1);
            }
        }
        try {
            return this.getString("MANDT");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public Date getCreationDate() {
        try {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getDate(29);
                }
                case 31: {
                    return this.getDate(28);
                }
            }
            return this.getDate("CREDAT");
        }
        catch (IDocConversionException exc) {
            throw new IDocRuntimeException(exc);
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getCreationDateAsString() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(29);
            }
            case 31: {
                return this.getString(28);
            }
        }
        try {
            return this.getString("CREDAT");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public Date getCreationTime() {
        try {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getTime(30);
                }
                case 31: {
                    return this.getTime(29);
                }
            }
            return this.getTime("CRETIM");
        }
        catch (IDocConversionException exc) {
            throw new IDocRuntimeException(exc);
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getCreationTimeAsString() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(30);
            }
            case 31: {
                return this.getString(29);
            }
        }
        try {
            return this.getString("CRETIM");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getDirection() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(5);
            }
            case 31: {
                return this.getString(6);
            }
        }
        try {
            return this.getString("DIRECT");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getEDIMessage() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(33);
            }
            case 31: {
                return this.getString(26);
            }
        }
        try {
            return this.getString("REFMES");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getEDIMessageGroup() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(32);
            }
            case 31: {
                return this.getString(25);
            }
        }
        try {
            return this.getString("REFGRP");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getEDIMessageType() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(16);
            }
            case 31: {
                return this.getString(14);
            }
        }
        try {
            return this.getString("STDMES");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getEDIStandardFlag() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(14);
            }
            case 31: {
                return this.getString(12);
            }
        }
        try {
            return this.getString("STD");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getEDIStandardVersion() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(15);
            }
            case 31: {
                return this.getString(13);
            }
        }
        try {
            return this.getString("STDVRS");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getEDITransmissionFile() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(31);
            }
            case 31: {
                return this.getString(24);
            }
        }
        try {
            return this.getString("REFINT");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getExpressFlag() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(7);
            }
            case 31: {
                return this.getString(36);
            }
        }
        try {
            return this.getString("EXPRSS");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getIDocNumber() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(2);
            }
            case 31: {
                return this.getString(2);
            }
        }
        try {
            return this.getString("DOCNUM");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getIDocSAPRelease() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(3);
            }
            case 31: {
                return this.getString(3);
            }
        }
        try {
            return this.getString("DOCREL");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getIDocCompoundType() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.m_iDocCompoundType;
            }
            case 31: {
                return this.getString(5);
            }
        }
        if (this.m_iDocCompoundType != null) {
            return this.m_iDocCompoundType;
        }
        try {
            return this.getString("DOCTYP");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getIDocType() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(9);
            }
            case 31: {
                return this.getString(31);
            }
        }
        try {
            return this.getString("IDOCTYP");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getIDocTypeExtension() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(10);
            }
            case 31: {
                return this.getString(32);
            }
        }
        try {
            return this.getString("CIMTYP");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getMessageCode() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(12);
            }
            case 31: {
                return this.getString(15);
            }
        }
        try {
            return this.getString("MESCOD");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getMessageFunction() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(13);
            }
            case 31: {
                return this.getString(16);
            }
        }
        try {
            return this.getString("MESFCT");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getMessageType() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(11);
            }
            case 31: {
                return this.getString(30);
            }
        }
        try {
            return this.getString("MESTYP");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getOutputMode() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(6);
            }
            case 31: {
                return this.getString(17);
            }
        }
        try {
            return this.getString("OUTMOD");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getRecipientAddress() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(27);
            }
            case 31: {
                return this.getString(10);
            }
        }
        try {
            return this.getString("RCVSAD");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getRecipientLogicalAddress() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(28);
            }
            case 31: {
                return this.getString(11);
            }
        }
        try {
            return this.getString("RCVLAD");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getRecipientPartnerFunction() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(25);
            }
            case 31: {
                return this.getString(33);
            }
        }
        try {
            return this.getString("RCVPFC");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getRecipientPartnerNumber() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(26);
            }
            case 31: {
                return this.getString(9);
            }
        }
        try {
            return this.getString("RCVPRN");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getRecipientPartnerType() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(24);
            }
            case 31: {
                return this.getString(8);
            }
        }
        try {
            return this.getString("RCVPRT");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getRecipientPort() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(23);
            }
            case 31: {
                return this.getString(7);
            }
        }
        try {
            return this.getString("RCVPOR");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getSenderAddress() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(21);
            }
            case 31: {
                return this.getString(22);
            }
        }
        try {
            return this.getString("SNDSAD");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getSenderLogicalAddress() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(22);
            }
            case 31: {
                return this.getString(23);
            }
        }
        try {
            return this.getString("SNDLAD");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getSenderPartnerFunction() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(19);
            }
            case 31: {
                return this.getString(34);
            }
        }
        try {
            return this.getString("SNDPFC");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getSenderPartnerNumber() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(20);
            }
            case 31: {
                return this.getString(21);
            }
        }
        try {
            return this.getString("SNDPRN");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getSenderPartnerType() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(18);
            }
            case 31: {
                return this.getString(20);
            }
        }
        try {
            return this.getString("SNDPRT");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getSenderPort() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(17);
            }
            case 31: {
                return this.getString(19);
            }
        }
        try {
            return this.getString("SNDPOR");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getSerialization() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(35);
            }
            case 31: {
                return this.getString(35);
            }
        }
        try {
            return this.getString("SERIAL");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getStatus() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(4);
            }
            case 31: {
                return this.getString(4);
            }
        }
        try {
            return this.getString("STATUS");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getTableStructureName() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(0);
            }
            case 31: {
                return this.getString(0);
            }
        }
        try {
            return this.getString("TABNAM");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public String getTestFlag() {
        switch (this.m_controlStructVersion) {
            case 40: {
                return this.getString(8);
            }
            case 31: {
                return this.getString(18);
            }
        }
        try {
            return this.getString("TEST");
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    public void setArchiveKey(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(34, value);
                break;
            }
            case 31: {
                this.setValue(27, value);
                break;
            }
            default: {
                try {
                    this.setValue("ARCKEY", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setClient(String value) throws IDocConversionException, IDocSyntaxException {
        if (value != null && value.length() > 0 && value.length() < 3) {
            StringBuilder strBld = new StringBuilder(3);
            strBld.append(DefaultIDocRuntime.ZERO_CHARARRAY, 0, 3 - value.length());
            strBld.append(value);
            value = strBld.toString();
        }
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(1, value);
                break;
            }
            case 31: {
                this.setValue(1, value);
                break;
            }
            default: {
                try {
                    this.setValue("MANDT", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setCreationDate(Date value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(29, (Object)value);
                break;
            }
            case 31: {
                this.setValue(28, (Object)value);
                break;
            }
            default: {
                try {
                    this.setValue("CREDAT", (Object)value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setCreationDate(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(29, value);
                break;
            }
            case 31: {
                this.setValue(28, value);
                break;
            }
            default: {
                try {
                    this.setValue("CREDAT", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setCreationTime(Date value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(30, (Object)value);
                break;
            }
            case 31: {
                this.setValue(29, (Object)value);
                break;
            }
            default: {
                try {
                    this.setValue("CRETIM", (Object)value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setCreationTime(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(30, value);
                break;
            }
            case 31: {
                this.setValue(29, value);
                break;
            }
            default: {
                try {
                    this.setValue("CRETIM", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setDirection(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(5, value);
                break;
            }
            case 31: {
                this.setValue(6, value);
                break;
            }
            default: {
                try {
                    this.setValue("DIRECT", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setEDIMessage(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(33, value);
                break;
            }
            case 31: {
                this.setValue(26, value);
                break;
            }
            default: {
                try {
                    this.setValue("REFMES", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setEDIMessageGroup(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(32, value);
                break;
            }
            case 31: {
                this.setValue(25, value);
                break;
            }
            default: {
                try {
                    this.setValue("REFGRP", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setEDIMessageType(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(16, value);
                break;
            }
            case 31: {
                this.setValue(14, value);
                break;
            }
            default: {
                try {
                    this.setValue("STDMES", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setEDIStandardFlag(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(14, value);
                break;
            }
            case 31: {
                this.setValue(12, value);
                break;
            }
            default: {
                try {
                    this.setValue("STD", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setEDIStandardVersion(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(15, value);
                break;
            }
            case 31: {
                this.setValue(13, value);
                break;
            }
            default: {
                try {
                    this.setValue("STDVRS", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setEDITransmissionFile(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(31, value);
                break;
            }
            case 31: {
                this.setValue(24, value);
                break;
            }
            default: {
                try {
                    this.setValue("REFINT", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setIDocNumber(String value) throws IDocConversionException, IDocSyntaxException {
        if (value != null && value.length() > 0 && value.length() < 16) {
            StringBuilder strBld = new StringBuilder(16);
            strBld.append(DefaultIDocRuntime.ZERO_CHARARRAY, 0, 16 - value.length());
            strBld.append(value);
            value = strBld.toString();
        }
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(2, value);
                break;
            }
            case 31: {
                this.setValue(2, value);
                break;
            }
            default: {
                try {
                    this.setValue("DOCNUM", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setIDocSAPRelease(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(3, value);
                break;
            }
            case 31: {
                this.setValue(3, value);
                break;
            }
            default: {
                try {
                    this.setValue("DOCREL", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setIDocCompoundType(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                if (value == null || value.length() <= 8) {
                    this.m_iDocCompoundType = value;
                    break;
                }
                this.m_iDocCompoundType = value.substring(0, 8);
                break;
            }
            case 31: {
                this.setValue(5, value);
                break;
            }
            default: {
                try {
                    this.setValue("DOCTYP", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    this.m_iDocCompoundType = value == null || value.length() <= 8 ? value : value.substring(0, 8);
                }
            }
        }
    }

    public void setIDocType(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(9, value);
                break;
            }
            case 31: {
                this.setValue(31, value);
                break;
            }
            default: {
                try {
                    this.setValue("IDOCTYP", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setIDocTypeExtension(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(10, value);
                break;
            }
            case 31: {
                this.setValue(32, value);
                break;
            }
            default: {
                try {
                    this.setValue("CIMTYP", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setMessageCode(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(12, value);
                break;
            }
            case 31: {
                this.setValue(15, value);
                break;
            }
            default: {
                try {
                    this.setValue("MESCOD", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setMessageFunction(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(13, value);
                break;
            }
            case 31: {
                this.setValue(16, value);
                break;
            }
            default: {
                try {
                    this.setValue("MESFCT", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setMessageType(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(11, value);
                break;
            }
            case 31: {
                this.setValue(30, value);
                break;
            }
            default: {
                try {
                    this.setValue("MESTYP", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setOutputMode(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(6, value);
                break;
            }
            case 31: {
                this.setValue(17, value);
                break;
            }
            default: {
                try {
                    this.setValue("OUTMOD", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setRecipientAddress(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(27, value);
                break;
            }
            case 31: {
                this.setValue(10, value);
                break;
            }
            default: {
                try {
                    this.setValue("RCVSAD", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setRecipientLogicalAddress(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(28, value);
                break;
            }
            case 31: {
                this.setValue(11, value);
                break;
            }
            default: {
                try {
                    this.setValue("RCVLAD", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setRecipientPartnerFunction(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(25, value);
                break;
            }
            case 31: {
                this.setValue(33, value);
                break;
            }
            default: {
                try {
                    this.setValue("RCVPFC", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setRecipientPartnerNumber(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(26, value);
                break;
            }
            case 31: {
                this.setValue(9, value);
                break;
            }
            default: {
                try {
                    this.setValue("RCVPRN", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setRecipientPartnerType(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(24, value);
                break;
            }
            case 31: {
                this.setValue(8, value);
                break;
            }
            default: {
                try {
                    this.setValue("RCVPRT", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setRecipientPort(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(23, value);
                break;
            }
            case 31: {
                this.setValue(7, value);
                break;
            }
            default: {
                try {
                    this.setValue("RCVPOR", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setSenderAddress(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(21, value);
                break;
            }
            case 31: {
                this.setValue(22, value);
                break;
            }
            default: {
                try {
                    this.setValue("SNDSAD", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setSenderLogicalAddress(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(22, value);
                break;
            }
            case 31: {
                this.setValue(23, value);
                break;
            }
            default: {
                try {
                    this.setValue("SNDLAD", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setSenderPartnerFunction(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(19, value);
                break;
            }
            case 31: {
                this.setValue(34, value);
                break;
            }
            default: {
                try {
                    this.setValue("SNDPFC", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setSenderPartnerNumber(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(20, value);
                break;
            }
            case 31: {
                this.setValue(21, value);
                break;
            }
            default: {
                try {
                    this.setValue("SNDPRN", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setSenderPartnerType(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(18, value);
                break;
            }
            case 31: {
                this.setValue(20, value);
                break;
            }
            default: {
                try {
                    this.setValue("SNDPRT", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setSenderPort(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(17, value);
                break;
            }
            case 31: {
                this.setValue(19, value);
                break;
            }
            default: {
                try {
                    this.setValue("SNDPOR", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setSerialization(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(35, value);
                break;
            }
            case 31: {
                this.setValue(35, value);
                break;
            }
            default: {
                try {
                    this.setValue("SERIAL", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setStatus(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(4, value);
                break;
            }
            case 31: {
                this.setValue(4, value);
                break;
            }
            default: {
                try {
                    this.setValue("STATUS", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    protected void setTableStructureName(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(0, value);
                break;
            }
            case 31: {
                this.setValue(0, value);
                break;
            }
            default: {
                try {
                    this.setValue("TABNAM", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public void setTestFlag(String value) throws IDocConversionException, IDocSyntaxException {
        switch (this.m_controlStructVersion) {
            case 40: {
                this.setValue(8, value);
                break;
            }
            case 31: {
                this.setValue(18, value);
                break;
            }
            default: {
                try {
                    this.setValue("TEST", value);
                    break;
                }
                catch (IDocFieldNotFoundException exc) {
                    throw new IDocRuntimeException(exc);
                }
            }
        }
    }

    public String toString() {
        StringBuilder strBuf = new StringBuilder(500);
        strBuf.append("ArchiveKey = ");
        strBuf.append(this.getArchiveKey());
        strBuf.append("\nClient = ");
        strBuf.append(this.getClient());
        strBuf.append("\nCreationDate = ");
        strBuf.append(this.getCreationDateAsString());
        strBuf.append("\nCreationTime = ");
        strBuf.append(this.getCreationTimeAsString());
        strBuf.append("\nDirection = ");
        strBuf.append(this.getDirection());
        strBuf.append("\nEDIMessage = ");
        strBuf.append(this.getEDIMessage());
        strBuf.append("\nEDIMessageGroup = ");
        strBuf.append(this.getEDIMessageGroup());
        strBuf.append("\nEDIMessageType = ");
        strBuf.append(this.getEDIMessageType());
        strBuf.append("\nEDIStandardFlag = ");
        strBuf.append(this.getEDIStandardFlag());
        strBuf.append("\nEDIStandardVersion = ");
        strBuf.append(this.getEDIStandardVersion());
        strBuf.append("\nEDITransmissionFile = ");
        strBuf.append(this.getEDITransmissionFile());
        strBuf.append("\nExpressFlag = ");
        strBuf.append(this.getExpressFlag());
        strBuf.append("\nIDocNumber = ");
        strBuf.append(this.getIDocNumber());
        strBuf.append("\nIDocSAPRelease = ");
        strBuf.append(this.getIDocSAPRelease());
        strBuf.append("\nIDocCompoundType = ");
        strBuf.append(this.getIDocCompoundType());
        strBuf.append("\nIDocType = ");
        strBuf.append(this.getIDocType());
        strBuf.append("\nIDocTypeExtension = ");
        strBuf.append(this.getIDocTypeExtension());
        strBuf.append("\nMessageCode = ");
        strBuf.append(this.getMessageCode());
        strBuf.append("\nMessageFunction = ");
        strBuf.append(this.getMessageFunction());
        strBuf.append("\nMessageType = ");
        strBuf.append(this.getMessageType());
        strBuf.append("\nOutputMode = ");
        strBuf.append(this.getOutputMode());
        strBuf.append("\nSenderAddress = ");
        strBuf.append(this.getSenderAddress());
        strBuf.append("\nSenderLogicalAddress = ");
        strBuf.append(this.getSenderLogicalAddress());
        strBuf.append("\nSenderPartnerFunction = ");
        strBuf.append(this.getSenderPartnerFunction());
        strBuf.append("\nSenderPartnerNumber = ");
        strBuf.append(this.getSenderPartnerNumber());
        strBuf.append("\nSenderPartnerType = ");
        strBuf.append(this.getSenderPartnerType());
        strBuf.append("\nSenderPort = ");
        strBuf.append(this.getSenderPort());
        strBuf.append("\nSerialization = ");
        strBuf.append(this.getSerialization());
        strBuf.append("\nRecipientAddress = ");
        strBuf.append(this.getRecipientAddress());
        strBuf.append("\nRecipientLogicalAddress = ");
        strBuf.append(this.getRecipientLogicalAddress());
        strBuf.append("\nRecipientPartnerFunction = ");
        strBuf.append(this.getRecipientPartnerFunction());
        strBuf.append("\nRecipientPartnerNumber = ");
        strBuf.append(this.getRecipientPartnerNumber());
        strBuf.append("\nRecipientPartnerType = ");
        strBuf.append(this.getRecipientPartnerType());
        strBuf.append("\nRecipientPort = ");
        strBuf.append(this.getRecipientPort());
        strBuf.append("\nStatus = ");
        strBuf.append(this.getStatus());
        strBuf.append("\nTestFlag = ");
        strBuf.append(this.getTestFlag());
        IDocSegment segment = this.m_rootSegment;
        int[] tree = new int[100];
        int rootlevel = segment.getHierarchyLevel();
        int hlevel = 0;
        tree[1] = segment.getNumChildren();
        strBuf.append("\n");
        strBuf.append(segment.getRecordMetaData().getName());
        strBuf.append(" (Type: ");
        strBuf.append(segment.getType());
        strBuf.append(")\n");
        for (segment = segment.getNext(); segment != null; segment = segment.getNext()) {
            int i;
            hlevel = segment.getHierarchyLevel();
            tree[hlevel - rootlevel + 1] = segment.getNumChildren();
            for (i = 1; i < hlevel - rootlevel; ++i) {
                if (tree[i] > 0) {
                    strBuf.append("!   ");
                    continue;
                }
                strBuf.append("    ");
            }
            strBuf.append("!\n");
            for (i = 1; i < hlevel - rootlevel; ++i) {
                if (tree[i] > 0) {
                    strBuf.append("!   ");
                    continue;
                }
                strBuf.append("    ");
            }
            strBuf.append("+-- ");
            strBuf.append(segment.getRecordMetaData().getName());
            strBuf.append(" (Type: ");
            strBuf.append(segment.getType());
            strBuf.append(")\n");
            int n = hlevel - rootlevel;
            tree[n] = tree[n] - 1;
        }
        return strBuf.toString();
    }

    public Object clone() {
        return super.clone();
    }
}

