/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.driver;

import com.sap.conn.jco.rt.DefaultTable;
import com.sap.conn.rfc.api.RfcAcceptInfo;
import com.sap.conn.rfc.api.RfcOptions;
import com.sap.conn.rfc.data.ARFCSDATA;
import com.sap.conn.rfc.data.ARfcSDataHeader;
import com.sap.conn.rfc.driver.RfcDriver;
import com.sap.conn.rfc.driver.RfcDriverState;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcPlaybackInfo;
import com.sap.conn.rfc.engine.Trc;

public class RfcTypePlayback
extends RfcDriver {
    private static final int blocksize = 1785;
    public ARFCSDATA itab_h;
    public ARfcSDataHeader key = new ARfcSDataHeader();
    public boolean pr_mode;
    public int linno;

    public RfcTypePlayback(RfcIoOpenCntl iocntl) {
        super(iocntl);
    }

    @Override
    public synchronized int open(RfcOptions options) {
        this.pr_mode = true;
        return 0;
    }

    @Override
    public synchronized int accept(RfcAcceptInfo acceptInfo) {
        RfcPlaybackInfo info = (RfcPlaybackInfo)acceptInfo;
        this.pr_mode = false;
        this.itab_h = info.itab_h;
        this.linno = 0;
        return 0;
    }

    @Override
    public synchronized int write(byte[] buffer, int buffersize, boolean last) {
        DefaultTable data = this.itab_h.getTable();
        if (!this.pr_mode) {
            return 0;
        }
        data.appendRow();
        data.setValue(0, this.key.getTID());
        data.setValue(1, this.key.getDestination());
        data.setValue(2, this.key.getLuwCounter());
        data.setValue(3, this.key.getBlockCounter());
        data.setValue(4, buffer);
        this.key.incrementBlockCounter();
        return 0;
    }

    @Override
    public synchronized int read(byte[] buffer, int buffersize, int[] bytes_read) {
        DefaultTable table = this.itab_h.getTable();
        byte[] ptr = null;
        if (this.pr_mode) {
            return 0;
        }
        if (table.getNumRows() <= this.linno) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("read(RfcTypePlayback) :: Finished after " + Integer.toString(this.linno) + " rows\n");
            }
            return 10;
        }
        table.setRow(this.linno);
        ++this.linno;
        ptr = table.getByteArray(4);
        System.arraycopy(ptr, 0, buffer, 0, Math.min(1785, ptr.length));
        bytes_read[0] = 1785;
        return 0;
    }

    @Override
    public int rflush() {
        return 0;
    }

    @Override
    public int wflush() {
        return 0;
    }

    @Override
    public void close() {
    }

    @Override
    public void abort() {
    }

    @Override
    public int getPacketSize() {
        return 1785;
    }

    @Override
    public int listen(byte[] buffer, int buffersize, int[] bytes_read, int timeout) {
        return 0;
    }

    @Override
    public void info(byte[] info) {
    }

    @Override
    public int proto(int set_get, int proto) {
        return 0;
    }

    @Override
    public int wait(byte[] buffer, int bufsize, int[] bytes_read) {
        bytes_read[0] = 0;
        return 0;
    }

    @Override
    public RfcDriverState getRfcDriverState() {
        return null;
    }

    @Override
    public void restoreState(RfcDriverState driverState) {
    }

    @Override
    public byte[] getSncPartnerAclKey() {
        assert (this.act_cntl.htRFC != null) : "Handle " + this.act_cntl.htRFC + " is not referenced";
        return this.act_cntl.htRFC.getSncPartnerAclKey();
    }

    @Override
    public String getSncPartnerName() {
        assert (this.act_cntl.htRFC != null) : "Handle " + this.act_cntl.htRFC + " is not referenced";
        return this.act_cntl.htRFC.getSncPartnerName();
    }

    @Override
    public boolean isSncMode() {
        assert (this.act_cntl.htRFC != null) : "Handle " + this.act_cntl.htRFC + " is not referenced";
        return this.act_cntl.htRFC.isSncMode();
    }
}

