/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonschema.JsonSerializableSchema;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicReference;

@JacksonStdImpl
public class SerializableSerializer
extends StdSerializer<JsonSerializable> {
    public static final SerializableSerializer instance = new SerializableSerializer();
    private static final AtomicReference<ObjectMapper> _mapperReference = new AtomicReference();

    protected SerializableSerializer() {
        super(JsonSerializable.class);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializers, JsonSerializable value2) {
        if (value2 instanceof JsonSerializable.Base) {
            return ((JsonSerializable.Base)value2).isEmpty(serializers);
        }
        return false;
    }

    @Override
    public void serialize(JsonSerializable value2, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        value2.serialize(gen, serializers);
    }

    @Override
    public final void serializeWithType(JsonSerializable value2, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        value2.serializeWithType(gen, serializers, typeSer);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        Class<?> rawClass;
        ObjectNode objectNode = this.createObjectNode();
        String schemaType = "any";
        String objectProperties = null;
        String itemDefinition = null;
        if (typeHint != null && (rawClass = TypeFactory.rawClass(typeHint)).isAnnotationPresent(JsonSerializableSchema.class)) {
            JsonSerializableSchema schemaInfo = rawClass.getAnnotation(JsonSerializableSchema.class);
            schemaType = schemaInfo.schemaType();
            if (!"##irrelevant".equals(schemaInfo.schemaObjectPropertiesDefinition())) {
                objectProperties = schemaInfo.schemaObjectPropertiesDefinition();
            }
            if (!"##irrelevant".equals(schemaInfo.schemaItemDefinition())) {
                itemDefinition = schemaInfo.schemaItemDefinition();
            }
        }
        objectNode.put("type", schemaType);
        if (objectProperties != null) {
            try {
                objectNode.set("properties", SerializableSerializer._getObjectMapper().readTree(objectProperties));
            }
            catch (IOException e) {
                throw JsonMappingException.from(provider, "Failed to parse @JsonSerializableSchema.schemaObjectPropertiesDefinition value");
            }
        }
        if (itemDefinition != null) {
            try {
                objectNode.set("items", SerializableSerializer._getObjectMapper().readTree(itemDefinition));
            }
            catch (IOException e) {
                throw JsonMappingException.from(provider, "Failed to parse @JsonSerializableSchema.schemaItemDefinition value");
            }
        }
        return objectNode;
    }

    private static final synchronized ObjectMapper _getObjectMapper() {
        ObjectMapper mapper2 = _mapperReference.get();
        if (mapper2 == null) {
            mapper2 = new ObjectMapper();
            _mapperReference.set(mapper2);
        }
        return mapper2;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectAnyFormat(typeHint);
    }
}

