/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RefDatabase {
    protected static final String[] SEARCH_PATH = new String[]{"", "refs/", "refs/tags/", "refs/heads/", "refs/remotes/"};
    protected static final int MAX_SYMBOLIC_REF_DEPTH = 5;
    public static final String ALL = "";

    public abstract void create() throws IOException;

    public abstract void close();

    public abstract boolean isNameConflicting(String var1) throws IOException;

    public Collection<String> getConflictingNames(String name2) throws IOException {
        Map<String, Ref> allRefs = this.getRefs(ALL);
        int lastSlash = name2.lastIndexOf(47);
        while (0 < lastSlash) {
            String needle = name2.substring(0, lastSlash);
            if (allRefs.containsKey(needle)) {
                return Collections.singletonList(needle);
            }
            lastSlash = name2.lastIndexOf(47, lastSlash - 1);
        }
        ArrayList<String> conflicting = new ArrayList<String>();
        String prefix = name2 + '/';
        for (String existing : allRefs.keySet()) {
            if (!existing.startsWith(prefix)) continue;
            conflicting.add(existing);
        }
        return conflicting;
    }

    public abstract RefUpdate newUpdate(String var1, boolean var2) throws IOException;

    public abstract RefRename newRename(String var1, String var2) throws IOException;

    public BatchRefUpdate newBatchUpdate() {
        return new BatchRefUpdate(this);
    }

    public boolean performsAtomicTransactions() {
        return false;
    }

    public abstract Ref getRef(String var1) throws IOException;

    public abstract Map<String, Ref> getRefs(String var1) throws IOException;

    public abstract List<Ref> getAdditionalRefs() throws IOException;

    public abstract Ref peel(Ref var1) throws IOException;

    public void refresh() {
    }

    public static Ref findRef(Map<String, Ref> map2, String name2) {
        for (String prefix : SEARCH_PATH) {
            String fullname = prefix + name2;
            Ref ref2 = map2.get(fullname);
            if (ref2 == null) continue;
            return ref2;
        }
        return null;
    }
}

