package io.fabric8.maven.docker.model;
/*
 *
 * Copyright 2014 Roland Huss
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Interface representing an inspected container
 *
 * @author daniel
 * @since 17/02/15
 */
public interface InspectedContainer extends Container {

    /**
     * The Health Status of this container (if applicable).
     * @return {@code false} if the container has a configured healthcheck and has not the
     * Health Status "healthy". Returns {@code true} otherwise.
     */
    boolean isHealthy();

    /**
     * @return the docker healthcheck command that is configured for this container.
     */
    String getHealthcheck();

}
