/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.karaf.itests;

import static org.junit.Assert.assertEquals;
import static org.ops4j.pax.exam.karaf.options.KarafDistributionOption.replaceConfigurationFile;

import java.io.IOException;

import javax.inject.Inject;

import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@RunWith(PaxExam.class)
@ExamReactorStrategy(PerClass.class)
public class ConfigManagedServiceFactoryTest extends KarafTestSupport {

	@Inject
	ConfigurationAdmin configAdmin;

	@org.ops4j.pax.exam.Configuration
	public Option[] config() {
		return new Option[] {
				CoreOptions.composite(super.config()),
				replaceConfigurationFile("etc/myconfig-test1.cfg",
						getConfigFile("/etc/myconfig-test1.cfg")),
		// KarafDistributionOption.debugConfiguration()
		};
	}

	@Test
	public void updateProperties() throws IOException, InvalidSyntaxException {
		checkInitialValuesFromFelixConfigAdmin();
		checkEditByFactoryPid();
		CheckEditByArbitraryAttribute();
	}
	
	@Test
	public void createNewFactoryConfig() throws Exception {
		executeCommand("config:edit --factory myconfig2\n"
				+ "config:property-set test1 data1\n"
				+ "config:update", new RolePrincipal("manager"));
		Configuration config = configAdmin.listConfigurations("(service.factorypid=myconfig2)")[0];
		assertEquals("data1", config.getProperties().get("test1"));
	}

	private void checkInitialValuesFromFelixConfigAdmin() throws IOException,
			InvalidSyntaxException {
		Configuration config = readConfig();
		assertEquals("data1", config.getProperties().get("test1"));
		assertEquals("data2", config.getProperties().get("test2"));
	}

	private void checkEditByFactoryPid() throws IOException,
			InvalidSyntaxException {
		executeCommand("config:edit '(service.factorypid=myconfig)'\n"
				+ "config:property-set test1 data1new\n" + "config:update",
				new RolePrincipal("manager"));
		Configuration config = readConfig();
		assertEquals("data1new", config.getProperties().get("test1"));
		assertEquals("data2", config.getProperties().get("test2"));
	}

	private void CheckEditByArbitraryAttribute() throws IOException,
			InvalidSyntaxException {
		executeCommand("config:edit '(test2=data2)'\n"
				+ "config:property-set test1 data1new2\n" + "config:update",
				new RolePrincipal("manager"));
		Configuration config = readConfig();
		assertEquals("data1new2", config.getProperties().get("test1"));
		assertEquals("data2", config.getProperties().get("test2"));
	}

	private Configuration readConfig() throws IOException,
			InvalidSyntaxException {
		Configuration[] configs = configAdmin
				.listConfigurations("(service.factorypid=myconfig)");
		return configs[0];
	}

}