/*
 * #%L
 * Fuse Patch :: Core
 * %%
 * Copyright (C) 2015 Private
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package org.wildfly.extras.patch.test;

import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.patch.internal.Main;

import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;


@Ignore
public class CVEPatchTest {

    String jbossHome = System.getenv("JBOSS_HOME");
    Logger LOG = LoggerFactory.getLogger(CVEPatchTest.class);

    @Test
    public void testCVEOneOff() throws Exception {

        Main.main(withArgs("--query-server"));

        String eapDistro = "fuse-eap-distro-7.11.1.fuse-SNAPSHOT";
        String eapDistroPatch = eapDistro + "-CVE-2022-36437.zip";
        Path eapPatchPath = Paths.get(jbossHome, eapDistroPatch);
        Main.main(withArgs("--add file:" + eapPatchPath + " --one-off " + eapDistro));
    }

    String[] withArgs(String cmdLine) throws Exception {
        String jbossHome = System.getenv("JBOSS_HOME");
        URL repoURL = Paths.get(jbossHome + "/fusepatch/repository").toUri().toURL();
        String cmdPrefix = String.format("--server %s --repository %s", jbossHome, repoURL);
        return String.format("%s %s", cmdPrefix, cmdLine).split(" ");
    }
}
