export default {
  beer:
    'data:image/svg+xml;base64,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',
  buffer:
    "data:image/svg+xml,%3Csvg aria-hidden='true' focusable='false' data-prefix='fab' data-icon='buffer' role='img' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 448 512' class='svg-inline--fa fa-buffer fa-w-14 fa-3x'%3E%3Cpath fill='currentColor' d='M427.84 380.67l-196.5 97.82a18.6 18.6 0 0 1-14.67 0L20.16 380.67c-4-2-4-5.28 0-7.29L67.22 350a18.65 18.65 0 0 1 14.69 0l134.76 67a18.51 18.51 0 0 0 14.67 0l134.76-67a18.62 18.62 0 0 1 14.68 0l47.06 23.43c4.05 1.96 4.05 5.24 0 7.24zm0-136.53l-47.06-23.43a18.62 18.62 0 0 0-14.68 0l-134.76 67.08a18.68 18.68 0 0 1-14.67 0L81.91 220.71a18.65 18.65 0 0 0-14.69 0l-47.06 23.43c-4 2-4 5.29 0 7.31l196.51 97.8a18.6 18.6 0 0 0 14.67 0l196.5-97.8c4.05-2.02 4.05-5.3 0-7.31zM20.16 130.42l196.5 90.29a20.08 20.08 0 0 0 14.67 0l196.51-90.29c4-1.86 4-4.89 0-6.74L231.33 33.4a19.88 19.88 0 0 0-14.67 0l-196.5 90.28c-4.05 1.85-4.05 4.88 0 6.74z' class=''%3E%3C/path%3E%3C/svg%3E",
  cubes:
    "data:image/svg+xml,%3Csvg aria-hidden='true' focusable='false' data-prefix='fas' data-icon='cubes'" +
    " role='img' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512' class='svg-inline--fa fa-cubes fa-w-16 fa-5x'%3E%3Cpath fill='currentColor' d='M488.6 250.2L392 214V105.5c0-15-9.3-28.4-23.4-33.7l-100-37.5c-8.1-3.1-17.1-3.1-25.3 0l-100 37.5c-14.1 5.3-23.4 18.7-23.4 33.7V214l-96.6 36.2C9.3 255.5 0 268.9 0 283.9V394c0 13.6 7.7 26.1 19.9 32.2l100 50c10.1 5.1 22.1 5.1 32.2 0l103.9-52 103.9 52c10.1 5.1 22.1 5.1 32.2 0l100-50c12.2-6.1 19.9-18.6 19.9-32.2V283.9c0-15-9.3-28.4-23.4-33.7zM358 214.8l-85 31.9v-68.2l85-37v73.3zM154 104.1l102-38.2 102 38.2v.6l-102 41.4-102-41.4v-.6zm84 291.1l-85 42.5v-79.1l85-38.8v75.4zm0-112l-102 41.4-102-41.4v-.6l102-38.2 102 38.2v.6zm240 112l-85 42.5v-79.1l85-38.8v75.4zm0-112l-102 41.4-102-41.4v-.6l102-38.2 102 38.2v.6z' class=''%3E%3C/path%3E%3C/svg%3E",
  github:
    "data:image/svg+xml,%3Csvg aria-hidden='true' focusable='false' data-prefix='fab' data-icon='github' role='img'" +
    " xmlns='http://www.w3.org/2000/svg' viewBox='0 0 496 512' class='svg-inline--fa fa-github fa-w-16 fa-3x'%3E%3Cpath fill='currentColor' d='M165.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3.3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-4.5c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2s-1.3-4.3-4.3-5.2c-2.6-.7-5.5.3-6.2 2.3zm44.2-1.7c-2.9.7-4.9 2.6-4.6 4.9.3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.6-.3-1.9-3-3.2-5.9-2.9zM244.8 8C106.1 8 0 113.3 0 252c0 110.9 69.8 205.8 169.5 239.2 12.8 2.3 17.3-5.6 17.3-12.1 0-6.2-.3-40.4-.3-61.4 0 0-70 15-84.7-29.8 0 0-11.4-29.1-27.8-36.6 0 0-22.9-15.7 1.6-15.4 0 0 24.9 2 38.6 25.8 21.9 38.6 58.6 27.5 72.9 20.9 2.3-16 8.8-27.1 16-33.7-55.9-6.2-112.3-14.3-112.3-110.5 0-27.5 7.6-41.3 23.6-58.9-2.6-6.5-11.1-33.3 2.6-67.9 20.9-6.5 69 27 69 27 20-5.6 41.5-8.5 62.8-8.5s42.8 2.9 62.8 8.5c0 0 48.1-33.6 69-27 13.7 34.7 5.2 61.4 2.6 67.9 16 17.7 25.8 31.5 25.8 58.9 0 96.5-58.9 104.2-114.8 110.5 9.2 7.9 17 22.9 17 46.4 0 33.7-.3 75.4-.3 83.6 0 6.5 4.6 14.4 17.3 12.1C428.2 457.8 496 362.9 496 252 496 113.3 383.5 8 244.8 8zM97.2 352.9c-1.3 1-1 3.3.7 5.2 1.6 1.6 3.9 2.3 5.2 1 1.3-1 1-3.3-.7-5.2-1.6-1.6-3.9-2.3-5.2-1zm-10.8-8.1c-.7 1.3.3 2.9 2.3 3.9 1.6 1 3.6.7 4.3-.7.7-1.3-.3-2.9-2.3-3.9-2-.6-3.6-.3-4.3.7zm32.4 35.6c-1.6 1.3-1 4.3 1.3 6.2 2.3 2.3 5.2 2.6 6.5 1 1.3-1.3.7-4.3-1.3-6.2-2.2-2.3-5.2-2.6-6.5-1zm-11.4-14.7c-1.6 1-1.6 3.6 0 5.9 1.6 2.3 4.3 3.3 5.6 2.3 1.6-1.3 1.6-3.9 0-6.2-1.4-2.3-4-3.3-5.6-2z' class=''%3E%3C/path%3E%3C/svg%3E",
  reddit:
    "data:image/svg+xml,%3Csvg aria-hidden='true' focusable='false' data-prefix='fab' data-icon='reddit' role='img' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512' class='svg-inline--fa fa-reddit fa-w-16 fa-3x'%3E%3Cpath fill='currentColor' d='M201.5 305.5c-13.8 0-24.9-11.1-24.9-24.6 0-13.8 11.1-24.9 24.9-24.9 13.6 0 24.6 11.1 24.6 24.9 0 13.6-11.1 24.6-24.6 24.6zM504 256c0 137-111 248-248 248S8 393 8 256 119 8 256 8s248 111 248 248zm-132.3-41.2c-9.4 0-17.7 3.9-23.8 10-22.4-15.5-52.6-25.5-86.1-26.6l17.4-78.3 55.4 12.5c0 13.6 11.1 24.6 24.6 24.6 13.8 0 24.9-11.3 24.9-24.9s-11.1-24.9-24.9-24.9c-9.7 0-18 5.8-22.1 13.8l-61.2-13.6c-3-.8-6.1 1.4-6.9 4.4l-19.1 86.4c-33.2 1.4-63.1 11.3-85.5 26.8-6.1-6.4-14.7-10.2-24.1-10.2-34.9 0-46.3 46.9-14.4 62.8-1.1 5-1.7 10.2-1.7 15.5 0 52.6 59.2 95.2 132 95.2 73.1 0 132.3-42.6 132.3-95.2 0-5.3-.6-10.8-1.9-15.8 31.3-16 19.8-62.5-14.9-62.5zM302.8 331c-18.2 18.2-76.1 17.9-93.6 0-2.2-2.2-6.1-2.2-8.3 0-2.5 2.5-2.5 6.4 0 8.6 22.8 22.8 87.3 22.8 110.2 0 2.5-2.2 2.5-6.1 0-8.6-2.2-2.2-6.1-2.2-8.3 0zm7.7-75c-13.6 0-24.6 11.1-24.6 24.9 0 13.6 11.1 24.6 24.6 24.6 13.8 0 24.9-11.1 24.9-24.6 0-13.8-11-24.9-24.9-24.9z' class=''%3E%3C/path%3E%3C/svg%3E",
  redHat:
    "data:image/svg+xml,%3Csvg aria-hidden='true' focusable='false' data-prefix='fab' data-icon='redhat' role='img' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512' class='svg-inline--fa fa-redhat fa-w-16 fa-3x'%3E%3Cpath fill='currentColor' d='M341.52 285.56c33.65 0 82.34-6.94 82.34-47 .22-6.74.86-1.82-20.88-96.24-4.62-19.15-8.68-27.84-42.31-44.65-26.09-13.34-82.92-35.37-99.73-35.37-15.66 0-20.2 20.17-38.87 20.17-18 0-31.31-15.06-48.12-15.06-16.14 0-26.66 11-34.78 33.62-27.5 77.55-26.28 74.27-26.12 78.27 0 24.8 97.64 106.11 228.47 106.11M429 254.84c4.65 22 4.65 24.35 4.65 27.25 0 37.66-42.33 58.56-98 58.56-125.74.08-235.91-73.65-235.91-122.33a49.55 49.55 0 0 1 4.06-19.72C58.56 200.86 0 208.93 0 260.63c0 84.67 200.63 189 359.49 189 121.79 0 152.51-55.08 152.51-98.58 0-34.21-29.59-73.05-82.93-96.24' class=''%3E%3C/path%3E%3C/svg%3E",
  salesforce:
    "data:image/svg+xml,%3Csvg aria-hidden='true' focusable='false' data-prefix='fab' data-icon='salesforce' role='img' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 640 512' class='svg-inline--fa fa-salesforce fa-w-20 fa-3x'%3E%3Cpath fill='currentColor' d='M248.89 245.64h-26.35c.69-5.16 3.32-14.12 13.64-14.12 6.75 0 11.97 3.82 12.71 14.12zm136.66-13.88c-.47 0-14.11-1.77-14.11 20s13.63 20 14.11 20c13 0 14.11-13.54 14.11-20 0-21.76-13.66-20-14.11-20zm-243.22 23.76a8.63 8.63 0 0 0-3.29 7.29c0 4.78 2.08 6.05 3.29 7.05 4.7 3.7 15.07 2.12 20.93.95v-16.94c-5.32-1.07-16.73-1.96-20.93 1.65zM640 232c0 87.58-80 154.39-165.36 136.43-18.37 33-70.73 70.75-132.2 41.63-41.16 96.05-177.89 92.18-213.81-5.17C8.91 428.78-50.19 266.52 53.36 205.61 18.61 126.18 76 32 167.67 32a124.24 124.24 0 0 1 98.56 48.7c20.7-21.4 49.4-34.81 81.15-34.81 42.34 0 79 23.52 98.8 58.57C539 63.78 640 132.69 640 232zm-519.55 31.8c0-11.76-11.69-15.17-17.87-17.17-5.27-2.11-13.41-3.51-13.41-8.94 0-9.46 17-6.66 25.17-2.12 0 0 1.17.71 1.64-.47.24-.7 2.36-6.58 2.59-7.29a1.13 1.13 0 0 0-.7-1.41c-12.33-7.63-40.7-8.51-40.7 12.7 0 12.46 11.49 15.44 17.88 17.17 4.72 1.58 13.17 3 13.17 8.7 0 4-3.53 7.06-9.17 7.06a31.76 31.76 0 0 1-19-6.35c-.47-.23-1.42-.71-1.65.71l-2.4 7.47c-.47.94.23 1.18.23 1.41 1.75 1.4 10.3 6.59 22.82 6.59 13.17 0 21.4-7.06 21.4-18.11zm32-42.58c-10.13 0-18.66 3.17-21.4 5.18a1 1 0 0 0-.24 1.41l2.59 7.06a1 1 0 0 0 1.18.7c.65 0 6.8-4 16.93-4 4 0 7.06.71 9.18 2.36 3.6 2.8 3.06 8.29 3.06 10.58-4.79-.3-19.11-3.44-29.41 3.76a16.92 16.92 0 0 0-7.34 14.54c0 5.9 1.51 10.4 6.59 14.35 12.24 8.16 36.28 2 38.1 1.41 1.58-.32 3.53-.66 3.53-1.88v-33.88c.04-4.61.32-21.64-22.78-21.64zM199 200.24a1.11 1.11 0 0 0-1.18-1.18H188a1.11 1.11 0 0 0-1.17 1.18v79a1.11 1.11 0 0 0 1.17 1.18h9.88a1.11 1.11 0 0 0 1.18-1.18zm55.75 28.93c-2.1-2.31-6.79-7.53-17.65-7.53-3.51 0-14.16.23-20.7 8.94-6.35 7.63-6.58 18.11-6.58 21.41 0 3.12.15 14.26 7.06 21.17 2.64 2.91 9.06 8.23 22.81 8.23 10.82 0 16.47-2.35 18.58-3.76.47-.24.71-.71.24-1.88l-2.35-6.83a1.26 1.26 0 0 0-1.41-.7c-2.59.94-6.35 2.82-15.29 2.82-17.42 0-16.85-14.74-16.94-16.7h37.17a1.23 1.23 0 0 0 1.17-.94c-.29 0 2.07-14.7-6.09-24.23zm36.69 52.69c13.17 0 21.41-7.06 21.41-18.11 0-11.76-11.7-15.17-17.88-17.17-4.14-1.66-13.41-3.38-13.41-8.94 0-3.76 3.29-6.35 8.47-6.35a38.11 38.11 0 0 1 16.7 4.23s1.18.71 1.65-.47c.23-.7 2.35-6.58 2.58-7.29a1.13 1.13 0 0 0-.7-1.41c-7.91-4.9-16.74-4.94-20.23-4.94-12 0-20.46 7.29-20.46 17.64 0 12.46 11.48 15.44 17.87 17.17 6.11 2 13.17 3.26 13.17 8.7 0 4-3.52 7.06-9.17 7.06a31.8 31.8 0 0 1-19-6.35 1 1 0 0 0-1.65.71l-2.35 7.52c-.47.94.23 1.18.23 1.41 1.72 1.4 10.33 6.59 22.79 6.59zM357.09 224c0-.71-.24-1.18-1.18-1.18h-11.76c0-.14.94-8.94 4.47-12.47 4.16-4.15 11.76-1.64 12-1.64 1.17.47 1.41 0 1.64-.47l2.83-7.77c.7-.94 0-1.17-.24-1.41-5.09-2-17.35-2.87-24.46 4.24-5.48 5.48-7 13.92-8 19.52h-8.47a1.28 1.28 0 0 0-1.17 1.18l-1.42 7.76c0 .7.24 1.17 1.18 1.17h8.23c-8.51 47.9-8.75 50.21-10.35 55.52-1.08 3.62-3.29 6.9-5.88 7.76-.09 0-3.88 1.68-9.64-.24 0 0-.94-.47-1.41.71-.24.71-2.59 6.82-2.83 7.53s0 1.41.47 1.41c5.11 2 13 1.77 17.88 0 6.28-2.28 9.72-7.89 11.53-12.94 2.75-7.71 2.81-9.79 11.76-59.74h12.23a1.29 1.29 0 0 0 1.18-1.18zm53.39 16c-.56-1.68-5.1-18.11-25.17-18.11-15.25 0-23 10-25.16 18.11-1 3-3.18 14 0 23.52.09.3 4.41 18.12 25.16 18.12 14.95 0 22.9-9.61 25.17-18.12 3.21-9.61 1.01-20.52 0-23.52zm45.4-16.7c-5-1.65-16.62-1.9-22.11 5.41v-4.47a1.11 1.11 0 0 0-1.18-1.17h-9.4a1.11 1.11 0 0 0-1.18 1.17v55.28a1.12 1.12 0 0 0 1.18 1.18h9.64a1.12 1.12 0 0 0 1.18-1.18v-27.77c0-2.91.05-11.37 4.46-15.05 4.9-4.9 12-3.36 13.41-3.06a1.57 1.57 0 0 0 1.41-.94 74 74 0 0 0 3.06-8 1.16 1.16 0 0 0-.47-1.41zm46.81 54.1l-2.12-7.29c-.47-1.18-1.41-.71-1.41-.71-4.23 1.82-10.15 1.89-11.29 1.89-4.64 0-17.17-1.13-17.17-19.76 0-6.23 1.85-19.76 16.47-19.76a34.85 34.85 0 0 1 11.52 1.65s.94.47 1.18-.71c.94-2.59 1.64-4.47 2.59-7.53.23-.94-.47-1.17-.71-1.17-11.59-3.87-22.34-2.53-27.76 0-1.59.74-16.23 6.49-16.23 27.52 0 2.9-.58 30.11 28.94 30.11a44.45 44.45 0 0 0 15.52-2.83 1.3 1.3 0 0 0 .47-1.42zm53.87-39.52c-.8-3-5.37-16.23-22.35-16.23-16 0-23.52 10.11-25.64 18.59a38.58 38.58 0 0 0-1.65 11.76c0 25.87 18.84 29.4 29.88 29.4 10.82 0 16.46-2.35 18.58-3.76.47-.24.71-.71.24-1.88l-2.36-6.83a1.26 1.26 0 0 0-1.41-.7c-2.59.94-6.35 2.82-15.29 2.82-17.42 0-16.85-14.74-16.93-16.7h37.16a1.25 1.25 0 0 0 1.18-.94c-.24-.01.94-7.07-1.41-15.54zm-23.29-6.35c-10.33 0-13 9-13.64 14.12H546c-.88-11.92-7.62-14.13-12.73-14.13z' class=''%3E%3C/path%3E%3C/svg%3E",
  smileWink:
    "data:image/svg+xml,%3Csvg aria-hidden='true' focusable='false' data-prefix='far' data-icon='smile-wink' role='img' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 496 512' class='svg-inline--fa fa-smile-wink fa-w-16 fa-5x'%3E%3Cpath fill='currentColor' d='M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 448c-110.3 0-200-89.7-200-200S137.7 56 248 56s200 89.7 200 200-89.7 200-200 200zm117.8-146.4c-10.2-8.5-25.3-7.1-33.8 3.1-20.8 25-51.5 39.4-84 39.4s-63.2-14.3-84-39.4c-8.5-10.2-23.7-11.5-33.8-3.1-10.2 8.5-11.5 23.6-3.1 33.8 30 36 74.1 56.6 120.9 56.6s90.9-20.6 120.9-56.6c8.5-10.2 7.1-25.3-3.1-33.8zM168 240c17.7 0 32-14.3 32-32s-14.3-32-32-32-32 14.3-32 32 14.3 32 32 32zm160-60c-25.7 0-55.9 16.9-59.9 42.1-1.7 11.2 11.5 18.2 19.8 10.8l9.5-8.5c14.8-13.2 46.2-13.2 61 0l9.5 8.5c8.5 7.4 21.6.3 19.8-10.8-3.8-25.2-34-42.1-59.7-42.1z' class=''%3E%3C/path%3E%3C/svg%3E",
  stackExchange:
    "data:image/svg+xml,%3Csvg aria-hidden='true' focusable='false' data-prefix='fab'" +
    " data-icon='stack-exchange' role='img' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 448 512' class='svg-inline--fa fa-stack-exchange fa-w-14 fa-3x'%3E%3Cpath fill='currentColor' d='M17.7 332.3h412.7v22c0 37.7-29.3 68-65.3 68h-19L259.3 512v-89.7H83c-36 0-65.3-30.3-65.3-68v-22zm0-23.6h412.7v-85H17.7v85zm0-109.4h412.7v-85H17.7v85zM365 0H83C47 0 17.7 30.3 17.7 67.7V90h412.7V67.7C430.3 30.3 401 0 365 0z' class=''%3E%3C/path%3E%3C/svg%3E",
  stackOverflow:
    "data:image/svg+xml,%3Csvg aria-hidden='true' focusable='false' data-prefix='fab' data-icon='stack-overflow' role='img' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 384 512' class='svg-inline--fa fa-stack-overflow fa-w-12 fa-3x'%3E%3Cpath fill='currentColor' d='M290.7 311L95 269.7 86.8 309l195.7 41zm51-87L188.2 95.7l-25.5 30.8 153.5 128.3zm-31.2 39.7L129.2 179l-16.7 36.5L293.7 300zM262 32l-32 24 119.3 160.3 32-24zm20.5 328h-200v39.7h200zm39.7 80H42.7V320h-40v160h359.5V320h-40z' class=''%3E%3C/path%3E%3C/svg%3E",
  twitter:
    "data:image/svg+xml,%3Csvg aria-hidden='true' focusable='false' data-prefix='fab' data-icon='twitter' role='img' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512' class='svg-inline--fa fa-twitter fa-w-16 fa-3x'%3E%3Cpath fill='currentColor' d='M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z'%3E%3C/path%3E%3C/svg%3E",
};
