/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.crypto.cms.springboot;

import javax.annotation.Generated;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * The crypto cms component is used for encrypting data in CMS Enveloped Data
 * format, decrypting CMS Enveloped Data, signing data in CMS Signed Data
 * format, and verifying CMS Signed Data.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.SpringBootAutoConfigurationMojo")
@ConfigurationProperties(prefix = "camel.component.crypto-cms")
public class CryptoCmsComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the crypto-cms component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * To configure the shared SignedDataVerifierConfiguration, which determines
     * the uri parameters for the verify operation. The option is a
     * org.apache.camel.component.crypto.cms.sig.SignedDataVerifierConfiguration
     * type.
     */
    private String signedDataVerifierConfiguration;
    /**
     * To configure the shared EnvelopedDataDecryptorConfiguration, which
     * determines the uri parameters for the decrypt operation. The option is a
     * org.apache.camel.component.crypto.cms.crypt.
     * EnvelopedDataDecryptorConfiguration type.
     */
    private String envelopedDataDecryptorConfiguration;
    /**
     * Whether the component should resolve property placeholders on itself when
     * starting. Only properties which are of String type can use property
     * placeholders.
     */
    private Boolean resolvePropertyPlaceholders = true;

    public String getSignedDataVerifierConfiguration() {
        return signedDataVerifierConfiguration;
    }

    public void setSignedDataVerifierConfiguration(
            String signedDataVerifierConfiguration) {
        this.signedDataVerifierConfiguration = signedDataVerifierConfiguration;
    }

    public String getEnvelopedDataDecryptorConfiguration() {
        return envelopedDataDecryptorConfiguration;
    }

    public void setEnvelopedDataDecryptorConfiguration(
            String envelopedDataDecryptorConfiguration) {
        this.envelopedDataDecryptorConfiguration = envelopedDataDecryptorConfiguration;
    }

    public Boolean getResolvePropertyPlaceholders() {
        return resolvePropertyPlaceholders;
    }

    public void setResolvePropertyPlaceholders(
            Boolean resolvePropertyPlaceholders) {
        this.resolvePropertyPlaceholders = resolvePropertyPlaceholders;
    }
}