/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws.ddb.DdbComponent;

/**
 * The aws-ddb component is used for storing and retrieving data from Amazon's
 * DynamoDB service.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface AwsDdbComponentBuilderFactory {

    /**
     * AWS DynamoDB (camel-aws-ddb)
     * The aws-ddb component is used for storing and retrieving data from
     * Amazon's DynamoDB service.
     * 
     * Category: cloud,database,nosql
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-aws-ddb
     */
    static AwsDdbComponentBuilder awsDdb() {
        return new AwsDdbComponentBuilderImpl();
    }

    /**
     * Builder for the AWS DynamoDB component.
     */
    interface AwsDdbComponentBuilder extends ComponentBuilder<DdbComponent> {
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default AwsDdbComponentBuilder accessKey(java.lang.String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default AwsDdbComponentBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The region in which DDB client needs to work.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default AwsDdbComponentBuilder region(java.lang.String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default AwsDdbComponentBuilder secretKey(java.lang.String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * Whether the component should use basic property binding (Camel 2.x)
         * or the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AwsDdbComponentBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * The AWS DDB default configuration.
         * 
         * The option is a:
         * <code>org.apache.camel.component.aws.ddb.DdbConfiguration</code>
         * type.
         * 
         * Group: advanced
         */
        default AwsDdbComponentBuilder configuration(
                org.apache.camel.component.aws.ddb.DdbConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    }

    class AwsDdbComponentBuilderImpl
            extends
                AbstractComponentBuilder<DdbComponent>
            implements
                AwsDdbComponentBuilder {
        @Override
        protected DdbComponent buildConcreteComponent() {
            return new DdbComponent();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "accessKey": ((DdbComponent) component).setAccessKey((java.lang.String) value); return true;
            case "lazyStartProducer": ((DdbComponent) component).setLazyStartProducer((boolean) value); return true;
            case "region": ((DdbComponent) component).setRegion((java.lang.String) value); return true;
            case "secretKey": ((DdbComponent) component).setSecretKey((java.lang.String) value); return true;
            case "basicPropertyBinding": ((DdbComponent) component).setBasicPropertyBinding((boolean) value); return true;
            case "configuration": ((DdbComponent) component).setConfiguration((org.apache.camel.component.aws.ddb.DdbConfiguration) value); return true;
            default: return false;
            }
        }
    }
}