/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.netty.http.NettyHttpComponent;

/**
 * Netty HTTP server and client using the Netty 4.x library.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface NettyHttpComponentBuilderFactory {

    /**
     * Netty HTTP (camel-netty-http)
     * Netty HTTP server and client using the Netty 4.x library.
     * 
     * Category: http
     * Since: 2.14
     * Maven coordinates: org.apache.camel:camel-netty-http
     */
    static NettyHttpComponentBuilder nettyHttp() {
        return new NettyHttpComponentBuilderImpl();
    }

    /**
     * Builder for the Netty HTTP component.
     */
    interface NettyHttpComponentBuilder
            extends
                ComponentBuilder<NettyHttpComponent> {
        /**
         * To use the NettyConfiguration as configuration when creating
         * endpoints.
         * 
         * The option is a:
         * <code>org.apache.camel.component.netty.http.NettyHttpConfiguration</code> type.
         * 
         * Group: common
         */
        default NettyHttpComponentBuilder configuration(
                org.apache.camel.component.netty.http.NettyHttpConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default NettyHttpComponentBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To use the given EventExecutorGroup.
         * 
         * The option is a:
         * <code>io.netty.util.concurrent.EventExecutorGroup</code> type.
         * 
         * Group: consumer (advanced)
         */
        default NettyHttpComponentBuilder executorService(
                io.netty.util.concurrent.EventExecutorGroup executorService) {
            doSetProperty("executorService", executorService);
            return this;
        }
        /**
         * Sets a maximum thread pool size for the netty consumer ordered thread
         * pool. The default size is 2 x cpu_core plus 1. Setting this value to
         * eg 10 will then use 10 threads unless 2 x cpu_core plus 1 is a higher
         * value, which then will override and be used. For example if there are
         * 8 cores, then the consumer thread pool will be 17. This thread pool
         * is used to route messages received from Netty by Camel. We use a
         * separate thread pool to ensure ordering of messages and also in case
         * some messages will block, then nettys worker threads (event loop)
         * wont be affected.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer (advanced)
         */
        default NettyHttpComponentBuilder maximumPoolSize(int maximumPoolSize) {
            doSetProperty("maximumPoolSize", maximumPoolSize);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default NettyHttpComponentBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the component should use basic property binding (Camel 2.x)
         * or the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default NettyHttpComponentBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter
         * headers.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default NettyHttpComponentBuilder headerFilterStrategy(
                org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom
         * org.apache.camel.component.netty.http.NettyHttpBinding for binding
         * to/from Netty and Camel Message API.
         * 
         * The option is a:
         * <code>org.apache.camel.component.netty.http.NettyHttpBinding</code>
         * type.
         * 
         * Group: advanced
         */
        default NettyHttpComponentBuilder nettyHttpBinding(
                org.apache.camel.component.netty.http.NettyHttpBinding nettyHttpBinding) {
            doSetProperty("nettyHttpBinding", nettyHttpBinding);
            return this;
        }
        /**
         * Refers to a
         * org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration
         * for configuring secure web resources.
         * 
         * The option is a:
         * <code>org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration</code> type.
         * 
         * Group: security
         */
        default NettyHttpComponentBuilder securityConfiguration(
                org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration securityConfiguration) {
            doSetProperty("securityConfiguration", securityConfiguration);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default NettyHttpComponentBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Enable usage of global SSL context parameters.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default NettyHttpComponentBuilder useGlobalSslContextParameters(
                boolean useGlobalSslContextParameters) {
            doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }
    }

    class NettyHttpComponentBuilderImpl
            extends
                AbstractComponentBuilder<NettyHttpComponent>
            implements
                NettyHttpComponentBuilder {
        @Override
        protected NettyHttpComponent buildConcreteComponent() {
            return new NettyHttpComponent();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "configuration": ((NettyHttpComponent) component).setConfiguration((org.apache.camel.component.netty.http.NettyHttpConfiguration) value); return true;
            case "bridgeErrorHandler": ((NettyHttpComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "executorService": ((NettyHttpComponent) component).setExecutorService((io.netty.util.concurrent.EventExecutorGroup) value); return true;
            case "maximumPoolSize": ((NettyHttpComponent) component).setMaximumPoolSize((int) value); return true;
            case "lazyStartProducer": ((NettyHttpComponent) component).setLazyStartProducer((boolean) value); return true;
            case "basicPropertyBinding": ((NettyHttpComponent) component).setBasicPropertyBinding((boolean) value); return true;
            case "headerFilterStrategy": ((NettyHttpComponent) component).setHeaderFilterStrategy((org.apache.camel.spi.HeaderFilterStrategy) value); return true;
            case "nettyHttpBinding": ((NettyHttpComponent) component).setNettyHttpBinding((org.apache.camel.component.netty.http.NettyHttpBinding) value); return true;
            case "securityConfiguration": ((NettyHttpComponent) component).setSecurityConfiguration((org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration) value); return true;
            case "sslContextParameters": ((NettyHttpComponent) component).setSslContextParameters((org.apache.camel.support.jsse.SSLContextParameters) value); return true;
            case "useGlobalSslContextParameters": ((NettyHttpComponent) component).setUseGlobalSslContextParameters((boolean) value); return true;
            default: return false;
            }
        }
    }
}