# Changelog

## [Unreleased](https://github.com/apache/camel-k/tree/HEAD)

[Full Changelog](https://github.com/apache/camel-k/compare/1.12.2-nightly...HEAD)

**Closed issues:**

- `kamel run` dry run may panic when no cluster [\#4566](https://github.com/apache/camel-k/issues/4566)
- `kamel run` in output mode still requires connecting to a k8s cluster [\#4556](https://github.com/apache/camel-k/issues/4556)
- Coverage reports does not report correct coverage [\#4555](https://github.com/apache/camel-k/issues/4555)
- Dry run tries to use empty namespace [\#4543](https://github.com/apache/camel-k/issues/4543)
- Camel K API doc has dead links to k8s ObjectMeta [\#4540](https://github.com/apache/camel-k/issues/4540)
- Add `description` to KameletBinding and Integration [\#4535](https://github.com/apache/camel-k/issues/4535)
- TestHealthTrait flakiness [\#4532](https://github.com/apache/camel-k/issues/4532)
- Nightly release Windows CLI failing [\#4531](https://github.com/apache/camel-k/issues/4531)
- Nightly release CLI binary \(Linux\) not working [\#4526](https://github.com/apache/camel-k/issues/4526)
- Builder image name missing the organization configuration [\#4525](https://github.com/apache/camel-k/issues/4525)
- Unable to run the code by adding Jar files as depedency [\#4524](https://github.com/apache/camel-k/issues/4524)
- Make command fails on MacOS due to TestGenerateKeystore [\#4516](https://github.com/apache/camel-k/issues/4516)
- Allow to remote debug the Operator [\#4513](https://github.com/apache/camel-k/issues/4513)
- Updating a property will cause Integration to rebuild [\#4511](https://github.com/apache/camel-k/issues/4511)
- CamelCatalog generated twice [\#4504](https://github.com/apache/camel-k/issues/4504)
- Question: use camel dependency version 3.20.3 or higher [\#4502](https://github.com/apache/camel-k/issues/4502)
- Problems reading boolean values for traits using comments [\#4493](https://github.com/apache/camel-k/issues/4493)
- Alter namespace where the Push of Operator sends the image generated [\#4492](https://github.com/apache/camel-k/issues/4492)
- Empty build strategy [\#4485](https://github.com/apache/camel-k/issues/4485)
- pod-template with knative in rest integration [\#4484](https://github.com/apache/camel-k/issues/4484)
- Can't install Camel-K 2.0 nightly on OpenShift cluster [\#4476](https://github.com/apache/camel-k/issues/4476)
- Missing license header [\#4469](https://github.com/apache/camel-k/issues/4469)
- Rework CLIs required by operator build process [\#4466](https://github.com/apache/camel-k/issues/4466)
- Use maven distribution available in the operator image [\#4429](https://github.com/apache/camel-k/issues/4429)
- kamel run | custom dependencies | local files | K8S Cluster with GHCR    [\#4398](https://github.com/apache/camel-k/issues/4398)
- Integration builder can't pull the builder image from the insecure registry [\#4236](https://github.com/apache/camel-k/issues/4236)
- Horizontal scaling ability for operators [\#4173](https://github.com/apache/camel-k/issues/4173)
- Observability documentation - Update to micrometer extension [\#4157](https://github.com/apache/camel-k/issues/4157)
- Multi architecture support - Operator and builder pods [\#4148](https://github.com/apache/camel-k/issues/4148)
- how to add custom component in camel-k [\#4145](https://github.com/apache/camel-k/issues/4145)
- how to set body of OUT message in yaml DSL? [\#4144](https://github.com/apache/camel-k/issues/4144)
- Add message during Operator Installation that checks that Internal Image Registry is configured [\#4130](https://github.com/apache/camel-k/issues/4130)
- Helm Node Selector [\#4096](https://github.com/apache/camel-k/issues/4096)
- Update the version of the kind-action [\#4063](https://github.com/apache/camel-k/issues/4063)
- camel k bypassing maven settings.xml when using proxy [\#3991](https://github.com/apache/camel-k/issues/3991)
- Onboard Camel K Tekton tasks [\#3795](https://github.com/apache/camel-k/issues/3795)
- Deprecated Github actions / warnings [\#3766](https://github.com/apache/camel-k/issues/3766)
- Document supported components [\#2228](https://github.com/apache/camel-k/issues/2228)
- Runtime reload configmap/secret when they change [\#2106](https://github.com/apache/camel-k/issues/2106)
- Build order strategy [\#592](https://github.com/apache/camel-k/issues/592)
- introduce code coverage report for each pr [\#559](https://github.com/apache/camel-k/issues/559)

## [1.12.2-nightly](https://github.com/apache/camel-k/tree/1.12.2-nightly) (2023-06-13)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.12.1...1.12.2-nightly)

**Closed issues:**

- Issue while working on multiple endpoint in camel-k. [\#4475](https://github.com/apache/camel-k/issues/4475)
- Kamel promote export without annotations [\#4471](https://github.com/apache/camel-k/issues/4471)
- Issue with connecting to microsoft sql server from camel-k [\#4465](https://github.com/apache/camel-k/issues/4465)
- Release 1.12.1 [\#4396](https://github.com/apache/camel-k/issues/4396)

**Merged pull requests:**

- chore\(ci\): bump replace version [\#4478](https://github.com/apache/camel-k/pull/4478) ([squakez](https://github.com/squakez))
- chore\(ci\): Helm 1.12.1 [\#4474](https://github.com/apache/camel-k/pull/4474) ([squakez](https://github.com/squakez))
- fix\(cmd\): promote annotations/labels [\#4473](https://github.com/apache/camel-k/pull/4473) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/container-tools/spectrum from 0.6.19 to 0.6.20 [\#4472](https://github.com/apache/camel-k/pull/4472) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/onsi/gomega from 1.27.7 to 1.27.8 [\#4470](https://github.com/apache/camel-k/pull/4470) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(ci\): split image build from deploy [\#4467](https://github.com/apache/camel-k/pull/4467) ([squakez](https://github.com/squakez))
- chore\(deps\): bump knative.dev/serving from 0.37.1 to 0.37.2 [\#4464](https://github.com/apache/camel-k/pull/4464) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(e2e\): TestLocalPlatform [\#4463](https://github.com/apache/camel-k/pull/4463) ([squakez](https://github.com/squakez))
- chore\(deps\): home made Set to replace github.com/scylladb/go-set [\#4462](https://github.com/apache/camel-k/pull/4462) ([squakez](https://github.com/squakez))
- fix\(ci\): bring back CLIs required by ci tasks [\#4461](https://github.com/apache/camel-k/pull/4461) ([squakez](https://github.com/squakez))
- chore\(ci\): define IMAGE\_ARCH parameter [\#4457](https://github.com/apache/camel-k/pull/4457) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/sirupsen/logrus from 1.9.2 to 1.9.3 [\#4455](https://github.com/apache/camel-k/pull/4455) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(e2e\): split upgrade from install [\#4454](https://github.com/apache/camel-k/pull/4454) ([squakez](https://github.com/squakez))
- chore\(deps\): revert vfs-gen removal [\#4450](https://github.com/apache/camel-k/pull/4450) ([gansheer](https://github.com/gansheer))
- fix\(ci\): temporarily repair upgrade checks [\#4449](https://github.com/apache/camel-k/pull/4449) ([squakez](https://github.com/squakez))
- chore\(deps\): replace github.com/radovskyb/watcher with github.com/fsn… [\#4448](https://github.com/apache/camel-k/pull/4448) ([squakez](https://github.com/squakez))
- chore\(ci\): use ubuntu-latest [\#4445](https://github.com/apache/camel-k/pull/4445) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/cloudflare/circl from 1.1.0 to 1.3.3 [\#4442](https://github.com/apache/camel-k/pull/4442) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/cloudflare/circl from 1.1.0 to 1.3.3 in /pkg/kamelet/repository [\#4441](https://github.com/apache/camel-k/pull/4441) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/container-tools/spectrum from 0.6.18 to 0.6.19 [\#4439](https://github.com/apache/camel-k/pull/4439) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/google/go-containerregistry from 0.13.0 to 0.15.2 [\#4438](https://github.com/apache/camel-k/pull/4438) ([dependabot[bot]](https://github.com/apps/dependabot))
- \[Github Actions\] Periodic Sync Camel K SBOM [\#4436](https://github.com/apache/camel-k/pull/4436) ([github-actions[bot]](https://github.com/apps/github-actions))
- chore\(deps\): update github.com/google/go-github/v52 [\#4435](https://github.com/apache/camel-k/pull/4435) ([squakez](https://github.com/squakez))
- chore\(deps\): bump knative.dev/eventing from 0.37.0 to 0.37.1 [\#4434](https://github.com/apache/camel-k/pull/4434) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/spf13/viper from 1.15.0 to 1.16.0 [\#4433](https://github.com/apache/camel-k/pull/4433) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/stretchr/testify from 1.8.3 to 1.8.4 [\#4432](https://github.com/apache/camel-k/pull/4432) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): remove deps and unused CLIs [\#4428](https://github.com/apache/camel-k/pull/4428) ([squakez](https://github.com/squakez))
- chore\(deps\): remove old replacements [\#4427](https://github.com/apache/camel-k/pull/4427) ([squakez](https://github.com/squakez))
- Removed coverage badge 3rd party dependency [\#4423](https://github.com/apache/camel-k/pull/4423) ([realMartinez](https://github.com/realMartinez))
- chore\(deps\): bump github.com/container-tools/spectrum from 0.6.17 to 0.6.18 [\#4422](https://github.com/apache/camel-k/pull/4422) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(ci\): release doc polishing [\#4421](https://github.com/apache/camel-k/pull/4421) ([squakez](https://github.com/squakez))
- chore: more archived deps removals [\#4419](https://github.com/apache/camel-k/pull/4419) ([squakez](https://github.com/squakez))
- Fix some OLM tests recently broken [\#4418](https://github.com/apache/camel-k/pull/4418) ([gansheer](https://github.com/gansheer))
- feat\(core\): Support S2I for builder image generation [\#4417](https://github.com/apache/camel-k/pull/4417) ([gansheer](https://github.com/gansheer))
- feat\(ci\): publish arm64 architecture [\#4416](https://github.com/apache/camel-k/pull/4416) ([squakez](https://github.com/squakez))
- fix\(trait\): minor lint [\#4415](https://github.com/apache/camel-k/pull/4415) ([squakez](https://github.com/squakez))
- chore: remove useless code [\#4412](https://github.com/apache/camel-k/pull/4412) ([squakez](https://github.com/squakez))
- chore: Improve Camel dependency validation [\#4411](https://github.com/apache/camel-k/pull/4411) ([christophd](https://github.com/christophd))
- Revert "chore\(ci\): remove autogen resource file" [\#4409](https://github.com/apache/camel-k/pull/4409) ([squakez](https://github.com/squakez))
- feat\(core\): Change Operator and Builder Pod user as non root 1000 [\#4407](https://github.com/apache/camel-k/pull/4407) ([gansheer](https://github.com/gansheer))
- chore\(ci\): remove autogen resource file [\#4405](https://github.com/apache/camel-k/pull/4405) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/prometheus/common from 0.43.0 to 0.44.0 [\#4404](https://github.com/apache/camel-k/pull/4404) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/container-tools/spectrum from 0.6.16 to 0.6.17 [\#4403](https://github.com/apache/camel-k/pull/4403) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): remove gopkg.in/inf.v0 [\#4401](https://github.com/apache/camel-k/pull/4401) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/container-tools/spectrum from 0.6.12 to 0.6.16 [\#4400](https://github.com/apache/camel-k/pull/4400) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump k8s.io/klog/v2 from 2.80.2-0.20221028030830-9ae4992afb54 to 2.100.1 [\#4399](https://github.com/apache/camel-k/pull/4399) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): remove go-homedir dependency [\#4397](https://github.com/apache/camel-k/pull/4397) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/mattn/go-shellwords from 1.0.3 to 1.0.12 [\#4394](https://github.com/apache/camel-k/pull/4394) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/onsi/gomega from 1.27.6 to 1.27.7 [\#4393](https://github.com/apache/camel-k/pull/4393) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/stretchr/testify from 1.8.2 to 1.8.3 [\#4392](https://github.com/apache/camel-k/pull/4392) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/sirupsen/logrus from 1.9.0 to 1.9.2 [\#4390](https://github.com/apache/camel-k/pull/4390) ([dependabot[bot]](https://github.com/apps/dependabot))
- Remove unused ocp3 option from CI cluster config [\#4386](https://github.com/apache/camel-k/pull/4386) ([claudio4j](https://github.com/claudio4j))
- feat: enable generic Pipeline [\#4384](https://github.com/apache/camel-k/pull/4384) ([squakez](https://github.com/squakez))
- Improve error logging with external KAMEL\_BIN [\#4383](https://github.com/apache/camel-k/pull/4383) ([bouskaJ](https://github.com/bouskaJ))
- chore\(deps\): bump github.com/otiai10/copy from 1.9.0 to 1.11.0 [\#4382](https://github.com/apache/camel-k/pull/4382) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/evanphx/json-patch from 4.12.0+incompatible to 5.6.0+incompatible [\#4381](https://github.com/apache/camel-k/pull/4381) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump go.uber.org/automaxprocs from 1.5.1 to 1.5.2 [\#4380](https://github.com/apache/camel-k/pull/4380) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): golang.org/x/net upgrade [\#4378](https://github.com/apache/camel-k/pull/4378) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/opencontainers/runc from 1.0.2 to 1.1.5 [\#4377](https://github.com/apache/camel-k/pull/4377) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump knative.dev/eventing from 0.35.3 to 0.37.0 [\#4375](https://github.com/apache/camel-k/pull/4375) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/container-tools/spectrum from 0.6.11 to 0.6.12 [\#4374](https://github.com/apache/camel-k/pull/4374) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump knative.dev/serving from 0.35.3 to 0.37.1 [\#4372](https://github.com/apache/camel-k/pull/4372) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump golang.org/x/time from 0.1.0 to 0.3.0 [\#4371](https://github.com/apache/camel-k/pull/4371) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix: Restrict Knative service trait to Http exposed and passive endpoints [\#4368](https://github.com/apache/camel-k/pull/4368) ([christophd](https://github.com/christophd))
- chore\(deps\): ignore only k8s dependencies [\#4367](https://github.com/apache/camel-k/pull/4367) ([squakez](https://github.com/squakez))
- chore\(deps\): remove camelcase dependency [\#4366](https://github.com/apache/camel-k/pull/4366) ([squakez](https://github.com/squakez))
- fix\(cmd\): promote should load catalog from k8s [\#4362](https://github.com/apache/camel-k/pull/4362) ([squakez](https://github.com/squakez))
- chore: ignore resources.go [\#4357](https://github.com/apache/camel-k/pull/4357) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/container-tools/spectrum from 0.6.10 to 0.6.11 [\#4356](https://github.com/apache/camel-k/pull/4356) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump golang.org/x/oauth2 from 0.7.0 to 0.8.0 [\#4355](https://github.com/apache/camel-k/pull/4355) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(\#4336\): Restrict Knative binding provider execution for v1alpha1 [\#4353](https://github.com/apache/camel-k/pull/4353) ([christophd](https://github.com/christophd))
- fix\(e2e\): high memory native test [\#4349](https://github.com/apache/camel-k/pull/4349) ([squakez](https://github.com/squakez))
- fix: Add proper app label on default integration platform [\#4348](https://github.com/apache/camel-k/pull/4348) ([christophd](https://github.com/christophd))
- chore\(dep\): Remove archived github.com/pkg/errors dependency [\#4346](https://github.com/apache/camel-k/pull/4346) ([gansheer](https://github.com/gansheer))
- fix\(\#4336\): Restrict Knative binding provider execution [\#4344](https://github.com/apache/camel-k/pull/4344) ([christophd](https://github.com/christophd))
- chore\(doc\): Java api support [\#4339](https://github.com/apache/camel-k/pull/4339) ([squakez](https://github.com/squakez))
- fix\(e2e\): increase commonwithcustominstall timeout [\#4338](https://github.com/apache/camel-k/pull/4338) ([squakez](https://github.com/squakez))
- chore: Restrict nightly coverage workflow execution [\#4335](https://github.com/apache/camel-k/pull/4335) ([christophd](https://github.com/christophd))
- fix: Always uninstall IntegrationPlatform resources [\#4334](https://github.com/apache/camel-k/pull/4334) ([christophd](https://github.com/christophd))
- chore\(deps\): bump github.com/prometheus/common from 0.42.0 to 0.43.0 [\#4331](https://github.com/apache/camel-k/pull/4331) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(e2e\): Improve max build limit E2E test [\#4330](https://github.com/apache/camel-k/pull/4330) ([christophd](https://github.com/christophd))
- fix\(ci\): native test path [\#4329](https://github.com/apache/camel-k/pull/4329) ([squakez](https://github.com/squakez))
- feat\(cli\): provide useful info in kubectl CLI [\#4325](https://github.com/apache/camel-k/pull/4325) ([squakez](https://github.com/squakez))
- feat\(trait\): custom builder resources [\#4322](https://github.com/apache/camel-k/pull/4322) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/prometheus/client\_model from 0.3.0 to 0.4.0 [\#4321](https://github.com/apache/camel-k/pull/4321) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/prometheus/client\_golang from 1.15.0 to 1.15.1 [\#4320](https://github.com/apache/camel-k/pull/4320) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(e2e\): Improve builder E2E tests [\#4319](https://github.com/apache/camel-k/pull/4319) ([christophd](https://github.com/christophd))
- feat: remove deprecated code [\#4318](https://github.com/apache/camel-k/pull/4318) ([squakez](https://github.com/squakez))
- fix: Consistent integration platform settings hierarchy [\#4317](https://github.com/apache/camel-k/pull/4317) ([christophd](https://github.com/christophd))
- fix\(e2e\): Improve max build limit E2E test [\#4314](https://github.com/apache/camel-k/pull/4314) ([christophd](https://github.com/christophd))
- chore: make codegen [\#4313](https://github.com/apache/camel-k/pull/4313) ([squakez](https://github.com/squakez))
- doc: new release process [\#4311](https://github.com/apache/camel-k/pull/4311) ([squakez](https://github.com/squakez))
- Add often used cli commands [\#4310](https://github.com/apache/camel-k/pull/4310) ([lfabriko](https://github.com/lfabriko))
- chore\(e2e\) Upgrade test operators [\#4309](https://github.com/apache/camel-k/pull/4309) ([gansheer](https://github.com/gansheer))
- feat\(trait\): Add startup probes into health trait [\#4305](https://github.com/apache/camel-k/pull/4305) ([mertdotcc](https://github.com/mertdotcc))
- fix\(e2e\): Stabilize YAKS E2E tests [\#4303](https://github.com/apache/camel-k/pull/4303) ([christophd](https://github.com/christophd))
- fix\(operator\): do not panic if cannot set GOMAXPROCS [\#4300](https://github.com/apache/camel-k/pull/4300) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/container-tools/spectrum from 0.6.9 to 0.6.10 [\#4298](https://github.com/apache/camel-k/pull/4298) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix: align process to latest ck runtime changes [\#4292](https://github.com/apache/camel-k/pull/4292) ([squakez](https://github.com/squakez))
- fix: Add max running builds CLI option [\#4291](https://github.com/apache/camel-k/pull/4291) ([christophd](https://github.com/christophd))
- chore\(doc\): Fix documentation for camel-website generation [\#4289](https://github.com/apache/camel-k/pull/4289) ([gansheer](https://github.com/gansheer))
- Allow to configure test namespace and operatorID [\#4286](https://github.com/apache/camel-k/pull/4286) ([bouskaJ](https://github.com/bouskaJ))
- fix\(cmd\): uninstall to wait the operator pod [\#4280](https://github.com/apache/camel-k/pull/4280) ([squakez](https://github.com/squakez))
- chore: Support platform selection on IntegrationKit [\#4278](https://github.com/apache/camel-k/pull/4278) ([christophd](https://github.com/christophd))
- chore\(doc\): Update Monitoring documentation for micrometer [\#4273](https://github.com/apache/camel-k/pull/4273) ([gansheer](https://github.com/gansheer))
- chore\(deps\): bump github.com/container-tools/spectrum from 0.6.8 to 0.6.9 [\#4269](https://github.com/apache/camel-k/pull/4269) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(\#3705\) Fix misleading message when updating unchanged integration [\#4268](https://github.com/apache/camel-k/pull/4268) ([bouskaJ](https://github.com/bouskaJ))
- fix\(\#4061\) Remove deprecated linters [\#4267](https://github.com/apache/camel-k/pull/4267) ([bouskaJ](https://github.com/bouskaJ))
- fabric8 extension docs [\#4265](https://github.com/apache/camel-k/pull/4265) ([andreaTP](https://github.com/andreaTP))
- Fix Website build [\#4261](https://github.com/apache/camel-k/pull/4261) ([oscerd](https://github.com/oscerd))
- Feat/coverage badge [\#4260](https://github.com/apache/camel-k/pull/4260) ([realMartinez](https://github.com/realMartinez))
- chore\(deps\): bump github.com/prometheus/client\_golang from 1.14.0 to 1.15.0 [\#4259](https://github.com/apache/camel-k/pull/4259) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/rs/xid from 1.4.0 to 1.5.0 [\#4258](https://github.com/apache/camel-k/pull/4258) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(cmd\): don't warn if rolebinding exists [\#4255](https://github.com/apache/camel-k/pull/4255) ([squakez](https://github.com/squakez))
- chore\(doc\): add upgrade instructions [\#4254](https://github.com/apache/camel-k/pull/4254) ([squakez](https://github.com/squakez))
- chore\(e2e\): support remote testing [\#4253](https://github.com/apache/camel-k/pull/4253) ([squakez](https://github.com/squakez))
- chore: changed comments for jvm/keystore\_test [\#4252](https://github.com/apache/camel-k/pull/4252) ([realMartinez](https://github.com/realMartinez))
- fix\(cmd\): uninstall kube-public rolebindings [\#4251](https://github.com/apache/camel-k/pull/4251) ([squakez](https://github.com/squakez))
- fix\(ctrl\): use builtin command kill [\#4250](https://github.com/apache/camel-k/pull/4250) ([squakez](https://github.com/squakez))
- fix: won't panic on error handler validation failure [\#4247](https://github.com/apache/camel-k/pull/4247) ([squakez](https://github.com/squakez))
- chore \(docs\): add a note about security requirements on macOS [\#4242](https://github.com/apache/camel-k/pull/4242) ([orpiske](https://github.com/orpiske))
- fix\(controller\): camelcatalog default timeout [\#4239](https://github.com/apache/camel-k/pull/4239) ([squakez](https://github.com/squakez))
- chore\(deps\): bump golang.org/x/oauth2 from 0.6.0 to 0.7.0 [\#4238](https://github.com/apache/camel-k/pull/4238) ([dependabot[bot]](https://github.com/apps/dependabot))
- Improve error reporting in case of knative is required but not installed [\#4237](https://github.com/apache/camel-k/pull/4237) ([claudio4j](https://github.com/claudio4j))
- fix\(\#3836\) Expose runtime details in kamel version -a -v [\#4235](https://github.com/apache/camel-k/pull/4235) ([bouskaJ](https://github.com/bouskaJ))
- chore\(deps\): bump github.com/container-tools/spectrum from 0.6.5 to 0.6.8 [\#4234](https://github.com/apache/camel-k/pull/4234) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix: Limit parallel builds on operator [\#4233](https://github.com/apache/camel-k/pull/4233) ([christophd](https://github.com/christophd))
- fix\(\#3476\) Add tests for enabling traits at IntegrationPlatform [\#4232](https://github.com/apache/camel-k/pull/4232) ([bouskaJ](https://github.com/bouskaJ))
- chore\(deps\): bump github.com/spf13/cobra from 1.6.1 to 1.7.0 [\#4231](https://github.com/apache/camel-k/pull/4231) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(core\): Fix copy local dependencies error message [\#4230](https://github.com/apache/camel-k/pull/4230) ([gansheer](https://github.com/gansheer))
- chore: keystore\_test file path change [\#4228](https://github.com/apache/camel-k/pull/4228) ([realMartinez](https://github.com/realMartinez))
- chore\(olm\): upgrade operator sdk [\#4223](https://github.com/apache/camel-k/pull/4223) ([squakez](https://github.com/squakez))
- chore: revert kamel rebuild changes [\#4222](https://github.com/apache/camel-k/pull/4222) ([squakez](https://github.com/squakez))
- fix\(lint\): rebuild test [\#4216](https://github.com/apache/camel-k/pull/4216) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/container-tools/spectrum from 0.6.4 to 0.6.5 [\#4213](https://github.com/apache/camel-k/pull/4213) ([dependabot[bot]](https://github.com/apps/dependabot))
- feat\(trait\): Migrate prometheus trait from microprofile metrics to micrometer [\#4211](https://github.com/apache/camel-k/pull/4211) ([gansheer](https://github.com/gansheer))
- fix\(cmd\): rebuild KameletBindings [\#4209](https://github.com/apache/camel-k/pull/4209) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/onsi/gomega from 1.27.5 to 1.27.6 [\#4206](https://github.com/apache/camel-k/pull/4206) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(cmd\): run does not expand camel properties [\#4199](https://github.com/apache/camel-k/pull/4199) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/container-tools/spectrum from 0.6.2 to 0.6.4 [\#4194](https://github.com/apache/camel-k/pull/4194) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/go-logr/logr from 1.2.3 to 1.2.4 [\#4193](https://github.com/apache/camel-k/pull/4193) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix lint warn in deployment.go [\#4189](https://github.com/apache/camel-k/pull/4189) ([claudio4j](https://github.com/claudio4j))
- Remove additional custom labels utility [\#4184](https://github.com/apache/camel-k/pull/4184) ([claudio4j](https://github.com/claudio4j))
- chore\(deps\): bump github.com/redhat-developer/service-binding-operator from 1.3.3 to 1.3.4 [\#4170](https://github.com/apache/camel-k/pull/4170) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/stoewer/go-strcase from 1.2.1 to 1.3.0 [\#4169](https://github.com/apache/camel-k/pull/4169) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix \#4167 : Default integrationPlatform created at operator startup dose not honor OPERATOR\_ID config [\#4168](https://github.com/apache/camel-k/pull/4168) ([valdar](https://github.com/valdar))
- minor improvements in integration.adoc [\#4165](https://github.com/apache/camel-k/pull/4165) ([mertdotcc](https://github.com/mertdotcc))
- Ref \#4150: Add the installation guide for Docker Desktop [\#4164](https://github.com/apache/camel-k/pull/4164) ([essobedo](https://github.com/essobedo))
- fix\(cli\): Remove CamelCatalogs CR on kamel uninstall [\#4162](https://github.com/apache/camel-k/pull/4162) ([gansheer](https://github.com/gansheer))
- chore\(deps\): bump github.com/onsi/gomega from 1.27.4 to 1.27.5 [\#4159](https://github.com/apache/camel-k/pull/4159) ([dependabot[bot]](https://github.com/apps/dependabot))
- feat: change KameletBinding name to Pipe [\#4156](https://github.com/apache/camel-k/pull/4156) ([squakez](https://github.com/squakez))
- rm unused parameter [\#4155](https://github.com/apache/camel-k/pull/4155) ([tsukasaI](https://github.com/tsukasaI))
- Chore: docker, jvm unit tests [\#4154](https://github.com/apache/camel-k/pull/4154) ([realMartinez](https://github.com/realMartinez))
- fix\(builder\): native from source should rebuild  [\#4153](https://github.com/apache/camel-k/pull/4153) ([squakez](https://github.com/squakez))

## [pkg/apis/camel/v1.12.1](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.12.1) (2023-06-07)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.12.1...pkg/apis/camel/v1.12.1)

## [v1.12.1](https://github.com/apache/camel-k/tree/v1.12.1) (2023-06-07)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.12.1...v1.12.1)

## [pkg/kamelet/repository/v1.12.1](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.12.1) (2023-06-07)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.12.1...pkg/kamelet/repository/v1.12.1)

## [pkg/client/camel/v1.12.1](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.12.1) (2023-06-07)

[Full Changelog](https://github.com/apache/camel-k/compare/camel-k-crds-1.12.1...pkg/client/camel/v1.12.1)

**Closed issues:**

- Nightly release get wrong tag when staging [\#4468](https://github.com/apache/camel-k/issues/4468)
- \[Regression\] likely all cmd/utils were required by CI [\#4460](https://github.com/apache/camel-k/issues/4460)
- TestLocalPlatform likely fail when staging [\#4458](https://github.com/apache/camel-k/issues/4458)
- SBOM for Camel K [\#4430](https://github.com/apache/camel-k/issues/4430)
- Remove unused/unmaintained dependencies [\#4326](https://github.com/apache/camel-k/issues/4326)
- Operator is not able to push builder image to the internal registry \(OpenShift cluster\) [\#4297](https://github.com/apache/camel-k/issues/4297)
- Configure memory resource requests on builder pods [\#1092](https://github.com/apache/camel-k/issues/1092)

## [camel-k-crds-1.12.1](https://github.com/apache/camel-k/tree/camel-k-crds-1.12.1) (2023-05-29)

[Full Changelog](https://github.com/apache/camel-k/compare/2.0.0-nightly...camel-k-crds-1.12.1)

**Closed issues:**

- Minor validation issue on Task [\#4413](https://github.com/apache/camel-k/issues/4413)
- Sudden validate issue [\#4408](https://github.com/apache/camel-k/issues/4408)
- Delete stale branches [\#4389](https://github.com/apache/camel-k/issues/4389)
- No such property: header for class: Script1 [\#4385](https://github.com/apache/camel-k/issues/4385)
- camel- k with spring cloud config [\#4370](https://github.com/apache/camel-k/issues/4370)
- Camel k 1.12.0: camel:jta not found in Camel catalog [\#4361](https://github.com/apache/camel-k/issues/4361)
- Test failures, likely some regression [\#4358](https://github.com/apache/camel-k/issues/4358)
- High memory Quarkus native check failing [\#4345](https://github.com/apache/camel-k/issues/4345)
- Cron Trait initiates shutdown for nested exchange \(Split EIP\) [\#4343](https://github.com/apache/camel-k/issues/4343)
- Binding from a Strimzi CR is not properly decoded [\#4336](https://github.com/apache/camel-k/issues/4336)
- Camel-k does not terminate previous pods after updating of integration [\#4333](https://github.com/apache/camel-k/issues/4333)
- Native "higher memory" checks not running [\#4328](https://github.com/apache/camel-k/issues/4328)
- TestKamelReset test flakiness [\#4316](https://github.com/apache/camel-k/issues/4316)
- Cannot set GOMAXPROCS [\#4299](https://github.com/apache/camel-k/issues/4299)
- Maximum number of running builds \(0\) exceeded [\#4290](https://github.com/apache/camel-k/issues/4290)
- Should uninstall --all remove PersistentVolumeClaim? [\#4285](https://github.com/apache/camel-k/issues/4285)
- Add statical check if integration refers to components supported by Camel K [\#4283](https://github.com/apache/camel-k/issues/4283)
- Camel K 2.0 release process [\#4282](https://github.com/apache/camel-k/issues/4282)
- Transform the Build into a Pipeline [\#4281](https://github.com/apache/camel-k/issues/4281)
- Camel-k install and uninstall on a fresh kind cluster in Linux [\#4277](https://github.com/apache/camel-k/issues/4277)
- Kamelet redis-source not working [\#4276](https://github.com/apache/camel-k/issues/4276)
- Failed to fetch data from Mysql database using camel-k [\#4264](https://github.com/apache/camel-k/issues/4264)
- Mention the published "generated extension" for Java in the docs [\#4262](https://github.com/apache/camel-k/issues/4262)
- unable to execute "kamel run" in secure mode [\#4249](https://github.com/apache/camel-k/issues/4249)
- Acquiring lock at startup is taking long [\#4246](https://github.com/apache/camel-k/issues/4246)
- Builder pod that hit timeout is not terminated [\#4241](https://github.com/apache/camel-k/issues/4241)
- Introduce Code Coverage badge [\#4227](https://github.com/apache/camel-k/issues/4227)
- CamelCatalog reconciliation fail [\#4226](https://github.com/apache/camel-k/issues/4226)
- duplicate routeId issue [\#4225](https://github.com/apache/camel-k/issues/4225)
- `KameletBinding` should own the related `Integration` [\#4219](https://github.com/apache/camel-k/issues/4219)
- `kamel rebuild` does not rebuild integrations correctly [\#4218](https://github.com/apache/camel-k/issues/4218)
- Local file in unit test leftover [\#4217](https://github.com/apache/camel-k/issues/4217)
- Validate error [\#4214](https://github.com/apache/camel-k/issues/4214)
- `kamel rebuild` does not rebuild KameletBindings [\#4208](https://github.com/apache/camel-k/issues/4208)
- Allow E2E suite test to run against a remote cluster [\#4207](https://github.com/apache/camel-k/issues/4207)
- Bring in the option to have more verbose IntegrationKit names [\#4205](https://github.com/apache/camel-k/issues/4205)
- Cannot copy local runtime dependencies [\#4198](https://github.com/apache/camel-k/issues/4198)
- Creation of monitoring resources fail in a new GKE cluster [\#4191](https://github.com/apache/camel-k/issues/4191)
- Unable to produce and consume in camel-k to apache kafka, getting error like "Connection to node -1 \(localhost/127.0.0.1:9092\) could not be established. Broker may not be available." [\#4186](https://github.com/apache/camel-k/issues/4186)
- Remove additional custom labels utility [\#4183](https://github.com/apache/camel-k/issues/4183)
- Camel K 2.x upgrade 1.x strategy [\#4179](https://github.com/apache/camel-k/issues/4179)
- Customize Builder resources when Quarkus Native [\#4177](https://github.com/apache/camel-k/issues/4177)
- Makefile not working on Mac [\#4175](https://github.com/apache/camel-k/issues/4175)
- Kamelet development using Camel DSL instead of YAML DSL [\#4174](https://github.com/apache/camel-k/issues/4174)
- Better naming of IntegrationKits to indicate whether the kit is native or non-native [\#4172](https://github.com/apache/camel-k/issues/4172)
- Default integrationPlatform created at operator startup dose not honor OPERATOR\_ID config [\#4167](https://github.com/apache/camel-k/issues/4167)
- property with dollar sign and brackets replaced with emtpy value [\#4163](https://github.com/apache/camel-k/issues/4163)
- Kamel cli reset/uninstall --all does not clean the camelcatalog [\#4160](https://github.com/apache/camel-k/issues/4160)
- Unused parameter [\#4152](https://github.com/apache/camel-k/issues/4152)
- + [\#4151](https://github.com/apache/camel-k/issues/4151)
- Kamel run sample integration is failing to run [\#4150](https://github.com/apache/camel-k/issues/4150)
- Bring in startup probes to the Health trait [\#4146](https://github.com/apache/camel-k/issues/4146)
- Bring an option to force an image build to the kamel run command [\#4126](https://github.com/apache/camel-k/issues/4126)
- How to use JVM classpaths in Native mode? [\#4124](https://github.com/apache/camel-k/issues/4124)
- Secret managers parsing errors [\#4080](https://github.com/apache/camel-k/issues/4080)
- Remove deprecated linters [\#4061](https://github.com/apache/camel-k/issues/4061)
- Remove github.com/fatih/structs dependency [\#4033](https://github.com/apache/camel-k/issues/4033)
- Camel K does not automatically add dependency JacksonXML [\#4027](https://github.com/apache/camel-k/issues/4027)
- Remove all deprecated code in 1.x version [\#4026](https://github.com/apache/camel-k/issues/4026)
- Bump Mandrel from 22.2.0 to 22.3.1 [\#4017](https://github.com/apache/camel-k/issues/4017)
- Some API warnings reported while contributing operator 1.11.1 [\#4016](https://github.com/apache/camel-k/issues/4016)
- add a new known issue to the Troubleshooting doc section [\#4007](https://github.com/apache/camel-k/issues/4007)
- Remove dependency no longer maintained [\#3935](https://github.com/apache/camel-k/issues/3935)
- Expose runtime details in `kamel version -a -v` [\#3836](https://github.com/apache/camel-k/issues/3836)
- Remove KEP cryptic message when installing [\#3829](https://github.com/apache/camel-k/issues/3829)
- Improve error reporting in case of knative is required but not installed [\#3803](https://github.com/apache/camel-k/issues/3803)
- Misleading message when updating an unchanged `Integration` [\#3705](https://github.com/apache/camel-k/issues/3705)
- Private Registry With TLS  Can Not Work [\#3672](https://github.com/apache/camel-k/issues/3672)
- Wrong KameletBinding definition leads to operator panic [\#3586](https://github.com/apache/camel-k/issues/3586)
- \[E2E\] Add tests for enabling traits at IntegrationPlatform [\#3476](https://github.com/apache/camel-k/issues/3476)
- Move from release nightly to Continuous Delivery [\#3260](https://github.com/apache/camel-k/issues/3260)
- OLM basic installation integration test [\#3180](https://github.com/apache/camel-k/issues/3180)
- A better name for KameletBinding [\#2625](https://github.com/apache/camel-k/issues/2625)
- Default to using Micrometer for integration monitoring [\#1773](https://github.com/apache/camel-k/issues/1773)

## [2.0.0-nightly](https://github.com/apache/camel-k/tree/2.0.0-nightly) (2023-03-22)

[Full Changelog](https://github.com/apache/camel-k/compare/1.10.5-nightly...2.0.0-nightly)

**Closed issues:**

- Regression on Kustomize [\#4142](https://github.com/apache/camel-k/issues/4142)
- Smoke test failing on master trait [\#4138](https://github.com/apache/camel-k/issues/4138)
- Integration in error state when knative SinkBinding mode=inclusion [\#4119](https://github.com/apache/camel-k/issues/4119)
- Nightly release fail after 2.0 [\#4086](https://github.com/apache/camel-k/issues/4086)
- Failure when mounting condifgmap and secrets with the same name [\#3980](https://github.com/apache/camel-k/issues/3980)
- CXF Maven Dependency error while running the camel k on OpenShift [\#3961](https://github.com/apache/camel-k/issues/3961)
- Unable to use Processor in Kamelet, unable to get logs either [\#3937](https://github.com/apache/camel-k/issues/3937)
- Cannot retrieve Camel K operator version when in global mode in different ns [\#3854](https://github.com/apache/camel-k/issues/3854)
- Camel K testing - official doc required [\#3848](https://github.com/apache/camel-k/issues/3848)
- Camel Pluggable Properties Source Feature: How to provide credentials for different cloud providers  [\#3031](https://github.com/apache/camel-k/issues/3031)
- Multi-architecture support [\#1238](https://github.com/apache/camel-k/issues/1238)

**Merged pull requests:**

- fix: kustomize revert placeholder namespace [\#4147](https://github.com/apache/camel-k/pull/4147) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/container-tools/spectrum from 0.6.1 to 0.6.2 [\#4143](https://github.com/apache/camel-k/pull/4143) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(cmd\): compatibility check when not a semver [\#4137](https://github.com/apache/camel-k/pull/4137) ([squakez](https://github.com/squakez))
- chore\(ci\): camel kamelets catalog scraping [\#4136](https://github.com/apache/camel-k/pull/4136) ([squakez](https://github.com/squakez))
- doc\(install\): camel k fine tuning [\#4134](https://github.com/apache/camel-k/pull/4134) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/onsi/gomega from 1.27.3 to 1.27.4 [\#4132](https://github.com/apache/camel-k/pull/4132) ([dependabot[bot]](https://github.com/apps/dependabot))
- feat\(ci\): scrape latest CK runtime available [\#4131](https://github.com/apache/camel-k/pull/4131) ([squakez](https://github.com/squakez))
- feat: move code to version 2 [\#4128](https://github.com/apache/camel-k/pull/4128) ([squakez](https://github.com/squakez))
- fix\(knative\): Integration in error state when knative SinkBinding mode=inclusion [\#4120](https://github.com/apache/camel-k/pull/4120) ([claudio4j](https://github.com/claudio4j))

## [1.10.5-nightly](https://github.com/apache/camel-k/tree/1.10.5-nightly) (2023-03-13)

[Full Changelog](https://github.com/apache/camel-k/compare/1.12.1-nightly...1.10.5-nightly)

**Closed issues:**

- All KameletBindings reporting "Integration X does not have a readiness condition" error message [\#4129](https://github.com/apache/camel-k/issues/4129)
- Kamelets are tried to unmarshal with old Flow [\#4117](https://github.com/apache/camel-k/issues/4117)
- Upgrade Operator Framework SDK version [\#4105](https://github.com/apache/camel-k/issues/4105)
- Automatic updates action failing [\#4073](https://github.com/apache/camel-k/issues/4073)
- Build refactoring \(to address runtime decoupling\) [\#3831](https://github.com/apache/camel-k/issues/3831)
- Add support for multiple data types and schemas in Kamelets [\#1980](https://github.com/apache/camel-k/issues/1980)

**Merged pull requests:**

- chore\(deps\): bump github.com/onsi/gomega from 1.27.2 to 1.27.3 [\#4127](https://github.com/apache/camel-k/pull/4127) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix typos on traits.adoc and improve the overall language [\#4123](https://github.com/apache/camel-k/pull/4123) ([mertdotcc](https://github.com/mertdotcc))
- fix typos on resources.adoc and improve language [\#4122](https://github.com/apache/camel-k/pull/4122) ([mertdotcc](https://github.com/mertdotcc))
- fix\(doc\): kamelet semver [\#4115](https://github.com/apache/camel-k/pull/4115) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/prometheus/common from 0.41.0 to 0.42.0 [\#4113](https://github.com/apache/camel-k/pull/4113) ([dependabot[bot]](https://github.com/apps/dependabot))
- Secret managers parsing errors [\#4109](https://github.com/apache/camel-k/pull/4109) ([oscerd](https://github.com/oscerd))
- fix\(\#1980\): Support data types in Kamelets [\#4100](https://github.com/apache/camel-k/pull/4100) ([christophd](https://github.com/christophd))
- Free Camel K from runtime dependency [\#4025](https://github.com/apache/camel-k/pull/4025) ([squakez](https://github.com/squakez))

## [1.12.1-nightly](https://github.com/apache/camel-k/tree/1.12.1-nightly) (2023-03-08)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.12.0...1.12.1-nightly)

**Closed issues:**

-  Nightly Quarkus native checks failure after 2.0 [\#4087](https://github.com/apache/camel-k/issues/4087)
- MongoDB sink: error during trait customization: component not found for uri [\#4058](https://github.com/apache/camel-k/issues/4058)
- Release 1.12.0 [\#4002](https://github.com/apache/camel-k/issues/4002)
- Camel-K maven security [\#3956](https://github.com/apache/camel-k/issues/3956)
- Create normal service when knative-service trait is disabled [\#3849](https://github.com/apache/camel-k/issues/3849)
- Rethink E2E execution flow [\#3847](https://github.com/apache/camel-k/issues/3847)
- Minimum Kubernetes version [\#495](https://github.com/apache/camel-k/issues/495)

**Merged pull requests:**

- chore\(olm\): bump framework operator sdk from v1.16.0 to v1.26.1 [\#4106](https://github.com/apache/camel-k/pull/4106) ([gansheer](https://github.com/gansheer))
- chore\(deps\): bump golang.org/x/oauth2 from 0.5.0 to 0.6.0 [\#4103](https://github.com/apache/camel-k/pull/4103) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(\#3956\): Add maven settings-security.xml to maven command [\#4099](https://github.com/apache/camel-k/pull/4099) ([gansheer](https://github.com/gansheer))
- \[camel-kamelets\] Issue-1330: Deprecating parameters [\#4097](https://github.com/apache/camel-k/pull/4097) ([manstis](https://github.com/manstis))
- fix\(ci\): quarkus native action name [\#4094](https://github.com/apache/camel-k/pull/4094) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/prometheus/common from 0.40.0 to 0.41.0 [\#4089](https://github.com/apache/camel-k/pull/4089) ([dependabot[bot]](https://github.com/apps/dependabot))
- feat: Add path-based Ingress options to the ingress trait [\#4088](https://github.com/apache/camel-k/pull/4088) ([astefanutti](https://github.com/astefanutti))
- chore\(deps\): bump github.com/onsi/gomega from 1.27.1 to 1.27.2 [\#4085](https://github.com/apache/camel-k/pull/4085) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(e2e\): correct jar location [\#4084](https://github.com/apache/camel-k/pull/4084) ([squakez](https://github.com/squakez))
- fix: actions for 2.0 [\#4083](https://github.com/apache/camel-k/pull/4083) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/container-tools/spectrum from 0.6.0 to 0.6.1 [\#4082](https://github.com/apache/camel-k/pull/4082) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore: bump to 2.0.0 [\#4081](https://github.com/apache/camel-k/pull/4081) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/stretchr/testify from 1.8.1 to 1.8.2 [\#4079](https://github.com/apache/camel-k/pull/4079) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(ci\): trigger native only when PR are labeled [\#4078](https://github.com/apache/camel-k/pull/4078) ([squakez](https://github.com/squakez))
- chore\(deps\): k8s api to 0.25.6 [\#4077](https://github.com/apache/camel-k/pull/4077) ([squakez](https://github.com/squakez))
- chore\(test\): rearrange e2e structure folder [\#4072](https://github.com/apache/camel-k/pull/4072) ([squakez](https://github.com/squakez))
- Use more recent link for Camel K tutorials [\#4071](https://github.com/apache/camel-k/pull/4071) ([apupier](https://github.com/apupier))
- chore\(deps\): bump github.com/prometheus/common from 0.39.0 to 0.40.0 [\#4068](https://github.com/apache/camel-k/pull/4068) ([dependabot[bot]](https://github.com/apps/dependabot))

## [pkg/apis/camel/v1.12.0](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.12.0) (2023-02-21)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.12.0...pkg/apis/camel/v1.12.0)

## [v1.12.0](https://github.com/apache/camel-k/tree/v1.12.0) (2023-02-21)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.12.0...v1.12.0)

## [pkg/kamelet/repository/v1.12.0](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.12.0) (2023-02-21)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.12.0...pkg/kamelet/repository/v1.12.0)

## [pkg/client/camel/v1.12.0](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.12.0) (2023-02-21)

[Full Changelog](https://github.com/apache/camel-k/compare/camel-k-crds-1.12.0...pkg/client/camel/v1.12.0)

## [camel-k-crds-1.12.0](https://github.com/apache/camel-k/tree/camel-k-crds-1.12.0) (2023-02-21)

[Full Changelog](https://github.com/apache/camel-k/compare/1.11.2-nightly...camel-k-crds-1.12.0)

**Closed issues:**

- Publish Fabric8 Java extension beside release [\#4055](https://github.com/apache/camel-k/issues/4055)
- YAKS test failure [\#4044](https://github.com/apache/camel-k/issues/4044)
- Fabric8 CRD deploy action fails [\#4035](https://github.com/apache/camel-k/issues/4035)
- Compatibility matrix show wrong kamelets version for camel-k releases 1.10.x and 1.11.x [\#4023](https://github.com/apache/camel-k/issues/4023)
- Native builds failure due to missing catalog [\#4022](https://github.com/apache/camel-k/issues/4022)
- operator refers to a openjdk image tag not found in docker.io [\#3998](https://github.com/apache/camel-k/issues/3998)
- Camel-k checks other namespaces and error given  [\#3996](https://github.com/apache/camel-k/issues/3996)
- Prometheus bump [\#3985](https://github.com/apache/camel-k/issues/3985)
- org.apache.camel.CamelExecutionException: Exception occurred during execution on the exchange: Exchange\[\] [\#3969](https://github.com/apache/camel-k/issues/3969)
- \[Discussion\] Camel K 2023 roadmap [\#3964](https://github.com/apache/camel-k/issues/3964)
- Default namespace not used when `-o yaml` [\#3955](https://github.com/apache/camel-k/issues/3955)
- --config property by kamel \> 1.10: Errror spec.traits.mount.configuration: Required value [\#3923](https://github.com/apache/camel-k/issues/3923)
- Support Hashicorp Vault as secrets properties source [\#3904](https://github.com/apache/camel-k/issues/3904)
- Support secret refresh through the existing addons [\#3903](https://github.com/apache/camel-k/issues/3903)
- Allow traits to be configured via configmap/secrets [\#3891](https://github.com/apache/camel-k/issues/3891)
- Allow "kamel promote" integrate with GitOps styled deployments [\#3888](https://github.com/apache/camel-k/issues/3888)
- Kamelets load properties from ConfigMap [\#3811](https://github.com/apache/camel-k/issues/3811)
- Unable to configure ServiceAccountName using Kamel run [\#3797](https://github.com/apache/camel-k/issues/3797)
- Split with parallelProcessing runs sequentially [\#3785](https://github.com/apache/camel-k/issues/3785)
- Integration Kit image build runs into an endless loop when a lower level image can't be pulled from Registry [\#3266](https://github.com/apache/camel-k/issues/3266)
- Camel-K Java native support - native run of a java route fails [\#3023](https://github.com/apache/camel-k/issues/3023)
- Choose a single location for examples [\#2826](https://github.com/apache/camel-k/issues/2826)
- Camel-K Tracing Trait error [\#2633](https://github.com/apache/camel-k/issues/2633)
- Provide non-regression tests for regression \#1872 [\#1875](https://github.com/apache/camel-k/issues/1875)
- rethink configurations spec [\#1680](https://github.com/apache/camel-k/issues/1680)
- Support for AWS ECR in kaniko builder in Operator [\#1031](https://github.com/apache/camel-k/issues/1031)

**Merged pull requests:**

- Preparation of release 1.12.0 [\#4067](https://github.com/apache/camel-k/pull/4067) ([oscerd](https://github.com/oscerd))
- Move pod's phase indexer to integration controller initialization [\#4064](https://github.com/apache/camel-k/pull/4064) ([lburgazzoli](https://github.com/lburgazzoli))
- feat\(ci\): Camel-K-CRD java dependency [\#4062](https://github.com/apache/camel-k/pull/4062) ([squakez](https://github.com/squakez))
- feature\(\#3903\): Support secret refresh through the existing addons - Docs update [\#4057](https://github.com/apache/camel-k/pull/4057) ([oscerd](https://github.com/oscerd))
- feature\(\#3903\): Support secret refresh through the existing addons - Azure Key Vault [\#4056](https://github.com/apache/camel-k/pull/4056) ([oscerd](https://github.com/oscerd))
- chore\(ci\): bump java crds [\#4054](https://github.com/apache/camel-k/pull/4054) ([squakez](https://github.com/squakez))
- Minor adjustments to generated CRDs java package [\#4053](https://github.com/apache/camel-k/pull/4053) ([andreaTP](https://github.com/andreaTP))
- fix - publish the jar with the generated classes [\#4052](https://github.com/apache/camel-k/pull/4052) ([andreaTP](https://github.com/andreaTP))
- feature\(\#3903\): Support secret refresh through the existing addons - Google Secret Manager [\#4051](https://github.com/apache/camel-k/pull/4051) ([oscerd](https://github.com/oscerd))
- feat\(cli\): promote dry run [\#4050](https://github.com/apache/camel-k/pull/4050) ([squakez](https://github.com/squakez))
- feature\(\#3903\): Support secret refresh through the existing addons - AWS Secrets Manager [\#4047](https://github.com/apache/camel-k/pull/4047) ([oscerd](https://github.com/oscerd))
- fix\(\#4044\): Fix Kamelet utils version in e2e tests [\#4046](https://github.com/apache/camel-k/pull/4046) ([christophd](https://github.com/christophd))
- fix\(ci\): env in proper place [\#4045](https://github.com/apache/camel-k/pull/4045) ([squakez](https://github.com/squakez))
- chore\(ci\): setting ASF snapshot credentials [\#4043](https://github.com/apache/camel-k/pull/4043) ([squakez](https://github.com/squakez))
- chore\(dependencies\): prometheus 0.60.0 [\#4042](https://github.com/apache/camel-k/pull/4042) ([squakez](https://github.com/squakez))
- chore\(deps\): bump golang.org/x/oauth2 from 0.4.0 to 0.5.0 [\#4041](https://github.com/apache/camel-k/pull/4041) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(ci\): settings directory [\#4039](https://github.com/apache/camel-k/pull/4039) ([squakez](https://github.com/squakez))
- Fix the package of camel-k-runtime when using SNAPSHOT version [\#4037](https://github.com/apache/camel-k/pull/4037) ([claudio4j](https://github.com/claudio4j))
- feat\(vault\): Support Hashicorp Vault as secrets properties source [\#4036](https://github.com/apache/camel-k/pull/4036) ([oscerd](https://github.com/oscerd))
- Upgrade test fails for respin - searches in ikit version for prevCSVVersion with Build [\#4034](https://github.com/apache/camel-k/pull/4034) ([lfabriko](https://github.com/lfabriko))
- Support Hashicorp Vault as secrets properties source [\#4032](https://github.com/apache/camel-k/pull/4032) ([oscerd](https://github.com/oscerd))
- feat\(cli\): enable service account [\#4030](https://github.com/apache/camel-k/pull/4030) ([squakez](https://github.com/squakez))
- fix\(test\): use Kamelet catalog [\#4029](https://github.com/apache/camel-k/pull/4029) ([squakez](https://github.com/squakez))
- fix: don't log forbidden warning [\#4028](https://github.com/apache/camel-k/pull/4028) ([squakez](https://github.com/squakez))
- Ref \#3023: Add native compilation with sources [\#4021](https://github.com/apache/camel-k/pull/4021) ([essobedo](https://github.com/essobedo))

## [1.11.2-nightly](https://github.com/apache/camel-k/tree/1.11.2-nightly) (2023-02-02)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.11.1...1.11.2-nightly)

**Closed issues:**

- Camel 3.20 incompatibilities [\#4011](https://github.com/apache/camel-k/issues/4011)
- Release 1.11.1 [\#4006](https://github.com/apache/camel-k/issues/4006)
- Set a more reasonable default for gomega eventually's polling interval [\#3992](https://github.com/apache/camel-k/issues/3992)
- Automatic dependency scraping not working [\#3984](https://github.com/apache/camel-k/issues/3984)
- Release 1.10.4 [\#3982](https://github.com/apache/camel-k/issues/3982)
- Facing an error while Invoking a SOAP service method from Camel-K [\#3973](https://github.com/apache/camel-k/issues/3973)
- Default `operator.id` annotation [\#3725](https://github.com/apache/camel-k/issues/3725)

**Merged pull requests:**

- fix\(ci\): shell step [\#4015](https://github.com/apache/camel-k/pull/4015) ([squakez](https://github.com/squakez))
- fix\(ci\): CRD dependency release in action [\#4014](https://github.com/apache/camel-k/pull/4014) ([squakez](https://github.com/squakez))
- chore\(ci\): automatic updates go version [\#4013](https://github.com/apache/camel-k/pull/4013) ([squakez](https://github.com/squakez))
- fix\(trait\): error handler ref in camel 3.20 [\#4012](https://github.com/apache/camel-k/pull/4012) ([squakez](https://github.com/squakez))
- chore\(test\): don't install kamelet catalog [\#4009](https://github.com/apache/camel-k/pull/4009) ([squakez](https://github.com/squakez))
- feat\(e2e\): Set a more reasonable default for gomega eventually's polling interval [\#4008](https://github.com/apache/camel-k/pull/4008) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(deps\): bump github.com/onsi/gomega from 1.25.0 to 1.26.0 [\#4001](https://github.com/apache/camel-k/pull/4001) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/container-tools/spectrum from 0.4.0 to 0.5.0 [\#3999](https://github.com/apache/camel-k/pull/3999) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/spf13/viper from 1.14.0 to 1.15.0 [\#3995](https://github.com/apache/camel-k/pull/3995) ([dependabot[bot]](https://github.com/apps/dependabot))
- \[proposal\] Publish a generated extension for Java [\#3994](https://github.com/apache/camel-k/pull/3994) ([andreaTP](https://github.com/andreaTP))
- fix\(\#3988\): Fix flaky E2E test on operator multi tenancy [\#3990](https://github.com/apache/camel-k/pull/3990) ([christophd](https://github.com/christophd))
- Add TIP for optional prop placeholder for non-req param [\#3989](https://github.com/apache/camel-k/pull/3989) ([tarilabs](https://github.com/tarilabs))
- chore\(deps\): bump github.com/onsi/gomega from 1.22.1 to 1.25.0 [\#3987](https://github.com/apache/camel-k/pull/3987) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/redhat-developer/service-binding-operator from 1.3.2 to 1.3.3 [\#3978](https://github.com/apache/camel-k/pull/3978) ([dependabot[bot]](https://github.com/apps/dependabot))
- feat: Render error message condition as json/structured message [\#3977](https://github.com/apache/camel-k/pull/3977) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(doc\): cannot use build pod strategy [\#3976](https://github.com/apache/camel-k/pull/3976) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/stoewer/go-strcase from 1.2.0 to 1.2.1 [\#3975](https://github.com/apache/camel-k/pull/3975) ([dependabot[bot]](https://github.com/apps/dependabot))
- feat\(trait\): Add telemetry trait [\#3970](https://github.com/apache/camel-k/pull/3970) ([gansheer](https://github.com/gansheer))
- api: Generate apply configurations [\#3968](https://github.com/apache/camel-k/pull/3968) ([astefanutti](https://github.com/astefanutti))
- chore\(deps\): bump github.com/container-tools/spectrum from 0.3.11 to 0.4.0 [\#3966](https://github.com/apache/camel-k/pull/3966) ([dependabot[bot]](https://github.com/apps/dependabot))
- Upgrade k8s, knative dependencies and Golang 1.18 [\#3963](https://github.com/apache/camel-k/pull/3963) ([astefanutti](https://github.com/astefanutti))
- chore\(deps\): bump golang.org/x/oauth2 from 0.3.0 to 0.4.0 [\#3962](https://github.com/apache/camel-k/pull/3962) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(ci\): use kamelets tag [\#3960](https://github.com/apache/camel-k/pull/3960) ([squakez](https://github.com/squakez))
- fix\(e2e\): Kamelets tag compatibility with 3.19 [\#3958](https://github.com/apache/camel-k/pull/3958) ([squakez](https://github.com/squakez))
- fix\(e2e\): stabilise kustomize uninstall tests [\#3954](https://github.com/apache/camel-k/pull/3954) ([tadayosi](https://github.com/tadayosi))
- fix\(test\): temporary remove env var [\#3953](https://github.com/apache/camel-k/pull/3953) ([squakez](https://github.com/squakez))
- fix\(\#3844\): Add service discovery for Kamelet data type converter [\#3912](https://github.com/apache/camel-k/pull/3912) ([christophd](https://github.com/christophd))
- fix\(\#3896\): Fix dependency inspector supporting property placeholders [\#3901](https://github.com/apache/camel-k/pull/3901) ([christophd](https://github.com/christophd))

## [pkg/client/camel/v1.11.1](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.11.1) (2023-01-24)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.11.1...pkg/client/camel/v1.11.1)

## [pkg/kamelet/repository/v1.11.1](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.11.1) (2023-01-24)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.11.1...pkg/kamelet/repository/v1.11.1)

## [pkg/apis/camel/v1.11.1](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.11.1) (2023-01-24)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.11.1...pkg/apis/camel/v1.11.1)

## [v1.11.1](https://github.com/apache/camel-k/tree/v1.11.1) (2023-01-24)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.10.4...v1.11.1)

## [pkg/kamelet/repository/v1.10.4](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.10.4) (2023-01-24)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.10.4...pkg/kamelet/repository/v1.10.4)

## [v1.10.4](https://github.com/apache/camel-k/tree/v1.10.4) (2023-01-24)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.10.4...v1.10.4)

## [pkg/apis/camel/v1.10.4](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.10.4) (2023-01-24)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.10.4...pkg/apis/camel/v1.10.4)

## [pkg/client/camel/v1.10.4](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.10.4) (2023-01-24)

[Full Changelog](https://github.com/apache/camel-k/compare/1.11.1-nightly...pkg/client/camel/v1.10.4)

**Closed issues:**

- Multi tenancy operator flaky test [\#3988](https://github.com/apache/camel-k/issues/3988)
- unable to set null-like default for non-required Kamelet property [\#3986](https://github.com/apache/camel-k/issues/3986)
- Render error message condition as json/structured message [\#3967](https://github.com/apache/camel-k/issues/3967)
- Smoke test error TestKameletBindingScale [\#3959](https://github.com/apache/camel-k/issues/3959)
- Nightly smoke test failure for Kamelets [\#3957](https://github.com/apache/camel-k/issues/3957)
- E2E - TestKamelCLIRun constantly failing after secrets.GITHUB\_TOKEN applied [\#3952](https://github.com/apache/camel-k/issues/3952)
- Important increase of size of apache/camel-k Docker image [\#3925](https://github.com/apache/camel-k/issues/3925)
- `kamel uninstall` doesn't uninstall IntegrationPlatform [\#3916](https://github.com/apache/camel-k/issues/3916)
- Kamelet http-sink not working [\#3896](https://github.com/apache/camel-k/issues/3896)
- Add data type converter factory finder discovery in camel-quarkus [\#3844](https://github.com/apache/camel-k/issues/3844)
- Upgrade to Go 1.18.x [\#3807](https://github.com/apache/camel-k/issues/3807)
- e2e testing: refactor to remove deprecated functions [\#3751](https://github.com/apache/camel-k/issues/3751)
- e2e test TestKamelCLIRun \(Run with http dependency\) consistently failing on OCP4 [\#3708](https://github.com/apache/camel-k/issues/3708)
- Move tracing from opentracing to opentelemetry [\#3519](https://github.com/apache/camel-k/issues/3519)

## [1.11.1-nightly](https://github.com/apache/camel-k/tree/1.11.1-nightly) (2022-12-23)

[Full Changelog](https://github.com/apache/camel-k/compare/1.11.0...1.11.1-nightly)

**Closed issues:**

- Container trait : setting `container.name` result in wrong integration condition type `Ready`  [\#3941](https://github.com/apache/camel-k/issues/3941)
- V 1.11.0 nightly wrong image name [\#3930](https://github.com/apache/camel-k/issues/3930)
- GraalVM removal from doc [\#3929](https://github.com/apache/camel-k/issues/3929)
- Use flag/config namespace for existing CLI completion kubectl commands [\#3922](https://github.com/apache/camel-k/issues/3922)
- Bundle Kamelets from a released version [\#3919](https://github.com/apache/camel-k/issues/3919)
- Automate the dependencies in doc setting [\#3867](https://github.com/apache/camel-k/issues/3867)
- Kustomize-based installation method doesn't provide uninstall [\#3866](https://github.com/apache/camel-k/issues/3866)
- Helm - missing parameters [\#3763](https://github.com/apache/camel-k/issues/3763)
- Kamelet API test rate limit [\#3760](https://github.com/apache/camel-k/issues/3760)
- Side services compatibility matrix [\#3306](https://github.com/apache/camel-k/issues/3306)
- Way to set a serviceaccount for the integration pod? [\#1030](https://github.com/apache/camel-k/issues/1030)

**Merged pull requests:**

- fix\(controller\): ensure `container.name` trait is used by the integration controller [\#3951](https://github.com/apache/camel-k/pull/3951) ([gansheer](https://github.com/gansheer))
- chore: use latest kamelets [\#3948](https://github.com/apache/camel-k/pull/3948) ([squakez](https://github.com/squakez))
- fix\(ci\): revert usage of TEST\_CLUSTER [\#3947](https://github.com/apache/camel-k/pull/3947) ([squakez](https://github.com/squakez))
- fix\(ci\): use shell for action steps [\#3938](https://github.com/apache/camel-k/pull/3938) ([squakez](https://github.com/squakez))
- fix\(ci\): github rate limit [\#3936](https://github.com/apache/camel-k/pull/3936) ([squakez](https://github.com/squakez))
- fix\(ci\): pass token via inputs [\#3931](https://github.com/apache/camel-k/pull/3931) ([squakez](https://github.com/squakez))
- feat\(kustomize\): add uninstall target to Makefile [\#3928](https://github.com/apache/camel-k/pull/3928) ([tadayosi](https://github.com/tadayosi))
- feat\(cli\): Add namespace in command autocompletion bash [\#3927](https://github.com/apache/camel-k/pull/3927) ([gansheer](https://github.com/gansheer))
- Test config revertions [\#3926](https://github.com/apache/camel-k/pull/3926) ([phantomjinx](https://github.com/phantomjinx))
- feat\(doc\): automatic version scraping [\#3924](https://github.com/apache/camel-k/pull/3924) ([squakez](https://github.com/squakez))
- chore\(cli\): Remove dead code on completion for context flag [\#3921](https://github.com/apache/camel-k/pull/3921) ([gansheer](https://github.com/gansheer))
- e2e fixes and changes [\#3823](https://github.com/apache/camel-k/pull/3823) ([phantomjinx](https://github.com/phantomjinx))

## [1.11.0](https://github.com/apache/camel-k/tree/1.11.0) (2022-12-16)

[Full Changelog](https://github.com/apache/camel-k/compare/1.12.0-nightly...1.11.0)

**Closed issues:**

- Create release actions for 1.11 version [\#3910](https://github.com/apache/camel-k/issues/3910)
- Delete camel k examples and provide a link to camel-k-example repo [\#3889](https://github.com/apache/camel-k/issues/3889)
- Remove `make install-minikube` and `make install-crc` [\#3873](https://github.com/apache/camel-k/issues/3873)
- Automatically `make generate` every night [\#3868](https://github.com/apache/camel-k/issues/3868)
- Enable CLI completion for integration, kit, kamelet names [\#3628](https://github.com/apache/camel-k/issues/3628)
- Propagate errors to KameletBinding status [\#3389](https://github.com/apache/camel-k/issues/3389)
- Health trait usage example [\#3141](https://github.com/apache/camel-k/issues/3141)
- If a KameletBinding is invalid, the related status is not updated to report an error [\#3010](https://github.com/apache/camel-k/issues/3010)
- Remove deprecated Kubernetes API [\#3840](https://github.com/apache/camel-k/issues/3840)
- Release 1.11.0 [\#3837](https://github.com/apache/camel-k/issues/3837)
- Deprecate overlapping Kamel CLI features in favour of Camel JBang [\#3790](https://github.com/apache/camel-k/issues/3790)
- Ready condition message not always taken from Camel Health Check [\#3761](https://github.com/apache/camel-k/issues/3761)
- camel k 0.11.0 helm - Error: parse error at \(camel-k/templates/operator.yaml:87\): "-en" [\#3654](https://github.com/apache/camel-k/issues/3654)
- Run E2E test before nightly releases [\#3572](https://github.com/apache/camel-k/issues/3572)
- Raise error when dependency could not be resolved via CamelCatalog [\#3449](https://github.com/apache/camel-k/issues/3449)
- Log a warn message once the component used has not a quarkus extension [\#3127](https://github.com/apache/camel-k/issues/3127)
- Delete knative warning when Knative is not installed [\#2397](https://github.com/apache/camel-k/issues/2397)

**Merged pull requests:**

- feat\(doc\): automatic doc configuration [\#3920](https://github.com/apache/camel-k/pull/3920) ([squakez](https://github.com/squakez))
- fix\(ci\): actions requires checking out code [\#3918](https://github.com/apache/camel-k/pull/3918) ([squakez](https://github.com/squakez))
-  chore\(build\): force using bash in Makefile to avoid incompatibilities [\#3917](https://github.com/apache/camel-k/pull/3917) ([tadayosi](https://github.com/tadayosi))
- chore\(deps\): bump github.com/redhat-developer/service-binding-operator from 1.3.1 to 1.3.2 [\#3915](https://github.com/apache/camel-k/pull/3915) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore: scripts cleaning [\#3914](https://github.com/apache/camel-k/pull/3914) ([squakez](https://github.com/squakez))
- feat: automatic github actions bump  [\#3913](https://github.com/apache/camel-k/pull/3913) ([squakez](https://github.com/squakez))
- feat\(ci\): automatic make generate  [\#3911](https://github.com/apache/camel-k/pull/3911) ([squakez](https://github.com/squakez))
- chore: deprecate bind funcs [\#3909](https://github.com/apache/camel-k/pull/3909) ([squakez](https://github.com/squakez))
- chore: link to official examples repo [\#3908](https://github.com/apache/camel-k/pull/3908) ([squakez](https://github.com/squakez))
- Fix typo in README [\#3907](https://github.com/apache/camel-k/pull/3907) ([JapuDCret](https://github.com/JapuDCret))
- chore\(deps\): bump github.com/prometheus/common from 0.38.0 to 0.39.0 [\#3905](https://github.com/apache/camel-k/pull/3905) ([dependabot[bot]](https://github.com/apps/dependabot))
- feat\(cli\): Add autocomplete on integrations, kits, kamelets commands [\#3902](https://github.com/apache/camel-k/pull/3902) ([gansheer](https://github.com/gansheer))
- fix\(cmd\): refactor install cmd to remove maintidx lint [\#3900](https://github.com/apache/camel-k/pull/3900) ([tadayosi](https://github.com/tadayosi))
- fix: reconciliation loops behaviors [\#3897](https://github.com/apache/camel-k/pull/3897) ([squakez](https://github.com/squakez))
- fix\(core\): move to policy/v1 [\#3841](https://github.com/apache/camel-k/pull/3841) ([squakez](https://github.com/squakez))
- chore: deprecated commands [\#3839](https://github.com/apache/camel-k/pull/3839) ([squakez](https://github.com/squakez))
- Fix tests related to recent camel-k-runtime changes [\#3838](https://github.com/apache/camel-k/pull/3838) ([claudio4j](https://github.com/claudio4j))
- Minor steps improvements in release guide [\#3809](https://github.com/apache/camel-k/pull/3809) ([oscerd](https://github.com/oscerd))
- fix\(trait\): Camel trait as IntegrationKit [\#3788](https://github.com/apache/camel-k/pull/3788) ([squakez](https://github.com/squakez))
- feat\(build\): parse cmd execution for errors [\#3786](https://github.com/apache/camel-k/pull/3786) ([squakez](https://github.com/squakez))
- feat\(controller\): add Ready condition to IntegrationPlatform [\#3783](https://github.com/apache/camel-k/pull/3783) ([tadayosi](https://github.com/tadayosi))
- Release Helm Chart 1.10.2 [\#3757](https://github.com/apache/camel-k/pull/3757) ([oscerd](https://github.com/oscerd))
- Use jolokia version defined in camel-k-runtime [\#3754](https://github.com/apache/camel-k/pull/3754) ([claudio4j](https://github.com/claudio4j))
- Fixes licenses in pkg [\#3732](https://github.com/apache/camel-k/pull/3732) ([oscerd](https://github.com/oscerd))
- Fixed licenses for addons [\#3729](https://github.com/apache/camel-k/pull/3729) ([oscerd](https://github.com/oscerd))
- Added Support for Azure Key Vault addon [\#3706](https://github.com/apache/camel-k/pull/3706) ([oscerd](https://github.com/oscerd))
- GCP Vault Support leveraging Camel-Google-Secret-Manager Properties Function [\#3697](https://github.com/apache/camel-k/pull/3697) ([oscerd](https://github.com/oscerd))
- chore\(api\): Add validation to trait enum parameters in CRDs [\#3696](https://github.com/apache/camel-k/pull/3696) ([astefanutti](https://github.com/astefanutti))
- fix: Use SIGTERM and SIGINT aware context for bootstrap operations [\#3691](https://github.com/apache/camel-k/pull/3691) ([astefanutti](https://github.com/astefanutti))
- More docs AWS Secrets Manager Vault [\#3689](https://github.com/apache/camel-k/pull/3689) ([oscerd](https://github.com/oscerd))
- chore\(trait\): Deprecate cached discovery option from GC trait [\#3688](https://github.com/apache/camel-k/pull/3688) ([astefanutti](https://github.com/astefanutti))
- Adds the default maven repositories if extra ones are added [\#3684](https://github.com/apache/camel-k/pull/3684) ([phantomjinx](https://github.com/phantomjinx))
- Added docs for AWS Secrets Manager Vault trait [\#3683](https://github.com/apache/camel-k/pull/3683) ([oscerd](https://github.com/oscerd))
- fix\(\#3671\): Fix native mode for KameletBinding [\#3682](https://github.com/apache/camel-k/pull/3682) ([christophd](https://github.com/christophd))
- Added Support AWS Secrets Manager Vault from Camel [\#3679](https://github.com/apache/camel-k/pull/3679) ([oscerd](https://github.com/oscerd))
- feat\(cli\): promote allow Integration update [\#3674](https://github.com/apache/camel-k/pull/3674) ([squakez](https://github.com/squakez))
- fix\(\#3657\): Use OPERATOR\_ID EnvVar consistently [\#3660](https://github.com/apache/camel-k/pull/3660) ([christophd](https://github.com/christophd))
- feat\(controller/cli\): improve handling of invalid components & dependencies against Camel catalog [\#3640](https://github.com/apache/camel-k/pull/3640) ([tadayosi](https://github.com/tadayosi))
- feat\(cli\): Allow to set build publish strategy options from install cmd [\#3631](https://github.com/apache/camel-k/pull/3631) ([essobedo](https://github.com/essobedo))
- feat\(cmd/run\): secret/configmap as runtime/build-time properties [\#3626](https://github.com/apache/camel-k/pull/3626) ([essobedo](https://github.com/essobedo))
- doc: generate Resume trait doc [\#3624](https://github.com/apache/camel-k/pull/3624) ([tadayosi](https://github.com/tadayosi))
- feat\(cli\): Add add-repo command to add a repo for custom Kamelet catalog [\#3623](https://github.com/apache/camel-k/pull/3623) ([essobedo](https://github.com/essobedo))
- feat: Ingress trait host is optional [\#3617](https://github.com/apache/camel-k/pull/3617) ([astefanutti](https://github.com/astefanutti))
- feat\(cli\): Add a config command to manage the default settings [\#3599](https://github.com/apache/camel-k/pull/3599) ([essobedo](https://github.com/essobedo))
- feat\(ci\): smoke test before nightly release [\#3594](https://github.com/apache/camel-k/pull/3594) ([squakez](https://github.com/squakez))
- feat\(cli\): Add tail flag to the log command [\#3589](https://github.com/apache/camel-k/pull/3589) ([essobedo](https://github.com/essobedo))
- feat\(metadata\): raise error when capability/dependency not resolved in CamelCatalog [\#3571](https://github.com/apache/camel-k/pull/3571) ([tadayosi](https://github.com/tadayosi))
- feat\(cli\): Allow to specify custom Kaniko and Buildah images [\#3558](https://github.com/apache/camel-k/pull/3558) ([essobedo](https://github.com/essobedo))

## [1.12.0-nightly](https://github.com/apache/camel-k/tree/1.12.0-nightly) (2022-12-14)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.11.0...1.12.0-nightly)

**Closed issues:**

- Saga example failing with version \> 1.10 [\#3869](https://github.com/apache/camel-k/issues/3869)
- E2E - Isolate native tests into a dedicated workflow and put each test with a separate job in the workflow [\#3777](https://github.com/apache/camel-k/issues/3777)
- E2E - Kustomize tests are unstable [\#3772](https://github.com/apache/camel-k/issues/3772)
- Apache sync not working [\#3734](https://github.com/apache/camel-k/issues/3734)
- OPC UA server not reachable from client [\#3580](https://github.com/apache/camel-k/issues/3580)
- How to run a Camel process as a cron job \(other than a timer\) [\#3576](https://github.com/apache/camel-k/issues/3576)
- `kamel uninstall` should also delete leases [\#3473](https://github.com/apache/camel-k/issues/3473)
- failed: could not pull base image image adoptopenjdk/openjdk11:slim: https://auth.docker.io/token dial tcp: i/o timeout [\#3425](https://github.com/apache/camel-k/issues/3425)
- Kamel `bind` step index unclear [\#2586](https://github.com/apache/camel-k/issues/2586)
- Migrate the PodDisruptionBudget trait to `policy/v1` API [\#2206](https://github.com/apache/camel-k/issues/2206)

**Merged pull requests:**

- Update runtime-resources.adoc [\#3898](https://github.com/apache/camel-k/pull/3898) ([tarilabs](https://github.com/tarilabs))
- chore\(deps\): bump go.uber.org/multierr from 1.8.0 to 1.9.0 [\#3895](https://github.com/apache/camel-k/pull/3895) ([dependabot[bot]](https://github.com/apps/dependabot))
- Upgrade release.adoc with instruction about upload/promote sources [\#3892](https://github.com/apache/camel-k/pull/3892) ([oscerd](https://github.com/oscerd))
- chore\(deps\): bump github.com/magiconair/properties from 1.8.6 to 1.8.7 [\#3887](https://github.com/apache/camel-k/pull/3887) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/prometheus/common from 0.37.0 to 0.38.0 [\#3886](https://github.com/apache/camel-k/pull/3886) ([dependabot[bot]](https://github.com/apps/dependabot))
- feat\(cli\): Update Kamel bind step index in properties to start at 1 instead of 0 [\#3884](https://github.com/apache/camel-k/pull/3884) ([gansheer](https://github.com/gansheer))
- Fix \#3869: Update Saga Example [\#3883](https://github.com/apache/camel-k/pull/3883) ([MotaOcimar](https://github.com/MotaOcimar))
- Revert "prometheus trait fully tested as in CI, the version of OCP is 4.x" [\#3881](https://github.com/apache/camel-k/pull/3881) ([squakez](https://github.com/squakez))
- fix\(\#3800\): Add proper kamel linux binary on MacOS [\#3879](https://github.com/apache/camel-k/pull/3879) ([christophd](https://github.com/christophd))
- Prepare release 1.11.0  [\#3878](https://github.com/apache/camel-k/pull/3878) ([oscerd](https://github.com/oscerd))
- prometheus trait fully tested as in CI, the version of OCP is 4.x [\#3875](https://github.com/apache/camel-k/pull/3875) ([vitorz](https://github.com/vitorz))
- fix\(e2e\): use generated API methods [\#3874](https://github.com/apache/camel-k/pull/3874) ([squakez](https://github.com/squakez))
- fix\(service\): Create k8s service when knative-service trait is disabled [\#3871](https://github.com/apache/camel-k/pull/3871) ([claudio4j](https://github.com/claudio4j))
- fix\(e2e\): isolate kustomize tests not to interfere with each other [\#3863](https://github.com/apache/camel-k/pull/3863) ([tadayosi](https://github.com/tadayosi))
- chore\(deps\): bump go.uber.org/zap from 1.23.0 to 1.24.0 [\#3862](https://github.com/apache/camel-k/pull/3862) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(ci\): move native into nigtly release wf [\#3860](https://github.com/apache/camel-k/pull/3860) ([squakez](https://github.com/squakez))
- fix\(trait\): trait error "camel-catalog already exists" during upgrade [\#3858](https://github.com/apache/camel-k/pull/3858) ([tadayosi](https://github.com/tadayosi))
- fix\(source\): dataformat dependencies not resolved [\#3856](https://github.com/apache/camel-k/pull/3856) ([tadayosi](https://github.com/tadayosi))
- fix: typo on operator.adoc [\#3850](https://github.com/apache/camel-k/pull/3850) ([mertdotcc](https://github.com/mertdotcc))
- fix\(GC\): Default to APIResourceList group when APIResource group is empty [\#3834](https://github.com/apache/camel-k/pull/3834) ([astefanutti](https://github.com/astefanutti))
- fix: bundle all Camel K runtime artifacts [\#3830](https://github.com/apache/camel-k/pull/3830) ([squakez](https://github.com/squakez))
- chore\(test\) : TestRunAndLog to pass on mac os [\#3828](https://github.com/apache/camel-k/pull/3828) ([u5surf](https://github.com/u5surf))
- Fix space in get\_catalog.sh [\#3827](https://github.com/apache/camel-k/pull/3827) ([claudio4j](https://github.com/claudio4j))
- chore\(build\): upgrade Maven and ubi-quarkus-mandrel base image [\#3825](https://github.com/apache/camel-k/pull/3825) ([tadayosi](https://github.com/tadayosi))
- chore: remove deprecated code [\#3819](https://github.com/apache/camel-k/pull/3819) ([squakez](https://github.com/squakez))
- chore\(e2e\): separate native-it and run it nightly [\#3816](https://github.com/apache/camel-k/pull/3816) ([tadayosi](https://github.com/tadayosi))
- fix\(controller\): Ready condition message not always taken from Camel Health Checks [\#3814](https://github.com/apache/camel-k/pull/3814) ([tadayosi](https://github.com/tadayosi))
- feat\(cli\): Support build time dependencies for dependencies uploaded … [\#3808](https://github.com/apache/camel-k/pull/3808) ([johnpoth](https://github.com/johnpoth))
- fix\(\#3800\): Add proper kamel CLI to image build on macOS [\#3804](https://github.com/apache/camel-k/pull/3804) ([christophd](https://github.com/christophd))
- chore\(deps\): bump github.com/prometheus/client\_golang from 1.13.0 to 1.14.0 [\#3801](https://github.com/apache/camel-k/pull/3801) ([dependabot[bot]](https://github.com/apps/dependabot))

## [pkg/client/camel/v1.11.0](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.11.0) (2022-12-07)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.11.0...pkg/client/camel/v1.11.0)

## [pkg/apis/camel/v1.11.0](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.11.0) (2022-12-07)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.11.0...pkg/apis/camel/v1.11.0)

## [v1.11.0](https://github.com/apache/camel-k/tree/v1.11.0) (2022-12-07)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.11.0...v1.11.0)

## [pkg/kamelet/repository/v1.11.0](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.11.0) (2022-12-07)

[Full Changelog](https://github.com/apache/camel-k/compare/1.10.4-nightly...pkg/kamelet/repository/v1.11.0)

**Closed issues:**

- E2E - Prometheus trait tests started to fail constantly after \#3875 [\#3880](https://github.com/apache/camel-k/issues/3880)
- Recent testing failures [\#3861](https://github.com/apache/camel-k/issues/3861)
- Update dependency versions in the documentation for 1.10.x and Next versions [\#3852](https://github.com/apache/camel-k/issues/3852)
- gc trait fails for: cannot list resource \"endpoints\" in API group \"submariner.io\" [\#3833](https://github.com/apache/camel-k/issues/3833)
- Bundle m2 camel k runtime distribution [\#3826](https://github.com/apache/camel-k/issues/3826)
- E2E - Upgrade tests has become flaky saying '"camel-catalog-1.16.0-snapshot-quarkus" already exists' [\#3822](https://github.com/apache/camel-k/issues/3822)
- `make generate` removes `PatchScale` func [\#3818](https://github.com/apache/camel-k/issues/3818)
- E2E - Builder tests are constantly failing due to "Out of date version of GraalVM detected: native-image 21.3.0.0-Final" [\#3817](https://github.com/apache/camel-k/issues/3817)
- query regarding using camel k [\#3815](https://github.com/apache/camel-k/issues/3815)
- TestRunAndLog refactoring [\#3813](https://github.com/apache/camel-k/issues/3813)
- FTP sink does not create directories when writing [\#3812](https://github.com/apache/camel-k/issues/3812)
- `make install-minikube` does not work on macOS [\#3800](https://github.com/apache/camel-k/issues/3800)
- Release 1.10.3 [\#3796](https://github.com/apache/camel-k/issues/3796)
- Remove code deprecated before 1.8 \(LTS\) [\#3787](https://github.com/apache/camel-k/issues/3787)
- Native checks to run on a nightly basis instead of on each PR [\#3784](https://github.com/apache/camel-k/issues/3784)
- Unable to set env var OPERATOR\_ID in Helm installation [\#3739](https://github.com/apache/camel-k/issues/3739)
- Camel version mismatch [\#3481](https://github.com/apache/camel-k/issues/3481)
- Why's there JDK inside the camel-k-kit-\* images? [\#3424](https://github.com/apache/camel-k/issues/3424)
- Drop support for Openshift 3 and related E2E test [\#3421](https://github.com/apache/camel-k/issues/3421)
- Turn AWS region parameter into an enum? [\#3289](https://github.com/apache/camel-k/issues/3289)
- Install Camel-K Operator based on Helm Chart with --global option [\#3054](https://github.com/apache/camel-k/issues/3054)
- Camel 3.15 - Data formats renamed [\#2880](https://github.com/apache/camel-k/issues/2880)
- Add official documentation on Kustomize introduced in 1.7 [\#2758](https://github.com/apache/camel-k/issues/2758)

## [1.10.4-nightly](https://github.com/apache/camel-k/tree/1.10.4-nightly) (2022-11-14)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.10.3...1.10.4-nightly)

**Merged pull requests:**

- chore: Fix tests on macOS aarch64 [\#3805](https://github.com/apache/camel-k/pull/3805) ([christophd](https://github.com/christophd))
- chore\(deps\): bump github.com/redhat-developer/service-binding-operator from 1.3.0 to 1.3.1 [\#3799](https://github.com/apache/camel-k/pull/3799) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/spf13/viper from 1.13.0 to 1.14.0 [\#3798](https://github.com/apache/camel-k/pull/3798) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(e2e\): clean up OCP3 guards [\#3782](https://github.com/apache/camel-k/pull/3782) ([tadayosi](https://github.com/tadayosi))
- chore: removed module [\#3780](https://github.com/apache/camel-k/pull/3780) ([squakez](https://github.com/squakez))
- fix helm annotations and kamel\_id [\#3778](https://github.com/apache/camel-k/pull/3778) ([milank78git](https://github.com/milank78git))
- fix\(e2e\): increase build timeout for native build tests: 40m -\> 60m [\#3776](https://github.com/apache/camel-k/pull/3776) ([tadayosi](https://github.com/tadayosi))
- chore\(deps\): bump github.com/stretchr/testify from 1.8.0 to 1.8.1 [\#3771](https://github.com/apache/camel-k/pull/3771) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/spf13/cobra from 1.6.0 to 1.6.1 [\#3770](https://github.com/apache/camel-k/pull/3770) ([dependabot[bot]](https://github.com/apps/dependabot))
- feat\(ci\): latest runtime snapshot available [\#3764](https://github.com/apache/camel-k/pull/3764) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/prometheus/client\_model from 0.2.0 to 0.3.0 [\#3752](https://github.com/apache/camel-k/pull/3752) ([dependabot[bot]](https://github.com/apps/dependabot))

## [pkg/kamelet/repository/v1.10.3](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.10.3) (2022-11-11)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.10.3...pkg/kamelet/repository/v1.10.3)

## [pkg/apis/camel/v1.10.3](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.10.3) (2022-11-11)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.10.3...pkg/apis/camel/v1.10.3)

## [v1.10.3](https://github.com/apache/camel-k/tree/v1.10.3) (2022-11-11)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.10.3...v1.10.3)

## [pkg/client/camel/v1.10.3](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.10.3) (2022-11-11)

[Full Changelog](https://github.com/apache/camel-k/compare/1.10.3-nightly...pkg/client/camel/v1.10.3)

**Closed issues:**

- Improve the user feedback when the integration kit fails [\#3779](https://github.com/apache/camel-k/issues/3779)
- KameletBinding in Error when prometheus trait is enabled [\#3775](https://github.com/apache/camel-k/issues/3775)
- E2E - No longer able to run native build tests with Quarkus 2.13.0 \(Camel Catalog 1.15.x\) [\#3773](https://github.com/apache/camel-k/issues/3773)
- Runtime trait failure [\#3758](https://github.com/apache/camel-k/issues/3758)
- Option ```--registry-insecure false``` takes no effect when using local dependencies ```-d file:///path/xxx.jar```  [\#3455](https://github.com/apache/camel-k/issues/3455)
- Unable to run an integration on Minikube [\#3442](https://github.com/apache/camel-k/issues/3442)
- Prometheus monitoring doc doesn't help to get monitoring working [\#3428](https://github.com/apache/camel-k/issues/3428)
- Upgrade can result in integration being rebuilt using the old integrationkit [\#3359](https://github.com/apache/camel-k/issues/3359)
- Integration Platform issues when using the Operator  [\#3297](https://github.com/apache/camel-k/issues/3297)
- Make knative broker name configurable [\#2864](https://github.com/apache/camel-k/issues/2864)
- integration platform: add conditions [\#2555](https://github.com/apache/camel-k/issues/2555)

## [1.10.3-nightly](https://github.com/apache/camel-k/tree/1.10.3-nightly) (2022-10-25)

[Full Changelog](https://github.com/apache/camel-k/compare/1.10.2...1.10.3-nightly)

**Merged pull requests:**

- fix\(ci\): add cluster type for nightly releases [\#3768](https://github.com/apache/camel-k/pull/3768) ([squakez](https://github.com/squakez))
- chore: update LAST\_RELEASED\_VERSION to 1.10.2 [\#3767](https://github.com/apache/camel-k/pull/3767) ([tadayosi](https://github.com/tadayosi))

## [1.10.2](https://github.com/apache/camel-k/tree/1.10.2) (2022-10-22)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.10.2...1.10.2)

**Closed issues:**

- Native E2E tests failing [\#3715](https://github.com/apache/camel-k/issues/3715)
- Unable to get basic hello.groovy example working on local single node KIND cluster [\#3349](https://github.com/apache/camel-k/issues/3349)
- Release 1.10.2 [\#3746](https://github.com/apache/camel-k/issues/3746)

**Merged pull requests:**

- chore\(ci\): clean actions [\#3759](https://github.com/apache/camel-k/pull/3759) ([squakez](https://github.com/squakez))
- Fix get\_catalog.sh when runtime is snapshot [\#3755](https://github.com/apache/camel-k/pull/3755) ([claudio4j](https://github.com/claudio4j))
- fix\(e2e\): stabilise TestNativeBinding [\#3747](https://github.com/apache/camel-k/pull/3747) ([tadayosi](https://github.com/tadayosi))
- fix\(e2e\): fix minor issue in e2e upgrade util.go [\#3745](https://github.com/apache/camel-k/pull/3745) ([tadayosi](https://github.com/tadayosi))
- change\(helm\): logLevel configuration enabled [\#3744](https://github.com/apache/camel-k/pull/3744) ([leewoobin789](https://github.com/leewoobin789))
- chore\(deps\): bump github.com/spf13/cobra from 1.5.0 to 1.6.0 [\#3742](https://github.com/apache/camel-k/pull/3742) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/onsi/gomega from 1.21.1 to 1.22.1 [\#3741](https://github.com/apache/camel-k/pull/3741) ([dependabot[bot]](https://github.com/apps/dependabot))
- Minor updates for bundle generation [\#3423](https://github.com/apache/camel-k/pull/3423) ([phantomjinx](https://github.com/phantomjinx))

## [pkg/apis/camel/v1.10.2](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.10.2) (2022-10-18)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.10.2...pkg/apis/camel/v1.10.2)

## [v1.10.2](https://github.com/apache/camel-k/tree/v1.10.2) (2022-10-18)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.10.2...v1.10.2)

## [pkg/kamelet/repository/v1.10.2](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.10.2) (2022-10-18)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.10.2...pkg/kamelet/repository/v1.10.2)

## [pkg/client/camel/v1.10.2](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.10.2) (2022-10-18)

[Full Changelog](https://github.com/apache/camel-k/compare/1.10.2-nightly...pkg/client/camel/v1.10.2)

**Closed issues:**

- Missing container image docker.io/apache/camel-k:1.10.1-SNAPSHOT [\#3720](https://github.com/apache/camel-k/issues/3720)

## [1.10.2-nightly](https://github.com/apache/camel-k/tree/1.10.2-nightly) (2022-10-14)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.10.1...1.10.2-nightly)

**Closed issues:**

- E2E native flaky tests [\#3726](https://github.com/apache/camel-k/issues/3726)
- The --add-repo switch fails with a global operator [\#3667](https://github.com/apache/camel-k/issues/3667)
- Should `make bundle` update kustomization.yaml? [\#3606](https://github.com/apache/camel-k/issues/3606)
- Release 1.10.1 [\#3605](https://github.com/apache/camel-k/issues/3605)

**Merged pull requests:**

- \#2758 documentation for kustomize installation [\#3738](https://github.com/apache/camel-k/pull/3738) ([phantomjinx](https://github.com/phantomjinx))
- Due to slower performance revert tests to sub-tests from separate functions [\#3737](https://github.com/apache/camel-k/pull/3737) ([phantomjinx](https://github.com/phantomjinx))
- chore: gotestfmt is renamed to gotesttools/gotestfmt [\#3735](https://github.com/apache/camel-k/pull/3735) ([tadayosi](https://github.com/tadayosi))
- feat\(cli\): Make add-repo and remove-repo compatible with a global operator [\#3731](https://github.com/apache/camel-k/pull/3731) ([essobedo](https://github.com/essobedo))
- chore\(deps\): bump github.com/redhat-developer/service-binding-operator from 1.2.0 to 1.3.0 [\#3727](https://github.com/apache/camel-k/pull/3727) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(cli\): don't verify operator [\#3723](https://github.com/apache/camel-k/pull/3723) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/onsi/gomega from 1.20.2 to 1.21.1 [\#3722](https://github.com/apache/camel-k/pull/3722) ([dependabot[bot]](https://github.com/apps/dependabot))
- e2e: test fixes and bug fixes from test runs [\#3716](https://github.com/apache/camel-k/pull/3716) ([phantomjinx](https://github.com/phantomjinx))
- fix\(ci\): build resources before testing [\#3714](https://github.com/apache/camel-k/pull/3714) ([squakez](https://github.com/squakez))
- chore: add test-fmt make target [\#3712](https://github.com/apache/camel-k/pull/3712) ([tadayosi](https://github.com/tadayosi))
- chore: Upgrade go.uber.org/automaxprocs to v1.5.1 [\#3711](https://github.com/apache/camel-k/pull/3711) ([astefanutti](https://github.com/astefanutti))
- chore: Use global client discovery API to check Knative install [\#3701](https://github.com/apache/camel-k/pull/3701) ([astefanutti](https://github.com/astefanutti))
- Update camel quarkus micropofile metrics doc [\#3698](https://github.com/apache/camel-k/pull/3698) ([zbendhiba](https://github.com/zbendhiba))
- Remove deprecated spectrum fix [\#3693](https://github.com/apache/camel-k/pull/3693) ([tadayosi](https://github.com/tadayosi))
- chore: Add client argument to controllers [\#3681](https://github.com/apache/camel-k/pull/3681) ([astefanutti](https://github.com/astefanutti))
- chore: Propagate reconcilation context to build routine [\#3678](https://github.com/apache/camel-k/pull/3678) ([astefanutti](https://github.com/astefanutti))
- chore\(deps\): bump github.com/container-tools/spectrum from 0.3.10 to 0.3.11 [\#3675](https://github.com/apache/camel-k/pull/3675) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(test\): KameletBinding native mode [\#3670](https://github.com/apache/camel-k/pull/3670) ([bouskaJ](https://github.com/bouskaJ))
- doc: add kamel promote [\#3665](https://github.com/apache/camel-k/pull/3665) ([squakez](https://github.com/squakez))
- chore: enable latest LTS nightly [\#3663](https://github.com/apache/camel-k/pull/3663) ([squakez](https://github.com/squakez))
- trait\(ingress\): Configure backend in ingress rule [\#3652](https://github.com/apache/camel-k/pull/3652) ([astefanutti](https://github.com/astefanutti))
- chore\(ci\): experimental use of gotestfmt for e2e [\#3651](https://github.com/apache/camel-k/pull/3651) ([tadayosi](https://github.com/tadayosi))
- chore\(deps\): bump github.com/redhat-developer/service-binding-operator from 1.1.1 to 1.2.0 [\#3637](https://github.com/apache/camel-k/pull/3637) ([dependabot[bot]](https://github.com/apps/dependabot))
- Improvements to OLM bundle building of test index [\#3527](https://github.com/apache/camel-k/pull/3527) ([phantomjinx](https://github.com/phantomjinx))

## [pkg/kamelet/repository/v1.10.1](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.10.1) (2022-10-10)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.10.1...pkg/kamelet/repository/v1.10.1)

## [pkg/apis/camel/v1.10.1](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.10.1) (2022-10-10)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.10.1...pkg/apis/camel/v1.10.1)

## [v1.10.1](https://github.com/apache/camel-k/tree/v1.10.1) (2022-10-10)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.10.1...v1.10.1)

## [pkg/client/camel/v1.10.1](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.10.1) (2022-10-10)

[Full Changelog](https://github.com/apache/camel-k/compare/1.10.1-nightly...pkg/client/camel/v1.10.1)

**Closed issues:**

- Cannot build the project, likely `gotestfmt` [\#3677](https://github.com/apache/camel-k/issues/3677)
- Add an info after `kamel promote` [\#3676](https://github.com/apache/camel-k/issues/3676)
- Allow continuous deployment for `kamel promote` [\#3673](https://github.com/apache/camel-k/issues/3673)
- Can't run KameletBinding with the native mode [\#3671](https://github.com/apache/camel-k/issues/3671)
- kamel local run: extension to "build and output" CRs  [\#3662](https://github.com/apache/camel-k/issues/3662)
- OLM installtion needs to set KAMEL\_OPERATOR\_ID EnvVar [\#3657](https://github.com/apache/camel-k/issues/3657)
- Provide documentation for LTS support [\#3647](https://github.com/apache/camel-k/issues/3647)
- Wrong compatibility matrix [\#3622](https://github.com/apache/camel-k/issues/3622)
- 1.10.x Smoke test failure TestBindingWithImage [\#3619](https://github.com/apache/camel-k/issues/3619)
- Nightly release 1.9.x missing tests [\#3613](https://github.com/apache/camel-k/issues/3613)
- `kamel promote` documentation [\#3375](https://github.com/apache/camel-k/issues/3375)
- Kamel install error on Minikube [\#3348](https://github.com/apache/camel-k/issues/3348)
- Camel route terminates when route takes longer than 5 minutes [\#3335](https://github.com/apache/camel-k/issues/3335)
- \[E2E\] Split integration test suite for kubernetes and openshift CI workflows [\#3210](https://github.com/apache/camel-k/issues/3210)
- \[regression\] Cannot provide 2 resources with 1.8.0 and 1.8.1 [\#3077](https://github.com/apache/camel-k/issues/3077)

## [1.10.1-nightly](https://github.com/apache/camel-k/tree/1.10.1-nightly) (2022-09-20)

[Full Changelog](https://github.com/apache/camel-k/compare/1.11.0-nightly...1.10.1-nightly)

**Closed issues:**

- `make bundle` failure [\#3602](https://github.com/apache/camel-k/issues/3602)
- Parametrize kaniko executor image to point to private registry [\#3350](https://github.com/apache/camel-k/issues/3350)
- kamel uninstall --all does not remove Kamelets [\#3342](https://github.com/apache/camel-k/issues/3342)
- Configure parallel container image layers push based on CPU quota [\#3340](https://github.com/apache/camel-k/issues/3340)
- Configure Maven builds based on CPU quota [\#3339](https://github.com/apache/camel-k/issues/3339)
- Add a `kamel install --publish-strategy-option` [\#3308](https://github.com/apache/camel-k/issues/3308)
- Simple KameletBinding created with Errors [\#3299](https://github.com/apache/camel-k/issues/3299)
- Proposal: Clarify the description for the Operator in the OLM catalog [\#3267](https://github.com/apache/camel-k/issues/3267)
- Flaky E2E tests identified in 1.9.x [\#3234](https://github.com/apache/camel-k/issues/3234)
- kamel log tail option [\#3004](https://github.com/apache/camel-k/issues/3004)
- Builder/Camel trait configmap/secret beside properties [\#3002](https://github.com/apache/camel-k/issues/3002)
- Provide a command to add a repo for custom Kamelet catalog [\#2850](https://github.com/apache/camel-k/issues/2850)
- Ability to set labels on knative service \(for things like "cluster-local"\) [\#1712](https://github.com/apache/camel-k/issues/1712)
- Allow overriding of buildah image with "kamel install" switches [\#1424](https://github.com/apache/camel-k/issues/1424)
- kamel CLI - Allow to specify a namespace to use instead of default [\#1184](https://github.com/apache/camel-k/issues/1184)
- Create a Github Action for Camel K [\#1163](https://github.com/apache/camel-k/issues/1163)
- Camel K doesn't support kubernetes services of type loadbalancer [\#1070](https://github.com/apache/camel-k/issues/1070)
- Camel-K operator should clean up kits and kit builders after integrations are deleted [\#889](https://github.com/apache/camel-k/issues/889)
- support for multiple type of builders [\#687](https://github.com/apache/camel-k/issues/687)
- Let dependencies be defined using HTTP URLs [\#240](https://github.com/apache/camel-k/issues/240)

**Merged pull requests:**

- Fix README in examples/openapi [\#3655](https://github.com/apache/camel-k/pull/3655) ([halmakidon](https://github.com/halmakidon))
- fix: release action to use secrets properly [\#3648](https://github.com/apache/camel-k/pull/3648) ([squakez](https://github.com/squakez))
- fix: release as an action [\#3646](https://github.com/apache/camel-k/pull/3646) ([squakez](https://github.com/squakez))
- feat\(cli/run\): Support dependencies defined using HTTP URLs [\#3644](https://github.com/apache/camel-k/pull/3644) ([essobedo](https://github.com/essobedo))
- Fix Camel website build by removing invalid link [\#3642](https://github.com/apache/camel-k/pull/3642) ([apupier](https://github.com/apupier))
- fix: release as an action [\#3636](https://github.com/apache/camel-k/pull/3636) ([squakez](https://github.com/squakez))
- Fixed helm install failing [\#3634](https://github.com/apache/camel-k/pull/3634) ([halmakidon](https://github.com/halmakidon))
- Update documentation for kamelet type that can also be action [\#3632](https://github.com/apache/camel-k/pull/3632) ([apupier](https://github.com/apupier))
- test: Use camel-k repo in the test for the add-repo command [\#3630](https://github.com/apache/camel-k/pull/3630) ([essobedo](https://github.com/essobedo))
- fix: release as an action [\#3629](https://github.com/apache/camel-k/pull/3629) ([squakez](https://github.com/squakez))
- migrate and improve master example [\#3627](https://github.com/apache/camel-k/pull/3627) ([KuthumiPepple](https://github.com/KuthumiPepple))
- fix: release as an action [\#3625](https://github.com/apache/camel-k/pull/3625) ([squakez](https://github.com/squakez))
- chore\(ci\): release as an action [\#3621](https://github.com/apache/camel-k/pull/3621) ([squakez](https://github.com/squakez))
- feat\(trait\): Provide the service type from the trait configuration [\#3618](https://github.com/apache/camel-k/pull/3618) ([essobedo](https://github.com/essobedo))
- Fix panics when integration is waiting for platform [\#3616](https://github.com/apache/camel-k/pull/3616) ([astefanutti](https://github.com/astefanutti))
- fix: do not run smoke tests on 1.9 nightly [\#3614](https://github.com/apache/camel-k/pull/3614) ([squakez](https://github.com/squakez))
- feat: Auto-create platform when registry can be inferred from KEP-1755 [\#3612](https://github.com/apache/camel-k/pull/3612) ([astefanutti](https://github.com/astefanutti))
- fix: Panic with odd number of key / value arguments [\#3610](https://github.com/apache/camel-k/pull/3610) ([astefanutti](https://github.com/astefanutti))
- chore\(deps\): bump github.com/spf13/viper from 1.12.0 to 1.13.0 [\#3609](https://github.com/apache/camel-k/pull/3609) ([dependabot[bot]](https://github.com/apps/dependabot))
- \[TEST\] OLM fresh install test [\#3593](https://github.com/apache/camel-k/pull/3593) ([bouskaJ](https://github.com/bouskaJ))

## [1.11.0-nightly](https://github.com/apache/camel-k/tree/1.11.0-nightly) (2022-09-06)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.10.0...1.11.0-nightly)

**Closed issues:**

- Test failing after release update [\#3600](https://github.com/apache/camel-k/issues/3600)
- Validate failure in CI [\#3591](https://github.com/apache/camel-k/issues/3591)
- Add back beginner examples [\#3579](https://github.com/apache/camel-k/issues/3579)
- 1.10.0 Release [\#3560](https://github.com/apache/camel-k/issues/3560)
- TestOperatorIDFiltering/Operators\_can\_handoff\_scoped\_integrations test failing [\#3542](https://github.com/apache/camel-k/issues/3542)
- `golangci-lint` version `1.47.2` reports more errors [\#3536](https://github.com/apache/camel-k/issues/3536)
- CPU Spikes on Openshift with unusual operator behaviour [\#3441](https://github.com/apache/camel-k/issues/3441)
- ERROR: could not find any knative type in namespace default, last error was: the server could not find the requested resource [\#3430](https://github.com/apache/camel-k/issues/3430)
- Release documentation: Review steps and make it a bit more complete for new release manager [\#2931](https://github.com/apache/camel-k/issues/2931)

**Merged pull requests:**

- chore: add a post release bump chapter [\#3608](https://github.com/apache/camel-k/pull/3608) ([squakez](https://github.com/squakez))
- chore\(ci\): support 1.10.x nightly release [\#3607](https://github.com/apache/camel-k/pull/3607) ([squakez](https://github.com/squakez))
- fix\(e2e\): codegen [\#3601](https://github.com/apache/camel-k/pull/3601) ([squakez](https://github.com/squakez))
- fix\(e2e\): relax constraints for builder kit full build test [\#3597](https://github.com/apache/camel-k/pull/3597) ([tadayosi](https://github.com/tadayosi))
- chore\(deps\): bump github.com/onsi/gomega from 1.20.1 to 1.20.2 [\#3596](https://github.com/apache/camel-k/pull/3596) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(lint\): suppress nolintlint - unused staticcheck [\#3592](https://github.com/apache/camel-k/pull/3592) ([tadayosi](https://github.com/tadayosi))
- fix\(e2e\): fix TestBindingWithImage [\#3590](https://github.com/apache/camel-k/pull/3590) ([tadayosi](https://github.com/tadayosi))
- Update the staging repository for camel-k-runtime 1.14.0 [\#3588](https://github.com/apache/camel-k/pull/3588) ([oscerd](https://github.com/oscerd))
- fix: Panic with odd number of key / value arguments [\#3587](https://github.com/apache/camel-k/pull/3587) ([astefanutti](https://github.com/astefanutti))
- test: Add an E2E test for deploying an it using secret key filtering [\#3585](https://github.com/apache/camel-k/pull/3585) ([essobedo](https://github.com/essobedo))
- fix\(e2e\): fix TestHealthTrait for upgraded Camel 3.18.x [\#3584](https://github.com/apache/camel-k/pull/3584) ([tadayosi](https://github.com/tadayosi))
- fix\(e2e\): attempt to stabilise TestNativeIntegrations [\#3583](https://github.com/apache/camel-k/pull/3583) ([tadayosi](https://github.com/tadayosi))
- chore\(deps\): bump github.com/onsi/gomega from 1.20.0 to 1.20.1 [\#3581](https://github.com/apache/camel-k/pull/3581) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(e2e\): make package-artifacts to be aware of staging repo [\#3578](https://github.com/apache/camel-k/pull/3578) ([tadayosi](https://github.com/tadayosi))
- fix\(e2e\): local test when staging [\#3574](https://github.com/apache/camel-k/pull/3574) ([squakez](https://github.com/squakez))
- chore\(build\): Use global operator in YAKS E2E tests [\#3573](https://github.com/apache/camel-k/pull/3573) ([christophd](https://github.com/christophd))
- chore\(deps\): bump go.uber.org/zap from 1.22.0 to 1.23.0 [\#3570](https://github.com/apache/camel-k/pull/3570) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(knative\): Remove obsolete Knative service beta v1 mappings [\#3569](https://github.com/apache/camel-k/pull/3569) ([christophd](https://github.com/christophd))
- chore\(build\): Restrict release workflow execution [\#3568](https://github.com/apache/camel-k/pull/3568) ([christophd](https://github.com/christophd))
- Update the staging repository for camel-k-runtime 1.14.0 [\#3567](https://github.com/apache/camel-k/pull/3567) ([oscerd](https://github.com/oscerd))
- Add preliminary support for the resume API [\#3566](https://github.com/apache/camel-k/pull/3566) ([orpiske](https://github.com/orpiske))
- migrate and improve knative example [\#3565](https://github.com/apache/camel-k/pull/3565) ([KuthumiPepple](https://github.com/KuthumiPepple))
- Camel k runtime 1.14.0 as Default [\#3564](https://github.com/apache/camel-k/pull/3564) ([oscerd](https://github.com/oscerd))
- chore\(deps\): bump github.com/go-logr/logr from 1.2.2 to 1.2.3 [\#3562](https://github.com/apache/camel-k/pull/3562) ([dependabot[bot]](https://github.com/apps/dependabot))
- Release 1.10.0: Staging camel-k-runtime 1.14.0 and kamelet-catalog 0.9.0 tag [\#3561](https://github.com/apache/camel-k/pull/3561) ([oscerd](https://github.com/oscerd))
- migrate and improve kamelets example [\#3559](https://github.com/apache/camel-k/pull/3559) ([KuthumiPepple](https://github.com/KuthumiPepple))
- chore: add pod tolerations options to operator [\#3557](https://github.com/apache/camel-k/pull/3557) ([zhiminglim](https://github.com/zhiminglim))
- feat\(cli\): Force arguments for the rebuild command [\#3556](https://github.com/apache/camel-k/pull/3556) ([essobedo](https://github.com/essobedo))
- chore\(cli\): refactor run cmd to remove nolint maintidx [\#3555](https://github.com/apache/camel-k/pull/3555) ([tadayosi](https://github.com/tadayosi))
- migrate and improve languages example [\#3554](https://github.com/apache/camel-k/pull/3554) ([KuthumiPepple](https://github.com/KuthumiPepple))
- fix: properly set annotations and labels to Kamelets [\#3553](https://github.com/apache/camel-k/pull/3553) ([essobedo](https://github.com/essobedo))
- chore: Upgrade k8s and Knative dependencies [\#3552](https://github.com/apache/camel-k/pull/3552) ([astefanutti](https://github.com/astefanutti))
- fix\(knative\): Fix the knative pods created until exhaustion [\#3548](https://github.com/apache/camel-k/pull/3548) ([claudio4j](https://github.com/claudio4j))
- fix\(rbac\): missing clusterrolebinding permission [\#3547](https://github.com/apache/camel-k/pull/3547) ([claudio4j](https://github.com/claudio4j))
- Feat\(trait\): Knative service visibility support [\#3546](https://github.com/apache/camel-k/pull/3546) ([halmakidon](https://github.com/halmakidon))
- Add operator global option when installing with Helm Chart [\#3545](https://github.com/apache/camel-k/pull/3545) ([zhiminglim](https://github.com/zhiminglim))
- fix\(trait\): force a volume path when key is set [\#3544](https://github.com/apache/camel-k/pull/3544) ([essobedo](https://github.com/essobedo))
- Remove overinstalling the timer kamelet [\#3515](https://github.com/apache/camel-k/pull/3515) ([bouskaJ](https://github.com/bouskaJ))
- chore\(build\): Use Camel K runtime Maven structural logging module [\#3376](https://github.com/apache/camel-k/pull/3376) ([christophd](https://github.com/christophd))
- fix\(knative\): Make knative broker name configurable [\#3373](https://github.com/apache/camel-k/pull/3373) ([claudio4j](https://github.com/claudio4j))
- chore\(build\): let bom managed by camel k runtime [\#3317](https://github.com/apache/camel-k/pull/3317) ([squakez](https://github.com/squakez))

## [pkg/client/camel/v1.10.0](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.10.0) (2022-08-31)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.10.0...pkg/client/camel/v1.10.0)

## [v1.10.0](https://github.com/apache/camel-k/tree/v1.10.0) (2022-08-31)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.10.0...v1.10.0)

## [pkg/kamelet/repository/v1.10.0](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.10.0) (2022-08-31)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.10.0...pkg/kamelet/repository/v1.10.0)

## [pkg/apis/camel/v1.10.0](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.10.0) (2022-08-31)

[Full Changelog](https://github.com/apache/camel-k/compare/1.8.3-nightly...pkg/apis/camel/v1.10.0)

**Closed issues:**

- Base Image is pulled via http instead of https [\#3577](https://github.com/apache/camel-k/issues/3577)
- How to run a Camel process as a cron job \(other than a timer\) [\#3575](https://github.com/apache/camel-k/issues/3575)
- Add E2E test for deploying an integration using configmap/secret key filtering [\#3563](https://github.com/apache/camel-k/issues/3563)
- load camel-cxf in camel-k integration [\#3550](https://github.com/apache/camel-k/issues/3550)
- Cannot deploy an integration using configmap/secret key filtering [\#3543](https://github.com/apache/camel-k/issues/3543)
- In a specific scenario a new integration pod is created every ~0.5 seconds [\#3522](https://github.com/apache/camel-k/issues/3522)
- `make generate-crd` error [\#3453](https://github.com/apache/camel-k/issues/3453)
- `kamel rebuild` default should not rebuild all Integrations [\#3445](https://github.com/apache/camel-k/issues/3445)
- Update to Knative v1.5.0 [\#3381](https://github.com/apache/camel-k/issues/3381)
- kamel local build is writing on stderr with Maven dependency specified as modeline even if it is working [\#3252](https://github.com/apache/camel-k/issues/3252)
- Unable to access MongoDB from kamelets binding \[DOCS bug\] [\#3228](https://github.com/apache/camel-k/issues/3228)
- Update the DSL yaml doc about the extension section [\#3151](https://github.com/apache/camel-k/issues/3151)

## [1.8.3-nightly](https://github.com/apache/camel-k/tree/1.8.3-nightly) (2022-08-16)

[Full Changelog](https://github.com/apache/camel-k/compare/1.9.3-nightly...1.8.3-nightly)

## [1.9.3-nightly](https://github.com/apache/camel-k/tree/1.9.3-nightly) (2022-08-16)

[Full Changelog](https://github.com/apache/camel-k/compare/1.10.0-nightly...1.9.3-nightly)

**Closed issues:**

- Passing namespace info for CXF Endpoint in Camel-K YAML DSL [\#3503](https://github.com/apache/camel-k/issues/3503)
- Trait owner.target-annotations is not propagated to K8S Services [\#3494](https://github.com/apache/camel-k/issues/3494)
- Release nightly fails [\#3492](https://github.com/apache/camel-k/issues/3492)
- Kamel install error on Kind [\#3483](https://github.com/apache/camel-k/issues/3483)
- camel-k ignores changes to traits configured using annotations [\#3479](https://github.com/apache/camel-k/issues/3479)
- Integration cannot be run from github with different branch [\#3475](https://github.com/apache/camel-k/issues/3475)
- `make images` is not building the binary [\#3474](https://github.com/apache/camel-k/issues/3474)
- `kamel operator` does not work locally [\#3472](https://github.com/apache/camel-k/issues/3472)
- `install-it` workflow is failing silently [\#3465](https://github.com/apache/camel-k/issues/3465)
- Declaring multiple traits in KameletBinding fails badly [\#3458](https://github.com/apache/camel-k/issues/3458)
- `camel-k-operator` pod in `CrashLoopBackOff` [\#3456](https://github.com/apache/camel-k/issues/3456)
- Option `--maven-repository` on kamel run command has no effect [\#3447](https://github.com/apache/camel-k/issues/3447)
- `make generate-doc` outputs non-deterministic `resources/traits.yaml` [\#3431](https://github.com/apache/camel-k/issues/3431)
- Any ideas on disabling property expansion in kamel run? [\#3422](https://github.com/apache/camel-k/issues/3422)
- Camel K integration Prometheus Trait label autocreation with Integration Platform not working [\#3415](https://github.com/apache/camel-k/issues/3415)
- Example readme page 404 links [\#3413](https://github.com/apache/camel-k/issues/3413)
- Failing integration does not report error condition [\#3412](https://github.com/apache/camel-k/issues/3412)
- Set log-level on Camel K operator not working [\#3399](https://github.com/apache/camel-k/issues/3399)
- kamel run --output yaml does not include resources [\#3396](https://github.com/apache/camel-k/issues/3396)
- Migrate from batch/v1beta1 to batch/v1 [\#3393](https://github.com/apache/camel-k/issues/3393)
- RBAC missing permissions for channels and inmemorychannels in messaging.knative.dev [\#3390](https://github.com/apache/camel-k/issues/3390)
- Update to golangci-lint 1.46.x [\#3387](https://github.com/apache/camel-k/issues/3387)
- kamel local run support --build-property ? [\#3356](https://github.com/apache/camel-k/issues/3356)
- Configmap properties changes are not being detected in dev mode [\#3347](https://github.com/apache/camel-k/issues/3347)
- How to deal with `SNAPSHOT` dependencies? [\#3341](https://github.com/apache/camel-k/issues/3341)
- CamelK 1.9.2 when installed via OLM "system:serviceaccount:openshift-operators:camel-k-operator" cannot get resource "channels" in API group "messaging.knative.dev" [\#3328](https://github.com/apache/camel-k/issues/3328)
- `make bundle` adds duplicate `replaces` to Camel K CSV [\#3321](https://github.com/apache/camel-k/issues/3321)
- E2E repeated failure [\#3315](https://github.com/apache/camel-k/issues/3315)
- Integrations, IntegrationKits, IntegrationPlatforms are not owned by Namespaces [\#3311](https://github.com/apache/camel-k/issues/3311)
- kamel local build:failure while building project: exit status 1 [\#3307](https://github.com/apache/camel-k/issues/3307)
- Helm Chart for camel-k 1.9.2 is invalid [\#3300](https://github.com/apache/camel-k/issues/3300)
- Our preference on defining multiple e2e tests [\#3298](https://github.com/apache/camel-k/issues/3298)
- Kamel run default service nodePort is invalid [\#3296](https://github.com/apache/camel-k/issues/3296)
- Integration upgraded automatically after operator upgrade [\#3294](https://github.com/apache/camel-k/issues/3294)
- `kamel rebuild` does not seem to work [\#3293](https://github.com/apache/camel-k/issues/3293)
- Dependency doc is wrong about how to add camel components [\#3291](https://github.com/apache/camel-k/issues/3291)
- Cannot find RestProducerFactory in Registry or as a Component to use" [\#3290](https://github.com/apache/camel-k/issues/3290)
- Never stale a bug issue [\#3283](https://github.com/apache/camel-k/issues/3283)
- Moving main to 1.10.0-SNAPSHOT [\#3280](https://github.com/apache/camel-k/issues/3280)
- Release 1.9.2 [\#3275](https://github.com/apache/camel-k/issues/3275)
- TestOLMAutomaticUpgrade test failing in 1.9.x [\#3261](https://github.com/apache/camel-k/issues/3261)
- 1.9.x TestHealthTrait/Readiness\_condition\_with\_stopped\_route failure [\#3258](https://github.com/apache/camel-k/issues/3258)
- Release 1.9.0 - Failure to install via OLM [\#3246](https://github.com/apache/camel-k/issues/3246)
- `make generate-doc` doesn't update CRD API doc when using Go 1.16.x [\#3236](https://github.com/apache/camel-k/issues/3236)
- Add e2e test for kamel run --dev in a warmed-up environment [\#3211](https://github.com/apache/camel-k/issues/3211)
- Nil pointer dereference tracing trait [\#3205](https://github.com/apache/camel-k/issues/3205)
- E2E errors in `1.8.x` [\#3191](https://github.com/apache/camel-k/issues/3191)
- Improve the reliability of e2e tests by installing operator globally as a pre-requisite. [\#3183](https://github.com/apache/camel-k/issues/3183)
- Add `.status.observedGeneration` to Camel K CRDs [\#3182](https://github.com/apache/camel-k/issues/3182)
- simplify platforms handling/configuration [\#3164](https://github.com/apache/camel-k/issues/3164)
- Service Binding trait usage example [\#3147](https://github.com/apache/camel-k/issues/3147)
- Route trait usage example [\#3146](https://github.com/apache/camel-k/issues/3146)
- PDB trait usage example [\#3145](https://github.com/apache/camel-k/issues/3145)
- Logging trait usage example [\#3143](https://github.com/apache/camel-k/issues/3143)
- Knative trait usage example [\#3142](https://github.com/apache/camel-k/issues/3142)
- Camel K operator scaling documentation [\#3133](https://github.com/apache/camel-k/issues/3133)
- Support operator hub bundle format in `make bundle` [\#3128](https://github.com/apache/camel-k/issues/3128)
- hello yaml example output [\#3124](https://github.com/apache/camel-k/issues/3124)
- java.lang.ClassNotFoundException: io.quarkus.bootstrap.runner.QuarkusEntryPoint after k8s node update [\#3122](https://github.com/apache/camel-k/issues/3122)
- E2E failing in release-1.8.x [\#3120](https://github.com/apache/camel-k/issues/3120)
- cyrus-sasl-lib \(CVE-2022-24407\), CVE-2022-23806 and multiple go related vulnerabilities in Docker Image 1.7.0, 1.8.1, 1.8.2 [\#3113](https://github.com/apache/camel-k/issues/3113)
- More user-friendly error messages for `kamel local` subcommands [\#3028](https://github.com/apache/camel-k/issues/3028)
- OLM scorecard tests missing [\#3022](https://github.com/apache/camel-k/issues/3022)
- cron.concurrency-policy does not work correctly [\#3019](https://github.com/apache/camel-k/issues/3019)
- kamel uninstall seems to remain some resources in the cluster [\#3013](https://github.com/apache/camel-k/issues/3013)
- Access channel in different namespace [\#3009](https://github.com/apache/camel-k/issues/3009)
- Operator creates too many repositories [\#3003](https://github.com/apache/camel-k/issues/3003)
- Improve message error when IntegrationPlatform failure [\#2996](https://github.com/apache/camel-k/issues/2996)
- Release: scripting Renaming files for operator works [\#2984](https://github.com/apache/camel-k/issues/2984)
- Autoscaling not working [\#2982](https://github.com/apache/camel-k/issues/2982)
- Modify e2e tests so that if failed the tests is repeated in a new namespace [\#2965](https://github.com/apache/camel-k/issues/2965)
- Update readiness condition based on new Camel health check format [\#2886](https://github.com/apache/camel-k/issues/2886)
- IntegrationPlatform camel-k hardcoded name causes wrong assumptions [\#2883](https://github.com/apache/camel-k/issues/2883)
- Using REST as consumer and producer appends PATH to producer URL [\#2867](https://github.com/apache/camel-k/issues/2867)
- Use deprecated field of yaml schema specification instead of only modifying description [\#2817](https://github.com/apache/camel-k/issues/2817)
- Adding mavens settings-security.xml to the spec.build.maven is not possible [\#2747](https://github.com/apache/camel-k/issues/2747)
- Integration won't rollout with changes outside spec [\#2648](https://github.com/apache/camel-k/issues/2648)
- Kamel 1.5.1 CLI generates broken zsh completions [\#2622](https://github.com/apache/camel-k/issues/2622)
- ImagePullBackOff when node failed [\#2485](https://github.com/apache/camel-k/issues/2485)
- Debug seems not to work on knative pods [\#2474](https://github.com/apache/camel-k/issues/2474)
- Groovy script JSON paring runs into java.util.ServiceConfigurationError: org.apache.groovy.json.FastStringServiceFactory: org.apache.groovy.json.DefaultFastStringServiceFactory not a subtype [\#2418](https://github.com/apache/camel-k/issues/2418)
- Migrate CronJob to `batch/v1` [\#2408](https://github.com/apache/camel-k/issues/2408)
- re-deployment strategies [\#2256](https://github.com/apache/camel-k/issues/2256)
- `kamel local build` doesn't support same dependency notation [\#2213](https://github.com/apache/camel-k/issues/2213)
- Provide option to have symbolic link for kamel local build --integration-directory \<folder\> [\#2179](https://github.com/apache/camel-k/issues/2179)
- Global vs local operator  [\#2177](https://github.com/apache/camel-k/issues/2177)
- Refactoring dump function [\#2172](https://github.com/apache/camel-k/issues/2172)
- In troubleshooting documentation section, provide information on which logs to look at [\#2031](https://github.com/apache/camel-k/issues/2031)
- Make the Camel K operator more involved in the Knative SinkBinding flow [\#1976](https://github.com/apache/camel-k/issues/1976)
- Take into account consumer/producer dependencies [\#1808](https://github.com/apache/camel-k/issues/1808)
- Camel K on GKE doesn't seem to work [\#1770](https://github.com/apache/camel-k/issues/1770)
- Populate Knative event registry when using KameletBinding [\#1689](https://github.com/apache/camel-k/issues/1689)
- List of supported versions combinations for running Camel-K with Knative [\#1665](https://github.com/apache/camel-k/issues/1665)
- Import release notes from Camel K Runtime on release [\#1623](https://github.com/apache/camel-k/issues/1623)
- Traits configuration schema [\#1614](https://github.com/apache/camel-k/issues/1614)
- Drop OpenShift 3 support [\#1550](https://github.com/apache/camel-k/issues/1550)
- No way to configure Ingress Trait with annotations [\#1535](https://github.com/apache/camel-k/issues/1535)
- kamel run directory \(self contained\) [\#1523](https://github.com/apache/camel-k/issues/1523)
- Modeline and file-based options on http/github endpoints [\#1522](https://github.com/apache/camel-k/issues/1522)
- OLM: enable support for OperatorGroup [\#1471](https://github.com/apache/camel-k/issues/1471)
- create trait to configure the http layer [\#1406](https://github.com/apache/camel-k/issues/1406)
- MicroK8s' built-in registry declared for the Camel K installation, but not used - integration installations fail [\#1376](https://github.com/apache/camel-k/issues/1376)
- Detect components from xxx.properties [\#1363](https://github.com/apache/camel-k/issues/1363)
- Add a compatibility matrix in documentation related to knative vs camel-k version [\#1336](https://github.com/apache/camel-k/issues/1336)
- watch of \*v1.ConfigMap ended with: too old resource version [\#1296](https://github.com/apache/camel-k/issues/1296)
- Restful sample does not work [\#589](https://github.com/apache/camel-k/issues/589)
- Improve IDE compatibility [\#564](https://github.com/apache/camel-k/issues/564)
- create test suite [\#558](https://github.com/apache/camel-k/issues/558)
- Refactor roles to simplify them [\#516](https://github.com/apache/camel-k/issues/516)
- CRD's without cluster admin access / No direct network access from cluster [\#512](https://github.com/apache/camel-k/issues/512)
- Improving kamel install [\#481](https://github.com/apache/camel-k/issues/481)
- Allow to remap headers to cloudevents headers [\#361](https://github.com/apache/camel-k/issues/361)
- Automatically add release notes on github releases [\#354](https://github.com/apache/camel-k/issues/354)
- Add status check that generated files have been committed [\#345](https://github.com/apache/camel-k/issues/345)
- support for dependencies archive [\#334](https://github.com/apache/camel-k/issues/334)
- Invistegate wg-serverless workflow support [\#327](https://github.com/apache/camel-k/issues/327)
- Reintegrate new doc in antora website [\#299](https://github.com/apache/camel-k/issues/299)
- build camel-k on windows linux subsystem \(ubuntu\) [\#214](https://github.com/apache/camel-k/issues/214)
- build camel-k on windows [\#213](https://github.com/apache/camel-k/issues/213)
- Evaluate how to add tracing information [\#78](https://github.com/apache/camel-k/issues/78)
- Improve user guide [\#37](https://github.com/apache/camel-k/issues/37)

**Merged pull requests:**

- fix actions/setup-java parameters [\#3549](https://github.com/apache/camel-k/pull/3549) ([lburgazzoli](https://github.com/lburgazzoli))
- doc: local operator id procedure [\#3540](https://github.com/apache/camel-k/pull/3540) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/onsi/gomega from 1.19.0 to 1.20.0 [\#3538](https://github.com/apache/camel-k/pull/3538) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix wrong workflow name [\#3535](https://github.com/apache/camel-k/pull/3535) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(deps\): bump go.uber.org/zap from 1.21.0 to 1.22.0 [\#3534](https://github.com/apache/camel-k/pull/3534) ([dependabot[bot]](https://github.com/apps/dependabot))
- Test operator image installed by the OLM [\#3531](https://github.com/apache/camel-k/pull/3531) ([bouskaJ](https://github.com/bouskaJ))
- chore\(deps\): bump github.com/prometheus/client\_golang from 1.12.2 to 1.13.0 [\#3530](https://github.com/apache/camel-k/pull/3530) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/sirupsen/logrus from 1.8.1 to 1.9.0 [\#3529](https://github.com/apache/camel-k/pull/3529) ([dependabot[bot]](https://github.com/apps/dependabot))
- delete unreachable code caused by log.Fatalln [\#3526](https://github.com/apache/camel-k/pull/3526) ([Abirdcfly](https://github.com/Abirdcfly))
- \[TEST\] Test container command [\#3521](https://github.com/apache/camel-k/pull/3521) ([bouskaJ](https://github.com/bouskaJ))
- feat: also build 1.9.x and 1.8.x as part of nightly builds [\#3520](https://github.com/apache/camel-k/pull/3520) ([lburgazzoli](https://github.com/lburgazzoli))
- Add missing import in kamelets-dev.adoc [\#3518](https://github.com/apache/camel-k/pull/3518) ([essobedo](https://github.com/essobedo))
- ensure gobin exists before copying operator-sdk [\#3517](https://github.com/apache/camel-k/pull/3517) ([lburgazzoli](https://github.com/lburgazzoli))
- fix: fix invalid type mapping for operator resources and securityContext [\#3516](https://github.com/apache/camel-k/pull/3516) ([zhiminglim](https://github.com/zhiminglim))
- Some improvements in runtime-resources.adoc [\#3513](https://github.com/apache/camel-k/pull/3513) ([essobedo](https://github.com/essobedo))
- Some various improvements in runtime-config.adoc [\#3512](https://github.com/apache/camel-k/pull/3512) ([essobedo](https://github.com/essobedo))
- re-deployment strategies [\#3511](https://github.com/apache/camel-k/pull/3511) ([lburgazzoli](https://github.com/lburgazzoli))
- Some improvements in runtime-properties.adoc [\#3510](https://github.com/apache/camel-k/pull/3510) ([essobedo](https://github.com/essobedo))
- Some various improvements in dependencies.adoc [\#3509](https://github.com/apache/camel-k/pull/3509) ([essobedo](https://github.com/essobedo))
- makefile [\#3508](https://github.com/apache/camel-k/pull/3508) ([lburgazzoli](https://github.com/lburgazzoli))
- Some various improvements [\#3507](https://github.com/apache/camel-k/pull/3507) ([essobedo](https://github.com/essobedo))
- Fix the file path in run command [\#3506](https://github.com/apache/camel-k/pull/3506) ([essobedo](https://github.com/essobedo))
- Fix typo in local.adoc [\#3505](https://github.com/apache/camel-k/pull/3505) ([essobedo](https://github.com/essobedo))
- Update the path of the file Sample.java [\#3504](https://github.com/apache/camel-k/pull/3504) ([essobedo](https://github.com/essobedo))
- Fix building multi-arch containers on ARM on MacOS [\#3500](https://github.com/apache/camel-k/pull/3500) ([orpiske](https://github.com/orpiske))
- fix\(cli\): more user-friendly error messages for kamel local subcommands [\#3499](https://github.com/apache/camel-k/pull/3499) ([tadayosi](https://github.com/tadayosi))
- migrate and improve kafka example [\#3495](https://github.com/apache/camel-k/pull/3495) ([KuthumiPepple](https://github.com/KuthumiPepple))
- fix\(trait\): camel to use a single properties file  [\#3493](https://github.com/apache/camel-k/pull/3493) ([squakez](https://github.com/squakez))
- fix\(lint\): nolintlint [\#3491](https://github.com/apache/camel-k/pull/3491) ([tadayosi](https://github.com/tadayosi))
- fix\(e2e\): stabilise knative/yaks tests [\#3490](https://github.com/apache/camel-k/pull/3490) ([tadayosi](https://github.com/tadayosi))
- fix\(cli\): run Integration from GitHub branch [\#3489](https://github.com/apache/camel-k/pull/3489) ([tadayosi](https://github.com/tadayosi))
- fix\(ci\): build before making images [\#3488](https://github.com/apache/camel-k/pull/3488) ([squakez](https://github.com/squakez))
- fix\(core\): cascade Integration error when kit in... [\#3487](https://github.com/apache/camel-k/pull/3487) ([squakez](https://github.com/squakez))
- Fix windows paths in --resource [\#3485](https://github.com/apache/camel-k/pull/3485) ([mmajerni](https://github.com/mmajerni))
- fix\(doc\): standardise Camel dependency notation in docs and examples [\#3482](https://github.com/apache/camel-k/pull/3482) ([tadayosi](https://github.com/tadayosi))
- fix: camel-k ignores changes to traits configured using annotations  [\#3480](https://github.com/apache/camel-k/pull/3480) ([lburgazzoli](https://github.com/lburgazzoli))
- fix\(ci\): common & install e2e workflows fail silently [\#3478](https://github.com/apache/camel-k/pull/3478) ([tadayosi](https://github.com/tadayosi))
- chore\(knative\): upgrade Knative to 1.3 \(0.30\) \#3381 [\#3477](https://github.com/apache/camel-k/pull/3477) ([tadayosi](https://github.com/tadayosi))
- fix\(trait\): nil pointer dereference when applying traits during kit building [\#3471](https://github.com/apache/camel-k/pull/3471) ([tadayosi](https://github.com/tadayosi))
- fix\(doc\): fix doc-gen to insert space between lines [\#3470](https://github.com/apache/camel-k/pull/3470) ([tadayosi](https://github.com/tadayosi))
- Provides Makefile with ability to generate a test bundle index image [\#3468](https://github.com/apache/camel-k/pull/3468) ([phantomjinx](https://github.com/phantomjinx))
- chore\(api\): refer to correct trait [\#3467](https://github.com/apache/camel-k/pull/3467) ([squakez](https://github.com/squakez))
- chore\(lint\): upgrade golangci-lint to 1.47.1 [\#3466](https://github.com/apache/camel-k/pull/3466) ([tadayosi](https://github.com/tadayosi))
- migrate ibm-mq example [\#3461](https://github.com/apache/camel-k/pull/3461) ([KuthumiPepple](https://github.com/KuthumiPepple))
- fix\(olm\): fix profile name: Openshift -\> OpenShift in OLM sample [\#3460](https://github.com/apache/camel-k/pull/3460) ([tadayosi](https://github.com/tadayosi))
- migrate and improve http example [\#3452](https://github.com/apache/camel-k/pull/3452) ([KuthumiPepple](https://github.com/KuthumiPepple))
- chore\(e2e\): reuse namespaces as much as possible for E2E tests [\#3451](https://github.com/apache/camel-k/pull/3451) ([tadayosi](https://github.com/tadayosi))
- chore\(deps\): bump github.com/prometheus/common from 0.35.0 to 0.37.0 [\#3450](https://github.com/apache/camel-k/pull/3450) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(lint\): upgrade golangci-lint to 1.46.2 [\#3448](https://github.com/apache/camel-k/pull/3448) ([tadayosi](https://github.com/tadayosi))
- fix\(doc\): fix camel-website build [\#3446](https://github.com/apache/camel-k/pull/3446) ([tadayosi](https://github.com/tadayosi))
- fix\(cli\): `kamel local build` doesn't support same dependency notation [\#3444](https://github.com/apache/camel-k/pull/3444) ([tadayosi](https://github.com/tadayosi))
- chore\(deps\): bump github.com/redhat-developer/service-binding-operator from 1.1.0 to 1.1.1 [\#3443](https://github.com/apache/camel-k/pull/3443) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(build\): `make generate-doc` outputs non-deterministic resources/traits.yaml [\#3440](https://github.com/apache/camel-k/pull/3440) ([tadayosi](https://github.com/tadayosi))
- Fix CLI test - update file name path [\#3436](https://github.com/apache/camel-k/pull/3436) ([mmajerni](https://github.com/mmajerni))
- fix\(doc\): fix gen-crd-api-reference-docs and regen API doc with Traits [\#3435](https://github.com/apache/camel-k/pull/3435) ([tadayosi](https://github.com/tadayosi))
- feat\(build\): Golang 1.17 [\#3432](https://github.com/apache/camel-k/pull/3432) ([squakez](https://github.com/squakez))
- migrate and improve jitpack example [\#3420](https://github.com/apache/camel-k/pull/3420) ([KuthumiPepple](https://github.com/KuthumiPepple))
- Handle OCP3 in e2e kustomize install tests [\#3419](https://github.com/apache/camel-k/pull/3419) ([phantomjinx](https://github.com/phantomjinx))
- migrate and improve dns example [\#3414](https://github.com/apache/camel-k/pull/3414) ([KuthumiPepple](https://github.com/KuthumiPepple))
- fix\(\#3393\): Fix e2e CronJob test [\#3411](https://github.com/apache/camel-k/pull/3411) ([christophd](https://github.com/christophd))
- migrate and improve database example [\#3410](https://github.com/apache/camel-k/pull/3410) ([KuthumiPepple](https://github.com/KuthumiPepple))
- chore\(ci\): regen docs & add generate workflow to test `make generate` [\#3409](https://github.com/apache/camel-k/pull/3409) ([tadayosi](https://github.com/tadayosi))
- chore\(deps\): bump github.com/stretchr/testify from 1.7.4 to 1.8.0 [\#3407](https://github.com/apache/camel-k/pull/3407) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(e2e\): promote typo [\#3406](https://github.com/apache/camel-k/pull/3406) ([squakez](https://github.com/squakez))
- allow setting resources & securityContext in Helm Chart values [\#3403](https://github.com/apache/camel-k/pull/3403) ([d-lopes](https://github.com/d-lopes))
- fix\(\#3393\): Update to CronJob batch/v1 [\#3402](https://github.com/apache/camel-k/pull/3402) ([christophd](https://github.com/christophd))
- fix\(\#3399\): Improve operator log level adjustments [\#3401](https://github.com/apache/camel-k/pull/3401) ([christophd](https://github.com/christophd))
- fix\(\#3390\): Fix Knative addressable resolver cluster role binding [\#3400](https://github.com/apache/camel-k/pull/3400) ([christophd](https://github.com/christophd))
- chore\(build\): Assume gnu-sed usage for MacOS users [\#3398](https://github.com/apache/camel-k/pull/3398) ([christophd](https://github.com/christophd))
- migrate and improve basic example [\#3395](https://github.com/apache/camel-k/pull/3395) ([KuthumiPepple](https://github.com/KuthumiPepple))
- migrate and improve caffeine example [\#3394](https://github.com/apache/camel-k/pull/3394) ([KuthumiPepple](https://github.com/KuthumiPepple))
- chore\(deps\): bump github.com/spf13/cobra from 1.4.0 to 1.5.0 [\#3388](https://github.com/apache/camel-k/pull/3388) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(build\): tidy submodules and make their tests run in build [\#3386](https://github.com/apache/camel-k/pull/3386) ([tadayosi](https://github.com/tadayosi))
- migrate and improve amqp example [\#3383](https://github.com/apache/camel-k/pull/3383) ([KuthumiPepple](https://github.com/KuthumiPepple))
- Improves reliability of e2e testing [\#3382](https://github.com/apache/camel-k/pull/3382) ([phantomjinx](https://github.com/phantomjinx))
- chore\(deps\): bump github.com/prometheus/common from 0.34.0 to 0.35.0 [\#3380](https://github.com/apache/camel-k/pull/3380) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/stretchr/testify from 1.7.2 to 1.7.4 [\#3379](https://github.com/apache/camel-k/pull/3379) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(trait\): use k8s.io/utils/pointer instead of homemade utils for pointer operations [\#3377](https://github.com/apache/camel-k/pull/3377) ([tadayosi](https://github.com/tadayosi))
- chore\(deps\): bump github.com/container-tools/spectrum from 0.3.9 to 0.3.10 [\#3374](https://github.com/apache/camel-k/pull/3374) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/redhat-developer/service-binding-operator from 1.0.1 to 1.1.0 [\#3370](https://github.com/apache/camel-k/pull/3370) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fixes `kamel local run` panic on Windows [\#3368](https://github.com/apache/camel-k/pull/3368) ([ammachado](https://github.com/ammachado))
- introduce spectrum option job [\#3366](https://github.com/apache/camel-k/pull/3366) ([SubhasmitaSw](https://github.com/SubhasmitaSw))
- Fixes GIT\_COMMIT assignment failure in build [\#3361](https://github.com/apache/camel-k/pull/3361) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/container-tools/spectrum from 0.3.8 to 0.3.9 [\#3360](https://github.com/apache/camel-k/pull/3360) ([dependabot[bot]](https://github.com/apps/dependabot))
- Improve multi operator handling and multi tenancy model [\#3358](https://github.com/apache/camel-k/pull/3358) ([christophd](https://github.com/christophd))
- chore\(deps\): bump github.com/stretchr/testify from 1.7.1 to 1.7.2 [\#3355](https://github.com/apache/camel-k/pull/3355) ([dependabot[bot]](https://github.com/apps/dependabot))
- move cron example to camel-k-examples repo [\#3352](https://github.com/apache/camel-k/pull/3352) ([KuthumiPepple](https://github.com/KuthumiPepple))
- \[TEST\] Add kamel reset test [\#3351](https://github.com/apache/camel-k/pull/3351) ([bouskaJ](https://github.com/bouskaJ))
- fix\(lint\): fix more forcetypeassert [\#3346](https://github.com/apache/camel-k/pull/3346) ([tadayosi](https://github.com/tadayosi))
- chore: Regen resources and use golangci config for lint in Makefile [\#3345](https://github.com/apache/camel-k/pull/3345) ([christophd](https://github.com/christophd))
- configuring maven builds based on CPU quota if set any [\#3344](https://github.com/apache/camel-k/pull/3344) ([SubhasmitaSw](https://github.com/SubhasmitaSw))
- \#3321: Fixes pre-bundle rule in Makefile [\#3343](https://github.com/apache/camel-k/pull/3343) ([phantomjinx](https://github.com/phantomjinx))
- fix\(e2e\): stabilise E2E tests [\#3334](https://github.com/apache/camel-k/pull/3334) ([tadayosi](https://github.com/tadayosi))
- chore: ci build rule and license fix [\#3333](https://github.com/apache/camel-k/pull/3333) ([squakez](https://github.com/squakez))
- Fix `make generate-strimzi` [\#3331](https://github.com/apache/camel-k/pull/3331) ([tadayosi](https://github.com/tadayosi))
- Adding basic support for `PodSecurityContext`. [\#3330](https://github.com/apache/camel-k/pull/3330) ([ammachado](https://github.com/ammachado))
- feat\(gc\): Skip GC for first integration generation [\#3327](https://github.com/apache/camel-k/pull/3327) ([astefanutti](https://github.com/astefanutti))
- feat\(gc\): Use SelfSubjectRulesReview to scan for garbage collectable resources [\#3326](https://github.com/apache/camel-k/pull/3326) ([astefanutti](https://github.com/astefanutti))
- feat\(cli\): environment promotion [\#3325](https://github.com/apache/camel-k/pull/3325) ([squakez](https://github.com/squakez))
- chore\(docs\): maven local repository [\#3324](https://github.com/apache/camel-k/pull/3324) ([squakez](https://github.com/squakez))
- \[TEST\] Add autoscaling test [\#3322](https://github.com/apache/camel-k/pull/3322) ([bouskaJ](https://github.com/bouskaJ))
- Enable parsing pod template as a modeline. [\#3319](https://github.com/apache/camel-k/pull/3319) ([ammachado](https://github.com/ammachado))
- fix\(ci\): fix Upgrade E2E testing on CI [\#3318](https://github.com/apache/camel-k/pull/3318) ([tadayosi](https://github.com/tadayosi))
- Local dependencies options [\#3316](https://github.com/apache/camel-k/pull/3316) ([johnpoth](https://github.com/johnpoth))
- chore\(deps\): bump github.com/spf13/viper from 1.11.0 to 1.12.0 [\#3313](https://github.com/apache/camel-k/pull/3313) ([dependabot[bot]](https://github.com/apps/dependabot))
- Detect wire tap EIP endpoints [\#3312](https://github.com/apache/camel-k/pull/3312) ([ammachado](https://github.com/ammachado))
- fix\(health\): support new Camel health check format [\#3310](https://github.com/apache/camel-k/pull/3310) ([tadayosi](https://github.com/tadayosi))
- MultiArchitecture support [\#3309](https://github.com/apache/camel-k/pull/3309) ([robertonav20](https://github.com/robertonav20))
- test\(e2e\): add test for 'kamel run --dev' in a warmed-up environment [\#3303](https://github.com/apache/camel-k/pull/3303) ([tadayosi](https://github.com/tadayosi))
- Fix typo [\#3301](https://github.com/apache/camel-k/pull/3301) ([lamabro23](https://github.com/lamabro23))
- Never stale a bug issue [\#3292](https://github.com/apache/camel-k/pull/3292) ([tal66](https://github.com/tal66))
- Fix \#3257: fix uploading checksum files to the image registry on Windows [\#3288](https://github.com/apache/camel-k/pull/3288) ([johnpoth](https://github.com/johnpoth))
- Fix: use platform.Status instead of platform.Spec [\#3287](https://github.com/apache/camel-k/pull/3287) ([johnpoth](https://github.com/johnpoth))
- chore\(deps\): bump github.com/prometheus/client\_golang from 1.12.1 to 1.12.2 [\#3273](https://github.com/apache/camel-k/pull/3273) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/gertd/go-pluralize from 0.2.0 to 0.2.1 [\#3272](https://github.com/apache/camel-k/pull/3272) ([dependabot[bot]](https://github.com/apps/dependabot))
- feat\(CRD\): Traits configuration schema [\#3235](https://github.com/apache/camel-k/pull/3235) ([tadayosi](https://github.com/tadayosi))
- chore\(deps\): bump github.com/mitchellh/mapstructure from 1.4.3 to 1.5.0 [\#3225](https://github.com/apache/camel-k/pull/3225) ([dependabot[bot]](https://github.com/apps/dependabot))
- added .status.observedGeneration to camel K CRDs [\#3218](https://github.com/apache/camel-k/pull/3218) ([SubhasmitaSw](https://github.com/SubhasmitaSw))
- Add settings security to Maven build [\#3185](https://github.com/apache/camel-k/pull/3185) ([haanhvu](https://github.com/haanhvu))
- \[TEST\] Add kamel debug test [\#3131](https://github.com/apache/camel-k/pull/3131) ([bouskaJ](https://github.com/bouskaJ))

## [1.10.0-nightly](https://github.com/apache/camel-k/tree/1.10.0-nightly) (2022-05-18)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.9.2...1.10.0-nightly)

**Closed issues:**

- Cannot upgrade from 1.8.x to 1.9.0-SNAPSHOT [\#3063](https://github.com/apache/camel-k/issues/3063)

**Merged pull requests:**

- chore\(trait\): Add an option to disable SSA in deployer trait [\#3286](https://github.com/apache/camel-k/pull/3286) ([astefanutti](https://github.com/astefanutti))
- fix: Use status change predicate to filter updates on owned resources [\#3285](https://github.com/apache/camel-k/pull/3285) ([astefanutti](https://github.com/astefanutti))
- Moving to 1.10.0-SNAPSHOT [\#3284](https://github.com/apache/camel-k/pull/3284) ([oscerd](https://github.com/oscerd))
- chore\(cmd/trait\): refactor cmd & trait packages [\#3279](https://github.com/apache/camel-k/pull/3279) ([tadayosi](https://github.com/tadayosi))

## [pkg/apis/camel/v1.9.2](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.9.2) (2022-05-17)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.9.2...pkg/apis/camel/v1.9.2)

## [pkg/client/camel/v1.9.2](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.9.2) (2022-05-17)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.9.2...pkg/client/camel/v1.9.2)

## [v1.9.2](https://github.com/apache/camel-k/tree/v1.9.2) (2022-05-17)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.9.2...v1.9.2)

## [pkg/kamelet/repository/v1.9.2](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.9.2) (2022-05-17)

[Full Changelog](https://github.com/apache/camel-k/compare/1.9.2-nightly...pkg/kamelet/repository/v1.9.2)

## [1.9.2-nightly](https://github.com/apache/camel-k/tree/1.9.2-nightly) (2022-05-17)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.9.1...1.9.2-nightly)

**Closed issues:**

- Local Dependencies Registry Problem [\#3271](https://github.com/apache/camel-k/issues/3271)
- Path-problem with local dependency \(jar\) on windows [\#3257](https://github.com/apache/camel-k/issues/3257)
- Enable Service to be exposed as NodePort should be disabled by default [\#3253](https://github.com/apache/camel-k/issues/3253)
- Default `make` fallback to `test` [\#3242](https://github.com/apache/camel-k/issues/3242)
- kamel init - Use camelCase for yaml created sample files [\#3206](https://github.com/apache/camel-k/issues/3206)

**Merged pull requests:**

- Fix \#3271: Prepend Organization/Namespace in HTTP path when uploading… [\#3278](https://github.com/apache/camel-k/pull/3278) ([johnpoth](https://github.com/johnpoth))
- fix: Bump remaining resources to 1.9.2 [\#3270](https://github.com/apache/camel-k/pull/3270) ([phantomjinx](https://github.com/phantomjinx))
- Fix: support absolute paths on Windows [\#3269](https://github.com/apache/camel-k/pull/3269) ([johnpoth](https://github.com/johnpoth))
- Fix \#3257: work with relative paths on windows to avoid extra semicolon [\#3265](https://github.com/apache/camel-k/pull/3265) ([johnpoth](https://github.com/johnpoth))
- fix\(trait\): disable NodePort by default for Service trait [\#3263](https://github.com/apache/camel-k/pull/3263) ([tadayosi](https://github.com/tadayosi))
- fix\(kamelet\): migrate to Camel 3.15 yaml definition [\#3256](https://github.com/apache/camel-k/pull/3256) ([squakez](https://github.com/squakez))
- chore\(ci\): force unit test [\#3251](https://github.com/apache/camel-k/pull/3251) ([squakez](https://github.com/squakez))
- added logging traits documentation.  [\#3231](https://github.com/apache/camel-k/pull/3231) ([Gre8t](https://github.com/Gre8t))
- chore: Improve extract Camel catalog script [\#3221](https://github.com/apache/camel-k/pull/3221) ([christophd](https://github.com/christophd))
- CamelCase for yaml created sample files [\#3209](https://github.com/apache/camel-k/pull/3209) ([SarveshLimaye](https://github.com/SarveshLimaye))

## [v1.9.1](https://github.com/apache/camel-k/tree/v1.9.1) (2022-05-09)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.9.1...v1.9.1)

## [pkg/client/camel/v1.9.1](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.9.1) (2022-05-09)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.9.1...pkg/client/camel/v1.9.1)

## [pkg/apis/camel/v1.9.1](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.9.1) (2022-05-09)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.9.1...pkg/apis/camel/v1.9.1)

## [pkg/kamelet/repository/v1.9.1](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.9.1) (2022-05-09)

[Full Changelog](https://github.com/apache/camel-k/compare/1.9.1-nightly...pkg/kamelet/repository/v1.9.1)

**Closed issues:**

- Yaml sources failure in 1.9.0 [\#3255](https://github.com/apache/camel-k/issues/3255)
- Release 1.9.0 [\#3220](https://github.com/apache/camel-k/issues/3220)
- Nightly builds in test docker repo [\#3106](https://github.com/apache/camel-k/issues/3106)
- Add log-level setting on Camel K operator [\#3053](https://github.com/apache/camel-k/issues/3053)
- kamel local run/build practices for creating a YAML output [\#3021](https://github.com/apache/camel-k/issues/3021)
- Upgrade deprecated linters [\#3012](https://github.com/apache/camel-k/issues/3012)
- Intermittent problem with integration remaining at phase "Building Kit" [\#2905](https://github.com/apache/camel-k/issues/2905)

## [1.9.1-nightly](https://github.com/apache/camel-k/tree/1.9.1-nightly) (2022-05-05)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.9.0...1.9.1-nightly)

**Closed issues:**

- Provide example for IBM MQ Server [\#3247](https://github.com/apache/camel-k/issues/3247)
- Preflight Test: Failure [\#3243](https://github.com/apache/camel-k/issues/3243)
- Operators: `make prepare-operators` should use the same folder structure of the Kubernetes output for the Openshift ecosystem [\#3237](https://github.com/apache/camel-k/issues/3237)
- Jitpack example deployment fails [\#3207](https://github.com/apache/camel-k/issues/3207)
- Mount trait usage example [\#3140](https://github.com/apache/camel-k/issues/3140)
- `Kamel kit create` to use mount/camel traits [\#2915](https://github.com/apache/camel-k/issues/2915)
- \[CLI\] Format long subcommand descriptions [\#2318](https://github.com/apache/camel-k/issues/2318)
- Camel K CLI asks for an OpenAPI v2 when also v3 is supported [\#2238](https://github.com/apache/camel-k/issues/2238)
- Traits to configure the container image and location fo the sources [\#2232](https://github.com/apache/camel-k/issues/2232)
- Lower priority of modeline options [\#1843](https://github.com/apache/camel-k/issues/1843)

**Merged pull requests:**

- fix\(ci\): release action tag params [\#3254](https://github.com/apache/camel-k/pull/3254) ([squakez](https://github.com/squakez))
- fix\(ci\): typo [\#3250](https://github.com/apache/camel-k/pull/3250) ([squakez](https://github.com/squakez))
- package\_maven\_artifacts: run unzip in silent mode [\#3249](https://github.com/apache/camel-k/pull/3249) ([claudio4j](https://github.com/claudio4j))
- Provide example for IBM MQ Server [\#3248](https://github.com/apache/camel-k/pull/3248) ([claudio4j](https://github.com/claudio4j))
- \#3053 \#3242 Fixes e2e preflight and adds debug level to logging [\#3245](https://github.com/apache/camel-k/pull/3245) ([phantomjinx](https://github.com/phantomjinx))
- Operators: make prepare-operators should use the same folder structur… [\#3239](https://github.com/apache/camel-k/pull/3239) ([oscerd](https://github.com/oscerd))
- fix\[cli\]: format long subcommand descriptions [\#3227](https://github.com/apache/camel-k/pull/3227) ([KuthumiPepple](https://github.com/KuthumiPepple))
- chore\(deps\): bump github.com/prometheus/common from 0.33.0 to 0.34.0 [\#3226](https://github.com/apache/camel-k/pull/3226) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(ci\): updating release action [\#3224](https://github.com/apache/camel-k/pull/3224) ([squakez](https://github.com/squakez))
- chore: Log build duration metrics [\#3223](https://github.com/apache/camel-k/pull/3223) ([christophd](https://github.com/christophd))
- fix: kamel run -o incompatible with --dev [\#3219](https://github.com/apache/camel-k/pull/3219) ([KuthumiPepple](https://github.com/KuthumiPepple))
- Docs: fixed some grammatical errors [\#3215](https://github.com/apache/camel-k/pull/3215) ([parul5sahoo](https://github.com/parul5sahoo))
- fix\(cli\): kamel panics when unknown command is passed [\#3204](https://github.com/apache/camel-k/pull/3204) ([tadayosi](https://github.com/tadayosi))
- chore\(deps\): bump github.com/spf13/viper from 1.10.1 to 1.11.0 [\#3202](https://github.com/apache/camel-k/pull/3202) ([dependabot[bot]](https://github.com/apps/dependabot))
- Release 1.9.0 preparation [\#3201](https://github.com/apache/camel-k/pull/3201) ([oscerd](https://github.com/oscerd))
- feat\(cli\): disconnected run and bind [\#3198](https://github.com/apache/camel-k/pull/3198) ([squakez](https://github.com/squakez))
- chore\(deps\): library upgrade [\#3197](https://github.com/apache/camel-k/pull/3197) ([squakez](https://github.com/squakez))
- fix\(cli\): modeline warn output to stderr [\#3196](https://github.com/apache/camel-k/pull/3196) ([squakez](https://github.com/squakez))
- Fix \#3192: use correct print function [\#3194](https://github.com/apache/camel-k/pull/3194) ([johnpoth](https://github.com/johnpoth))
- Add verbose flag for the run command [\#3193](https://github.com/apache/camel-k/pull/3193) ([johnpoth](https://github.com/johnpoth))
- fix\(e2e\): resolve Camel version from catalog for test local [\#3189](https://github.com/apache/camel-k/pull/3189) ([tadayosi](https://github.com/tadayosi))
- fix\(ci\): replace release action [\#3188](https://github.com/apache/camel-k/pull/3188) ([squakez](https://github.com/squakez))
- added a file-config doc [\#3187](https://github.com/apache/camel-k/pull/3187) ([Gre8t](https://github.com/Gre8t))
- tracing trait usage example [\#3184](https://github.com/apache/camel-k/pull/3184) ([SubhasmitaSw](https://github.com/SubhasmitaSw))
- chore\(doc\): removing useless fragment [\#3181](https://github.com/apache/camel-k/pull/3181) ([squakez](https://github.com/squakez))
- chore\(examples\): olm installation [\#3179](https://github.com/apache/camel-k/pull/3179) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/prometheus/common from 0.32.1 to 0.33.0 [\#3178](https://github.com/apache/camel-k/pull/3178) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(olm\): IntegrationPlatform reconciled by operator  [\#3172](https://github.com/apache/camel-k/pull/3172) ([squakez](https://github.com/squakez))
- fix \#2835 address comments [\#3171](https://github.com/apache/camel-k/pull/3171) ([johnpoth](https://github.com/johnpoth))
- Add Mount trait example [\#3166](https://github.com/apache/camel-k/pull/3166) ([haanhvu](https://github.com/haanhvu))
- operator: allow to configure the lock name [\#3163](https://github.com/apache/camel-k/pull/3163) ([lburgazzoli](https://github.com/lburgazzoli))
- refactored redundant kamel kit flags [\#3160](https://github.com/apache/camel-k/pull/3160) ([Gre8t](https://github.com/Gre8t))
- added trait example of services [\#3159](https://github.com/apache/camel-k/pull/3159) ([Gre8t](https://github.com/Gre8t))
- Disable deprecate linters [\#3158](https://github.com/apache/camel-k/pull/3158) ([Gre8t](https://github.com/Gre8t))
- Makefile windows support [\#3157](https://github.com/apache/camel-k/pull/3157) ([SubhasmitaSw](https://github.com/SubhasmitaSw))
- chore\(deps\): bump github.com/rs/xid from 1.3.0 to 1.4.0 [\#3156](https://github.com/apache/camel-k/pull/3156) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/stretchr/testify from 1.7.0 to 1.7.1 [\#3155](https://github.com/apache/camel-k/pull/3155) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(ci\): nightly allow release update [\#3154](https://github.com/apache/camel-k/pull/3154) ([squakez](https://github.com/squakez))
- fix: redirect ouput and errors to appropriate writer [\#3153](https://github.com/apache/camel-k/pull/3153) ([KuthumiPepple](https://github.com/KuthumiPepple))
- Example to show usage of prometheus trait [\#3152](https://github.com/apache/camel-k/pull/3152) ([SubhasmitaSw](https://github.com/SubhasmitaSw))
- add k8s labels to deployment service [\#3150](https://github.com/apache/camel-k/pull/3150) ([desirekaleba](https://github.com/desirekaleba))
- chore\(deps\): bump github.com/onsi/gomega from 1.16.0 to 1.19.0 [\#3135](https://github.com/apache/camel-k/pull/3135) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(ci\): remove unused maven references [\#3123](https://github.com/apache/camel-k/pull/3123) ([squakez](https://github.com/squakez))
- Stabilize route test [\#3121](https://github.com/apache/camel-k/pull/3121) ([bouskaJ](https://github.com/bouskaJ))
- chore\(deps\): bump github.com/redhat-developer/service-binding-operator from 1.0.0 to 1.0.1 [\#3118](https://github.com/apache/camel-k/pull/3118) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/spf13/cobra from 1.2.1 to 1.4.0 [\#3112](https://github.com/apache/camel-k/pull/3112) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(e2e\): stabilise local e2e tests [\#3084](https://github.com/apache/camel-k/pull/3084) ([tadayosi](https://github.com/tadayosi))
- Migrates opm to file based indexes and fixes e2e upgrade tests [\#3078](https://github.com/apache/camel-k/pull/3078) ([phantomjinx](https://github.com/phantomjinx))
- Local dependencies [\#2835](https://github.com/apache/camel-k/pull/2835) ([johnpoth](https://github.com/johnpoth))
- Global test on ns with its own op fix [\#2784](https://github.com/apache/camel-k/pull/2784) ([vitorz](https://github.com/vitorz))
-  fix 1802: leverage KEP-1755 to retrieve local image registry host an… [\#2696](https://github.com/apache/camel-k/pull/2696) ([johnpoth](https://github.com/johnpoth))

## [pkg/kamelet/repository/v1.9.0](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.9.0) (2022-04-21)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.9.0...pkg/kamelet/repository/v1.9.0)

## [pkg/apis/camel/v1.9.0](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.9.0) (2022-04-21)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.9.0...pkg/apis/camel/v1.9.0)

## [v1.9.0](https://github.com/apache/camel-k/tree/v1.9.0) (2022-04-21)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.9.0...v1.9.0)

## [pkg/client/camel/v1.9.0](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.9.0) (2022-04-21)

[Full Changelog](https://github.com/apache/camel-k/compare/1.9.0-nightly...pkg/client/camel/v1.9.0)

**Closed issues:**

- \[SOLVED\]Cant specify fastjson when marshal [\#3212](https://github.com/apache/camel-k/issues/3212)
- Camel K CLI panics when unknown command is passed [\#3203](https://github.com/apache/camel-k/issues/3203)
- Kamel run -o incompatible with --dev [\#3195](https://github.com/apache/camel-k/issues/3195)
- Cosmetic log error [\#3192](https://github.com/apache/camel-k/issues/3192)
- Update allowed release Github action [\#3190](https://github.com/apache/camel-k/issues/3190)
- Make CLI --output argument more clean [\#3177](https://github.com/apache/camel-k/issues/3177)
- operator: allow to configure the lock name  [\#3162](https://github.com/apache/camel-k/issues/3162)
- Error when running camel-k in global mode with label selection [\#3161](https://github.com/apache/camel-k/issues/3161)
- Improve the logging of quarkus build failures [\#3149](https://github.com/apache/camel-k/issues/3149)
- Tracing trait usage example [\#3148](https://github.com/apache/camel-k/issues/3148)
- Prometheus trait usage example [\#3144](https://github.com/apache/camel-k/issues/3144)
- Prepare for releasing Camel-K with Camel 3.16.0 [\#3138](https://github.com/apache/camel-k/issues/3138)
- Use Kubernetes recommended labels  [\#3137](https://github.com/apache/camel-k/issues/3137)
- Nightly release fail to create an existing tag [\#3130](https://github.com/apache/camel-k/issues/3130)
- Jsonata does not evaluate correctly [\#3129](https://github.com/apache/camel-k/issues/3129)
- wrong XSD url generated with XML initialiser [\#3093](https://github.com/apache/camel-k/issues/3093)
- Openshift integration tests failure [\#3055](https://github.com/apache/camel-k/issues/3055)
- Scaling integration pod and the replicas are not able to receive traffic via UDP port [\#2847](https://github.com/apache/camel-k/issues/2847)
- Best practice to manage multiple routes in Camel-K [\#2824](https://github.com/apache/camel-k/issues/2824)
- way to add a trusted root cert? \(non-maven\) [\#2820](https://github.com/apache/camel-k/issues/2820)
- Remove usage of deprecated "flow" in Kamelet CRD in the documentation examples [\#2816](https://github.com/apache/camel-k/issues/2816)
- Be able to configure PodMonitor via prometheus trait [\#2812](https://github.com/apache/camel-k/issues/2812)
- camel-k doesn't create a service [\#2810](https://github.com/apache/camel-k/issues/2810)
- SEDA low performance issue [\#2808](https://github.com/apache/camel-k/issues/2808)
- Get rid of `fmt.Print...()` methods [\#2773](https://github.com/apache/camel-k/issues/2773)
- Remove maven wrapper and any leftover pom.xml [\#2659](https://github.com/apache/camel-k/issues/2659)
- kamelet binding annotation should be propagated to the integration  [\#2436](https://github.com/apache/camel-k/issues/2436)
- languages: support kamelet eip [\#2375](https://github.com/apache/camel-k/issues/2375)
- kamelet binding: use the Kamelet EIP for steps [\#2370](https://github.com/apache/camel-k/issues/2370)
- Use local registry config from cluster [\#1802](https://github.com/apache/camel-k/issues/1802)
- Istio sidecar injection is enabled for builder pod [\#1706](https://github.com/apache/camel-k/issues/1706)
- Integration controller issue [\#1691](https://github.com/apache/camel-k/issues/1691)
- Create ConsoleYAMLSample for Integration and IntegrationPlatform CRDs on OpenShift [\#1480](https://github.com/apache/camel-k/issues/1480)
- Kamel run fails to pull in camel-k-builder after installing with helm [\#1476](https://github.com/apache/camel-k/issues/1476)
- Let dependencies be defined using file URLs [\#1227](https://github.com/apache/camel-k/issues/1227)
- Write doc about file based configuration for kamel CLI [\#1155](https://github.com/apache/camel-k/issues/1155)
- Deployment not found while replacing CamelSource [\#1028](https://github.com/apache/camel-k/issues/1028)
- Document how to use Camel K without the "kamel" tool [\#52](https://github.com/apache/camel-k/issues/52)
- Add roadmap information [\#35](https://github.com/apache/camel-k/issues/35)

## [1.9.0-nightly](https://github.com/apache/camel-k/tree/1.9.0-nightly) (2022-03-14)

[Full Changelog](https://github.com/apache/camel-k/compare/1.9.0-nightly.202203101127...1.9.0-nightly)

**Closed issues:**

- Nightly tag failure [\#3107](https://github.com/apache/camel-k/issues/3107)
- Kaniko settings refactoring [\#3005](https://github.com/apache/camel-k/issues/3005)
- Add daily operator image builds [\#393](https://github.com/apache/camel-k/issues/393)

**Merged pull requests:**

- fix\(ci\): attempt for a single nightly release [\#3117](https://github.com/apache/camel-k/pull/3117) ([squakez](https://github.com/squakez))
- chore\(deps\): bump github.com/gertd/go-pluralize from 0.1.1 to 0.2.0 [\#3116](https://github.com/apache/camel-k/pull/3116) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/prometheus/client\_golang from 1.11.0 to 1.12.1 [\#3110](https://github.com/apache/camel-k/pull/3110) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix: Propagate readiness condition message in KameletBinding if present [\#3108](https://github.com/apache/camel-k/pull/3108) ([astefanutti](https://github.com/astefanutti))
- chore\(deps\): bump github.com/magiconair/properties from 1.8.5 to 1.8.6 [\#3104](https://github.com/apache/camel-k/pull/3104) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(cli\): resource file with same content [\#3103](https://github.com/apache/camel-k/pull/3103) ([squakez](https://github.com/squakez))
- \[\#3093\] wrong XSD url generated with XML initialiser [\#3102](https://github.com/apache/camel-k/pull/3102) ([rnetuka](https://github.com/rnetuka))
- fix\(ci\): creating nightly tag [\#3100](https://github.com/apache/camel-k/pull/3100) ([squakez](https://github.com/squakez))
- Refactor kaniko settings [\#3032](https://github.com/apache/camel-k/pull/3032) ([mmelko](https://github.com/mmelko))
- chore\(deps\): bump go.uber.org/zap from 1.19.1 to 1.21.0 [\#2995](https://github.com/apache/camel-k/pull/2995) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/rs/xid from 1.2.1 to 1.3.0 [\#2980](https://github.com/apache/camel-k/pull/2980) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/radovskyb/watcher from 1.0.6 to 1.0.7 [\#2863](https://github.com/apache/camel-k/pull/2863) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump github.com/container-tools/spectrum from 0.3.7 to 0.3.8 [\#2862](https://github.com/apache/camel-k/pull/2862) ([dependabot[bot]](https://github.com/apps/dependabot))

## [1.9.0-nightly.202203101127](https://github.com/apache/camel-k/tree/1.9.0-nightly.202203101127) (2022-03-10)

[Full Changelog](https://github.com/apache/camel-k/compare/1.9.0-nightly.202203101040...1.9.0-nightly.202203101127)

**Closed issues:**

- integration readiness condition is not reported to kamelet binding [\#3091](https://github.com/apache/camel-k/issues/3091)

**Merged pull requests:**

- fix\(ci\): nightly build [\#3099](https://github.com/apache/camel-k/pull/3099) ([squakez](https://github.com/squakez))
- Fix script name for set version: from set-version to set\_version [\#3094](https://github.com/apache/camel-k/pull/3094) ([oscerd](https://github.com/oscerd))
- fix: The KameletBinding readiness condition should mirror its Integration one [\#3092](https://github.com/apache/camel-k/pull/3092) ([astefanutti](https://github.com/astefanutti))

## [1.9.0-nightly.202203101040](https://github.com/apache/camel-k/tree/1.9.0-nightly.202203101040) (2022-03-09)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.8.2...1.9.0-nightly.202203101040)

**Closed issues:**

- Post release steps: Operators manifests [\#3085](https://github.com/apache/camel-k/issues/3085)
- Release 1.8.2 [\#3057](https://github.com/apache/camel-k/issues/3057)
- Why do we println errors in `kamel local` instead of returning them? [\#3029](https://github.com/apache/camel-k/issues/3029)
- Migrate the OLM metadata CSVs to bundle format [\#3018](https://github.com/apache/camel-k/issues/3018)
- How to package integration to deploy it into a private k8s cluster without internet connection [\#2737](https://github.com/apache/camel-k/issues/2737)
- Allow trait customization through kamel bind [\#2596](https://github.com/apache/camel-k/issues/2596)
- Provide automated tests for "kamel local build" command [\#2074](https://github.com/apache/camel-k/issues/2074)

**Merged pull requests:**

- fix\(cli\): make sure kamel local run clean up dirs at ctrl+c [\#3088](https://github.com/apache/camel-k/pull/3088) ([tadayosi](https://github.com/tadayosi))
- Post release steps: Operators manifests [\#3087](https://github.com/apache/camel-k/pull/3087) ([oscerd](https://github.com/oscerd))
- Post release 1.8.2 [\#3086](https://github.com/apache/camel-k/pull/3086) ([oscerd](https://github.com/oscerd))
- Update compatibility matrix reflectin main changes [\#3081](https://github.com/apache/camel-k/pull/3081) ([oscerd](https://github.com/oscerd))
- test\(e2e\): add tests for `kamel local build` [\#3079](https://github.com/apache/camel-k/pull/3079) ([tadayosi](https://github.com/tadayosi))
- Release documentation: Update docs for OperatorHub with new repositories [\#3073](https://github.com/apache/camel-k/pull/3073) ([oscerd](https://github.com/oscerd))
- fix: Fix image tag in operator deployment [\#3071](https://github.com/apache/camel-k/pull/3071) ([astefanutti](https://github.com/astefanutti))
- feat\(cli\): kamel bind --trait option [\#3070](https://github.com/apache/camel-k/pull/3070) ([squakez](https://github.com/squakez))
- chore: Add camel-catalog-1.12.0.yaml to embedded resources [\#3069](https://github.com/apache/camel-k/pull/3069) ([astefanutti](https://github.com/astefanutti))
- fix\(olm\): Upgrade container image in base CSV manifest [\#3068](https://github.com/apache/camel-k/pull/3068) ([astefanutti](https://github.com/astefanutti))
- chore: Update last released version to 1.8.1 [\#3067](https://github.com/apache/camel-k/pull/3067) ([astefanutti](https://github.com/astefanutti))
- chore: Upgrade Kamelet catalog to version 0.7.1 [\#3066](https://github.com/apache/camel-k/pull/3066) ([astefanutti](https://github.com/astefanutti))
- chore: Upgrade Camel K runtime to version 1.12.0 [\#3065](https://github.com/apache/camel-k/pull/3065) ([astefanutti](https://github.com/astefanutti))
- fix: The error handler trait should update status dependencies [\#3056](https://github.com/apache/camel-k/pull/3056) ([astefanutti](https://github.com/astefanutti))
- chore: Tune operator logging [\#3050](https://github.com/apache/camel-k/pull/3050) ([christophd](https://github.com/christophd))
- Makefile Release staging: Pass the remote repository name as argument… [\#3048](https://github.com/apache/camel-k/pull/3048) ([oscerd](https://github.com/oscerd))
- Release note script: Check if the GITHUB\_TOKEN var has been set befor… [\#3045](https://github.com/apache/camel-k/pull/3045) ([oscerd](https://github.com/oscerd))
- Add Helm Chart 1.8.0 and 1.8.1 [\#3043](https://github.com/apache/camel-k/pull/3043) ([oscerd](https://github.com/oscerd))
- Release instruction: remove QUARKUS placeholder, not used anymore in … [\#3039](https://github.com/apache/camel-k/pull/3039) ([oscerd](https://github.com/oscerd))
- test\(e2e\): add test for 'kamel local run --integration-directory' [\#3038](https://github.com/apache/camel-k/pull/3038) ([tadayosi](https://github.com/tadayosi))
- Stop make erroring on lack of kubectl [\#3035](https://github.com/apache/camel-k/pull/3035) ([phantomjinx](https://github.com/phantomjinx))
- fix\(cli\): kamel local subcommands accept traits but simply ignore them [\#3034](https://github.com/apache/camel-k/pull/3034) ([tadayosi](https://github.com/tadayosi))
- doc\(cli\): add documentation for kamel local subcommands [\#3030](https://github.com/apache/camel-k/pull/3030) ([tadayosi](https://github.com/tadayosi))
- chore\(api\): full spec [\#3026](https://github.com/apache/camel-k/pull/3026) ([squakez](https://github.com/squakez))
- chore\(cmd\): refactor kamel local commands [\#3025](https://github.com/apache/camel-k/pull/3025) ([tadayosi](https://github.com/tadayosi))
- Adds OLM channels to bundle metadata [\#3020](https://github.com/apache/camel-k/pull/3020) ([phantomjinx](https://github.com/phantomjinx))
- chore\(ci\): revert nolint [\#3015](https://github.com/apache/camel-k/pull/3015) ([squakez](https://github.com/squakez))
- fix\(build\): incremental build [\#3008](https://github.com/apache/camel-k/pull/3008) ([squakez](https://github.com/squakez))
- Update tekton documentation [\#3000](https://github.com/apache/camel-k/pull/3000) ([livespotty](https://github.com/livespotty))
- fix\(cmd/run\): allow multiple resources [\#2997](https://github.com/apache/camel-k/pull/2997) ([squakez](https://github.com/squakez))
- fix\(kamelet\): reconcile when errored [\#2993](https://github.com/apache/camel-k/pull/2993) ([squakez](https://github.com/squakez))
- Enhance Http proxy test about the OLM [\#2992](https://github.com/apache/camel-k/pull/2992) ([bouskaJ](https://github.com/bouskaJ))
- fix\(yaml\): also consider toD while parsing YAML DSL steps [\#2989](https://github.com/apache/camel-k/pull/2989) ([toonalbers](https://github.com/toonalbers))
- fix\(cli\): kamel run -v should configure the mount trait [\#2986](https://github.com/apache/camel-k/pull/2986) ([astefanutti](https://github.com/astefanutti))
- chore: Upgrade Knative to version 1.2.0 [\#2979](https://github.com/apache/camel-k/pull/2979) ([astefanutti](https://github.com/astefanutti))
- \[TEST\] Fix route test on Knative enabled clusters [\#2974](https://github.com/apache/camel-k/pull/2974) ([bouskaJ](https://github.com/bouskaJ))
- feat\(cli\): add flag --skip-default-kamelets-setup to kamel install [\#2973](https://github.com/apache/camel-k/pull/2973) ([tadayosi](https://github.com/tadayosi))
- fix\(e2e\): Decode OpenShift ProjectRequest into a Project struct [\#2971](https://github.com/apache/camel-k/pull/2971) ([astefanutti](https://github.com/astefanutti))
- chore: Upgrade controller-runtime to v0.10.3 [\#2970](https://github.com/apache/camel-k/pull/2970) ([astefanutti](https://github.com/astefanutti))
- \[TEST\] Add CliDownloadTest [\#2969](https://github.com/apache/camel-k/pull/2969) ([bouskaJ](https://github.com/bouskaJ))
- chore: Upgrade sub-modules to Kubernetes API v0.22.5 [\#2968](https://github.com/apache/camel-k/pull/2968) ([astefanutti](https://github.com/astefanutti))
- fix\(cli\): Kamel CLI zero-code exists when trait properties validation fails [\#2964](https://github.com/apache/camel-k/pull/2964) ([astefanutti](https://github.com/astefanutti))
- Generate crd API docs as AsciiDoc \(main\) \(Update\) [\#2963](https://github.com/apache/camel-k/pull/2963) ([djencks](https://github.com/djencks))
- feat\(knative\): Rely on addressable-resolver ClusterRole to transfer RBAC for Knative Sinks [\#2958](https://github.com/apache/camel-k/pull/2958) ([astefanutti](https://github.com/astefanutti))
- \[TEST\] Add Global operator + namespaced kamelet test [\#2955](https://github.com/apache/camel-k/pull/2955) ([bouskaJ](https://github.com/bouskaJ))
- fix\(api\): Add missing loader metadata field in CamelCatalog API [\#2953](https://github.com/apache/camel-k/pull/2953) ([astefanutti](https://github.com/astefanutti))
- Kamel dump: make the command smarter  [\#2952](https://github.com/apache/camel-k/pull/2952) ([oscerd](https://github.com/oscerd))
- WIP separate v1 and v1alpha1 api packages as much as possible [\#2951](https://github.com/apache/camel-k/pull/2951) ([djencks](https://github.com/djencks))
- chore\(deps\): remove kamelet-reify [\#2949](https://github.com/apache/camel-k/pull/2949) ([squakez](https://github.com/squakez))
- fix\(e2e\): Patch OLM Subscription to avoid conflicting updates [\#2946](https://github.com/apache/camel-k/pull/2946) ([astefanutti](https://github.com/astefanutti))
- chore: Upgrade Kubernetes API to version 1.22.5 [\#2945](https://github.com/apache/camel-k/pull/2945) ([astefanutti](https://github.com/astefanutti))
- fix\(e2e\): Do not add snapshot bundle to stable channel [\#2939](https://github.com/apache/camel-k/pull/2939) ([astefanutti](https://github.com/astefanutti))
- fix: Fix number of found deployments in dump [\#2933](https://github.com/apache/camel-k/pull/2933) ([christophd](https://github.com/christophd))
- chore: remove deprecated code in pre 1.6 releases [\#2932](https://github.com/apache/camel-k/pull/2932) ([squakez](https://github.com/squakez))
- chore: Bump version to 1.9.0-SNAPSHOT [\#2930](https://github.com/apache/camel-k/pull/2930) ([astefanutti](https://github.com/astefanutti))
- fix: Camel Catalog generation fails with empty Maven effective settings [\#2929](https://github.com/apache/camel-k/pull/2929) ([astefanutti](https://github.com/astefanutti))
- Release Documentation: It's release-helm and not generate-helm command [\#2919](https://github.com/apache/camel-k/pull/2919) ([oscerd](https://github.com/oscerd))
- \[Backport main\] Updated the helm index.yml file, by only adding the latest helm chart [\#2918](https://github.com/apache/camel-k/pull/2918) ([github-actions[bot]](https://github.com/apps/github-actions))
- \[Backport main\] Helm release and next [\#2914](https://github.com/apache/camel-k/pull/2914) ([github-actions[bot]](https://github.com/apps/github-actions))
- fix\(e2e\): Update health tests based on Camel 3.14 new health check responses [\#2911](https://github.com/apache/camel-k/pull/2911) ([astefanutti](https://github.com/astefanutti))
- camel-website \#701 camel-k RI table setup \(main\) [\#2906](https://github.com/apache/camel-k/pull/2906) ([djencks](https://github.com/djencks))
- fix\(e2e\): Use X.Y channels for OLM upgrade e2e tests [\#2901](https://github.com/apache/camel-k/pull/2901) ([astefanutti](https://github.com/astefanutti))
- See \#2898 Generate CRD API docs as AsciiDoc [\#2899](https://github.com/apache/camel-k/pull/2899) ([djencks](https://github.com/djencks))
- \[TEST\] - check IntegrationPlatform namespace with global operator [\#2895](https://github.com/apache/camel-k/pull/2895) ([bouskaJ](https://github.com/bouskaJ))
- Update stale.yaml [\#2894](https://github.com/apache/camel-k/pull/2894) ([squakez](https://github.com/squakez))
- Fix \#2788: use kamelets 0.7.0 and align with new dir structure [\#2887](https://github.com/apache/camel-k/pull/2887) ([nicolaferraro](https://github.com/nicolaferraro))
- doc: add more details about installation on IKS/ICR [\#2882](https://github.com/apache/camel-k/pull/2882) ([tadayosi](https://github.com/tadayosi))
- fix: Install Kamelets as unstructured resources [\#2881](https://github.com/apache/camel-k/pull/2881) ([astefanutti](https://github.com/astefanutti))
- feat\(maven\): Configurable Maven CLI options [\#2879](https://github.com/apache/camel-k/pull/2879) ([astefanutti](https://github.com/astefanutti))
- fix\(log\): Structure keytool logs [\#2878](https://github.com/apache/camel-k/pull/2878) ([astefanutti](https://github.com/astefanutti))
- fix http-proxy-docs [\#2874](https://github.com/apache/camel-k/pull/2874) ([djencks](https://github.com/djencks))
- fix: filter lint comment in traits [\#2873](https://github.com/apache/camel-k/pull/2873) ([squakez](https://github.com/squakez))
-  camel-website \#701: RI info \(main\) [\#2868](https://github.com/apache/camel-k/pull/2868) ([djencks](https://github.com/djencks))
- feat: Global HTTP proxy support [\#2858](https://github.com/apache/camel-k/pull/2858) ([astefanutti](https://github.com/astefanutti))
- doc\(jitpack\): detailed info and link to example [\#2857](https://github.com/apache/camel-k/pull/2857) ([squakez](https://github.com/squakez))
- \#2852 Update Antora usage and move diagram source \(main\) [\#2853](https://github.com/apache/camel-k/pull/2853) ([djencks](https://github.com/djencks))
- fix\(doc\): filter nolint comments in documentation trait [\#2851](https://github.com/apache/camel-k/pull/2851) ([squakez](https://github.com/squakez))
- doc\(kamelets\): custom repository [\#2849](https://github.com/apache/camel-k/pull/2849) ([squakez](https://github.com/squakez))
- chore: Upgrade Knative to version 1.1.0 [\#2846](https://github.com/apache/camel-k/pull/2846) ([astefanutti](https://github.com/astefanutti))
- chore\(kamelet\): remove bean and ref error handler types [\#2843](https://github.com/apache/camel-k/pull/2843) ([squakez](https://github.com/squakez))
- AFTER camel-website \#740: local build v2 [\#2839](https://github.com/apache/camel-k/pull/2839) ([djencks](https://github.com/djencks))
- Add support for KEDA [\#2838](https://github.com/apache/camel-k/pull/2838) ([nicolaferraro](https://github.com/nicolaferraro))
- feat: Set GOMAXPROCS based on CPU quota [\#2837](https://github.com/apache/camel-k/pull/2837) ([astefanutti](https://github.com/astefanutti))
- fix\(e2e\): Account for requeued and errored integration reconciliations [\#2836](https://github.com/apache/camel-k/pull/2836) ([astefanutti](https://github.com/astefanutti))
- fix\(e2e\): Avoid nested Gomega fields matcher [\#2833](https://github.com/apache/camel-k/pull/2833) ([astefanutti](https://github.com/astefanutti))
- chore: Try SSA for Kamelet install only once [\#2823](https://github.com/apache/camel-k/pull/2823) ([astefanutti](https://github.com/astefanutti))
- fix\(yaml\): Take to-d into account while parsing YAML DSL steps [\#2822](https://github.com/apache/camel-k/pull/2822) ([astefanutti](https://github.com/astefanutti))
- fix: First bundle Kamelets install with client-side apply [\#2821](https://github.com/apache/camel-k/pull/2821) ([astefanutti](https://github.com/astefanutti))
- feat: Faster operator startup [\#2814](https://github.com/apache/camel-k/pull/2814) ([astefanutti](https://github.com/astefanutti))
- chore\(ci\): Better GitHub Actions concurrency group [\#2811](https://github.com/apache/camel-k/pull/2811) ([astefanutti](https://github.com/astefanutti))
- fix\(OLM\): Remove aggregated cluster roles from OLM bundle [\#2809](https://github.com/apache/camel-k/pull/2809) ([astefanutti](https://github.com/astefanutti))
- chore\(RBAC\): Remove wildcards from Knative role [\#2807](https://github.com/apache/camel-k/pull/2807) ([astefanutti](https://github.com/astefanutti))
- chore: Remove custom REST client [\#2806](https://github.com/apache/camel-k/pull/2806) ([astefanutti](https://github.com/astefanutti))
- chore\(build\): Upgrade base image to ubi-quarkus-mandrel:21.3.0.0 [\#2798](https://github.com/apache/camel-k/pull/2798) ([astefanutti](https://github.com/astefanutti))
- fix\(build\): Fix OLM bundle generation on Mac OS [\#2797](https://github.com/apache/camel-k/pull/2797) ([astefanutti](https://github.com/astefanutti))
- fix\(cli\): Skip version compatibility check for builder command [\#2796](https://github.com/apache/camel-k/pull/2796) ([astefanutti](https://github.com/astefanutti))
- fix\(doc\): Update Prometheus Operator setup documentation [\#2795](https://github.com/apache/camel-k/pull/2795) ([astefanutti](https://github.com/astefanutti))
- chore\(RBAC\): Remove wildcards from roles [\#2793](https://github.com/apache/camel-k/pull/2793) ([astefanutti](https://github.com/astefanutti))
- Makefile: for the generate-doc target don't use show-progress for wget [\#2792](https://github.com/apache/camel-k/pull/2792) ([oscerd](https://github.com/oscerd))
- Fix doc port name [\#2790](https://github.com/apache/camel-k/pull/2790) ([oscerd](https://github.com/oscerd))
- fix\(doc\): header complain [\#2787](https://github.com/apache/camel-k/pull/2787) ([squakez](https://github.com/squakez))
- fix\(lint\): error return value are not checked [\#2786](https://github.com/apache/camel-k/pull/2786) ([lburgazzoli](https://github.com/lburgazzoli))
- doc: no CLI integration run [\#2783](https://github.com/apache/camel-k/pull/2783) ([squakez](https://github.com/squakez))
- fix\(ci\): Fix OLM upgrade e2e tests [\#2782](https://github.com/apache/camel-k/pull/2782) ([astefanutti](https://github.com/astefanutti))
- fix\(doc\): broken links [\#2781](https://github.com/apache/camel-k/pull/2781) ([squakez](https://github.com/squakez))
- lint [\#2780](https://github.com/apache/camel-k/pull/2780) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: Upgrade Spectrum and go-containerregistry [\#2779](https://github.com/apache/camel-k/pull/2779) ([astefanutti](https://github.com/astefanutti))
- doc: cleaning [\#2778](https://github.com/apache/camel-k/pull/2778) ([squakez](https://github.com/squakez))
- fix\(build\): default jitpack to main [\#2775](https://github.com/apache/camel-k/pull/2775) ([squakez](https://github.com/squakez))
- doc\(install\): suggested resource configuration [\#2774](https://github.com/apache/camel-k/pull/2774) ([squakez](https://github.com/squakez))
- feat\(cmd/run\): autogenerated configmap for resource/config local files [\#2771](https://github.com/apache/camel-k/pull/2771) ([squakez](https://github.com/squakez))
- chore\(release\): Update latest released version and OLM base CSV manifest [\#2770](https://github.com/apache/camel-k/pull/2770) ([astefanutti](https://github.com/astefanutti))
- chore\(build\): Upgrade Maven to version 3.8.4 [\#2767](https://github.com/apache/camel-k/pull/2767) ([astefanutti](https://github.com/astefanutti))
- gosec [\#2766](https://github.com/apache/camel-k/pull/2766) ([lburgazzoli](https://github.com/lburgazzoli))
- Update the operator-sdk version [\#2755](https://github.com/apache/camel-k/pull/2755) ([phantomjinx](https://github.com/phantomjinx))
- Fix \#2638: fix condition for external kit and add test [\#2754](https://github.com/apache/camel-k/pull/2754) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(release\): Remove staging repository [\#2750](https://github.com/apache/camel-k/pull/2750) ([astefanutti](https://github.com/astefanutti))
- chore\(e2e\): disable object truncation on test results [\#2745](https://github.com/apache/camel-k/pull/2745) ([tadayosi](https://github.com/tadayosi))
- feat: Health trait [\#2740](https://github.com/apache/camel-k/pull/2740) ([astefanutti](https://github.com/astefanutti))
- feat\(cmd\): OLM default discovery [\#2735](https://github.com/apache/camel-k/pull/2735) ([squakez](https://github.com/squakez))
- fix\(e2e\): Update latest released version to fix upgrade tests [\#2734](https://github.com/apache/camel-k/pull/2734) ([astefanutti](https://github.com/astefanutti))
- chore: Upgrade Knative to version 1.0.0 [\#2733](https://github.com/apache/camel-k/pull/2733) ([astefanutti](https://github.com/astefanutti))
- Add pojo-jar example [\#2731](https://github.com/apache/camel-k/pull/2731) ([dweber019](https://github.com/dweber019))
- feat\(cmd\): operator additional info [\#2730](https://github.com/apache/camel-k/pull/2730) ([squakez](https://github.com/squakez))
- chore\(sbo\): upgrade Servce Binding Operator to 1.0.0 GA [\#2729](https://github.com/apache/camel-k/pull/2729) ([johnpoth](https://github.com/johnpoth))
- Fix \#2724: assign an ID to the binding main route [\#2727](https://github.com/apache/camel-k/pull/2727) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(e2e\): temporarily disable TestKameletBindingScale test for OpenShift 3 [\#2723](https://github.com/apache/camel-k/pull/2723) ([tadayosi](https://github.com/tadayosi))
- update site links to point to 'next' [\#2722](https://github.com/apache/camel-k/pull/2722) ([jbpratt](https://github.com/jbpratt))
- chore: Set indent size for Go files in .editorconfig [\#2721](https://github.com/apache/camel-k/pull/2721) ([astefanutti](https://github.com/astefanutti))
- Some more e2e stabilisation & improvements [\#2720](https://github.com/apache/camel-k/pull/2720) ([tadayosi](https://github.com/tadayosi))
- feat: Report runtime health checks into Integration readiness condition [\#2719](https://github.com/apache/camel-k/pull/2719) ([astefanutti](https://github.com/astefanutti))
- camel k main latest to next [\#2716](https://github.com/apache/camel-k/pull/2716) ([djencks](https://github.com/djencks))
- \[TEST\] Add cross-channel upgrade test feature [\#2715](https://github.com/apache/camel-k/pull/2715) ([bouskaJ](https://github.com/bouskaJ))
- chore\(ci\): update to golangci-lint 1.42.x and use golangci/golangci-lint-action [\#2714](https://github.com/apache/camel-k/pull/2714) ([tadayosi](https://github.com/tadayosi))
- E2E development allowing injection of secrets denoting testing on custom clusters [\#2711](https://github.com/apache/camel-k/pull/2711) ([phantomjinx](https://github.com/phantomjinx))
- fix refs to camel-quarkus docs to point to latest released version [\#2708](https://github.com/apache/camel-k/pull/2708) ([djencks](https://github.com/djencks))
- fix\(ci\): proper action/staleV3 configuration [\#2707](https://github.com/apache/camel-k/pull/2707) ([squakez](https://github.com/squakez))
- chore\(dev\): add .editorconfig [\#2705](https://github.com/apache/camel-k/pull/2705) ([tadayosi](https://github.com/tadayosi))
- fix: Avoid operator panic when Quarkus fast-jar directory is empty [\#2704](https://github.com/apache/camel-k/pull/2704) ([astefanutti](https://github.com/astefanutti))
- fix: Use a single operator and CLI client globally [\#2703](https://github.com/apache/camel-k/pull/2703) ([astefanutti](https://github.com/astefanutti))
- fix\(script\): goldflag with empty space [\#2701](https://github.com/apache/camel-k/pull/2701) ([squakez](https://github.com/squakez))
- CI test dump improvements [\#2700](https://github.com/apache/camel-k/pull/2700) ([tadayosi](https://github.com/tadayosi))
- fix\(ci\): broken stale action [\#2699](https://github.com/apache/camel-k/pull/2699) ([squakez](https://github.com/squakez))
- Fix \#2687: Allow multiple integration platforms in the same namespace [\#2695](https://github.com/apache/camel-k/pull/2695) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(runtime\): update to Camel K Runtime 1.10.0-SNAPSHOT [\#2694](https://github.com/apache/camel-k/pull/2694) ([tadayosi](https://github.com/tadayosi))
- chore: Bypass cache round-trips to reconcile integration status [\#2692](https://github.com/apache/camel-k/pull/2692) ([astefanutti](https://github.com/astefanutti))
- fix: Integration readiness status should account for updated replicas [\#2691](https://github.com/apache/camel-k/pull/2691) ([astefanutti](https://github.com/astefanutti))
- fix: Round meta.Time fields to second precision as they are marshalled in RFC3339 format [\#2689](https://github.com/apache/camel-k/pull/2689) ([astefanutti](https://github.com/astefanutti))
- chore\(builder\): Self-defined Build spec [\#2688](https://github.com/apache/camel-k/pull/2688) ([astefanutti](https://github.com/astefanutti))
- fix\(e2e\): Resolve kamel bind e2e test conflict [\#2686](https://github.com/apache/camel-k/pull/2686) ([astefanutti](https://github.com/astefanutti))
- Fix \#1943: allow multiple operators to reconcile label filtered resources [\#2683](https://github.com/apache/camel-k/pull/2683) ([nicolaferraro](https://github.com/nicolaferraro))
- feat: Comprehensive Integration error status [\#2682](https://github.com/apache/camel-k/pull/2682) ([astefanutti](https://github.com/astefanutti))
- fix\(cli\): apply --registry\* flags even on OpenShift for kamel install [\#2681](https://github.com/apache/camel-k/pull/2681) ([tadayosi](https://github.com/tadayosi))
- \[TEST\] Missing cli tests were added [\#2680](https://github.com/apache/camel-k/pull/2680) ([vsokolovskii](https://github.com/vsokolovskii))
- \[TEST\] Global kamelet test - support for openshift [\#2679](https://github.com/apache/camel-k/pull/2679) ([asmigala](https://github.com/asmigala))
- feat: Add active-deadline-seconds and backoff-limit options to cron trait [\#2678](https://github.com/apache/camel-k/pull/2678) ([astefanutti](https://github.com/astefanutti))
- feat: Add progress-deadline-seconds option to deployment trait [\#2677](https://github.com/apache/camel-k/pull/2677) ([astefanutti](https://github.com/astefanutti))
- fix\(cli\): kamel install fails with error: Object 'Kind' is missing in 'null' [\#2676](https://github.com/apache/camel-k/pull/2676) ([tadayosi](https://github.com/tadayosi))
- doc\(dev\): update required Go version to 1.16 [\#2675](https://github.com/apache/camel-k/pull/2675) ([tadayosi](https://github.com/tadayosi))
- chore\(cli\): Add operator env vars option to install CLI [\#2673](https://github.com/apache/camel-k/pull/2673) ([astefanutti](https://github.com/astefanutti))
- fix\(ci\): Disable default Kamelets installation for builder e2e tests [\#2672](https://github.com/apache/camel-k/pull/2672) ([astefanutti](https://github.com/astefanutti))
- fix\(build\): Update Maven binary download URL [\#2671](https://github.com/apache/camel-k/pull/2671) ([astefanutti](https://github.com/astefanutti))
- fix: Handle Integration changes while waiting for Kit build [\#2670](https://github.com/apache/camel-k/pull/2670) ([astefanutti](https://github.com/astefanutti))
- chore: Parallel Kamelets reconciliation [\#2668](https://github.com/apache/camel-k/pull/2668) ([astefanutti](https://github.com/astefanutti))
- feat\(native\): Add support for Knative service gradual roll-out [\#2667](https://github.com/apache/camel-k/pull/2667) ([astefanutti](https://github.com/astefanutti))
- fix: Affinity trait must run after the Knative Service trait [\#2666](https://github.com/apache/camel-k/pull/2666) ([astefanutti](https://github.com/astefanutti))
- chore\(jolokia\): upgrade to Jolokia 1.7.1 [\#2665](https://github.com/apache/camel-k/pull/2665) ([tadayosi](https://github.com/tadayosi))
- chore : automatic PR creation to update "peripheral" go dependencies [\#2664](https://github.com/apache/camel-k/pull/2664) ([apupier](https://github.com/apupier))
- feat: Consistent Integration scale status [\#2662](https://github.com/apache/camel-k/pull/2662) ([astefanutti](https://github.com/astefanutti))
- chore: refresh kamelets also when operator version does not change an… [\#2661](https://github.com/apache/camel-k/pull/2661) ([nicolaferraro](https://github.com/nicolaferraro))
- Make quarkus dependencies management more robust [\#2658](https://github.com/apache/camel-k/pull/2658) ([doru1004](https://github.com/doru1004))
- chore\(ci\): Use `github.head_ref` as concurrency group key [\#2657](https://github.com/apache/camel-k/pull/2657) ([astefanutti](https://github.com/astefanutti))
-  Output redirection Fix: \#2495 [\#2656](https://github.com/apache/camel-k/pull/2656) ([vsokolovskii](https://github.com/vsokolovskii))
- chore\(build\): Upgrade Go dependencies [\#2655](https://github.com/apache/camel-k/pull/2655) ([astefanutti](https://github.com/astefanutti))
- Fix local builds from directory for containerized and non-containerized uses. [\#2654](https://github.com/apache/camel-k/pull/2654) ([doru1004](https://github.com/doru1004))
- \[TEST\] Global test - support for openshift [\#2653](https://github.com/apache/camel-k/pull/2653) ([bouskaJ](https://github.com/bouskaJ))
- Update dependencies.adoc [\#2651](https://github.com/apache/camel-k/pull/2651) ([hadoken79](https://github.com/hadoken79))
- feat\(trait\): environment variables [\#2650](https://github.com/apache/camel-k/pull/2650) ([squakez](https://github.com/squakez))
- fix: Switch off color in Maven logs [\#2647](https://github.com/apache/camel-k/pull/2647) ([astefanutti](https://github.com/astefanutti))
- Alow fixed custom labels in any pod [\#2646](https://github.com/apache/camel-k/pull/2646) ([claudio4j](https://github.com/claudio4j))
- fix: Unify post-build integration phases reconciliation [\#2645](https://github.com/apache/camel-k/pull/2645) ([astefanutti](https://github.com/astefanutti))
- Fix \#2638: sync owned integration kit to avoid gc [\#2639](https://github.com/apache/camel-k/pull/2639) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix documentation for building website [\#2637](https://github.com/apache/camel-k/pull/2637) ([oscerd](https://github.com/oscerd))
- Fixed website build [\#2636](https://github.com/apache/camel-k/pull/2636) ([oscerd](https://github.com/oscerd))
- feat\(trait\): camel trait to include properties [\#2635](https://github.com/apache/camel-k/pull/2635) ([squakez](https://github.com/squakez))
- doc: architecture \> runtime section [\#2634](https://github.com/apache/camel-k/pull/2634) ([squakez](https://github.com/squakez))
- doc\(native\): Add package type tag to build metrics [\#2632](https://github.com/apache/camel-k/pull/2632) ([astefanutti](https://github.com/astefanutti))
- chore\(native\): Fail-fast native build for unsupported languages [\#2631](https://github.com/apache/camel-k/pull/2631) ([astefanutti](https://github.com/astefanutti))
- chore: stale bot configuration [\#2630](https://github.com/apache/camel-k/pull/2630) ([squakez](https://github.com/squakez))
- fix\(doc\): escape characters in trait doc [\#2628](https://github.com/apache/camel-k/pull/2628) ([squakez](https://github.com/squakez))
- Upgrade sbo [\#2627](https://github.com/apache/camel-k/pull/2627) ([johnpoth](https://github.com/johnpoth))
- chore\(release\): Update OLM base CSV manifest [\#2624](https://github.com/apache/camel-k/pull/2624) ([astefanutti](https://github.com/astefanutti))
- Fix \#2616: correctly encode numbers in Kamelet parameters [\#2617](https://github.com/apache/camel-k/pull/2617) ([nicolaferraro](https://github.com/nicolaferraro))
- \[website\] fix attribute usage, and put the crd html file in partials [\#2614](https://github.com/apache/camel-k/pull/2614) ([djencks](https://github.com/djencks))
- chore: Update embedded catalog to 1.9.0-SNAPSHOT runtime [\#2613](https://github.com/apache/camel-k/pull/2613) ([astefanutti](https://github.com/astefanutti))
- fix\(ci\): Update latest release version to 1.5.1 [\#2612](https://github.com/apache/camel-k/pull/2612) ([astefanutti](https://github.com/astefanutti))
- Bump Camel K Runtime to 1.9.x [\#2611](https://github.com/apache/camel-k/pull/2611) ([orpiske](https://github.com/orpiske))
- fix\(ci\): Fix YAKS binary download [\#2610](https://github.com/apache/camel-k/pull/2610) ([astefanutti](https://github.com/astefanutti))
- doc\(kamelets\): trait array vaue syntax [\#2609](https://github.com/apache/camel-k/pull/2609) ([squakez](https://github.com/squakez))
- Update dependencies.adoc [\#2607](https://github.com/apache/camel-k/pull/2607) ([mmacphail](https://github.com/mmacphail))
- Fix \#2487: do not directly delete owned integrations on reset [\#2603](https://github.com/apache/camel-k/pull/2603) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(build\): use batch-mode for maven-overlay task in CI [\#2601](https://github.com/apache/camel-k/pull/2601) ([tadayosi](https://github.com/tadayosi))
- doc\(dependencies\): note on dynamic URIs [\#2599](https://github.com/apache/camel-k/pull/2599) ([squakez](https://github.com/squakez))
- fix\(kamelets\): error handler uri autodiscovery [\#2597](https://github.com/apache/camel-k/pull/2597) ([squakez](https://github.com/squakez))
- chore\(strimzi\): upgrade API to v1beta2 [\#2595](https://github.com/apache/camel-k/pull/2595) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(jolokia\): upgrade to Jolokia 1.7.0 [\#2594](https://github.com/apache/camel-k/pull/2594) ([tadayosi](https://github.com/tadayosi))
- Kamelet binding sbo [\#2592](https://github.com/apache/camel-k/pull/2592) ([johnpoth](https://github.com/johnpoth))
- Fix typo [\#2588](https://github.com/apache/camel-k/pull/2588) ([mmacphail](https://github.com/mmacphail))
- feat\(cmd/bind\): error-handler setting [\#2587](https://github.com/apache/camel-k/pull/2587) ([squakez](https://github.com/squakez))
- doc: contribute links [\#2584](https://github.com/apache/camel-k/pull/2584) ([squakez](https://github.com/squakez))
- feat\(trait\): container image pull policy [\#2583](https://github.com/apache/camel-k/pull/2583) ([squakez](https://github.com/squakez))
- Fix \#2486: make kamelet binding scalable [\#2582](https://github.com/apache/camel-k/pull/2582) ([nicolaferraro](https://github.com/nicolaferraro))
- doc\(kamelets\): trait annotation usage and examples [\#2581](https://github.com/apache/camel-k/pull/2581) ([squakez](https://github.com/squakez))
- Reworked logging trait dependencies [\#2580](https://github.com/apache/camel-k/pull/2580) ([orpiske](https://github.com/orpiske))
- trait: Add tests for route trait and read certificate from secrets [\#2577](https://github.com/apache/camel-k/pull/2577) ([claudio4j](https://github.com/claudio4j))
- fix\(cmd/bind\): show expected kameletbinding [\#2575](https://github.com/apache/camel-k/pull/2575) ([squakez](https://github.com/squakez))
- ad \[FUSEQE-13946\] Probably incorrect integration name [\#2572](https://github.com/apache/camel-k/pull/2572) ([lfabriko](https://github.com/lfabriko))
- fix\(cli\): modeline build-property check [\#2571](https://github.com/apache/camel-k/pull/2571) ([squakez](https://github.com/squakez))
- fix\(cli\): property priority [\#2570](https://github.com/apache/camel-k/pull/2570) ([squakez](https://github.com/squakez))
- fix\(api\): property leading space [\#2564](https://github.com/apache/camel-k/pull/2564) ([squakez](https://github.com/squakez))
- fix TestPermissionDenied should ignore darwin  [\#2561](https://github.com/apache/camel-k/pull/2561) ([Abirdcfly](https://github.com/Abirdcfly))
- fix\(controller\): panic on nil annotation [\#2557](https://github.com/apache/camel-k/pull/2557) ([Abirdcfly](https://github.com/Abirdcfly))
- postgres user on readme was different than the one created on the yam… [\#2554](https://github.com/apache/camel-k/pull/2554) ([josetesan](https://github.com/josetesan))
- chore\(rbac\): Remove attributeRestrictions fields [\#2552](https://github.com/apache/camel-k/pull/2552) ([astefanutti](https://github.com/astefanutti))
- fix: Fix cross-namespace creator resource events [\#2547](https://github.com/apache/camel-k/pull/2547) ([astefanutti](https://github.com/astefanutti))
- fix\(builder\): Fix race-condition when Build transitions to running phase [\#2545](https://github.com/apache/camel-k/pull/2545) ([astefanutti](https://github.com/astefanutti))
- Move bool pointer functions to trait package and use them throughout the traits [\#2543](https://github.com/apache/camel-k/pull/2543) ([tadayosi](https://github.com/tadayosi))
- Forcelly set QUARKUS\_LOG\_CONSOLE\_JSON to false if the trait is not provided \(GH issue \#2539\) [\#2540](https://github.com/apache/camel-k/pull/2540) ([orpiske](https://github.com/orpiske))
- feat: Quarkus native build support [\#2536](https://github.com/apache/camel-k/pull/2536) ([astefanutti](https://github.com/astefanutti))
- Fix \#2530: fix type and do not add cross-namespace owner references [\#2535](https://github.com/apache/camel-k/pull/2535) ([nicolaferraro](https://github.com/nicolaferraro))
- chore: add support for darwin/atm64 [\#2532](https://github.com/apache/camel-k/pull/2532) ([lburgazzoli](https://github.com/lburgazzoli))
- \[test\] Remove 3rd party dependencies [\#2529](https://github.com/apache/camel-k/pull/2529) ([bouskaJ](https://github.com/bouskaJ))
- Allow Probe Scheme to Be Customized [\#2527](https://github.com/apache/camel-k/pull/2527) ([Kyle-Cooley](https://github.com/Kyle-Cooley))
- fix\(controller\): panic on nil application properties [\#2526](https://github.com/apache/camel-k/pull/2526) ([squakez](https://github.com/squakez))
- \[test\] add Kamelet errorHandler test [\#2522](https://github.com/apache/camel-k/pull/2522) ([bouskaJ](https://github.com/bouskaJ))
- doc: Improve Helm configuration section and architecture integration platform [\#2521](https://github.com/apache/camel-k/pull/2521) ([toonalbers](https://github.com/toonalbers))
- Use https instead of http for xsd location [\#2517](https://github.com/apache/camel-k/pull/2517) ([apupier](https://github.com/apupier))
- Add classpath kamelet loading test [\#2516](https://github.com/apache/camel-k/pull/2516) ([bouskaJ](https://github.com/bouskaJ))
- fix\(\#2514\): Fix tar.gz changes the uid/gid of cwd [\#2515](https://github.com/apache/camel-k/pull/2515) ([christophd](https://github.com/christophd))
- Fix Typo [\#2511](https://github.com/apache/camel-k/pull/2511) ([mattheh](https://github.com/mattheh))
- chore\(release\): bump version to 1.6.0-SNAPSHOT and remove deprecated … [\#2510](https://github.com/apache/camel-k/pull/2510) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(examples\): AMQP connection bean [\#2508](https://github.com/apache/camel-k/pull/2508) ([squakez](https://github.com/squakez))
- \[Examples\] Use correct folder in resource-secret-route example [\#2506](https://github.com/apache/camel-k/pull/2506) ([avano](https://github.com/avano))
- chore\(trait\): pull-secret unit test [\#2505](https://github.com/apache/camel-k/pull/2505) ([squakez](https://github.com/squakez))
- \#2358: Possible to skip configuring of registry when installing via cli [\#2497](https://github.com/apache/camel-k/pull/2497) ([phantomjinx](https://github.com/phantomjinx))
- fix\(cmd/bind\): nullable error-handler [\#2496](https://github.com/apache/camel-k/pull/2496) ([squakez](https://github.com/squakez))
- doc: remove programmatic datasource example [\#2491](https://github.com/apache/camel-k/pull/2491) ([squakez](https://github.com/squakez))
- fix\(cli\): kamel uninstall should delete kamelets \#2479 [\#2489](https://github.com/apache/camel-k/pull/2489) ([tadayosi](https://github.com/tadayosi))
- chore\(sbo-trait\): Upgrade Service Binding Operator to v0.8.0 [\#2488](https://github.com/apache/camel-k/pull/2488) ([johnpoth](https://github.com/johnpoth))
- Fix \#2482: ServiceBinding CR should tied to the IntegrationPhaseWaiti… [\#2483](https://github.com/apache/camel-k/pull/2483) ([johnpoth](https://github.com/johnpoth))
- chore\(release\): prepare 1.5.0 release [\#2478](https://github.com/apache/camel-k/pull/2478) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(cmd/run\): windows scheme support [\#2477](https://github.com/apache/camel-k/pull/2477) ([squakez](https://github.com/squakez))
- Fix \#2468: parse all YAML nodes in the tree [\#2476](https://github.com/apache/camel-k/pull/2476) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(cli\) Duplicated trait set as modeline and kamel run parameters causes error [\#2467](https://github.com/apache/camel-k/pull/2467) ([claudio4j](https://github.com/claudio4j))
- doc\(architecture\): trait section [\#2465](https://github.com/apache/camel-k/pull/2465) ([squakez](https://github.com/squakez))
- test: Missing cli e2e tests implementation [\#2461](https://github.com/apache/camel-k/pull/2461) ([vsokolovskii](https://github.com/vsokolovskii))
- chore: Remove Camel Sources support from Knative trait [\#2460](https://github.com/apache/camel-k/pull/2460) ([astefanutti](https://github.com/astefanutti))
- chore: Update embedded camel-catalog-1.8.0-SNAPSHOT.yaml [\#2459](https://github.com/apache/camel-k/pull/2459) ([astefanutti](https://github.com/astefanutti))
- chore: Remove unsupported probe-path property from container trait [\#2458](https://github.com/apache/camel-k/pull/2458) ([astefanutti](https://github.com/astefanutti))
- fix: Filter influencing traits to lookup matching kits [\#2457](https://github.com/apache/camel-k/pull/2457) ([astefanutti](https://github.com/astefanutti))
- Align to Quarkus documentation [\#2455](https://github.com/apache/camel-k/pull/2455) ([oscerd](https://github.com/oscerd))
- fix: Unrecognized configuration from quarkus-logging-json [\#2454](https://github.com/apache/camel-k/pull/2454) ([astefanutti](https://github.com/astefanutti))
- fix: Correct Quarkus default health probe path [\#2453](https://github.com/apache/camel-k/pull/2453) ([astefanutti](https://github.com/astefanutti))
- Remove the unnecessary indefinite articles in the list. in documentat… [\#2452](https://github.com/apache/camel-k/pull/2452) ([apupier](https://github.com/apupier))
- Remove the unnecessary indefinite articles in the list. in documentat… [\#2451](https://github.com/apache/camel-k/pull/2451) ([apupier](https://github.com/apupier))
- fix cron trait issue [\#2448](https://github.com/apache/camel-k/pull/2448) ([liurui-1](https://github.com/liurui-1))
- Revert "Temporarily disable qute due to Camel Quarkus issue \#2701" [\#2447](https://github.com/apache/camel-k/pull/2447) ([orpiske](https://github.com/orpiske))
- Fix \#2441: parse parameters in YAML DSL [\#2442](https://github.com/apache/camel-k/pull/2442) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(api\): Remove obsolete failure field From Integration API [\#2440](https://github.com/apache/camel-k/pull/2440) ([astefanutti](https://github.com/astefanutti))
- doc: readme cleanup [\#2433](https://github.com/apache/camel-k/pull/2433) ([squakez](https://github.com/squakez))
- chore\(doc\): drop Minishift from documentation and install script \#2428 [\#2431](https://github.com/apache/camel-k/pull/2431) ([tadayosi](https://github.com/tadayosi))
- chore: Remove Camel Sources support [\#2430](https://github.com/apache/camel-k/pull/2430) ([astefanutti](https://github.com/astefanutti))
- fix\(doc\): examples link [\#2429](https://github.com/apache/camel-k/pull/2429) ([squakez](https://github.com/squakez))
- feat\(trait\): jvm classpath [\#2427](https://github.com/apache/camel-k/pull/2427) ([squakez](https://github.com/squakez))
- Sync main with the latest changes from camel-main [\#2426](https://github.com/apache/camel-k/pull/2426) ([orpiske](https://github.com/orpiske))
- feat\(knative\): upgrade Knative to 0.23 \#2343 [\#2424](https://github.com/apache/camel-k/pull/2424) ([tadayosi](https://github.com/tadayosi))
- fix\(cmd/run\): secret/configmap as property file [\#2423](https://github.com/apache/camel-k/pull/2423) ([squakez](https://github.com/squakez))
- \[e2e-tests\] cli test \(without kamel debug\) [\#2422](https://github.com/apache/camel-k/pull/2422) ([vsokolovskii](https://github.com/vsokolovskii))
- fix\(trait\): never fallback to client-side apply unless server-side apply is incombatible [\#2421](https://github.com/apache/camel-k/pull/2421) ([tadayosi](https://github.com/tadayosi))
- chore\(ci\): upgrade Knative versions in CI to latest possible [\#2420](https://github.com/apache/camel-k/pull/2420) ([tadayosi](https://github.com/tadayosi))
- fix\(cli\): resource path with quotes and spaces [\#2419](https://github.com/apache/camel-k/pull/2419) ([squakez](https://github.com/squakez))
- Precise requirements on Minikube instance for development [\#2416](https://github.com/apache/camel-k/pull/2416) ([apupier](https://github.com/apupier))
- refactor\(trait\): use bool pointer util functions in knative trait [\#2415](https://github.com/apache/camel-k/pull/2415) ([tadayosi](https://github.com/tadayosi))
- chore\(build\): Some more go.sum updates [\#2413](https://github.com/apache/camel-k/pull/2413) ([astefanutti](https://github.com/astefanutti))
- chore\(e2e\): Check Deployment progressing condition after re-run [\#2412](https://github.com/apache/camel-k/pull/2412) ([astefanutti](https://github.com/astefanutti))
- Doc: new configuration explained [\#2411](https://github.com/apache/camel-k/pull/2411) ([squakez](https://github.com/squakez))
- fix\(cli\): Use Patch with optimistic lock to update Integration [\#2410](https://github.com/apache/camel-k/pull/2410) ([astefanutti](https://github.com/astefanutti))
- chore: Upgrade Kubernetes API to v0.20.2 [\#2407](https://github.com/apache/camel-k/pull/2407) ([astefanutti](https://github.com/astefanutti))
- Update link to video to debug in VS Code [\#2406](https://github.com/apache/camel-k/pull/2406) ([apupier](https://github.com/apupier))
- chore\(build\): Upgrade Go to version 1.15 [\#2404](https://github.com/apache/camel-k/pull/2404) ([astefanutti](https://github.com/astefanutti))
- chore\(trait\): Polish Logging trait documentation [\#2403](https://github.com/apache/camel-k/pull/2403) ([astefanutti](https://github.com/astefanutti))
- fix\(e2e\): Remove image pull secret e2e test race conditions [\#2402](https://github.com/apache/camel-k/pull/2402) ([astefanutti](https://github.com/astefanutti))
- chore: Upgrade controller-runtime to v0.8.3 [\#2401](https://github.com/apache/camel-k/pull/2401) ([astefanutti](https://github.com/astefanutti))
- fix\(trait\): ImagePullSecrets are not configured when the Integration is running [\#2399](https://github.com/apache/camel-k/pull/2399) ([claudio4j](https://github.com/claudio4j))
- chore\(build\): Cancel s2i Build on context cancellation or timeout [\#2398](https://github.com/apache/camel-k/pull/2398) ([astefanutti](https://github.com/astefanutti))
- fix\(RBAC\): Add permission to send termination signals to builder pods [\#2393](https://github.com/apache/camel-k/pull/2393) ([astefanutti](https://github.com/astefanutti))
- chore\(e2e\): allow e2e to use nexus mirror to speed up testing \#2387 [\#2392](https://github.com/apache/camel-k/pull/2392) ([tadayosi](https://github.com/tadayosi))
- chore\(doc\): Tidy observability documentation [\#2390](https://github.com/apache/camel-k/pull/2390) ([astefanutti](https://github.com/astefanutti))
- chore\(doc\): Add autoscaling with Knative documentation [\#2386](https://github.com/apache/camel-k/pull/2386) ([astefanutti](https://github.com/astefanutti))
- Fixes website build [\#2385](https://github.com/apache/camel-k/pull/2385) ([oscerd](https://github.com/oscerd))
- S3 dependencies [\#2383](https://github.com/apache/camel-k/pull/2383) ([johnpoth](https://github.com/johnpoth))
- doc\(kamelets\): debugging simple notice [\#2381](https://github.com/apache/camel-k/pull/2381) ([squakez](https://github.com/squakez))
- Removed the deprecated --logging-level option \(issue \#2000\) [\#2377](https://github.com/apache/camel-k/pull/2377) ([orpiske](https://github.com/orpiske))
- chore\(doc\): Fix Pod trait documentation formatting [\#2373](https://github.com/apache/camel-k/pull/2373) ([astefanutti](https://github.com/astefanutti))
- chore\(e2e\): remove duplicate test in knative tests [\#2372](https://github.com/apache/camel-k/pull/2372) ([tadayosi](https://github.com/tadayosi))
- Fix \#2361: allow multiline properties by correctly encoding them [\#2369](https://github.com/apache/camel-k/pull/2369) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(doc\): Remove deprecated Camel Sources documentation [\#2368](https://github.com/apache/camel-k/pull/2368) ([astefanutti](https://github.com/astefanutti))
- chore\(ci\): kourier versions not necessarily bound to knative-serving [\#2367](https://github.com/apache/camel-k/pull/2367) ([tadayosi](https://github.com/tadayosi))
- chore\(ci\): Do not execute e2e tests on documentation changes [\#2366](https://github.com/apache/camel-k/pull/2366) ([astefanutti](https://github.com/astefanutti))
- chore\(doc\): Update high-level architecture diagram [\#2362](https://github.com/apache/camel-k/pull/2362) ([astefanutti](https://github.com/astefanutti))
- Make it possible to define the container image without IntegrationKit [\#2360](https://github.com/apache/camel-k/pull/2360) ([lburgazzoli](https://github.com/lburgazzoli))
- Update README to reflect where Sample.java is [\#2359](https://github.com/apache/camel-k/pull/2359) ([bentito](https://github.com/bentito))
- feat\(cmd/run\): resource option refactoring  [\#2355](https://github.com/apache/camel-k/pull/2355) ([squakez](https://github.com/squakez))
- Related to \#2165: account for annotations when checking if integratio… [\#2352](https://github.com/apache/camel-k/pull/2352) ([nicolaferraro](https://github.com/nicolaferraro))
- feat\(cli\): add sub command kamel kamelet for get and delete \#2312 [\#2351](https://github.com/apache/camel-k/pull/2351) ([tadayosi](https://github.com/tadayosi))
- fix\(cli\): stop printing \<nil\> at the end of kamel describe output [\#2350](https://github.com/apache/camel-k/pull/2350) ([tadayosi](https://github.com/tadayosi))
- chore\(build\): Cancellable Maven operations [\#2348](https://github.com/apache/camel-k/pull/2348) ([astefanutti](https://github.com/astefanutti))
- feat\(cli\): support k8s api shortnames for kit & platform with kamel describe [\#2346](https://github.com/apache/camel-k/pull/2346) ([tadayosi](https://github.com/tadayosi))
- feat\(cli\): initial support for describing Kamelets with kamel describe \#2312 [\#2345](https://github.com/apache/camel-k/pull/2345) ([tadayosi](https://github.com/tadayosi))
- chore\(api\): Encapsulate Maven properties [\#2344](https://github.com/apache/camel-k/pull/2344) ([astefanutti](https://github.com/astefanutti))
- Starting deadline seconds [\#2342](https://github.com/apache/camel-k/pull/2342) ([zach-robinson](https://github.com/zach-robinson))
- Add link to the github repo [\#2340](https://github.com/apache/camel-k/pull/2340) ([davidlanouette](https://github.com/davidlanouette))
- feat\(cmd/run\): --config option flag [\#2339](https://github.com/apache/camel-k/pull/2339) ([squakez](https://github.com/squakez))
- Fix \#2165: allow configuring traits via annotations [\#2338](https://github.com/apache/camel-k/pull/2338) ([nicolaferraro](https://github.com/nicolaferraro))
- kamelets: add condition to report when an integration is stuck waiting for them [\#2337](https://github.com/apache/camel-k/pull/2337) ([lburgazzoli](https://github.com/lburgazzoli))
- doc\(dev\): add instruction for deploying custom images to remote clusters [\#2336](https://github.com/apache/camel-k/pull/2336) ([tadayosi](https://github.com/tadayosi))
- feat\(cli\): make kamel delete command aware of KameletBindings [\#2332](https://github.com/apache/camel-k/pull/2332) ([tadayosi](https://github.com/tadayosi))
- feat\(cmd/run\): property configuration refactoring [\#2329](https://github.com/apache/camel-k/pull/2329) ([squakez](https://github.com/squakez))
- Extra repositories [\#2328](https://github.com/apache/camel-k/pull/2328) ([johnpoth](https://github.com/johnpoth))
- Added K3s to the registry section of navbar [\#2325](https://github.com/apache/camel-k/pull/2325) ([oscerd](https://github.com/oscerd))
- Nav Bar: Titles fixed [\#2324](https://github.com/apache/camel-k/pull/2324) ([oscerd](https://github.com/oscerd))
- Fix Route Trait Crash [\#2323](https://github.com/apache/camel-k/pull/2323) ([Kyle-Cooley](https://github.com/Kyle-Cooley))
- Updated the nav bar with all the installations [\#2322](https://github.com/apache/camel-k/pull/2322) ([oscerd](https://github.com/oscerd))
- \[TEST\] Increase timeouts for slow infra [\#2319](https://github.com/apache/camel-k/pull/2319) ([bouskaJ](https://github.com/bouskaJ))
- Fix \#2315: Add leader-election flag to Operator command [\#2316](https://github.com/apache/camel-k/pull/2316) ([johnpoth](https://github.com/johnpoth))
- Fix \#2236: Add Service Binding E2E test [\#2314](https://github.com/apache/camel-k/pull/2314) ([johnpoth](https://github.com/johnpoth))
- Check if the environment can produce structured Maven logs before parsing them [\#2311](https://github.com/apache/camel-k/pull/2311) ([orpiske](https://github.com/orpiske))
- chore\(ci\): Use `github.ref` instead of `github.head_ref` as concurrency group key [\#2310](https://github.com/apache/camel-k/pull/2310) ([astefanutti](https://github.com/astefanutti))
- feat\(cmd\): build-property flag [\#2309](https://github.com/apache/camel-k/pull/2309) ([squakez](https://github.com/squakez))
- Fix \#2237: add flag to disable installation of default kamelets [\#2308](https://github.com/apache/camel-k/pull/2308) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(ci\): Cancel running workflows when PRs are updated [\#2304](https://github.com/apache/camel-k/pull/2304) ([astefanutti](https://github.com/astefanutti))
- chore: Make phase structured logging key a string [\#2303](https://github.com/apache/camel-k/pull/2303) ([astefanutti](https://github.com/astefanutti))
- chore\(cli\): Update CRDs when force installing cluster resources [\#2301](https://github.com/apache/camel-k/pull/2301) ([astefanutti](https://github.com/astefanutti))
- chore: Update .asf.yaml file with project page link [\#2300](https://github.com/apache/camel-k/pull/2300) ([astefanutti](https://github.com/astefanutti))
- chore: Update README badges [\#2298](https://github.com/apache/camel-k/pull/2298) ([astefanutti](https://github.com/astefanutti))
- chore\(e2e\): config test [\#2295](https://github.com/apache/camel-k/pull/2295) ([squakez](https://github.com/squakez))
- fix\(test\) - toleration trait test [\#2294](https://github.com/apache/camel-k/pull/2294) ([tplevko](https://github.com/tplevko))
- Added documentation about installing Camel K on Kind [\#2293](https://github.com/apache/camel-k/pull/2293) ([orpiske](https://github.com/orpiske))
- fix\(integration\) Integration not marked as Failed when Camel is unabl… [\#2292](https://github.com/apache/camel-k/pull/2292) ([claudio4j](https://github.com/claudio4j))
- Configure kubernetes to use structured log [\#2290](https://github.com/apache/camel-k/pull/2290) ([orpiske](https://github.com/orpiske))
- fix\(doc\): camel website error fixes [\#2288](https://github.com/apache/camel-k/pull/2288) ([squakez](https://github.com/squakez))
- chore\(e2e\): Assert upgraded integration Pod uses new version Kit [\#2285](https://github.com/apache/camel-k/pull/2285) ([astefanutti](https://github.com/astefanutti))
- Creates alternative kustomize installer for installation of the camel-k operator [\#2284](https://github.com/apache/camel-k/pull/2284) ([phantomjinx](https://github.com/phantomjinx))
- chore\(e2e\): Remove obsolete operator upgrade e2e test [\#2283](https://github.com/apache/camel-k/pull/2283) ([astefanutti](https://github.com/astefanutti))
- fix\(doc\): broken links [\#2282](https://github.com/apache/camel-k/pull/2282) ([squakez](https://github.com/squakez))
- fix\(e2e\): Fix OLM upgrade e2e test [\#2281](https://github.com/apache/camel-k/pull/2281) ([astefanutti](https://github.com/astefanutti))
- Normalize the Spectrum log messages [\#2279](https://github.com/apache/camel-k/pull/2279) ([orpiske](https://github.com/orpiske))
- Doc: generated API [\#2274](https://github.com/apache/camel-k/pull/2274) ([squakez](https://github.com/squakez))
- Use different job id names to avoid confusion when using GH CLI [\#2272](https://github.com/apache/camel-k/pull/2272) ([orpiske](https://github.com/orpiske))
- Normalizes Maven build logs [\#2270](https://github.com/apache/camel-k/pull/2270) ([orpiske](https://github.com/orpiske))
- feat\(build\): Cancellable Build and global timeout [\#2269](https://github.com/apache/camel-k/pull/2269) ([astefanutti](https://github.com/astefanutti))
- Added support for configuring the log format [\#2267](https://github.com/apache/camel-k/pull/2267) ([orpiske](https://github.com/orpiske))
- Consolidate make targets used in Github actions [\#2264](https://github.com/apache/camel-k/pull/2264) ([orpiske](https://github.com/orpiske))
- Added support for displaying Maven logs in JSON [\#2262](https://github.com/apache/camel-k/pull/2262) ([orpiske](https://github.com/orpiske))
- Remove a reference to the old logging configuration page [\#2261](https://github.com/apache/camel-k/pull/2261) ([orpiske](https://github.com/orpiske))
- Replaced the logging configuration documentation with the logging trait documentation [\#2259](https://github.com/apache/camel-k/pull/2259) ([orpiske](https://github.com/orpiske))
- Support adjusting the log level for integrations [\#2258](https://github.com/apache/camel-k/pull/2258) ([orpiske](https://github.com/orpiske))
- fix\(olm\): Update CSV base template [\#2257](https://github.com/apache/camel-k/pull/2257) ([astefanutti](https://github.com/astefanutti))
- fix\(cmd\): run file system stat errors [\#2255](https://github.com/apache/camel-k/pull/2255) ([squakez](https://github.com/squakez))
- Fix typo [\#2254](https://github.com/apache/camel-k/pull/2254) ([apupier](https://github.com/apupier))
- fix\(api\): Fix error handler types deepcopy generation [\#2253](https://github.com/apache/camel-k/pull/2253) ([astefanutti](https://github.com/astefanutti))
- Added support for the json log format via the logging trait [\#2252](https://github.com/apache/camel-k/pull/2252) ([orpiske](https://github.com/orpiske))
- fix\(ci\): Upgrade Kubernetes to version 1.21.1 [\#2251](https://github.com/apache/camel-k/pull/2251) ([astefanutti](https://github.com/astefanutti))
- refactor\(example\): error handler using a real Kafka topic [\#2248](https://github.com/apache/camel-k/pull/2248) ([squakez](https://github.com/squakez))
- fix\(source\): yaml route steps [\#2247](https://github.com/apache/camel-k/pull/2247) ([squakez](https://github.com/squakez))
- Improve readability of error messages in Camel K [\#2245](https://github.com/apache/camel-k/pull/2245) ([orpiske](https://github.com/orpiske))
- doc\(install\): operationalize options [\#2244](https://github.com/apache/camel-k/pull/2244) ([squakez](https://github.com/squakez))
- fix\(ci\): Use Docker to build OLM index image [\#2242](https://github.com/apache/camel-k/pull/2242) ([astefanutti](https://github.com/astefanutti))
- fix\(build\): Default to routine build strategy for local IntegrationPlatform [\#2240](https://github.com/apache/camel-k/pull/2240) ([astefanutti](https://github.com/astefanutti))
- chore: ugprade Service Binding Operator v0.7.1 [\#2235](https://github.com/apache/camel-k/pull/2235) ([johnpoth](https://github.com/johnpoth))
- chore: change references to use "main" [\#2234](https://github.com/apache/camel-k/pull/2234) ([nicolaferraro](https://github.com/nicolaferraro))
- Bump version to 1.5.0-SNAPSHOT [\#2233](https://github.com/apache/camel-k/pull/2233) ([nicolaferraro](https://github.com/nicolaferraro))
- issue2230- fix for run-from-github page [\#2231](https://github.com/apache/camel-k/pull/2231) ([bfitzpat](https://github.com/bfitzpat))
- fix\(cli\): Use apiextensions.k8s.io/v1 to uninstall CRDs [\#2226](https://github.com/apache/camel-k/pull/2226) ([astefanutti](https://github.com/astefanutti))
- chore\(release\): switch back to 1.7.0-SNAPSHOT runtime [\#2225](https://github.com/apache/camel-k/pull/2225) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(trait\): kamelet spec in running phase [\#2224](https://github.com/apache/camel-k/pull/2224) ([squakez](https://github.com/squakez))
- chore\(release\): disable dynamic linking in released artifacts [\#2222](https://github.com/apache/camel-k/pull/2222) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(e2e\): Rely on staging repository in Maven CA e2e tests [\#2219](https://github.com/apache/camel-k/pull/2219) ([astefanutti](https://github.com/astefanutti))
- feat\(kamelets\): kamelet binding error handler [\#2217](https://github.com/apache/camel-k/pull/2217) ([squakez](https://github.com/squakez))
- feat\(monitoring\): Migrate to PodMonitor for Integration monitoring [\#2216](https://github.com/apache/camel-k/pull/2216) ([astefanutti](https://github.com/astefanutti))
- Missing camel-k-kamelet-reify version while building kamelet binding [\#2215](https://github.com/apache/camel-k/pull/2215) ([claudio4j](https://github.com/claudio4j))
- fix\(dsl\): The fromF DSL should be parsed during HTTP endpoint discovery [\#2211](https://github.com/apache/camel-k/pull/2211) ([astefanutti](https://github.com/astefanutti))
- Fix \#2170: uniform camel: and camel-quarkus: dependencies [\#2208](https://github.com/apache/camel-k/pull/2208) ([nicolaferraro](https://github.com/nicolaferraro))
- feat\(cmd\): install resource requirements flag [\#2207](https://github.com/apache/camel-k/pull/2207) ([squakez](https://github.com/squakez))
- chore: Tidy proposals directory [\#2204](https://github.com/apache/camel-k/pull/2204) ([astefanutti](https://github.com/astefanutti))
- chore\(cli\): Fix error handling in local commands [\#2202](https://github.com/apache/camel-k/pull/2202) ([astefanutti](https://github.com/astefanutti))
- Add OLM upgrade test [\#2198](https://github.com/apache/camel-k/pull/2198) ([bouskaJ](https://github.com/bouskaJ))
- Update to Camel 3.9.0 and Camel-Quarkus 1.8.1 [\#2197](https://github.com/apache/camel-k/pull/2197) ([nicolaferraro](https://github.com/nicolaferraro))
- fix: Prevent Integration environment variables ordering randomization [\#2196](https://github.com/apache/camel-k/pull/2196) ([astefanutti](https://github.com/astefanutti))
- chore\(ci\): upgrade YAKS version [\#2194](https://github.com/apache/camel-k/pull/2194) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(cli\): Improve run command --dependency option description [\#2193](https://github.com/apache/camel-k/pull/2193) ([astefanutti](https://github.com/astefanutti))
- fix: Increase operator liveness probe initial delay and period [\#2192](https://github.com/apache/camel-k/pull/2192) ([astefanutti](https://github.com/astefanutti))
- fix: Add bindings.knative.dev/include label to SinkBinding sources [\#2190](https://github.com/apache/camel-k/pull/2190) ([astefanutti](https://github.com/astefanutti))
- chore: upgrade Service Binding Operator to v0.6.0 [\#2187](https://github.com/apache/camel-k/pull/2187) ([johnpoth](https://github.com/johnpoth))
- doc: Maven configuration documentation [\#2186](https://github.com/apache/camel-k/pull/2186) ([astefanutti](https://github.com/astefanutti))
- Fix \#2083: add kamel bind command [\#2183](https://github.com/apache/camel-k/pull/2183) ([nicolaferraro](https://github.com/nicolaferraro))
- feat\(operator\): NodeSelector install options [\#2182](https://github.com/apache/camel-k/pull/2182) ([squakez](https://github.com/squakez))
- feat\(build\): Custom Maven CA certificate\(s\) support [\#2180](https://github.com/apache/camel-k/pull/2180) ([astefanutti](https://github.com/astefanutti))
- Fix link in example knative readme [\#2174](https://github.com/apache/camel-k/pull/2174) ([apupier](https://github.com/apupier))
- Adding a dump command [\#2171](https://github.com/apache/camel-k/pull/2171) ([oscerd](https://github.com/oscerd))
- Normalize names [\#2169](https://github.com/apache/camel-k/pull/2169) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(OLM\): Remove old Build CRD from OLM package [\#2166](https://github.com/apache/camel-k/pull/2166) ([astefanutti](https://github.com/astefanutti))
- fix: Integrations are re-built on operator upgrade [\#2163](https://github.com/apache/camel-k/pull/2163) ([astefanutti](https://github.com/astefanutti))
- test: Operator upgrade e2e tests [\#2159](https://github.com/apache/camel-k/pull/2159) ([astefanutti](https://github.com/astefanutti))
- doc\(test\): basic e2e local instructions [\#2155](https://github.com/apache/camel-k/pull/2155) ([squakez](https://github.com/squakez))
- fix\(ci\): Free more disk space and pin OS version [\#2154](https://github.com/apache/camel-k/pull/2154) ([astefanutti](https://github.com/astefanutti))
- chore\(s2i\): Set owner reference for BuildConfig and ImageStream resources [\#2152](https://github.com/apache/camel-k/pull/2152) ([astefanutti](https://github.com/astefanutti))
- Fix \#2035: invalid YAML should not make the operator panic [\#2148](https://github.com/apache/camel-k/pull/2148) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix oc parameter and added filenames to the yaml sections [\#2147](https://github.com/apache/camel-k/pull/2147) ([claudio4j](https://github.com/claudio4j))
- fix service-binding role group [\#2145](https://github.com/apache/camel-k/pull/2145) ([nicolaferraro](https://github.com/nicolaferraro))
- doc: added documentation about deploying Camel K on k3s [\#2143](https://github.com/apache/camel-k/pull/2143) ([orpiske](https://github.com/orpiske))
- Add toleration trait e2e test [\#2142](https://github.com/apache/camel-k/pull/2142) ([tplevko](https://github.com/tplevko))
- fix: disable CGO when building on Fedora to avoid linking issues on the Ubuntu-based image \(\#2140\) [\#2141](https://github.com/apache/camel-k/pull/2141) ([orpiske](https://github.com/orpiske))
- fix: buildah to ensure it works with insecure registries [\#2138](https://github.com/apache/camel-k/pull/2138) ([orpiske](https://github.com/orpiske))
- feat: container image builder tasks [\#2131](https://github.com/apache/camel-k/pull/2131) ([astefanutti](https://github.com/astefanutti))
- fix: ensure Kaniko build strategy works with insecure registries [\#2130](https://github.com/apache/camel-k/pull/2130) ([orpiske](https://github.com/orpiske))
- test: Add e2e/common/cli to common e2e test suite [\#2128](https://github.com/apache/camel-k/pull/2128) ([astefanutti](https://github.com/astefanutti))
- Create new test folder with kamel cli specific tests [\#2125](https://github.com/apache/camel-k/pull/2125) ([mmajerni](https://github.com/mmajerni))
- fix: only assume secure pull if the main registry and the base image registry are different [\#2124](https://github.com/apache/camel-k/pull/2124) ([orpiske](https://github.com/orpiske))
- test: Add toleration trait e2e tests [\#2123](https://github.com/apache/camel-k/pull/2123) ([astefanutti](https://github.com/astefanutti))
- chore\(doc\): fix links to unlock website [\#2121](https://github.com/apache/camel-k/pull/2121) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(test\): test correct filtering of messages from Knative broker [\#2120](https://github.com/apache/camel-k/pull/2120) ([nicolaferraro](https://github.com/nicolaferraro))
- Kamel local inspect: In case of missing format, show the output in th… [\#2118](https://github.com/apache/camel-k/pull/2118) ([oscerd](https://github.com/oscerd))
- Fix knative subscriptions and triggers [\#2115](https://github.com/apache/camel-k/pull/2115) ([nicolaferraro](https://github.com/nicolaferraro))
- feat\(operator\): toleration install flag [\#2114](https://github.com/apache/camel-k/pull/2114) ([squakez](https://github.com/squakez))
- fix\(cli\): install error message [\#2112](https://github.com/apache/camel-k/pull/2112) ([squakez](https://github.com/squakez))
- chore: fix default template for Kamelets [\#2111](https://github.com/apache/camel-k/pull/2111) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(documentation\): add Kamelet development guide [\#2110](https://github.com/apache/camel-k/pull/2110) ([nicolaferraro](https://github.com/nicolaferraro))
- fix: Do not report falsy readiness condition on Integration downscaling [\#2108](https://github.com/apache/camel-k/pull/2108) ([astefanutti](https://github.com/astefanutti))
- fix\(ci\): Fix OpenShift DNS node configuration [\#2104](https://github.com/apache/camel-k/pull/2104) ([astefanutti](https://github.com/astefanutti))
- chore : Fix links to the developers guide - needs to point to latest/contributing/developers.html [\#2102](https://github.com/apache/camel-k/pull/2102) ([cunningt](https://github.com/cunningt))
- chore: Upgrade Knative to version 0.21.0 [\#2101](https://github.com/apache/camel-k/pull/2101) ([astefanutti](https://github.com/astefanutti))
- chore: Rely on Lease from controller-runtime for leader election [\#2100](https://github.com/apache/camel-k/pull/2100) ([astefanutti](https://github.com/astefanutti))
- tests: common/files are rewritten to yaml [\#2099](https://github.com/apache/camel-k/pull/2099) ([vsokolovskii](https://github.com/vsokolovskii))
- Add missing classpath locations for external kits [\#2097](https://github.com/apache/camel-k/pull/2097) ([jamesnetherton](https://github.com/jamesnetherton))
- fix: Use correct versions to access OLM APIs [\#2095](https://github.com/apache/camel-k/pull/2095) ([astefanutti](https://github.com/astefanutti))
- Upgrade sbo [\#2094](https://github.com/apache/camel-k/pull/2094) ([johnpoth](https://github.com/johnpoth))
- Disable OLM in uninstall tests [\#2092](https://github.com/apache/camel-k/pull/2092) ([bouskaJ](https://github.com/bouskaJ))
- Fix alternative image test [\#2091](https://github.com/apache/camel-k/pull/2091) ([bouskaJ](https://github.com/bouskaJ))
- Fix \#200: Add support for mirrorOf attribute [\#2089](https://github.com/apache/camel-k/pull/2089) ([bouskaJ](https://github.com/bouskaJ))
- chore: Upgrade controller-runtime to version 0.7.2 [\#2087](https://github.com/apache/camel-k/pull/2087) ([astefanutti](https://github.com/astefanutti))
- chore\(kamelets\): embed kamelet repository and remove lookup from gith… [\#2086](https://github.com/apache/camel-k/pull/2086) ([nicolaferraro](https://github.com/nicolaferraro))
- chore: Upgrade to `networking.k8s.io/v1` Ingress API [\#2084](https://github.com/apache/camel-k/pull/2084) ([astefanutti](https://github.com/astefanutti))
- refactor\(trait\): affinity  [\#2078](https://github.com/apache/camel-k/pull/2078) ([squakez](https://github.com/squakez))
- Upgrade Kubernetes to v0.19.8 and Service Binding operator to v0.4.1 [\#2076](https://github.com/apache/camel-k/pull/2076) ([astefanutti](https://github.com/astefanutti))
- Fix deprecated annotation [\#2070](https://github.com/apache/camel-k/pull/2070) ([bouskaJ](https://github.com/bouskaJ))
- Operator labels are different when OLM is used [\#2069](https://github.com/apache/camel-k/pull/2069) ([bouskaJ](https://github.com/bouskaJ))
- test: Add operator metrics e2e tests [\#2066](https://github.com/apache/camel-k/pull/2066) ([astefanutti](https://github.com/astefanutti))
- Cleanup files dir [\#2065](https://github.com/apache/camel-k/pull/2065) ([bouskaJ](https://github.com/bouskaJ))
- chore\(e2e\): Assert Integration readiness condition in scaling e2e tests [\#2064](https://github.com/apache/camel-k/pull/2064) ([astefanutti](https://github.com/astefanutti))
- chore\(e2e\): Polish Gomega usage in e2e tests [\#2063](https://github.com/apache/camel-k/pull/2063) ([astefanutti](https://github.com/astefanutti))
- test: Add eviction cases to the PodDisruptionBudget trait e2e tests [\#2062](https://github.com/apache/camel-k/pull/2062) ([astefanutti](https://github.com/astefanutti))
- chore\(e2e\): Add test case to Integration scaling e2e tests [\#2061](https://github.com/apache/camel-k/pull/2061) ([astefanutti](https://github.com/astefanutti))
- fix\(api\): Remove deprecated deepcopy-gen markers [\#2060](https://github.com/apache/camel-k/pull/2060) ([astefanutti](https://github.com/astefanutti))
- Move trait test to separate directory [\#2059](https://github.com/apache/camel-k/pull/2059) ([bouskaJ](https://github.com/bouskaJ))
- Implement a lightning-fast global strategy [\#2058](https://github.com/apache/camel-k/pull/2058) ([nicolaferraro](https://github.com/nicolaferraro))
- test: Add PodDisruptionBudget trait e2e tests [\#2057](https://github.com/apache/camel-k/pull/2057) ([astefanutti](https://github.com/astefanutti))
- chore\(cmd\): skip operator compatibility warning [\#2056](https://github.com/apache/camel-k/pull/2056) ([squakez](https://github.com/squakez))
- feat: add command completion for connect flag [\#2055](https://github.com/apache/camel-k/pull/2055) ([johnpoth](https://github.com/johnpoth))
- Wait for operator to start before scaling it to zero [\#2054](https://github.com/apache/camel-k/pull/2054) ([bouskaJ](https://github.com/bouskaJ))
- chore\(test\): Add integration scaling e2e tests [\#2053](https://github.com/apache/camel-k/pull/2053) ([astefanutti](https://github.com/astefanutti))
- chore\(api\): Add Scale methods to the Integration generated client API [\#2052](https://github.com/apache/camel-k/pull/2052) ([astefanutti](https://github.com/astefanutti))
- For the moment lets remove absolute path [\#2049](https://github.com/apache/camel-k/pull/2049) ([oscerd](https://github.com/oscerd))
- Add local build command replacing local create [\#2048](https://github.com/apache/camel-k/pull/2048) ([doru1004](https://github.com/doru1004))
- Fix \#2043: add processing steps to KameletBinding [\#2044](https://github.com/apache/camel-k/pull/2044) ([nicolaferraro](https://github.com/nicolaferraro))
- fix: Consider ObjectMeta field for deep derivative comparison before patching [\#2042](https://github.com/apache/camel-k/pull/2042) ([astefanutti](https://github.com/astefanutti))
- fix\(pdb\): Add TypeMeta field to PodDisruptionBudget resource [\#2041](https://github.com/apache/camel-k/pull/2041) ([astefanutti](https://github.com/astefanutti))
- feat\(trait\): toleration trait [\#2040](https://github.com/apache/camel-k/pull/2040) ([squakez](https://github.com/squakez))
- feat: Use server-side apply to create and patch owned resources [\#2039](https://github.com/apache/camel-k/pull/2039) ([astefanutti](https://github.com/astefanutti))
- chore\(ci\): Pin the Kubernetes version deployed by Kind [\#2037](https://github.com/apache/camel-k/pull/2037) ([astefanutti](https://github.com/astefanutti))
- fix\(ci\): Use kubectl wait command to check Knative readiness [\#2036](https://github.com/apache/camel-k/pull/2036) ([astefanutti](https://github.com/astefanutti))
- chore\(olm\): Update IntegrationPlatform creation step in CSV description [\#2034](https://github.com/apache/camel-k/pull/2034) ([astefanutti](https://github.com/astefanutti))
- chore\(cli\): Exclude manifests directory from embedded resources [\#2033](https://github.com/apache/camel-k/pull/2033) ([astefanutti](https://github.com/astefanutti))
- fix\(olm\): Fix Integration example from CSV description [\#2032](https://github.com/apache/camel-k/pull/2032) ([astefanutti](https://github.com/astefanutti))
- Point to documentation for debugging using VS Code [\#2030](https://github.com/apache/camel-k/pull/2030) ([apupier](https://github.com/apupier))
- Increase timeouts [\#2028](https://github.com/apache/camel-k/pull/2028) ([bouskaJ](https://github.com/bouskaJ))
- chore\(RBAC\): Symmetrical RBAC setup between OLM and CLI [\#2027](https://github.com/apache/camel-k/pull/2027) ([astefanutti](https://github.com/astefanutti))
- \[fix\] Add bigger flexibility to alerts tests [\#2026](https://github.com/apache/camel-k/pull/2026) ([llowinge](https://github.com/llowinge))
- fix: Add embedded kamelets directory check back [\#2021](https://github.com/apache/camel-k/pull/2021) ([astefanutti](https://github.com/astefanutti))
- fix: Resource name must be used instead of kind for SelfSubjectAccessReview request [\#2020](https://github.com/apache/camel-k/pull/2020) ([astefanutti](https://github.com/astefanutti))
- fix: ServiceBinding SAR check does not guaranty CRD is installed [\#2019](https://github.com/apache/camel-k/pull/2019) ([astefanutti](https://github.com/astefanutti))
- chore\(config\): Remove RBAC duplications [\#2017](https://github.com/apache/camel-k/pull/2017) ([astefanutti](https://github.com/astefanutti))
- fix\(pdb\): Add missing watch verb to PodDisruptionBudget resources RBAC [\#2016](https://github.com/apache/camel-k/pull/2016) ([astefanutti](https://github.com/astefanutti))
- fix\(helm\): Add missing permissions for PodDisruptionBudget resources [\#2015](https://github.com/apache/camel-k/pull/2015) ([astefanutti](https://github.com/astefanutti))
- chore\(helm\): Remove duplicated rule for servicebindings [\#2014](https://github.com/apache/camel-k/pull/2014) ([astefanutti](https://github.com/astefanutti))
- doc: camel k runtime local instructions [\#2013](https://github.com/apache/camel-k/pull/2013) ([squakez](https://github.com/squakez))
- chore\(olm\): Regenerate current OLM package manifest [\#2012](https://github.com/apache/camel-k/pull/2012) ([astefanutti](https://github.com/astefanutti))
- fix\(olm\): Add back lost rules to OLM role [\#2011](https://github.com/apache/camel-k/pull/2011) ([astefanutti](https://github.com/astefanutti))
- chore\(doc\): Add ServiceBinding trait documentation [\#2010](https://github.com/apache/camel-k/pull/2010) ([astefanutti](https://github.com/astefanutti))
- chore\(install\): Tidy RBAC resources into Kustomize directory [\#2008](https://github.com/apache/camel-k/pull/2008) ([astefanutti](https://github.com/astefanutti))
- fix\(api\): Fix JSON schemas generation based on CRD apiextensions.k8s.io/v1 [\#2006](https://github.com/apache/camel-k/pull/2006) ([astefanutti](https://github.com/astefanutti))
- chore\(CRD\): Remove old CRDs from the deploy directory [\#2005](https://github.com/apache/camel-k/pull/2005) ([astefanutti](https://github.com/astefanutti))
- Add scaffold for Kamelet via kamel init [\#2004](https://github.com/apache/camel-k/pull/2004) ([rudeigerc](https://github.com/rudeigerc))
- feat\(conf\): Mount source and resource ConfigMaps as subPaths instead of volumes [\#2002](https://github.com/apache/camel-k/pull/2002) ([astefanutti](https://github.com/astefanutti))
- Document OLM based deployment from source [\#2001](https://github.com/apache/camel-k/pull/2001) ([amitsadaphule](https://github.com/amitsadaphule))
- chore\(doc\): Use Asciidoc style code blocks instead of Markdown style Verified [\#1999](https://github.com/apache/camel-k/pull/1999) ([astefanutti](https://github.com/astefanutti))
- Revert "Switch to a different backport implementation" [\#1997](https://github.com/apache/camel-k/pull/1997) ([oscerd](https://github.com/oscerd))
- Picky commit for testing backport action [\#1996](https://github.com/apache/camel-k/pull/1996) ([oscerd](https://github.com/oscerd))
- Switch to a different backport implementation [\#1995](https://github.com/apache/camel-k/pull/1995) ([oscerd](https://github.com/oscerd))
- Fix \#1992: allow accessing Strimzi "kafkatopics" instead of "topics" [\#1993](https://github.com/apache/camel-k/pull/1993) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(OLM\): Remove replaces field from Kustomize base CSV manifest [\#1991](https://github.com/apache/camel-k/pull/1991) ([astefanutti](https://github.com/astefanutti))
- Fix a little typo good for testing backport action [\#1989](https://github.com/apache/camel-k/pull/1989) ([oscerd](https://github.com/oscerd))
- Fix \#1986: use properties instead of URL encoding for Kamelets in bin… [\#1987](https://github.com/apache/camel-k/pull/1987) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(OLM\): Add missing internal-objects annotation to Kustomize base CSV manifest [\#1985](https://github.com/apache/camel-k/pull/1985) ([astefanutti](https://github.com/astefanutti))
- Re-introduce changelog action [\#1982](https://github.com/apache/camel-k/pull/1982) ([oscerd](https://github.com/oscerd))
- Refactors the deploy directory to make config directory single source of CRD truth [\#1978](https://github.com/apache/camel-k/pull/1978) ([phantomjinx](https://github.com/phantomjinx))
- fix\(OLM\): OLM bundle generation fixes [\#1977](https://github.com/apache/camel-k/pull/1977) ([astefanutti](https://github.com/astefanutti))
- Backport action: Added license [\#1975](https://github.com/apache/camel-k/pull/1975) ([oscerd](https://github.com/oscerd))
- Remove node configuration from backport action. It is not needed [\#1974](https://github.com/apache/camel-k/pull/1974) ([oscerd](https://github.com/oscerd))
- Revert "Test PR do not merge" [\#1973](https://github.com/apache/camel-k/pull/1973) ([oscerd](https://github.com/oscerd))
- Test PR do not merge [\#1971](https://github.com/apache/camel-k/pull/1971) ([oscerd](https://github.com/oscerd))
- Added Backport Github action [\#1970](https://github.com/apache/camel-k/pull/1970) ([oscerd](https://github.com/oscerd))
- refactor\(examples\): organize in folders [\#1968](https://github.com/apache/camel-k/pull/1968) ([squakez](https://github.com/squakez))
- chore\(doc\): Monospaced property and type trait configuration options columns [\#1967](https://github.com/apache/camel-k/pull/1967) ([astefanutti](https://github.com/astefanutti))
- feat\(trait\): leverage ConfigMap binary data for resources [\#1965](https://github.com/apache/camel-k/pull/1965) ([squakez](https://github.com/squakez))
- Correct the documented syntax for Dependency trait usage [\#1964](https://github.com/apache/camel-k/pull/1964) ([bvahdat](https://github.com/bvahdat))
- chore\(build\): Sort builder steps by phase in Build spec [\#1962](https://github.com/apache/camel-k/pull/1962) ([astefanutti](https://github.com/astefanutti))
- Fix \#1939: workaround for catalogs with duplicate entries [\#1960](https://github.com/apache/camel-k/pull/1960) ([nicolaferraro](https://github.com/nicolaferraro))
- \[ENTESB-15644\] Fix monitoring test [\#1958](https://github.com/apache/camel-k/pull/1958) ([llowinge](https://github.com/llowinge))
- proposal: provided kamelets [\#1957](https://github.com/apache/camel-k/pull/1957) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(prometheus\): Remove runtime references from the Prometheus trait [\#1956](https://github.com/apache/camel-k/pull/1956) ([astefanutti](https://github.com/astefanutti))
- Remove references to Quarkus runtime from monitoring and modeline documentation [\#1954](https://github.com/apache/camel-k/pull/1954) ([astefanutti](https://github.com/astefanutti))
- fix\(trait\): using proper contentKey for sources [\#1953](https://github.com/apache/camel-k/pull/1953) ([squakez](https://github.com/squakez))
- feat: Add ServiceBinding trait \(\#1445\) [\#1952](https://github.com/apache/camel-k/pull/1952) ([johnpoth](https://github.com/johnpoth))
- chore\(crd\): Use conversion-gen API for structured conversion of CRDs to v1beta1 [\#1950](https://github.com/apache/camel-k/pull/1950) ([astefanutti](https://github.com/astefanutti))
- doc: local development environment [\#1949](https://github.com/apache/camel-k/pull/1949) ([squakez](https://github.com/squakez))
- fix\(cli\): Improve CLI / operator versions compatibility check [\#1944](https://github.com/apache/camel-k/pull/1944) ([astefanutti](https://github.com/astefanutti))
- fix\(doc\): Activating the Prometheus trait at platform level must use a boolean [\#1942](https://github.com/apache/camel-k/pull/1942) ([astefanutti](https://github.com/astefanutti))
- Fix \#1936: avoid patching if the target resource contains all expecte… [\#1937](https://github.com/apache/camel-k/pull/1937) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(api\): Add missing x-descriptors field to Kamelet property type [\#1934](https://github.com/apache/camel-k/pull/1934) ([astefanutti](https://github.com/astefanutti))
- Fix helm chart so it is compatible with Go 1.14 [\#1933](https://github.com/apache/camel-k/pull/1933) ([jon-ruckwood](https://github.com/jon-ruckwood))
- Use Quarkus fast-jar package format apache/camel-k-runtime\#360 [\#1931](https://github.com/apache/camel-k/pull/1931) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#1928: use "id" property in kamelet binding for adding specific c… [\#1929](https://github.com/apache/camel-k/pull/1929) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(examples\): kamelets properties fix [\#1927](https://github.com/apache/camel-k/pull/1927) ([squakez](https://github.com/squakez))
- Fix saga example [\#1926](https://github.com/apache/camel-k/pull/1926) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix image location extraction [\#1925](https://github.com/apache/camel-k/pull/1925) ([doru1004](https://github.com/doru1004))
- Fix modeline for inspect. [\#1924](https://github.com/apache/camel-k/pull/1924) ([doru1004](https://github.com/doru1004))
- chore\(cli\): global install enhanced description [\#1920](https://github.com/apache/camel-k/pull/1920) ([squakez](https://github.com/squakez))
- Fix contributing documentation for integration test naming convention [\#1918](https://github.com/apache/camel-k/pull/1918) ([apupier](https://github.com/apupier))
- fix\(cli\): remove install camel-version flag [\#1917](https://github.com/apache/camel-k/pull/1917) ([squakez](https://github.com/squakez))
- Environment variables evaluated only at integration runtime [\#1916](https://github.com/apache/camel-k/pull/1916) ([doru1004](https://github.com/doru1004))
- Upgrade CRDs to apiextensions.k8s.io/v1 [\#1914](https://github.com/apache/camel-k/pull/1914) ([astefanutti](https://github.com/astefanutti))
- fix\(cli\): check run sources exists [\#1913](https://github.com/apache/camel-k/pull/1913) ([squakez](https://github.com/squakez))
- Feat\(cli\): version operator and warning compatibility message [\#1912](https://github.com/apache/camel-k/pull/1912) ([squakez](https://github.com/squakez))
- chore: Remove duplicated version target in Makefile [\#1909](https://github.com/apache/camel-k/pull/1909) ([astefanutti](https://github.com/astefanutti))
- chore: Bump resources to version 1.4.0-SNAPSHOT [\#1908](https://github.com/apache/camel-k/pull/1908) ([astefanutti](https://github.com/astefanutti))
- fix\(cli\): help command offline [\#1907](https://github.com/apache/camel-k/pull/1907) ([squakez](https://github.com/squakez))
- fix: Unique syntax for Maven artifact GAV string representation [\#1903](https://github.com/apache/camel-k/pull/1903) ([astefanutti](https://github.com/astefanutti))
- fix\(ci\): Use AdoptOpenJDK/install-jdk@v1 action [\#1901](https://github.com/apache/camel-k/pull/1901) ([astefanutti](https://github.com/astefanutti))
- fix: Do not filter Camel catalogs by runtime provider label [\#1900](https://github.com/apache/camel-k/pull/1900) ([astefanutti](https://github.com/astefanutti))
- refactor\(test\): included all run command flag test [\#1895](https://github.com/apache/camel-k/pull/1895) ([squakez](https://github.com/squakez))
- Fix \#1707: add a way to override the base image in the operator [\#1894](https://github.com/apache/camel-k/pull/1894) ([nicolaferraro](https://github.com/nicolaferraro))
- feat\(test\): operator command unit test [\#1893](https://github.com/apache/camel-k/pull/1893) ([squakez](https://github.com/squakez))
- feat\(test\): builder command unit test [\#1891](https://github.com/apache/camel-k/pull/1891) ([squakez](https://github.com/squakez))
- feat\(test\): kit create command unit test [\#1889](https://github.com/apache/camel-k/pull/1889) ([squakez](https://github.com/squakez))
- feat\(test\): delete command unit test [\#1888](https://github.com/apache/camel-k/pull/1888) ([squakez](https://github.com/squakez))
- chore\(e2e\): add test for Istio trait \#1547 [\#1885](https://github.com/apache/camel-k/pull/1885) ([tadayosi](https://github.com/tadayosi))
- feat\(test\): install command flags unit test [\#1883](https://github.com/apache/camel-k/pull/1883) ([squakez](https://github.com/squakez))
- Fix operator monitoring test [\#1880](https://github.com/apache/camel-k/pull/1880) ([llowinge](https://github.com/llowinge))
- Add network name flag to local run. [\#1879](https://github.com/apache/camel-k/pull/1879) ([doru1004](https://github.com/doru1004))
- Skip CRD installation if output flag enabled [\#1876](https://github.com/apache/camel-k/pull/1876) ([squakez](https://github.com/squakez))
- \[Fix\] Check conditions in the correct order [\#1873](https://github.com/apache/camel-k/pull/1873) ([doru1004](https://github.com/doru1004))
- Fix typo DigitalOcen --\> DigitalOcean [\#1868](https://github.com/apache/camel-k/pull/1868) ([apupier](https://github.com/apupier))
- chore\(e2e\): add test for Affinity trait \#1547 [\#1866](https://github.com/apache/camel-k/pull/1866) ([tadayosi](https://github.com/tadayosi))
- chore\(e2e\): add test for Pull Secret trait \#1547 [\#1865](https://github.com/apache/camel-k/pull/1865) ([tadayosi](https://github.com/tadayosi))
- proposal: add Service Binding proposal \(\#1445\) [\#1864](https://github.com/apache/camel-k/pull/1864) ([johnpoth](https://github.com/johnpoth))
- chore\(doc\): quote inline code blocks in environment trait comment [\#1863](https://github.com/apache/camel-k/pull/1863) ([tadayosi](https://github.com/tadayosi))
- feat\(uninstall\): add --skip-registry-secret option and make uninstall remove registry secret \#1859 [\#1862](https://github.com/apache/camel-k/pull/1862) ([tadayosi](https://github.com/tadayosi))
- PodSpecable Integration [\#1861](https://github.com/apache/camel-k/pull/1861) ([mmelko](https://github.com/mmelko))
- chore\(doc\): generate doc for environment trait [\#1858](https://github.com/apache/camel-k/pull/1858) ([tadayosi](https://github.com/tadayosi))
- Prioritize user properties over modeline properties. [\#1857](https://github.com/apache/camel-k/pull/1857) ([doru1004](https://github.com/doru1004))
- chore\(test\): test that propertyless kamelets can be bound [\#1856](https://github.com/apache/camel-k/pull/1856) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(api\): make KameletSpec.Definition a pointer so it can be omitted [\#1855](https://github.com/apache/camel-k/pull/1855) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(crd\): Regenerate KameletBinding CRD [\#1854](https://github.com/apache/camel-k/pull/1854) ([astefanutti](https://github.com/astefanutti))
- chore\(api\): make Endpoint.Properties a pointer so it can be omitted [\#1853](https://github.com/apache/camel-k/pull/1853) ([lburgazzoli](https://github.com/lburgazzoli))
- api: add in/out/error type schema to v1alpha1.Endpoint [\#1852](https://github.com/apache/camel-k/pull/1852) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(api\): make KameletSpec.Authorization a pointer so it can be omitted [\#1851](https://github.com/apache/camel-k/pull/1851) ([lburgazzoli](https://github.com/lburgazzoli))
- fix\(trait\): bool trait props should be pointer, otherwise omitted in CR \#1848 [\#1850](https://github.com/apache/camel-k/pull/1850) ([tadayosi](https://github.com/tadayosi))
- chore\(e2e\): add test for Prometheus trait \#1547 [\#1849](https://github.com/apache/camel-k/pull/1849) ([tadayosi](https://github.com/tadayosi))
- Remove Travis CI build [\#1847](https://github.com/apache/camel-k/pull/1847) ([astefanutti](https://github.com/astefanutti))
- fix\(api\): Remove controller-tools dependency from API module [\#1846](https://github.com/apache/camel-k/pull/1846) ([astefanutti](https://github.com/astefanutti))
- chore\(e2e\): add test for Jolokia trait \#1547 [\#1845](https://github.com/apache/camel-k/pull/1845) ([tadayosi](https://github.com/tadayosi))
- fix: Fix kamelet.feature for YAKS version 0.1.0 [\#1844](https://github.com/apache/camel-k/pull/1844) ([astefanutti](https://github.com/astefanutti))
- Upgrade controller-tools to version 0.4.1 [\#1841](https://github.com/apache/camel-k/pull/1841) ([astefanutti](https://github.com/astefanutti))
- chore\(doc\): Add standard operation procedures to troubleshooting guide [\#1839](https://github.com/apache/camel-k/pull/1839) ([astefanutti](https://github.com/astefanutti))
- Fix \#1675: use kamelets in the operator namespace [\#1836](https://github.com/apache/camel-k/pull/1836) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(test\): upgrade YAKS to 0.1.0 [\#1835](https://github.com/apache/camel-k/pull/1835) ([nicolaferraro](https://github.com/nicolaferraro))
- doc\(cli\): add section for global flags \#1185 [\#1833](https://github.com/apache/camel-k/pull/1833) ([tadayosi](https://github.com/tadayosi))
- Fix \#1654: enable sinkbinding automatically [\#1832](https://github.com/apache/camel-k/pull/1832) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1818: add support for Kamelet repository [\#1830](https://github.com/apache/camel-k/pull/1830) ([nicolaferraro](https://github.com/nicolaferraro))
- Provide tests for ENTESB-14497 [\#1829](https://github.com/apache/camel-k/pull/1829) ([llowinge](https://github.com/llowinge))
- Add command line support for creating, building and running containerized integrations locally [\#1827](https://github.com/apache/camel-k/pull/1827) ([doru1004](https://github.com/doru1004))
- Sort the integration configurations before returning [\#1825](https://github.com/apache/camel-k/pull/1825) ([kaczyns](https://github.com/kaczyns))
- Split tests by language [\#1822](https://github.com/apache/camel-k/pull/1822) ([bouskaJ](https://github.com/bouskaJ))
- chore\(doc\): Shorten monitoring/scaling navigation menu items [\#1819](https://github.com/apache/camel-k/pull/1819) ([astefanutti](https://github.com/astefanutti))
- Support CLI properties for kamel local run. [\#1817](https://github.com/apache/camel-k/pull/1817) ([doru1004](https://github.com/doru1004))
- chore\(doc\): Add Camel K operator monitoring documentation [\#1812](https://github.com/apache/camel-k/pull/1812) ([astefanutti](https://github.com/astefanutti))
- \#1743: Begin generating the operator bundle using operator-sdk [\#1811](https://github.com/apache/camel-k/pull/1811) ([phantomjinx](https://github.com/phantomjinx))
- Update PDB trait documentation [\#1810](https://github.com/apache/camel-k/pull/1810) ([astefanutti](https://github.com/astefanutti))
- Fix \#1549: auto-detect json in YAML [\#1809](https://github.com/apache/camel-k/pull/1809) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1771: use registry creds for pull and push and set Spectrum as default [\#1807](https://github.com/apache/camel-k/pull/1807) ([nicolaferraro](https://github.com/nicolaferraro))
- Add local run subcommand with basic support [\#1805](https://github.com/apache/camel-k/pull/1805) ([doru1004](https://github.com/doru1004))
- Fix \#1562: remove support for main runtime [\#1804](https://github.com/apache/camel-k/pull/1804) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(ci\): simplify test configuration [\#1801](https://github.com/apache/camel-k/pull/1801) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#751: add guard to global operator [\#1800](https://github.com/apache/camel-k/pull/1800) ([nicolaferraro](https://github.com/nicolaferraro))
- Fixes ENTESB-15219: only use default values when user doesn't provide a kamelet property value in integration [\#1796](https://github.com/apache/camel-k/pull/1796) ([dhirajsb](https://github.com/dhirajsb))
- \[test\] Detect camel quarkus version dynamically in monitoring test [\#1795](https://github.com/apache/camel-k/pull/1795) ([llowinge](https://github.com/llowinge))
- \#1283: Enhance the `kamel log` command to show more detail prior to i… [\#1793](https://github.com/apache/camel-k/pull/1793) ([phantomjinx](https://github.com/phantomjinx))
- Fix \#1791: auto-generate v1alpha1 resources [\#1792](https://github.com/apache/camel-k/pull/1792) ([nicolaferraro](https://github.com/nicolaferraro))
- \[ENTESB-15044\] Refactor monitoring test to be able consume camel quar… [\#1790](https://github.com/apache/camel-k/pull/1790) ([llowinge](https://github.com/llowinge))
- Create PodDisruptionBudget for every integration [\#1787](https://github.com/apache/camel-k/pull/1787) ([mmelko](https://github.com/mmelko))
- Fix \#1785: propagate klb changes to integrations [\#1786](https://github.com/apache/camel-k/pull/1786) ([nicolaferraro](https://github.com/nicolaferraro))
- Make inspect subcommand run locally. [\#1782](https://github.com/apache/camel-k/pull/1782) ([doru1004](https://github.com/doru1004))
- doc\(example\): timer-source example refactory and timer-source-log-sink new example [\#1781](https://github.com/apache/camel-k/pull/1781) ([squakez](https://github.com/squakez))
- Fix \#1778: allow pushing to broker via KameletBinding [\#1780](https://github.com/apache/camel-k/pull/1780) ([nicolaferraro](https://github.com/nicolaferraro))
- Inspect all transitive dependencies of an integration [\#1777](https://github.com/apache/camel-k/pull/1777) ([doru1004](https://github.com/doru1004))
- Fix \#1774: use direct HTTP binding when Knative is not in use [\#1776](https://github.com/apache/camel-k/pull/1776) ([nicolaferraro](https://github.com/nicolaferraro))
- Automatic changelog: Remove deprecated github action commands [\#1775](https://github.com/apache/camel-k/pull/1775) ([oscerd](https://github.com/oscerd))
- update prometheus trait doc with quarkus as default runtime [\#1772](https://github.com/apache/camel-k/pull/1772) ([smccarthy-ie](https://github.com/smccarthy-ie))
- Add a kamel debug command [\#1769](https://github.com/apache/camel-k/pull/1769) ([nicolaferraro](https://github.com/nicolaferraro))
- fix: Kamelet example [\#1768](https://github.com/apache/camel-k/pull/1768) ([christophd](https://github.com/christophd))
- fix: Correct operator leader election ConfigMap lock name [\#1765](https://github.com/apache/camel-k/pull/1765) ([astefanutti](https://github.com/astefanutti))
- Added workflow dispatch to changelog gh action [\#1764](https://github.com/apache/camel-k/pull/1764) ([oscerd](https://github.com/oscerd))
- Camel K operator monitoring [\#1762](https://github.com/apache/camel-k/pull/1762) ([astefanutti](https://github.com/astefanutti))
- Release Helm charts and bump versions [\#1759](https://github.com/apache/camel-k/pull/1759) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(build\): remove reference to staging repo [\#1758](https://github.com/apache/camel-k/pull/1758) ([lburgazzoli](https://github.com/lburgazzoli))
- Add inspect sub-command with basic support [\#1757](https://github.com/apache/camel-k/pull/1757) ([doru1004](https://github.com/doru1004))
- Fix \#1537: generate json schema for full Kubernetes resources [\#1756](https://github.com/apache/camel-k/pull/1756) ([nicolaferraro](https://github.com/nicolaferraro))
- chore: tidy go.sum [\#1755](https://github.com/apache/camel-k/pull/1755) ([astefanutti](https://github.com/astefanutti))
- Upgrade k8s api to 0.18.9 and Knative to 0.18.0 [\#1753](https://github.com/apache/camel-k/pull/1753) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(crd\): make CRD more json-schema friend [\#1752](https://github.com/apache/camel-k/pull/1752) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1750: auto-compress/encode binary sources and resources [\#1751](https://github.com/apache/camel-k/pull/1751) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1747: propagate icon on kameletbinding and fix integration owner… [\#1749](https://github.com/apache/camel-k/pull/1749) ([nicolaferraro](https://github.com/nicolaferraro))
- Add suport for gists [\#1748](https://github.com/apache/camel-k/pull/1748) ([lburgazzoli](https://github.com/lburgazzoli))
- Add support for Strimzi KafkaTopics in KameletBinding [\#1745](https://github.com/apache/camel-k/pull/1745) ([nicolaferraro](https://github.com/nicolaferraro))
- chore: Upgrade Prometheus to version 0.42.1 [\#1744](https://github.com/apache/camel-k/pull/1744) ([astefanutti](https://github.com/astefanutti))
- fix\(doc\): Set architecture diagram width explicitly [\#1742](https://github.com/apache/camel-k/pull/1742) ([astefanutti](https://github.com/astefanutti))
- Upgrade to Operator SDK 1.0+ [\#1741](https://github.com/apache/camel-k/pull/1741) ([astefanutti](https://github.com/astefanutti))
- Added installations steps to IBM Kubernetes Service\(IKS\) [\#1739](https://github.com/apache/camel-k/pull/1739) ([juanjopb](https://github.com/juanjopb))
- Fix typo [\#1736](https://github.com/apache/camel-k/pull/1736) ([llowinge](https://github.com/llowinge))
- doc: Add high-level architecture diagram [\#1735](https://github.com/apache/camel-k/pull/1735) ([astefanutti](https://github.com/astefanutti))
- fix: Uninstall cluster role bindings [\#1734](https://github.com/apache/camel-k/pull/1734) ([christophd](https://github.com/christophd))
- chore: Update rbac authorization k8s from v1beta1 to v1 [\#1733](https://github.com/apache/camel-k/pull/1733) ([christophd](https://github.com/christophd))
- chore: Fix operator sdk download url in release workflow [\#1731](https://github.com/apache/camel-k/pull/1731) ([christophd](https://github.com/christophd))
- fix\(\#1717\) Automatic changelog update should not be run on forks [\#1730](https://github.com/apache/camel-k/pull/1730) ([christophd](https://github.com/christophd))
- chore: Make scripts portable [\#1729](https://github.com/apache/camel-k/pull/1729) ([christophd](https://github.com/christophd))
- \[fix\] Use correct name of kameletbinding [\#1728](https://github.com/apache/camel-k/pull/1728) ([llowinge](https://github.com/llowinge))
- chore\(binding\): refactor binding mechanism and add many more tests [\#1727](https://github.com/apache/camel-k/pull/1727) ([nicolaferraro](https://github.com/nicolaferraro))
- \[fix\] Use bigger timeout to start querying metrics in test [\#1726](https://github.com/apache/camel-k/pull/1726) ([llowinge](https://github.com/llowinge))
- Related to \#1675: install default Kamelets [\#1725](https://github.com/apache/camel-k/pull/1725) ([nicolaferraro](https://github.com/nicolaferraro))
- fix: Adapt Knative service definition to new KnativeEnvironment definition [\#1724](https://github.com/apache/camel-k/pull/1724) ([astefanutti](https://github.com/astefanutti))
- Jolokia trait fixes so that it works with Hawtio Online [\#1723](https://github.com/apache/camel-k/pull/1723) ([astefanutti](https://github.com/astefanutti))
- \[fix\] Use in-place editing [\#1722](https://github.com/apache/camel-k/pull/1722) ([llowinge](https://github.com/llowinge))
- docs: add section describing secret ref in properties files [\#1716](https://github.com/apache/camel-k/pull/1716) ([evanshortiss](https://github.com/evanshortiss))
- Fix \#1710: auto-generate CRD specification on "generate" task \(and fix Kamelets\) [\#1714](https://github.com/apache/camel-k/pull/1714) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1709: add e2e tests about kamelets [\#1711](https://github.com/apache/camel-k/pull/1711) ([nicolaferraro](https://github.com/nicolaferraro))
- \[Minor\] grammatical/typo changes [\#1705](https://github.com/apache/camel-k/pull/1705) ([PoojaChandak](https://github.com/PoojaChandak))
- Document Update [\#1704](https://github.com/apache/camel-k/pull/1704) ([NiteshKoushik](https://github.com/NiteshKoushik))
- Document update [\#1703](https://github.com/apache/camel-k/pull/1703) ([NiteshKoushik](https://github.com/NiteshKoushik))
- Document Update [\#1702](https://github.com/apache/camel-k/pull/1702) ([NiteshKoushik](https://github.com/NiteshKoushik))
- Switch from Gitter to Zulip [\#1701](https://github.com/apache/camel-k/pull/1701) ([lburgazzoli](https://github.com/lburgazzoli))
- Add documentation about kamel run from github [\#1695](https://github.com/apache/camel-k/pull/1695) ([davsclaus](https://github.com/davsclaus))
- Automatic changelog: Let's run during the night only one time [\#1692](https://github.com/apache/camel-k/pull/1692) ([oscerd](https://github.com/oscerd))
- chore\(doc\): document Kamelets and fix small issues [\#1690](https://github.com/apache/camel-k/pull/1690) ([nicolaferraro](https://github.com/nicolaferraro))
- Changelog updater: run every hour [\#1688](https://github.com/apache/camel-k/pull/1688) ([oscerd](https://github.com/oscerd))
- Fix \#1670: upgrade to Knative 0.16 and support from 0.15 to 0.17 [\#1685](https://github.com/apache/camel-k/pull/1685) ([nicolaferraro](https://github.com/nicolaferraro))
- Added an automatic changelog Github action [\#1684](https://github.com/apache/camel-k/pull/1684) ([oscerd](https://github.com/oscerd))
- Add describe command completion [\#1683](https://github.com/apache/camel-k/pull/1683) ([johnpoth](https://github.com/johnpoth))
- fix \#1668: cancel previous context before issuing a new one [\#1679](https://github.com/apache/camel-k/pull/1679) ([nicolaferraro](https://github.com/nicolaferraro))
- Create amqpConsume.java [\#1678](https://github.com/apache/camel-k/pull/1678) ([rbaumgar](https://github.com/rbaumgar))
- build\(ci\): ignore some paths on the GitHub action workflows [\#1672](https://github.com/apache/camel-k/pull/1672) ([lburgazzoli](https://github.com/lburgazzoli))
- docs: remove old references to the runtime [\#1671](https://github.com/apache/camel-k/pull/1671) ([lburgazzoli](https://github.com/lburgazzoli))
- \[test\] Create integration test for exposing metrics to prometheus [\#1660](https://github.com/apache/camel-k/pull/1660) ([llowinge](https://github.com/llowinge))
- Remove backport gh action. It doesn't work [\#1659](https://github.com/apache/camel-k/pull/1659) ([oscerd](https://github.com/oscerd))
- Fixes \(mainly typo\) in documentation [\#1658](https://github.com/apache/camel-k/pull/1658) ([ikwattro](https://github.com/ikwattro))
- chore\(doc\): document sinkbinding in the context of sources and Kamelets [\#1655](https://github.com/apache/camel-k/pull/1655) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(release\): create additional tags for go modules [\#1653](https://github.com/apache/camel-k/pull/1653) ([nicolaferraro](https://github.com/nicolaferraro))
- Add support for oidc [\#1647](https://github.com/apache/camel-k/pull/1647) ([aslom](https://github.com/aslom))
- Related to \#1638 kamel init - should not create source file with ASF … [\#1644](https://github.com/apache/camel-k/pull/1644) ([oscerd](https://github.com/oscerd))
- Related to \#1638 kamel init - should not create source file with ASF … [\#1643](https://github.com/apache/camel-k/pull/1643) ([oscerd](https://github.com/oscerd))
- Related to \#1638 kamel init - should not create source file with ASF … [\#1642](https://github.com/apache/camel-k/pull/1642) ([oscerd](https://github.com/oscerd))
- Related to \#1638 kamel init - should not create source file with ASF … [\#1641](https://github.com/apache/camel-k/pull/1641) ([oscerd](https://github.com/oscerd))
- Related to \#1638 kamel init - should not create source file with ASF … [\#1640](https://github.com/apache/camel-k/pull/1640) ([oscerd](https://github.com/oscerd))
- Related to \#1638 kamel init - should not create source file with ASF … [\#1639](https://github.com/apache/camel-k/pull/1639) ([oscerd](https://github.com/oscerd))
- Add support for sinkbinding [\#1637](https://github.com/apache/camel-k/pull/1637) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1536: take modeline changes into account in dev mode [\#1634](https://github.com/apache/camel-k/pull/1634) ([johnpoth](https://github.com/johnpoth))
- fix\(doc\): Fix Affinity trait examples formatting [\#1631](https://github.com/apache/camel-k/pull/1631) ([astefanutti](https://github.com/astefanutti))
- Initial architecture documentation [\#1629](https://github.com/apache/camel-k/pull/1629) ([lburgazzoli](https://github.com/lburgazzoli))
- fix\(doc\): PodMonitoring -\> PodMonitor [\#1628](https://github.com/apache/camel-k/pull/1628) ([astefanutti](https://github.com/astefanutti))
- doc: Init troubleshooting guide [\#1627](https://github.com/apache/camel-k/pull/1627) ([astefanutti](https://github.com/astefanutti))
- chore\(doc\): Polish secured monitoring proposal [\#1626](https://github.com/apache/camel-k/pull/1626) ([astefanutti](https://github.com/astefanutti))
- doc: Update secured monitoring proposal for Quarkus/Knative single-port [\#1625](https://github.com/apache/camel-k/pull/1625) ([astefanutti](https://github.com/astefanutti))
- Fix \#1599: generate good trait doc [\#1622](https://github.com/apache/camel-k/pull/1622) ([nicolaferraro](https://github.com/nicolaferraro))
- Init .asf.yaml file [\#1621](https://github.com/apache/camel-k/pull/1621) ([astefanutti](https://github.com/astefanutti))
- Upgrade to staged Camel K runtime 1.4.0 \(Camel 3.4.0,Camel-Quarkus 1.… [\#1620](https://github.com/apache/camel-k/pull/1620) ([nicolaferraro](https://github.com/nicolaferraro))
- Set reply=false by default from knative broker and channel [\#1619](https://github.com/apache/camel-k/pull/1619) ([nicolaferraro](https://github.com/nicolaferraro))
- \#1556 - Add the camel category to Camel K CRDs [\#1615](https://github.com/apache/camel-k/pull/1615) ([ipolyzos](https://github.com/ipolyzos))
- Add examples back into the affinity trait documentation [\#1613](https://github.com/apache/camel-k/pull/1613) ([astefanutti](https://github.com/astefanutti))
- feat: expose Operator ImagePullPolicy option and set it to Always in … [\#1612](https://github.com/apache/camel-k/pull/1612) ([johnpoth](https://github.com/johnpoth))
- Use Quarkus as default runtime [\#1609](https://github.com/apache/camel-k/pull/1609) ([nicolaferraro](https://github.com/nicolaferraro))
- doc: add toc to readme [\#1606](https://github.com/apache/camel-k/pull/1606) ([tadayosi](https://github.com/tadayosi))
- Upgrade Knative to version 0.15.0 [\#1605](https://github.com/apache/camel-k/pull/1605) ([oscerd](https://github.com/oscerd))
- Fix \#1601: add v prefix to future tags [\#1603](https://github.com/apache/camel-k/pull/1603) ([nicolaferraro](https://github.com/nicolaferraro))
- Implement Kamelets [\#1602](https://github.com/apache/camel-k/pull/1602) ([nicolaferraro](https://github.com/nicolaferraro))
- feat: Structured traits configuration serialization [\#1600](https://github.com/apache/camel-k/pull/1600) ([astefanutti](https://github.com/astefanutti))
- Fix typo missing space "featuresare" -\> "features are" [\#1598](https://github.com/apache/camel-k/pull/1598) ([apupier](https://github.com/apupier))
- chore: Add information on how to debug the camel-k operator [\#1597](https://github.com/apache/camel-k/pull/1597) ([johnpoth](https://github.com/johnpoth))
- Fixes incomplete help message [\#1596](https://github.com/apache/camel-k/pull/1596) ([orpiske](https://github.com/orpiske))
- Submit secured monitoring proposal [\#1594](https://github.com/apache/camel-k/pull/1594) ([astefanutti](https://github.com/astefanutti))
- Document CRC's insecure Docker registry \#1410 [\#1592](https://github.com/apache/camel-k/pull/1592) ([johnpoth](https://github.com/johnpoth))
- fix\(api\): Declare integration Flow as json.RawMessage [\#1591](https://github.com/apache/camel-k/pull/1591) ([astefanutti](https://github.com/astefanutti))
- fix\(doc\): Correct title levels in monitoring documentation [\#1589](https://github.com/apache/camel-k/pull/1589) ([astefanutti](https://github.com/astefanutti))
- Monitoring docs: Fixed link [\#1588](https://github.com/apache/camel-k/pull/1588) ([oscerd](https://github.com/oscerd))
- feat: Integration scale sub-resource works with HPA [\#1587](https://github.com/apache/camel-k/pull/1587) ([astefanutti](https://github.com/astefanutti))
- doc: Complete the monitoring documentation [\#1586](https://github.com/apache/camel-k/pull/1586) ([astefanutti](https://github.com/astefanutti))
- feat\(crd\): Generate CRDs from APIs [\#1582](https://github.com/apache/camel-k/pull/1582) ([astefanutti](https://github.com/astefanutti))
- Fix typo fo -\> of [\#1578](https://github.com/apache/camel-k/pull/1578) ([apupier](https://github.com/apupier))
- add documentation for CRC \#1410 [\#1570](https://github.com/apache/camel-k/pull/1570) ([johnpoth](https://github.com/johnpoth))
- doc: Add monitoring documentation [\#1569](https://github.com/apache/camel-k/pull/1569) ([astefanutti](https://github.com/astefanutti))
- fix typo [\#1564](https://github.com/apache/camel-k/pull/1564) ([nicolaferraro](https://github.com/nicolaferraro))
- Added token as parameter to backport gh action [\#1563](https://github.com/apache/camel-k/pull/1563) ([oscerd](https://github.com/oscerd))
- Added back token for gh action [\#1561](https://github.com/apache/camel-k/pull/1561) ([oscerd](https://github.com/oscerd))
- Switch to Syndesis backport github action [\#1560](https://github.com/apache/camel-k/pull/1560) ([oscerd](https://github.com/oscerd))
- fix\(jvm\): Integration do not shutdown gracefully when jvm.print-command is set [\#1558](https://github.com/apache/camel-k/pull/1558) ([astefanutti](https://github.com/astefanutti))
- fix\(util\): line break after "Monitoring pod ..." message [\#1554](https://github.com/apache/camel-k/pull/1554) ([tadayosi](https://github.com/tadayosi))
- fix: bug in utility function [\#1553](https://github.com/apache/camel-k/pull/1553) ([nicolaferraro](https://github.com/nicolaferraro))
- support make install-crc \#1410 [\#1544](https://github.com/apache/camel-k/pull/1544) ([johnpoth](https://github.com/johnpoth))
- Cannot expose knative endpoints in YAML [\#1540](https://github.com/apache/camel-k/pull/1540) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: add a backport action [\#1531](https://github.com/apache/camel-k/pull/1531) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(doc\): remove redundant '/build' entry in project structure [\#1530](https://github.com/apache/camel-k/pull/1530) ([tadayosi](https://github.com/tadayosi))
- fix: JVM trait overrides other traits JVM arguments [\#1528](https://github.com/apache/camel-k/pull/1528) ([astefanutti](https://github.com/astefanutti))
- \#1524 set the OLM channel used on install to 'stable' [\#1527](https://github.com/apache/camel-k/pull/1527) ([ipolyzos](https://github.com/ipolyzos))
-  \#1321 add support for nodeport type for services [\#1526](https://github.com/apache/camel-k/pull/1526) ([ipolyzos](https://github.com/ipolyzos))
- Add ikb as alias for builds.camel.apache.org [\#1521](https://github.com/apache/camel-k/pull/1521) ([lburgazzoli](https://github.com/lburgazzoli))
- fix for \#1511 [\#1517](https://github.com/apache/camel-k/pull/1517) ([ipolyzos](https://github.com/ipolyzos))
- CLI - Make kamel run handle github urls that are not raw [\#1515](https://github.com/apache/camel-k/pull/1515) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(release\): bump version to 1.1.0-SNAPSHOT and update OLM/HELM [\#1510](https://github.com/apache/camel-k/pull/1510) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(ci\): fix ci repository configuration [\#1504](https://github.com/apache/camel-k/pull/1504) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(release\): bump runtime to 1.3.0 [\#1501](https://github.com/apache/camel-k/pull/1501) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(jvm\): Bind all interfaces to restore remote debugging with newer JDK versions [\#1500](https://github.com/apache/camel-k/pull/1500) ([astefanutti](https://github.com/astefanutti))
- Add stale action [\#1499](https://github.com/apache/camel-k/pull/1499) ([lburgazzoli](https://github.com/lburgazzoli))
- feat: Add option to print JVM command in integration logs [\#1496](https://github.com/apache/camel-k/pull/1496) ([astefanutti](https://github.com/astefanutti))
- chore\(ci\): bump setup jdk action in CI [\#1494](https://github.com/apache/camel-k/pull/1494) ([nicolaferraro](https://github.com/nicolaferraro))
- Avoid requirements of a kubeconfig when using  command [\#1493](https://github.com/apache/camel-k/pull/1493) ([lburgazzoli](https://github.com/lburgazzoli))
- Add tracing trait and automatically discover Jaeger [\#1492](https://github.com/apache/camel-k/pull/1492) ([nicolaferraro](https://github.com/nicolaferraro))
- support for jitpack dependencies [\#1491](https://github.com/apache/camel-k/pull/1491) ([lburgazzoli](https://github.com/lburgazzoli))
- feat: Prometheus support for Quarkus based on MicroProfile Metrics [\#1490](https://github.com/apache/camel-k/pull/1490) ([astefanutti](https://github.com/astefanutti))
- chore\(keys\): update PGP key [\#1488](https://github.com/apache/camel-k/pull/1488) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1396: use circuitbreaker capability from runtime [\#1486](https://github.com/apache/camel-k/pull/1486) ([nicolaferraro](https://github.com/nicolaferraro))
- fix: Regenerate catalogs with Camel version 3.3.0 [\#1485](https://github.com/apache/camel-k/pull/1485) ([astefanutti](https://github.com/astefanutti))
- sanitized integration name on Windows contains whole path [\#1484](https://github.com/apache/camel-k/pull/1484) ([oscerd](https://github.com/oscerd))
- chore\(ci\): install latest openjdk in Travis [\#1483](https://github.com/apache/camel-k/pull/1483) ([nicolaferraro](https://github.com/nicolaferraro))
- Upgrade Operator SDK to version 0.17.1 [\#1482](https://github.com/apache/camel-k/pull/1482) ([astefanutti](https://github.com/astefanutti))
- Code clean-up [\#1481](https://github.com/apache/camel-k/pull/1481) ([astefanutti](https://github.com/astefanutti))
- chore\(builder\): enable Spectrum to publish to authenticated registries [\#1479](https://github.com/apache/camel-k/pull/1479) ([nicolaferraro](https://github.com/nicolaferraro))
- Make Prometheus trait compatible with Knative Serving [\#1478](https://github.com/apache/camel-k/pull/1478) ([astefanutti](https://github.com/astefanutti))
- chore\(client\): generate client interface for catalog [\#1477](https://github.com/apache/camel-k/pull/1477) ([nicolaferraro](https://github.com/nicolaferraro))
- Uninstall all doc [\#1475](https://github.com/apache/camel-k/pull/1475) ([ipolyzos](https://github.com/ipolyzos))
- fix: Use platform HTTP server in REST DSL example [\#1474](https://github.com/apache/camel-k/pull/1474) ([astefanutti](https://github.com/astefanutti))
- Fixed link in Quarkus.adoc [\#1473](https://github.com/apache/camel-k/pull/1473) ([oscerd](https://github.com/oscerd))
- Fix \#1470: support inline YAML [\#1472](https://github.com/apache/camel-k/pull/1472) ([nicolaferraro](https://github.com/nicolaferraro))
- Update uninstalling.doc [\#1467](https://github.com/apache/camel-k/pull/1467) ([ipolyzos](https://github.com/ipolyzos))
- \#1465 remove crd and clusterrole on uninstall [\#1466](https://github.com/apache/camel-k/pull/1466) ([ipolyzos](https://github.com/ipolyzos))
- Fix \#1463: add apis and client as submodule [\#1464](https://github.com/apache/camel-k/pull/1464) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1045: hide internal CRDs in OLM console [\#1461](https://github.com/apache/camel-k/pull/1461) ([nicolaferraro](https://github.com/nicolaferraro))
- Make cron work on quarkus runtime [\#1460](https://github.com/apache/camel-k/pull/1460) ([nicolaferraro](https://github.com/nicolaferraro))
- Allow the short syntax in knative endpoints [\#1458](https://github.com/apache/camel-k/pull/1458) ([nicolaferraro](https://github.com/nicolaferraro))
- Remove unused import package in example [\#1457](https://github.com/apache/camel-k/pull/1457) ([apupier](https://github.com/apupier))

## [pkg/client/camel/v1.8.2](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.8.2) (2022-03-03)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.8.2...pkg/client/camel/v1.8.2)

## [v1.8.2](https://github.com/apache/camel-k/tree/v1.8.2) (2022-03-03)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.8.2...v1.8.2)

## [pkg/kamelet/repository/v1.8.2](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.8.2) (2022-03-03)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.8.2...pkg/kamelet/repository/v1.8.2)

## [pkg/apis/camel/v1.8.2](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.8.2) (2022-03-03)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.8.1...pkg/apis/camel/v1.8.2)

**Closed issues:**

- Container Trait for Resource Allocation on Openshift [\#3052](https://github.com/apache/camel-k/issues/3052)
- IntegrationKit creation based on YAML file fails [\#3033](https://github.com/apache/camel-k/issues/3033)
- Expose Camel-related metrics \(Prometheus\) [\#3027](https://github.com/apache/camel-k/issues/3027)
- Helm multiple namespace install Camel-K [\#2985](https://github.com/apache/camel-k/issues/2985)
- Release 1.8.1 [\#2983](https://github.com/apache/camel-k/issues/2983)
- Makefile Release staging: Pass the remote repository name as argument with origin as default  [\#2891](https://github.com/apache/camel-k/issues/2891)
- Release note script: Check if the GITHUB\_TOKEN var has been set before running the command [\#2890](https://github.com/apache/camel-k/issues/2890)
- Remove deprecated code [\#2751](https://github.com/apache/camel-k/issues/2751)
- \[E2E\] Test error handler appears to be flaky [\#2744](https://github.com/apache/camel-k/issues/2744)
- `Kamel local` chokes on traits [\#2499](https://github.com/apache/camel-k/issues/2499)
- Documentation for `kamel local run` [\#2490](https://github.com/apache/camel-k/issues/2490)
- Support for HashiCorp Vault [\#2107](https://github.com/apache/camel-k/issues/2107)
- Provide automated tests for "kamel local run --integration-directory \<dir-name\>" command [\#2075](https://github.com/apache/camel-k/issues/2075)
- Support for POJO, bring it back!  [\#1821](https://github.com/apache/camel-k/issues/1821)

## [pkg/client/camel/v1.8.1](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.8.1) (2022-02-21)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.8.1...pkg/client/camel/v1.8.1)

## [pkg/kamelet/repository/v1.8.1](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.8.1) (2022-02-21)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.8.1...pkg/kamelet/repository/v1.8.1)

## [pkg/apis/camel/v1.8.1](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.8.1) (2022-02-21)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.8.1...pkg/apis/camel/v1.8.1)

## [v1.8.1](https://github.com/apache/camel-k/tree/v1.8.1) (2022-02-21)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.8.0...v1.8.1)

**Closed issues:**

- logging.level.org.apache.camel=DEBUG does not affect integration logs. [\#3024](https://github.com/apache/camel-k/issues/3024)
- Build artifact checksum not working [\#3007](https://github.com/apache/camel-k/issues/3007)
- kamel client for macOS from release 1.8.0 is really 1.0.0-M4 [\#3006](https://github.com/apache/camel-k/issues/3006)
- SEDA multiple threads not working [\#3001](https://github.com/apache/camel-k/issues/3001)
- Errored status Kamelet cannot be reconciled to Ready status [\#2988](https://github.com/apache/camel-k/issues/2988)
- Kamel install failure [\#2987](https://github.com/apache/camel-k/issues/2987)
- Configure Maven: Artifact Repository is not recognized [\#2966](https://github.com/apache/camel-k/issues/2966)
- camel-k-operator forbidden to get kafkachannels.messaging.knative.dev since 1.8.x [\#2950](https://github.com/apache/camel-k/issues/2950)
- \[regression\] Cannot provide 2 resources with 1.8.0 [\#2943](https://github.com/apache/camel-k/issues/2943)
- \[Docs/Website\] Generate API documentation as AsciiDoc rather than html [\#2898](https://github.com/apache/camel-k/issues/2898)
- Enabling prometheus causes KameletBindings to be stuck in status "Creating" [\#2896](https://github.com/apache/camel-k/issues/2896)
- Stale bot is setting issue `stale` where marked as `never-stale` [\#2893](https://github.com/apache/camel-k/issues/2893)
- camel-k-client binary is missing in the latest release assets [\#2892](https://github.com/apache/camel-k/issues/2892)
- Release 1.8.0 [\#2848](https://github.com/apache/camel-k/issues/2848)
- Error: unknown flag: --trait on local build [\#2776](https://github.com/apache/camel-k/issues/2776)
- Implement gosec to inspect source code for security problems [\#2763](https://github.com/apache/camel-k/issues/2763)
- Kamelet with MQTT Broker Mosquitto [\#2690](https://github.com/apache/camel-k/issues/2690)
- Unable to access MongoDB [\#2684](https://github.com/apache/camel-k/issues/2684)
- KAMEL\_INSTALL\_DEFAULT\_KAMELETS behavior [\#2560](https://github.com/apache/camel-k/issues/2560)
- Log warnings with kamelets [\#2395](https://github.com/apache/camel-k/issues/2395)
- Json marshalling is needed for Rest route and uncommented code seems to be executed [\#2341](https://github.com/apache/camel-k/issues/2341)
- build: use golangci/golangci-lint-action [\#2334](https://github.com/apache/camel-k/issues/2334)
- Change autogen doc template to adoc [\#2289](https://github.com/apache/camel-k/issues/2289)
- Kamel dump: make the command smarter [\#2189](https://github.com/apache/camel-k/issues/2189)

## [pkg/kamelet/repository/v1.8.0](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.8.0) (2022-01-19)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.8.0...pkg/kamelet/repository/v1.8.0)

## [pkg/apis/camel/v1.8.0](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.8.0) (2022-01-19)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.8.0...pkg/apis/camel/v1.8.0)

## [pkg/client/camel/v1.8.0](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.8.0) (2022-01-19)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.8.0...pkg/client/camel/v1.8.0)

## [v1.8.0](https://github.com/apache/camel-k/tree/v1.8.0) (2022-01-19)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.7.0...v1.8.0)

**Closed issues:**

- Update Antora usage [\#2852](https://github.com/apache/camel-k/issues/2852)
- Support local dependencies when running an integration [\#2834](https://github.com/apache/camel-k/issues/2834)
- Log4j Security Issue [\#2830](https://github.com/apache/camel-k/issues/2830)
- Outdated `ca-cert` path for Jolokia trait [\#2827](https://github.com/apache/camel-k/issues/2827)
- Kafka component propagating headers is supported? [\#2825](https://github.com/apache/camel-k/issues/2825)
- Integration with To-D can't find Kamelet [\#2819](https://github.com/apache/camel-k/issues/2819)
- KameletBinding - Make error handler more simpler [\#2815](https://github.com/apache/camel-k/issues/2815)
- CXF Support [\#2799](https://github.com/apache/camel-k/issues/2799)
- Update documentation about monitoring metrics using Prometheus Operator 0.38.0 [\#2794](https://github.com/apache/camel-k/issues/2794)
- Makefile: for the generate-doc target don't use show-progress for wget [\#2791](https://github.com/apache/camel-k/issues/2791)
- how i use build-property on Integration crd [\#2789](https://github.com/apache/camel-k/issues/2789)
- Align to the new folder structure on Camel-Kamelets [\#2788](https://github.com/apache/camel-k/issues/2788)
- user provided maven setting are overridden by the camel-k operator [\#2777](https://github.com/apache/camel-k/issues/2777)
- Let user configure configmaps/secrets for `kamel run --openapi` option [\#2772](https://github.com/apache/camel-k/issues/2772)
- Dry run kamel run [\#2769](https://github.com/apache/camel-k/issues/2769)
- Is there any resources requirements for camel-k operator Deployment? [\#2768](https://github.com/apache/camel-k/issues/2768)
- How to use a custom Kamelet Repository? [\#2765](https://github.com/apache/camel-k/issues/2765)
- Jitpack still configured with `master` branch [\#2764](https://github.com/apache/camel-k/issues/2764)
- How can I find the log file location in the integration pod?  [\#2762](https://github.com/apache/camel-k/issues/2762)
- Default value of trait container.port-name is missing from catalog [\#2761](https://github.com/apache/camel-k/issues/2761)
- Trait catalog provided by kamel CLI contains a description mentioning "the end of this page"  [\#2760](https://github.com/apache/camel-k/issues/2760)
- Document dependency on camel-quarkus \(and camel\) [\#2759](https://github.com/apache/camel-k/issues/2759)
- How to remove Kamelets installation when installing IntegrationPlatform CRD? [\#2756](https://github.com/apache/camel-k/issues/2756)
- Add 1.7.x documentation tag [\#2753](https://github.com/apache/camel-k/issues/2753)
- Generated bundle created from `make bundle` contains separate service-account resource [\#2749](https://github.com/apache/camel-k/issues/2749)
- Could not pull base image - Build kit failed \(No matching credentials were found, falling back on anonymous\) [\#2748](https://github.com/apache/camel-k/issues/2748)
- Cannot deploy XML integration with undertow [\#2746](https://github.com/apache/camel-k/issues/2746)
- Release 1.7.0 [\#2743](https://github.com/apache/camel-k/issues/2743)
- \[E2E\] Reconciliation duration metric failure [\#2742](https://github.com/apache/camel-k/issues/2742)
- Camel K SEDA Queue full Issue [\#2725](https://github.com/apache/camel-k/issues/2725)
- How to set map properties in the kamelet parameters via the yaml definition? [\#2608](https://github.com/apache/camel-k/issues/2608)
- Provide a way to specify exclusions for a dependency [\#2598](https://github.com/apache/camel-k/issues/2598)
- Google storage component doesn't work [\#2576](https://github.com/apache/camel-k/issues/2576)
- topicName [\#2567](https://github.com/apache/camel-k/issues/2567)
- Kamelet: default KameletBindings configuration settings [\#2558](https://github.com/apache/camel-k/issues/2558)
- Trying to run Sample.java in Kind cluster [\#2542](https://github.com/apache/camel-k/issues/2542)
- Multiple of the examples fail on Minikube [\#2537](https://github.com/apache/camel-k/issues/2537)
- Camel-K - uninstall and namespace deletion w/ k8s let all Camel-K Integrations in this namespace alive [\#2533](https://github.com/apache/camel-k/issues/2533)
- insecure=true does not work with base image [\#2531](https://github.com/apache/camel-k/issues/2531)
- Install Error [\#2498](https://github.com/apache/camel-k/issues/2498)
- Make sure Camel K runs on Microshift [\#2473](https://github.com/apache/camel-k/issues/2473)
- If the pod is in CrashLoopBackOff, the phase is reported as Running [\#2445](https://github.com/apache/camel-k/issues/2445)
- \[Trait\] Configuration refactoring [\#2320](https://github.com/apache/camel-k/issues/2320)
- Wait for dependencies  [\#2151](https://github.com/apache/camel-k/issues/2151)
- Secret type not supported with buildah on K3S [\#2136](https://github.com/apache/camel-k/issues/2136)
- Camel K doesn't automatically create an endpoint to view the Openapi doc that it was built with. [\#2135](https://github.com/apache/camel-k/issues/2135)
- Ability to pre-build integrations [\#2129](https://github.com/apache/camel-k/issues/2129)
- Kamelet using Java DSL [\#2117](https://github.com/apache/camel-k/issues/2117)
- Add sample using Flink [\#2116](https://github.com/apache/camel-k/issues/2116)
- OLM installation may fail with default values [\#2113](https://github.com/apache/camel-k/issues/2113)
- Kamelet - Possible to pre configure component options [\#2081](https://github.com/apache/camel-k/issues/2081)
- Monitor integration related events [\#2025](https://github.com/apache/camel-k/issues/2025)
- Switch to UBI minimal  [\#2007](https://github.com/apache/camel-k/issues/2007)
- AMQP connection factory injection example improvement [\#1961](https://github.com/apache/camel-k/issues/1961)
- Option to declare capabilities an integration requires [\#1948](https://github.com/apache/camel-k/issues/1948)
- Expose operator information [\#1947](https://github.com/apache/camel-k/issues/1947)
- not able to use json: MethodNotFoundException [\#1915](https://github.com/apache/camel-k/issues/1915)
- hotrod-client.properties not picked up [\#1898](https://github.com/apache/camel-k/issues/1898)
- Using -SNAPSHOT prevents rebuilding past commits [\#1878](https://github.com/apache/camel-k/issues/1878)
- './kamel run xxx' and 'make test-integration' pod failures on Ubuntu 16.04 \(with minikube\) [\#1869](https://github.com/apache/camel-k/issues/1869)
- GitHub Packages registry cannot be used as expected [\#1860](https://github.com/apache/camel-k/issues/1860)
- Camel sslContextParameter not working [\#1815](https://github.com/apache/camel-k/issues/1815)
- Document Jitpack usage [\#1789](https://github.com/apache/camel-k/issues/1789)
- Global operator mode on Minikube not working [\#1766](https://github.com/apache/camel-k/issues/1766)
- Consider listing operator in Artifact Hub [\#1732](https://github.com/apache/camel-k/issues/1732)
- can't run hello.java,maybe somethings wrong with registry [\#1699](https://github.com/apache/camel-k/issues/1699)
- Support for Camel Kafka Connector [\#1682](https://github.com/apache/camel-k/issues/1682)
- Workaround for knative-source loader does not exists any more? [\#1666](https://github.com/apache/camel-k/issues/1666)
- IntegrationKit stuck in 'Build Submitted' phase due to validation error 'type in spec.tasks.image.volumes.secret is required' on GKE [\#1663](https://github.com/apache/camel-k/issues/1663)
- Unable to install camel-k with Google Kubernetes Engine [\#1661](https://github.com/apache/camel-k/issues/1661)
- Regression on CLI 1.0.0 injecting routes file? [\#1651](https://github.com/apache/camel-k/issues/1651)
- Add the option to deploy a CamelSource Integration from the CLI [\#1650](https://github.com/apache/camel-k/issues/1650)
- Kaniko produces " UNAUTHORIZED: authentication required" error when building an integration route with Dockerhub [\#1572](https://github.com/apache/camel-k/issues/1572)
- Buildah produces "stderr: permission denied" when building an integration route with Dockerhub  [\#1571](https://github.com/apache/camel-k/issues/1571)
- Running in Azure AKS with ACR Registry [\#1566](https://github.com/apache/camel-k/issues/1566)
- Kamel run issue [\#1551](https://github.com/apache/camel-k/issues/1551)
- Kamel 1.0 fails on install on mac [\#1543](https://github.com/apache/camel-k/issues/1543)
- kamel run that can auto discover/guess what to include and run [\#1409](https://github.com/apache/camel-k/issues/1409)
- Honor cluster PROXY settings [\#1402](https://github.com/apache/camel-k/issues/1402)
- Configurable maven options [\#1332](https://github.com/apache/camel-k/issues/1332)
- traits: support capabilities [\#1331](https://github.com/apache/camel-k/issues/1331)
- Cannot append/override stored properties [\#1323](https://github.com/apache/camel-k/issues/1323)
- CLI log could use some kind of feedback when waiting for pod to spin up [\#1283](https://github.com/apache/camel-k/issues/1283)
- Kaniko in builder pod failed to push image to docker registry [\#1282](https://github.com/apache/camel-k/issues/1282)
- Add a trait\(?\) to enable default REST DSL endpoint [\#1239](https://github.com/apache/camel-k/issues/1239)
- Camel-K Doesn't Create a Service or Ingress for an Integration [\#1232](https://github.com/apache/camel-k/issues/1232)
- Performance and Architectural Questions On Camel-K [\#1196](https://github.com/apache/camel-k/issues/1196)
- Transactions with Camel K [\#1128](https://github.com/apache/camel-k/issues/1128)
- Investigate integration with Keda [\#1107](https://github.com/apache/camel-k/issues/1107)
- Camel K Operator don't ignore commented endpoint in the JAVA DSL source [\#1057](https://github.com/apache/camel-k/issues/1057)
- Kamel cli should send exit code when integration in --dev mode is deleted [\#938](https://github.com/apache/camel-k/issues/938)
- Kafka example not building on OpenShit v4.? - latest crc version on Mac [\#918](https://github.com/apache/camel-k/issues/918)
- Documenting expected behavior with certain potential collisions [\#870](https://github.com/apache/camel-k/issues/870)
- no matches for kind "BuildConfig" in version "build.openshift.io/v1" [\#739](https://github.com/apache/camel-k/issues/739)
- Add camel-k-runtime to the root readme [\#630](https://github.com/apache/camel-k/issues/630)
- support versions like 2.21.0.tag-730075-anothertag-00002 in version matching [\#617](https://github.com/apache/camel-k/issues/617)
- Camel K with Java routes without public class and imports ... [\#605](https://github.com/apache/camel-k/issues/605)

## [pkg/apis/camel/v1.7.0](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.7.0) (2021-11-10)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.7.0...pkg/apis/camel/v1.7.0)

## [pkg/client/camel/v1.7.0](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.7.0) (2021-11-10)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.7.0...pkg/client/camel/v1.7.0)

## [v1.7.0](https://github.com/apache/camel-k/tree/v1.7.0) (2021-11-10)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.7.0...v1.7.0)

## [pkg/kamelet/repository/v1.7.0](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.7.0) (2021-11-10)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.6.1...pkg/kamelet/repository/v1.7.0)

**Closed issues:**

- 02-serverless-api example fails in the camel-k-examples repo \(same as \#2400\) [\#2738](https://github.com/apache/camel-k/issues/2738)
- ErrorHandler for stopping a route when an error occurs [\#2724](https://github.com/apache/camel-k/issues/2724)
- Release 1.6.1 [\#2713](https://github.com/apache/camel-k/issues/2713)
- Building with buildah not working [\#2685](https://github.com/apache/camel-k/issues/2685)
- Flaky TestKameletBindingScale test? [\#2660](https://github.com/apache/camel-k/issues/2660)
- CloudEvent header mapping is confusing [\#2501](https://github.com/apache/camel-k/issues/2501)
- Revisit saga example [\#2472](https://github.com/apache/camel-k/issues/2472)
- kamel run command creates 2 pods [\#2469](https://github.com/apache/camel-k/issues/2469)
- Trying to use bean method call \#class:com.mongodb.client.MongoClients\#create\("mongodb://foo"\) throws ClassNotFoundException [\#2444](https://github.com/apache/camel-k/issues/2444)
- kamelet binding: support for openapi ? [\#2409](https://github.com/apache/camel-k/issues/2409)
- kamel uninstall should uninstall everything by default [\#2405](https://github.com/apache/camel-k/issues/2405)
- `kamel run --maven-repository` doesn't work when we have `@mirrorOf=*` at `kamel install` [\#2391](https://github.com/apache/camel-k/issues/2391)
- kamel subcommand for kamelet bindings? [\#2363](https://github.com/apache/camel-k/issues/2363)
- build: install required binaries in a temporary subdirectory of the project [\#2335](https://github.com/apache/camel-k/issues/2335)
- build: update to latest golangci-lint [\#2333](https://github.com/apache/camel-k/issues/2333)
- "cannot find symbol" issue in camel-k releases v1.4.0 [\#2317](https://github.com/apache/camel-k/issues/2317)
- Leverage KinD multi-nodes cluster setup for CI [\#2302](https://github.com/apache/camel-k/issues/2302)
- Docs validation CI workflow [\#2278](https://github.com/apache/camel-k/issues/2278)
- Kamel reset fails with KameletBinding [\#2221](https://github.com/apache/camel-k/issues/2221)
- Use environment independent `operator-sdk` CLI version [\#2167](https://github.com/apache/camel-k/issues/2167)
- Extend config docs to reflect all possibilities coming from camel [\#2153](https://github.com/apache/camel-k/issues/2153)
- Separate readiness and liveness probe [\#1610](https://github.com/apache/camel-k/issues/1610)

## [pkg/kamelet/repository/v1.6.1](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.6.1) (2021-10-23)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.6.1...pkg/kamelet/repository/v1.6.1)

## [pkg/apis/camel/v1.6.1](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.6.1) (2021-10-23)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.6.1...pkg/apis/camel/v1.6.1)

## [v1.6.1](https://github.com/apache/camel-k/tree/v1.6.1) (2021-10-23)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.6.1...v1.6.1)

## [pkg/client/camel/v1.6.1](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.6.1) (2021-10-23)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.6.0...pkg/client/camel/v1.6.1)

**Closed issues:**

- kamel install: cannot find k8s-certificates [\#2702](https://github.com/apache/camel-k/issues/2702)
- Stale bot action failing [\#2698](https://github.com/apache/camel-k/issues/2698)
- panic: runtime error: invalid memory address or nil pointer dereference when running a simple integration [\#2697](https://github.com/apache/camel-k/issues/2697)
- Enable secondary integration platforms [\#2687](https://github.com/apache/camel-k/issues/2687)
- Error: Object 'Kind' is missing in 'null' [\#2674](https://github.com/apache/camel-k/issues/2674)
- Provide automatic PR creation to update "peripheral" go dependencies [\#2663](https://github.com/apache/camel-k/issues/2663)
- Alow fixed custom labels in any pod [\#2642](https://github.com/apache/camel-k/issues/2642)
- Integration in error phase can't be scaled: why don't we just rebuild it? [\#2640](https://github.com/apache/camel-k/issues/2640)
- kamelet binding: scaling to 0 and the to 1 not working when a container image is provided [\#2638](https://github.com/apache/camel-k/issues/2638)
- Container trait documentation messed up [\#2626](https://github.com/apache/camel-k/issues/2626)
- Bots to simplify project managment [\#2623](https://github.com/apache/camel-k/issues/2623)
- Contribution missing in 1.6.0 release note [\#2621](https://github.com/apache/camel-k/issues/2621)
- Kamelet add support for tolerations [\#2602](https://github.com/apache/camel-k/issues/2602)
- Release 1.6.0 [\#2591](https://github.com/apache/camel-k/issues/2591)
- Should we move to go 1.16 / 1.17 ? [\#2579](https://github.com/apache/camel-k/issues/2579)
- Read certificates from secrets to setup TLS config for route trait [\#2574](https://github.com/apache/camel-k/issues/2574)
- kamel bind does not support --connect for ServiceBinding [\#2566](https://github.com/apache/camel-k/issues/2566)
- Investigate Camel K deployment on k3d [\#2518](https://github.com/apache/camel-k/issues/2518)
- Issue when trying to configure env vars with annotations [\#2512](https://github.com/apache/camel-k/issues/2512)
- kamel cli output redirection doesn't work for some commands [\#2495](https://github.com/apache/camel-k/issues/2495)
- Cron Trait - Should use max idle seconds to auto terminate instead of max messages [\#2439](https://github.com/apache/camel-k/issues/2439)
- install: optional registry [\#2358](https://github.com/apache/camel-k/issues/2358)
- kamelet binding: make it possible to use normalized name  [\#2296](https://github.com/apache/camel-k/issues/2296)
- \[Doc\] Add documentation for architecture [\#2273](https://github.com/apache/camel-k/issues/2273)
- Provide kustomize installation configuration for install of camel-k [\#1979](https://github.com/apache/camel-k/issues/1979)
- operator: option to limit CRs the operator should handle [\#1943](https://github.com/apache/camel-k/issues/1943)
- Document, or provide examples for, TLS configuration on OpenShift [\#1033](https://github.com/apache/camel-k/issues/1033)
- support for quarkus in native mode [\#991](https://github.com/apache/camel-k/issues/991)
- Release yaml files for installation [\#550](https://github.com/apache/camel-k/issues/550)

## [v1.6.0](https://github.com/apache/camel-k/tree/v1.6.0) (2021-09-03)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.6.0...v1.6.0)

## [pkg/apis/camel/v1.6.0](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.6.0) (2021-09-03)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.6.0...pkg/apis/camel/v1.6.0)

## [pkg/client/camel/v1.6.0](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.6.0) (2021-09-03)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.6.0...pkg/client/camel/v1.6.0)

## [pkg/kamelet/repository/v1.6.0](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.6.0) (2021-09-03)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.5.1...pkg/kamelet/repository/v1.6.0)

**Closed issues:**

- Numeric values are not properly encoded in KameletBindings [\#2616](https://github.com/apache/camel-k/issues/2616)
- How to define custom container specs ? [\#2606](https://github.com/apache/camel-k/issues/2606)
- groupId is overriden by `camel-k-integration` using kafka consumer [\#2605](https://github.com/apache/camel-k/issues/2605)
- Release 1.5.1 [\#2590](https://github.com/apache/camel-k/issues/2590)
- jitpack dependency is not resolved [\#2589](https://github.com/apache/camel-k/issues/2589)
- Upgrade Service Binding Operator to latest version [\#2553](https://github.com/apache/camel-k/issues/2553)
- Evaluate/Cleanup logging trait dependency [\#2541](https://github.com/apache/camel-k/issues/2541)
- kamelet binding : camel controller fail reconcile the kafka sink resource. [\#2528](https://github.com/apache/camel-k/issues/2528)
- camel-k-integration override provided groupId name in Kafka component [\#2523](https://github.com/apache/camel-k/issues/2523)
- DeadLetterURI Dependency autodiscover [\#2492](https://github.com/apache/camel-k/issues/2492)
- kamel bind -o yaml creates wrong data [\#2480](https://github.com/apache/camel-k/issues/2480)
- propagate labels to deployments and pods [\#2446](https://github.com/apache/camel-k/issues/2446)
- Supporting Apache Camel 3.10 [\#2326](https://github.com/apache/camel-k/issues/2326)
- No possibility to disable compression while executing `kamel run` [\#2227](https://github.com/apache/camel-k/issues/2227)
- `extensions/v1beta1` Ingress is deprecated [\#2157](https://github.com/apache/camel-k/issues/2157)
- Wiretap to Kamelet does not work in YAML [\#2139](https://github.com/apache/camel-k/issues/2139)
- More information needed about dependency resolution [\#2085](https://github.com/apache/camel-k/issues/2085)

## [pkg/kamelet/repository/v1.5.1](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.5.1) (2021-08-27)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.5.1...pkg/kamelet/repository/v1.5.1)

## [v1.5.1](https://github.com/apache/camel-k/tree/v1.5.1) (2021-08-27)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.5.1...v1.5.1)

## [pkg/apis/camel/v1.5.1](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.5.1) (2021-08-27)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.5.1...pkg/apis/camel/v1.5.1)

## [pkg/client/camel/v1.5.1](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.5.1) (2021-08-27)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.5.0...pkg/client/camel/v1.5.1)

**Closed issues:**

- Upgrade to Jolokia 1.7.0 [\#2593](https://github.com/apache/camel-k/issues/2593)
- Modeline, build-property not checking if option also provided by the user [\#2569](https://github.com/apache/camel-k/issues/2569)
- Kamel bind produces incomplete yaml files with -o yaml [\#2565](https://github.com/apache/camel-k/issues/2565)
- controller: panic on nil annotation [\#2556](https://github.com/apache/camel-k/issues/2556)
- Remove "attributeRestrictions" from operator-role.yaml [\#2549](https://github.com/apache/camel-k/issues/2549)
- trait logging.json: "false" does not have effect if the integration includes quarkus-logging-json [\#2539](https://github.com/apache/camel-k/issues/2539)
- CLI parameter does not overwrite application.properties [\#2538](https://github.com/apache/camel-k/issues/2538)
- Component: AtlasMap - NullPointerException [\#2534](https://github.com/apache/camel-k/issues/2534)
- Error in OpenShift image-pull delegation on IBM Cloud [\#2530](https://github.com/apache/camel-k/issues/2530)
- Runtime issue: cannot use KameletBinding error handler [\#2525](https://github.com/apache/camel-k/issues/2525)
- KameletBinding error handler nil map [\#2524](https://github.com/apache/camel-k/issues/2524)
- camel-k-client tar.gz changes the uid/gid of cwd [\#2514](https://github.com/apache/camel-k/issues/2514)
- Liveness and Readiness Probes not Supported When Using HTTPS [\#2513](https://github.com/apache/camel-k/issues/2513)
- container trait : add a flag to configure the image pull policy [\#2503](https://github.com/apache/camel-k/issues/2503)
- \[Doc\] Feedback channels missing in contributing page [\#2502](https://github.com/apache/camel-k/issues/2502)
- \[Doc\] Trait annotations [\#2500](https://github.com/apache/camel-k/issues/2500)
- \[CMD\] `kamel bind --error-handler` feature [\#2494](https://github.com/apache/camel-k/issues/2494)
- \[CMD\] `kamel bind` empty error handler [\#2493](https://github.com/apache/camel-k/issues/2493)
- kamel reset should not fail for integration missing due to owning kameletbinding removed [\#2487](https://github.com/apache/camel-k/issues/2487)
- kamelet binding: make it scalable ? [\#2486](https://github.com/apache/camel-k/issues/2486)
- kamel 1.4.1 build failure [\#2484](https://github.com/apache/camel-k/issues/2484)
- ServiceBinding CR sometimes doesn't get created [\#2482](https://github.com/apache/camel-k/issues/2482)
- V1.5.0 release without assets [\#2481](https://github.com/apache/camel-k/issues/2481)
- Kamel uninstall should delete kamelets [\#2479](https://github.com/apache/camel-k/issues/2479)
- Release 1.4.1 [\#2471](https://github.com/apache/camel-k/issues/2471)
- Release 1.5.0 [\#2470](https://github.com/apache/camel-k/issues/2470)
- Duplicated trait set as modeline and kamel run parameters causes error [\#2466](https://github.com/apache/camel-k/issues/2466)
- Update Camel K Serverless api examples to not use --property-file [\#2463](https://github.com/apache/camel-k/issues/2463)
- Kamelets: configuration does not seem to cascade to the integration [\#2396](https://github.com/apache/camel-k/issues/2396)
- kamel CLI binary for apple silicon / arm [\#2022](https://github.com/apache/camel-k/issues/2022)

## [pkg/client/camel/v1.5.0](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.5.0) (2021-07-05)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.5.0...pkg/client/camel/v1.5.0)

## [pkg/apis/camel/v1.5.0](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.5.0) (2021-07-05)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.5.0...pkg/apis/camel/v1.5.0)

## [pkg/kamelet/repository/v1.5.0](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.5.0) (2021-07-05)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.5.0...pkg/kamelet/repository/v1.5.0)

## [v1.5.0](https://github.com/apache/camel-k/tree/v1.5.0) (2021-07-05)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.4.1...v1.5.0)

**Closed issues:**

- \[cmd\] kamel run github|http|... fails on windows machine [\#2475](https://github.com/apache/camel-k/issues/2475)
- Oddity in channel name [\#2468](https://github.com/apache/camel-k/issues/2468)
- No endpoint found for Smooks after explicitly adding dependency with kamel [\#2437](https://github.com/apache/camel-k/issues/2437)

## [pkg/client/camel/v1.4.1](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.4.1) (2021-06-30)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.4.1...pkg/client/camel/v1.4.1)

## [pkg/apis/camel/v1.4.1](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.4.1) (2021-06-30)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.4.1...pkg/apis/camel/v1.4.1)

## [pkg/kamelet/repository/v1.4.1](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.4.1) (2021-06-30)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.4.1...pkg/kamelet/repository/v1.4.1)

## [v1.4.1](https://github.com/apache/camel-k/tree/v1.4.1) (2021-06-30)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.4.0...v1.4.1)

**Closed issues:**

- Parameters in YAML DSL are not recognized [\#2441](https://github.com/apache/camel-k/issues/2441)
- Versioned documentation [\#2435](https://github.com/apache/camel-k/issues/2435)
- Publish camel-k 1.4 documentation to website [\#2432](https://github.com/apache/camel-k/issues/2432)
- Drop support for minishift? [\#2428](https://github.com/apache/camel-k/issues/2428)
- \(cmd/run\) Support quotes in resource/config file option [\#2417](https://github.com/apache/camel-k/issues/2417)
- trait\(jvm\): option to add additional classpath elements [\#2414](https://github.com/apache/camel-k/issues/2414)
- 02-serverless-api example fails in the camel-k-examples repo [\#2400](https://github.com/apache/camel-k/issues/2400)
- ImagePullSecrets are not configured when the Integration is running [\#2394](https://github.com/apache/camel-k/issues/2394)
- Add option to use Nexus repository mirror to speed up e2e testing [\#2387](https://github.com/apache/camel-k/issues/2387)
- Cannot use camel-util dependency [\#2384](https://github.com/apache/camel-k/issues/2384)
- Scaling documentation - Add section about knative [\#2380](https://github.com/apache/camel-k/issues/2380)
- Cannot update integration using kamel run [\#2379](https://github.com/apache/camel-k/issues/2379)
- Can't set multiline properties in Kamelet bindings [\#2361](https://github.com/apache/camel-k/issues/2361)
- Maven logs are no longer shown [\#2357](https://github.com/apache/camel-k/issues/2357)
- examples/RestDSL.java does not work [\#2349](https://github.com/apache/camel-k/issues/2349)
- Documentation points to old repo with quickstarts [\#2347](https://github.com/apache/camel-k/issues/2347)
- Camel K seems to fail with Knative 0.23 [\#2343](https://github.com/apache/camel-k/issues/2343)
- kamelets: add condition to report when an integration is stuck waiting for them  [\#2331](https://github.com/apache/camel-k/issues/2331)
- Property in cron trait to set `startingDeadlineSeconds` [\#2330](https://github.com/apache/camel-k/issues/2330)
- maven-repository flag is not honored in the run command  [\#2327](https://github.com/apache/camel-k/issues/2327)
- Timeout when debugging the operator locally [\#2315](https://github.com/apache/camel-k/issues/2315)
- Creating an IntegrationPlatform with the route Trait Crashes the Operator [\#2313](https://github.com/apache/camel-k/issues/2313)
- Kamel Kamelets subcommand [\#2312](https://github.com/apache/camel-k/issues/2312)
- Integration container build errors are absent from the log messages [\#2306](https://github.com/apache/camel-k/issues/2306)
- Kamel delete should consider KameletBindings [\#2305](https://github.com/apache/camel-k/issues/2305)
- Log parsing errors [\#2299](https://github.com/apache/camel-k/issues/2299)
- Rebase architecture diagram on 1.4 release  [\#2297](https://github.com/apache/camel-k/issues/2297)
- Integration not marked as Failed when Camel is unable to start [\#2291](https://github.com/apache/camel-k/issues/2291)
- Structured logs: remaining bits [\#2286](https://github.com/apache/camel-k/issues/2286)
- \[Docs\] Broken links on autogenerated API [\#2280](https://github.com/apache/camel-k/issues/2280)
- Normalize Spectrum build logs [\#2276](https://github.com/apache/camel-k/issues/2276)
- kamelets: support for kamelet local beans [\#2271](https://github.com/apache/camel-k/issues/2271)
- Normalize Maven build log [\#2268](https://github.com/apache/camel-k/issues/2268)
- kamelet-binding: improve conditions [\#2265](https://github.com/apache/camel-k/issues/2265)
- Consolidate make targets used in Github actions [\#2263](https://github.com/apache/camel-k/issues/2263)
- Flaky scale integration test or scale intermittent issue [\#2250](https://github.com/apache/camel-k/issues/2250)
- Camel K and Amazon EKS \(Elastic Kubernetes Service\) [\#2241](https://github.com/apache/camel-k/issues/2241)
- `kamel` run fails for remote files on windows [\#2239](https://github.com/apache/camel-k/issues/2239)
- Add a flag to enable/disable the installation of default kamelets [\#2237](https://github.com/apache/camel-k/issues/2237)
- Create E2E test for Service Binding Operator [\#2236](https://github.com/apache/camel-k/issues/2236)
- Update run-from-github page to correct github example path [\#2230](https://github.com/apache/camel-k/issues/2230)
- SourceSpec Type default to empty [\#2223](https://github.com/apache/camel-k/issues/2223)
- Allow to configure traits using annotations [\#2165](https://github.com/apache/camel-k/issues/2165)
- Release 1.4.0 [\#2134](https://github.com/apache/camel-k/issues/2134)
- Maven build extensions [\#2132](https://github.com/apache/camel-k/issues/2132)
- Dependency autoloading is not working correctly with YAML format [\#2098](https://github.com/apache/camel-k/issues/2098)
- PodSpecable Integration [\#2096](https://github.com/apache/camel-k/issues/2096)
- api: provide java bindings [\#2082](https://github.com/apache/camel-k/issues/2082)
- Kamelet file parameters [\#2080](https://github.com/apache/camel-k/issues/2080)
- Can't mount secrets with binary data [\#2009](https://github.com/apache/camel-k/issues/2009)
- Revisit configuration options [\#2003](https://github.com/apache/camel-k/issues/2003)
- Logging configuration does not affect integrations [\#2000](https://github.com/apache/camel-k/issues/2000)
- kamelet-binding : suport for error handling [\#1941](https://github.com/apache/camel-k/issues/1941)
- Document secrets for using secrets \(and config maps\) [\#1838](https://github.com/apache/camel-k/issues/1838)
- Add a new configuration type to set build time properties [\#1831](https://github.com/apache/camel-k/issues/1831)
- builder: use structured logging for maven output [\#1783](https://github.com/apache/camel-k/issues/1783)
- Add support for podtemplatespec / container in the Integration CRD [\#1657](https://github.com/apache/camel-k/issues/1657)
- Support custom application.properties for Quarkus builds [\#1534](https://github.com/apache/camel-k/issues/1534)
- Support adding quarkus.index-dependency entries to scan CDI beans [\#1533](https://github.com/apache/camel-k/issues/1533)
- Fix github landing page [\#1502](https://github.com/apache/camel-k/issues/1502)
- Installation on a kind cluster [\#1468](https://github.com/apache/camel-k/issues/1468)
- Generate CRD documentation for website [\#1137](https://github.com/apache/camel-k/issues/1137)
- Integration logging configuration [\#580](https://github.com/apache/camel-k/issues/580)
- kamel run - compile errors should be more visible [\#185](https://github.com/apache/camel-k/issues/185)

## [pkg/kamelet/repository/v1.4.0](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.4.0) (2021-04-16)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.4.0...pkg/kamelet/repository/v1.4.0)

## [pkg/client/camel/v1.4.0](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.4.0) (2021-04-16)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.4.0...pkg/client/camel/v1.4.0)

## [pkg/apis/camel/v1.4.0](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.4.0) (2021-04-16)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.4.0...pkg/apis/camel/v1.4.0)

## [v1.4.0](https://github.com/apache/camel-k/tree/v1.4.0) (2021-04-16)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.3.2...v1.4.0)

**Closed issues:**

- Scaling integrations removes Kamelet ConfigMaps [\#2218](https://github.com/apache/camel-k/issues/2218)
- Missing camel-k-kamelet-reify version while building kamelet binding [\#2214](https://github.com/apache/camel-k/issues/2214)
- Duplicated ports are declared between the container and prometheus traits [\#2212](https://github.com/apache/camel-k/issues/2212)
- The `fromF` DSL should be parsed during HTTP endpoint discovery [\#2210](https://github.com/apache/camel-k/issues/2210)
- Kamelet yaml will be stored with wrong order of fields [\#2203](https://github.com/apache/camel-k/issues/2203)
- Multiple ReplicaSet Race Condition [\#2188](https://github.com/apache/camel-k/issues/2188)
- \[regression\] 1.3.2 regresses on "SinkBinding on KSVC results into ping-pong between operators \#1936" [\#2184](https://github.com/apache/camel-k/issues/2184)
- Resource selector [\#2178](https://github.com/apache/camel-k/issues/2178)
- Support additonal Maven repositories for `kamel local build` [\#2175](https://github.com/apache/camel-k/issues/2175)
- Default liveness probe initial delay is too short [\#2173](https://github.com/apache/camel-k/issues/2173)
- Normalize camel and camel-quarkus dependencies [\#2170](https://github.com/apache/camel-k/issues/2170)
- Uninstall is leaving items behind [\#2168](https://github.com/apache/camel-k/issues/2168)
- Review generated CSV [\#2164](https://github.com/apache/camel-k/issues/2164)
- Integrations are re-built on operator upgrade [\#2162](https://github.com/apache/camel-k/issues/2162)
- Deployment on K3s failing with Kaniko and Buildah build strategy [\#2161](https://github.com/apache/camel-k/issues/2161)
- Deployment on K3s failing with Spectrum build strategy [\#2160](https://github.com/apache/camel-k/issues/2160)
- Normalize object references [\#2158](https://github.com/apache/camel-k/issues/2158)
- Ability to provide Maven repository CA certificates [\#2149](https://github.com/apache/camel-k/issues/2149)
- kamelet-binding: embedding camelets [\#2146](https://github.com/apache/camel-k/issues/2146)
- Release 1.3.2 [\#2144](https://github.com/apache/camel-k/issues/2144)
- cli: add a binding sub command [\#2083](https://github.com/apache/camel-k/issues/2083)
- SinkBinding produces errored pods on 0.18+ / OpenShift Serverless 1.12 [\#1945](https://github.com/apache/camel-k/issues/1945)
- Improve description of "dependency" run and modeline option to include case of Camel components artifactId [\#1584](https://github.com/apache/camel-k/issues/1584)
- Migrate from ServiceMonitor to PodMonitor in Prometheus trait [\#1555](https://github.com/apache/camel-k/issues/1555)
- Adding camel-jackson dependency creates issues with inner classes  [\#1507](https://github.com/apache/camel-k/issues/1507)
- Adding a dump command [\#1415](https://github.com/apache/camel-k/issues/1415)

## [pkg/apis/camel/v1.3.2](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.3.2) (2021-03-19)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.3.2...pkg/apis/camel/v1.3.2)

## [v1.3.2](https://github.com/apache/camel-k/tree/v1.3.2) (2021-03-19)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.3.2...v1.3.2)

## [pkg/kamelet/repository/v1.3.2](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.3.2) (2021-03-19)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.3.2...pkg/kamelet/repository/v1.3.2)

## [pkg/client/camel/v1.3.2](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.3.2) (2021-03-19)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.3.1...pkg/client/camel/v1.3.2)

**Closed issues:**

- CGO and linking woes when building with newer Fedora versions [\#2140](https://github.com/apache/camel-k/issues/2140)
- Buildah build strategy is not working with insecure registries [\#2137](https://github.com/apache/camel-k/issues/2137)
- Push to insecure registry fails when using Kaniko build strategy [\#2127](https://github.com/apache/camel-k/issues/2127)
- Allow pulling base images from insecure registries [\#2122](https://github.com/apache/camel-k/issues/2122)
- Consuming from more than 1 knative channel is broken [\#2109](https://github.com/apache/camel-k/issues/2109)
- OLM installation fallback to normal installation without warning [\#2105](https://github.com/apache/camel-k/issues/2105)
- Error when using an external kit [\#2090](https://github.com/apache/camel-k/issues/2090)
- Add support for `@mirrorOf=xxx` for --maven-repository option [\#2088](https://github.com/apache/camel-k/issues/2088)
- Upgrade to Service Binding operator to v0.5.0 [\#2077](https://github.com/apache/camel-k/issues/2077)
- bou.ke/monkey license [\#2067](https://github.com/apache/camel-k/issues/2067)
- \[cmd\] Warning on launching operator [\#2051](https://github.com/apache/camel-k/issues/2051)
- \[Trait\] Extend affinity trait to CronJobs and KnativeServices [\#2047](https://github.com/apache/camel-k/issues/2047)
- kamelet-binding: support for processing steps [\#2043](https://github.com/apache/camel-k/issues/2043)
- Local build implementation [\#2038](https://github.com/apache/camel-k/issues/2038)
- Illegal YAML may result in operator panic [\#2035](https://github.com/apache/camel-k/issues/2035)
- spectrum publish x509: certificate signed by unknown authority [\#2029](https://github.com/apache/camel-k/issues/2029)
- ServiceBinding kind not installed  [\#2018](https://github.com/apache/camel-k/issues/2018)
- Mount resource ConfigMaps as subPaths instead of volumes [\#1998](https://github.com/apache/camel-k/issues/1998)
- Can't directly access Strimzi Topics in KameletBindings [\#1992](https://github.com/apache/camel-k/issues/1992)
- Cannot use special characters in KameletBindings [\#1986](https://github.com/apache/camel-k/issues/1986)
- Options to share state between routes [\#1984](https://github.com/apache/camel-k/issues/1984)
- Allow to scaffold a Kamelet via kamel init [\#1983](https://github.com/apache/camel-k/issues/1983)
- Make changelog action work again [\#1981](https://github.com/apache/camel-k/issues/1981)
- Add a Backport Github action  [\#1969](https://github.com/apache/camel-k/issues/1969)
- Release 1.3.1 [\#1966](https://github.com/apache/camel-k/issues/1966)
- Group all traits test under one e2e directory [\#1955](https://github.com/apache/camel-k/issues/1955)
- Usage of binary data in ConfigMaps [\#1946](https://github.com/apache/camel-k/issues/1946)
- \[ppc64le\] bundle image generated using `bundle` and `bundle-build` targets incompatible with `opm` [\#1923](https://github.com/apache/camel-k/issues/1923)
- kamel inspect is not providing dependencies specified in modeline [\#1921](https://github.com/apache/camel-k/issues/1921)
- Installing Camel-K operator on Docker for Desktop with Kubernetes cluster enabled [\#1902](https://github.com/apache/camel-k/issues/1902)
- Removed changelog gh action [\#1890](https://github.com/apache/camel-k/issues/1890)
- Corrupted binaries attached as resource [\#1881](https://github.com/apache/camel-k/issues/1881)
- Release 1.3.0 [\#1867](https://github.com/apache/camel-k/issues/1867)
- Make Knative endpoints and kameletbinding work with broker without explicit event type [\#1840](https://github.com/apache/camel-k/issues/1840)
- Refactor artifacts of deploy directory and continue alignment towards operator-sdk & kustomize [\#1820](https://github.com/apache/camel-k/issues/1820)
- Implementing a global build strategy [\#1799](https://github.com/apache/camel-k/issues/1799)
- Add a cli subcommand to inspect dependencies required by an Integration [\#1738](https://github.com/apache/camel-k/issues/1738)
- Camel K installed globally by default [\#1693](https://github.com/apache/camel-k/issues/1693)
- Example Integration in the ClusterServiceVersion stuck in Deploying phase [\#1677](https://github.com/apache/camel-k/issues/1677)
- document how to create knative camel sources using Java [\#1674](https://github.com/apache/camel-k/issues/1674)
- Builder not getting configured with private docker repo [\#1568](https://github.com/apache/camel-k/issues/1568)
- Take a look at service binding [\#1445](https://github.com/apache/camel-k/issues/1445)
- Reference to IntegrationKit metdata in Builder CR [\#1299](https://github.com/apache/camel-k/issues/1299)
- Build controller service / operator [\#681](https://github.com/apache/camel-k/issues/681)
- Add support for template endpoint [\#249](https://github.com/apache/camel-k/issues/249)

## [pkg/apis/camel/v1.3.1](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.3.1) (2021-02-01)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.3.1...pkg/apis/camel/v1.3.1)

## [pkg/kamelet/repository/v1.3.1](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.3.1) (2021-02-01)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.3.1...pkg/kamelet/repository/v1.3.1)

## [v1.3.1](https://github.com/apache/camel-k/tree/v1.3.1) (2021-02-01)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.3.1...v1.3.1)

## [pkg/client/camel/v1.3.1](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.3.1) (2021-02-01)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.3.0...pkg/client/camel/v1.3.1)

**Closed issues:**

- A simple XML-DSL based integration with Spring doesn't work [\#1963](https://github.com/apache/camel-k/issues/1963)
- Ability to have sources for integrations as ConfigMaps [\#1951](https://github.com/apache/camel-k/issues/1951)
- Flaky e2e test \(cron-fallback\) [\#1939](https://github.com/apache/camel-k/issues/1939)
- SinkBinding on KSVC results into ping-pong between operators [\#1936](https://github.com/apache/camel-k/issues/1936)
- Adding component dependency doesn't seem to work [\#1935](https://github.com/apache/camel-k/issues/1935)
- Warnings on getting operator versions [\#1930](https://github.com/apache/camel-k/issues/1930)
- Provide a way to use kamelet ID in binding [\#1928](https://github.com/apache/camel-k/issues/1928)
- \[CLI\] Kamel run does not check source file exists [\#1911](https://github.com/apache/camel-k/issues/1911)
- \[CLI\] Kamel run does not check source file exists [\#1910](https://github.com/apache/camel-k/issues/1910)
- CLI command kamel help fail if not connected to any cluster [\#1906](https://github.com/apache/camel-k/issues/1906)
- Integration Monitoring, documentation issue [\#1904](https://github.com/apache/camel-k/issues/1904)
- Default catalog is ignored and the operator creates a duplicate [\#1897](https://github.com/apache/camel-k/issues/1897)
- Implement operator command's flags test [\#1892](https://github.com/apache/camel-k/issues/1892)
- kamel install camel-version flag not used [\#1884](https://github.com/apache/camel-k/issues/1884)
- Can't use Kamelets from Integration yaml resources [\#1882](https://github.com/apache/camel-k/issues/1882)
- Local run fails when quarkus runtime dependency is passed on the command line [\#1877](https://github.com/apache/camel-k/issues/1877)
- \[regression\] panic: runtime error: invalid memory address or nil pointer dereference with version 1.3.0 when calling without or with - or -- arguments [\#1872](https://github.com/apache/camel-k/issues/1872)
- Cannot load Knative configuration from file or env variable [\#1871](https://github.com/apache/camel-k/issues/1871)
- camel.component.\* properties not being respected under Quarkus runtime [\#1870](https://github.com/apache/camel-k/issues/1870)
- Generate OLM Bundle [\#1743](https://github.com/apache/camel-k/issues/1743)
- Adding a way to override the default base image at runtime [\#1707](https://github.com/apache/camel-k/issues/1707)
- camel-K installation failed with Helm on GKE [\#1664](https://github.com/apache/camel-k/issues/1664)
- Add a warning when operating from a CLI with a different installed Operator version [\#1652](https://github.com/apache/camel-k/issues/1652)
- Increase trait test coverage [\#1547](https://github.com/apache/camel-k/issues/1547)
- Upgrade CRDs to apiextensions.k8s.io/v1 [\#1487](https://github.com/apache/camel-k/issues/1487)
- Implement kit\_create command's flags test [\#1159](https://github.com/apache/camel-k/issues/1159)
- Implement install command's flags test [\#1158](https://github.com/apache/camel-k/issues/1158)
- Implement delete command's flags test [\#1157](https://github.com/apache/camel-k/issues/1157)
- Implement builder command's flags test [\#1156](https://github.com/apache/camel-k/issues/1156)
- kamel --output option should not need deploy resources to cluster [\#886](https://github.com/apache/camel-k/issues/886)

## [pkg/client/camel/v1.3.0](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.3.0) (2020-12-22)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/kamelet/repository/v1.3.0...pkg/client/camel/v1.3.0)

## [pkg/kamelet/repository/v1.3.0](https://github.com/apache/camel-k/tree/pkg/kamelet/repository/v1.3.0) (2020-12-22)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.3.0...pkg/kamelet/repository/v1.3.0)

## [pkg/apis/camel/v1.3.0](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.3.0) (2020-12-22)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.3.0...pkg/apis/camel/v1.3.0)

## [v1.3.0](https://github.com/apache/camel-k/tree/v1.3.0) (2020-12-22)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.2.1...v1.3.0)

**Closed issues:**

- Should 'kamel uninstall --all' also delete camel-k-registry-secret? [\#1859](https://github.com/apache/camel-k/issues/1859)
- Integration with Prometheus trait doesn't deploy on Minikube [\#1848](https://github.com/apache/camel-k/issues/1848)
- Groovy example is broken [\#1842](https://github.com/apache/camel-k/issues/1842)
- Unable to use Kamelet spec in a custom CRD [\#1837](https://github.com/apache/camel-k/issues/1837)
- Multiple knative revisions created when integration has multiple spec.configuration items [\#1824](https://github.com/apache/camel-k/issues/1824)
- Release 1.2.1 [\#1823](https://github.com/apache/camel-k/issues/1823)
- Support for kamelet repository [\#1818](https://github.com/apache/camel-k/issues/1818)
- Telegram Kamlet sets CloudEvent source attribute to Knative sink [\#1813](https://github.com/apache/camel-k/issues/1813)
- Move released images to a hub without rate limits [\#1761](https://github.com/apache/camel-k/issues/1761)
- Define default global Kamelets [\#1675](https://github.com/apache/camel-k/issues/1675)
- Enable SinkBinding automatically [\#1654](https://github.com/apache/camel-k/issues/1654)
- Document the --config option in the kamel CLI [\#1185](https://github.com/apache/camel-k/issues/1185)
- Basic module structure for Camel K projects [\#1135](https://github.com/apache/camel-k/issues/1135)

## [pkg/apis/camel/v1.2.1](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.2.1) (2020-11-23)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.2.1...pkg/apis/camel/v1.2.1)

## [pkg/client/camel/v1.2.1](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.2.1) (2020-11-23)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.2.1...pkg/client/camel/v1.2.1)

## [v1.2.1](https://github.com/apache/camel-k/tree/v1.2.1) (2020-11-23)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.2.0...v1.2.1)

**Closed issues:**

- How to specify resource for integration components [\#1814](https://github.com/apache/camel-k/issues/1814)
- scaling out camel-k integrations are not working correctly [\#1806](https://github.com/apache/camel-k/issues/1806)
- Remove main runtime from operator codebase [\#1803](https://github.com/apache/camel-k/issues/1803)
- Scalability of integration components in a non knative environment [\#1798](https://github.com/apache/camel-k/issues/1798)
- Panic when attempting to convert from unstructured to Integration with traits [\#1794](https://github.com/apache/camel-k/issues/1794)
- Kamelets resource autogenerated informers and listers [\#1791](https://github.com/apache/camel-k/issues/1791)
-  Changes to KameletBinding must be propagated to Integrations [\#1785](https://github.com/apache/camel-k/issues/1785)
- KameletBinding to broker fails [\#1778](https://github.com/apache/camel-k/issues/1778)
- Kamelet binding to an explicit URI failing [\#1774](https://github.com/apache/camel-k/issues/1774)
- Use registry secrets for both pulling and pushing [\#1771](https://github.com/apache/camel-k/issues/1771)
- When building quarkus, properties should be part of the generate application.properties used to build the project [\#1763](https://github.com/apache/camel-k/issues/1763)
- Ability to configure PodDisruptionBudget for integrations [\#1760](https://github.com/apache/camel-k/issues/1760)
- Release 1.2.0 [\#1754](https://github.com/apache/camel-k/issues/1754)
- Add suport for gists [\#1740](https://github.com/apache/camel-k/issues/1740)
- Update to k8s 0.18.8 [\#1698](https://github.com/apache/camel-k/issues/1698)
- Error during unshare\(...\): Operation not permitted [\#1580](https://github.com/apache/camel-k/issues/1580)
- Remove support for Main runtime for integrations [\#1562](https://github.com/apache/camel-k/issues/1562)
- Auto-detect json in yaml syntax [\#1549](https://github.com/apache/camel-k/issues/1549)
- Provide yaml schema of design definition [\#1537](https://github.com/apache/camel-k/issues/1537)
- Expose operator related metrics [\#1267](https://github.com/apache/camel-k/issues/1267)
- helm.sh entries in go.sum [\#1231](https://github.com/apache/camel-k/issues/1231)
- Add camel-k-quarkus example [\#1082](https://github.com/apache/camel-k/issues/1082)
- Make sure global and local operators can cohexist [\#751](https://github.com/apache/camel-k/issues/751)
- Document architecture [\#36](https://github.com/apache/camel-k/issues/36)

## [v1.2.0](https://github.com/apache/camel-k/tree/v1.2.0) (2020-10-08)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.2.0...v1.2.0)

## [pkg/apis/camel/v1.2.0](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.2.0) (2020-10-08)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.2.0...pkg/apis/camel/v1.2.0)

## [pkg/client/camel/v1.2.0](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.2.0) (2020-10-08)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.1.1...pkg/client/camel/v1.2.0)

**Closed issues:**

- Binary resources such as keystores are being corrupted [\#1750](https://github.com/apache/camel-k/issues/1750)
- Propagate Kamelet icon on binding [\#1747](https://github.com/apache/camel-k/issues/1747)
- Thread blocked calling knative REST [\#1720](https://github.com/apache/camel-k/issues/1720)
- Automatic changelog update should not be run on forks [\#1717](https://github.com/apache/camel-k/issues/1717)
- Environment Variables from Secrets [\#1715](https://github.com/apache/camel-k/issues/1715)
- Salesforce Integration as Knative Serverless Service fails [\#1713](https://github.com/apache/camel-k/issues/1713)
- Generate CRD schema for Kamelet + KameletBinding [\#1710](https://github.com/apache/camel-k/issues/1710)
- Add Kamelet integration tests [\#1709](https://github.com/apache/camel-k/issues/1709)
- Does camel-k plan to provide Java SDK client Calls? [\#1708](https://github.com/apache/camel-k/issues/1708)
- Release 1.1.1 [\#1700](https://github.com/apache/camel-k/issues/1700)
- Upgrade to Prometheus operator version 0.42.0+ [\#1697](https://github.com/apache/camel-k/issues/1697)
- Kamel init - Do not include license header [\#1696](https://github.com/apache/camel-k/issues/1696)
- Add support for Strimzi Topics in KameletBinding [\#1686](https://github.com/apache/camel-k/issues/1686)
- kamelets: source/sink binding [\#1676](https://github.com/apache/camel-k/issues/1676)
- Add related image in OLM descriptor [\#1611](https://github.com/apache/camel-k/issues/1611)
- Deprecate build kit at platform set-up time [\#1604](https://github.com/apache/camel-k/issues/1604)
- kamelets: runtime support [\#1575](https://github.com/apache/camel-k/issues/1575)
- kamelets: operator support [\#1574](https://github.com/apache/camel-k/issues/1574)
- Support for Kamelets [\#1567](https://github.com/apache/camel-k/issues/1567)
- Add a kamel help cli command [\#1545](https://github.com/apache/camel-k/issues/1545)
- Switch to Quarkus as default runtime for integrations [\#1513](https://github.com/apache/camel-k/issues/1513)

## [pkg/client/camel/v1.1.1](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.1.1) (2020-09-11)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.1.1...pkg/client/camel/v1.1.1)

## [pkg/apis/camel/v1.1.1](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.1.1) (2020-09-11)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.1.1...pkg/apis/camel/v1.1.1)

## [v1.1.1](https://github.com/apache/camel-k/tree/v1.1.1) (2020-09-11)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.1.0...v1.1.1)

**Closed issues:**

- Failed to install Camel-K in IKS [\#1687](https://github.com/apache/camel-k/issues/1687)
- Upgrade base to Knative 0.16 and support 0.17 [\#1670](https://github.com/apache/camel-k/issues/1670)
- Integration is logged twice in dev mode [\#1668](https://github.com/apache/camel-k/issues/1668)
- operator.adoc - ascii doc warning [\#1662](https://github.com/apache/camel-k/issues/1662)
- Caffeine with Knative doesn't work [\#1649](https://github.com/apache/camel-k/issues/1649)
- Build error when using traits [\#1648](https://github.com/apache/camel-k/issues/1648)
- Add oidc provider to Camel-K [\#1646](https://github.com/apache/camel-k/issues/1646)
- When creating a new tag, make sure it's strictly numeric \(i.e. 1.1.0 instead of v1.1.0\) [\#1645](https://github.com/apache/camel-k/issues/1645)
- kamel init - should not create source file with ASF license header [\#1638](https://github.com/apache/camel-k/issues/1638)
- No matches for kind "Subscription" in version "messaging.knative.dev/v1alpha1" [\#1636](https://github.com/apache/camel-k/issues/1636)
- Add command completion for kamel [\#1635](https://github.com/apache/camel-k/issues/1635)
- Release Camel K 1.1.0 [\#1618](https://github.com/apache/camel-k/issues/1618)
- kamel install not working on vanilla k8 cluster  [\#1552](https://github.com/apache/camel-k/issues/1552)
- Use sinkbinding in operator [\#1548](https://github.com/apache/camel-k/issues/1548)
- Publish yaml schema of design definition on https://www.schemastore.org/json/ [\#1538](https://github.com/apache/camel-k/issues/1538)
- In dev mode, changes to modeline are not taken into account [\#1536](https://github.com/apache/camel-k/issues/1536)
- PublishStrategy missing from IntegrationPlatform build spec [\#1370](https://github.com/apache/camel-k/issues/1370)
- kamel install not working - Error: cannot find automatically a registry where to push images [\#674](https://github.com/apache/camel-k/issues/674)

## [pkg/client/camel/v1.1.0](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.1.0) (2020-07-21)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.1.0...pkg/client/camel/v1.1.0)

## [v1.1.0](https://github.com/apache/camel-k/tree/v1.1.0) (2020-07-21)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.1.0...v1.1.0)

## [pkg/apis/camel/v1.1.0](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.1.0) (2020-07-21)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.1...pkg/apis/camel/v1.1.0)

**Closed issues:**

- Set knative.reply = false in knative environment metadata [\#1617](https://github.com/apache/camel-k/issues/1617)
- Camel-K-Examples: The Kinesis examples fails because of signature [\#1608](https://github.com/apache/camel-k/issues/1608)
- Camel-K-example: The Kinesis source example fails because region is missing [\#1607](https://github.com/apache/camel-k/issues/1607)
- Add 'v' prefix to tag names [\#1601](https://github.com/apache/camel-k/issues/1601)
- Fix generation of traits.yaml file [\#1599](https://github.com/apache/camel-k/issues/1599)
- Create a troubleshooting documentation [\#1595](https://github.com/apache/camel-k/issues/1595)
- The options parameter from the jvm trait should support value containing commas [\#1593](https://github.com/apache/camel-k/issues/1593)
- Restore flow type as object? [\#1590](https://github.com/apache/camel-k/issues/1590)
- Bad help description for kamel init [\#1585](https://github.com/apache/camel-k/issues/1585)
- dependencies trait - Camel shorthand camel:dns vs camel-dns [\#1583](https://github.com/apache/camel-k/issues/1583)
- Camel to Yaml transformation [\#1581](https://github.com/apache/camel-k/issues/1581)
- Running YAML code [\#1579](https://github.com/apache/camel-k/issues/1579)
- Add the camel category to Camel K CRDs [\#1556](https://github.com/apache/camel-k/issues/1556)
- kamel run simple.js --dev hangs after multiple kill/start [\#1505](https://github.com/apache/camel-k/issues/1505)
- Support `make install-crc` [\#1410](https://github.com/apache/camel-k/issues/1410)
- Add a nodeport option to the service trait [\#1321](https://github.com/apache/camel-k/issues/1321)
- Misleading error message in knative trait: cannot find event default [\#1308](https://github.com/apache/camel-k/issues/1308)
- Error when trying create Integration [\#1280](https://github.com/apache/camel-k/issues/1280)
- Verify registry connection on install [\#1192](https://github.com/apache/camel-k/issues/1192)
- Kafka Producer [\#1189](https://github.com/apache/camel-k/issues/1189)
- Add a specific label to the integration pod [\#1129](https://github.com/apache/camel-k/issues/1129)
- Add documentation for integration platform configuration [\#951](https://github.com/apache/camel-k/issues/951)
- kamel --dev stuck when mvn dependencies has problem [\#911](https://github.com/apache/camel-k/issues/911)
- Update Camel-K/Knative examples for 1.0.0-M1 release [\#908](https://github.com/apache/camel-k/issues/908)
- IntegrationPlatform stucked in "status.phase: Starting" [\#466](https://github.com/apache/camel-k/issues/466)
- camel-k operator Error with minikube [\#431](https://github.com/apache/camel-k/issues/431)
- Structured trait configuration [\#395](https://github.com/apache/camel-k/issues/395)

## [1.0.1](https://github.com/apache/camel-k/tree/1.0.1) (2020-06-25)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.0...1.0.1)

**Closed issues:**

- Switch to Syndesis gh action for backporting [\#1559](https://github.com/apache/camel-k/issues/1559)
- Integration do not shutdown gracefully when `jvm.print-command` is set [\#1557](https://github.com/apache/camel-k/issues/1557)
- Adding dependencies on external packages [\#1546](https://github.com/apache/camel-k/issues/1546)
- application.properties missing when using latest kamel-1.0.0 release [\#1542](https://github.com/apache/camel-k/issues/1542)
- Package not found [\#1541](https://github.com/apache/camel-k/issues/1541)
- Can't connect to prometheus endpoint in 1.0.0 \(not running?\) [\#1525](https://github.com/apache/camel-k/issues/1525)
- Create a 1.0.x branch  [\#1519](https://github.com/apache/camel-k/issues/1519)
- Update the kamel homebrew formula to v1.0.0 [\#1512](https://github.com/apache/camel-k/issues/1512)
- \[regression\]kamel help trait --all -o json returns both yaml and json output [\#1511](https://github.com/apache/camel-k/issues/1511)
- addRoutes problem when running 01-Basic example from new camel-k-example docs [\#1509](https://github.com/apache/camel-k/issues/1509)
- CLI - Make kamel run handle github urls that are not raw [\#1497](https://github.com/apache/camel-k/issues/1497)
- metrics: in quarkus mode, use microprofile metrics in place of the prometheus agent [\#1263](https://github.com/apache/camel-k/issues/1263)
- Add time it takes to build a kit in the builder pod log [\#1186](https://github.com/apache/camel-k/issues/1186)
- Saga example [\#1097](https://github.com/apache/camel-k/issues/1097)
- java.lang.NoSuchMethodError: com.javainuse.route.SimpleRouteBuilder.getContext\(\)Lorg/apache/camel/model/ModelCamelContext; [\#1073](https://github.com/apache/camel-k/issues/1073)
- Error after cluster restart [\#933](https://github.com/apache/camel-k/issues/933)
- Error pushing image to camel-k-ctx [\#853](https://github.com/apache/camel-k/issues/853)
- service and route not created when using --open-api parameter [\#843](https://github.com/apache/camel-k/issues/843)
- one page of documentation to install Camel-K on Minikube is incorrect [\#798](https://github.com/apache/camel-k/issues/798)
- Kamel run Sample.java --dev hanged with "Waiting for Platform". Error - Non-resolvable import POM [\#677](https://github.com/apache/camel-k/issues/677)
- Sample does not work after change camel version [\#664](https://github.com/apache/camel-k/issues/664)
- Release 1.0.1 [\#1565](https://github.com/apache/camel-k/issues/1565)
- Cannot expose knative endpoints in YAML [\#1539](https://github.com/apache/camel-k/issues/1539)
- kamel install uses the wrong channel in OLM [\#1524](https://github.com/apache/camel-k/issues/1524)

## [1.0.0](https://github.com/apache/camel-k/tree/1.0.0) (2020-06-05)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.0-nightly.202005130003...1.0.0)

**Closed issues:**

- Print the JVM command with its parameters in integration pod logs [\#1495](https://github.com/apache/camel-k/issues/1495)
- Converting ProcessorDefinition to DSL and interfacing with camel k [\#1469](https://github.com/apache/camel-k/issues/1469)
- vanilla minikube - CronJobs are not being built from operator [\#1442](https://github.com/apache/camel-k/issues/1442)
- Move languages documentation to camel-k-runtime [\#1427](https://github.com/apache/camel-k/issues/1427)
- Kotlin documentation incorrect for kotlin DSL [\#1426](https://github.com/apache/camel-k/issues/1426)
- Switchting to quarkus fails to build because of missing versions [\#1423](https://github.com/apache/camel-k/issues/1423)
- support for jitpack dependencies [\#1407](https://github.com/apache/camel-k/issues/1407)
- Avoid requirements of a kubeconfig when using `kamel init xxx` command [\#1368](https://github.com/apache/camel-k/issues/1368)
- Support for local development using containers [\#1339](https://github.com/apache/camel-k/issues/1339)
- User cannot create resource in API group [\#1302](https://github.com/apache/camel-k/issues/1302)
- Support of 3rd party camel components, data formats and type converters [\#1285](https://github.com/apache/camel-k/issues/1285)
- Camel-k with Spring boot  [\#1176](https://github.com/apache/camel-k/issues/1176)
- routes-rest.js not working [\#1174](https://github.com/apache/camel-k/issues/1174)
- Unable to run Knative integration [\#1169](https://github.com/apache/camel-k/issues/1169)
- Basic javascript example generates "Multiple applicable overloads found for method name process" [\#1144](https://github.com/apache/camel-k/issues/1144)
- Basic groovy example generates "Ambiguous method overloading for method org.apache.camel.model.RouteDefinition\#process" [\#1143](https://github.com/apache/camel-k/issues/1143)
- Multiple traits to create a service [\#1061](https://github.com/apache/camel-k/issues/1061)
- Camel K Operator is not reading the Telegram endpoint API-Key properly. [\#1039](https://github.com/apache/camel-k/issues/1039)
- No interface for setting the number of pods on which an integration is to be deployed [\#1032](https://github.com/apache/camel-k/issues/1032)
- Is there a way to co-locate the camel-k-operator, builder and PV in the same node [\#924](https://github.com/apache/camel-k/issues/924)
- Camel-K build fails with error: open /workspace/builder-656588331/package/context/Dockerfile: no such file or directory [\#923](https://github.com/apache/camel-k/issues/923)
- Add support for defining the loader to be used by the runtime [\#910](https://github.com/apache/camel-k/issues/910)
- Support shebang to precise that a file is a Camel-K executable file [\#754](https://github.com/apache/camel-k/issues/754)
- Cannot reinstall the kamel in minikube [\#711](https://github.com/apache/camel-k/issues/711)
- \[DISCUSS\] Vision for Knative Sources [\#639](https://github.com/apache/camel-k/issues/639)
- Remove maven wrapper from camel-k [\#629](https://github.com/apache/camel-k/issues/629)
- Allow "kamel" to install a specific version of camel k [\#604](https://github.com/apache/camel-k/issues/604)
- Knative minikube service failure [\#482](https://github.com/apache/camel-k/issues/482)
- Add support for secure registries in Kubernetes mode [\#139](https://github.com/apache/camel-k/issues/139)
- Add health checks and additional monitoring [\#58](https://github.com/apache/camel-k/issues/58)
- Release Camel K 1.0.0 [\#1498](https://github.com/apache/camel-k/issues/1498)
- Add an opentracing trait [\#1489](https://github.com/apache/camel-k/issues/1489)
- Support inline YAML DSL  [\#1470](https://github.com/apache/camel-k/issues/1470)
- Kamel uninstall leftovers [\#1465](https://github.com/apache/camel-k/issues/1465)
- Refactor API module to include it in master [\#1463](https://github.com/apache/camel-k/issues/1463)
- sanitized integration name on Windows contains whole path [\#1462](https://github.com/apache/camel-k/issues/1462)
- Unable to start Prometheus when Knative enabled.  [\#1459](https://github.com/apache/camel-k/issues/1459)
- Customizing prometheus configuration fails with MountVolume issue [\#1451](https://github.com/apache/camel-k/issues/1451)
- servicemonitor is not created for missing role on camel-k-operator [\#1450](https://github.com/apache/camel-k/issues/1450)
- Support setting parameters as modeline options [\#1449](https://github.com/apache/camel-k/issues/1449)
- Issue when fixing erroneous resource [\#1446](https://github.com/apache/camel-k/issues/1446)
- Can't install camel-k helm chart in more than one namespace [\#1443](https://github.com/apache/camel-k/issues/1443)
- Vanilla Minishift install not working. [\#1429](https://github.com/apache/camel-k/issues/1429)
- Use /openapi.json as default location for OpenAPI data [\#1428](https://github.com/apache/camel-k/issues/1428)
- CamelSources not working in nightly [\#1419](https://github.com/apache/camel-k/issues/1419)
- Add license headers to files generated with kamel init [\#1417](https://github.com/apache/camel-k/issues/1417)
- Spectrum publisher still slow [\#1416](https://github.com/apache/camel-k/issues/1416)
- Support Knative channels v1beta1 versions [\#1414](https://github.com/apache/camel-k/issues/1414)
- Camel Cron trait page is rendered incorrectly [\#1401](https://github.com/apache/camel-k/issues/1401)
- Detect camel-microprofile-fault-tolerance for Circuit Breaker [\#1396](https://github.com/apache/camel-k/issues/1396)
- Events should be shown also when running the integration with --logs [\#1395](https://github.com/apache/camel-k/issues/1395)
- Cannot switch between cron and normal deployment in dev mode [\#1394](https://github.com/apache/camel-k/issues/1394)
- The camel-k:edit clusterrole is not always created [\#1393](https://github.com/apache/camel-k/issues/1393)
- Add some sugar for additional sources [\#1388](https://github.com/apache/camel-k/issues/1388)
- Quarkus runner jar is never rebuilt on layered kits [\#1387](https://github.com/apache/camel-k/issues/1387)
- Allow to define custom prometheus exporter [\#1384](https://github.com/apache/camel-k/issues/1384)
- Cannot manage prometheus resources [\#1382](https://github.com/apache/camel-k/issues/1382)
- OpenShift CLI download links are not populated when installing from operator hub [\#1379](https://github.com/apache/camel-k/issues/1379)
- Add more build events [\#1367](https://github.com/apache/camel-k/issues/1367)
- Knative API example becomes unstable [\#1364](https://github.com/apache/camel-k/issues/1364)
- Refactor CI tests to reduce feedback time [\#1362](https://github.com/apache/camel-k/issues/1362)
- Add a simple API tutorial for the getting started experience [\#1361](https://github.com/apache/camel-k/issues/1361)
- Upgrade Knative CI to 0.13.x [\#1359](https://github.com/apache/camel-k/issues/1359)
- Provide description in JSON output for traits [\#1358](https://github.com/apache/camel-k/issues/1358)
- Kamel uninstall does not remove everything in OLM mode [\#1356](https://github.com/apache/camel-k/issues/1356)
- Standard rest services can be bound to 8080 by default [\#1347](https://github.com/apache/camel-k/issues/1347)
- 'context' object not available in JavaScript integrations [\#1346](https://github.com/apache/camel-k/issues/1346)
- Probes not bound to Knative services [\#1341](https://github.com/apache/camel-k/issues/1341)
- ConfigMap xxx-openapi-000 not found [\#1340](https://github.com/apache/camel-k/issues/1340)
- Wrong knative dependency [\#1337](https://github.com/apache/camel-k/issues/1337)
- Adapt cron trait to latest camel-k-runtime [\#1329](https://github.com/apache/camel-k/issues/1329)
- Switch to java 11 by default ? [\#1327](https://github.com/apache/camel-k/issues/1327)
- Add a 3scale addon [\#1325](https://github.com/apache/camel-k/issues/1325)
- Add e2e test for the multiple files scenario [\#1320](https://github.com/apache/camel-k/issues/1320)
- Rename rest-dsl trait to openapi [\#1317](https://github.com/apache/camel-k/issues/1317)
- Add some sugar to rest APIs [\#1316](https://github.com/apache/camel-k/issues/1316)
- Errors in incremental build on OCP4 [\#1314](https://github.com/apache/camel-k/issues/1314)
- Support OpenAPI 3 [\#1310](https://github.com/apache/camel-k/issues/1310)
- Cannot patch event log errors [\#1309](https://github.com/apache/camel-k/issues/1309)
- Events are reported twice in dev mode [\#1297](https://github.com/apache/camel-k/issues/1297)
- Support Knative eventing v1beta1 APIs [\#1212](https://github.com/apache/camel-k/issues/1212)
- Add condition/status to monitor running state of the integration [\#1171](https://github.com/apache/camel-k/issues/1171)
- Document YAML DSL on the website [\#1114](https://github.com/apache/camel-k/issues/1114)
- Hide some CRDs from developer catalog [\#1045](https://github.com/apache/camel-k/issues/1045)
- GC trait fails on unknown types [\#1027](https://github.com/apache/camel-k/issues/1027)
- Kamel install -o yaml should not try to connect to a cluster [\#885](https://github.com/apache/camel-k/issues/885)
- Wrong links from second page on [\#827](https://github.com/apache/camel-k/issues/827)
- Update installation documentation [\#823](https://github.com/apache/camel-k/issues/823)
- Builds are 1200% slower on Openshift 4 [\#813](https://github.com/apache/camel-k/issues/813)
- CLI too slow on remote clusters [\#792](https://github.com/apache/camel-k/issues/792)
- Add .flow example to e2e tests [\#780](https://github.com/apache/camel-k/issues/780)
- Propagate build errors up to the integration [\#763](https://github.com/apache/camel-k/issues/763)
- Add timeout to maven operations [\#761](https://github.com/apache/camel-k/issues/761)
- Service trait: confusing behavior [\#753](https://github.com/apache/camel-k/issues/753)
- Include checksum when checking for compatible kits [\#743](https://github.com/apache/camel-k/issues/743)
- validate maven artifacts [\#742](https://github.com/apache/camel-k/issues/742)
- camel-k-cache crashes on minikube [\#736](https://github.com/apache/camel-k/issues/736)
- Move to knative serving v1beta1 apis [\#729](https://github.com/apache/camel-k/issues/729)
- Add the ASL license header on the source file [\#709](https://github.com/apache/camel-k/issues/709)
- Add e2e tests in CI [\#693](https://github.com/apache/camel-k/issues/693)
- Add version information to all resources [\#692](https://github.com/apache/camel-k/issues/692)
- Insufficient permission when installing 0.3.3 from operatorhub [\#686](https://github.com/apache/camel-k/issues/686)
- Remove predefined images [\#644](https://github.com/apache/camel-k/issues/644)
- Define a meta-controller for Camel-based Knative sources [\#641](https://github.com/apache/camel-k/issues/641)
- Add support for Knative Broker/Trigger [\#638](https://github.com/apache/camel-k/issues/638)
- Testing Camel K integrations [\#600](https://github.com/apache/camel-k/issues/600)
- Add conditions to camel-k CRs [\#594](https://github.com/apache/camel-k/issues/594)
- Generate Specific Knative Sources per Camel Component [\#569](https://github.com/apache/camel-k/issues/569)
- Automatic installation when creating a Knative Camel Source [\#568](https://github.com/apache/camel-k/issues/568)
- Support for multi-tenancy [\#523](https://github.com/apache/camel-k/issues/523)
- Enable the scale sub resource on integrations [\#353](https://github.com/apache/camel-k/issues/353)
- VSCode extension [\#338](https://github.com/apache/camel-k/issues/338)
- Improve IDE auto-completion [\#311](https://github.com/apache/camel-k/issues/311)
- Be revision-friendly and do not use revisions by default on Knative profile [\#289](https://github.com/apache/camel-k/issues/289)
- Rename 'context' term used by Camel K. [\#206](https://github.com/apache/camel-k/issues/206)
- Publish Helm charts [\#168](https://github.com/apache/camel-k/issues/168)

## [1.0.0-nightly.202005130003](https://github.com/apache/camel-k/tree/1.0.0-nightly.202005130003) (2020-05-11)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.0-nightly.202005060045...1.0.0-nightly.202005130003)

**Closed issues:**

- \(vanilla minikube\) RestDSL.java not working out of the box [\#1452](https://github.com/apache/camel-k/issues/1452)
- Make kamel cli installable via Homebrew [\#1369](https://github.com/apache/camel-k/issues/1369)

**Merged pull requests:**

- Fix \#1449: add support for modeline options [\#1455](https://github.com/apache/camel-k/pull/1455) ([nicolaferraro](https://github.com/nicolaferraro))
- information to update the homebrew formula [\#1454](https://github.com/apache/camel-k/pull/1454) ([ipolyzos](https://github.com/ipolyzos))
- Fix \#1450: fix servicemonitor roles on direct install [\#1453](https://github.com/apache/camel-k/pull/1453) ([nicolaferraro](https://github.com/nicolaferraro))
- Helm fix [\#1448](https://github.com/apache/camel-k/pull/1448) ([nicolaferraro](https://github.com/nicolaferraro))

## [1.0.0-nightly.202005060045](https://github.com/apache/camel-k/tree/1.0.0-nightly.202005060045) (2020-05-05)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.0-nightly.202004171040...1.0.0-nightly.202005060045)

**Closed issues:**

- Does any company use Camel K in production environment? [\#1436](https://github.com/apache/camel-k/issues/1436)
- Kotlin Autocomplete in Intellij? [\#1425](https://github.com/apache/camel-k/issues/1425)
- @PropertyInject does not work in @BindToRegistry methods [\#1422](https://github.com/apache/camel-k/issues/1422)
- Not working Ubuntu 18 Minikube [\#1412](https://github.com/apache/camel-k/issues/1412)
- Error during unshare\(CLONE\_NEWUSER\): Invalid argument [\#1408](https://github.com/apache/camel-k/issues/1408)
- re-organize e2e tests [\#1404](https://github.com/apache/camel-k/issues/1404)

**Merged pull requests:**

- Fix \#1446 and \#1395: completely update integration resource on redepl… [\#1447](https://github.com/apache/camel-k/pull/1447) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1367: add more build events [\#1444](https://github.com/apache/camel-k/pull/1444) ([nicolaferraro](https://github.com/nicolaferraro))
- Partially Fixes Camel 14995: generates master and 3/threescale traits docs. [\#1441](https://github.com/apache/camel-k/pull/1441) ([djencks](https://github.com/djencks))
- Fixes CAMEL-14993 generate traits table with Antora, etc. [\#1440](https://github.com/apache/camel-k/pull/1440) ([djencks](https://github.com/djencks))
- Update 3scale.go [\#1439](https://github.com/apache/camel-k/pull/1439) ([rajatdiptabiswas](https://github.com/rajatdiptabiswas))
- Add ready condition to the integration [\#1438](https://github.com/apache/camel-k/pull/1438) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1414: upgrade to knative 0.14 and support v1beta1 channels and b… [\#1437](https://github.com/apache/camel-k/pull/1437) ([nicolaferraro](https://github.com/nicolaferraro))
- Attempt to upgrade knative CI [\#1435](https://github.com/apache/camel-k/pull/1435) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1416: make minikube experience super-fast again [\#1434](https://github.com/apache/camel-k/pull/1434) ([nicolaferraro](https://github.com/nicolaferraro))
- Fixes CAMEL-14975 \(2 of 3\) Issue 14975 move lang to runtime: remove moved files [\#1433](https://github.com/apache/camel-k/pull/1433) ([djencks](https://github.com/djencks))
- Fix 1401 [\#1432](https://github.com/apache/camel-k/pull/1432) ([oscerd](https://github.com/oscerd))
- chore\(CI\): add knative sources test with YAKS [\#1431](https://github.com/apache/camel-k/pull/1431) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix for \#1358 [\#1430](https://github.com/apache/camel-k/pull/1430) ([dobozysaurus](https://github.com/dobozysaurus))
- Fix knative sources [\#1421](https://github.com/apache/camel-k/pull/1421) ([nicolaferraro](https://github.com/nicolaferraro))
- Add license headers to files generated with kamel init [\#1420](https://github.com/apache/camel-k/pull/1420) ([ipolyzos](https://github.com/ipolyzos))
- Attempt to make CI better [\#1418](https://github.com/apache/camel-k/pull/1418) ([nicolaferraro](https://github.com/nicolaferraro))
- Properly handle platform-http component in routes [\#1411](https://github.com/apache/camel-k/pull/1411) ([lburgazzoli](https://github.com/lburgazzoli))
- Add some sugar for additional sources [\#1400](https://github.com/apache/camel-k/pull/1400) ([lburgazzoli](https://github.com/lburgazzoli))

## [1.0.0-nightly.202004171040](https://github.com/apache/camel-k/tree/1.0.0-nightly.202004171040) (2020-04-17)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.0-nightly.202003261646...1.0.0-nightly.202004171040)

**Closed issues:**

- Failed to read a GraphQL query from a ConfigMap [\#1403](https://github.com/apache/camel-k/issues/1403)
- Adding the http4  dependency causes the deployment of an integration to fail [\#1386](https://github.com/apache/camel-k/issues/1386)
- How can I run a whole project with many integration files in a comfortable way? [\#1375](https://github.com/apache/camel-k/issues/1375)

**Merged pull requests:**

- Fixed cron trait docs [\#1405](https://github.com/apache/camel-k/pull/1405) ([oscerd](https://github.com/oscerd))
- Fix \#1393: create standard role at operator startup in OLM [\#1399](https://github.com/apache/camel-k/pull/1399) ([nicolaferraro](https://github.com/nicolaferraro))
- Cannot switch between cron and normal deployment in dev mode [\#1398](https://github.com/apache/camel-k/pull/1398) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1384: allow to define an alternative prometheus config [\#1397](https://github.com/apache/camel-k/pull/1397) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix YAML rest-dsl inspections [\#1392](https://github.com/apache/camel-k/pull/1392) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(builder\): small refactor to image context lookup [\#1391](https://github.com/apache/camel-k/pull/1391) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(ci\): fix Knative CI [\#1390](https://github.com/apache/camel-k/pull/1390) ([nicolaferraro](https://github.com/nicolaferraro))
- Include checksum when checking for compatible kits [\#1389](https://github.com/apache/camel-k/pull/1389) ([lburgazzoli](https://github.com/lburgazzoli))
- bug: fix minor repetition of example heading in cron trait [\#1385](https://github.com/apache/camel-k/pull/1385) ([AemieJ](https://github.com/AemieJ))
- fix \#1382: enable prometheus roles when installing from olm and helm [\#1383](https://github.com/apache/camel-k/pull/1383) ([nicolaferraro](https://github.com/nicolaferraro))
- Switch to java 11 by default and adapt to runtime 1.3.x [\#1381](https://github.com/apache/camel-k/pull/1381) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1379: make download link available also when installing from operator hub [\#1380](https://github.com/apache/camel-k/pull/1380) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1356: remove namespace resources on uninstall and fix maven-sett… [\#1378](https://github.com/apache/camel-k/pull/1378) ([nicolaferraro](https://github.com/nicolaferraro))

## [1.0.0-nightly.202003261646](https://github.com/apache/camel-k/tree/1.0.0-nightly.202003261646) (2020-03-26)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.0-RC2...1.0.0-nightly.202003261646)

**Closed issues:**

- Nightly builds? [\#1365](https://github.com/apache/camel-k/issues/1365)
- unsupported secret type for registry authentication [\#1360](https://github.com/apache/camel-k/issues/1360)
- How can I modify registries in buildah container? [\#1357](https://github.com/apache/camel-k/issues/1357)
- Remove human-readable format from timer period computation in cron trait [\#1350](https://github.com/apache/camel-k/issues/1350)
- Cannot find RestApiConsumerFactory [\#1348](https://github.com/apache/camel-k/issues/1348)
- Error creating build container: no space left on device [\#1333](https://github.com/apache/camel-k/issues/1333)
- Catalog generation does not take into account the runtime provider to determine the catalog name [\#1312](https://github.com/apache/camel-k/issues/1312)
- Add superfast builds for dev clusters [\#1305](https://github.com/apache/camel-k/issues/1305)
- Unable to run saga sample [\#1304](https://github.com/apache/camel-k/issues/1304)
- \[Enhancement\]Improve log message when image not available in cache [\#1301](https://github.com/apache/camel-k/issues/1301)
- Unable to run the polyglot sample [\#1300](https://github.com/apache/camel-k/issues/1300)
- kamel version should report version number in offline mode [\#1298](https://github.com/apache/camel-k/issues/1298)
- ClassNotFoundException from pom-catalog.xml [\#1293](https://github.com/apache/camel-k/issues/1293)
- Defining datasource in groovy and using in XML routes [\#892](https://github.com/apache/camel-k/issues/892)
- Inject CamelContext into Java DSL RouteBuilder [\#563](https://github.com/apache/camel-k/issues/563)
- Error with Knative probes [\#528](https://github.com/apache/camel-k/issues/528)

**Merged pull requests:**

- chore\(build\): fix package\_artifact.sh script call [\#1374](https://github.com/apache/camel-k/pull/1374) ([johnpoth](https://github.com/johnpoth))
- Add nightly releases [\#1373](https://github.com/apache/camel-k/pull/1373) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1364: only delete direct children of the integration during gc [\#1372](https://github.com/apache/camel-k/pull/1372) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(build\): bump runtime to 1.2.1 [\#1366](https://github.com/apache/camel-k/pull/1366) ([nicolaferraro](https://github.com/nicolaferraro))
- Nth attempt to fix CI [\#1355](https://github.com/apache/camel-k/pull/1355) ([nicolaferraro](https://github.com/nicolaferraro))
- Support for configuring uninstall commmand through files and env vars [\#1354](https://github.com/apache/camel-k/pull/1354) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1340: own openapi configmap and cache it [\#1353](https://github.com/apache/camel-k/pull/1353) ([nicolaferraro](https://github.com/nicolaferraro))
- Fixes \#1350 Remove human-readable format from timer period computatio… [\#1352](https://github.com/apache/camel-k/pull/1352) ([oscerd](https://github.com/oscerd))
- Fix \#1325: add 3scale addon [\#1351](https://github.com/apache/camel-k/pull/1351) ([nicolaferraro](https://github.com/nicolaferraro))
- Set default for rest based services [\#1349](https://github.com/apache/camel-k/pull/1349) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix probes port detection [\#1345](https://github.com/apache/camel-k/pull/1345) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1309: add permissions to patch events [\#1344](https://github.com/apache/camel-k/pull/1344) ([nicolaferraro](https://github.com/nicolaferraro))
- Probes not bound to Knative services [\#1342](https://github.com/apache/camel-k/pull/1342) ([lburgazzoli](https://github.com/lburgazzoli))
- Wrong knative dependency \#1337 [\#1338](https://github.com/apache/camel-k/pull/1338) ([lburgazzoli](https://github.com/lburgazzoli))
- Workaround for apache/camel-k-runtime\#258 [\#1335](https://github.com/apache/camel-k/pull/1335) ([lburgazzoli](https://github.com/lburgazzoli))
- refactor source code inspectors to avoid using redgexp for markup languages [\#1334](https://github.com/apache/camel-k/pull/1334) ([lburgazzoli](https://github.com/lburgazzoli))
- Support for OpenAPI v3 [\#1330](https://github.com/apache/camel-k/pull/1330) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix helm install doc [\#1326](https://github.com/apache/camel-k/pull/1326) ([nicolaferraro](https://github.com/nicolaferraro))
- \[ADD\] Add rest test [\#1324](https://github.com/apache/camel-k/pull/1324) ([bouskaJ](https://github.com/bouskaJ))
- Add e2e test for the multiple files scenario [\#1322](https://github.com/apache/camel-k/pull/1322) ([lburgazzoli](https://github.com/lburgazzoli))
- \[FIX\] Fix kamel install olm parameter [\#1319](https://github.com/apache/camel-k/pull/1319) ([bouskaJ](https://github.com/bouskaJ))
- Add support for capabilities [\#1318](https://github.com/apache/camel-k/pull/1318) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1304: fix the saga example to use default ports [\#1315](https://github.com/apache/camel-k/pull/1315) ([nicolaferraro](https://github.com/nicolaferraro))
- Catalog generation does not take into account the runtime provider to determine the catalog name [\#1313](https://github.com/apache/camel-k/pull/1313) ([lburgazzoli](https://github.com/lburgazzoli))
- Workaround. Labels are not supported on ProjectRequest [\#1311](https://github.com/apache/camel-k/pull/1311) ([bouskaJ](https://github.com/bouskaJ))
- Make test timeouts configurable [\#1307](https://github.com/apache/camel-k/pull/1307) ([bouskaJ](https://github.com/bouskaJ))
- Add super-fast builds for dev clusters [\#1306](https://github.com/apache/camel-k/pull/1306) ([nicolaferraro](https://github.com/nicolaferraro))
- Unable to run the polyglot sample  [\#1303](https://github.com/apache/camel-k/pull/1303) ([lburgazzoli](https://github.com/lburgazzoli))
- feat: Support Buildah builds on OpenShift with internal registry auto-configuration [\#1295](https://github.com/apache/camel-k/pull/1295) ([astefanutti](https://github.com/astefanutti))
- Fix \#1236: upgrade to runtime 1.1.0 and remove camel-bean autodetection [\#1294](https://github.com/apache/camel-k/pull/1294) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(platform\): Default to pod build strategy for Kaniko [\#1292](https://github.com/apache/camel-k/pull/1292) ([astefanutti](https://github.com/astefanutti))
- Related to \#1190: add more logs when patch fails [\#1291](https://github.com/apache/camel-k/pull/1291) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1255: add a global installation test [\#1290](https://github.com/apache/camel-k/pull/1290) ([nicolaferraro](https://github.com/nicolaferraro))
- Some small Knative fixes [\#1289](https://github.com/apache/camel-k/pull/1289) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1286: overwrite resources when --force option is passed to kamel… [\#1288](https://github.com/apache/camel-k/pull/1288) ([nicolaferraro](https://github.com/nicolaferraro))
- Add Helm chart for Camel K [\#1287](https://github.com/apache/camel-k/pull/1287) ([nicolaferraro](https://github.com/nicolaferraro))
- \[FIX\] Fix output redirection for external bin [\#1284](https://github.com/apache/camel-k/pull/1284) ([bouskaJ](https://github.com/bouskaJ))
- fix typo puslar -\> pulsar [\#1281](https://github.com/apache/camel-k/pull/1281) ([apupier](https://github.com/apupier))
- Fix Quarkus dependency detection [\#1279](https://github.com/apache/camel-k/pull/1279) ([jamesnetherton](https://github.com/jamesnetherton))
- Get rid of json schema generation [\#1278](https://github.com/apache/camel-k/pull/1278) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(ci\): test openshift on GH actions [\#1277](https://github.com/apache/camel-k/pull/1277) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1237: check specific knative serving versions to determine if it… [\#1276](https://github.com/apache/camel-k/pull/1276) ([nicolaferraro](https://github.com/nicolaferraro))
- Add concurrency control in cronjobs and fix controller switching [\#1275](https://github.com/apache/camel-k/pull/1275) ([nicolaferraro](https://github.com/nicolaferraro))
- Refactoring traits to allow addons and add master trait \(as addon\) [\#1274](https://github.com/apache/camel-k/pull/1274) ([nicolaferraro](https://github.com/nicolaferraro))
- tekton parameters with parentheses instead of curly brackets [\#1272](https://github.com/apache/camel-k/pull/1272) ([brunoNetId](https://github.com/brunoNetId))
- fix \#1270: upgrade to Knative 0.12 [\#1271](https://github.com/apache/camel-k/pull/1271) ([nicolaferraro](https://github.com/nicolaferraro))
- fix \#1222: use image sha in s2i build to avoid knative registry resol… [\#1269](https://github.com/apache/camel-k/pull/1269) ([nicolaferraro](https://github.com/nicolaferraro))
- Apache Pulsar and Groovy example [\#1268](https://github.com/apache/camel-k/pull/1268) ([haris-zynka](https://github.com/haris-zynka))
- Allow to inject data from externally crafted secrets \#1261 \(camel-k bits\) [\#1265](https://github.com/apache/camel-k/pull/1265) ([lburgazzoli](https://github.com/lburgazzoli))
- Use OLM by default when available [\#1260](https://github.com/apache/camel-k/pull/1260) ([nicolaferraro](https://github.com/nicolaferraro))
- chore: Run Maven in batch mode to reduce log noise [\#1258](https://github.com/apache/camel-k/pull/1258) ([jamesnetherton](https://github.com/jamesnetherton))
- Add uninstall command [\#1254](https://github.com/apache/camel-k/pull/1254) ([jamesnetherton](https://github.com/jamesnetherton))
- chore\(build\): Upgrade Kaniko to version 0.17.1 [\#1253](https://github.com/apache/camel-k/pull/1253) ([astefanutti](https://github.com/astefanutti))
- Small fixes [\#1252](https://github.com/apache/camel-k/pull/1252) ([astefanutti](https://github.com/astefanutti))
- add 'logs' alias on 'log' cmd [\#1251](https://github.com/apache/camel-k/pull/1251) ([ipolyzos](https://github.com/ipolyzos))
- Fix dead link to trait documentation \#1249 [\#1250](https://github.com/apache/camel-k/pull/1250) ([apupier](https://github.com/apupier))
- fix\(install\): Check permission to create OpenShift ConsoleCLIDownload resource [\#1248](https://github.com/apache/camel-k/pull/1248) ([astefanutti](https://github.com/astefanutti))
- chore\(test\): enable e2e tests with Docker Hub and Github packages [\#1247](https://github.com/apache/camel-k/pull/1247) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1162: Knative e2e tests with Kourier [\#1246](https://github.com/apache/camel-k/pull/1246) ([nicolaferraro](https://github.com/nicolaferraro))
- Remove the option to set the camel version [\#1245](https://github.com/apache/camel-k/pull/1245) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1102: add run --property-file option [\#1244](https://github.com/apache/camel-k/pull/1244) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(permissions\): restrict knative serving permissions on the services [\#1243](https://github.com/apache/camel-k/pull/1243) ([nicolaferraro](https://github.com/nicolaferraro))
- fix \#1230: make some commands to work offline [\#1241](https://github.com/apache/camel-k/pull/1241) ([nicolaferraro](https://github.com/nicolaferraro))
- Provide more information on the deployment status and generate related Kubernetes events [\#1228](https://github.com/apache/camel-k/pull/1228) ([nicolaferraro](https://github.com/nicolaferraro))
- JVM trait [\#1226](https://github.com/apache/camel-k/pull/1226) ([astefanutti](https://github.com/astefanutti))
- fix: Command execution fails with result must be a pointer [\#1225](https://github.com/apache/camel-k/pull/1225) ([jamesnetherton](https://github.com/jamesnetherton))
- chore\(dev\): Upgrade Operator SDK to version 0.15.0 [\#1224](https://github.com/apache/camel-k/pull/1224) ([astefanutti](https://github.com/astefanutti))
- feat: Offer easier access to trait list [\#1220](https://github.com/apache/camel-k/pull/1220) ([jamesnetherton](https://github.com/jamesnetherton))
- fix \#1188: add init command [\#1219](https://github.com/apache/camel-k/pull/1219) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1093: document how to update multiple trait properties [\#1218](https://github.com/apache/camel-k/pull/1218) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1181: add --save option to install and run [\#1217](https://github.com/apache/camel-k/pull/1217) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(build\): add verbose flag for Kaniko builds [\#1216](https://github.com/apache/camel-k/pull/1216) ([nicolaferraro](https://github.com/nicolaferraro))
- Support any Java base images [\#1215](https://github.com/apache/camel-k/pull/1215) ([astefanutti](https://github.com/astefanutti))
- fix: Exiting dev mode returns non zero exit code [\#1214](https://github.com/apache/camel-k/pull/1214) ([jamesnetherton](https://github.com/jamesnetherton))
- chore\(olm\): set empty spec in CSV to pass courier validation [\#1213](https://github.com/apache/camel-k/pull/1213) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(dev\): Use go-homedir package instead of os/user to retrieve user home directory [\#1211](https://github.com/apache/camel-k/pull/1211) ([astefanutti](https://github.com/astefanutti))
- chore\(crd\): update the CRD versions [\#1210](https://github.com/apache/camel-k/pull/1210) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(jolokia\): Declare client certificate Jolokia trait option as an array [\#1202](https://github.com/apache/camel-k/pull/1202) ([astefanutti](https://github.com/astefanutti))
- fix\(jolokia\): Order consistently Jolokia agent options when encoded as environment variable [\#1198](https://github.com/apache/camel-k/pull/1198) ([astefanutti](https://github.com/astefanutti))
- Add native support for CronJobs [\#1197](https://github.com/apache/camel-k/pull/1197) ([nicolaferraro](https://github.com/nicolaferraro))
- Jolokia trait improvements [\#1193](https://github.com/apache/camel-k/pull/1193) ([astefanutti](https://github.com/astefanutti))
- Upgrade Operator SDK to version 0.14.0 [\#1191](https://github.com/apache/camel-k/pull/1191) ([astefanutti](https://github.com/astefanutti))
- fix: Avoid potential nil pointer dereference in wait & dev modes [\#1179](https://github.com/apache/camel-k/pull/1179) ([jamesnetherton](https://github.com/jamesnetherton))
- kamel run --wait should return non-zero exit code in case of failure [\#1178](https://github.com/apache/camel-k/pull/1178) ([jamesnetherton](https://github.com/jamesnetherton))
- Auto detect Camel components via FQN classnames [\#1177](https://github.com/apache/camel-k/pull/1177) ([jamesnetherton](https://github.com/jamesnetherton))
- chore\(release\): bump version to 1.0.0-RC2-SNAPSHOT [\#1168](https://github.com/apache/camel-k/pull/1168) ([nicolaferraro](https://github.com/nicolaferraro))
- Upgrade to Runtime 1.0.9 and Kaniko 0.14.0 [\#1167](https://github.com/apache/camel-k/pull/1167) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(CLI\): Cannot set Kaniko cache option [\#1166](https://github.com/apache/camel-k/pull/1166) ([astefanutti](https://github.com/astefanutti))
- \[quarkus\] in JVM mode we should no restrict the languages we can use [\#1161](https://github.com/apache/camel-k/pull/1161) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#921: Migration to v1 API [\#1160](https://github.com/apache/camel-k/pull/1160) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(dev\): Upgrade Operator SDK to version 0.13.0 [\#1153](https://github.com/apache/camel-k/pull/1153) ([astefanutti](https://github.com/astefanutti))
- fix for issue \#1138 [\#1152](https://github.com/apache/camel-k/pull/1152) ([mrganeshraja](https://github.com/mrganeshraja))
- Fix \#1089: defer knative detection to when integration runs [\#1151](https://github.com/apache/camel-k/pull/1151) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(gc\): Do not log 403 errors on deletecollection requests during GC [\#1150](https://github.com/apache/camel-k/pull/1150) ([astefanutti](https://github.com/astefanutti))
- Some minor fixes and updates [\#1148](https://github.com/apache/camel-k/pull/1148) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(test\): add e2e tests for dev mode [\#1147](https://github.com/apache/camel-k/pull/1147) ([nicolaferraro](https://github.com/nicolaferraro))
- fix \#1136: do not watch remote files in dev mode [\#1146](https://github.com/apache/camel-k/pull/1146) ([nicolaferraro](https://github.com/nicolaferraro))
- Added unit tests for the prometheus trait \#255 [\#1142](https://github.com/apache/camel-k/pull/1142) ([aldettinger](https://github.com/aldettinger))
- Fix \#1126: remove constraints and use default versions [\#1141](https://github.com/apache/camel-k/pull/1141) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(test\): allow to change some defaults for testing [\#1139](https://github.com/apache/camel-k/pull/1139) ([nicolaferraro](https://github.com/nicolaferraro))
- Update to maven 3.6.3 [\#1134](https://github.com/apache/camel-k/pull/1134) ([lburgazzoli](https://github.com/lburgazzoli))
- Allow to configure kamel CLI with env vars and configuration files [\#1133](https://github.com/apache/camel-k/pull/1133) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1125: use all known knative types to check if it's enabled [\#1131](https://github.com/apache/camel-k/pull/1131) ([nicolaferraro](https://github.com/nicolaferraro))
- Don't write to platform spec to allow upgrades [\#1127](https://github.com/apache/camel-k/pull/1127) ([nicolaferraro](https://github.com/nicolaferraro))
- Enable github actions to build and validate pr [\#1124](https://github.com/apache/camel-k/pull/1124) ([lburgazzoli](https://github.com/lburgazzoli))
- Switch to Knative 0.10 and remove Knative 0.8 compatibility [\#1123](https://github.com/apache/camel-k/pull/1123) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(build\): disable go modules when performing go clean [\#1118](https://github.com/apache/camel-k/pull/1118) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1047: create a default platform when possible [\#1117](https://github.com/apache/camel-k/pull/1117) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(ci\): dump namespace when tests fail in CI [\#1113](https://github.com/apache/camel-k/pull/1113) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(revert\): revert Kaniko to more stable v0.9.0 [\#1111](https://github.com/apache/camel-k/pull/1111) ([nicolaferraro](https://github.com/nicolaferraro))
- Use JSON merge patch to reconcile Camel K custom resource statuses [\#1110](https://github.com/apache/camel-k/pull/1110) ([astefanutti](https://github.com/astefanutti))
- Update to add the saga example [\#1109](https://github.com/apache/camel-k/pull/1109) ([zhfeng](https://github.com/zhfeng))
- Change case of readme to please Eclipse Che [\#1106](https://github.com/apache/camel-k/pull/1106) ([apupier](https://github.com/apupier))
- chore: Add explicit dependency on json-patch [\#1105](https://github.com/apache/camel-k/pull/1105) ([astefanutti](https://github.com/astefanutti))
- Check whether KAMEL\_BIN file exists [\#1101](https://github.com/apache/camel-k/pull/1101) ([bouskaJ](https://github.com/bouskaJ))
- feat: Generic patching of integration resources in running phase [\#1100](https://github.com/apache/camel-k/pull/1100) ([astefanutti](https://github.com/astefanutti))
- fix\(doc\): Add affinity trait examples back [\#1098](https://github.com/apache/camel-k/pull/1098) ([astefanutti](https://github.com/astefanutti))
- fix\(OpenAPI\): Use catalog runtime version to generate OpenAPI project [\#1096](https://github.com/apache/camel-k/pull/1096) ([astefanutti](https://github.com/astefanutti))
- chore\(lint\): fix formatting error to make CI happy again [\#1090](https://github.com/apache/camel-k/pull/1090) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(deps\): bump js-yaml from 3.12.0 to 3.13.1 in /docs [\#1088](https://github.com/apache/camel-k/pull/1088) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump lodash from 4.17.11 to 4.17.15 in /docs [\#1087](https://github.com/apache/camel-k/pull/1087) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump handlebars from 4.0.12 to 4.5.3 in /docs [\#1086](https://github.com/apache/camel-k/pull/1086) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump mixin-deep from 1.3.1 to 1.3.2 in /docs [\#1085](https://github.com/apache/camel-k/pull/1085) ([dependabot[bot]](https://github.com/apps/dependabot))
- Allow to push images to other registries [\#1084](https://github.com/apache/camel-k/pull/1084) ([nicolaferraro](https://github.com/nicolaferraro))
- Add examples [\#1078](https://github.com/apache/camel-k/pull/1078) ([lburgazzoli](https://github.com/lburgazzoli))
- fix the version of the operator image [\#1077](https://github.com/apache/camel-k/pull/1077) ([zhfeng](https://github.com/zhfeng))
- Support KUBECONF env variable [\#1076](https://github.com/apache/camel-k/pull/1076) ([bouskaJ](https://github.com/bouskaJ))
- chore\(build\): Use JSON merge patch to update build status [\#1074](https://github.com/apache/camel-k/pull/1074) ([astefanutti](https://github.com/astefanutti))
- Automatically generate trait documentation from code [\#1068](https://github.com/apache/camel-k/pull/1068) ([nicolaferraro](https://github.com/nicolaferraro))
- examples with camel-amqp and connection factory [\#1067](https://github.com/apache/camel-k/pull/1067) ([hguerrero](https://github.com/hguerrero))
- add wrapper for processor functions [\#1066](https://github.com/apache/camel-k/pull/1066) ([hguerrero](https://github.com/hguerrero))
- feat\(build\): Better report build progress [\#1064](https://github.com/apache/camel-k/pull/1064) ([astefanutti](https://github.com/astefanutti))
- Add GC trait discovery client caching options and server-side deletion [\#1062](https://github.com/apache/camel-k/pull/1062) ([astefanutti](https://github.com/astefanutti))
- chore\(olm\): fix olm naming [\#1060](https://github.com/apache/camel-k/pull/1060) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1048: use container mode only when no other mechanism is available [\#1054](https://github.com/apache/camel-k/pull/1054) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1038: redeploy integration when trait config changes [\#1053](https://github.com/apache/camel-k/pull/1053) ([nicolaferraro](https://github.com/nicolaferraro))
- Remove support for java class loader [\#1052](https://github.com/apache/camel-k/pull/1052) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1036: generate k8s client for camel k resources [\#1051](https://github.com/apache/camel-k/pull/1051) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(magic\): auto-add dependency on camel-jackson when using plain .… [\#1049](https://github.com/apache/camel-k/pull/1049) ([nicolaferraro](https://github.com/nicolaferraro))
- fix \#662: mark kit traits to avoid rebuilding when not necessary [\#1046](https://github.com/apache/camel-k/pull/1046) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(camel\): Report runtime version from Camel catalog into integration and kit statuses [\#1044](https://github.com/apache/camel-k/pull/1044) ([astefanutti](https://github.com/astefanutti))
- chore\(dev\): Upgrade Operator SDK to version 0.12.0 [\#1043](https://github.com/apache/camel-k/pull/1043) ([astefanutti](https://github.com/astefanutti))
- Fix typo in doc [\#1042](https://github.com/apache/camel-k/pull/1042) ([apupier](https://github.com/apupier))
- fix \#989: document the release process [\#1041](https://github.com/apache/camel-k/pull/1041) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(dev\): Require Go version 1.13 [\#1040](https://github.com/apache/camel-k/pull/1040) ([astefanutti](https://github.com/astefanutti))
- Add readme in examples subfolder [\#1034](https://github.com/apache/camel-k/pull/1034) ([apupier](https://github.com/apupier))
- fix \#1023: add possibility to reference staging artifacts [\#1029](https://github.com/apache/camel-k/pull/1029) ([nicolaferraro](https://github.com/nicolaferraro))
- chore: fix eaxmples [\#1026](https://github.com/apache/camel-k/pull/1026) ([lburgazzoli](https://github.com/lburgazzoli))
- fix\(SDK\): Add relative symlink to kamel main package [\#1025](https://github.com/apache/camel-k/pull/1025) ([astefanutti](https://github.com/astefanutti))
- chore: Use non-caching API reader from SDK [\#1021](https://github.com/apache/camel-k/pull/1021) ([astefanutti](https://github.com/astefanutti))
- fix \#985: add correct clusterroles for knative in global mode [\#1019](https://github.com/apache/camel-k/pull/1019) ([nicolaferraro](https://github.com/nicolaferraro))
- fix \#988: add check for missing licenses before release [\#1018](https://github.com/apache/camel-k/pull/1018) ([nicolaferraro](https://github.com/nicolaferraro))
- Upgrade Operator SDK to version 0.11.0 [\#1017](https://github.com/apache/camel-k/pull/1017) ([astefanutti](https://github.com/astefanutti))
- chore\(tests\): add integration tests for common knative issues [\#1016](https://github.com/apache/camel-k/pull/1016) ([nicolaferraro](https://github.com/nicolaferraro))
- feat\(quarkus\): Initial Quarkus support [\#1013](https://github.com/apache/camel-k/pull/1013) ([astefanutti](https://github.com/astefanutti))
- Support Knative broker/trigger model and explicit source/sink [\#1012](https://github.com/apache/camel-k/pull/1012) ([nicolaferraro](https://github.com/nicolaferraro))
- fix \#1005: allow to customize loader and add default dependencies for… [\#1007](https://github.com/apache/camel-k/pull/1007) ([nicolaferraro](https://github.com/nicolaferraro))
- Update OLM manifests for 1.0.0-M2 release [\#1006](https://github.com/apache/camel-k/pull/1006) ([astefanutti](https://github.com/astefanutti))
- fix: Avoid updating Deployment replicas in default configuration [\#1003](https://github.com/apache/camel-k/pull/1003) ([astefanutti](https://github.com/astefanutti))
- perf: Enqueue ReplicaSet updates only when replicas changed [\#1002](https://github.com/apache/camel-k/pull/1002) ([astefanutti](https://github.com/astefanutti))
- chore: Remove references to OpenShift deprecated build APIs [\#1001](https://github.com/apache/camel-k/pull/1001) ([astefanutti](https://github.com/astefanutti))
- fix: Handle traits update conflicts gracefully [\#1000](https://github.com/apache/camel-k/pull/1000) ([astefanutti](https://github.com/astefanutti))
- chore: GC trait improvements [\#999](https://github.com/apache/camel-k/pull/999) ([astefanutti](https://github.com/astefanutti))
- remove integration delete action and finalizer [\#996](https://github.com/apache/camel-k/pull/996) ([lburgazzoli](https://github.com/lburgazzoli))
- Include camel-k-runtime version in camel-catalog [\#993](https://github.com/apache/camel-k/pull/993) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix release issues for 1.0.0-M2 [\#986](https://github.com/apache/camel-k/pull/986) ([asifdxtreme](https://github.com/asifdxtreme))
- fix \#972: strip local host data from build [\#980](https://github.com/apache/camel-k/pull/980) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix gke permissions [\#979](https://github.com/apache/camel-k/pull/979) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(scale\): Rebuild resources [\#978](https://github.com/apache/camel-k/pull/978) ([astefanutti](https://github.com/astefanutti))
- fix: Add missing configmaps resource to camel-k-builder role [\#977](https://github.com/apache/camel-k/pull/977) ([jamesnetherton](https://github.com/jamesnetherton))
- chore: Display Kaniko version in prelude log [\#976](https://github.com/apache/camel-k/pull/976) ([astefanutti](https://github.com/astefanutti))
- fix: Kaniko cache default spec is not updated when calling the status endpoint [\#975](https://github.com/apache/camel-k/pull/975) ([astefanutti](https://github.com/astefanutti))
- fix: Add nil check for dev mode intergration phase watch result [\#974](https://github.com/apache/camel-k/pull/974) ([jamesnetherton](https://github.com/jamesnetherton))
- fix: Kaniko publisher step fails with IncrementalPackager [\#970](https://github.com/apache/camel-k/pull/970) ([astefanutti](https://github.com/astefanutti))
- chore\(cli\): Hide builder and operator commands [\#969](https://github.com/apache/camel-k/pull/969) ([astefanutti](https://github.com/astefanutti))
- fix\(build\): Remove builder bin commands [\#967](https://github.com/apache/camel-k/pull/967) ([astefanutti](https://github.com/astefanutti))
- fix: Merge all binaries into a single one [\#966](https://github.com/apache/camel-k/pull/966) ([jamesnetherton](https://github.com/jamesnetherton))
- fix: Rename kamel get 'context' column to 'kit' [\#964](https://github.com/apache/camel-k/pull/964) ([jamesnetherton](https://github.com/jamesnetherton))
- chore\(release\): automatic generation of release notes [\#963](https://github.com/apache/camel-k/pull/963) ([nicolaferraro](https://github.com/nicolaferraro))
- Upgrade to Knative 0.9 [\#961](https://github.com/apache/camel-k/pull/961) ([nicolaferraro](https://github.com/nicolaferraro))
- sanitize name of auto-generated catalogs [\#958](https://github.com/apache/camel-k/pull/958) ([lburgazzoli](https://github.com/lburgazzoli))
- Automatically resolve dependencies for language expressions [\#957](https://github.com/apache/camel-k/pull/957) ([jamesnetherton](https://github.com/jamesnetherton))
- chore: Remove unecessary watch on builds while reconciling integrations [\#955](https://github.com/apache/camel-k/pull/955) ([astefanutti](https://github.com/astefanutti))
- Jolokia and Prometheus traits fixes [\#954](https://github.com/apache/camel-k/pull/954) ([astefanutti](https://github.com/astefanutti))
- fix\(build\): Go 1.13 compatibility [\#953](https://github.com/apache/camel-k/pull/953) ([astefanutti](https://github.com/astefanutti))
- Resources GC improvements [\#950](https://github.com/apache/camel-k/pull/950) ([astefanutti](https://github.com/astefanutti))
- Upgrade Operator SDK to version 0.10.0 [\#949](https://github.com/apache/camel-k/pull/949) ([astefanutti](https://github.com/astefanutti))
- fix\(builder\): Clean ReplaceHost step leftover that causes nil pointer dereference panic [\#948](https://github.com/apache/camel-k/pull/948) ([astefanutti](https://github.com/astefanutti))
- Add ability to execute tasks in Tekton pipeline [\#943](https://github.com/apache/camel-k/pull/943) ([nicolaferraro](https://github.com/nicolaferraro))
- Making kamel CLI 90% faster on remote clusters [\#940](https://github.com/apache/camel-k/pull/940) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(examples\): Remove timer route to allow scale-to-zero of REST DSL example [\#936](https://github.com/apache/camel-k/pull/936) ([astefanutti](https://github.com/astefanutti))
- fix\(knative\): Use channel hostname to filter Knative history header [\#935](https://github.com/apache/camel-k/pull/935) ([astefanutti](https://github.com/astefanutti))
- Provide better instructions on the kit create command for missing nam… [\#932](https://github.com/apache/camel-k/pull/932) ([dobozysaurus](https://github.com/dobozysaurus))
- Fix \#732: Adjusted CLI tagline to be in sync with updated \(serverless superpowers\) language. [\#931](https://github.com/apache/camel-k/pull/931) ([dobozysaurus](https://github.com/dobozysaurus))
- fix: Correct indentation for integration source content [\#928](https://github.com/apache/camel-k/pull/928) ([jamesnetherton](https://github.com/jamesnetherton))
- fix: Dev mode does not show if the build failed [\#927](https://github.com/apache/camel-k/pull/927) ([jamesnetherton](https://github.com/jamesnetherton))
- fix\(build\): Replace git.apache.org/thrift.git dependency [\#926](https://github.com/apache/camel-k/pull/926) ([astefanutti](https://github.com/astefanutti))
- fix\(knative\): favor cluster-local instead of public URL to address en… [\#925](https://github.com/apache/camel-k/pull/925) ([astefanutti](https://github.com/astefanutti))
- perf\(gc\): Restrict discovery to types that support the list verb [\#917](https://github.com/apache/camel-k/pull/917) ([astefanutti](https://github.com/astefanutti))
- fix\(knative\): Cannot schedule container image using default internal registry hostname [\#916](https://github.com/apache/camel-k/pull/916) ([astefanutti](https://github.com/astefanutti))
- fix\(doc\): migrate links from staging to official Camel Web site [\#913](https://github.com/apache/camel-k/pull/913) ([astefanutti](https://github.com/astefanutti))
- fix\(OLM\): CSV name must be DNS-1123 subdomains and consist of lower c… [\#912](https://github.com/apache/camel-k/pull/912) ([astefanutti](https://github.com/astefanutti))
- fix\(OLM\): Remove integration context leftovers from OLM bundles [\#909](https://github.com/apache/camel-k/pull/909) ([astefanutti](https://github.com/astefanutti))
-  fix: Enable proxy server to be configured for Kaniko builds [\#905](https://github.com/apache/camel-k/pull/905) ([jamesnetherton](https://github.com/jamesnetherton))
- Added unit tests for the jolokia trait \#255 [\#904](https://github.com/apache/camel-k/pull/904) ([aldettinger](https://github.com/aldettinger))
- fix\(build\): Cache go modules directory [\#903](https://github.com/apache/camel-k/pull/903) ([jamesnetherton](https://github.com/jamesnetherton))
- fix\(examples\): Remove references to obsolete runtime argument [\#901](https://github.com/apache/camel-k/pull/901) ([jamesnetherton](https://github.com/jamesnetherton))
- fix: Improve kamel get to enable specifying integration name [\#897](https://github.com/apache/camel-k/pull/897) ([jamesnetherton](https://github.com/jamesnetherton))
- Include modeline in examples \#895 [\#896](https://github.com/apache/camel-k/pull/896) ([apupier](https://github.com/apupier))
- External kamel bin testing [\#894](https://github.com/apache/camel-k/pull/894) ([bouskaJ](https://github.com/bouskaJ))
- BuildConfig's, ImageStream's and Pod's not labeled with camel-k and can't delete with -l 'app=camel-k' [\#884](https://github.com/apache/camel-k/pull/884) ([dmvolod](https://github.com/dmvolod))
- Fix embedded resources snapshot version [\#882](https://github.com/apache/camel-k/pull/882) ([dmvolod](https://github.com/dmvolod))
- Switch to images-dev build on install-mini\<plaform\> [\#881](https://github.com/apache/camel-k/pull/881) ([dmvolod](https://github.com/dmvolod))
- Added unit tests for ingress\_trait \#255 [\#880](https://github.com/apache/camel-k/pull/880) ([aldettinger](https://github.com/aldettinger))
- Fix make clean for tests and remove binary file from repo [\#879](https://github.com/apache/camel-k/pull/879) ([dmvolod](https://github.com/dmvolod))
- chore\(js\): fix examples, use arrow function for lambda style processor [\#877](https://github.com/apache/camel-k/pull/877) ([lburgazzoli](https://github.com/lburgazzoli))
- fix\(GC\): Skip 503 errors when scanning for resources to be GCed [\#876](https://github.com/apache/camel-k/pull/876) ([astefanutti](https://github.com/astefanutti))
- Remove Dep files [\#872](https://github.com/apache/camel-k/pull/872) ([astefanutti](https://github.com/astefanutti))
- chore\(build\): remove go mod vendor from travis build [\#871](https://github.com/apache/camel-k/pull/871) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#789: add correct example for operator hub [\#868](https://github.com/apache/camel-k/pull/868) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#730: put example that demonstrate backward compatibility works [\#867](https://github.com/apache/camel-k/pull/867) ([nicolaferraro](https://github.com/nicolaferraro))
- camel-rest should load automatically for routes using Rest DSL [\#866](https://github.com/apache/camel-k/pull/866) ([lburgazzoli](https://github.com/lburgazzoli))
- Remove .gitmodules file [\#865](https://github.com/apache/camel-k/pull/865) ([astefanutti](https://github.com/astefanutti))
- Update build requirements documentation [\#864](https://github.com/apache/camel-k/pull/864) ([astefanutti](https://github.com/astefanutti))
- Fix \#815: determine correct profile at runtime when empty [\#861](https://github.com/apache/camel-k/pull/861) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(examples\): add --dependency=camel-rest to usage comments in rest examples [\#860](https://github.com/apache/camel-k/pull/860) ([tadayosi](https://github.com/tadayosi))
- Add --verbose to lint for preventing hangs visibility [\#859](https://github.com/apache/camel-k/pull/859) ([dmvolod](https://github.com/dmvolod))
- fix\(docs\): typo in running in dev mode [\#858](https://github.com/apache/camel-k/pull/858) ([tadayosi](https://github.com/tadayosi))
- Fix \#856: lookup destination in multiple places and add e2e tests [\#857](https://github.com/apache/camel-k/pull/857) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(lint\): tune golangci-lint resource requirements [\#855](https://github.com/apache/camel-k/pull/855) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(knative\): fix auto discovery [\#854](https://github.com/apache/camel-k/pull/854) ([lburgazzoli](https://github.com/lburgazzoli))
- fix\(classpath\): lookup integration container by name instead of iterating amoung all the containers [\#852](https://github.com/apache/camel-k/pull/852) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade to Knative 0.7.1 [\#851](https://github.com/apache/camel-k/pull/851) ([nicolaferraro](https://github.com/nicolaferraro))
- Upgrade Operator SDK to version 0.9.0 [\#850](https://github.com/apache/camel-k/pull/850) ([astefanutti](https://github.com/astefanutti))
- Groovy Rest example fails due to Unable to find loader for language=xml [\#849](https://github.com/apache/camel-k/pull/849) ([dmvolod](https://github.com/dmvolod))
- Disable Istio by default [\#847](https://github.com/apache/camel-k/pull/847) ([lburgazzoli](https://github.com/lburgazzoli))
- Add unit tests for the classpath trait \#255 [\#846](https://github.com/apache/camel-k/pull/846) ([aldettinger](https://github.com/aldettinger))
- fix build-pod strategy on kubernetes [\#844](https://github.com/apache/camel-k/pull/844) ([lburgazzoli](https://github.com/lburgazzoli))
- route trait assumes target port name is always 'http' [\#842](https://github.com/apache/camel-k/pull/842) ([lburgazzoli](https://github.com/lburgazzoli))
- fix: Enable maven strict checksum policy on platform initialization [\#836](https://github.com/apache/camel-k/pull/836) ([jamesnetherton](https://github.com/jamesnetherton))
- Stable container name [\#835](https://github.com/apache/camel-k/pull/835) ([lburgazzoli](https://github.com/lburgazzoli))
- Concurrency issue in the end to end tests [\#834](https://github.com/apache/camel-k/pull/834) ([lburgazzoli](https://github.com/lburgazzoli))
- fix: point to the staging site from README.adoc [\#831](https://github.com/apache/camel-k/pull/831) ([zregvart](https://github.com/zregvart))
- chore\(docs\): cleanup contributors guide [\#829](https://github.com/apache/camel-k/pull/829) ([zregvart](https://github.com/zregvart))
- chore: point the Antora configuration to `master` [\#828](https://github.com/apache/camel-k/pull/828) ([zregvart](https://github.com/zregvart))
- Misleading "service.enabled=false" when used in combination with the prometheus trait i [\#825](https://github.com/apache/camel-k/pull/825) ([lburgazzoli](https://github.com/lburgazzoli))
- Publishing documentation using Antora [\#824](https://github.com/apache/camel-k/pull/824) ([zregvart](https://github.com/zregvart))
- chore\(doc\): add ddoc for probes trait [\#822](https://github.com/apache/camel-k/pull/822) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: re-enable integration tests [\#821](https://github.com/apache/camel-k/pull/821) ([lburgazzoli](https://github.com/lburgazzoli))
- Remove obsolete runtime dependency type [\#820](https://github.com/apache/camel-k/pull/820) ([lburgazzoli](https://github.com/lburgazzoli))
- fix\(test\): Fix XML e2e test after upgrade to 3.0.0-M4 [\#819](https://github.com/apache/camel-k/pull/819) ([jamesnetherton](https://github.com/jamesnetherton))
- chore\(runtime\): remove hardcoded log4j dependency [\#818](https://github.com/apache/camel-k/pull/818) ([lburgazzoli](https://github.com/lburgazzoli))
- test\(yaml\): Add YAML e2e test [\#817](https://github.com/apache/camel-k/pull/817) ([jamesnetherton](https://github.com/jamesnetherton))
- fix: Use error condition when active platform cannot be resolved [\#816](https://github.com/apache/camel-k/pull/816) ([jamesnetherton](https://github.com/jamesnetherton))
- Update to camel 3.0.0-M4 [\#812](https://github.com/apache/camel-k/pull/812) ([lburgazzoli](https://github.com/lburgazzoli))
- fix: Kamel install with kit option can leave integrationkit stuck waiting for platform [\#810](https://github.com/apache/camel-k/pull/810) ([jamesnetherton](https://github.com/jamesnetherton))
- fix: Dependencies & rest-dsl traits are never enabled [\#808](https://github.com/apache/camel-k/pull/808) ([jamesnetherton](https://github.com/jamesnetherton))
- fix: Nil pointer on build failure recovery [\#805](https://github.com/apache/camel-k/pull/805) ([jamesnetherton](https://github.com/jamesnetherton))
- Revert "chore: Re-enable e2e tests" [\#803](https://github.com/apache/camel-k/pull/803) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: Re-enable e2e tests [\#802](https://github.com/apache/camel-k/pull/802) ([jamesnetherton](https://github.com/jamesnetherton))
- chore\(build\): strip full path from stackstraces [\#801](https://github.com/apache/camel-k/pull/801) ([lburgazzoli](https://github.com/lburgazzoli))
- Support for new yaml dsl [\#800](https://github.com/apache/camel-k/pull/800) ([lburgazzoli](https://github.com/lburgazzoli))
- Move waiting for platform to controller [\#799](https://github.com/apache/camel-k/pull/799) ([lburgazzoli](https://github.com/lburgazzoli))
- Don't wait for initial kit to be ready to declare the platform ready [\#796](https://github.com/apache/camel-k/pull/796) ([lburgazzoli](https://github.com/lburgazzoli))
- Add keys [\#790](https://github.com/apache/camel-k/pull/790) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(travis\): disable e2e [\#787](https://github.com/apache/camel-k/pull/787) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: extract indentedwriter to it's own package and make it an utility [\#786](https://github.com/apache/camel-k/pull/786) ([lburgazzoli](https://github.com/lburgazzoli))
- refactor\(trait\): replace resources and execute post action as part of trait management [\#785](https://github.com/apache/camel-k/pull/785) ([lburgazzoli](https://github.com/lburgazzoli))
- Refactor controller logic [\#784](https://github.com/apache/camel-k/pull/784) ([lburgazzoli](https://github.com/lburgazzoli))
- Route trait does not work if route.auto is set to false [\#783](https://github.com/apache/camel-k/pull/783) ([lburgazzoli](https://github.com/lburgazzoli))
- Initial upgrade support [\#782](https://github.com/apache/camel-k/pull/782) ([nicolaferraro](https://github.com/nicolaferraro))
- fix: Integration naming issues with numbers in them [\#779](https://github.com/apache/camel-k/pull/779) ([jamesnetherton](https://github.com/jamesnetherton))
- fix: Validate maven artifacts [\#774](https://github.com/apache/camel-k/pull/774) ([jamesnetherton](https://github.com/jamesnetherton))
- chore\(lint\): run golanci-lint on travis [\#773](https://github.com/apache/camel-k/pull/773) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: cleanup integration kit [\#772](https://github.com/apache/camel-k/pull/772) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: cleanup build [\#771](https://github.com/apache/camel-k/pull/771) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(lint\): fix findings [\#770](https://github.com/apache/camel-k/pull/770) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(integration controller\): replace custom reconcile trigger with watch [\#769](https://github.com/apache/camel-k/pull/769) ([lburgazzoli](https://github.com/lburgazzoli))
- Add conditions to camel-k CRs [\#766](https://github.com/apache/camel-k/pull/766) ([lburgazzoli](https://github.com/lburgazzoli))
- Add timeout to maven operations [\#765](https://github.com/apache/camel-k/pull/765) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(lint\): fix findings [\#760](https://github.com/apache/camel-k/pull/760) ([lburgazzoli](https://github.com/lburgazzoli))
- Automatically create catalogs from maven [\#759](https://github.com/apache/camel-k/pull/759) ([lburgazzoli](https://github.com/lburgazzoli))
- Add e2e tests [\#758](https://github.com/apache/camel-k/pull/758) ([nicolaferraro](https://github.com/nicolaferraro))
- Service trait: confusing behavior [\#757](https://github.com/apache/camel-k/pull/757) ([lburgazzoli](https://github.com/lburgazzoli))
-  feat: Add a --global install option [\#752](https://github.com/apache/camel-k/pull/752) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#749: do not create route/ingress if not needed [\#750](https://github.com/apache/camel-k/pull/750) ([nicolaferraro](https://github.com/nicolaferraro))
-  fix: CR example is using wrong schema [\#748](https://github.com/apache/camel-k/pull/748) ([jamesnetherton](https://github.com/jamesnetherton))
- The --maven-repository shortcut does not configure plugin repositories [\#747](https://github.com/apache/camel-k/pull/747) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(builder\): ensure files added tot he tar archive have the right permissions [\#741](https://github.com/apache/camel-k/pull/741) ([lburgazzoli](https://github.com/lburgazzoli))
- fix: Honour KUBECONFIG [\#740](https://github.com/apache/camel-k/pull/740) ([jamesnetherton](https://github.com/jamesnetherton))
- Set RestWithRestlet response Content-Type header to text/plain [\#738](https://github.com/apache/camel-k/pull/738) ([jamesnetherton](https://github.com/jamesnetherton))
- Added KEYS file [\#734](https://github.com/apache/camel-k/pull/734) ([oscerd](https://github.com/oscerd))
- Bump to 1.0.0-M1-SNAPSHOT and release changes [\#733](https://github.com/apache/camel-k/pull/733) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(regen\): regenerate defaults [\#727](https://github.com/apache/camel-k/pull/727) ([lburgazzoli](https://github.com/lburgazzoli))
- Rename 'context' term used by Camel K. [\#726](https://github.com/apache/camel-k/pull/726) ([lburgazzoli](https://github.com/lburgazzoli))
- fix: Do not share labels map reference in integration deployment [\#725](https://github.com/apache/camel-k/pull/725) ([astefanutti](https://github.com/astefanutti))
- Filter allowed env variables in Knative [\#724](https://github.com/apache/camel-k/pull/724) ([nicolaferraro](https://github.com/nicolaferraro))
- Automatically configure global build strategy [\#723](https://github.com/apache/camel-k/pull/723) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(build\): remove test artifacts [\#721](https://github.com/apache/camel-k/pull/721) ([lburgazzoli](https://github.com/lburgazzoli))
-  Allow to provide custom settings.xml [\#720](https://github.com/apache/camel-k/pull/720) ([lburgazzoli](https://github.com/lburgazzoli))
- Don't automatically install contexts upon platform installation [\#719](https://github.com/apache/camel-k/pull/719) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: default to camel-k-runtime v0.3.3 [\#718](https://github.com/apache/camel-k/pull/718) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#707: sign released artifacts [\#713](https://github.com/apache/camel-k/pull/713) ([nicolaferraro](https://github.com/nicolaferraro))
- \#709 Add ASL license header into the files [\#712](https://github.com/apache/camel-k/pull/712) ([WillemJiang](https://github.com/WillemJiang))
- kamel run --dev examples/resources-route.groovy issues Cannot find resource [\#710](https://github.com/apache/camel-k/pull/710) ([lburgazzoli](https://github.com/lburgazzoli))
- \#701 Update the cluster-setup document for installing knative on minishift [\#708](https://github.com/apache/camel-k/pull/708) ([WillemJiang](https://github.com/WillemJiang))
- trait\(route\): do not set Route.Spec.TLS if not needed [\#705](https://github.com/apache/camel-k/pull/705) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#698: 2nd attempt [\#704](https://github.com/apache/camel-k/pull/704) ([nicolaferraro](https://github.com/nicolaferraro))
- feat: Set env var with Kamel [\#696](https://github.com/apache/camel-k/pull/696) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#644: remove predefined images [\#695](https://github.com/apache/camel-k/pull/695) ([nicolaferraro](https://github.com/nicolaferraro))
- chore: disable modules when invoking go clean [\#694](https://github.com/apache/camel-k/pull/694) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: fix lint finding [\#691](https://github.com/apache/camel-k/pull/691) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: include build info in camel-k operator [\#690](https://github.com/apache/camel-k/pull/690) ([lburgazzoli](https://github.com/lburgazzoli))
- Update to Camel 2.24.0 [\#689](https://github.com/apache/camel-k/pull/689) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: remove spring-boot leftovers [\#688](https://github.com/apache/camel-k/pull/688) ([lburgazzoli](https://github.com/lburgazzoli))
- Remove vendor directory for good [\#685](https://github.com/apache/camel-k/pull/685) ([astefanutti](https://github.com/astefanutti))
- fix: Integration stuck waiting for platform [\#684](https://github.com/apache/camel-k/pull/684) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#679: make sure we don't use external deps other than kube in apis [\#680](https://github.com/apache/camel-k/pull/680) ([nicolaferraro](https://github.com/nicolaferraro))
- A pack of small Knative improvements [\#678](https://github.com/apache/camel-k/pull/678) ([nicolaferraro](https://github.com/nicolaferraro))
- chore: support for health based on servlet available from 0.3.3-SNAPSHOT [\#676](https://github.com/apache/camel-k/pull/676) ([lburgazzoli](https://github.com/lburgazzoli))
- Migrate to Go modules [\#675](https://github.com/apache/camel-k/pull/675) ([astefanutti](https://github.com/astefanutti))
- trait\(route\): tls support [\#673](https://github.com/apache/camel-k/pull/673) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(lint\): better naming [\#672](https://github.com/apache/camel-k/pull/672) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade Operator SDK to version 0.8.0 [\#671](https://github.com/apache/camel-k/pull/671) ([astefanutti](https://github.com/astefanutti))
- chore\(lint\): fix findings [\#670](https://github.com/apache/camel-k/pull/670) ([lburgazzoli](https://github.com/lburgazzoli))
- fix wrong log method used to log formatted content [\#667](https://github.com/apache/camel-k/pull/667) ([lburgazzoli](https://github.com/lburgazzoli))
- Unified operator deployment [\#661](https://github.com/apache/camel-k/pull/661) ([astefanutti](https://github.com/astefanutti))
- include context traits when looking up for a compatible context [\#659](https://github.com/apache/camel-k/pull/659) ([lburgazzoli](https://github.com/lburgazzoli))
- drop support for knative \< 0.4 [\#658](https://github.com/apache/camel-k/pull/658) ([lburgazzoli](https://github.com/lburgazzoli))
- remove spring boot support [\#657](https://github.com/apache/camel-k/pull/657) ([lburgazzoli](https://github.com/lburgazzoli))
- remove support for integration container image creation [\#656](https://github.com/apache/camel-k/pull/656) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#651: removed camel 3.0.0-M1 catalog [\#652](https://github.com/apache/camel-k/pull/652) ([aldettinger](https://github.com/aldettinger))
- Initial OLM manifest [\#648](https://github.com/apache/camel-k/pull/648) ([astefanutti](https://github.com/astefanutti))
- Adding a note about the delay at first Sample run [\#647](https://github.com/apache/camel-k/pull/647) ([rafaeltuelho](https://github.com/rafaeltuelho))
- Fix \#645: use the right kind of sink in knative trait [\#646](https://github.com/apache/camel-k/pull/646) ([nicolaferraro](https://github.com/nicolaferraro))
- Upgrade to camel-k-runtime 0.3.2 [\#643](https://github.com/apache/camel-k/pull/643) ([davsclaus](https://github.com/davsclaus))
- feat: Add volume argument to kamel run [\#640](https://github.com/apache/camel-k/pull/640) ([jamesnetherton](https://github.com/jamesnetherton))
- fix: Add .exe file extension to Windows kamel binary [\#636](https://github.com/apache/camel-k/pull/636) ([jamesnetherton](https://github.com/jamesnetherton))
- LanguageXML is not included in languages list \#634 [\#635](https://github.com/apache/camel-k/pull/635) ([lburgazzoli](https://github.com/lburgazzoli))
- feat: Add kamel describe command [\#633](https://github.com/apache/camel-k/pull/633) ([jamesnetherton](https://github.com/jamesnetherton))
- Modified PR \#625 as requested [\#632](https://github.com/apache/camel-k/pull/632) ([valdar](https://github.com/valdar))
- Use non-caching client in builds scheduling critical section [\#631](https://github.com/apache/camel-k/pull/631) ([astefanutti](https://github.com/astefanutti))
- chore\(doc\): change the description of the project [\#628](https://github.com/apache/camel-k/pull/628) ([nicolaferraro](https://github.com/nicolaferraro))
- Updated README for configmap [\#626](https://github.com/apache/camel-k/pull/626) ([stevef1uk](https://github.com/stevef1uk))
- Build improvements [\#623](https://github.com/apache/camel-k/pull/623) ([astefanutti](https://github.com/astefanutti))
-  allow to configure default configurations on platform [\#622](https://github.com/apache/camel-k/pull/622) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#602: error in set-version script [\#621](https://github.com/apache/camel-k/pull/621) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(build\): add builder to dev workflow [\#616](https://github.com/apache/camel-k/pull/616) ([nicolaferraro](https://github.com/nicolaferraro))
- Rely on label selector to query older generation resources in GC [\#615](https://github.com/apache/camel-k/pull/615) ([astefanutti](https://github.com/astefanutti))
- Update gke-setup.adoc [\#612](https://github.com/apache/camel-k/pull/612) ([MehrCurry](https://github.com/MehrCurry))
- Fix \#575: recognize hystrix automatically [\#611](https://github.com/apache/camel-k/pull/611) ([nicolaferraro](https://github.com/nicolaferraro))
- istio: allow to control annotation sidecar.istio.io/inject i [\#610](https://github.com/apache/camel-k/pull/610) ([lburgazzoli](https://github.com/lburgazzoli))
- Add affinity trait [\#607](https://github.com/apache/camel-k/pull/607) ([astefanutti](https://github.com/astefanutti))
- fix \#602: Script set-version.sh does not honor the registry/repository… [\#603](https://github.com/apache/camel-k/pull/603) ([valdar](https://github.com/valdar))
- Change builder to sync style API and remove in-memory working queue [\#599](https://github.com/apache/camel-k/pull/599) ([astefanutti](https://github.com/astefanutti))
- Upgrade Operator SDK to version 0.7.0 [\#596](https://github.com/apache/camel-k/pull/596) ([astefanutti](https://github.com/astefanutti))
- cleanup [\#590](https://github.com/apache/camel-k/pull/590) ([lburgazzoli](https://github.com/lburgazzoli))
- context with status error should not be included when looking up suitable context for an integration [\#585](https://github.com/apache/camel-k/pull/585) ([lburgazzoli](https://github.com/lburgazzoli))
- Split builder from operator [\#583](https://github.com/apache/camel-k/pull/583) ([astefanutti](https://github.com/astefanutti))
- Fix \#579: fix namespace in subscription [\#581](https://github.com/apache/camel-k/pull/581) ([nicolaferraro](https://github.com/nicolaferraro))
- Add log4j-slf4j-impl as runtime dependency in default project build [\#578](https://github.com/apache/camel-k/pull/578) ([astefanutti](https://github.com/astefanutti))
- chore\(style\): apply gofmt after code generation [\#577](https://github.com/apache/camel-k/pull/577) ([lburgazzoli](https://github.com/lburgazzoli))
- allow to configure resources requests/limits [\#573](https://github.com/apache/camel-k/pull/573) ([lburgazzoli](https://github.com/lburgazzoli))
- Add support for traits defaults [\#572](https://github.com/apache/camel-k/pull/572) ([lburgazzoli](https://github.com/lburgazzoli))
- knative: create full camel environment [\#571](https://github.com/apache/camel-k/pull/571) ([lburgazzoli](https://github.com/lburgazzoli))
- dependencies: add support for boms [\#565](https://github.com/apache/camel-k/pull/565) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade Operator SDK to version 0.6.0 [\#562](https://github.com/apache/camel-k/pull/562) ([astefanutti](https://github.com/astefanutti))
- Fix \#557: fix generated images [\#560](https://github.com/apache/camel-k/pull/560) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(maven\): Run Maven in batch mode to reduce log noise [\#556](https://github.com/apache/camel-k/pull/556) ([jamesnetherton](https://github.com/jamesnetherton))
- knative: fix copy secrets to env vars [\#555](https://github.com/apache/camel-k/pull/555) ([lburgazzoli](https://github.com/lburgazzoli))
- resources: add options to configure mount path and key [\#554](https://github.com/apache/camel-k/pull/554) ([lburgazzoli](https://github.com/lburgazzoli))
- Timeout in S2I build [\#551](https://github.com/apache/camel-k/pull/551) ([lburgazzoli](https://github.com/lburgazzoli))
- fix: Improve how SanitizeName handles paths and URLs [\#549](https://github.com/apache/camel-k/pull/549) ([jamesnetherton](https://github.com/jamesnetherton))
- fix bug due to state change during trait evaluation [\#547](https://github.com/apache/camel-k/pull/547) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(refactor\): move JAVA\_CLASSPATH configuration to classpath trait [\#546](https://github.com/apache/camel-k/pull/546) ([lburgazzoli](https://github.com/lburgazzoli))
- fix: include mount paths in java's classpath [\#545](https://github.com/apache/camel-k/pull/545) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(fix\): minScale and maxScale should be always greater than 0 [\#544](https://github.com/apache/camel-k/pull/544) ([nicolaferraro](https://github.com/nicolaferraro))
- Add explicit kind selection to deployer trait [\#543](https://github.com/apache/camel-k/pull/543) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(runtime\): update to runtime v0.3.1 [\#542](https://github.com/apache/camel-k/pull/542) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: Remove operator metrics port and service [\#541](https://github.com/apache/camel-k/pull/541) ([jamesnetherton](https://github.com/jamesnetherton))
- camel-k --runtime-version is not honoured for all runtimes [\#539](https://github.com/apache/camel-k/pull/539) ([lburgazzoli](https://github.com/lburgazzoli))
- Improve owner trait [\#535](https://github.com/apache/camel-k/pull/535) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(lint\): fix findings [\#533](https://github.com/apache/camel-k/pull/533) ([lburgazzoli](https://github.com/lburgazzoli))
- fix: do not add probes to knative services [\#532](https://github.com/apache/camel-k/pull/532) ([lburgazzoli](https://github.com/lburgazzoli))
- Add option to health probes [\#531](https://github.com/apache/camel-k/pull/531) ([lburgazzoli](https://github.com/lburgazzoli))
- feature\(kaniko\): support for incremental build [\#530](https://github.com/apache/camel-k/pull/530) ([lburgazzoli](https://github.com/lburgazzoli))
- ordered delete [\#529](https://github.com/apache/camel-k/pull/529) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(kamel\): fix reset command [\#526](https://github.com/apache/camel-k/pull/526) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(release\): add automatic version update to release [\#524](https://github.com/apache/camel-k/pull/524) ([nicolaferraro](https://github.com/nicolaferraro))
- fix: Allow file names as delete cmd argument [\#522](https://github.com/apache/camel-k/pull/522) ([christophd](https://github.com/christophd))
- chore\(image\): include camel runtime adapters [\#521](https://github.com/apache/camel-k/pull/521) ([lburgazzoli](https://github.com/lburgazzoli))
- test\(builder\): more assertions on deps [\#520](https://github.com/apache/camel-k/pull/520) ([oscerd](https://github.com/oscerd))
- chore\(build\): remove jitpack configuration [\#519](https://github.com/apache/camel-k/pull/519) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(runtime\): Bump runtime to 0.3.0 [\#518](https://github.com/apache/camel-k/pull/518) ([oscerd](https://github.com/oscerd))
- knative\(serving\): add support for additional annotations [\#517](https://github.com/apache/camel-k/pull/517) ([lburgazzoli](https://github.com/lburgazzoli))
- Adding Probes to Knative services [\#514](https://github.com/apache/camel-k/pull/514) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(make\): fix images-push target [\#510](https://github.com/apache/camel-k/pull/510) ([lburgazzoli](https://github.com/lburgazzoli))
- minikube doc update [\#509](https://github.com/apache/camel-k/pull/509) ([kameshsampath](https://github.com/kameshsampath))
- chore\(crd\): add missing label to CamelCatalog CRD [\#502](https://github.com/apache/camel-k/pull/502) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(install\): fix wrong resource kind [\#501](https://github.com/apache/camel-k/pull/501) ([lburgazzoli](https://github.com/lburgazzoli))
- feature\(knative\): support configmap and secrets [\#500](https://github.com/apache/camel-k/pull/500) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#497: upgrade to knative 0.4.0 [\#499](https://github.com/apache/camel-k/pull/499) ([nicolaferraro](https://github.com/nicolaferraro))
- Perform garbage collection asynchronously [\#496](https://github.com/apache/camel-k/pull/496) ([astefanutti](https://github.com/astefanutti))
- Do not swallow error returned by controller actions [\#494](https://github.com/apache/camel-k/pull/494) ([astefanutti](https://github.com/astefanutti))
- sanitize dependencies [\#491](https://github.com/apache/camel-k/pull/491) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(controller\): reduce logging when action fails because of conflicts, log the error message without the stack and re-queue the reconcilation [\#488](https://github.com/apache/camel-k/pull/488) ([lburgazzoli](https://github.com/lburgazzoli))
- do not include runtime artefacts in operator image by default [\#486](https://github.com/apache/camel-k/pull/486) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(version\): Align to latest runtime, until we remove git submodule [\#485](https://github.com/apache/camel-k/pull/485) ([oscerd](https://github.com/oscerd))
- chore\(refactor\): Added license to .travis.yml [\#484](https://github.com/apache/camel-k/pull/484) ([oscerd](https://github.com/oscerd))
- add finalizer to ensure integration children are cleaned up [\#480](https://github.com/apache/camel-k/pull/480) ([lburgazzoli](https://github.com/lburgazzoli))
- Activate Kaniko caching and warm the platform base image [\#479](https://github.com/apache/camel-k/pull/479) ([astefanutti](https://github.com/astefanutti))
- add an option to set which runtime version the operator should to run integrations [\#478](https://github.com/apache/camel-k/pull/478) ([lburgazzoli](https://github.com/lburgazzoli))
- Aligned the submodule runtime from camel-k-runtime [\#476](https://github.com/apache/camel-k/pull/476) ([oscerd](https://github.com/oscerd))
- Removed JenkinsFile since it used by the runtime repo now [\#475](https://github.com/apache/camel-k/pull/475) ([oscerd](https://github.com/oscerd))
- Fixes \#470 [\#474](https://github.com/apache/camel-k/pull/474) ([oscerd](https://github.com/oscerd))
- fix\(traints\): ensure an error is returned to the caller if a catalog cannot be found [\#472](https://github.com/apache/camel-k/pull/472) ([lburgazzoli](https://github.com/lburgazzoli))
- Remove unecessary Go dep overrides [\#467](https://github.com/apache/camel-k/pull/467) ([astefanutti](https://github.com/astefanutti))
- fix\(semver\): support exact version match when looking up camel catalog [\#465](https://github.com/apache/camel-k/pull/465) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix lint errors [\#464](https://github.com/apache/camel-k/pull/464) ([astefanutti](https://github.com/astefanutti))
- Add a phase to wake up integration reconcile loop on context build co… [\#463](https://github.com/apache/camel-k/pull/463) ([astefanutti](https://github.com/astefanutti))
- add a tool to generate json schema from custom resources  [\#462](https://github.com/apache/camel-k/pull/462) ([lburgazzoli](https://github.com/lburgazzoli))
- Optimize reconciliation loops [\#459](https://github.com/apache/camel-k/pull/459) ([astefanutti](https://github.com/astefanutti))
- Added a FailIfNoTests option to Surefire [\#457](https://github.com/apache/camel-k/pull/457) ([oscerd](https://github.com/oscerd))
- Enable status subresource for integration context [\#456](https://github.com/apache/camel-k/pull/456) ([astefanutti](https://github.com/astefanutti))
- Enable status subresource for integration platform [\#455](https://github.com/apache/camel-k/pull/455) ([astefanutti](https://github.com/astefanutti))
- Added release profile [\#454](https://github.com/apache/camel-k/pull/454) ([oscerd](https://github.com/oscerd))
- chore\(catalog\): improve camel catalog generation [\#451](https://github.com/apache/camel-k/pull/451) ([lburgazzoli](https://github.com/lburgazzoli))
- Remove deploy phase from test and install stage [\#450](https://github.com/apache/camel-k/pull/450) ([oscerd](https://github.com/oscerd))
- Fixed Jenkinsfile [\#449](https://github.com/apache/camel-k/pull/449) ([oscerd](https://github.com/oscerd))
- chore\(build\): deploy camel-k runtime artifacts to apache snapshot aut… [\#448](https://github.com/apache/camel-k/pull/448) ([oscerd](https://github.com/oscerd))
- Cannot deploy integration if not in the root package [\#444](https://github.com/apache/camel-k/pull/444) ([lburgazzoli](https://github.com/lburgazzoli))
- Error while deploying integration in Knative based environment [\#443](https://github.com/apache/camel-k/pull/443) ([lburgazzoli](https://github.com/lburgazzoli))
- Add field 'camel-version' to Integration CRD [\#442](https://github.com/apache/camel-k/pull/442) ([lburgazzoli](https://github.com/lburgazzoli))
- fix rest dsl generation [\#441](https://github.com/apache/camel-k/pull/441) ([lburgazzoli](https://github.com/lburgazzoli))
- Pass garbage collection items by values instead of references [\#440](https://github.com/apache/camel-k/pull/440) ([astefanutti](https://github.com/astefanutti))
- Ability to customise the generated camel-k image [\#438](https://github.com/apache/camel-k/pull/438) ([kameshsampath](https://github.com/kameshsampath))
- chore\(deploy snapshot\): deploy runtime snapshots to apache snapshot r… [\#435](https://github.com/apache/camel-k/pull/435) ([oscerd](https://github.com/oscerd))
- Fix typos in traits doc [\#434](https://github.com/apache/camel-k/pull/434) ([astefanutti](https://github.com/astefanutti))
- Add garbage collector trait [\#433](https://github.com/apache/camel-k/pull/433) ([astefanutti](https://github.com/astefanutti))
- Fix operator leader election [\#430](https://github.com/apache/camel-k/pull/430) ([astefanutti](https://github.com/astefanutti))
- Deactivate Downloading/Downloaded Maven log messages from CI build [\#429](https://github.com/apache/camel-k/pull/429) ([astefanutti](https://github.com/astefanutti))
- Set Maven batch mode for CI Maven build [\#428](https://github.com/apache/camel-k/pull/428) ([astefanutti](https://github.com/astefanutti))
- chore\(catalog\): reduce build\_catalog.sh verbosity [\#427](https://github.com/apache/camel-k/pull/427) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade operator SDK to version 0.5.0 [\#426](https://github.com/apache/camel-k/pull/426) ([astefanutti](https://github.com/astefanutti))
- chore\(runtime\): prepare for deployment [\#425](https://github.com/apache/camel-k/pull/425) ([lburgazzoli](https://github.com/lburgazzoli))
- feature\(kamel\): Validate --context when given [\#423](https://github.com/apache/camel-k/pull/423) ([rhuss](https://github.com/rhuss))
- Support transfering annotations and labels from an integration onto o… [\#422](https://github.com/apache/camel-k/pull/422) ([astefanutti](https://github.com/astefanutti))
- enhancement\(runtime\): improve runtime lifecycle handling [\#420](https://github.com/apache/camel-k/pull/420) ([lburgazzoli](https://github.com/lburgazzoli))
- Fixed --property flag, now commas can be used inside flag's value. [\#418](https://github.com/apache/camel-k/pull/418) ([valdar](https://github.com/valdar))
- Moved route loading of jvm-runtime inside a Listner to load them afte… [\#417](https://github.com/apache/camel-k/pull/417) ([valdar](https://github.com/valdar))
- chore\(runtime\): update dependencies [\#416](https://github.com/apache/camel-k/pull/416) ([lburgazzoli](https://github.com/lburgazzoli))
- Resolve camel catalog from custom resource [\#415](https://github.com/apache/camel-k/pull/415) ([lburgazzoli](https://github.com/lburgazzoli))
- runtime: ensure that the generated project uses the right camel version [\#413](https://github.com/apache/camel-k/pull/413) ([lburgazzoli](https://github.com/lburgazzoli))
- Renamed RuntimeTrait in ContextCustomizer since the name clashed and … [\#412](https://github.com/apache/camel-k/pull/412) ([valdar](https://github.com/valdar))
- chore\(lint\): fix lint fidings and standardize traits initialization [\#411](https://github.com/apache/camel-k/pull/411) ([lburgazzoli](https://github.com/lburgazzoli))
- fix context.Context misuse [\#410](https://github.com/apache/camel-k/pull/410) ([lburgazzoli](https://github.com/lburgazzoli))
- camel-knative: support for cloud events specs v0.2 [\#409](https://github.com/apache/camel-k/pull/409) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix CSV map string parsing [\#408](https://github.com/apache/camel-k/pull/408) ([astefanutti](https://github.com/astefanutti))
- Add an option to deactivate ServiceMonitor resource creation in Prome… [\#407](https://github.com/apache/camel-k/pull/407) ([astefanutti](https://github.com/astefanutti))
- The example RestWithRestlet does not work calling its service via curl or webbrowser [\#406](https://github.com/apache/camel-k/pull/406) ([lburgazzoli](https://github.com/lburgazzoli))
- Default OpenShift proxy client principal in Jolokia trait [\#405](https://github.com/apache/camel-k/pull/405) ([astefanutti](https://github.com/astefanutti))
- Update Jolokia trait documentation [\#404](https://github.com/apache/camel-k/pull/404) ([astefanutti](https://github.com/astefanutti))
- Factorize CSV map string parsing [\#403](https://github.com/apache/camel-k/pull/403) ([astefanutti](https://github.com/astefanutti))
- Improve error handling while parsing Prometheus service monitor labels [\#401](https://github.com/apache/camel-k/pull/401) ([astefanutti](https://github.com/astefanutti))
- Jolokia trait configuration maps JVM agent options directly [\#400](https://github.com/apache/camel-k/pull/400) ([astefanutti](https://github.com/astefanutti))
- chore\(maven\): simplify maven model [\#399](https://github.com/apache/camel-k/pull/399) ([lburgazzoli](https://github.com/lburgazzoli))
- Fixed array index out of boun that would kill camel-k operator in case of a malformed --dependency [\#396](https://github.com/apache/camel-k/pull/396) ([valdar](https://github.com/valdar))
- Fix comment about multi-valuated CLI trait configuration option [\#392](https://github.com/apache/camel-k/pull/392) ([astefanutti](https://github.com/astefanutti))
- Use named target ports in integration service [\#391](https://github.com/apache/camel-k/pull/391) ([astefanutti](https://github.com/astefanutti))
- Add Prometheus ServiceMonitor labels trait configuration [\#390](https://github.com/apache/camel-k/pull/390) ([astefanutti](https://github.com/astefanutti))
- Fixed AddDependency in integration\_type\_support.go to handle default … [\#389](https://github.com/apache/camel-k/pull/389) ([valdar](https://github.com/valdar))
- Aggregate multiple occurences of the same run command CLI option into… [\#388](https://github.com/apache/camel-k/pull/388) ([astefanutti](https://github.com/astefanutti))
- Add container ports to integration deployment [\#387](https://github.com/apache/camel-k/pull/387) ([astefanutti](https://github.com/astefanutti))
- Automatically apply defaults to platform configuration \#365 [\#386](https://github.com/apache/camel-k/pull/386) ([lburgazzoli](https://github.com/lburgazzoli))
- Use consistent logging style [\#385](https://github.com/apache/camel-k/pull/385) ([lburgazzoli](https://github.com/lburgazzoli))
- Service and Prometheus traits aggregate into a single service per int… [\#382](https://github.com/apache/camel-k/pull/382) ([astefanutti](https://github.com/astefanutti))
- Fix trait properties to kebab case [\#381](https://github.com/apache/camel-k/pull/381) ([astefanutti](https://github.com/astefanutti))
- Deactivate the Prometheus agent in trait Apply instead of Configure [\#380](https://github.com/apache/camel-k/pull/380) ([astefanutti](https://github.com/astefanutti))
- chore\(s2i\): update base image to 3.0-java8 [\#379](https://github.com/apache/camel-k/pull/379) ([lburgazzoli](https://github.com/lburgazzoli))
- runtime: simplify loader development [\#378](https://github.com/apache/camel-k/pull/378) ([lburgazzoli](https://github.com/lburgazzoli))
- Failed to resolve endpoint: twitter-search [\#377](https://github.com/apache/camel-k/pull/377) ([lburgazzoli](https://github.com/lburgazzoli))
- Jolokia trait initial implementation [\#375](https://github.com/apache/camel-k/pull/375) ([astefanutti](https://github.com/astefanutti))
- Configure Prometheus agent port based on trait property [\#373](https://github.com/apache/camel-k/pull/373) ([astefanutti](https://github.com/astefanutti))
- Added a commit to explain why duoble trait.apply is used in RuntimeSu… [\#372](https://github.com/apache/camel-k/pull/372) ([valdar](https://github.com/valdar))
- runtime: improve discovery and configuration of runtime traits [\#371](https://github.com/apache/camel-k/pull/371) ([lburgazzoli](https://github.com/lburgazzoli))
- Activate the Prometheus Java agent according to the eponym trait conf… [\#368](https://github.com/apache/camel-k/pull/368) ([astefanutti](https://github.com/astefanutti))
- chore\(deps\): update kotlin to v1.3.20 [\#367](https://github.com/apache/camel-k/pull/367) ([lburgazzoli](https://github.com/lburgazzoli))
- Prometheus trait initial implementation [\#364](https://github.com/apache/camel-k/pull/364) ([astefanutti](https://github.com/astefanutti))
- chore\(release\): add publisher to makefile [\#360](https://github.com/apache/camel-k/pull/360) ([nicolaferraro](https://github.com/nicolaferraro))
- Allow to configure the location fo the local maven repo [\#359](https://github.com/apache/camel-k/pull/359) ([lburgazzoli](https://github.com/lburgazzoli))
- kamel stuck when a secret has an illegal name [\#357](https://github.com/apache/camel-k/pull/357) ([lburgazzoli](https://github.com/lburgazzoli))
- Enable status subresource for integration [\#352](https://github.com/apache/camel-k/pull/352) ([astefanutti](https://github.com/astefanutti))
- build handlers: split buld step in two phases: submit and run [\#351](https://github.com/apache/camel-k/pull/351) ([lburgazzoli](https://github.com/lburgazzoli))
- fix openapi handling when used in conjunction with deployment.container-image=true [\#350](https://github.com/apache/camel-k/pull/350) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: regenerated resources.go [\#349](https://github.com/apache/camel-k/pull/349) ([rhuss](https://github.com/rhuss))
- fix\(kamel log\): Use integration name for looking up containers [\#348](https://github.com/apache/camel-k/pull/348) ([rhuss](https://github.com/rhuss))
- Integration/IntegrationContext builds sometimes fail [\#346](https://github.com/apache/camel-k/pull/346) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(contributing.adoc\): Add explanation to add KOTLIN\_JDK\_HOME for building on MacOs [\#344](https://github.com/apache/camel-k/pull/344) ([rhuss](https://github.com/rhuss))
- builder: add hooks to the builder state changes to update resources when the build completes [\#343](https://github.com/apache/camel-k/pull/343) ([lburgazzoli](https://github.com/lburgazzoli))
- Allow to configure the base image used to run integrations [\#341](https://github.com/apache/camel-k/pull/341) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade Jackson to version 2.9.8 [\#339](https://github.com/apache/camel-k/pull/339) ([oscerd](https://github.com/oscerd))
- Bump to Camel 2.23.1 [\#337](https://github.com/apache/camel-k/pull/337) ([oscerd](https://github.com/oscerd))
- Some Knative improvements [\#336](https://github.com/apache/camel-k/pull/336) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix bug in compression utils [\#335](https://github.com/apache/camel-k/pull/335) ([nicolaferraro](https://github.com/nicolaferraro))
- openapi: fix automatic service configuration [\#333](https://github.com/apache/camel-k/pull/333) ([lburgazzoli](https://github.com/lburgazzoli))
- Add a state to integrations waiting for platform to be ready [\#332](https://github.com/apache/camel-k/pull/332) ([lburgazzoli](https://github.com/lburgazzoli))
- Add a -w flag to kamel install [\#331](https://github.com/apache/camel-k/pull/331) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: refactor source inspector [\#329](https://github.com/apache/camel-k/pull/329) ([lburgazzoli](https://github.com/lburgazzoli))
- support for openapi/swagger  [\#328](https://github.com/apache/camel-k/pull/328) ([lburgazzoli](https://github.com/lburgazzoli))
- create camel-k-maven-plugin [\#326](https://github.com/apache/camel-k/pull/326) ([lburgazzoli](https://github.com/lburgazzoli))
- Release some predefined images for Knative [\#325](https://github.com/apache/camel-k/pull/325) ([nicolaferraro](https://github.com/nicolaferraro))
- Runtime dep upgrade [\#321](https://github.com/apache/camel-k/pull/321) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(ux\): show the same basic info with oc and kamel [\#320](https://github.com/apache/camel-k/pull/320) ([lburgazzoli](https://github.com/lburgazzoli))
- Allow to customize contexts create at installation [\#319](https://github.com/apache/camel-k/pull/319) ([lburgazzoli](https://github.com/lburgazzoli))
- Option to create an Integration Context from an existing image [\#317](https://github.com/apache/camel-k/pull/317) ([lburgazzoli](https://github.com/lburgazzoli))
- Migrate to operator-sdk 0.3.0 [\#315](https://github.com/apache/camel-k/pull/315) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(knative\): do not change spec during processing [\#314](https://github.com/apache/camel-k/pull/314) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(knative\): improvements for creating Knative CamelSources [\#313](https://github.com/apache/camel-k/pull/313) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(client\): add a reset command [\#310](https://github.com/apache/camel-k/pull/310) ([nicolaferraro](https://github.com/nicolaferraro))
- Remove the "./" prefix before sanitizing the integration name. [\#309](https://github.com/apache/camel-k/pull/309) ([crystaldust](https://github.com/crystaldust))
- runtime: add support for a simple yaml flow [\#308](https://github.com/apache/camel-k/pull/308) ([lburgazzoli](https://github.com/lburgazzoli))
- Display relevant custom columns [\#304](https://github.com/apache/camel-k/pull/304) ([lburgazzoli](https://github.com/lburgazzoli))
- catalog : include camel-k components [\#303](https://github.com/apache/camel-k/pull/303) ([lburgazzoli](https://github.com/lburgazzoli))
- add resources to an integration [\#300](https://github.com/apache/camel-k/pull/300) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(runtime\): try to lookup routes loaders from registry first, then from resources/services [\#298](https://github.com/apache/camel-k/pull/298) ([lburgazzoli](https://github.com/lburgazzoli))
- Platform options  [\#296](https://github.com/apache/camel-k/pull/296) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(release\): package examples to publish them during release [\#295](https://github.com/apache/camel-k/pull/295) ([nicolaferraro](https://github.com/nicolaferraro))
- Allow to generate install resources if needed [\#294](https://github.com/apache/camel-k/pull/294) ([nicolaferraro](https://github.com/nicolaferraro))
- Re-add missing commits [\#293](https://github.com/apache/camel-k/pull/293) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(log\): make dev-mode work in Knative [\#280](https://github.com/apache/camel-k/pull/280) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#221: use registry name instead of IP in Knative on Openshift [\#278](https://github.com/apache/camel-k/pull/278) ([nicolaferraro](https://github.com/nicolaferraro))
- Determine active/passive endpoints from Catalog [\#277](https://github.com/apache/camel-k/pull/277) ([lburgazzoli](https://github.com/lburgazzoli))
- trait: add a trait to inject pod metadata as env var [\#276](https://github.com/apache/camel-k/pull/276) ([lburgazzoli](https://github.com/lburgazzoli))
- Traits lifecycle [\#273](https://github.com/apache/camel-k/pull/273) ([lburgazzoli](https://github.com/lburgazzoli))
- Allow using compressed sources in Knative profile [\#272](https://github.com/apache/camel-k/pull/272) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(deps\): update kotlin to v1.3.11 [\#271](https://github.com/apache/camel-k/pull/271) ([lburgazzoli](https://github.com/lburgazzoli))
- builder: wake up event loop when the container image buils is done to seep up deployment time [\#269](https://github.com/apache/camel-k/pull/269) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: rename constant KamelPlatform to IntegrationContextTypePlatform [\#267](https://github.com/apache/camel-k/pull/267) ([lburgazzoli](https://github.com/lburgazzoli))
- Support for compressed source blob  [\#266](https://github.com/apache/camel-k/pull/266) ([lburgazzoli](https://github.com/lburgazzoli))
- Better Knative and Istio integration [\#261](https://github.com/apache/camel-k/pull/261) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(runtime\): code cleanup [\#260](https://github.com/apache/camel-k/pull/260) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: add all sorts of linters and pre-commit hook [\#257](https://github.com/apache/camel-k/pull/257) ([zregvart](https://github.com/zregvart))
- Update runtime dependencies [\#256](https://github.com/apache/camel-k/pull/256) ([lburgazzoli](https://github.com/lburgazzoli))
- add an option to always generate a docker image [\#253](https://github.com/apache/camel-k/pull/253) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: add debug trait [\#252](https://github.com/apache/camel-k/pull/252) ([zregvart](https://github.com/zregvart))
- runtime\(springboot\): set the exact list of dependencies used by spring boot instead of use everithing in the dependencies folder [\#251](https://github.com/apache/camel-k/pull/251) ([lburgazzoli](https://github.com/lburgazzoli))
- Update dependencies [\#250](https://github.com/apache/camel-k/pull/250) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: support for computing knative channel/service host name from uri [\#248](https://github.com/apache/camel-k/pull/248) ([lburgazzoli](https://github.com/lburgazzoli))
- Allow to push to Knative channels [\#247](https://github.com/apache/camel-k/pull/247) ([nicolaferraro](https://github.com/nicolaferraro))
- small adjustments to README [\#245](https://github.com/apache/camel-k/pull/245) ([onderson](https://github.com/onderson))
- typo [\#244](https://github.com/apache/camel-k/pull/244) ([davsclaus](https://github.com/davsclaus))
- Fixing some govet findings [\#243](https://github.com/apache/camel-k/pull/243) ([oscerd](https://github.com/oscerd))
- Make go-report happy again with gofmt [\#242](https://github.com/apache/camel-k/pull/242) ([oscerd](https://github.com/oscerd))
- support for spring boot [\#239](https://github.com/apache/camel-k/pull/239) ([lburgazzoli](https://github.com/lburgazzoli))
- initial support for custom maven repositories [\#238](https://github.com/apache/camel-k/pull/238) ([lburgazzoli](https://github.com/lburgazzoli))
- Trigger context update when build finishes [\#236](https://github.com/apache/camel-k/pull/236) ([lburgazzoli](https://github.com/lburgazzoli))
- Support for multiple integration definitions [\#235](https://github.com/apache/camel-k/pull/235) ([lburgazzoli](https://github.com/lburgazzoli))
- runtime: add a netty4-http based knative component [\#234](https://github.com/apache/camel-k/pull/234) ([lburgazzoli](https://github.com/lburgazzoli))
- trait: add builder trait [\#233](https://github.com/apache/camel-k/pull/233) ([lburgazzoli](https://github.com/lburgazzoli))
- Make it work on GKE [\#232](https://github.com/apache/camel-k/pull/232) ([nicolaferraro](https://github.com/nicolaferraro))
- temporary build folder not cleaned up [\#231](https://github.com/apache/camel-k/pull/231) ([lburgazzoli](https://github.com/lburgazzoli))
- refactor: make traits more flexible [\#229](https://github.com/apache/camel-k/pull/229) ([lburgazzoli](https://github.com/lburgazzoli))
- Bump version to 0.0.6-SNAPSHOT [\#228](https://github.com/apache/camel-k/pull/228) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix kaniko build [\#227](https://github.com/apache/camel-k/pull/227) ([nicolaferraro](https://github.com/nicolaferraro))
- runtime: small improvement to the dependency lister plugin [\#225](https://github.com/apache/camel-k/pull/225) ([lburgazzoli](https://github.com/lburgazzoli))
- new builder [\#223](https://github.com/apache/camel-k/pull/223) ([lburgazzoli](https://github.com/lburgazzoli))
- Update deps and cleanup [\#217](https://github.com/apache/camel-k/pull/217) ([lburgazzoli](https://github.com/lburgazzoli))
- Add base support for Knative eventing [\#215](https://github.com/apache/camel-k/pull/215) ([nicolaferraro](https://github.com/nicolaferraro))
- Add first Knative trait and profiles [\#210](https://github.com/apache/camel-k/pull/210) ([nicolaferraro](https://github.com/nicolaferraro))
- feat: \#207 Provide option to get the Json/Yaml of a integration [\#208](https://github.com/apache/camel-k/pull/208) ([chirino](https://github.com/chirino))
- cloudevents & knative [\#204](https://github.com/apache/camel-k/pull/204) ([lburgazzoli](https://github.com/lburgazzoli))
- Added some traits and full refactoring [\#203](https://github.com/apache/camel-k/pull/203) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix compatibility with operator sdk 0.0.7 [\#202](https://github.com/apache/camel-k/pull/202) ([nicolaferraro](https://github.com/nicolaferraro))
- Cannot configure traits [\#200](https://github.com/apache/camel-k/pull/200) ([lburgazzoli](https://github.com/lburgazzoli))
- \(chore\) add an example of xml route [\#198](https://github.com/apache/camel-k/pull/198) ([nicolaferraro](https://github.com/nicolaferraro))
- Use a working kaniko sha [\#197](https://github.com/apache/camel-k/pull/197) ([nicolaferraro](https://github.com/nicolaferraro))
- runtime\(kotline\): update to kotlin 1.3.0 release [\#195](https://github.com/apache/camel-k/pull/195) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix installation on new cluster and upgrade operator sdk [\#193](https://github.com/apache/camel-k/pull/193) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix CI Job [\#192](https://github.com/apache/camel-k/pull/192) ([nicolaferraro](https://github.com/nicolaferraro))
- misc runtime fixes and improvements [\#191](https://github.com/apache/camel-k/pull/191) ([lburgazzoli](https://github.com/lburgazzoli))
- corrected minor spelling or wrong language reference \(Kotlin-\>JavaScript\) [\#187](https://github.com/apache/camel-k/pull/187) ([marcellanz](https://github.com/marcellanz))
- kamel run --dev mode terminate pod if pressing ctrl + c  [\#186](https://github.com/apache/camel-k/pull/186) ([dmvolod](https://github.com/dmvolod))
- chore\(logging\): move log colouring definition to runtime [\#181](https://github.com/apache/camel-k/pull/181) ([lburgazzoli](https://github.com/lburgazzoli))
- camel-http4 not recognized automatically [\#180](https://github.com/apache/camel-k/pull/180) ([lburgazzoli](https://github.com/lburgazzoli))
- Add log command [\#179](https://github.com/apache/camel-k/pull/179) ([lburgazzoli](https://github.com/lburgazzoli))
- configure camel context from properties [\#178](https://github.com/apache/camel-k/pull/178) ([lburgazzoli](https://github.com/lburgazzoli))
- Misc fixing [\#177](https://github.com/apache/camel-k/pull/177) ([lburgazzoli](https://github.com/lburgazzoli))
- operator: swich to type safe trait definition [\#176](https://github.com/apache/camel-k/pull/176) ([lburgazzoli](https://github.com/lburgazzoli))
- runtime\(groovy\) : improve registry dsl [\#170](https://github.com/apache/camel-k/pull/170) ([lburgazzoli](https://github.com/lburgazzoli))
- Regenerate code, deps and fixes [\#166](https://github.com/apache/camel-k/pull/166) ([lburgazzoli](https://github.com/lburgazzoli))
- Ci integration tests [\#165](https://github.com/apache/camel-k/pull/165) ([nicolaferraro](https://github.com/nicolaferraro))
- Add travis build info [\#163](https://github.com/apache/camel-k/pull/163) ([nicolaferraro](https://github.com/nicolaferraro))
- \(chore\) Add gitter badge [\#162](https://github.com/apache/camel-k/pull/162) ([nicolaferraro](https://github.com/nicolaferraro))
- Add initial support for traits [\#160](https://github.com/apache/camel-k/pull/160) ([nicolaferraro](https://github.com/nicolaferraro))
- Make goReport happy, again [\#159](https://github.com/apache/camel-k/pull/159) ([oscerd](https://github.com/oscerd))
- Minor fix in the order of operation for sanitizing integration name [\#158](https://github.com/apache/camel-k/pull/158) ([oscerd](https://github.com/oscerd))
- runtime: refine groovy dsl [\#157](https://github.com/apache/camel-k/pull/157) ([lburgazzoli](https://github.com/lburgazzoli))
- Add option to run from URL [\#156](https://github.com/apache/camel-k/pull/156) ([oscerd](https://github.com/oscerd))
- doc: add initial documentation about integration DSLs [\#155](https://github.com/apache/camel-k/pull/155) ([lburgazzoli](https://github.com/lburgazzoli))
- \(chore\): use operator-sdk master and fix tests [\#154](https://github.com/apache/camel-k/pull/154) ([nicolaferraro](https://github.com/nicolaferraro))
- runtime: improve rest dsl for groovy and kotlin runtimes [\#152](https://github.com/apache/camel-k/pull/152) ([lburgazzoli](https://github.com/lburgazzoli))
- runtime: improve kotlin dsl [\#151](https://github.com/apache/camel-k/pull/151) ([lburgazzoli](https://github.com/lburgazzoli))
- runtime: improve groovy dsl [\#150](https://github.com/apache/camel-k/pull/150) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: compile integration tests on make [\#149](https://github.com/apache/camel-k/pull/149) ([nicolaferraro](https://github.com/nicolaferraro))
- runtime: enhance groovy dsl [\#148](https://github.com/apache/camel-k/pull/148) ([lburgazzoli](https://github.com/lburgazzoli))
- Added Maven Wrapper [\#147](https://github.com/apache/camel-k/pull/147) ([oscerd](https://github.com/oscerd))
- Added vendor directory to avoid dep ensure [\#145](https://github.com/apache/camel-k/pull/145) ([oscerd](https://github.com/oscerd))
- chore: small improvement to groovy dls [\#144](https://github.com/apache/camel-k/pull/144) ([lburgazzoli](https://github.com/lburgazzoli))
- Added an example of binding object in Camel registry in groovy [\#143](https://github.com/apache/camel-k/pull/143) ([oscerd](https://github.com/oscerd))
- Add initial implementation of a DSL to bind object to camel registry [\#141](https://github.com/apache/camel-k/pull/141) ([lburgazzoli](https://github.com/lburgazzoli))
- Use properties to configure components and logging [\#140](https://github.com/apache/camel-k/pull/140) ([lburgazzoli](https://github.com/lburgazzoli))
- Add support for plain Kubernetes [\#138](https://github.com/apache/camel-k/pull/138) ([nicolaferraro](https://github.com/nicolaferraro))
- Polish and make go-report happy [\#134](https://github.com/apache/camel-k/pull/134) ([oscerd](https://github.com/oscerd))
- runtime: support for kotlin runtime [\#133](https://github.com/apache/camel-k/pull/133) ([lburgazzoli](https://github.com/lburgazzoli))
- Defer cancel function call returned by WithDeadline in tests [\#131](https://github.com/apache/camel-k/pull/131) ([oscerd](https://github.com/oscerd))
- Remove unreachable code in pod\_scraper.go [\#130](https://github.com/apache/camel-k/pull/130) ([oscerd](https://github.com/oscerd))
- Dead link in Developer's guide "runtime" [\#129](https://github.com/apache/camel-k/pull/129) ([oscerd](https://github.com/oscerd))
- Report correct build status in case of failure [\#128](https://github.com/apache/camel-k/pull/128) ([oscerd](https://github.com/oscerd))
- Add IntegrationPlatform resource [\#126](https://github.com/apache/camel-k/pull/126) ([nicolaferraro](https://github.com/nicolaferraro))
- Avoid deprecated addRoutes \(replaced by includeRoutes\) [\#123](https://github.com/apache/camel-k/pull/123) ([apupier](https://github.com/apupier))
- Fix "typo" Openshift -\> OpenShift [\#122](https://github.com/apache/camel-k/pull/122) ([apupier](https://github.com/apupier))
- Add bindings for rest dsl in groovy/js routes [\#120](https://github.com/apache/camel-k/pull/120) ([lburgazzoli](https://github.com/lburgazzoli))
- Groovy regression [\#119](https://github.com/apache/camel-k/pull/119) ([lburgazzoli](https://github.com/lburgazzoli))
- Speed up s2i a little bit [\#112](https://github.com/apache/camel-k/pull/112) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(kamel\): improve completion and context delete [\#111](https://github.com/apache/camel-k/pull/111) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(dep\): remove dependency on yaml.v1 [\#110](https://github.com/apache/camel-k/pull/110) ([lburgazzoli](https://github.com/lburgazzoli))
- Add asciidoc documentation with sub-documents and some badges [\#109](https://github.com/apache/camel-k/pull/109) ([nicolaferraro](https://github.com/nicolaferraro))
- Refactor build, deploy and run workflow [\#107](https://github.com/apache/camel-k/pull/107) ([lburgazzoli](https://github.com/lburgazzoli))
- Bump version to 0.0.3-SNAPSHOT [\#105](https://github.com/apache/camel-k/pull/105) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix golint findings, remove unused code [\#103](https://github.com/apache/camel-k/pull/103) ([lburgazzoli](https://github.com/lburgazzoli))
- feat\(examples\): Add a Camel-caffeine Cache java sample [\#101](https://github.com/apache/camel-k/pull/101) ([oscerd](https://github.com/oscerd))
- Add delete integration option [\#100](https://github.com/apache/camel-k/pull/100) ([dmvolod](https://github.com/dmvolod))
- chore: refactor pkg/build to a more idiomatic structure [\#99](https://github.com/apache/camel-k/pull/99) ([lburgazzoli](https://github.com/lburgazzoli))
- Auto-discover dependencies [\#98](https://github.com/apache/camel-k/pull/98) ([nicolaferraro](https://github.com/nicolaferraro))
- Embed camel catalog [\#95](https://github.com/apache/camel-k/pull/95) ([lburgazzoli](https://github.com/lburgazzoli))
- Add sync and dev mode [\#92](https://github.com/apache/camel-k/pull/92) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(cobra\): add autocompletion for configmap and secrets [\#91](https://github.com/apache/camel-k/pull/91) ([lburgazzoli](https://github.com/lburgazzoli))
- Simplify install and update readme [\#88](https://github.com/apache/camel-k/pull/88) ([nicolaferraro](https://github.com/nicolaferraro))
- kamel install with sample [\#87](https://github.com/apache/camel-k/pull/87) ([dmvolod](https://github.com/dmvolod))
- Pod log implementation [\#86](https://github.com/apache/camel-k/pull/86) ([nicolaferraro](https://github.com/nicolaferraro))
- Added make install-minishift command to build [\#83](https://github.com/apache/camel-k/pull/83) ([oscerd](https://github.com/oscerd))
- Minot improvements to kamel client [\#81](https://github.com/apache/camel-k/pull/81) ([lburgazzoli](https://github.com/lburgazzoli))
- jvm: improve language detection [\#79](https://github.com/apache/camel-k/pull/79) ([lburgazzoli](https://github.com/lburgazzoli))
- Context handling improvement [\#76](https://github.com/apache/camel-k/pull/76) ([lburgazzoli](https://github.com/lburgazzoli))
- Add release commands and bump to 0.0.2-SNAPSHOT [\#72](https://github.com/apache/camel-k/pull/72) ([nicolaferraro](https://github.com/nicolaferraro))
- Add support for XML routes [\#71](https://github.com/apache/camel-k/pull/71) ([lburgazzoli](https://github.com/lburgazzoli))
- Support for integration configuration [\#68](https://github.com/apache/camel-k/pull/68) ([lburgazzoli](https://github.com/lburgazzoli))
- kamel run runtime/examples/Sample.java fails with java.lang.NoClassDefFoundError [\#64](https://github.com/apache/camel-k/pull/64) ([lburgazzoli](https://github.com/lburgazzoli))
-  Fix tests and add release scripts up to cross-compilation [\#63](https://github.com/apache/camel-k/pull/63) ([nicolaferraro](https://github.com/nicolaferraro))
- Allow buildless direct deploy [\#61](https://github.com/apache/camel-k/pull/61) ([lburgazzoli](https://github.com/lburgazzoli))
- Add a wait option to kamel run [\#56](https://github.com/apache/camel-k/pull/56) ([nicolaferraro](https://github.com/nicolaferraro))
- Store integration code in a configmap [\#55](https://github.com/apache/camel-k/pull/55) ([lburgazzoli](https://github.com/lburgazzoli))
- kamel run should support adding dependencies [\#53](https://github.com/apache/camel-k/pull/53) ([lburgazzoli](https://github.com/lburgazzoli))
- Unable to reinstall the operator fixes \#43 [\#50](https://github.com/apache/camel-k/pull/50) ([dmvolod](https://github.com/dmvolod))
- Support set integration name for kamel run [\#48](https://github.com/apache/camel-k/pull/48) ([oscerd](https://github.com/oscerd))
- Route loaders should derive language from 'kamel run --language' \#46 [\#47](https://github.com/apache/camel-k/pull/47) ([lburgazzoli](https://github.com/lburgazzoli))
- add support for non java integrations [\#39](https://github.com/apache/camel-k/pull/39) ([lburgazzoli](https://github.com/lburgazzoli))
-  Adding contributing guide [\#29](https://github.com/apache/camel-k/pull/29) ([nicolaferraro](https://github.com/nicolaferraro))
- Bump Camel to version 2.22.1 [\#28](https://github.com/apache/camel-k/pull/28) ([oscerd](https://github.com/oscerd))
- generate pom using go's xml encoder [\#27](https://github.com/apache/camel-k/pull/27) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix typo in print integration context [\#26](https://github.com/apache/camel-k/pull/26) ([dmvolod](https://github.com/dmvolod))
- Changed log message in Sample.java in order to really rocks! [\#25](https://github.com/apache/camel-k/pull/25) ([valdar](https://github.com/valdar))
- initial code for integration context [\#24](https://github.com/apache/camel-k/pull/24) ([lburgazzoli](https://github.com/lburgazzoli))
- Add label to service [\#23](https://github.com/apache/camel-k/pull/23) ([dmvolod](https://github.com/dmvolod))
- CAMEL-12789: complete install command [\#22](https://github.com/apache/camel-k/pull/22) ([nicolaferraro](https://github.com/nicolaferraro))
- Add labels to all resources [\#21](https://github.com/apache/camel-k/pull/21) ([dmvolod](https://github.com/dmvolod))
- CAMEL-12798: Add getting started guide [\#20](https://github.com/apache/camel-k/pull/20) ([nicolaferraro](https://github.com/nicolaferraro))
- runtime: add support for groovy [\#19](https://github.com/apache/camel-k/pull/19) ([lburgazzoli](https://github.com/lburgazzoli))
- Installation and run works [\#18](https://github.com/apache/camel-k/pull/18) ([nicolaferraro](https://github.com/nicolaferraro))
- t code [\#17](https://github.com/apache/camel-k/pull/17) ([lburgazzoli](https://github.com/lburgazzoli))
- README update [\#16](https://github.com/apache/camel-k/pull/16) ([oscerd](https://github.com/oscerd))
- Dep version Readme [\#15](https://github.com/apache/camel-k/pull/15) ([oscerd](https://github.com/oscerd))
- add clean and dep target to Makefile [\#14](https://github.com/apache/camel-k/pull/14) ([lburgazzoli](https://github.com/lburgazzoli))
- Update readme fix typos [\#12](https://github.com/apache/camel-k/pull/12) ([onderson](https://github.com/onderson))
- Added build documentation. [\#11](https://github.com/apache/camel-k/pull/11) ([valdar](https://github.com/valdar))
- Use https instead of git for github.com/nicolaferraro/operator-sdk.git source [\#10](https://github.com/apache/camel-k/pull/10) ([dmvolod](https://github.com/dmvolod))
- Fix operator role to have lower privileges than the standard user and standardize command options [\#7](https://github.com/apache/camel-k/pull/7) ([nicolaferraro](https://github.com/nicolaferraro))
- Adding install and get commands [\#6](https://github.com/apache/camel-k/pull/6) ([nicolaferraro](https://github.com/nicolaferraro))
- Added Property placeholder for commons-lang3 version [\#5](https://github.com/apache/camel-k/pull/5) ([oscerd](https://github.com/oscerd))
- Minor refactor of client cmd [\#4](https://github.com/apache/camel-k/pull/4) ([lburgazzoli](https://github.com/lburgazzoli))
- swith to full in-memory java compiler and some minro cleanup [\#3](https://github.com/apache/camel-k/pull/3) ([lburgazzoli](https://github.com/lburgazzoli))
- Add bash completion [\#2](https://github.com/apache/camel-k/pull/2) ([lburgazzoli](https://github.com/lburgazzoli))
- Add support for .js, .java and classes [\#1](https://github.com/apache/camel-k/pull/1) ([lburgazzoli](https://github.com/lburgazzoli))

## [1.0.0-RC2](https://github.com/apache/camel-k/tree/1.0.0-RC2) (2020-02-24)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.0-RC1...1.0.0-RC2)

**Closed issues:**

- Buildah support [\#1256](https://github.com/apache/camel-k/issues/1256)
- Dead link from readme to trait documentation [\#1249](https://github.com/apache/camel-k/issues/1249)
- When using `camel-opentracing`, \<Log statement in routes.xml is getting logged twice [\#1240](https://github.com/apache/camel-k/issues/1240)
- Resource group endpoints is that a left over from old Camel version [\#1187](https://github.com/apache/camel-k/issues/1187)
- Private repository for dependent Library [\#1180](https://github.com/apache/camel-k/issues/1180)
- Trying to get sample RestWithUndertow working [\#1175](https://github.com/apache/camel-k/issues/1175)
- Abilty to disable sidecar injection in knative services [\#1173](https://github.com/apache/camel-k/issues/1173)
- Support for using ENV variables in kamel binary [\#1103](https://github.com/apache/camel-k/issues/1103)
- Get rid of json schema generation [\#1037](https://github.com/apache/camel-k/issues/1037)
- camel-k-maven-settings localRepository change is not working [\#1010](https://github.com/apache/camel-k/issues/1010)
- Error in jsonschema gen [\#561](https://github.com/apache/camel-k/issues/561)
- Provide config command for kamel [\#504](https://github.com/apache/camel-k/issues/504)
- Decouple traits from base image [\#394](https://github.com/apache/camel-k/issues/394)
- Automatically use Kubernetes-based master component [\#259](https://github.com/apache/camel-k/issues/259)
- Integrate with GolangCI [\#258](https://github.com/apache/camel-k/issues/258)
- add unit tests for traits [\#255](https://github.com/apache/camel-k/issues/255)
- Add uninstall command [\#38](https://github.com/apache/camel-k/issues/38)
- Resources are not replaced on install [\#1286](https://github.com/apache/camel-k/issues/1286)
- Release 1.0.0-RC2 [\#1273](https://github.com/apache/camel-k/issues/1273)
- Upgrade to Knative 0.12 [\#1270](https://github.com/apache/camel-k/issues/1270)
- Allow to inject data from externally crafted secrets [\#1261](https://github.com/apache/camel-k/issues/1261)
- Multiple Knative endpoint in the same route will cause the pod continuously restart  [\#1257](https://github.com/apache/camel-k/issues/1257)
- Add e2e tests for global installation mode [\#1255](https://github.com/apache/camel-k/issues/1255)
- Installation error: normal user can't delete consoleclidownloads [\#1242](https://github.com/apache/camel-k/issues/1242)
- Check exact Knative version before enabling serving [\#1237](https://github.com/apache/camel-k/issues/1237)
- Autodetect camel-bean [\#1236](https://github.com/apache/camel-k/issues/1236)
- Add a "master" trait [\#1234](https://github.com/apache/camel-k/issues/1234)
- Dev mode doesn't start if the integration is already running [\#1233](https://github.com/apache/camel-k/issues/1233)
- Kamel version should not try to connect to a cluster [\#1230](https://github.com/apache/camel-k/issues/1230)
- Remove the option to set the camel version [\#1229](https://github.com/apache/camel-k/issues/1229)
- Avoid installing operator when OLM reaources are present [\#1223](https://github.com/apache/camel-k/issues/1223)
- knative channel consumer stuck in running state [\#1222](https://github.com/apache/camel-k/issues/1222)
- kamel kit create returns error - result must be a pointer [\#1221](https://github.com/apache/camel-k/issues/1221)
- Integration builds takes lots of time [\#1209](https://github.com/apache/camel-k/issues/1209)
- Disabling traits does not reflect in camel-k  integration [\#1208](https://github.com/apache/camel-k/issues/1208)
- Camel K Validator Component hangs on URL input  [\#1207](https://github.com/apache/camel-k/issues/1207)
- Knative services are slow to become ready [\#1206](https://github.com/apache/camel-k/issues/1206)
- Change log that warns Knative users [\#1205](https://github.com/apache/camel-k/issues/1205)
- Slow build time on Minikube reported [\#1204](https://github.com/apache/camel-k/issues/1204)
- Offer easier access to trait list [\#1203](https://github.com/apache/camel-k/issues/1203)
- Allow easy switch between different controllers [\#1201](https://github.com/apache/camel-k/issues/1201)
- Handle concurrency in CronJob mode [\#1200](https://github.com/apache/camel-k/issues/1200)
- Provide more information when the integration fails at runtime [\#1199](https://github.com/apache/camel-k/issues/1199)
- Add build information when printing integration logs [\#1195](https://github.com/apache/camel-k/issues/1195)
- Add `kamel logs` alias [\#1194](https://github.com/apache/camel-k/issues/1194)
- Invalid JSON Patch error when running simple Camel-K example with 1.0.0-RC1 [\#1190](https://github.com/apache/camel-k/issues/1190)
- Add an init/scaffold subcommand [\#1188](https://github.com/apache/camel-k/issues/1188)
- Exiting dev mode returns non zero exit code [\#1183](https://github.com/apache/camel-k/issues/1183)
- Add native support for CronJobs [\#1182](https://github.com/apache/camel-k/issues/1182)
- Simplify user experience when using config file [\#1181](https://github.com/apache/camel-k/issues/1181)
- Knative integration takes too long to make the service ready [\#1172](https://github.com/apache/camel-k/issues/1172)
- kamel run --wait should return non-zero exit code in case of failure [\#1170](https://github.com/apache/camel-k/issues/1170)
- Add Knative Integration Tests on KinD [\#1162](https://github.com/apache/camel-k/issues/1162)
- Set the IntegrationConditionServiceNotAvailableReason only when the service trait is disabled [\#1149](https://github.com/apache/camel-k/issues/1149)
- Kamel run --property-file [\#1102](https://github.com/apache/camel-k/issues/1102)
- Auto detect Camel components via FQN classnames [\#1095](https://github.com/apache/camel-k/issues/1095)
- traits documentation - Make it clear how to specify 2 or more options [\#1093](https://github.com/apache/camel-k/issues/1093)
- Handle defaults differently \(aka do not change specs\) [\#778](https://github.com/apache/camel-k/issues/778)
- Package installation artifacts with Helm [\#167](https://github.com/apache/camel-k/issues/167)
- Execute e2e tests on vanilla Kubernetes [\#164](https://github.com/apache/camel-k/issues/164)

**Merged pull requests:**

- Buildah support [\#1259](https://github.com/apache/camel-k/pull/1259) ([astefanutti](https://github.com/astefanutti))

## [1.0.0-RC1](https://github.com/apache/camel-k/tree/1.0.0-RC1) (2019-12-20)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.0-M4...1.0.0-RC1)

**Closed issues:**

- Trying to get sample RestWithUndertow working. [\#1130](https://github.com/apache/camel-k/issues/1130)
- unable to execute basic Examples eg. Printer.groovy in GKE [\#1115](https://github.com/apache/camel-k/issues/1115)
- kamel scale integration to zero not possible [\#1094](https://github.com/apache/camel-k/issues/1094)
- kamel - Allow to configure memory and cpu settings [\#1091](https://github.com/apache/camel-k/issues/1091)
- Example Request: CamelJmsToFileExample.java [\#1079](https://github.com/apache/camel-k/issues/1079)
- No component found with scheme: http4 // Camel-k 1.0.0M4 [\#1072](https://github.com/apache/camel-k/issues/1072)
- Registry beans issues after upgrade from kamel 0.3.4 to kamel 1.0.0 M4 [\#1071](https://github.com/apache/camel-k/issues/1071)
- broken routes.js example [\#1065](https://github.com/apache/camel-k/issues/1065)
- camel-k installation struggles [\#1059](https://github.com/apache/camel-k/issues/1059)
- camel-k-maven-plugin must not contain any of these characters \/:"\<\>|?\* but found \> @ line 16, column 18 [\#1056](https://github.com/apache/camel-k/issues/1056)
- Automatically extract trait configuration for user manual [\#1014](https://github.com/apache/camel-k/issues/1014)
- Cannot set blockOwnerDeletion in this case because cannot find RESTMapping for APIVersion camel.apache.org/v1alpha1 Kind IntegrationKit [\#764](https://github.com/apache/camel-k/issues/764)
- Error creating integration context with buildStrategy: routine on minikube [\#665](https://github.com/apache/camel-k/issues/665)
- Kaniko: Add ability to push to on-premise registries [\#613](https://github.com/apache/camel-k/issues/613)
- \[quarkus\] in JVM mode we should no restrict the languages we can use [\#1154](https://github.com/apache/camel-k/issues/1154)
- In Kotlin example single quote needs to be replaced with double quotes [\#1145](https://github.com/apache/camel-k/issues/1145)
- \[gc\] cannot delete collection resource "daemonsets" [\#1140](https://github.com/apache/camel-k/issues/1140)
- Camel-k install on azure fails. [\#1138](https://github.com/apache/camel-k/issues/1138)
- Kamel CLI run from URL [\#1136](https://github.com/apache/camel-k/issues/1136)
- Ignore package when working with Java classes [\#1132](https://github.com/apache/camel-k/issues/1132)
- Review usage of version constraints [\#1126](https://github.com/apache/camel-k/issues/1126)
- Improve discovery of Knative on install [\#1125](https://github.com/apache/camel-k/issues/1125)
- Do not change spec in platform [\#1120](https://github.com/apache/camel-k/issues/1120)
- Knative event endpoints may be bidirectional [\#1119](https://github.com/apache/camel-k/issues/1119)
- Release 1.0.0-RC1 [\#1116](https://github.com/apache/camel-k/issues/1116)
- Upgrade to Knative 0.10.x serving v1 API and remove support for 0.8 [\#1112](https://github.com/apache/camel-k/issues/1112)
- Allow to configure kamel CLI with env vars and configuration files [\#1108](https://github.com/apache/camel-k/issues/1108)
- Defer detection of knative profile to when the integration runs [\#1089](https://github.com/apache/camel-k/issues/1089)
- Create camel-quarkus catalog for new release [\#1083](https://github.com/apache/camel-k/issues/1083)
- Update dev-mode documentation to use newer Camel log output [\#1081](https://github.com/apache/camel-k/issues/1081)
- error building image: getting stage builder for stage 0: MANIFEST\_UNKNOWN: "manifest unknown [\#1080](https://github.com/apache/camel-k/issues/1080)
- Remove requirement for PVC on vanilla Kube [\#1069](https://github.com/apache/camel-k/issues/1069)
- Hystrix detection should be changed when upgrading to Camel 3 GA [\#1058](https://github.com/apache/camel-k/issues/1058)
- Running without a platform [\#1047](https://github.com/apache/camel-k/issues/1047)
- Problems with incremental packager on Kaniko [\#998](https://github.com/apache/camel-k/issues/998)
- Moving api to v1 [\#921](https://github.com/apache/camel-k/issues/921)

**Merged pull requests:**

- feat\(build\): Task-based builds [\#1121](https://github.com/apache/camel-k/pull/1121) ([astefanutti](https://github.com/astefanutti))

## [1.0.0-M4](https://github.com/apache/camel-k/tree/1.0.0-M4) (2019-11-13)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.0-M3...1.0.0-M4)

**Closed issues:**

- Remove support for java class loader [\#1050](https://github.com/apache/camel-k/issues/1050)
- can't use a function processor with javascript [\#1035](https://github.com/apache/camel-k/issues/1035)
- Cannot push kit image to GCR \(or Docker.io\) during integration creation [\#1024](https://github.com/apache/camel-k/issues/1024)
- groovy.lang.MissingMethodException: No signature of method: Script1.context\(\) [\#1022](https://github.com/apache/camel-k/issues/1022)
- support for quarkus in JVM mode [\#990](https://github.com/apache/camel-k/issues/990)
- Release 1.0.0-M4 [\#1055](https://github.com/apache/camel-k/issues/1055)
- When kamel is launched from inside a container, it is using the serviceaccount of this container instead of the user configured in kubeconfig [\#1048](https://github.com/apache/camel-k/issues/1048)
- Changing trait config should lead to redeploy [\#1038](https://github.com/apache/camel-k/issues/1038)
- Generate full k8s client for provided APIs [\#1036](https://github.com/apache/camel-k/issues/1036)
- Avoid having failing builds during Apache Vote [\#1023](https://github.com/apache/camel-k/issues/1023)
- Write documentation for the release process [\#989](https://github.com/apache/camel-k/issues/989)
- Require go \>= 1.13 for development [\#981](https://github.com/apache/camel-k/issues/981)
- Automatically create catalogs from maven [\#744](https://github.com/apache/camel-k/issues/744)
- Do not rebuild knative integrations when changing sink [\#662](https://github.com/apache/camel-k/issues/662)

## [1.0.0-M3](https://github.com/apache/camel-k/tree/1.0.0-M3) (2019-10-18)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.0-M2...1.0.0-M3)

**Closed issues:**

- Failing start the camel-k-operator 1.0.0.-M3-SNAPSHOT with the minishifit [\#1015](https://github.com/apache/camel-k/issues/1015)
- Provide a plain text file with the latest version of Camel K for easier automation of downloading via the tooling [\#1009](https://github.com/apache/camel-k/issues/1009)
- Cannot use knative-source-yaml loader [\#1005](https://github.com/apache/camel-k/issues/1005)
- Pubilsh Camel K 1.0.0-M2 to operator hub [\#1004](https://github.com/apache/camel-k/issues/1004)
- remove integration delete action and finalizer [\#995](https://github.com/apache/camel-k/issues/995)
- kamel run fail: Get https://image-registry.openshift-image-registry.svc:5000/v2/: x509: certificate signed by unknown authority [\#994](https://github.com/apache/camel-k/issues/994)
- Permission Denied while creating a temporary dir on AWS EKS [\#971](https://github.com/apache/camel-k/issues/971)
- Starting a new integration in --dev mode and then starting it again without --dev mode leaves hanging process [\#946](https://github.com/apache/camel-k/issues/946)
- Help message of "camel context create" misleading [\#586](https://github.com/apache/camel-k/issues/586)
- Release Camel K 1.0.0-M3 [\#1020](https://github.com/apache/camel-k/issues/1020)
- Misleading version 1.0.0 in some Camel K runtime artifacts [\#1011](https://github.com/apache/camel-k/issues/1011)
- Allow explicit usage of apiVersion and kind in knative URIs [\#1008](https://github.com/apache/camel-k/issues/1008)
- Cannot configure slices in traits [\#997](https://github.com/apache/camel-k/issues/997)
- Add check for missing license headers in files [\#988](https://github.com/apache/camel-k/issues/988)
- Wrong knative roles installed in global mode [\#985](https://github.com/apache/camel-k/issues/985)
- Wrong behavior of global mode wrt kaniko cache warmer and platform [\#984](https://github.com/apache/camel-k/issues/984)
- Build operator image from non-Linux local OS [\#982](https://github.com/apache/camel-k/issues/982)
- Include camel-k-runtime version in camel-catalog [\#959](https://github.com/apache/camel-k/issues/959)
- Add Kamel CLI download link in OpenShift Web console [\#939](https://github.com/apache/camel-k/issues/939)

**Merged pull requests:**

- Kaniko cache warmer and platform multi-tenancy improvements [\#992](https://github.com/apache/camel-k/pull/992) ([astefanutti](https://github.com/astefanutti))
- chore\(build\): Auto cross-compile operator image binary from non-Linux local OS [\#987](https://github.com/apache/camel-k/pull/987) ([astefanutti](https://github.com/astefanutti))
- Add Kamel CLI download link to OpenShift Web console [\#983](https://github.com/apache/camel-k/pull/983) ([astefanutti](https://github.com/astefanutti))

## [1.0.0-M2](https://github.com/apache/camel-k/tree/1.0.0-M2) (2019-10-05)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.0-M1...1.0.0-M2)

**Closed issues:**

- Build completes OK but integration shows ERROR [\#965](https://github.com/apache/camel-k/issues/965)
- Monitoring kubectl for changes to integrations misses transition to error state [\#937](https://github.com/apache/camel-k/issues/937)
- Knative route from AWS S3 endpoint immediatly stops after starting [\#919](https://github.com/apache/camel-k/issues/919)
- Dev mode doesn't show if the build failed [\#906](https://github.com/apache/camel-k/issues/906)
- Road Map about Yaml DSL [\#902](https://github.com/apache/camel-k/issues/902)
- Issues with pre-published Kubernetes secret and Camel-K integration [\#900](https://github.com/apache/camel-k/issues/900)
- camel-k-kit-XXXXX is not able to inherit docker proxy configuration [\#899](https://github.com/apache/camel-k/issues/899)
- Camel-k-cache not able to create PVC \(pod has unbound immediate PersistentVolumeClaims\) [\#898](https://github.com/apache/camel-k/issues/898)
- Include modeline in examples [\#895](https://github.com/apache/camel-k/issues/895)
- Improve kamel "get" to enable specifying integration name [\#893](https://github.com/apache/camel-k/issues/893)
- Publish Camel K 1.0.0-M1 to operator hub [\#887](https://github.com/apache/camel-k/issues/887)
- Kamel reset should delete builds as well as kits [\#875](https://github.com/apache/camel-k/issues/875)
- BuildConfig's, ImageStream's and Pod's not labeled with camel-k and can't delete with -l 'app=camel-k' [\#840](https://github.com/apache/camel-k/issues/840)
- Orphan generated XML DSL from OpenAPI JSON after deleting integration [\#839](https://github.com/apache/camel-k/issues/839)
- All links of the documentation are missing spaces before and after displayed text [\#794](https://github.com/apache/camel-k/issues/794)
- Update Camel K tagline in Kamel CLI [\#732](https://github.com/apache/camel-k/issues/732)
- Review reset and delete with --all option for merging similar functions to one place  [\#598](https://github.com/apache/camel-k/issues/598)
- Able to run maven build with debug and/or extended info [\#85](https://github.com/apache/camel-k/issues/85)
- Remove references to host that did compilation in stacktraces [\#972](https://github.com/apache/camel-k/issues/972)
- Integration fails with --dev mode [\#968](https://github.com/apache/camel-k/issues/968)
- Kaniko step fails on Minikube with IncrementalPackager [\#960](https://github.com/apache/camel-k/issues/960)
- Upgrade to Camel 3.0.0-RC1 [\#956](https://github.com/apache/camel-k/issues/956)
- Upgrade to Knative 0.9 [\#952](https://github.com/apache/camel-k/issues/952)
- Permission error on a OpenStack/Cinder persistent volume while creating a temporary dir [\#947](https://github.com/apache/camel-k/issues/947)
- Merge all binaries into a single one [\#945](https://github.com/apache/camel-k/issues/945)
- Release Camel K 1.0.0-M2 [\#944](https://github.com/apache/camel-k/issues/944)
- Allow to run integrations in Tekton pipelines [\#942](https://github.com/apache/camel-k/issues/942)
- kamel get still has a column for 'Context' [\#941](https://github.com/apache/camel-k/issues/941)
- routes.yaml example fails with NoSuchLanguageException [\#929](https://github.com/apache/camel-k/issues/929)
- Can't use operator global mode [\#920](https://github.com/apache/camel-k/issues/920)
- Kamel run fails on Google Cloud Infrastructure \(GKE\) [\#915](https://github.com/apache/camel-k/issues/915)
- Automatically resolve dependency for language expressions \(eg: groovy\) [\#914](https://github.com/apache/camel-k/issues/914)
- Add option to disable Kaniko cache warming [\#907](https://github.com/apache/camel-k/issues/907)
- Camel K should use duck types to recognize Knative sinks [\#888](https://github.com/apache/camel-k/issues/888)

**Merged pull requests:**

- feat: Enable integration scale sub-resource [\#962](https://github.com/apache/camel-k/pull/962) ([astefanutti](https://github.com/astefanutti))
- fix: Add option to disable Kaniko cache warming [\#922](https://github.com/apache/camel-k/pull/922) ([asifdxtreme](https://github.com/asifdxtreme))

## [1.0.0-M1](https://github.com/apache/camel-k/tree/1.0.0-M1) (2019-07-25)

[Full Changelog](https://github.com/apache/camel-k/compare/0.3.4...1.0.0-M1)

**Closed issues:**

- Lambda processor doesn't work with JS routes [\#873](https://github.com/apache/camel-k/issues/873)
- make images fail on resolve of camel-k-maven-plugin [\#869](https://github.com/apache/camel-k/issues/869)
- operator-sdk build fails on latest master with 'make images-dev' [\#863](https://github.com/apache/camel-k/issues/863)
- camel-rest should load automatically for routes using Rest DSL  [\#862](https://github.com/apache/camel-k/issues/862)
- Upgrade operator sdk to 0.9.0 [\#845](https://github.com/apache/camel-k/issues/845)
- route trait assumes target port name is always 'http' [\#837](https://github.com/apache/camel-k/issues/837)
- Concurrency issue in the end to end tests [\#830](https://github.com/apache/camel-k/issues/830)
- Can camel-k accept camel context definition? [\#814](https://github.com/apache/camel-k/issues/814)
- Update to camel 3.0.0-M4  [\#811](https://github.com/apache/camel-k/issues/811)
- Kamel install with kit option can leave integrationkit stuck waiting for platform [\#809](https://github.com/apache/camel-k/issues/809)
- Dependencies & rest-dsl traits are never enabled [\#807](https://github.com/apache/camel-k/issues/807)
- Updating an integration leaves it stuck in phase Deploying [\#806](https://github.com/apache/camel-k/issues/806)
- Nil pointer on build failure recovery [\#804](https://github.com/apache/camel-k/issues/804)
- Move waiting for platform to controller [\#797](https://github.com/apache/camel-k/issues/797)
- Don't wait for initial kit to be ready to declare the platform ready [\#795](https://github.com/apache/camel-k/issues/795)
- e2e tests are failing on travis [\#793](https://github.com/apache/camel-k/issues/793)
- Support for new yaml dsl [\#781](https://github.com/apache/camel-k/issues/781)
- Integration naming issues with numbers in them [\#777](https://github.com/apache/camel-k/issues/777)
- Route trait does not work if route.auto is set to false [\#767](https://github.com/apache/camel-k/issues/767)
- Switch to Camel 3 [\#755](https://github.com/apache/camel-k/issues/755)
- Do not create a route on top of prometheus service only [\#749](https://github.com/apache/camel-k/issues/749)
- The --maven-repository shortcut does not configure plugin repositories [\#746](https://github.com/apache/camel-k/issues/746)
- Add a --global install option [\#745](https://github.com/apache/camel-k/issues/745)
- CR example is using wrong schema [\#737](https://github.com/apache/camel-k/issues/737)
- camelContext is not supported in XML DSL routedefinition [\#731](https://github.com/apache/camel-k/issues/731)
- Switch to go mod compatible version of operator-sdk [\#702](https://github.com/apache/camel-k/issues/702)
- `make generate` does not work with new module structure [\#699](https://github.com/apache/camel-k/issues/699)
- camel-k-operator ready for running integration when camel-k-\* builds are still fails [\#582](https://github.com/apache/camel-k/issues/582)
- Honour KUBECONFIG [\#574](https://github.com/apache/camel-k/issues/574)
- Generate website using Antora [\#282](https://github.com/apache/camel-k/issues/282)
- Able to set custom camel-k-operator image name and location  [\#97](https://github.com/apache/camel-k/issues/97)
- Add script/doc for those who use 'oc cluster up' \(cluster-wrapper\) [\#60](https://github.com/apache/camel-k/issues/60)
- Release Camel K 1.0.0 M1 and related Camel K Runtime [\#878](https://github.com/apache/camel-k/issues/878)
- Can't determine knative endpoint address [\#856](https://github.com/apache/camel-k/issues/856)
- Wrong dependency camel-k:knative used [\#848](https://github.com/apache/camel-k/issues/848)
- Groovy Rest example fails due to Unable to find loader for language=xml [\#838](https://github.com/apache/camel-k/issues/838)
- Disable Istio by default [\#833](https://github.com/apache/camel-k/issues/833)
- GC trait fails on some installations [\#832](https://github.com/apache/camel-k/issues/832)
- Stable container name [\#826](https://github.com/apache/camel-k/issues/826)
- Determine correct profile at runtime in the operator [\#815](https://github.com/apache/camel-k/issues/815)
- Knative serving runLatest is deprecated [\#791](https://github.com/apache/camel-k/issues/791)
- Wrong example on operator hub [\#789](https://github.com/apache/camel-k/issues/789)
- Enable maven strict checksum policy on platform initialization [\#776](https://github.com/apache/camel-k/issues/776)
- Misleading "service.enabled=false" when used in combination with the prometheus trait [\#768](https://github.com/apache/camel-k/issues/768)
- Allow backward compatible changes in CRD [\#730](https://github.com/apache/camel-k/issues/730)

## [0.3.4](https://github.com/apache/camel-k/tree/0.3.4) (2019-06-07)

[Full Changelog](https://github.com/apache/camel-k/compare/0.3.3...0.3.4)

**Closed issues:**

- Don't automatically install contexts upon platform installation [\#716](https://github.com/apache/camel-k/issues/716)
- Allow to provide custom settings.xml  [\#715](https://github.com/apache/camel-k/issues/715)
- Question about the installation of the cluster [\#701](https://github.com/apache/camel-k/issues/701)
- Provide a way to override the default image name [\#698](https://github.com/apache/camel-k/issues/698)
- kamel run --dev examples/resources-route.groovy issues Cannot find resource [\#697](https://github.com/apache/camel-k/issues/697)
- Making sure external dep projects can import Camel K APIs [\#679](https://github.com/apache/camel-k/issues/679)
- Remove depenency on Istio for Knative sources [\#669](https://github.com/apache/camel-k/issues/669)
- Allow to subscribe to multiple knative channels in the same integration   [\#668](https://github.com/apache/camel-k/issues/668)
- Error creating integration context with buildStrategy: pod on minikube [\#666](https://github.com/apache/camel-k/issues/666)
- Use in-memory channel provisioner in place of in-memory-channel in Knative example [\#663](https://github.com/apache/camel-k/issues/663)
- Integration stuck waiting for platform [\#660](https://github.com/apache/camel-k/issues/660)
- Update to Camel 2.24.0 [\#655](https://github.com/apache/camel-k/issues/655)
- Improve documentation [\#653](https://github.com/apache/camel-k/issues/653)
- Remove camel 3.0.0-M1 catalog [\#651](https://github.com/apache/camel-k/issues/651)
- remove support for integration container image creation [\#650](https://github.com/apache/camel-k/issues/650)
- include context traits when looking up for a compatible context [\#649](https://github.com/apache/camel-k/issues/649)
- examples/knative splitter 'Service.serving.knative.dev \"words\" not found' [\#645](https://github.com/apache/camel-k/issues/645)
- Release 0.3.3 [\#642](https://github.com/apache/camel-k/issues/642)
- Generate catalog for recent Camel versions [\#637](https://github.com/apache/camel-k/issues/637)
- Deprecate integration image creation [\#627](https://github.com/apache/camel-k/issues/627)
- Set env var with Kamel [\#606](https://github.com/apache/camel-k/issues/606)
- Add support for DSL in Knative Camel Sources [\#567](https://github.com/apache/camel-k/issues/567)
- drop support for knative \< 0.4 [\#552](https://github.com/apache/camel-k/issues/552)
- remove spring boot support [\#534](https://github.com/apache/camel-k/issues/534)
- camel-k on Openshift Container Platform 3.11 [\#493](https://github.com/apache/camel-k/issues/493)
- Add spring-boot example in the examples directory [\#397](https://github.com/apache/camel-k/issues/397)
- examples/knative broken on OpenShift knative 0.6.0, must not set the field\(s\): spec.runLatest.configuration.revisionTemplate.spec.container.env\[11\].valueFrom.fieldRef [\#722](https://github.com/apache/camel-k/issues/722)
- PGP Sign released artifacts [\#707](https://github.com/apache/camel-k/issues/707)
- Setup the maven proxy inside of the builder [\#706](https://github.com/apache/camel-k/issues/706)
- Automatically use pod build strategy in "AllNamespaces" setup [\#703](https://github.com/apache/camel-k/issues/703)
- Release 0.3.4 [\#683](https://github.com/apache/camel-k/issues/683)

## [0.3.3](https://github.com/apache/camel-k/tree/0.3.3) (2019-05-03)

[Full Changelog](https://github.com/apache/camel-k/compare/0.3.2...0.3.3)

**Closed issues:**

- LanguageXML is not included in languages list [\#634](https://github.com/apache/camel-k/issues/634)
- FTP producer: Error writig file [\#620](https://github.com/apache/camel-k/issues/620)
- Kamel binary install on Windows 10 with Minikube [\#619](https://github.com/apache/camel-k/issues/619)
- Malformed maven project while building context [\#618](https://github.com/apache/camel-k/issues/618)
- istio: allow to control annotation sidecar.istio.io/inject [\#609](https://github.com/apache/camel-k/issues/609)
- allow to configure default configurations on platform [\#608](https://github.com/apache/camel-k/issues/608)
- Script set-version.sh does not honor the registry/repository settings [\#602](https://github.com/apache/camel-k/issues/602)
- add options to configure affinity [\#601](https://github.com/apache/camel-k/issues/601)
- camel-k groovy, jvm, spring-boot gives error pushing image [\#588](https://github.com/apache/camel-k/issues/588)
- on-premises: mount rwx volume [\#587](https://github.com/apache/camel-k/issues/587)
- context with status error should not be included when looking up suitable context for an integration [\#584](https://github.com/apache/camel-k/issues/584)
- Release 0.3.2 [\#576](https://github.com/apache/camel-k/issues/576)
- When using hystrix EIP then auto include camel-hystrix dependency [\#575](https://github.com/apache/camel-k/issues/575)
- camel-k-operator pod CrashLoopBackOff on minikube on restart [\#537](https://github.com/apache/camel-k/issues/537)
- Resolving Dependency Automatically -- aws-s3 [\#419](https://github.com/apache/camel-k/issues/419)
- Kamel CLI - Add command to view which dependencies the pre-build context has loaded [\#398](https://github.com/apache/camel-k/issues/398)
- Review resource conflict hanndling [\#363](https://github.com/apache/camel-k/issues/363)
- Split builder from operator [\#125](https://github.com/apache/camel-k/issues/125)

## [0.3.2](https://github.com/apache/camel-k/tree/0.3.2) (2019-03-26)

[Full Changelog](https://github.com/apache/camel-k/compare/0.3.1...0.3.2)

**Closed issues:**

- Unable to create subscription to channel [\#579](https://github.com/apache/camel-k/issues/579)
- allow to configure resources requests/limits [\#570](https://github.com/apache/camel-k/issues/570)
- Add support for traits defaults [\#566](https://github.com/apache/camel-k/issues/566)
- Can't connect to kservices [\#553](https://github.com/apache/camel-k/issues/553)
- Release 0.3.1 [\#540](https://github.com/apache/camel-k/issues/540)
- Knative pods not scaling down to zero [\#498](https://github.com/apache/camel-k/issues/498)
- improve release process [\#458](https://github.com/apache/camel-k/issues/458)
- Upgrade to Apache Camel 3.0.0-M1 [\#452](https://github.com/apache/camel-k/issues/452)
- JVM issue on Minikube while running Sample.java integration using 0.2.0 release of Kamel binary [\#424](https://github.com/apache/camel-k/issues/424)

## [0.3.1](https://github.com/apache/camel-k/tree/0.3.1) (2019-03-15)

[Full Changelog](https://github.com/apache/camel-k/compare/0.3.0...0.3.1)

**Closed issues:**

- Unable to use predefined images [\#557](https://github.com/apache/camel-k/issues/557)
- Improve SanitizeName [\#548](https://github.com/apache/camel-k/issues/548)
- camel-k --runtime-version is not honoured for all runtimes [\#538](https://github.com/apache/camel-k/issues/538)
- Timeout in S2I build [\#536](https://github.com/apache/camel-k/issues/536)
- Add option to health probes [\#525](https://github.com/apache/camel-k/issues/525)
- Remove operator metrics port and service [\#513](https://github.com/apache/camel-k/issues/513)
- Adding Probes to Knative services [\#511](https://github.com/apache/camel-k/issues/511)
- Release version 0.3.0 [\#489](https://github.com/apache/camel-k/issues/489)

## [0.3.0](https://github.com/apache/camel-k/tree/0.3.0) (2019-03-04)

[Full Changelog](https://github.com/apache/camel-k/compare/0.2.1...0.3.0)

**Closed issues:**

- Allow file names as "kamel delete" argument [\#515](https://github.com/apache/camel-k/issues/515)
- Update minikube docs  [\#508](https://github.com/apache/camel-k/issues/508)
- Unable to start knative route [\#506](https://github.com/apache/camel-k/issues/506)
- Add kamel option to uninstall [\#503](https://github.com/apache/camel-k/issues/503)
- Upgrade to Knative  \> v0.3.0 [\#497](https://github.com/apache/camel-k/issues/497)
- Support for MAVEN\_MIRROR\_URL [\#492](https://github.com/apache/camel-k/issues/492)
- Came-k routes takes long time to terminate [\#490](https://github.com/apache/camel-k/issues/490)
- improve resource gc performances [\#487](https://github.com/apache/camel-k/issues/487)
- Unable to send message to knative channel [\#483](https://github.com/apache/camel-k/issues/483)
- add finalizer to ensure integration children are cleaned up [\#477](https://github.com/apache/camel-k/issues/477)
- move runtime in its own repository [\#470](https://github.com/apache/camel-k/issues/470)
- add an option to set which runtime version the operator should to run integrations [\#469](https://github.com/apache/camel-k/issues/469)
- do not include runtime artefacts in operator image by default [\#468](https://github.com/apache/camel-k/issues/468)
- add a tool to generate json schema from custom resources [\#461](https://github.com/apache/camel-k/issues/461)
- move integration reconcile loop wake-up field to status [\#460](https://github.com/apache/camel-k/issues/460)
- release version 0.2.1 [\#453](https://github.com/apache/camel-k/issues/453)
- Use Kaniko Cache to speedup [\#196](https://github.com/apache/camel-k/issues/196)

## [0.2.1](https://github.com/apache/camel-k/tree/0.2.1) (2019-02-19)

[Full Changelog](https://github.com/apache/camel-k/compare/0.2.0...0.2.1)

**Closed issues:**

- deploy camel-k runtime artifacts to apache snapshot automatically [\#447](https://github.com/apache/camel-k/issues/447)
- move catalog definition in status instead of spec [\#446](https://github.com/apache/camel-k/issues/446)
- camel catalog controller [\#445](https://github.com/apache/camel-k/issues/445)
- Add field 'camel-version' to Integration CRD [\#439](https://github.com/apache/camel-k/issues/439)
- Passing image destination to build [\#437](https://github.com/apache/camel-k/issues/437)
- Error while deploying integration in Knative based environment [\#436](https://github.com/apache/camel-k/issues/436)
- deploy runtime snapshots to apache snapshot repo [\#432](https://github.com/apache/camel-k/issues/432)
- support for semver catalog resolution [\#414](https://github.com/apache/camel-k/issues/414)
- The example RestWithRestlet does not work calling its service via curl or webbrowser [\#402](https://github.com/apache/camel-k/issues/402)
- runtime: ensure that the generated project uses the right camel version [\#384](https://github.com/apache/camel-k/issues/384)
- camel-knative: support for cloud events specs v0.2 [\#376](https://github.com/apache/camel-k/issues/376)
- Failed to resolve endpoint: twitter-search [\#370](https://github.com/apache/camel-k/issues/370)
- Add a trait to configure/enable jolokia [\#369](https://github.com/apache/camel-k/issues/369)
- Automatically apply defaults to platform configuration [\#365](https://github.com/apache/camel-k/issues/365)
- Use consistent logging style [\#362](https://github.com/apache/camel-k/issues/362)
- Allow to configure the location fo the local maven repo [\#358](https://github.com/apache/camel-k/issues/358)
- kamel stuck when a secret has an illegal name [\#356](https://github.com/apache/camel-k/issues/356)
- catalog should be available as custom resource [\#302](https://github.com/apache/camel-k/issues/302)
- Provide a way to inject annotations/labels into child resources [\#263](https://github.com/apache/camel-k/issues/263)
- Remove old resources on redeploy [\#211](https://github.com/apache/camel-k/issues/211)
- Expose metrics to Prometheus [\#82](https://github.com/apache/camel-k/issues/82)
- Cannot deploy integration if not in the root package [\#41](https://github.com/apache/camel-k/issues/41)

## [0.2.0](https://github.com/apache/camel-k/tree/0.2.0) (2019-01-22)

[Full Changelog](https://github.com/apache/camel-k/compare/0.1.0...0.2.0)

**Closed issues:**

- Use container name for "kamel log", too [\#347](https://github.com/apache/camel-k/issues/347)
- Allow to configure the base image used to run integrations [\#340](https://github.com/apache/camel-k/issues/340)
- Use standard deployment for Knative event sources [\#324](https://github.com/apache/camel-k/issues/324)
- support for openapi/swagger  [\#323](https://github.com/apache/camel-k/issues/323)
- create camel-k-maven-plugin [\#322](https://github.com/apache/camel-k/issues/322)
- Allow to customize contexts create at installation [\#318](https://github.com/apache/camel-k/issues/318)
- Option to create an Integration Context from an existing image [\#316](https://github.com/apache/camel-k/issues/316)
- Publish some base images together with Camel K [\#312](https://github.com/apache/camel-k/issues/312)
- Add a simplified model for sources [\#307](https://github.com/apache/camel-k/issues/307)
- The kaniko build pod failed to start [\#306](https://github.com/apache/camel-k/issues/306)
- Allow to customize integration service account [\#305](https://github.com/apache/camel-k/issues/305)
- catalog : include camel-k components [\#301](https://github.com/apache/camel-k/issues/301)
- Set the env var KOTLIN\_JDK\_HOME to point to your real JDK home [\#297](https://github.com/apache/camel-k/issues/297)
- Support for runtime traits [\#287](https://github.com/apache/camel-k/issues/287)
- Inject camel-k version as environment variable [\#285](https://github.com/apache/camel-k/issues/285)
- Platform options [\#284](https://github.com/apache/camel-k/issues/284)
- IntegrationContext builds sometimes fail [\#279](https://github.com/apache/camel-k/issues/279)
- trait: add a trait to inject pod metadata as env var [\#275](https://github.com/apache/camel-k/issues/275)
- Display relevant custom columns [\#274](https://github.com/apache/camel-k/issues/274)
- Refactor traits lifecycle [\#268](https://github.com/apache/camel-k/issues/268)
- Determine active/passive endpoints from Catalog [\#264](https://github.com/apache/camel-k/issues/264)
- add resources to an integration [\#241](https://github.com/apache/camel-k/issues/241)
- Migrate to Operator SDK 0.1.x [\#237](https://github.com/apache/camel-k/issues/237)
- Use docker-registry.default.svc to reference images [\#221](https://github.com/apache/camel-k/issues/221)
- Add option to extract all resources needed to install Camel K [\#220](https://github.com/apache/camel-k/issues/220)
- Exposing Rest endpoint [\#212](https://github.com/apache/camel-k/issues/212)
- Creating Ingress and services with Kubernetes  [\#189](https://github.com/apache/camel-k/issues/189)
- create knative context [\#183](https://github.com/apache/camel-k/issues/183)
- Add a state to integrations waiting for platform to be ready [\#136](https://github.com/apache/camel-k/issues/136)
- Add a "-w" flag to "kamel install" [\#135](https://github.com/apache/camel-k/issues/135)
- Provide PR build check on pull requests [\#132](https://github.com/apache/camel-k/issues/132)
- Provide link to CI in readme [\#121](https://github.com/apache/camel-k/issues/121)
- Add a dev's mode to kamel command to push project directly within the pod [\#108](https://github.com/apache/camel-k/issues/108)

## [0.1.0](https://github.com/apache/camel-k/tree/0.1.0) (2018-12-10)

[Full Changelog](https://github.com/apache/camel-k/compare/0.0.5...0.1.0)

**Closed issues:**

- Allow using compressed sources in Knative profile [\#270](https://github.com/apache/camel-k/issues/270)
- Support for compressed source blob [\#265](https://github.com/apache/camel-k/issues/265)
- add an option to always generate a docker image [\#246](https://github.com/apache/camel-k/issues/246)
- temporary build folder not cleaned up [\#230](https://github.com/apache/camel-k/issues/230)
- Do not always scale down to 0 in Knative [\#219](https://github.com/apache/camel-k/issues/219)
- Allow to push to a Knative channel or service endpoint [\#218](https://github.com/apache/camel-k/issues/218)
- Support subscription to multiple Knative channels [\#216](https://github.com/apache/camel-k/issues/216)
- Create a Istio trait [\#209](https://github.com/apache/camel-k/issues/209)
- Provide example with custom processor [\#205](https://github.com/apache/camel-k/issues/205)
- Kamel CLI - Add command to run integration in Java debug mode [\#190](https://github.com/apache/camel-k/issues/190)
- runtime : create cloudevents camel component [\#171](https://github.com/apache/camel-k/issues/171)
- Investigate switching to kubebuilder [\#169](https://github.com/apache/camel-k/issues/169)
- Allow to use dash syntax in configuring component properties [\#142](https://github.com/apache/camel-k/issues/142)
- Introducing Traits [\#115](https://github.com/apache/camel-k/issues/115)
- Trigger context update when build finishes [\#113](https://github.com/apache/camel-k/issues/113)
- Support for multiple integration definitions [\#45](https://github.com/apache/camel-k/issues/45)

## [0.0.5](https://github.com/apache/camel-k/tree/0.0.5) (2018-11-16)

[Full Changelog](https://github.com/apache/camel-k/compare/0.0.4...0.0.5)

**Closed issues:**

- Kaniko build failing on Minikube [\#226](https://github.com/apache/camel-k/issues/226)
- camel-k make resulting in test failures while building runtime kotlin  [\#222](https://github.com/apache/camel-k/issues/222)
- Provide option to get the Json/Yaml of a integration [\#207](https://github.com/apache/camel-k/issues/207)
- Where we can get XSD for plain XML DSL? [\#201](https://github.com/apache/camel-k/issues/201)
- Cannot configure traits [\#199](https://github.com/apache/camel-k/issues/199)
- camel-k-context-jvm, camel-k-context-kotlin, camel-k-context-groovy pods goes into error state when installing camel-k [\#194](https://github.com/apache/camel-k/issues/194)
- Installation hangs on GKE  [\#188](https://github.com/apache/camel-k/issues/188)
- kamel run --dev mode terminate pod if pressing ctrl + c [\#184](https://github.com/apache/camel-k/issues/184)
- runtime : create knative camel component [\#172](https://github.com/apache/camel-k/issues/172)
- Doc and/or command should be changed - kamel install [\#106](https://github.com/apache/camel-k/issues/106)

## [0.0.4](https://github.com/apache/camel-k/tree/0.0.4) (2018-10-16)

[Full Changelog](https://github.com/apache/camel-k/compare/0.0.3...0.0.4)

**Closed issues:**

- configure camel context from properties  [\#175](https://github.com/apache/camel-k/issues/175)
- Camel-http4 not recognized automatically [\#174](https://github.com/apache/camel-k/issues/174)
- Property placeholder conflict in groovy [\#173](https://github.com/apache/camel-k/issues/173)
- kamel "get" should not return contexts [\#161](https://github.com/apache/camel-k/issues/161)
- Add log command [\#153](https://github.com/apache/camel-k/issues/153)
- Add option to run from URL [\#137](https://github.com/apache/camel-k/issues/137)
- Enable integration tests in CI [\#127](https://github.com/apache/camel-k/issues/127)
- Need a Web UI? [\#77](https://github.com/apache/camel-k/issues/77)

## [0.0.3](https://github.com/apache/camel-k/tree/0.0.3) (2018-10-02)

[Full Changelog](https://github.com/apache/camel-k/compare/0.0.2...0.0.3)

**Closed issues:**

- Dead link in Developer's guide "runtime" [\#124](https://github.com/apache/camel-k/issues/124)
- Regression for groovy routes [\#118](https://github.com/apache/camel-k/issues/118)
- Add bindings for rest dsl in groovy/js routes [\#117](https://github.com/apache/camel-k/issues/117)
- Experiment with janino to build java expressions to reduce java verbosity [\#116](https://github.com/apache/camel-k/issues/116)
- Report correct build status in case of failure [\#114](https://github.com/apache/camel-k/issues/114)
- Document latest improvements and release 0.0.2 [\#102](https://github.com/apache/camel-k/issues/102)
- Create a Camel CRD [\#73](https://github.com/apache/camel-k/issues/73)
- Figure out how to deploy integrations on plain Kubernetes [\#32](https://github.com/apache/camel-k/issues/32)

## [0.0.2](https://github.com/apache/camel-k/tree/0.0.2) (2018-09-19)

[Full Changelog](https://github.com/apache/camel-k/compare/0.0.1...0.0.2)

**Closed issues:**

- Add delete integration option [\#96](https://github.com/apache/camel-k/issues/96)
- Auto-discover dependencies [\#94](https://github.com/apache/camel-k/issues/94)
- Embed camel catalog [\#93](https://github.com/apache/camel-k/issues/93)
- Integrations are started twice [\#90](https://github.com/apache/camel-k/issues/90)
- Fails to run build after install with  javax.net.ssl.SSLProtocolException: handshake alert:  unrecognized\_name [\#84](https://github.com/apache/camel-k/issues/84)
- Manually trigger integration update [\#80](https://github.com/apache/camel-k/issues/80)
- Automatically create "platform" contexts [\#75](https://github.com/apache/camel-k/issues/75)
- Install a root IntegrationContext [\#74](https://github.com/apache/camel-k/issues/74)
- Add support for XML routes  [\#70](https://github.com/apache/camel-k/issues/70)
- Remove language configuration in kamel run [\#69](https://github.com/apache/camel-k/issues/69)
- Support for configmap and secrets [\#67](https://github.com/apache/camel-k/issues/67)
- Support for environment variables [\#65](https://github.com/apache/camel-k/issues/65)
- Support for properties [\#62](https://github.com/apache/camel-k/issues/62)
- Setup release scripts [\#59](https://github.com/apache/camel-k/issues/59)
- kamel install with sample [\#51](https://github.com/apache/camel-k/issues/51)
- Add "make install-minishift" command [\#42](https://github.com/apache/camel-k/issues/42)
- Add dev mode [\#34](https://github.com/apache/camel-k/issues/34)
- Add wait and log watch options [\#33](https://github.com/apache/camel-k/issues/33)
- Manage dependencies [\#30](https://github.com/apache/camel-k/issues/30)

## [0.0.1](https://github.com/apache/camel-k/tree/0.0.1) (2018-09-13)

[Full Changelog](https://github.com/apache/camel-k/compare/55fca8ee59ca67450bd114065872b0849917f132...0.0.1)

**Closed issues:**

- kamel run runtime/examples/Sample.java fails with java.lang.NoClassDefFoundError [\#57](https://github.com/apache/camel-k/issues/57)
- Store integration code in a configmap [\#54](https://github.com/apache/camel-k/issues/54)
- kamel run should support adding dependencies [\#49](https://github.com/apache/camel-k/issues/49)
- Route loaders should derive language from "kamel run --language" [\#46](https://github.com/apache/camel-k/issues/46)
- How to know a Component status at a time [\#44](https://github.com/apache/camel-k/issues/44)
- Unable to reinstall the operator [\#43](https://github.com/apache/camel-k/issues/43)
- Support set integration name for kamel run [\#40](https://github.com/apache/camel-k/issues/40)
- Allow buildless direct deploy [\#31](https://github.com/apache/camel-k/issues/31)



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
