/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "github.com/apache/camel-k/pkg/apis/camel/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeIntegrationKits implements IntegrationKitInterface
type FakeIntegrationKits struct {
	Fake *FakeCamelV1
	ns   string
}

var integrationkitsResource = v1.SchemeGroupVersion.WithResource("integrationkits")

var integrationkitsKind = v1.SchemeGroupVersion.WithKind("IntegrationKit")

// Get takes name of the integrationKit, and returns the corresponding integrationKit object, and an error if there is any.
func (c *FakeIntegrationKits) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.IntegrationKit, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(integrationkitsResource, c.ns, name), &v1.IntegrationKit{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.IntegrationKit), err
}

// List takes label and field selectors, and returns the list of IntegrationKits that match those selectors.
func (c *FakeIntegrationKits) List(ctx context.Context, opts metav1.ListOptions) (result *v1.IntegrationKitList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(integrationkitsResource, integrationkitsKind, c.ns, opts), &v1.IntegrationKitList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.IntegrationKitList{ListMeta: obj.(*v1.IntegrationKitList).ListMeta}
	for _, item := range obj.(*v1.IntegrationKitList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested integrationKits.
func (c *FakeIntegrationKits) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(integrationkitsResource, c.ns, opts))

}

// Create takes the representation of a integrationKit and creates it.  Returns the server's representation of the integrationKit, and an error, if there is any.
func (c *FakeIntegrationKits) Create(ctx context.Context, integrationKit *v1.IntegrationKit, opts metav1.CreateOptions) (result *v1.IntegrationKit, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(integrationkitsResource, c.ns, integrationKit), &v1.IntegrationKit{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.IntegrationKit), err
}

// Update takes the representation of a integrationKit and updates it. Returns the server's representation of the integrationKit, and an error, if there is any.
func (c *FakeIntegrationKits) Update(ctx context.Context, integrationKit *v1.IntegrationKit, opts metav1.UpdateOptions) (result *v1.IntegrationKit, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(integrationkitsResource, c.ns, integrationKit), &v1.IntegrationKit{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.IntegrationKit), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeIntegrationKits) UpdateStatus(ctx context.Context, integrationKit *v1.IntegrationKit, opts metav1.UpdateOptions) (*v1.IntegrationKit, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(integrationkitsResource, "status", c.ns, integrationKit), &v1.IntegrationKit{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.IntegrationKit), err
}

// Delete takes name of the integrationKit and deletes it. Returns an error if one occurs.
func (c *FakeIntegrationKits) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(integrationkitsResource, c.ns, name, opts), &v1.IntegrationKit{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeIntegrationKits) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(integrationkitsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1.IntegrationKitList{})
	return err
}

// Patch applies the patch and returns the patched integrationKit.
func (c *FakeIntegrationKits) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.IntegrationKit, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(integrationkitsResource, c.ns, name, pt, data, subresources...), &v1.IntegrationKit{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.IntegrationKit), err
}
