/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.soroush;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelSoroushSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_SOROUSH_PATH_ACTION_CONF = "camel.source.path.action";
    public static final String CAMEL_SOURCE_SOROUSH_PATH_ACTION_DOC = "The action to do. One of: [sendMessage] [getMessage] [uploadFile] [downloadFile]";
    public static final String CAMEL_SOURCE_SOROUSH_PATH_ACTION_DEFAULT = null;
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_CONNECTION_TIMEOUT_CONF = "camel.source.endpoint.connectionTimeout";
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_CONNECTION_TIMEOUT_DOC = "Connection timeout in ms when connecting to soroush API";
    public static final Integer CAMEL_SOURCE_SOROUSH_ENDPOINT_CONNECTION_TIMEOUT_DEFAULT = 30000;
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_MAX_CONNECTION_RETRY_CONF = "camel.source.endpoint.maxConnectionRetry";
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_MAX_CONNECTION_RETRY_DOC = "Maximum connection retry when fail to connect to soroush API, if the quota is reached, MaximumConnectionRetryReachedException is thrown for that message.";
    public static final Integer CAMEL_SOURCE_SOROUSH_ENDPOINT_MAX_CONNECTION_RETRY_DEFAULT = 4;
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_SOROUSH_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_CONCURRENT_CONSUMERS_CONF = "camel.source.endpoint.concurrentConsumers";
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_CONCURRENT_CONSUMERS_DOC = "Number of Thread created by consumer in the route. if you use this method for parallelism, it is guaranteed that messages from same user always execute in the same thread and therefore messages from the same user are processed sequentially. Default value notice: using SoroushBotSingleThreadConsumer";
    public static final Integer CAMEL_SOURCE_SOROUSH_ENDPOINT_CONCURRENT_CONSUMERS_DEFAULT = 1;
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_QUEUE_CAPACITY_PER_THREAD_CONF = "camel.source.endpoint.queueCapacityPerThread";
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_QUEUE_CAPACITY_PER_THREAD_DOC = "Maximum capacity of each queue when concurrentConsumers is greater than 1. if a queue become full, every message that should go to that queue will be dropped. If bridgeErrorHandler is set to true, an exchange with CongestionException is directed to ErrorHandler. You can then processed the error using onException(CongestionException.class) route. Default value notice: infinite capacity";
    public static final Integer CAMEL_SOURCE_SOROUSH_ENDPOINT_QUEUE_CAPACITY_PER_THREAD_DEFAULT = 0;
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_SOROUSH_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_BACK_OFF_STRATEGY_CONF = "camel.source.endpoint.backOffStrategy";
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_BACK_OFF_STRATEGY_DOC = "The strategy to backoff in case of connection failure. Currently 3 strategies are supported: 1. Exponential (default): It multiply retryWaitingTime by retryExponentialCoefficient after each connection failure. 2. Linear: It increase retryWaitingTime by retryLinearIncrement after each connection failure. 3. Fixed: Always use retryWaitingTime as the time between retries.";
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_BACK_OFF_STRATEGY_DEFAULT = "Exponential";
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_MAX_RETRY_WAITING_TIME_CONF = "camel.source.endpoint.maxRetryWaitingTime";
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_MAX_RETRY_WAITING_TIME_DOC = "Maximum amount of time (in millisecond) a thread wait before retrying failed request.";
    public static final Long CAMEL_SOURCE_SOROUSH_ENDPOINT_MAX_RETRY_WAITING_TIME_DEFAULT = 3600000L;
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_RECONNECT_IDLE_CONNECTION_TIMEOUT_CONF = "camel.source.endpoint.reconnectIdleConnectionTimeout";
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_RECONNECT_IDLE_CONNECTION_TIMEOUT_DOC = "The timeout in millisecond to reconnect the existing getMessage connection to ensure that the connection is always live and does not dead without notifying the bot. this value should not be changed.";
    public static final Long CAMEL_SOURCE_SOROUSH_ENDPOINT_RECONNECT_IDLE_CONNECTION_TIMEOUT_DEFAULT = 300000L;
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_RETRY_EXPONENTIAL_COEFFICIENT_CONF = "camel.source.endpoint.retryExponentialCoefficient";
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_RETRY_EXPONENTIAL_COEFFICIENT_DOC = "Coefficient to compute back off time when using Exponential Back Off strategy";
    public static final Long CAMEL_SOURCE_SOROUSH_ENDPOINT_RETRY_EXPONENTIAL_COEFFICIENT_DEFAULT = 2L;
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_RETRY_LINEAR_INCREMENT_CONF = "camel.source.endpoint.retryLinearIncrement";
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_RETRY_LINEAR_INCREMENT_DOC = "The amount of time (in millisecond) which adds to waiting time when using Linear back off strategy";
    public static final Long CAMEL_SOURCE_SOROUSH_ENDPOINT_RETRY_LINEAR_INCREMENT_DEFAULT = 10000L;
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_RETRY_WAITING_TIME_CONF = "camel.source.endpoint.retryWaitingTime";
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_RETRY_WAITING_TIME_DOC = "Waiting time before retry failed request (Millisecond). If backOffStrategy is not Fixed this is the based value for computing back off waiting time. the first retry is always happen immediately after failure and retryWaitingTime do not apply to the first retry.";
    public static final Long CAMEL_SOURCE_SOROUSH_ENDPOINT_RETRY_WAITING_TIME_DEFAULT = 1000L;
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_AUTHORIZATION_TOKEN_CONF = "camel.source.endpoint.authorizationToken";
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_AUTHORIZATION_TOKEN_DOC = "The authorization token for using the bot. if uri path does not contain authorization token, this token will be used.";
    public static final String CAMEL_SOURCE_SOROUSH_ENDPOINT_AUTHORIZATION_TOKEN_DEFAULT = null;
    public static final String CAMEL_SOURCE_SOROUSH_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.soroush.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_SOROUSH_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_SOROUSH_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_SOROUSH_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.soroush.autowiredEnabled";
    public static final String CAMEL_SOURCE_SOROUSH_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SOURCE_SOROUSH_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;
    public static final String CAMEL_SOURCE_SOROUSH_COMPONENT_AUTHORIZATION_TOKEN_CONF = "camel.component.soroush.authorizationToken";
    public static final String CAMEL_SOURCE_SOROUSH_COMPONENT_AUTHORIZATION_TOKEN_DOC = "The default Soroush authorization token to be used when the information is not provided in the endpoints.";
    public static final String CAMEL_SOURCE_SOROUSH_COMPONENT_AUTHORIZATION_TOKEN_DEFAULT = null;

    public CamelSoroushSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelSoroushSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_SOROUSH_PATH_ACTION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SOROUSH_PATH_ACTION_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_SOROUSH_PATH_ACTION_DOC);
        conf.define(CAMEL_SOURCE_SOROUSH_ENDPOINT_CONNECTION_TIMEOUT_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_SOROUSH_ENDPOINT_CONNECTION_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SOROUSH_ENDPOINT_CONNECTION_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_SOROUSH_ENDPOINT_MAX_CONNECTION_RETRY_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_SOROUSH_ENDPOINT_MAX_CONNECTION_RETRY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SOROUSH_ENDPOINT_MAX_CONNECTION_RETRY_DOC);
        conf.define(CAMEL_SOURCE_SOROUSH_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SOROUSH_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SOROUSH_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_SOROUSH_ENDPOINT_CONCURRENT_CONSUMERS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_SOROUSH_ENDPOINT_CONCURRENT_CONSUMERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SOROUSH_ENDPOINT_CONCURRENT_CONSUMERS_DOC);
        conf.define(CAMEL_SOURCE_SOROUSH_ENDPOINT_QUEUE_CAPACITY_PER_THREAD_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_SOROUSH_ENDPOINT_QUEUE_CAPACITY_PER_THREAD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SOROUSH_ENDPOINT_QUEUE_CAPACITY_PER_THREAD_DOC);
        conf.define(CAMEL_SOURCE_SOROUSH_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SOROUSH_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SOROUSH_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_SOROUSH_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SOROUSH_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SOROUSH_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_SOROUSH_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SOROUSH_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SOROUSH_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_SOROUSH_ENDPOINT_BACK_OFF_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SOROUSH_ENDPOINT_BACK_OFF_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SOROUSH_ENDPOINT_BACK_OFF_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_SOROUSH_ENDPOINT_MAX_RETRY_WAITING_TIME_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_SOROUSH_ENDPOINT_MAX_RETRY_WAITING_TIME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SOROUSH_ENDPOINT_MAX_RETRY_WAITING_TIME_DOC);
        conf.define(CAMEL_SOURCE_SOROUSH_ENDPOINT_RECONNECT_IDLE_CONNECTION_TIMEOUT_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_SOROUSH_ENDPOINT_RECONNECT_IDLE_CONNECTION_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SOROUSH_ENDPOINT_RECONNECT_IDLE_CONNECTION_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_SOROUSH_ENDPOINT_RETRY_EXPONENTIAL_COEFFICIENT_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_SOROUSH_ENDPOINT_RETRY_EXPONENTIAL_COEFFICIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SOROUSH_ENDPOINT_RETRY_EXPONENTIAL_COEFFICIENT_DOC);
        conf.define(CAMEL_SOURCE_SOROUSH_ENDPOINT_RETRY_LINEAR_INCREMENT_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_SOROUSH_ENDPOINT_RETRY_LINEAR_INCREMENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SOROUSH_ENDPOINT_RETRY_LINEAR_INCREMENT_DOC);
        conf.define(CAMEL_SOURCE_SOROUSH_ENDPOINT_RETRY_WAITING_TIME_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_SOROUSH_ENDPOINT_RETRY_WAITING_TIME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SOROUSH_ENDPOINT_RETRY_WAITING_TIME_DOC);
        conf.define(CAMEL_SOURCE_SOROUSH_ENDPOINT_AUTHORIZATION_TOKEN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SOROUSH_ENDPOINT_AUTHORIZATION_TOKEN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SOROUSH_ENDPOINT_AUTHORIZATION_TOKEN_DOC);
        conf.define(CAMEL_SOURCE_SOROUSH_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SOROUSH_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SOROUSH_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_SOROUSH_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_SOROUSH_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SOROUSH_COMPONENT_AUTOWIRED_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_SOROUSH_COMPONENT_AUTHORIZATION_TOKEN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_SOROUSH_COMPONENT_AUTHORIZATION_TOKEN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_SOROUSH_COMPONENT_AUTHORIZATION_TOKEN_DOC);
        return conf;
    }
}