/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.thrift;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelThriftSinkConnectorConfig extends CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_THRIFT_PATH_HOST_CONF = "camel.sink.path.host";
    public static final String CAMEL_SINK_THRIFT_PATH_HOST_DOC = "The Thrift server host name. This is localhost or 0.0.0.0 (if not defined) when being a consumer or remote server host name when using producer.";
    public static final String CAMEL_SINK_THRIFT_PATH_HOST_DEFAULT = null;
    public static final String CAMEL_SINK_THRIFT_PATH_PORT_CONF = "camel.sink.path.port";
    public static final String CAMEL_SINK_THRIFT_PATH_PORT_DOC = "The Thrift server port";
    public static final Integer CAMEL_SINK_THRIFT_PATH_PORT_DEFAULT = null;
    public static final String CAMEL_SINK_THRIFT_PATH_SERVICE_CONF = "camel.sink.path.service";
    public static final String CAMEL_SINK_THRIFT_PATH_SERVICE_DOC = "Fully qualified service name from the thrift descriptor file (package dot service definition name)";
    public static final String CAMEL_SINK_THRIFT_PATH_SERVICE_DEFAULT = null;
    public static final String CAMEL_SINK_THRIFT_ENDPOINT_COMPRESSION_TYPE_CONF = "camel.sink.endpoint.compressionType";
    public static final String CAMEL_SINK_THRIFT_ENDPOINT_COMPRESSION_TYPE_DOC = "Protocol compression mechanism type One of: [NONE] [ZLIB]";
    public static final String CAMEL_SINK_THRIFT_ENDPOINT_COMPRESSION_TYPE_DEFAULT = "NONE";
    public static final String CAMEL_SINK_THRIFT_ENDPOINT_EXCHANGE_PROTOCOL_CONF = "camel.sink.endpoint.exchangeProtocol";
    public static final String CAMEL_SINK_THRIFT_ENDPOINT_EXCHANGE_PROTOCOL_DOC = "Exchange protocol serialization type One of: [BINARY] [JSON] [SJSON] [COMPACT]";
    public static final String CAMEL_SINK_THRIFT_ENDPOINT_EXCHANGE_PROTOCOL_DEFAULT = "BINARY";
    public static final String CAMEL_SINK_THRIFT_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_THRIFT_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_THRIFT_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_THRIFT_ENDPOINT_METHOD_CONF = "camel.sink.endpoint.method";
    public static final String CAMEL_SINK_THRIFT_ENDPOINT_METHOD_DOC = "The Thrift invoked method name";
    public static final String CAMEL_SINK_THRIFT_ENDPOINT_METHOD_DEFAULT = null;
    public static final String CAMEL_SINK_THRIFT_ENDPOINT_SYNCHRONOUS_CONF = "camel.sink.endpoint.synchronous";
    public static final String CAMEL_SINK_THRIFT_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SINK_THRIFT_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SINK_THRIFT_ENDPOINT_NEGOTIATION_TYPE_CONF = "camel.sink.endpoint.negotiationType";
    public static final String CAMEL_SINK_THRIFT_ENDPOINT_NEGOTIATION_TYPE_DOC = "Security negotiation type One of: [PLAINTEXT] [SSL] [SASL]";
    public static final String CAMEL_SINK_THRIFT_ENDPOINT_NEGOTIATION_TYPE_DEFAULT = "PLAINTEXT";
    public static final String CAMEL_SINK_THRIFT_ENDPOINT_SSL_PARAMETERS_CONF = "camel.sink.endpoint.sslParameters";
    public static final String CAMEL_SINK_THRIFT_ENDPOINT_SSL_PARAMETERS_DOC = "Configuration parameters for SSL/TLS security negotiation";
    public static final String CAMEL_SINK_THRIFT_ENDPOINT_SSL_PARAMETERS_DEFAULT = null;
    public static final String CAMEL_SINK_THRIFT_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.thrift.lazyStartProducer";
    public static final String CAMEL_SINK_THRIFT_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_THRIFT_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_THRIFT_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.thrift.autowiredEnabled";
    public static final String CAMEL_SINK_THRIFT_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SINK_THRIFT_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;
    public static final String CAMEL_SINK_THRIFT_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_CONF = "camel.component.thrift.useGlobalSslContextParameters";
    public static final String CAMEL_SINK_THRIFT_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DOC = "Determine if the thrift component is using global SSL context parameters";
    public static final Boolean CAMEL_SINK_THRIFT_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DEFAULT = false;

    public CamelThriftSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelThriftSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_THRIFT_PATH_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SINK_THRIFT_PATH_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_THRIFT_PATH_HOST_DOC);
        conf.define(CAMEL_SINK_THRIFT_PATH_PORT_CONF, ConfigDef.Type.INT, CAMEL_SINK_THRIFT_PATH_PORT_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_THRIFT_PATH_PORT_DOC);
        conf.define(CAMEL_SINK_THRIFT_PATH_SERVICE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_THRIFT_PATH_SERVICE_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_THRIFT_PATH_SERVICE_DOC);
        conf.define(CAMEL_SINK_THRIFT_ENDPOINT_COMPRESSION_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_THRIFT_ENDPOINT_COMPRESSION_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_THRIFT_ENDPOINT_COMPRESSION_TYPE_DOC);
        conf.define(CAMEL_SINK_THRIFT_ENDPOINT_EXCHANGE_PROTOCOL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_THRIFT_ENDPOINT_EXCHANGE_PROTOCOL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_THRIFT_ENDPOINT_EXCHANGE_PROTOCOL_DOC);
        conf.define(CAMEL_SINK_THRIFT_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_THRIFT_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_THRIFT_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_THRIFT_ENDPOINT_METHOD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_THRIFT_ENDPOINT_METHOD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_THRIFT_ENDPOINT_METHOD_DOC);
        conf.define(CAMEL_SINK_THRIFT_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_THRIFT_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_THRIFT_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SINK_THRIFT_ENDPOINT_NEGOTIATION_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_THRIFT_ENDPOINT_NEGOTIATION_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_THRIFT_ENDPOINT_NEGOTIATION_TYPE_DOC);
        conf.define(CAMEL_SINK_THRIFT_ENDPOINT_SSL_PARAMETERS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_THRIFT_ENDPOINT_SSL_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_THRIFT_ENDPOINT_SSL_PARAMETERS_DOC);
        conf.define(CAMEL_SINK_THRIFT_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_THRIFT_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_THRIFT_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_THRIFT_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_THRIFT_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_THRIFT_COMPONENT_AUTOWIRED_ENABLED_DOC);
        conf.define(CAMEL_SINK_THRIFT_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_THRIFT_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_THRIFT_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DOC);
        return conf;
    }
}