/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.quarkus.component.atomix.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import org.junit.jupiter.api.Test;

@QuarkusTest
class AtomixTest {

    @Test
    public void loadComponentAtomixMap() {
        /* A simple autogenerated test */
        RestAssured.get("/atomix/load/component/atomix-map")
                .then()
                .statusCode(200);
    }

    @Test
    public void loadComponentAtomixMessaging() {
        /* A simple autogenerated test */
        RestAssured.get("/atomix/load/component/atomix-messaging")
                .then()
                .statusCode(200);
    }

    @Test
    public void loadComponentAtomixMultimap() {
        /* A simple autogenerated test */
        RestAssured.get("/atomix/load/component/atomix-multimap")
                .then()
                .statusCode(200);
    }

    @Test
    public void loadComponentAtomixQueue() {
        /* A simple autogenerated test */
        RestAssured.get("/atomix/load/component/atomix-queue")
                .then()
                .statusCode(200);
    }

    @Test
    public void loadComponentAtomixSet() {
        /* A simple autogenerated test */
        RestAssured.get("/atomix/load/component/atomix-set")
                .then()
                .statusCode(200);
    }

    @Test
    public void loadComponentAtomixValue() {
        /* A simple autogenerated test */
        RestAssured.get("/atomix/load/component/atomix-value")
                .then()
                .statusCode(200);
    }

}
