/**
 * Copyright 2014 Red Hat, Inc.
 * 
 * Red Hat licenses this file to you under the Apache License, version
 * 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied.  See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 */
package org.fusesource.camel.component.sap;

import org.apache.camel.Category;
import org.apache.camel.Producer;
import org.apache.camel.spi.UriEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * An SAP endpoint providing outbound sRFC (Synchronous Remote Function Call) communication to SAP.
 * 
 * @author William Collins <punkhornsw@gmail.com>
 *
 */
@UriEndpoint(firstVersion = "3.20.1-redhat", scheme="sap-srfc-destination", syntax = "sap-srfc-destination:destination:rfc", producerOnly = true, title="SAP Synchronous RFC Destination", category = { Category.SAP })
public class SapSynchronousRfcDestinationEndpoint extends SapRfcDestinationEndpoint {
	
    private static final Logger LOG = LoggerFactory.getLogger(SapSynchronousRfcDestinationEndpoint.class);

	public SapSynchronousRfcDestinationEndpoint() {
	}

	public SapSynchronousRfcDestinationEndpoint(String endpointUri, SapSynchronousRfcDestinationComponent component) {
		super(endpointUri, component);
	}

	@Override
	public Producer createProducer() throws Exception {
		LOG.debug("Created producer for endpoint '" + getEndpointUri() + "'");
		return new SapSynchronousRfcProducer(this);
	}

}
