/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.springboot.maven;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

import java.util.HashMap;

/**
 * Utility class to read in the list of required productized artifacts.
 **/
 public class RequiredProductizedArtifactsReader {
    /**
     * Reads in the list of required productized camel-spring-boot artifacts from the file.
     *
     *  @return map of required productized camel-spring-boot artifacts
     **/
    public static HashMap<String, Boolean> getProductizedCSBArtifacts(File requiredFile) {
        HashMap<String, Boolean> map = new HashMap<>();

        try {
            FileReader fileReader = new FileReader(requiredFile);
            BufferedReader br = new BufferedReader(fileReader);

            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) {
                    continue;
                }
                
                if (!map.containsKey(line)) {
                    map.put(line, true);
                } else {
                    map.replace(line, true);
                }
            }
        } catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return map;
    }
}
