/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator.xml;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.decorator.ChainingDecorator;
import org.jboss.windup.metadata.decoration.Classification;
import org.jboss.windup.metadata.type.XmlMetadata;
import org.jboss.windup.metadata.util.LocationAwareContentHandler;

public class DTDPatternClassifyingDecorator
extends ChainingDecorator<XmlMetadata> {
    private String matchDescription;
    private Pattern namePattern;
    private Pattern publicIdPattern;
    private Pattern systemIdPattern;
    private Pattern baseURIPattern;

    public void setMatchDescription(String matchDescription) {
        this.matchDescription = matchDescription;
    }

    public void setNamePattern(Pattern namePattern) {
        this.namePattern = namePattern;
    }

    public void setPublicIdPattern(Pattern publicIdPattern) {
        this.publicIdPattern = publicIdPattern;
    }

    public void setSystemIdPattern(Pattern systemIdPattern) {
        this.systemIdPattern = systemIdPattern;
    }

    public void setBaseURIPattern(Pattern baseURIPattern) {
        this.baseURIPattern = baseURIPattern;
    }

    @Override
    public void processMeta(XmlMetadata file) {
        LocationAwareContentHandler.Doctype docType = (LocationAwareContentHandler.Doctype)file.getParsedDocument().getUserData("dt");
        if (docType != null && this.matchesAny(docType)) {
            Classification cr = new Classification();
            cr.setDescription(this.matchDescription);
            cr.setEffort(this.effort);
            file.getDecorations().add(cr);
            this.chainDecorators(file);
        }
    }

    protected boolean matchesAny(LocationAwareContentHandler.Doctype docType) {
        return this.processPattern(this.namePattern, docType.getName()) || this.processPattern(this.publicIdPattern, docType.getPublicId()) || this.processPattern(this.systemIdPattern, docType.getSystemId()) || this.processPattern(this.baseURIPattern, docType.getBaseURI());
    }

    protected boolean processPattern(Pattern pattern, String val) {
        if (pattern != null && StringUtils.isNotBlank((String)val)) {
            Matcher matcher = pattern.matcher(val);
            return matcher.find();
        }
        return false;
    }
}

